/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   codeswap.c
*
*  Codeswapping functions.
*
*-------------------------------------------------------------------------
*/

#include "typedef.h"
#include "const.h"
#include "rt_state.h"
#include "xrtstate.h"
#include "flcswap.h"
#include "nmp_plfm.h"
#include "nmp.h"
#ifndef ADSL_62
    #include "mei_iof.h"
#endif
#include "gdata.h"
#include "trailphaserr.h"
#include "mtkernel.h"
#include "rt_tones.h"
#include "codeswap.h"
#include "soc_codeswap.h"
#include "cmv.h"
#include "cmv_Data.h"
#include "trail.h"
#include "states.h"
#include "aux_regs.h"

/****************************************************************************
;  Prototype: void CheckForCodeSwapDone(void);
;
;  Description:
;       This function is called in RxForeGround() while a codeswap is in progress
;     This function simply checks for completion of last codeswap request and
;     updates statestrail.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;****************************************************************************/

void EnterFailStates(uint32);

#ifdef ADSL_62
int GetXdmaAccessStatus(void);
void ReleaseXdmaLock(void);
#endif

FlagT CheckForCodeSwapDone(void)
{

   if (guc_CodeSwapMsgReq == CODESWAP_REQUEST_SENT)
   {
      if (GetXdmaAccessStatus())
      {
         ReleaseXdmaLock();
         return(TRUE);
      }
      else
      {
         return(FALSE);
      }
   }

   return(FALSE);
}

/****************************************************************************
;  Prototype: void CheckForCodeSwap(void);
;
;  Description:
;       This function is called in RxForeGround().
;     This function sends a codeswap request to the host and then checks
;       for and processes codeswapping messages until codeswap is completed.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;****************************************************************************/
void CheckForCodeSwap(void)
{
   // All codeswaps done, return
   if (gs_CodeSwapStatus == CODESWAP_ALL_DONE)
      return;

   // Entered showtime and last codeswap (SHOWBG2)  has been started. SHOWBG2 is
   // overlayed with R_NOSHOW which contains the codeswap state m/c. Hence,
   // check of SHOWBG2 codeswap completion is done differently.
   // To further save program memory, we could just ignore checking for completion
   // of SHOWBG2 done and ass-u-me its OK
   if (gs_CodeSwapSection == CSPAGE_BIS_SHOWBG2 && /* Last codeswap page SHOWBG2 */
      gs_CodeSwapStatus == CODESWAP_IN_PROGRESS)   /* is in progress */
   {
      // check the status of the codeswap request
      if (CheckForCodeSwapDone())   /* Check for codeswap done */
      {
         gft_RestoreShowtimeBGState = 1; /* ok to run the showtime bg routines */

         //assure showtime event log always starts @ top of states trail
         if (gt_debugTrailTriggerControl.s_logType & DEBUG_LOG_SHOW_EVENT)
         {
            gt_debugTrailCollectControl.s_debugTrailLen = 0;
         }
            #ifdef HERCULES_ADSL_CPE
            DebugTrail(3, DEBUG_LOG_STATESTRAIL, 0xBBBB, gs_CodeSwapSection, (int16)gl_RxSymbolCount);
         #endif
         /* Indicates all codeswaps are done, gs_CodeSwapSection indicates last page codeswaped */
         gs_CodeSwapStatus = CODESWAP_ALL_DONE;
      }
   }
   else
   {
      CheckForCodeSwapTrain();
   }
}

