/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   codeswap_nost.c
*
*  Codeswapping functions that are not used in showtime.
*
*-------------------------------------------------------------------------
*/

#include "typedef.h"
#include "const.h"
#include "rt_state.h"
#ifndef ADSL_62
    #include "mei_iof.h"
#endif
#include "gdata.h"
#include "codeswap.h"
#include "soc_codeswap.h"
#include "trail.h"
#include "pll.h"
#include "aux_regs.h"

#ifdef DANUBE
    #include "dataswap.h"
#endif


/****************************************************************************
;  Prototype: void SendCodeSwapRequest(void)
;
;  Description:
;       Sends a codeswap request to host.
;
;  Arguments:
;
;  Return Value:
;     none
;
;
;****************************************************************************/
#ifdef DANUBE
int32 gla_CS_Header_LocalBuf[8];
int32 gl_AlignedOffset;
#endif

#ifdef ADSL_62
    extern PortModeControl_t gt_PortModeControl;
#endif

extern FlagT LockXdmaBus(void);
extern void SetupReadXdmaBlock(int32 l_SourceStart, int32 l_DestStart, int32 l_NumOfBytes);
extern void TrailPhaseError(void);
void SendCodeSwapRequest(void) {

    int32 l_SourceAddress, l_PageSize, l_Destination;
    int32 l_PageNum;

    l_PageNum = gs_CodeSwapSection;
    l_SourceAddress = gt_PortModeControl.l_SRAMImageOffset;

    switch(guc_CodeSwapMsgReq)
    {
        case SEND_CODESWAP_REQUEST:        // fetching codeswap table entry for the requested page
         // Workaround a XDMA problem where the returned data maybe corrupted if the
         // starting address is at offset 4 and the size crosses a 32-byte boundary.
         //
            // DMA the page descriptor from SDRAM on 8-byte address boundary to a temporary buffer.
            // When done, copy the 24-byte header to its final buffer

         // Skip the first 12 bytes (3 longwords) in the beginning of the image (image size, checksum,
         // number of swap pages) to get to the start of page descriptor.
         // The size of each page descriptor is 24 bytes.
            //
            // Also note that the first page header was a dummy entry and only used for DANUBE
            if (LockXdmaBus())
            {
                l_SourceAddress += l_PageNum*24 + 12;

                SetupReadXdmaBlock(l_SourceAddress, (int32)&gt_CS_HeaderEntry, sizeof(CS_HeaderEntry_t));

                guc_CodeSwapMsgReq = SEND_CODESWAP_REQUEST_2;
            }

            break;

        case SEND_CODESWAP_REQUEST_2:        // wait for codeswap table entry for the requested page
            if (GetXdmaAccessStatus())
            {
                // XDMA is done
                guc_CodeSwapMsgReq = SEND_CODESWAP_REQUEST_3;
            }
            break;

        case SEND_CODESWAP_REQUEST_3:        // wait for codeswap table entry for the requested page
            guc_CodeSwapMsgReq = CODESWAP_REQUEST_SENT;

            if ((l_PageSize = gt_CS_HeaderEntry.l_PmSize) > 0)
            {
                l_SourceAddress += gt_CS_HeaderEntry.l_PmOffset;
                l_Destination =  gt_CS_HeaderEntry.l_PmDestination;
            }
            else if ((l_PageSize = gt_CS_HeaderEntry.l_DmSize) > 0)
            {
                l_SourceAddress += gt_CS_HeaderEntry.l_DmOffset;
                l_Destination =  gt_CS_HeaderEntry.l_DmDestination;
            }
            else
            {
                return;
            }

            // setting XDMA GAP register
            // Danube value; when applied will be multiplied by 2 because
            // VR9 instruction cycle is twice as short.
            if (guc_XdmaCodeSwapSpeed == XDMA_SLOW_CODESWAP)
            {
                SetDspReg(ARC_XDMA_GAP, XDMA_GAP_SLOW);
            }
            else
            {
                SetDspReg(ARC_XDMA_GAP, XDMA_GAP_FAST);
                // reset this GAP setting
                guc_XdmaCodeSwapSpeed = XDMA_SLOW_CODESWAP;
            }

            SetupReadXdmaBlock(l_SourceAddress, l_Destination, l_PageSize << 2);
            break;
    }
}

/****************************************************************************
;  Prototype: void SendFastReadRequest(void)
;
;  Description:
;
;     Requests a DMA transfer from Socrates to the ME. Socrates supplies the
;  address and length of its data, as well as an offset into the ME's destination buffer.
;
;  Arguments:
;
;  Return Value:
;     none
;
;
;****************************************************************************/
#if !defined(HERCULES_ADSL_CPE) || defined(ADSL_62)
void SendFastReadRequest(void) {
#if 0 // This Fast Read functions is being referenced in the code but we
      // dont have fast read functionality on n/w processor yet).
      // Hence we #ifdef the contents of function to get some Resident memory

   uint32 ul_data;

   // Set the destination offset (upper 16-bits)
   // and the transfer length (lower 16-bits)

   ul_data = gs_FastReadlength | (gs_FastReadDestOffset << 16);
   MEI_RegisterWrite(OMB_GP_8_ADDR, ul_data);

   // Set the source address (32-bits)

   MEI_RegisterWrite(OMB_GP_9_ADDR, gl_FastReadAddress);

   // set the MSG_TYPE bit in the OMB_CODESWAP_MESSAGE register to 1
   // to indicate that the ARC->MEI message is a codeswap message

   ul_data = OMB_FASTREAD_MESSAGE_MSG_TYPE_MASK;

   *(int32 *)OMB_CODESWAP_MESSAGE_ADDR = ul_data;

   // notify MEI of codeswap request by assertin the ARC->MEI mailbox message interrupt
   ul_data = (uint32) MEI_INT_AC_ARC_MSGAV_MASK;
   MEI_RegisterWrite(MEI_INT_AC_ADDR, ul_data);
#endif
}
#endif   // #if !defined(HERCULES_ADSL_CPE) || defined(ADSL_62)



/****************************************************************************
;  Prototype: void FastDataRequest(int32 l_addr, int16 s_length, int16 s_dest_offset)
;
;  Description:
;
;     This function is called at various points within the code (training
;  or showtime) in order to request a Fast Read from the ME.  Typical
;  applications include upload of GHS data, SNR tables, messages, etc.
;
;  Arguments:
;
;     l_addr = source address, i.e. buffer within Socrates
;     s_length = length in doublewords
;     s_dest_offset = address (and/or buffer) within ME
;
;  Return Value:
;     none
;
;
;****************************************************************************/

#if 0 // These Fast Read functions are not being referenced from anywhere in the code.
      // Hence we #ifdef them out completely
int16 WaitForFastRead(void)
{
   /* Wait for the Fast Read to complete. */
   /* Eventually this flag will be cleared by the ME. */
   /* Currently this flag is cleared in the ProcessTxMailbox function. */

   return((*gpuc_FastReadMsgReq));

}

void WaitInBgForFastRead(void)
{

   int32 l_FastReadStart;

   /* Wait for the Fast Read to complete. */
   /* Eventually this flag will be cleared by the ME. */
   /* Currently this flag is cleared in the ProcessTxMailbox function. */

   l_FastReadStart = gl_RxSymbolCount;
   while (WaitForFastRead() !=0){
      if ((gl_RxSymbolCount - l_FastReadStart) >= FAST_READ_TIME_OUT){
         (*gpuc_FastReadMsgReq) = 0;
         gs_FastReadTimeOutCnt++;
         break;
      }
   }

}

void FastReadRequest(int32 l_addr, int16 s_length, int16 s_dest_offset, uint8* puc_flag) {

   int16 s_enabled;
   int16 i;

   /* set global variables used by SendFastReadRequest() function */
   gl_FastReadAddress = l_addr;
   gs_FastReadlength = s_length;
   gs_FastReadDestOffset = s_dest_offset;

   /* Check table to see if Fast Read is enabled. */

   s_enabled = 0;
   for (i=0; i<FAST_READ_LIST_LENGTH; i++)
   {
      if (puc_flag == gpuca_FastReadAddressList[i]){
         s_enabled=1;
      }
   }

   if (s_enabled == 0)
   {
      /* if Fast Read is not enabled */
      /*   then clear flag and return */

      (*puc_flag) = 0;
   }
   else
   {
      /* else Fast Read is enabled */

      /* set global pointer variable to specific flag */
      gpuc_FastReadMsgReq = puc_flag;


      /* set variable to trigger request from ME */
      (*gpuc_FastReadMsgReq)=1;

   }

}
#endif

/****************************************************************************
;  Prototype: int16 HandleCodeSwap(void);
;
;  Description:s
;       Handles a codeswap request from start to finish.  Send the codeswap
;     request to the MEI, checks the MEI's response to the request, and
;     informs the task layer code of the status of the codeswap request.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;
;****************************************************************************/
int16 gs_CodeSwapDelay = 0 ;  // debug: delay the message to the ME by this number of symbols, to test CS latency
int16 gs_PreCodeSwapCnt = 0 ;
int16 gs_CodeSwapCnt = 0;

void HandleCodeSwap(void)
{
   /* call ProcessTxMailbox() function here in case interrupts and/or MP is         */
   /* not yet enabled.  This call is redundant once MP messages are being processed.   */
   ProcessTxMailbox();

   switch (gs_CodeSwapStatus) {

      /* the CODESWAP_START state may be entered based on the Rx State/SymbolCount trigger,  */
      /* or explicitly.  In either case, the guc_CodeSwapMsgReq is set to request a Codeswap */
      /* page and is monitored in the ProcessTxMailbox function, which is used to            */
      /* multiplex Codeswap, MP messages, and FastDataRead requests.                   */

      case CODESWAP_START:

         if (gs_PreCodeSwapCnt == 0) {
            DebugTrail(3, DEBUG_LOG_STATESTRAIL, 0xAAAA, gs_CodeSwapSection, (int16)gl_RxSymbolCount);
         }

         if (gs_PreCodeSwapCnt++ == gs_CodeSwapDelay)  {
            // send the codeswap request
                guc_CodeSwapMsgReq = SEND_CODESWAP_REQUEST;
            gs_PreCodeSwapCnt = 0 ;
            gs_CodeSwapStatus = CODESWAP_IN_PROGRESS;
         }

         break;

      /* The CODESWAP_IN_PROGRESS state first waits for the Codeswap request to be sent to the  */
      /* ME, and then monitors the codeswap complete signal.                              */
      case CODESWAP_IN_PROGRESS:

         // check the status of the codeswap request
         if (CheckForCodeSwapDone())   /* Check for codeswap done */
         {
            gs_CodeSwapStatus = CODESWAP_COMPLETE;
                #ifdef HERCULES_ADSL_CPE
                DebugTrail(3, DEBUG_LOG_STATESTRAIL, 0xBBBB, gs_CodeSwapSection, (int16)gl_RxSymbolCount);
                #endif
         }
         break;

   }
}

/****************************************************************************
;  Prototype: void CheckForCodeSwapTrain(void);
;
;  Description:
;       This function is called in RxForeGround() before processing of last cswap page(SHOWBG2)
;     This function sends a codeswap request to the host and then checks
;       for and processes codeswapping messages until codeswap is completed.
;
;  Arguments:
;     none
;
;  Return Value:
;     none
;
;****************************************************************************/
void CheckForCodeSwapTrain()
{
   if(gft_EnablePLL){
      TrailPhaseError(); //Log the phase error from PLL
   }

      /*  codeswap state machine control */
   switch (gs_CodeSwapStatus) {

      /* wait for codeswap trigger based on RxState and Symbol Count */

      case CODESWAP_IDLE:
            if ((gs_RxState       == gsa_CodeSwapStartState[  gs_CodeSwapSection]) &&
                (gs_TxState       >= gsa_CodeSwapTxStartState[gs_CodeSwapSection]) &&
                (gl_RxSymbolCount >= gla_CodeSwapStartSymbol[ gs_CodeSwapSection]))
            {
                gs_CodeSwapStatus = CODESWAP_START;
            }
            else
            {
                // Make sure that both Rx and Tx have transitted to showtime before we codeswap
                // the SHOWBG1 and SHOWBG2 pages. Also ensure that we are done using R_NOSHOW page
                // Enables us to overlay portions of training and showtime transition code
                if (     (    (gs_CodeSwapSection == CSPAGE_BIS_SHOWBG2)
                           || (gs_CodeSwapSection == CSPAGE_BIS_SHOWBG1)
                           || (gs_CodeSwapSection == CSPAGE_BIS_SHOWBG1DMT))
                      && gs_RxState == R_C_SHOWTIME_RX
                      && gs_TxState == R_SHOWTIME_TX
                      && guc_BkgdTaskState == BKGDTASK_DONE)
                {  /* we need to swap right away */
                    gs_CodeSwapStatus = CODESWAP_START;
                }
            }
            break;

      /* the CODESWAP_START state may be entered based on the Rx State/SymbolCount trigger,  */
      /* or explicitly.  In either case, the guc_CodeSwapMsgReq is set to request a Codeswap */
      /* page and is monitored in the ProcessTxMailbox function, which is used to            */
      /* multiplex Codeswap, MP messages, and FastDataRead requests.                   */


      case CODESWAP_START:
#if defined(XDMA_DATA_SWAP)
            if (gt_DataSwap.c_State == DATASWAP_IN_PROGRESS)
            {
                break;
            }
#endif
      case CODESWAP_IN_PROGRESS:
         HandleCodeSwap();
         gs_CodeSwapCnt++;
         break;

      case CODESWAP_COMPLETE:

            gs_CodeSwapCnt = 0;

            gs_CodeSwapStatus = CODESWAP_IDLE;

            //Update codeswap section to be swapped in next
            gs_CodeSwapSection = gsa_CodeSwapNextSection[gs_CodeSwapSection];

#if defined(DANUBE) || defined(ADSL_62)
            //Few codeswaps are triggered right away
            if (gs_CodeSwapSection == CSPAGE_BIS_DISC1 ||
                gs_CodeSwapSection == CSPAGE_BIS_XCVR0)
            {
                gs_CodeSwapStatus = CODESWAP_START;
         }
#endif

         break;
   }
}
