/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   codeswap_sinit.c
*
*  Codeswapping arrays initialization.
*
*-------------------------------------------------------------------------
*/
//****************************************************************************
//codeswap_sinit.c
//
// History
//
// 25/04/2012 Kannan:
//          1. ADSL DS ReTx feature implementation
//             Grep for "XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx"
//*****************************************************************************************

#include "typedef.h"
#include "const.h"
#include "rt_state.h"
#include "gdata.h"
#include "codeswap.h"
#include "soc_codeswap.h"
#include "data_alloc.h"

#include "aux_regs.h"

/* Codeswap global variables */
int16 gs_CodeSwapCount;
int16 gs_NumCodeSwap;
int16 gs_CodeSwapStatus;
int16 gs_CodeSwapSection;
int16 gs_CodeSwapEndState;
int32 gl_CodeSwapEndSymbol;

int16 gs_CheckState;
int16 gs_checkRxState;

// Below arrays unused in showtime, hence defined in DeIllv2.
// HOWEVER, protect code (for ex codeswap_nost.c) so that
// we do not acces these arrays when Rx is in showtime
DATA_MAP_deILV2_BIS
int16 gsa_CodeSwapStartState[NO_OF_SWAPPAGES];
int16 gsa_CodeSwapTxStartState[NO_OF_SWAPPAGES];
int32 gla_CodeSwapStartSymbol[NO_OF_SWAPPAGES];
DATA_MAP_END
int16 gsa_CodeSwapNextSection[NO_OF_SWAPPAGES];

/* Fast Read Variables */
int16 gs_FastReadlength;
int16 gs_FastReadDestOffset;
int32 gl_FastReadAddress;

/* the following variables are used to coordinate the Socrates-ME interrupts. */
/* the flags guc_MPMsgReq, CodeSwapMsgReq, and FastReadMsgReq are set to request */
/* an MP transmission, Code Swap, and Fast Read, respectively.  The ProcessTxMailbox */
/* function monitors these flags and coordinates the interrupt signals to the ME. */

uint8 guc_MPMsgReq;
uint8 guc_CodeSwapMsgReq;
uint8 guc_FastReadMsgReq;
uint8*   gpuc_FastReadMsgReq;

CS_HeaderEntry_t gt_CS_HeaderEntry;
uint8   guc_XdmaCodeSwapSpeed;       // either XDMA_SLOW_CODESWAP or XDMA_FAST_CODESWAP

/* the time out cnt is incremented each time the Fast Read times out. */
/* (should remain 0). */

int16 gs_FastReadTimeOutCnt;

/* A flag is associated with each FastReadRequest.  The FastReadAddressList      */
/* identifies and enables Fast Reads by the address of this flag. if       */
/* the address of the flag is contained within the FastReadAddressList, then  */
/* the Fast Read is enabled.                                      */

// Below arrays are unused currently since we do not implement fast read.
// We have a data memory crunch in showtime. Hence these are moved to DeIllv.
DATA_MAP_deILV2_BIS
uint8*   gpuca_FastReadAddressList[FAST_READ_LIST_LENGTH];
uint8 guca_FastReadIDList[FAST_READ_LIST_LENGTH];
DATA_MAP_END


/****************************************************************************
;  Prototype: void InitCodeSwap(void);
;
;  Description:
;       Sets up various global variables for codeswapping.
;
;  Arguments:
;       none
;
;  Return Value:
;     none
;
;****************************************************************************/
void InitCodeSwap(void) {

   int16 i;

   for (i=0; i<NO_OF_SWAPPAGES; i++)
      gsa_CodeSwapTxStartState[i] = -1;

   //BIS codeswap page initialization
   gsa_CodeSwapStartState[CSPAGE_BIS_R_NOGHS]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_R_NOGHS] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_R_NOGHS] = -1;  //Will be initialized @ run time depending on mode

   gsa_CodeSwapStartState[CSPAGE_BIS_XCVR0]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_XCVR0] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_XCVR0] = CSPAGE_BULK_O1;

   gsa_CodeSwapStartState[CSPAGE_BIS_DISC1]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_DISC1] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_DISC1] = CSPAGE_BULK_O1;

   //codeswap DISC2 when both Rx and Tx reach the specified states
   gsa_CodeSwapStartState[CSPAGE_BIS_DISC2]  = R_C_QUIET1_RX_BIS;
   gsa_CodeSwapTxStartState[CSPAGE_BIS_DISC2]  = R_QUIET1_TX_BIS;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_DISC2] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_DISC2] = CSPAGE_BIS_DISC3;

   gsa_CodeSwapStartState[CSPAGE_BIS_DISC3]  = R_C_COMB2_RX_BIS;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_DISC3] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_DISC3] = CSPAGE_BIS_XCVR1;

   gsa_CodeSwapStartState[CSPAGE_BIS_DMT_RAM]  = R_C_PILOT1_RX;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_DMT_RAM] = 1;
   gsa_CodeSwapNextSection[CSPAGE_BIS_DMT_RAM] = CSPAGE_BIS_XCVR1;

   // The following need to change in the state machine code for DMT
#if defined(DANUBE) || defined(ADSL_62)
   gsa_CodeSwapStartState[CSPAGE_BIS_XCVR1]  = R_C_QUIET4_RX_BIS;
#else
   gsa_CodeSwapStartState[CSPAGE_BIS_XCVR1]  = R_C_QUIET3_RX_BIS;
   gsa_CodeSwapTxStartState[CSPAGE_BIS_XCVR1]  = R_COMB2_TX_BIS;
#endif
   gla_CodeSwapStartSymbol[CSPAGE_BIS_XCVR1] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_XCVR1] = CSPAGE_BIS_XCVR1EXT;

   gsa_CodeSwapStartState[CSPAGE_BIS_XCVR1EXT]  = R_C_REVERB1_RX_BIS;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_XCVR1EXT] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_XCVR1EXT] = CSPAGE_BIS_XCVR2;

   /* Inititate code swap in the Task layer */
   gsa_CodeSwapStartState[CSPAGE_BIS_XCVR2]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_XCVR2] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_XCVR2] = CSPAGE_BIS_ANAL;

   gsa_CodeSwapStartState[CSPAGE_BIS_ANAL]  = R_C_REVERB3_RX_BIS;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_ANAL] = 0;   // clc debug
   gsa_CodeSwapNextSection[CSPAGE_BIS_ANAL] = CSPAGE_BIS_MTDQ;

   gsa_CodeSwapStartState[CSPAGE_BIS_MTDQ]  = R_C_TREF2_RX_BIS; //could it possible be R_C_QUIET5_RX_BIS?
#if defined(DANUBE) || defined(ADSL_62)
   gla_CodeSwapStartSymbol[CSPAGE_BIS_MTDQ] = 32;              // delay a bit for diag mode test
#else
   gla_CodeSwapStartSymbol[CSPAGE_BIS_MTDQ] = 0;
#endif
   gsa_CodeSwapNextSection[CSPAGE_BIS_MTDQ] = CSPAGE_BIS_TDQTEST;

   //Can be done automatically when Rx enters medley, given ADSL2/+ standards assure
   //the Tx is in Medley when Rx Enters Medley for ATU-R. Due to a error in the
   //Diag Mode standard this is not so. Hence, to get around that we manually
   //bring in the page when Tx and Rx are both in medley
   gsa_CodeSwapStartState[CSPAGE_BIS_TDQTEST]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_TDQTEST] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_TDQTEST] = CSPAGE_BIS_BTLD;

   // we don't have the corresponding start state macro for this page, have to initial it in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_BTLD]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_BTLD] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_BTLD] = CSPAGE_BIS_RXINIT;

   // we don't have the corresponding start state macro for this page, have to initial it in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_RXINIT]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_RXINIT] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_RXINIT] = CSPAGE_BIS_EXCH1;

   // (1)EXCH1 will be brought in during Medley when RXINIT is in use over BTLD page
   // (2)EXCH2 and EXCH3 will be brought in over RXINIT page after it is done during Medley
   // (2)We will first load SHOW1 page over EXCH1 page in order to make sure that we have showtime code ready
   // for the rx showtime state whose arrival is not under CPEs control.
   // (3)The SHOW2 page overlaps with the TXINIT page and hence we need to wait until decode cparams before
   // we can consider swapping in SHOW2
   // (4)To summarize, we will swap as follows:
   //    EXCH1, EXCH2 and EXCH3 in sequential order in RCMedleyRxF_RxInit_BIS
   //    SHOW1 in RREVERB6 given formation of RParams is done so that we can get rid of EXCH1
   //    TXINIT in RREVERB7 given RxState is RCReverb7 and DecodeCParams is done so that we can get rid of EXCH2
   //    SHOW2 triggered by completion of TXINIT usage and is followed by RREVERB7 transition to R-SHOWTIME
   //    SHOWBG triggered by completion of SHOW2 codeswap and can take as long as it wants
   // (5)To summarize the time available for codeswaps:
   //    SHOW1 has atleast (max_length{RREVERB6} == 2000) symbols.
   //    TXINIT(inclu ShowinitTx,TxDataPump)+SHOW2 has atleast (max_length{RREVERB7} == 2048) symbols
   // (6)To summarize the structuring of file for codeswaps:
   //    SHOW1 needs to have all necessary Rx specific functions
   //    SHOW2 needs to have all showtime specific files - SHOW1 - SHOWBG (overlaps R_NOSHOW)

   // we don't have the corresponding start state macro for this page, we have to initial it in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_EXCH1]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_EXCH1] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_EXCH1] = CSPAGE_BIS_EXCH2;

   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx   (START)
   //Will be done in the task layer, before doing data swap, save
   //the contecnt of "gs_CodeSwapSection" and restore back once after the codeswap page of this is
   //done to avoid break in the linked list.
   gsa_CodeSwapStartState[CSPAGE_BIS_ZEP_RX_RETX_LP1_UCODE]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_ZEP_RX_RETX_LP1_UCODE] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_ZEP_RX_RETX_LP1_UCODE] = -1;
   //XDSLRTFW-443 Feature_DS_BisPlus_All_ReTx  (END)

   // we don't have the corresponding start state macro for this page, we have to initial it in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_EXCH2]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_EXCH2] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_EXCH2] = CSPAGE_BIS_EXCH3;

   // we don't have the corresponding start state macro for this page, we have to initial it in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_EXCH3]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_EXCH3] = -1;
   gsa_CodeSwapNextSection[CSPAGE_BIS_EXCH3] = CSPAGE_BIS_SHOW1;

   // we don't have the corresponding start state macro for this page, we have to initial it in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_SHOW1]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHOW1] = -1;
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHOW1] = CSPAGE_BIS_TXINIT;

   // we don't have the corresponding start state macro for this page, we have to initial it in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_TXINIT]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_TXINIT] = -1;
   gsa_CodeSwapNextSection[CSPAGE_BIS_TXINIT] = CSPAGE_BIS_SHOW2;

   // ShowRX1 codeswap is specify in task layer
   gsa_CodeSwapStartState[CSPAGE_BIS_SHOW2]  = -1;    //Unused
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHOW2] = -1;    //Unused
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHOW2] = CSPAGE_BIS_SHOWBG1;

   gsa_CodeSwapStartState[CSPAGE_BIS_SHOWBG1]  = -1;  //Unused
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHOWBG1] = 0;   //Unused
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHOWBG1] = CSPAGE_BIS_SHOWBG2;

#if defined(DANUBE) || defined(ADSL_62)
   gsa_CodeSwapStartState[CSPAGE_BIS_SHOWBG2]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHOWBG2] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHOWBG2] = -1;
#else
   gsa_CodeSwapStartState[CSPAGE_BIS_SHOWBG2]  = -1;  //Unused
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHOWBG2] = 0;   //Unused
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHOWBG2] = CSPAGE_BIS_SHWBG3A;
#endif

   /* DMT only swaps */
   gsa_CodeSwapStartState[CSPAGE_BIS_ANL1DMT]  = R_C_REVERB3_RX;
   gsa_CodeSwapTxStartState[CSPAGE_BIS_ANL1DMT]  = R_REVERB2_TX;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_ANL1DMT] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_ANL1DMT] = CSPAGE_BIS_MTDQ;

   gsa_CodeSwapStartState[CSPAGE_BIS_BTLDDMT]  = -1;              // When MultiTDQ is done
   gla_CodeSwapStartSymbol[CSPAGE_BIS_BTLDDMT] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_BTLDDMT] = CSPAGE_BIS_BTLDDMT1;
   gsa_CodeSwapStartState[CSPAGE_BIS_BTLDDMT1]  = R_C_REVERB_RA_RX;  // When BTLDDMT is in
   gla_CodeSwapStartSymbol[CSPAGE_BIS_BTLDDMT1] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_BTLDDMT1] = CSPAGE_BIS_RXINIT;

   gsa_CodeSwapStartState[CSPAGE_BIS_EXCHDMT]  = -1;              // When TxInit is in
   gla_CodeSwapStartSymbol[CSPAGE_BIS_EXCHDMT] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_EXCHDMT] = CSPAGE_BIS_SHT1DMT;

   gsa_CodeSwapStartState[CSPAGE_BIS_SHT1DMT]  = -1;              // When ExchDMT is in
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHT1DMT] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHT1DMT] = CSPAGE_BIS_SHT2DMT;

#if defined(DANUBE) || defined(ADSL_62)
   gsa_CodeSwapStartState[CSPAGE_BIS_SHT2DMT]  = R_C_SHOWTIME_RX;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHT2DMT] = 4;
#else
   gsa_CodeSwapStartState[CSPAGE_BIS_SHT2DMT]  = -1;  //Unused
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHT2DMT] = 0;   //Unused
#endif
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHT2DMT] = CSPAGE_BIS_SHOWBG1DMT;


   gsa_CodeSwapStartState[CSPAGE_BIS_SHOWBG1DMT]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BIS_SHOWBG1DMT] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BIS_SHOWBG1DMT] = CSPAGE_BIS_SHOWBG2;

   gsa_CodeSwapStartState[CSPAGE_BULK_O1]  = -1;
   gla_CodeSwapStartSymbol[CSPAGE_BULK_O1] = 0;
   gsa_CodeSwapNextSection[CSPAGE_BULK_O1] = CSPAGE_BIS_DISC2;    //default behavior for BIS


   /* Initialize Fast Read variables */

   gs_FastReadlength = 0;
   gs_FastReadDestOffset = 0;
   gl_FastReadAddress = 0;

   guc_CodeSwapMsgReq= CODESWAP_REQUEST_SENT;
   guc_FastReadMsgReq=0;


   /* clear the list of Fast Read addresses.                */
   /* this table defines which Fast Read flags are enabled        */
   /* and provides and associated ID that defines the Fast Read   */
   /* parameters, e.g. source address, destination, etc.       */

   for (i=0; i<FAST_READ_LIST_LENGTH; i++)
   {
      gpuca_FastReadAddressList[i]=0;
      guca_FastReadIDList[i]=0;
   }

   gs_FastReadTimeOutCnt=0;

   /* for now, we will use only one address, namely guc_FastReadMsgFlag */
   /* Eventually, this table should be programmed by the ME.            */

   gpuca_FastReadAddressList[0] = &guc_FastReadMsgReq;

#ifdef DANUBE
    {
        // configure XDMA for codeswapping
        _sr(0x0, ARC_XDMA_CTRL);
        _sr(0x200, ARC_XDMA_GAP);
        guc_XdmaCodeSwapSpeed = XDMA_GAP_SLOW;
    }
#endif
}



