/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: decxcorr.c
*
*   This file contains the DECXcorr function used in DEC training.
*
*******************************************************************************/

#include "typedef.h"

/*******************************************************************************
*
*   Prototype: void DECXcorr(int16 *psa_TxDataBuf, int16 *psa_RxInBuf,
*       int32 *pl_Xcorr, int16 s_cnt, int16 s_pitch, int16 s_RS)
*
*   Description:
*       This function is called by DECTrain2b to help compute the inner loop
*       of the circular cross correlation between the received sequence
*       (DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame) and a "decorrelating
*       sequence" (length = DEC_TRAINING_PERIOD*TxFftLength).
*
*   Arguments:
*       psa_TxDataBuf: (I) pointer to the decorrelating sequence
*       psa_RxInBuf: (I) pointer to the received sequence
*       pl_Xcorr: (I/O) pointer to the cross-correlation
*       s_cnt: (I) number of times to execute the loop
*       s_pitch: (I) ratio of sampling rate of received sequence to
*           the sampling rate of the decorrelating sequence
*       s_RS: (I) amount to scale down accumulator
*
*   Return Value:
*
*   Global Variables:
*
*******************************************************************************/

void DECXcorr(int16 *psa_TxDataBuf, int16 *psa_RxInBuf, int32 *pl_Xcorr, int16 s_cnt, int16 s_pitch, int16 s_RS)
{
   int16 n;
   int32 l_Acc;

   for (n=0;n<s_cnt;n++) {
      l_Acc = ((int32) *psa_RxInBuf) * (*psa_TxDataBuf);
      l_Acc >>= s_RS; /* skip if 40 bit acc available */
      *pl_Xcorr += l_Acc;
      psa_RxInBuf += s_pitch;
      psa_TxDataBuf++;
   }
}
