/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*******************************************************************************
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413
*   Phone: (781) 276 - 4000
*   Fax:   (781) 276 - 4001
*
*   filename: dxc_init.c
*
*   This file contains the DECXcorr function used in DEC training.
*
*******************************************************************************/
#include "typedef.h"
#include "xy_iof.h"
#include "dma_iof.h"
#include <string.h>
/*******************************************************************************
*
*   Prototype: FlagT InitDECXcorr(int16 *psa_TxDataBuf, int16 *psa_RxInBuf,
*                      int16 s_TxBufLen, int16 s_RxBufLen, int16 s_pitch);
*
*   Description:
*       This function is called by DECTrain2b to prepare for the computation
*       of the circular cross correlation between the received sequence
*       (DEC_TRAINING_PERIOD*gs_RxSamplesPerFrame) and a "decorrelating
*       sequence" (length = DEC_TRAINING_PERIOD*TxFftLength).
*
*   Arguments:
*       psa_TxDataBuf: (I) pointer to the decorrelating sequence
*       psa_RxInBuf:   (I) pointer to the received sequence
*       s_TxBufLen:    (I) length of the decorrelating sequence (must be even)
*       s_RxBufLen:    (I) length of the received sequence (must be even)
*       s_pitch:       (I) ratio of sampling rate of received sequence to
*           the sampling rate of the decorrelating sequence
*
*   Return Value:
*       TRUE:  successful setup
*       FALSE: setup did not complete
*
*   Global Variables:
*
*******************************************************************************/
void SetupXYMemoryForDECXcorr(int32 psa_TxBufXY, int16 s_TxBufLen, int32 psa_RxBufXY, int16 s_RxBufLen, int16 s_pitch);
FlagT InitDECXcorr(int16 *psa_TxDataBuf, int16 *psa_RxInBuf, int16 s_TxBufLen, int16 s_RxBufLen, int16 s_pitch) {
   int32 psa_TxDataBufXY, psa_RxInBufXY;

   // check Rx address
   if(CheckXYAddrRange((int32 *)(void *)psa_RxInBuf, XY_BUF_8X0) == FAIL)
      return FALSE;
   psa_RxInBufXY = XYAddrDecode((int32 *)(void *)psa_RxInBuf, ADDR_MODE_16);

   /**********************************************************************************
   * check Tx address - the Tx decorrelation buffer must either be stored in        *
   * system memory or in Y memory in the free buffer.  If the buffer is located in  *
   * system memory then we must copy it the free buffer in Y memory.  If the buffer *
   * is not either of the 2 memories, then we have an invalid address.              *
   **********************************************************************************/
   if(2*s_TxBufLen > XY_BUF_Y_DEC_TMP_BUF_SIZE)
      return FALSE;

   if(CheckXYAddrRange((int32 *)(void *)psa_TxDataBuf, XY_MEM) == FAIL) {
      // copy it into XY memory above the input signal
#ifndef ADSL_62
      int16  *psa_TxXY = (int16 *) (Y_BASE_ADDR_IN_BYTES + (XY_BUF_Y_DEC_TMP_START << LOG2_BYTES_PER_WORD));
#else
        int16  *psa_TxXY = (int16 *) (Y_BASE_ADDR_IN_BYTES);
#endif
      memcpy(psa_TxXY , psa_TxDataBuf , sizeof(int16)*s_TxBufLen);
      psa_TxDataBuf = psa_TxXY;
   }
#ifndef ADSL_62
   else if(CheckXYAddrRange((int32 *) psa_TxDataBuf, XY_BUF_Y_TMP_DEC) == FAIL)
#else
    else if(CheckXYAddrRange((int32 *)(void *)psa_TxDataBuf, XY_BUF_8X1) == FAIL)
#endif
   return FALSE;

   // the Tx decorrelation buffer uses modulo addressing, so
   // we must check that the buffer starts on a valid address
   psa_TxDataBufXY = XYAddrDecode((int32 *)(void *)psa_TxDataBuf, ADDR_MODE_16);
   if(s_TxBufLen & 1) {
      if(CheckValidModuloAddr(psa_TxDataBufXY, 2*s_TxBufLen) == FAIL)
         return FALSE;
   }
   else {
      if(CheckValidModuloAddr(psa_TxDataBufXY, s_TxBufLen) == FAIL)
         return FALSE;
   }

   /* format the Rx and Tx buffers and setup XY address pointers */
   SetupXYMemoryForDECXcorr(psa_TxDataBufXY, s_TxBufLen, psa_RxInBufXY,
      s_RxBufLen, s_pitch);
   return TRUE;
}
