/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        fdqmult.c
*
* DESCRIPTION:     Function for computing product of two scalar arrays
*
**************************************************************************/

#include "xy_iof.h"
#include "gdata.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : FdqMultiply
 *
 *  Description:
 *    This routine multiplies the fdq coeffiecients with a scalar value and
 *    normalizes them if necessary using the exponents.
 *
 * Memory Allocation:
 *    The fqd coeffieicent array must be in Y memory.  The size of the array
 *    must "2*s_length" words.
 *
 * Algorithm:
 *
 *    The routine cycles through each element of the two arrays performing a
 *    multiplication followed by a right shift and storing the results to Y
 *    memory (inplace) in the same order.
 *
 *  Prototype:
 *    void FdqMultiply(int16 *psa_fdq_coef, int8 *puca_fdq_exp, int16 s_multiplier, int16 s_first_tone, int16 s_length, int16 s_fdq_mantissa_wordlength, int16 s_fdq_multiplier_frac_bits)
 *
 *  Input Arguments:
 *    int16 *psa_fdq_coef           - Pointer to fdq coefs in Y memory
 *    int16 *puca_fdq_exp           - Pointer to fdq exponents
 *    int16 *s_multiplier           - Fdq multiplier
 *    int16 s_first_tone            - First tone
 *    int16 s_length             - Number of tones
 *    int16 s_fdq_mantissa_wordlength  - Fdq Mantissa Wordlength
 *    int16 s_fdq_multiplier_frac_bits- Number of fractional bits in fdq multiplier
 *
 *  Output Arguments:
 *    Fdq Multiplication done in place
 *    int16 *psa_fdq_coef     - Pointer to fdq coefs in Y memory
 *    int16 *puca_fdq_exp     - Pointer to fdq exponents
 *
 *  Return:
 *
 *------------------------------------------------------------------------
 *^^^
 */
void FdqMultiplyLoop(int32 fdq_coef_arr, int32 fdq_exp_arr, int32 fdq_multiplier, int16 length, int16 fdq_mantissa_wordlength, int16 fdq_multiplier_frac_bits);
void FdqMultiply(int16 *psa_fdq_coef, int8 *puca_fdq_exp, int16 s_multiplier, int16 s_first_tone, int16 s_length, int16 s_fdq_mantissa_wordlength, int16 s_fdq_multiplier_frac_bits)
{
   int32 l_vectorFdqCoef, l_scalarFdqMultiplier;

#if 1

   l_vectorFdqCoef = (int32)(gl_XYDec_FdqCoef_Y16+ (s_first_tone<<1));

#else //Disabled for now (since only showtime processing is using this) to conserve program memory

   if(CheckXYAddrRange(&psa_fdq_coef[(s_first_tone<<1)], Y_MEM) == FAIL)
      return;
   l_vectorFdqCoef = XYAddrDecode((int32 *) (&psa_fdq_coef[(s_first_tone<<1)]), ADDR_MODE_16);

#endif

   l_scalarFdqMultiplier = (int32)((s_multiplier<<16) | s_multiplier);

   FdqMultiplyLoop(l_vectorFdqCoef, (int32)(&puca_fdq_exp[s_first_tone]), l_scalarFdqMultiplier, s_length, s_fdq_mantissa_wordlength, s_fdq_multiplier_frac_bits);
}
