/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-1998 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: fixconv.c
;
;  This file contains the fixed-point convolution routine
;
;***************************************************************************/

#include "common.h"
#include "dsp_op.h"

/*****************************************************************************
;  Subroutine Name: FixedPointConvolve
;
;  Description:
;
;     Fixed point convolution.
;
;  Prototype:
;
;     void FixedPointConvolve(int16 *psa_input, int16 *psa_filter, int32 *pla_output, int16 s_inputlen,
;           int16 s_CPLen, int16 s_filterlen, int16 s_round);
;
;  Input Arguments:
;
;     int16 *psa_input  - pointer to 16-bit input data array
;     int16 *psa_filter - pointer to 16-bit filter array
;     int16 *pla_output - pointer to 32-bit array for convolution result
;     int16 s_inputlne  - length of input array
;     int16 s_CPLen     - length of cyclic prefix (CP)
;     int16 s_filterlen - length of filter
;     int16 s_round     - bits to shift during multiply-accumulate state to
;                    prevent overflow
;
;  Output Arguments:
;     none
;
;  Return Value:
;     none
;
;  Global Variables Used:
;****************************************************************************/

void FixedPointConvolve(int16 *psa_input, int16 *psa_filter, int32 *pla_output, int16 s_inputlen,
            int16 s_CPLen, int16 s_filterlen, int16 s_round) {

   int16 i, j, Index, Index2;
   /* int16 f_Sum; */
   int32 l_Sum;
   int32 l_temp1;

   Index = s_CPLen - s_filterlen;
   for(i=0; i<s_inputlen; i++){
      l_Sum = 0;
      Index++;
      if(Index < 0){
         Index += s_inputlen;
      }
      if(Index >= s_inputlen){
         Index -= s_inputlen;
      }
      for(j=0; j<s_filterlen; j++){
         if((Index + j) >= s_inputlen) {
            Index2 = Index + j - s_inputlen;
         }
         else Index2 = Index + j;

         l_temp1 = (int32)psa_input[Index2] * (int32)psa_filter[j];
         l_temp1 = round(l_temp1,s_round);
         l_Sum = l_add(l_Sum, l_temp1);

      }
      pla_output[i] = l_Sum;
   }
}

