/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2000 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  goertzel.c
;
;  This file contains routines to calculate the DFT of the pilot tone
;
;***************************************************************************/


#include "common.h"
#include "dsp_op.h"
#include "pll.h"
#include "gdata.h"
#include "rt_state.h"

/*****************************************************************************
;  Prototype:
;     void RxGoertzel(void);
;
;  Description:
;     This function calculates the DFT of tone 64.
;
;       Specifically, for the 1.104 MHz sampling rate, we have
;           X[64] = sum(m=0 to 63) (x[4m] - jx[4m+1] - x[4m+2] + jx[4m+3]).
;
;       For the 2.208 MHz sampling rate this is less elegant:
;           X[64] = sum(m=0 to 63) (x[8m] - jx[8m+2] - x[8m+4] + jx[8m+6]
;        + ((1-j)x[8m+1] + (-1-j)x[8m+3] + (-1+j)x[8m+5] + (1+j)x[8m+7])/sqrt(2))
;
;  Input Arguments: psa_SampleData contains an array of time-domain samples
;                        s_NumTones indicates the sampling rate
;
;  Output Arguments: psa_InPilotTone contains the DFT of tone 64
;
;  Global Variables: none
;
;*************************************************************************************/
void RxGoertzel(int16 *psa_InPilotTone, int16 *psa_SampleData, int16 s_NumTones)
{
   int16 i;
   int16 *s_sample  = psa_SampleData+1;
   int32 l_Acc0 = 0;
   int32 l_Acc1 = 0;

   if (s_NumTones == 256)
   {
      /* we have a 2.208 MHz sampling rate for the time-domain data */
      for (i=64; i>0; i--)
      {
         l_Acc0 += (int32)(*s_sample);  // x[8m+1]
         s_sample += 2;
         l_Acc0 -= (int32)(*s_sample);  // -x[8m+3]
         s_sample += 2;
         l_Acc0 -= (int32)(*s_sample);  // -x[8m+5]
         s_sample += 2;
         l_Acc0 += (int32)(*s_sample);  // x[8m+7]
         s_sample += 2;
      }

      s_sample = psa_SampleData+1;
      for (i=64; i>0; i--)
      {
         l_Acc1 -= (int32)(*s_sample); // (-j)x[8m+1]
         s_sample += 2;
         l_Acc1 -= (int32)(*s_sample); // (-j)x[8m+3]
         s_sample += 2;
         l_Acc1 += (int32)(*s_sample); // (+j)x[8m+5]
         s_sample += 2;
         l_Acc1 += (int32)(*s_sample); // (+j)x[8m+7]
         s_sample += 2;
      }

      l_Acc0 = round((l_Acc0 >> 2)*(int32)0x5A82, 13);  // sum *= 1/sqrt(2)
      l_Acc1 = round((l_Acc1 >> 2)*(int32)0x5A82, 13);  // sum *= 1/sqrt(2)

      s_sample = psa_SampleData;
      for (i=64; i>0; i--)
      {
         l_Acc0 += (int32)(*s_sample);  // X_r[64] += x[8i]
         s_sample += 4;
         l_Acc0 -= (int32)(*s_sample);  // X_r[64] -= x[8i+4]
         s_sample -= 2;
         l_Acc1 -= (int32)(*s_sample);  // X_i[64] -= x[8i+2]
         s_sample += 4;
         l_Acc1 += (int32)(*s_sample);  // X_i[64] += x[8i+6]
         s_sample += 2;
      }
      l_Acc0 = round(l_Acc0, 5);  // scale consistent with FFT
      l_Acc1 = round(l_Acc1, 5);  // scale consistent with FFT
   }
   else
   {
      /* we have a 1.104 MHz sampling rate for the time-domain data */
      s_sample--;
      for (i=64; i>0; i--)
      {
         l_Acc0 += (int32)(*s_sample++);  // X_r[64] += x[4i]
         l_Acc1 -= (int32)(*s_sample++);  // X_i[64] -= x[4i+1]
         l_Acc0 -= (int32)(*s_sample++);  // X_r[64] -= x[4i+2]
         l_Acc1 += (int32)(*s_sample++);  // X_i[64] += x[4i+3]
      }
      l_Acc0 = round(l_Acc0, 4);
      l_Acc1 = round(l_Acc1, 4);
   }
   psa_InPilotTone[0] = sature16(l_Acc0);
   psa_InPilotTone[1] = sature16(l_Acc1);
}
