/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------
*
*   Aware DMT Technology. Proprietary and Confidential.
*
*   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
*   Phone (781) 276 - 4000
*   Fax   (781) 276 - 4001
*
*   codeswap.c
*
*  Codeswapping functions.
*
*-------------------------------------------------------------------------
*/
/*----------------------------------------------------------------------------------------------------------------------------------------*/
//
// File load_codeswap.c
//
// History :
//
//  19/09/2011 Sriram Shastry : Disable Power Management L2,L3 mode, Seamless rate adaptation ( US & DS direction) as a part of R43. delivery
//             This is done as per project management requirement. They are only check box feature for R4.3 release. SRA & PM L2 mode
//             features are functionally not verified.
//
//    Grep for :   IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode
//
// 18/10/2011 Raghu/Vinjam: Dis-able noise shapper to reduce the DC SRC caused by TX SRC block.
//                  It is under the CMV control INFO 103 27 0x1000
//                  Grep for XDSLRTFW-316
//
// 21/11/2011 Hanyu: Ported NLNF measurement state machine entry on sleep state page for VRx MFD.
//            This feature is triggered by SW API "cw cntl 0 0 0x09" similar to sleep test mode.
//            Additinally, it is triggered by SW API 3.16.5.9 or newer during modem power up
//            and can be disabled by CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect
//
// 02/12/2011 Balabath:Added new microstate STATs18D and 19D CMV DSL 16 is used inplace of INFO 121
//       for NLNF measurement.INFO 103 (6:11) are mapped to DSL 18 0 5 (Hybrid information)..
//            Additinally, DSL13 bit2 is used inplace of CMV bit-15 (default "0" means enabled) of INFO 121 0.
//        Grep for XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap
//
// 04/01/2012 Balabath:Support US SRA and controlling US SRA" between Hercules CMV "OPTN 15 0 x0002"
//                   to Socrates "OPTN 15 0 0x0100
//       Grep for XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap
//
// 10/01/2012:Balabath:Enhance_DM_Optimisation
//
// 07/08/2012 Vinjam: Added a CMV "TEST 40 0 0x1" to force upstream fine gains to unity (0x2000) to measure CPE Tx PSD.
//            if(CMV "TEST 40 0 0x1") then disable upstream bitswap.
//            Grep for XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement
//
// 24/8/2012 Vinjam: If DSL 19 0 1 is set, then CRC & FEC counters are set to zero.
//            Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 29/8/2012 Vinjam: Changed CMV (from "TEST 40 0 0x1" to "TEST 28 0 0x2") to force upstream fine gains to unity
//            CMV is changed to keep it same across ARx & VRx platforms.
//            Grep for XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement
//
// 07/9/2012 Vinjam: Renamed "CMV_TO_SUPPRESS_HercCNTRtoSOCPLAM_SWWRITEOPTION" to "CMV_TO_SUPPRESS_CRC_FEC_WriteBackOption".
//                   Grep for XDSLRTFW-508 Fix_DS_All_All_SuppressCounterWriteFromDSLAPI
//
// 28/9/2012 Vinjam: US G.hs tone PSD level is 18dBm/Hz lower than mormnal level of -40dBm/Hz after Annex M mode
//                 is selected against any CO/DSLAM on any loop. It is found due to uninitialization of "gl_SelectedMode"
//                 which is used for configuring IFFT scalebacks. Fixed the issue by forcing "gl_SelectedMode" to "0",
//                 if the previous selected mode is "5M".
//                 Grep for XDSLRTFW-514 BugFix_US_AnxMBisPlus_CNXT_GhsTxPSD
// 21/11/2012 Kannan: Code swap of showtime page is done it here.
//            Grep for "XDSLRTFW-541: Platform_VR9_VRX318"
//
// 15/01/2013 Kannan: Code added to call the exceptional handler
//             if there is an exception error in AFE initialization after issuing
//             CNTL 0 0 2 or CNTL 0  0 8.
//            Grep for "XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication"
//
// 27/02/2013 Mahesh: Added crystal drive changes for Jira - XDSLRTFW -561
//                       added the delta freq offset in DSL 25 to gl_initfreqoffset
//                       Grep for XDSLRTFW-561 Enhancement_All_All_All_FreqOffset
//
// 07/03/2013 Vinjam: Enable PM L3 Feature so that it honours (i) API request for PM L3 & (ii) CO request to go to PM L3
//                 Grep for XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault
//
// 19/05/2013 Kannan: Pause Marker removed for afe init fail exception.
//     "XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException"

// 27/05/2013 Varun : Added code to initialize the Debug Buffer variables . Also codeswap page GHS_TO_SHOW added
//                   Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 05/03/2014 Prashant: Controlling the line driver mode using a CMV. Set line driver (DSL 10) after CNTL 0 0 2.
//            Reprogram line driver only if it is different from initialized one.
//            Grep for XDSLRTFW-1630
//
// 26/11/2014 Prashant: Setting the customer IOP bits using DSL 21. Instead of setting the individual IOP bits,
//            Now the iop bits for different operators are set internally in FW depending on input from DSL 21.
//
//            Grep for XDSLRTFW-1792
//
// 09/03/2018 Sriram Shastry : XDSLRTFW-3740 : Do changes for KPN operator also for OTE_GREECE and MT_HUNGARY
//            Add support for operator bit in ADSL oISDN for extended US0 tone range
//            Grep for : XDSLRTFW-3740
//
// 10/09/2018 Chih-Wen: XDSLRTFW-3958: Set default US tones to 29~57 to improve US rate for ISDN. This is done by setting
//            CMV_TO_FORCE_KPN_TSSI_US_BIN_START by default. So the setting for the operators, MT_HUNGARY, OTE_GREECE, and KPN, are
//            removed.
//            Grep for XDSLRTFW-3958 SetDefaultUsTones29to57_oISDN
//
/*-------------------------------------------------------------------------------------------------------------------------------------------*/

#include "typedef.h"
#include "const.h"
#include "gdata.h"
#include "codeswap.h"
#include "soc_codeswap.h"
#include "memrymap.h"
#include "interrupt.h"
#include "LL_IOf.h"
#include "cmv.h"
#include "modem_hw.h"
#include "sleep.h"
#include "states.h"
#include "DebugBuffer.c"
#ifdef CUSTOMER_TASKS
#include "CustomerTasks.h"
#endif
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#include "nlnf.h"
#endif
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)
#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"
#include "Cnfg_task.h"
#include "LinkStart.h"
#include "RCSilent1RxF.h"

extern int16 gs_DECUpsamplingFactor;

extern void delay(uint16 delay_val);
extern void LinkStart(void);
//XDSLRTFW-1634 (Start_End)
extern void InitReTxVars(void);

/****************************************************************************
;  Prototype: void LoadCodeSwapPagesForInitialState(void)
;
;  Description:
;       Load codeswap page after initial state has been selected
;
;  Arguments:
;       none
;
;  Return Value:
;
;****************************************************************************/

#define MAX_NUM_CODESWAP_SECTIONS_FOR_INITIAL_STATE      4

#define FULL_INIT_LINK  0
#define SHORT_INIT_LINK 1

int32 gl_tle;

void SetSelectModeInSleep()
{
   uint16 u_ModeOPtion;

   //the DMS command dsl dms 0x45 0 2 0x1000 0 sets OPTNArray[OPTN_ModeControl] = 0x1000
   u_ModeOPtion = (uint16)OPTNArray[OPTN_ModeControl];

   switch (u_ModeOPtion)
   {
      case OPTN_ConfigMode_G992_1_A:
         gl_SelectedMode = MODE_G992_1 | ANNEX_A;
         break;

      case OPTN_ConfigMode_G992_1_B:
         gl_SelectedMode = MODE_G992_1 | ANNEX_B;
         break;

      case OPTN_ConfigMode_G992_3_A:
         gl_SelectedMode = MODE_G992_3 | ANNEX_A;
         break;

      case OPTN_ConfigMode_G992_3_B:
         gl_SelectedMode = MODE_G992_3 | ANNEX_B;
         break;

      case OPTN_ConfigMode_G992_3_L:
         //From winhost set STATArray[STAT_Misc] |= STAT_AnnexL_US_Mask1_PSD for
         //for Annex L mask1 and STAT_AnnexL_US_Mask2_PSD for Annex L mask2  before
         //giving the sleep state command (dsl dms 0x41 0 1 8)
         gl_SelectedMode = MODE_G992_3 | ANNEX_L;
         break;

      case OPTN_ConfigMode_G992_3_M:
         //From winhost set gs_AnnexBMJPSDMaskIdx to required Annex M index before giving
         //the sleep state command (dsl dms 0x41 0 1 8)
         gl_SelectedMode = MODE_G992_3 | ANNEX_M;
         break;

      case OPTN_ConfigMode_G992_5_A:
         gl_SelectedMode = MODE_G992_5 | ANNEX_A;
         break;

      case OPTN_ConfigMode_G992_5_B:
         gl_SelectedMode = MODE_G992_5 | ANNEX_B;
         break;

        default:
         //Annex A binary and B binary are diffeence and hence here mask is not set
         gl_SelectedMode = MODE_G992_5;
         break;
   }
#if 0 //Disabled because the following DMS command is not working throwing error in teraterm
   //the DMS command dsl dms 0x45 7 2 0x2 0 sets OPTNArray[OPTN_ModeControl1] = 0x2
   u_ModeOPtion = (uint16)OPTNArray[OPTN_ModeControl1];
   if (u_ModeOPtion)
   {
      switch (u_ModeOPtion)
   {
      case OPTN_ConfigMode_G992_5_J:
         //From winhost set gs_AnnexBMJPSDMaskIdx to required Annex J index before giving
         //the sleep state command (dsl dms 0x41 0 1 8)
         gl_SelectedMode = MODE_G992_5 | ANNEX_J;
         break;

      case OPTN_ConfigMode_G992_5_M:
         //From winhost set gs_AnnexBMJPSDMaskIdx to required Annex M index before giving
         //the sleep state command (dsl dms 0x41 0 1 8)
         gl_SelectedMode = MODE_G992_5 | ANNEX_M;
         break;

      default:
         //Annex A binary and B binary are diffeence and hence here mask is not set
         gl_SelectedMode = MODE_G992_5;
         break;
   }
   }
#endif
   //Before calling the Reconfig_PostGHS set all the globals corresponding
   //to the DMT/ADSL2/ADSL2+ used to configure the HW Tx/Rx paths
   if (( gl_SelectedMode & MODE_G992_1) || (gl_SelectedMode & MODE_G992_3))
   {
      gs_RxNumTones = 256;
      gs_RxFftLength = 512;
   gs_RxCPLength = gs_RxFftLength >> 4;
   gs_RxLog2FftLength1 = 8;
   /* Compute log2rxnumsamples */
   gs_Log2RxSamplesPerFrame = 9;

   gs_TxFftLength_Oversample = gs_RxFftLength;
   gs_TxCPLength_Oversample = gs_RxCPLength;
   /* Compute log2(gs_TxFftLength)-1 = log2(gs_FftLength/2) */
   gs_TxLog2FftLength1_Oversample = gs_RxLog2FftLength1 ;
   gs_RxSamplesPerFrame = gs_RxFftLength;
   gs_DECUpsamplingFactor = 1;
   }
   else
   {
   gs_RxNumTones = 512;
   gs_RxFftLength = 1024;
   gs_RxCPLength = gs_RxFftLength >> 4;
   gs_RxLog2FftLength1 = 9;
   /* Compute log2rxnumsamples */
   gs_Log2RxSamplesPerFrame = 10;

   gs_TxFftLength_Oversample = gs_RxFftLength;
   gs_TxCPLength_Oversample = gs_RxCPLength;
   /* Compute log2(gs_TxFftLength)-1 = log2(gs_FftLength/2) */
      gs_TxLog2FftLength1_Oversample = gs_RxLog2FftLength1 ;
   gs_RxSamplesPerFrame = gs_RxFftLength;
   gs_DECUpsamplingFactor = 2;
   }
   Reconfig_PostGHS();
}

void LoadCodeSwapPagesForInitialState()
{
   int i;
   int16 s_linkType;
   int16 sa_CodeswapSections[2][MAX_NUM_CODESWAP_SECTIONS_FOR_INITIAL_STATE] =
   {

      // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
      //XDSLRTFW-541: Platform_VR9_VRX318 (START)
      //Code swap of "CSPAGE_BIS_SHOW_1PORT" is done it here before starting the
      //the link, though this page is applicable for showtime.
      //If we swap this page just before entering showtime,
      //this memory may be used for training purpose too.
      //{CSPAGE_BIS_HNSHK1, CSPAGE_BIS_HNSHK2, -1},
      //{CSPAGE_BIS_HNSHK2, CSPAGE_BIS_R_NOGHS, CSPAGE_BIS_DISC1}
      {CSPAGE_BIS_HNSHK1, CSPAGE_BIS_HNSHK2, CSPAGE_BIS_SHOW_1PORT, CSPAGE_BIS_GHS_TO_SHOW},
      {CSPAGE_BIS_HNSHK2, CSPAGE_BIS_R_NOGHS, CSPAGE_BIS_DISC1, -1}
      //XDSLRTFW-541: Platform_VR9_VRX318 (END)
   };

#ifdef CUSTOMER_TASKS
   Customer_LoadSwapPagesForInitState();
#endif

   if (gl_SelectedMode & LINK_SHORTINIT)
   {
      s_linkType = SHORT_INIT_LINK;
   }
   else
   {
      s_linkType = FULL_INIT_LINK;
   }

   // if we're here, we've received an MP start command
   // we need to codeswap handshake page before other tasks start
   for (i = 0; i < MAX_NUM_CODESWAP_SECTIONS_FOR_INITIAL_STATE; i++)
   {
      gs_CodeSwapSection = sa_CodeswapSections[s_linkType][i];
      if (gs_CodeSwapSection != -1)
      {
         gs_CodeSwapStatus = CODESWAP_START;
         // send the codeswap request to code server
         // blocking other tasks if codeswap is not complete
         do {
            HandleCodeSwap();
                gl_tle++;
         }while (gs_CodeSwapStatus != CODESWAP_COMPLETE);
      }
   }
    gl_tle = 0x0d1d;

   //Update codeswap section to be swapped in next
   if (s_linkType == SHORT_INIT_LINK)
   {
      gs_CodeSwapSection = CSPAGE_BIS_XCVR1;
   }
   else
   {
      gs_CodeSwapSection = CSPAGE_BIS_R_NOGHS;
   }
   gs_CodeSwapStatus = CODESWAP_IDLE;

   // set some global variables for codeswap purpose
   gft_RxinitSwap = DO_CODESWAP; //this global variable will indicate doing codeswap specifically for showtime Rx page
}
//Enhance_DM_Optimisation (start) moved to gdata.c
//FlagT gft_LinkStartFlag = FALSE;
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (START)
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
//FlagT gft_EnableAutoSRA = TRUE;
//FlagT gft_EnableUSSRA  = TRUE;
//XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)
//FlagT gft_EnableL2Mode = FALSE;
//FlagT gft_EnableL3Mode = FALSE;
// IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (END)
//Enhance_DM_Optimisation (end) moved to gdata.c
void StartModemOperation(void)
{
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
   // "CNTL 0 0 9" for NLNF will need SW API change simialor to sleep mode.
   // Force to NLNF in "Sleep mode" to avoid SW rebooting without SW API change
   // This can be enabled by CMV bit-2 of DSL 13 0
   // (default "0" means enabled)
   // and cw test 7 0 0x7FD0 without SW API support.
   //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)
  if ((gt_ApiOptions.us_Opt_Offset0 & CMV_BIT2_TO_ENABLEE_NLNF_STARTUP) &&
      (TESTArray[TEST_RxSubState] == CMV_TEST70_RX_NLNF_TRIGGERED))
    {
      guc_NLNF_Enable = 1; // Enable NLNF in "Sleep mode" to avoid SW rebooting
      CNTLArray[0] = 8;    // Force to go to "Sleep mode" to avoid SW rebooting
    }
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (Start)
//OPTNArray[OPTN_ModeControl]  |= OPTN_ConfigMode_T1413;
//XDSLRTFW-326 Feature_ALL_Try_GHS_Before_T1413_ALL (End)
   switch(CNTLArray[0] & 0x000F)
   {
      case 2:     /* Link Start  */
         //DO NOT ADD ANY CODE BEFORE THIS POINT
         //XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START)
         if ((gus_ExceptionCode != E_CODE_NO_ERROR) &&
           (OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_AFE_FAIL_EXCEPTION))
         {
            gus_ExceptionState = gs_RxState;
            // Run Exception Handler sets FAIL state and triggers ME reboot, including showtime
            ExceptionHandler();
         }
         //XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (END)

         // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (Start)
         //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (start)
#if 0
         //Disable downstream AuToSRA
         if(gft_EnableAutoSRA == FALSE){
            OPTNArray[OPTN_OLRControl_DS] &= ~OPTN_EnableAutoSRA;
         }
         else
         {
            OPTNArray[OPTN_OLRControl_DS] |= OPTN_EnableAutoSRA;
         }
         //Disable upstream SRA
         if(gft_EnableUSSRA == FALSE){
            OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableUSSRA;
         }

         //XDSLRTFW-380: Feature_US_BisPlus_All_USSRA_CMVRemap (end)
         //Disable downstream PM L2 mode
         if(gft_EnableL2Mode == 0){
            OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableL2Mode;
         }
#endif

#if 0
         //XDSLRTFW-750 Fix_DS_BisPlus_All_PML3EnableByDefault (Start_End)
         //Disable downstream PM L3 mode - Take it out to enable PM L3
         if(gft_EnableL3Mode == 0){
         OPTNArray[OPTN_OLRControl_DS] |= OPTN_DisableL3Mode;
         }
         // IOP_ALL_ALL_ALL_USDSSRA_PML2_PML3_mode (End)
#endif
         //XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement (Start)
         if (TESTArray[TEST_Control3] & TEST_ForceUpStreamFineGainsToUnity)
            OPTNArray[OPTN_AlgControl] |= OPTN_USBitSwapDisable;
         //XDSLRTFW-501 Test_US_BisPlus_ALL_ForceUpStreamFineGainsToUnityForPSDmeasurement (End)




         // XDSLRTFW-316 (Start)
            //Dis-able noise shapper reduce the DC SRC caused by TX SRC block
            if (gt_INFX_CMV.us_OperatorSpBits5 & (CMV_TO_BYPASS_PLL_BW_CHANGE_IN_SHOWTIME))
            {
            gft_EnableNoiseShaping = FALSE;
            }
         // XDSLRTFW-316 (End)

         //XDSLRTFW-524 BugFix_US_AnxMBisPlus_CNXT_GhsTxPSD (Start)
         //Add this code before LinkStart()
         if (gl_SelectedMode & (ANNEX_M))
               gl_SelectedMode = 0;
         //XDSLRTFW-524 BugFix_US_AnxMBisPlus_CNXT_GhsTxPSD (End)
            // XDSLRTFW-1630 (Start)
            if (((gus_LD_Mode & 0x00FF) > 0) && (gus_LD_Mode != gus_Choosen_LD_Mode))
            {
             // Set LD mode
               AFED_SetLdMode((gus_LD_Mode&0x00FF));
             //VR9_SetLDMode((gus_LD_Mode&0x00FF));
            }
            // XDSLRTFW-1630 (End)

// XDSLRTFW-1792 (Start)
#ifndef ISDN // Only for Annex-A
         if(gt_Dsl_Operator_Select.us_Operator_Select == FT)
         {
            gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_ENABLE_REIN_DETECTION_TRAINING_AND_CHANGE_FRAMING;  // Bit #9 of INFO 103 28
            gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_DISABLE_RFI_NOTCH; // Bit #8 of INFO 103 28
            gt_INFX_CMV.s_DFE_Options |= CMV_INFX_DFE_FT_INTERP13_ENABLE; // Bit #7 of INFO 103 1
            gt_INFX_CMV.us_OperatorSpBits2 |= CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE;  // Bit #6 of INFO 103 20
            gt_INFX_CMV.us_OperatorSpBits3 |= CMV_TO_DISABLE_REIN_ADAPTATION_TRAINING; // Bit #5 of INFO 103 23
            gt_INFX_CMV.us_OperatorSpBits4 |= CMV_TO_ENABLE_BRCM_MAXNOMATP_DS_SettoZero; //Bit #4 of INFO 103 26
            gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset0 |= ( MONI_LCD_FAILURE_BC0 | MONI_LOM_FAILURE | MONI_LOS_FAILURE); //MONI 5 0 (Bit#6, Bit#3, Bit#0)
            gsa_HercADSL_MONIMap_ShowFailConditions[0].s_Offset1 |= (MONI_SES30_FAILURE | MONI_ES90_FAILURE); //MONI 5 1 (Bit#1, Bit#0)
         }

         if(gt_Dsl_Operator_Select.us_Operator_Select == CT)
         {
              OPTNArray[OPTN_AlgControl3] |= CMV_TO_BoostGhsToneDetScale; // Bit #8 of OPTN 33 0
            gt_INFX_CMV.us_OperatorSpBits2 |= CMV_TO_ENABLE_Ghs_CPilot1DetFix; // Bit #2 of INFO 103 20
         }

         if(gt_Dsl_Operator_Select.us_Operator_Select == TELEFONICA)
         {
            gt_INFX_CMV.us_OperatorSpBits3 |= CMV_TO_ENABLE_ADSL2PLUS_ATN_BenchmarkAR7; // Bit #15 of CMV INFO 103 23
            gt_INFX_CMV.us_OperatorSpBits2 |= CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE;  // Bit #6 of INFO 103 20
            gt_INFX_CMV.us_OperatorSpBits2 |= CMV_TO_ENABLE_CNXT_US_RateImprovement; // Bit #13 of INFO 103 20
            gt_INFX_CMV.us_OperatorSpBits4 |= CMV_TO_ENABLE_FIX_Sparnex_DS_CRC; // Bit #5 of INFO 103 26
            gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_ENABLE_DS_ST_STABLE_WITH_IKNS; //Bit #14 of INFO 103 28
            gt_INFX_CMV.us_OperatorSpBits4 |= CMV_TO_ENABLE_BRCM_MAXNOMATP_DS_SettoZero; // Bit #4 of INFO 103 26
         }

         if(gt_Dsl_Operator_Select.us_Operator_Select == TW)
         {
            gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_ENABLE_PSDBoostUSPerf24HDSLNoise; // Bit #15 of CMV INFO 103 28
         }

         if(gt_Dsl_Operator_Select.us_Operator_Select == OTE_GREECE)
         {
            gt_INFX_CMV.us_OperatorSpBits2 |= CMV_TO_ENABLE_CNXT_US_RateImprovement; // Bit #13 of INFO 103 20
         }
#else // ANNEX B
                //XDSLRTFW-3958 SetDefaultUsTones29to57_oISDN (START)
                if(gt_Dsl_Operator_Select.us_Operator_Select == DTAG)
                {
                   gt_INFX_CMV.us_OperatorSpBits &= ~CMV_TO_FORCE_KPN_TSSI_US_BIN_START;
                }
                //XDSLRTFW-3958 SetDefaultUsTones29to57_oISDN (END)
                //XDSLRTFW-3958 SetDefaultUsTones29to57_oISDN (START)
                //The default setting is CMV_TO_FORCE_KPN_TSSI_US_BIN_START, so the setting for the operators below are removed.
                // XDSLRTFW-3740 (Start)
         //if(gt_Dsl_Operator_Select.us_Operator_Select == MT_HUNGARY)
         //{
      //   gt_INFX_CMV.us_OperatorSpBits |= CMV_TO_FORCE_KPN_TSSI_US_BIN_START; // Bit #0 of INFO 103 0
         //}

            //if(gt_Dsl_Operator_Select.us_Operator_Select == OTE_GREECE)
         //{
                //   gt_INFX_CMV.us_OperatorSpBits |= CMV_TO_FORCE_KPN_TSSI_US_BIN_START; // Bit #0 of INFO 103 0
         //}
                // XDSLRTFW-3740 (End)

         //if(gt_Dsl_Operator_Select.us_Operator_Select == KPN)
         //{
      //   gt_INFX_CMV.us_OperatorSpBits |= CMV_TO_FORCE_KPN_TSSI_US_BIN_START; // Bit #0 of INFO 103 0
         //}
                //XDSLRTFW-3958 SetDefaultUsTones29to57_oISDN (END)
         if(gt_Dsl_Operator_Select.us_Operator_Select == COMLABS_NORWAY)
         {
              gt_INFX_CMV.us_OperatorSpBits |= CMV_ENABLE_IOP_CNXT_REDUCE_US_PCB_BY_3dB; // Bit #8 of INFO 103 0
         }

         if(gt_Dsl_Operator_Select.us_Operator_Select == FT)
         {
            gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_ENABLE_REIN_DETECTION_TRAINING_AND_CHANGE_FRAMING;  // Bit #9 of INFO 103 28
            gt_INFX_CMV.us_OperatorSpBits3 |= CMV_TO_DISABLE_REIN_ADAPTATION_TRAINING; // Bit #5 of INFO 103 23
            gt_INFX_CMV.us_OperatorSpBits6 |= CMV_TO_DISABLE_RFI_NOTCH; // Bit #8 of INFO 103 28
            gt_INFX_CMV.s_DFE_Options |= CMV_INFX_DFE_FT_INTERP13_ENABLE; // Bit #7 of INFO 103 1
            gt_INFX_CMV.us_SRA_IOP_Bits |= CMV_FOR_MARGIN_ON_15BITS_TONES; // Bit #15 of INFO 103 29
            gt_INFX_CMV.us_OperatorSpBits2 |= CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE;  // Bit #6 of INFO 103 20
         }

         if(gt_Dsl_Operator_Select.us_Operator_Select == TELEFONICA)
         {
            gt_INFX_CMV.us_OperatorSpBits2 |= CMV_INFX_DFE_FAVOR_MARGIN_OVER_INP_ENABLE;  // Bit #6 of INFO 103 20
         }
#endif
// XDSLRTFW-1792 (End)

         LinkStart();
         gft_LinkStartFlag = TRUE;

         // Load codeswap page based on Initial state
         LoadCodeSwapPagesForInitialState();
#ifdef DEBUG_TRACES
         // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
         // All variables related to Debug Buffer should be initialized here
           //failing to follow these intructions might result in Fail state at the GHS only
         Init_DebugBuf_variables();

#endif // #ifdef DEBUG_TRACES
         //XDSLRTFW-1634 (Start_End)
         /* Initialization of ReTx variables missing if Debug Traces are turned off */
         /* Note : This is  done to  avoid conflicting implementation with  AVM code. AVM has different code base for debug Buffer and they may not
         include #define DEBUG_TRACES in their FW. To avoid this InitReTxVars() is kept outside DEBUG_TRACES compiler switch */
         /* XDSLRTFW-2895 */
         InitReTxVars();
         /* XDSLRTFW-2895 */
         // Set back to 1 to switch to foreground MP handler.
         gs_MpWinhostControl = 1;

#ifndef ADSL_62
            // interrupts are always on for ADSL_62
         ClearADSLInterrupts();
         EnableADSLInterrupts();
#endif
         break;

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
     case 9:   // NLNF measurement in sleep codeswap page similar to case 8.
      // Disable NLNF feature in FW during modem startup
      // as well as subsequential training.
      //XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect_CMVRemap (start_end)
      if ((gt_ApiOptions.us_Opt_Offset0 & CMV_BIT2_TO_ENABLEE_NLNF_STARTUP)== 0)
       break;

      guc_NLNF_Enable = 1; // Flag to indicate NLNF enabled
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

      case 7:
         gs_TxNextState = R_SILENT0_TX;
         gpF_TxStateFunc = (PtrToFunc) RSilent0TxF;
         gs_RxNextState = R_C_SILENT1_RX;
         gpF_RxStateFunc = (PtrToFunc) RCSilent1RxF;

         STATArray[STAT_MacroState] = STAT_DSL_POWER_DOWN;
         gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_DSL_POWER_DOWN;
         gusa_HercADSL_MONIMap_Curr[3] = MONI_DSL_POWER_DOWN;
         AFED_SetLdMode(LD_PDN);
         WriteCoreReg((uint32)(V_FCSI_CMD_D_35B_ADDR), FCSI_CMD_RST_CONTROLLER_BUSREGS);  //V_FCSI_CMD_C_35B_ADDR = 0x4000 means 010B  --> RST
         delay(50);
         WriteCoreReg((uint32)(V_FCSI_CMD_C_35B_ADDR), FCSI_CMD_RST_CONTROLLER_BUSREGS);  //V_FCSI_CMD_C_35B_ADDR = 0x4000 means 010B  --> RST
         delay(50);
         // Load codeswap page based on Initial state
         LoadCodeSwapPagesForInitialState();
         break;

      case 8:     /* sleep mode */
         //DO NOT ADD ANY CODE BEFORE THIS POINT
         //XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START)
         if ((gus_ExceptionCode != E_CODE_NO_ERROR) &&
            (OPTNArray[OPTN_AlgControl3] & CMV_TO_ENABLE_AFE_FAIL_EXCEPTION))
         {
            gus_ExceptionState = gs_RxState;
            // Run Exception Handler sets FAIL state and triggers ME reboot, including showtime
            ExceptionHandler();
         }
         //XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (END)

         // XDSLRTFW-3548 (Start)
         STATArray[STAT_MacroState] = STAT_TEST;
         gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_TEST;
         gusa_HercADSL_MONIMap_Curr[0] = MONI_TEST;
         // XDSLRTFW-3548 (End)

         delay(50000);
         if (gft_LinkStartFlag == FALSE)
         {
            /* load the init swap page */
            gs_CodeSwapSection = CSPAGE_BIS_INIT;
            gs_CodeSwapStatus = CODESWAP_START;
            while (gs_CodeSwapStatus != CODESWAP_COMPLETE)
               HandleCodeSwap();

            LinkStart();
#if 1
                SetSelectModeInSleep();
#endif
            gft_LinkStartFlag = TRUE;

         }

         gs_CodeSwapSection = CSPAGE_BIS_SLEEP;
         gs_CodeSwapStatus = CODESWAP_START;
         while (gs_CodeSwapStatus != CODESWAP_COMPLETE){
            HandleCodeSwap();
         }

// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (START)
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
      // For case 9: NLNF measurement state machine entry.
      if (guc_NLNF_Enable)
      {
        // Bit13 = 1 indicates NLNF Triggered and clear other bits
        gt_nlnf_metrics_ibs.us_NlnfIbs = 0x2000;

        STATArray[STAT_MacroState] = STAT_ReadyState; //STAT_NLNFStartState;

        // XDSLRTFW-3548 (Start)
        gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;
        gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
        // XDSLRTFW-3548 (End)

        gs_TxNextState = NLNF_QUIET_TX;
        gs_RxNextState = NLNF_SYNC_RX;

        gpF_TxStateFunc = (PtrToFunc) NLNF_QuietTxF;
        gpF_RxStateFunc = (PtrToFunc) NLNF_SyncRxF;
        if(gs_Set_Pause == 0x00B1)Pause(0x00B1);
      }
      else // For case 8: Sleep mode state machine transition.
      {
#endif //#ifndef ISDN
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE

         STATArray[STAT_MacroState] = STAT_ReadyState;
         gusa_HercADSL_MONIMap_Curr[0] = MONI_READY;   // XDSLRTFW-3548 (End)
         gt_HercADSL_STATMap_MacroState.s_Offset0 = STAT_ReadyState;
         gs_TxNextState = SLEEP_TX;
         gs_RxNextState = SLEEP_RX;

         gpF_TxStateFunc = (PtrToFunc)RSleepTxF;
         gpF_RxStateFunc = (PtrToFunc)RSleepRxF;
#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
#ifndef ISDN
      }
#endif
#endif //#ifdef ENABLE_MICROFILTER_DETECT_FEATURE
// XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect (END)

#ifndef ADSL_62
            // interrupts are always on for ADSL_62
         ClearADSLInterrupts();
         EnableADSLInterrupts();
#endif
         break;
   }
}

#undef FULL_INIT_LINK
#undef SHORT_INIT_LINK

#undef MAX_NUM_CODESWAP_SECTIONS_FOR_INITIAL_STATE


