/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;  File Name: med2rev.c
;
;  This file contains the noiseacc function used in SNR calculation
;
;***************************************************************************/
#include "common.h"
#include "medley.h"
#include "gdata.h"
#include "GenMedly.h"
#include "rcmedly2.h"
#include "xy_iof.h"
#include "const.h"

int16 CalculatePhaseDif(int16 s_ar, int16 s_ai, int16 s_br, int16 sbi);
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (Start)
//Moved to DATA_BULK01 to save data memory
DATA_BULKO1_BEGIN //TODO:check is this used (DM optimisation)
C_SCOPE CONSTANT int16 PhaseDifTable[4][4] = { {   0,  90, 270, 180},
                           { 270,   0, 180,  90},
                           {  90, 180,   0, 270},
                           { 180, 270,  90,   0}};
DATA_MAP_END //DATA_BULKO1_BEGIN
//XDSLRTFW-379 Feature_ALL_T1413_GHS_Switching (End)

/********************************************************************************************
;  Subroutine Name: BgMedleyToReverbAccum
;
;  Description:
;     This routine first applies phase shift to a MEDLEY input to
;     make it a REVERB signal, then accumulates it.
;
;     This routine is called during MEDLEY FDQ calculation.
;     The offset parameter is used to control the PN sequence shift during MEDLEY.
;
;
;  Prototype:
;     void BgMedleyToReverbAccum(void)
;
;  Input Arguments:
;     gsa_recv_tones -- pointer to the received DMT tones
;     gsa_ref_tones  -- pointer to the reference DMT tones
;     gs_MedleyOffset      -- offset used to generate Medley signal
;     gs_RxFirstChannel   -- first channel
;     gs_RxLastChannel    -- last channel
;
;  Output Arguments:
;     gla_NoisePower -- pointer to accumulators.
;                    Note that this pointer should point to the address
;                    for the first noise value.  Noise values will get written to
;                 gla_NoisePower[0] through gla_NoisePower[gs_RxLastChannel-gs_RxFirstChannel],
;                 rather than gla_NoisePower[gs_RxFirstChannel] through gla_NoisePower[gs_RxLastChannel]
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;****************************************************************************/
void MedleyToReverbAccumLoop(int32 pla_NoisePower, int32 psa_rec, int32 psa_ref,
         int16 s_first_chan, int16 s_last_chan, int16 s_offset, int16 s_modulo);
#ifdef ADSL_62
void MedleyToReverbAccumLoopXY(int32 pla_NoisePower, int32 psa_rec, int32 psa_ref,
         int16 s_first_chan, int16 s_last_chan, int16 s_offset, int16 s_modulo);
#endif
C_SCOPE void BgMedleyToReverbAccum(void) {
//    if(gft_ModemType == G_DMT) {
      int32 *pla_NoisePower;
      int16 *psa_recv_tones, *psa_ref_tones;
      int16 s_first_chan, s_last_chan, s_offset, s_modulo;
      int16 *psa_rec;
      int32 pla_NoisePowerXY;
      int16 psa_recXY;
      int16 psa_refXY;
      /* ================================================== */
      /* Initialize local variables                         */
      /* ================================================== */
      pla_NoisePower = gla_NoisePower;
      psa_recv_tones = gsa_recv_tones;
      psa_ref_tones  = gsa_ref_tones;
      s_first_chan   = gs_RxFirstChannel;
      s_last_chan    = gs_RxLastChannel;
      s_offset       = gs_MedleyOffset;
      s_modulo       = gs_MedleyModulo;

      /* ================================================== */
      /* Set up address pointers                   */
      /* ================================================== */
      if(CheckXYAddrRange(pla_NoisePower, X_MEM) == FAIL)
         return;
      pla_NoisePowerXY = XYAddrDecode(pla_NoisePower, ADDR_MODE_32);


      /* reference tone buffer */
      if(CheckXYAddrRange((int32 *)(void *)psa_ref_tones, Y_MEM) == FAIL)
         return;

      // the reference tone buffer uses modulo addressing, so
      // we must check that the buffer starts on a valid address
      psa_refXY = XYAddrDecode((int32 *)(void *)psa_ref_tones, ADDR_MODE_16);
      if(CheckValidModuloAddr(psa_refXY, s_modulo) == FAIL)
         return;

      psa_rec = psa_recv_tones+2*s_first_chan;
      psa_recXY = XYAddrDecode((int32 *)(void *)psa_rec, ADDR_MODE_16);


      /* ================================================== */
      /* Compute noise power and add it to the total power  */
      /* ================================================== */

      if(CheckXYAddrRange((int32 *)(void *)psa_rec, X_MEM) == PASS)
         MedleyToReverbAccumLoop(pla_NoisePowerXY, psa_recXY, psa_refXY, s_first_chan, s_last_chan, s_offset, s_modulo);
#ifdef ADSL_62
      else if(CheckXYAddrRange((int32 *)(void *)psa_rec, Y_MEM) == PASS)
         MedleyToReverbAccumLoopXY(pla_NoisePowerXY, psa_recXY, psa_refXY, s_first_chan, s_last_chan, s_offset, s_modulo);
#endif
      else
         return;


      /* ================================================== */
      /* Accumulation is done. */
      /* ================================================== */
      guc_AccumState = TRAINING_DONE;

      /* Turn on transfer of Rx Tone buffer */
      gft_CopyRxBuffer = TRUE;
}

/********************************************************************************************
;  Subroutine Name: CalculatePhaseDif
;
;  Description:
;     This routine calculates the phase difference, i.e.
;
;     phase(A) - phase(B)
;
;     where A = s_ar + i*s_ai, and B = s_br + s_bi.
;
;     Note that phase differences are allowed to be 0, 90, 180, or 270 degrees and
;     possible phase difference combinations are pre-stored in PhaseDifTable
;     as shown below.
;
;             (--) (-+) (+-) (++)
;         A\B| 00 | 01 | 10 | 11 |                    ^
;        ----+----+----+----+----+              (-+)  |  (++)
;    (--) 00 |   0|  90| 270| 180|                1   |   3
;        ----+----+----+----+----+                    |
;    (-+) 01 | 270|   0| 180|  90|          <---------+--------->
;        ----+----+----+----+----+                    |
;    (+-) 10 |  90| 180|   0| 270|                0   |   2
;        ----+----+----+----+----+              (--)  |  (+-)
;    (++) 11 | 180| 270|  90|   0|                    v
;        ----+----+----+----+----+
;
;  Prototype:
;     int16 CalculatePhaseDif(int16 s_ar, int16 s_ai, int16 s_br, int16 s_bi)
;
********************************************************************************************/
#define IS_POSITIVE(x) ((x>=0) ? (1) : (0))

C_SCOPE int16 CalculatePhaseDif(int16 s_ar, int16 s_ai, int16 s_br, int16 s_bi)
{

   return (PhaseDifTable[2*IS_POSITIVE(s_ar)+IS_POSITIVE(s_ai)] [2*IS_POSITIVE(s_br)+IS_POSITIVE(s_bi)]);

}
