/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        mei_iof.c
*
* DESCRIPTION:     MEI interface functions
*
**************************************************************************/
#include "typedef.h"

#ifndef ADSL_62
/***** PROTOTYPES *****/
// as given in Appendix A of the Metaware High C/C++ Programmer's Guide
// (must be left commented out)
//unsigned _lr (unsigned addr);
//void _sr(unsigned val, unsigned addr);

/****************************************************************************
; Name: MEI_RegisterRead
;
; Prototype:
;  void MEI_RegisterRead(uint32 ul_addr, uint32 *pul_word);
;
; Description:
;  Function for reading an ARC MEI register
;
; Arguments:
;  ul_addr     (I)      physical address of register
;  *pul_word   (O)      32-bit data read from the register
;
;  Return Value:
;  N/A
*****************************************************************************/
void MEI_RegisterRead(uint32 ul_addr, uint32 *pul_word) {
   *pul_word = _lr(ul_addr);
}

/****************************************************************************
; Name: MEI_RegisterWrite
;
; Prototype:
;  void MEI_RegisterWrite(uint32 ul_addr, uint32 ul_word);
;
;
; Description:
;  Function for writing to an ARC MEI register
;
; Arguments:
;  ul_addr     (I)      physical address of register
;  ul_word     (I)      32-bit data to be written to the register
;
;  Return Value:
;  N/A
*****************************************************************************/
void MEI_RegisterWrite(uint32 ul_addr, uint32 ul_word) {
   _sr(ul_word, ul_addr);
}
#endif // ADSL_62
