/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2003 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp_handlemsg.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*     void ProcessTxMailbox(void)
*     int16 NewMPCheckMessage
*     void  NewMPSendMessage
*     void  NewMPHanleMessage
*
*-------------------------------------------------------------------
*/

#ifndef NMP_HANDLEMSG_C
#define NMP_HANDLEMSG_C

#define IN_NMP_PLFM_C

/*******************************************************************
*
*       Include Files
*
*******************************************************************/
#if defined(ADSL_62) && defined(TARGET_HW)
#include "hmp.h"
#else
#include "nmp.h"
#endif
#include "nmp_plfm.h"
#include <stdio.h>
#include <stdlib.h>
#include "mei_iof.h"
#include "soc_codeswap.h"
#include "cmv.h"
#ifdef DANUBE
#include "rt_state.h"
#include "trail.h"
#include "dataswap.h"
#include "gdata.h"
#endif

// Allowed values for datatype/"bitsize" field of MP word 0.
#define MP_RW_BYTE_DATA 0x1      // Read/write bytes.
#define MP_RW_WORD_DATA 0x0      // Read/write 16-bit words.
#define MP_RW_DWORD_DATA   0x2      // Read/write 32-bit doublewords.


/* The function NewMPHandleMessage() moved from nmp_plfm.c to
reduce RES page memory.  */

/*^^^
*----------------------------------------------------------------------------------
*
*       Prototype:
*        int16  NewMPHandleMessage(int16 mailbox);
*
*       Abstract:
*        This function receives the MP message and performs any required
*        variabe access. This function also sends a response (ACK) message
*        back to the sender. The hardware layer of the sender is handled
*        in the hardware layer.
*
*       Input Parameters:
*        int16 mailbox - Not used.
*
*       Returns:
*        int16 :  TRUE  If a message was received which requires modem
*                    intervention.
*              FALSE If no intervention is required
*
*       Notes:
*
*-------------------------------------------------------------------------------------
^^^*/
int16 NewMPHandleMessage(int16 mailbox)
{
   int16 FunctionOpcode, ReturnOpcode, Mode, Direction, Size;
   int16 BlockNameType, AddrField, OffsetField, ReadWriteStatus;
   int16 MemAccessError;
   int16 OperationRequired;
   int32 i;
   int16 *tmpptr;
   uint32 l_addr_32bit;
    uint16 us_WriteMask = 0xFFFF;
   int16 s_datatype;
   void *p_Src, *p_Dst;

   /* Initialize response variable */
   OperationRequired = FALSE;

   /* Grab Message Type and Subtype. */
   FunctionOpcode = (NewMPRxArray[0] >> 4) & 0xFF;
   ReturnOpcode = FunctionOpcode ^ 1;  // Invert LSB of opcode to form default return opcode.
   Mode = (FunctionOpcode >>1) & 0x1;  /* CMV mode or debug mode */
   Size = (NewMPRxArray[0] & 0x0F); // Number of data to read/write.

   AddrField = NewMPRxArray[2];
   OffsetField = NewMPRxArray[3];

   /* Grab Sender ID and Receiver ID. */
   Direction = FunctionOpcode & 0x1;

   /* Do nothing if Receiver ID is not 0. */

   if ( (Direction) != 0) return OperationRequired;

   /* Respond to message. */

   if (Mode == 0){ /* CMV mode */

      s_datatype = MP_RW_WORD_DATA; // All CMV data are currently 16 bits.

      /* Decode CMV Block Name & Offset; validate Offset is in range and determine read/write status. */
      MemAccessError = NewDecodeCMVBlockName(&BlockNameType,&ReadWriteStatus);
      /* If error found, send message to ME. */
      if (MemAccessError > 0)
      {
         /* zero out the size field for reads */
         if (FunctionOpcode == H2D_CMV_READ)
            NewMPRxArray[0] = NewMPRxArray[0] & 0xfff0;
         ReturnOpcode = D2H_ERROR_CMV_UNKNOWN;
      }

      else {

         int16 *CMVPtr;
         int32 l_PayloadOffset = 4;

         CMVPtr = (int16 *) NewCMVBlockNamePtr[BlockNameType-1];

#ifndef HERC_API
         if ((BlockNameType == NewINFOType) || (BlockNameType == NewRATEType) || (BlockNameType == NewPLAMType) || (BlockNameType == NewCNFGType) )
            {
#else
         if ((BlockNameType == NewINFOType) || (BlockNameType == NewRATEType) || (BlockNameType == NewPLAMType) || (BlockNameType == NewCNFGType) || (BlockNameType == NewAINFType) || (BlockNameType == NewMONIType) )
         {
#endif
            // If indirect reference, we have a table of pointers.
            CMVPtr = (int16 *) (((int16 **) CMVPtr) + AddrField);
            CMVPtr = *(int16 **) CMVPtr;
            if (CMVPtr == NULL){
               // This address entry not loaded yet, return error.
               NewMPRxArray[0] = NewMPRxArray[0] & 0xfff0;
               ReturnOpcode = D2H_ERROR_CMV_UNINITIALIZED_ENTRY;
               goto Finish;
            }
            CMVPtr = CMVPtr + OffsetField;
         }
         else{
            CMVPtr += AddrField;
         }
         tmpptr = CMVPtr;

         switch(FunctionOpcode)
         {
         case H2D_CMV_READ:

            if (ReadWriteStatus == WRITE_ACCESS)

               /* If BlockName.Offset is WRITE-ONLY, then send message to ME. */
            {
               NewMPRxArray[0] = NewMPRxArray[0] & 0xfff0;
               ReturnOpcode = D2H_ERROR_CMV_WRITE_ONLY;
            }
            else {

               p_Src = (void *)tmpptr;
               p_Dst = (void *)(NewMPRxArray + 4);

#ifdef DANUBE
            {  // local scope
               int32 l_XmemAddr;
               int16 s_XdmaSize;
               int16 s_Burst = 0;
               int32 l_Timeout_Cnt = 1000;
               int16 s_NonAlignedWord;
               int16 *p_MsgBufAddr = (int16 *)(NewMPRxArray + 4);

               /* Check to see if the requested CMV data had been swapped to XMEM */
               if (((l_XmemAddr = CheckSwappedDataInXmem (AddrField)) != 0) && (BlockNameType == NewINFOType))
               {
                  // XDMA can only transfer from longword aligned address correctly
                  s_NonAlignedWord = OffsetField & 1;

                  // Read the non-aligned word via ld-st operation
                  if (s_NonAlignedWord)
                  {
                     // XMEM LD-ST address = 0x80000 + Xmem Address
                     *p_MsgBufAddr = *(int16 *)(ADSL_IMAGE_BASE_ADDR + l_XmemAddr + OffsetField);
                     p_MsgBufAddr++;
                     OffsetField++;
                  }

                  l_XmemAddr += OffsetField * sizeof(int16);
                  s_XdmaSize = (Size - s_NonAlignedWord) * sizeof(int16);

                  // Do at least a longword transfer
                  if ((s_XdmaSize != 0) && (s_XdmaSize < sizeof(int32)))
                  {
                     s_XdmaSize = sizeof(int32);
                  }

                  // Workaround a XDMA problem where the returned data maybe corrupted if the
                  // starting address is at offset 4 and the size crosses a 32-byte boundary.
                  // In such case, XDMA request will be broken into two bursts, first burst
                  // transfer up to 12 bytes to align with 32-byte boundary. Then second burst
                  // finishes the XDMA.
                  if (l_XmemAddr & 4)
                  {
                     s_Burst = (s_XdmaSize > 12) ? 12 : s_XdmaSize;

                     if (RequestSwappedDataFromXmem ((int32)p_MsgBufAddr, l_XmemAddr, s_Burst) != 0)
                     {
                        gus_WarningCode = E_CODE_DATASWAP_QUEUE_BUSY_ERROR;
                        ReturnOpcode = D2H_ERROR_CMV_READ_NOT_AVAILABLE;
                        goto Finish;
                     }

                     /* XDMA the first burst of data from XMEM to message buffer */
                     do {
                        CheckForDataSwap ();
                     } while ((gt_DataSwap.c_State != DATASWAP_READY) && (--l_Timeout_Cnt > 0));

                     if (l_Timeout_Cnt == 0)
                     {
                        gus_WarningCode = E_CODE_DATASWAP_XDMA_BUSY_ERROR;
                        ReturnOpcode = D2H_ERROR_CMV_READ_NOT_AVAILABLE;
                        goto Finish;
                     }

                     /* Update XDMA source address and remaining size */
                     s_XdmaSize -= s_Burst;
                     l_XmemAddr += s_Burst;
                  }

                  // See if we need to do a second XDMA to finish up the request
                  if (s_XdmaSize > 0)
                  {
                     l_Timeout_Cnt = 1000;

                     if (RequestSwappedDataFromXmem (((int32)p_MsgBufAddr + s_Burst/2), l_XmemAddr, s_XdmaSize) != 0)
                     {
                        gus_WarningCode = E_CODE_DATASWAP_QUEUE_BUSY_ERROR;
                        ReturnOpcode = D2H_ERROR_CMV_READ_NOT_AVAILABLE;
                        goto Finish;
                     }

                     /* XDMA the rest of the data from XMEM to message buffer */
                     do {
                        CheckForDataSwap ();
                     } while ((gt_DataSwap.c_State != DATASWAP_READY) && (--l_Timeout_Cnt > 0));

                     if (l_Timeout_Cnt == 0)
                     {
                        gus_WarningCode = E_CODE_DATASWAP_XDMA_BUSY_ERROR;
                        ReturnOpcode = D2H_ERROR_CMV_READ_NOT_AVAILABLE;
                     }
                  }

                  goto Finish;
               }
               }
#endif
            }

            break;

            /* ================================================================= */
            /*                                                    */
            /* CMV WRITE                                             */
            /*                                                    */
            /* ================================================================= */

         case H2D_CMV_WRITE_MASKED:

                l_PayloadOffset = 5;
                us_WriteMask = (uint16) *(NewMPRxArray + 4);
                // Continue to next case

         case H2D_CMV_WRITE:

            if (ReadWriteStatus == READ_ACCESS)
            {
               /* If BlockName.Offset is READ-ONLY, then send message to ME. */
               ReturnOpcode = D2H_ERROR_CMV_READ_ONLY;
            }
            else {

               /* Set variable to signal the modem application */
               if ((BlockNameType == NewCNTLType) && (AddrField == 0))
               {
                  OperationRequired = TRUE;
               }
               p_Src = (void *)(NewMPRxArray + l_PayloadOffset);
               p_Dst = (void *)tmpptr;
            }
            break;

         default:
            ReturnOpcode = D2H_ERROR_OPCODE_UNKNOWN;
            break;
         }  /* switch (FunctionOpcode) */
      }
   }   /* if CMV mode */

   else{   /* Debug mode */

      l_addr_32bit = (((uint32)NewMPRxArray[2] & 0xFFFF) << 16) | (NewMPRxArray[3] & 0xFFFF);
      s_datatype = (NewMPRxArray[0] >> 14) & 0x3;

      if ((FunctionOpcode == H2D_DEBUG_READ_DM) || (FunctionOpcode == H2D_DEBUG_READ_PM))
      {
         p_Src = (void *)l_addr_32bit;
         p_Dst = (void *) (NewMPRxArray+4);
      }
      else if ((FunctionOpcode == H2D_DEBUG_WRITE_DM) || (FunctionOpcode == H2D_DEBUG_WRITE_PM))
      {
         p_Src = (void *) (NewMPRxArray+4);
         p_Dst = (void *)l_addr_32bit;
      }
      else
         ReturnOpcode = D2H_ERROR_OPCODE_UNKNOWN;

   } // if Debug mode

   if (ReturnOpcode == (FunctionOpcode^1))
      // If no error, then read/write data
   {
      if (s_datatype == MP_RW_BYTE_DATA)
      {
         memcpy(p_Dst, p_Src, Size);
      }
      else if (s_datatype == MP_RW_DWORD_DATA)
      {
         memcpy(p_Dst, p_Src, Size * sizeof(int32));
      }
        else  // (s_datatype == MP_RW_WORD_DATA)
        {
            for (i=0; i<Size; i++)
            {
                *( ((int16 *)p_Dst) + i) &= ~us_WriteMask;
                *( ((int16 *)p_Dst) + i) |=  *( ((int16 *)p_Src) + i) & us_WriteMask;
            }

        }
   }

   // We always send an acknowledgement.
   // Set flag in gs_TxMailboxState to notify ProcessTxMailbox function that an
   // MP message is ready to go out, and
   // use global variable to pass ReturnOpcode to the ProcessTxMailbox function.
   //
Finish:
   gs_MPReturnOpcode = ReturnOpcode;
   guc_MPMsgReq = 1;

   return OperationRequired;
}  /* NewMPHandleMessage */


#endif
