/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1995-2002 Aware Incorporated
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------
*
*       All Rights Reserved
*
*       40, Middlesex Turnpike , Bedford, MA 01730-1413
*       Phone (617) 276 - 4000 ; Fax (617) 276 - 4001
*
*       nmp_plfm.c
*
*       ADSL Configuration and Management protocol using the New CMV format
*
*     int16 NewMPInitialize
*     void  NewMPSetupReadyMessage(void)
*
*-------------------------------------------------------------------
*/

#ifndef NMP_PLFM_C
#define NMP_PLFM_C

#define IN_NMP_PLFM_C


/*******************************************************************
*
*       Include Files
*
*******************************************************************/

#include "ll_iof.h"
#include "aux_regs.h"
#include "nmp.h"
#include "nmp_plfm.h"
#include "mei_iof.h"
#include "soc_codeswap.h"

extern FlagT gft_AC_CLK_NotEnabled;

/* =============================================== */
/* MP Message Structure                      */
/* =============================================== */
/*
**
**              typedef struct {
**                 int16 FunctionOpcode;
**                 int16 PayloadSize;
**                 int16 GroupField;
**                 int16 AddrField;
**                 int16 IndexField;
**                 int16 PayLoad[12];
**             } MPStruct;
**
**          CR/CW format
**          ------------
**
**          Word        Contents
**
**          0           Bits 11-4 = Function Opcode,
**                      bit 5 = 0 (mode)
**                      bit 4 = Direction: 0=Host-to-DSP, 1=DSP-to-Host.
**                      bits 3-0 = payload size.
**          1           CMV group name
**          2           Address field (index into CMV array)
**          3           Offset field (for indirect addressing, this is added to address)
**          4 - 15         Payload data.
**
**          MR/MW/MRB/MWB/MRD/MWD format
**          ----------------------------
**
**          Word        Contents
**
**          0           Bits 15-14 = datatype (00=word, 01=byte, 10=dword, 11=reserved)
**                      Bits 11-4 = Function Opcode,
**                      bit 5 = 1 (mode)
**                      bit 4 = Direction: 0=Host-to-DSP, 1=DSP-to-Host.
**                      bits 3-0 = payload size, i.e number of data to read or write.
**          1
**          2           Most significant 16 bits of address
**          3           Least significant 16 bits of address
**          4 - 15         Payload data.
*/



/*^^^
*-------------------------------------------------------------------------------------
*
*     Prototype:
*        int16 NewMPInitialize(int16 Source)
*
*     Abstract:
*        This function initializes all hardware and required variables
*        for the specified MP source.
*
*       Parameters:     None
*
*       Returns:
*        int   :  Returns TRUE if initialization successful, else
*              FALSE is returned.
*
*       Notes:
*
*-------------------------------------------------------------------
^^^*/
int16 NewMPInitialize(void)
{
   int16 i;
   uint32 ul_data;
   int32 *p;
   /* Clear the Rx message available interrupt.           *
   * We only need to write a 1 to the bit being cleared. */
   MEI_RegisterWrite(MEI_INT_MC_ADDR, MEI_MSGAV_MASK);

   /* Clear the Tx message available interrupt bit.       */
   MEI_RegisterRead(MEI_INT_AC_ADDR, &ul_data);
   ul_data &= ~((uint32) ARC_MSGAV_MASK);
   MEI_RegisterWrite(MEI_INT_AC_ADDR, ul_data);

   p = (int32 *) IMB_GP_FIRST_ADDR;
   /* Clear the MEI to ARC mailbox registers */
   for(i=0; i<NUM_IMB_GP_REGISTERS; i++)
      *p++ = 0;
   p = (int32 *) OMB_GP_FIRST_ADDR;
   /* Clear the ARC to MEI mailbox registers */
   for(i=0; i<NUM_OMB_GP_REGISTERS; i++)
      *p++ = 0;

   guc_MPMsgReq=0;

   return TRUE;
}  /* MPInitialize */





#endif
