;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        round64.s
;
; DESCRIPTION:     round function for a 64-bit number
;
;*************************************************************************
.include "asm.h"

.text
;/*****************************************************************************
;  Subroutine Name: round64
;
;   Rounds a 64-bit accumulator A at "bit_position" and then shifts the result
;   right by "bit_position".  The accumulator will always be rounded away from 0;
;   e.g. if A=3 and bit_position=1, round_acc48 will return 2, and if
;   A=-3 and bit_position=1, round_acc48 will return -2.
;
;   The final result must fit within a 32-bit integer.  If the final result
;   cannot fit into a 32-bit integer a saturated result is returned; i.e.
;   if the final result is positive and greater than 0x7FFF FFFF (the maximum 32-bit integer)
;   the function will return 0x7FFF FFFF, and if the final result is negative and
;   less than 0x8000 0000 (the minimum 32-bit integer), the function will return 0x8000 0000.
;
;  Prototype:
;       int32 round64(int32 l_AccH, int32 l_AccL, int16 s_bit_position)
;
;  Input Arguments:
;     l_AccH         - The 32 MSBs of the 64-bit accumulator
;     l_AccL         - The 32 LSBs of the 64-bit accumulator
;       s_bit_position  - The lowers bit position preserved after shifting
;                       - 0 <= s_bit_position <= 31
;
;  Output Arguments:
;
;  Return:
;     Returns the rounded accum.
;
;  Global Variables:
;     none
;
;*******************************************************************************/
;int32 round64(int32 l_AccH, int32 l_AccL, int16 s_bit_position)
.global round64
round64:
   ; Input Arguments
   ; %r0 = l_AccH
   ; %r1 = l_AccL
   ; %r2 = s_bit_position
   .define l_AccH, %r0
   .define l_AccL, %r1
   .define s_bit_position, %r2

   ; parameter checking
   sub.f  0, s_bit_position, 32  ; if (s_bit_position >= 32)
   mov.ge %r0, 0
   bge    9f                  ;  return 0;
   sub.f  0, s_bit_position, 0      ; else if(s_bit_position < 0)
   mov.lt s_bit_position, 0      ;  s_bit_position = 0;

   sub.f  0, l_AccH, 0           ; check if (accumulator < 0)
   blt    1f

   ; accumulator >= 0 (positive)
   sub.f  0, s_bit_position, 0
   beq    0f

   .define l_roundConst, %r3
   .define s_accH_LS, %r4
                                 ; if (s_bit_position > 0)
   sub    l_roundConst, s_bit_position, 1
   asl    l_roundConst, 1, l_roundConst   ; l_roundConst = 1 << (s_bit_position-1)

   add.f  l_AccL, l_AccL, l_roundConst    ; if (s_bit_position > 0)
   adc.f  l_AccH, l_AccH, 0            ;  accumulator += l_roundConst
   mov.v  l_AccH, 0x7FFF_FFFF
   mov.v  l_AccL, 0xFFFF_FFFF

   sub.f  0, l_AccH, l_roundConst         ; if (l_AccH >= l_roundConst), we have overflowed.
   mov.ge %r0, MAX_32BIT_NUM           ; return the maximum positive number
   bge    9f

   sub  s_accH_LS, 32, s_bit_position
   asl  l_AccH, l_AccH, s_accH_LS

   lsr  l_AccL, l_AccL, s_bit_position
   or   %r0, l_AccH, l_AccL
   b    9f

   0: ; if (s_bit_position == 0)
   sub.f  0, l_AccH, 0                 ; we already know that l_AccH >= 0
   mov.ne %r0, MAX_32BIT_NUM           ; if (l_AccH != 0), we have overflowed.
   bne    9f                        ; return the maximum positive number

   sub.f  0, l_AccL, 0                 ; if (l_AccL < 0), then we have a positive number that
                                 ; must be represented by 33 bits
   mov.lt %r0, MAX_32BIT_NUM           ; return the maximum positive number
   mov.ge %r0, l_AccL                  ; else return l_AccL
   b   9f

   .undef l_roundConst
   .undef s_accH_LS

   1: ; accumulator < 0 (negative)
   .define s_overflowBit, %r3
   .define l_roundConst, %r4
   .define s_overflowBase, %r5
   .define s_accH_LS, %r6
   sub.f  0, s_bit_position, 0
   beq    0f

   sub    s_overflowBit, s_bit_position, 1      ; s_overflowBit = the bit in the upper accumulator
                                    ;  that determines whether we have saturated
                                    ;  = s_bit_position - 1
   asl    l_roundConst, 1, s_overflowBit
   sub.f  0, s_bit_position, 1
   sub.ne l_roundConst, l_roundConst, 1
   add.f  l_AccL, l_AccL, l_roundConst
   adc    l_AccH, l_AccH, 0

   asr    s_overflowBase, l_AccH, s_overflowBit
   sub.f  0, s_overflowBase, 0
   mov.eq %r0, 0
   beq     9f

   sub.f  0, s_overflowBase, -1
   mov.lt %r0, MIN_32BIT_NUM
   blt    9f

   sub    s_accH_LS, 32, s_bit_position
   asl    l_AccH, l_AccH, s_accH_LS

   lsr    l_AccL, l_AccL, s_bit_position
   or     %r0, l_AccH, l_AccL
   b      9f

   0: ; if (s_bit_position == 0)
   sub.f  0, l_AccH, -1             ; we already know that l_AccH < 0
   mov.lt %r0, MIN_32BIT_NUM           ; if (l_AccH < 0xFFFFFFFF), we have overflowed.
   blt    9f                        ; return the largest negative number

   sub.f  0, l_AccL, 0                 ; if (l_AccL >= 0), then we have a positive number that
                                 ; must be represented by 33 bits
   mov.ge %r0, MIN_32BIT_NUM           ; return the largest negative number
   mov.lt %r0, l_AccL                  ; else return l_AccL
   b   9f

   .undef s_overflowBit
   .undef l_roundConst
   .undef s_overflowBase
   .undef s_accH_LS

   9:
   j  [%blink]
