/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2003 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   rxinvfiltcoef.c
 *
 *   Function to return Rx Inverse Filter Coefficient for AFE
 *
 *
 *----------------------------------------------------------------------------
 */
//**************************************************************************************************************************
// rxinvfiltcoef.c
//
// History
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
// 30/08/2011 Sriram Shastry :  QLN/HLOG calibration for Annex-A DMT, ADSL2/2+. Calibration is done with respect to the
// line simulator generated refernce data.
//             Grep for "XDSLRTFW-211 Enhance_DS_ALL_ALL_Delt_Calibration"
//
// 22/03/2013 Prashant Patil :  QLN/HLOG calibration for Annex-B DMT, ADSL2/2+.
//             Grep for "XDSLRTFW-758 PERF_DS_ALL_ALL_AnnexB_QLN_Calibration"
//
// 26/03/2013 Prashant Patil : LATN calibration for AnnexB. There was 3db offset in Bis/PLUS mode and 4db offset
//                             in DMT mode for DS LATN compared to reference LATN value.
//             Grep for "XDSLRTFW-775 PERF_DS_ALL_ALL_AnnexB_LATN_Calibration"
//
// 24/06/2013 Prashant Patil : Hlog calibration for AnnexB DMT/Bis.
//             Grep for "XDSLRTFW-895 BugFix_DS_DmtBis_ALL_AnnexB_HLOG"
//
//**************************************************************************************************************************

#include "common.h"
#include "diagparam_bis.h"
#include "data_alloc.h"
#include "afe.h"
#include "cmv.h"
#include "gdata_bis_diag.h"
#include "gpersistent.h"
#include "gdata.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : RxInvFiltCoef()
 *
 *  Description:  Returns AFE specific Rx Inverse filter coefficient in (dB) Q9.7
 *          for given tone for compensation of the Rx Filter effects from
 *          the received signal (This includes the PGA, Rx System Gain, and Rxfilter)
 *          (May have to interpolate subsampled Filter coefficients here)
 *          s_chan < 0 is used to indicate that this function should return the
 *          minimum Rxfilter coefficient (thus resulting in maximimum compensation value)
 *
 *  Prototype:
 *    int16 RxInvFiltCoef(int16 s_chan)
 *
 *  Input Arguments:
 *    int16  s_chan        - tone number to be compensated
 *
 *  Output Arguments:
 *
 *  Return:
 *      int16 AFE Rx Inverse Filter compensation coefficient in (dB) Q9.7
 *
 *  Global Variables Used:
 *    gsa_RxAFEfiltHFB_on_dB, gsa_RxAFEfiltHFB_off_dB    -- (I) Rx filter compensation in dB
 *
 *  Notes: dB operations performed in Q9.7 to handle lowest possible realistic values for QLN
 *
 *------------------------------------------------------------------------
 *^^^
 */
C_SCOPE int16 RxInvFiltCoef(int16 s_chan)
{
   int16 s_InvFiltCoefValue = 0, s_index, *psa_Rxfilter_comp_dB, s_MaxValCompChannel;
   int16 s_FilterCalDone = 1, s_compoffset = 0;

   if (gft_DiagAfeRxCalibration==0)
   {

      if (gl_SelectedMode & (MODE_G992_5))
      {
#ifdef ISDN
         //Anx B
         /* Plus vector downsampled by four. */
         psa_Rxfilter_comp_dB = gsa_VR9_PlusRxAFEFilt_dB;
#else
         //Anx A
         psa_Rxfilter_comp_dB = gsa_VR9_AnxA_PlusRxAFEFilt_dB;
#endif    //ifdef ISDN
         /* The channel with the minimum value for Rx Filter will have */
         /* maximum compensation. */
         s_MaxValCompChannel = 0;
      }
      else if (gl_SelectedMode & (MODE_G992_3)) // Bis
      {
#ifdef ISDN
         //Anx B
         /* Bis vector downsampled by two (equalizer is always off). */
         psa_Rxfilter_comp_dB = gsa_VR9_BisRxAFEFilt_dB;
#else
         //Anx A
         psa_Rxfilter_comp_dB = gsa_VR9_AnxA_BisRxAFEFilt_dB;
#endif    //ifdef ISDN
         s_MaxValCompChannel = gs_MinValBisChan_VR9;
      }  // BIS
      else  // DMT
      {
#ifdef ISDN
         //Anx B
         /* DMT vector downsampled by two (equalizer is always off). */
         psa_Rxfilter_comp_dB = gsa_VR9_DMTRxAFEFilt_dB;
#else
         //Anx A
         psa_Rxfilter_comp_dB = gsa_VR9_AnxA_DmtRxAFEFilt_dB;
#endif  //ifdef ISDN
         s_MaxValCompChannel = gs_MinValBisChan_VR9;
      }  // DMT

      if (s_FilterCalDone) // check that filter calibration is done
      {
         // For PLUS interpolate by 4
         if (gl_SelectedMode & (MODE_G992_5))
         {
            /* Subract off first channel of array. */
            s_chan -= RX_FILTERCOMP_FIRST_CHAN_PLUS;

            // interpolate the samples by 4
            if(s_chan >= 0)
            {
               s_index = s_chan>>2;

#ifdef ISDN
               // XDSLRTFW-758 PERF_DS_ALL_ALL_AnnexB_QLN_Calibration (Start_End)
                   //s_compoffset = 422;  //3.3dB
               s_compoffset = 0;  //0.0dB

               // XDSLRTFW-775 PERF_DS_ALL_ALL_AnnexB_LATN_Calibration (Start)
               if (gs_RxState == R_C_REVERB3_RX_BIS)
                  {
                           s_compoffset = 300;
                  }
               // XDSLRTFW-775 PERF_DS_ALL_ALL_AnnexB_LATN_Calibration (End)
#else
                   s_compoffset = 0;
#endif
               switch(s_chan & 0x3)
               {
               case 0:
                  s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_index]-s_compoffset;
                  break;
               case 1:
                  /* linearly interpolate these points */
                  s_InvFiltCoefValue = (int16)(((int32)3*(psa_Rxfilter_comp_dB[s_index]-s_compoffset) + psa_Rxfilter_comp_dB[s_index+1] - s_compoffset + 2) >> 2);
                  break;
               case 2:
                  s_InvFiltCoefValue = (int16)((((int32)psa_Rxfilter_comp_dB[s_index] - s_compoffset) + (psa_Rxfilter_comp_dB[s_index+1] - s_compoffset) + 1) >> 1);
                  break;
               case 3:
                  s_InvFiltCoefValue = (int16)((((int32)psa_Rxfilter_comp_dB[s_index] - s_compoffset) + (int32)3*(psa_Rxfilter_comp_dB[s_index+1] - s_compoffset) + 2) >> 2);
                  break;
               }
            }
            else
               s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_MaxValCompChannel];
         } // PLUS
         else
         {
            // BIS/ DMT
            s_chan -= RX_FILTERCOMP_FIRST_CHAN_BIS;      //Subtract off first channel of array;

            // interpolate by 2
            if(s_chan >= 0)
            {
               s_index = s_chan>>1;

#ifdef ISDN
               // XDSLRTFW-758 PERF_DS_ALL_ALL_AnnexB_QLN_Calibration (Start_End)
               //s_compoffset = 153;  //1.2dB (to account for bug due to change of hybrid)
               s_compoffset = 0;  //1.2dB (to account for bug due to change of hybrid)

               // XDSLRTFW-775 PERF_DS_ALL_ALL_AnnexB_LATN_Calibration (Start)
               // XDSLRTFW-895 BugFix_DS_DmtBis_ALL_AnnexB_HLOG (Start)
               if (gs_RxState == R_C_MEDLEY_RX || gs_RxState == R_C_REVERB3_RX_BIS)
                  {
                     // s_compoffset = 0x0400;  //4.0dB (to account for bug due to change of hybrid)
                  s_compoffset = 0x80;  // 0.5dB (to account for bug due to change of hybrid)
                  }
               // XDSLRTFW-895 BugFix_DS_DmtBis_ALL_AnnexB_HLOG (End)
               // XDSLRTFW-775 PERF_DS_ALL_ALL_AnnexB_LATN_Calibration (End)
#else
                   s_compoffset = 0;
#endif
               if((s_chan & 0x1) == 0)
                  s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_index] - s_compoffset;
               else
               {
                  // interpolate subsampled psa_Rxfilter_comp_dB
                  s_InvFiltCoefValue = (int16)((((int32)psa_Rxfilter_comp_dB[s_index] - s_compoffset) + (psa_Rxfilter_comp_dB[s_index+1] - s_compoffset) + 1) >> 1);
               }

            }   //s_chan >= 0
            else
            {
               s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_MaxValCompChannel];
            }

         }

      } // s_FilterCalDone == 1
      else
      {
         // AFE not calibrated
         s_InvFiltCoefValue = gs_DiagRxCalibrateConstant;
      }
   }

   else // gft_DiagAfeRxCalibration =1
   {
      s_InvFiltCoefValue = gs_DiagRxCalibrateConstant;
   }

   return(s_InvFiltCoefValue);
}
// Feature_DS_BisPlus_ALL_VR9QLNCalib (End)


#ifdef AMAZON_AFE
C_SCOPE int16 RxInvFiltCoef(int16 s_chan)
{
   int16 s_InvFiltCoefValue, s_index, *psa_Rxfilter_comp_dB, s_MaxValCompChannel;

   if (gft_DiagAfeRxCalibration == 0)
   {
      if (( gl_SelectedMode & (MODE_G992_5)  ))
      {
         /* Plus vector downsampled by four. */
         if (gs_HPFEq_Reg_Setting & EQUALIZER_ON)
         {
            psa_Rxfilter_comp_dB = gsa_Amazon_PlusRxAFEFiltEqOn_dB;
            /* The channel with the minimum value for Rx Filter will have */
            /* maximum compensation. */
            s_MaxValCompChannel = gs_MinValPlusChan_AmazonEqOn;
         }
         else
         {
            psa_Rxfilter_comp_dB = gsa_Amazon_PlusRxAFEFiltEqOff_dB;
            s_MaxValCompChannel = gs_MinValPlusChan_AmazonEqOff;
         }

         /* Subract off first channel of array. */
         s_chan -= RX_FILTERCOMP_FIRST_CHAN_PLUS;
         if (s_chan >= 0)
         {
            /* Linearly interpolate points between values in the table. */
            s_index = s_chan >> 2;
#if defined (DANUBE) && defined (ISDN)

                int16 s_plus_Rxfilter_comp_dB_0 = psa_Rxfilter_comp_dB[s_index];
                int16 s_plus_Rxfilter_comp_dB_1 = psa_Rxfilter_comp_dB[s_index+1];
                if (gs_RxState == R_C_REVERB3_RX_BIS)
                {
                   s_plus_Rxfilter_comp_dB_0 -= 300;
                   s_plus_Rxfilter_comp_dB_1 -= 300;
                }
                switch (s_chan & 0x3)
            {
            case 0:
               s_InvFiltCoefValue = s_plus_Rxfilter_comp_dB_0;
               break;
            case 1:
               s_InvFiltCoefValue = (int16)(((int32)3*s_plus_Rxfilter_comp_dB_0 + s_plus_Rxfilter_comp_dB_1 + 2) >> 2);
               break;
            case 2:
               s_InvFiltCoefValue = (int16)(((int32)s_plus_Rxfilter_comp_dB_0 + s_plus_Rxfilter_comp_dB_1 + 1) >> 1);
               break;
            case 3:
               s_InvFiltCoefValue = (int16)(((int32)s_plus_Rxfilter_comp_dB_0 + (int32)3*s_plus_Rxfilter_comp_dB_1 + 2) >> 2);
               break;
            }

#else
                switch (s_chan & 0x3)
            {
            case 0:
               s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_index];
               break;
            case 1:
               s_InvFiltCoefValue = (int16)(((int32)3*psa_Rxfilter_comp_dB[s_index] + psa_Rxfilter_comp_dB[s_index+1] + 2) >> 2);
               break;
            case 2:
               s_InvFiltCoefValue = (int16)(((int32)psa_Rxfilter_comp_dB[s_index] + psa_Rxfilter_comp_dB[s_index+1] + 1) >> 1);
               break;
            case 3:
               s_InvFiltCoefValue = (int16)(((int32)psa_Rxfilter_comp_dB[s_index] + (int32)3*psa_Rxfilter_comp_dB[s_index+1] + 2) >> 2);
               break;
            }

#endif
         }
         else
         {
            s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_MaxValCompChannel];
         }
      }
      else
      {
         /* Bis vector downsampled by two (equalizer is always off). */
         psa_Rxfilter_comp_dB = gsa_Amazon_BisRxAFEFiltEqOff_dB;
         s_MaxValCompChannel = gs_MinValBisChan_AmazonEqOff;

         /* Subract off first channel of array. */
         s_chan -= RX_FILTERCOMP_FIRST_CHAN_BIS;
         if (s_chan >= 0)
         {
            /* Linearly interpolate points between values in the table. */
            s_index = s_chan >> 1;
#if defined (DANUBE) && defined (ISDN)

                int16 s_Rxfilter_comp_dB_0 = psa_Rxfilter_comp_dB[s_index];
                int16 s_Rxfilter_comp_dB_1 = psa_Rxfilter_comp_dB[s_index+1];

                if (gs_RxState == R_C_MEDLEY_RX || gs_RxState == R_C_REVERB3_RX_BIS)
                {
                  s_Rxfilter_comp_dB_0 -= 500;
                  s_Rxfilter_comp_dB_1 -= 500;
                }

            if ((s_chan & 0x1) == 0)
            {
               s_InvFiltCoefValue =  s_Rxfilter_comp_dB_0;
            }
            else
            {
               s_InvFiltCoefValue = (int16)(((int32)s_Rxfilter_comp_dB_0 + (int32)s_Rxfilter_comp_dB_1 + 1) >> 1);
            }
#else
               if ((s_chan & 0x1) == 0)
            {
               s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_index];
            }
            else
            {
               s_InvFiltCoefValue = (int16)(((int32)psa_Rxfilter_comp_dB[s_index] + psa_Rxfilter_comp_dB[s_index+1] + 1) >> 1);
            }
#endif
         }
         else
         {
            s_InvFiltCoefValue = psa_Rxfilter_comp_dB[s_MaxValCompChannel];
         }
      }
   }
   else
   {
      s_InvFiltCoefValue = gs_DiagRxCalibrateConstant;
   }

   return(s_InvFiltCoefValue);
}
#endif
