/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        vecmult.c
*
* DESCRIPTION:     Function for computing product of two scalar arrays
*
**************************************************************************/

#include "xy_iof.h"
#include "gdata.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : VectorMultiply
 *
 *  Description:
 *    This routine multiplies and shifts together, two arrays to form a single
 *    array, which is of the same size as the input arrays. The two arrays in Y
 *    memory can be at the same location but otherwise they must not overlap.
 *
 * Memory Allocation:
 *    The two arrays in Y memory can be at the same location but otherwise they
 *    must not overlap. The sizes of each of the arrays is "s_length" words.
 *
 * Algorithm:
 *
 *    The routine cycles through each element of the two arrays performing a
 *    multiplication followed by a right shift and storing the results to Y
 *    memory in the same order.
 *
 *  Prototype:
 *    void VectorMultiply(int16 *psa_destbuf, int16 *psa_srcbuf1, int16 *psa_srcbuf2, int16 *psa_resultShift, int16 s_length)
 *
 *  Input Arguments:
 *    int16 *psa_srcbuf1      - Pointer to input vector 1 in X memory
 *    int16 *psa_srcbuf2      - Pointer to input vector 2 in Y memory
 *    int16 *psa_resultShift  - Pointer to input vector 3 in X memory
 *    int16 length         - Number of elements in array
 *
 *  Output Arguments:
 *    int16 *psa_destbuf      - Pointer to output vector in Y memory
 *
 *  Return:
 *
 *  Notes:
 *    -  vector_D = (vector_A * vector_B) >> Shift_Vector_C
 *    - Elements of Shift_Vector_C must be within the following range
 *       0 <= x <= 16
 *    - Elements of all the other vectors are assumed to be signed words
 *       ie 0x8000 <= x <=0x7fff
 *    - No saturation checks are performed
 *    - Dual MAC implementation. Hence, best if length of vector is multiple
 *    of 2. No gurantees otherwise!
 *------------------------------------------------------------------------
 *^^^
 */
void VectorMultiplyLoop(int32 dest_arr, int32 src_arr1, int32 src_arr2, int32 src_shift_arr, int16 length);
void VectorMultiply(int16 *psa_destbuf, int16 *psa_srcbuf1, int16 *psa_srcbuf2, int16 *psa_resultShift, int16 s_length)
{
   int32 l_vectorOutputY, l_vectorInputX, l_vectorInputY, l_vectorOutputShiftX;

   if(CheckXYAddrRange((int32 *)(void *)psa_srcbuf1, X_MEM) == FAIL)
      return;
   l_vectorInputX = XYAddrDecode((int32 *)(void *)psa_srcbuf1, ADDR_MODE_32);

   if(CheckXYAddrRange((int32 *)(void *)psa_srcbuf2, Y_MEM) == FAIL)
      return;
   l_vectorInputY = XYAddrDecode((int32 *)(void *)psa_srcbuf2, ADDR_MODE_32);

   if(CheckXYAddrRange((int32 *)(void *)psa_resultShift, X_MEM) == FAIL)
      return;
   l_vectorOutputShiftX = XYAddrDecode((int32 *)(void *)psa_resultShift, ADDR_MODE_16);

   if(CheckXYAddrRange((int32 *)(void *)psa_destbuf, Y_MEM) == FAIL)
      return;
   l_vectorOutputY = XYAddrDecode((int32 *)(void *)psa_destbuf, ADDR_MODE_16);

   VectorMultiplyLoop(l_vectorOutputY, l_vectorInputX, l_vectorInputY, l_vectorOutputShiftX, s_length);
}
