/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        vecpwr.c
*
* DESCRIPTION:     Function for computing total power in complex vector
*
**************************************************************************/

#include "typedef.h"
#include "dsp_op.h"
#include "rx_ops.h"
#include "xy_iof.h"

/*^^^
 *------------------------------------------------------------------------
 *
 *  Name : VectorPower
 *
 *  Description:  Computes the total power of a 16-bit signed vector X.
 *             If the vector X is represented as X[0], X[1], X[2], etc...
 *             the return value is:
 *
 *             Sum {i=0 to ndata-1} ((X[i]*X[i] + (ROUND_CNST) >> s_GuardBits)
 *
 *             where the rounding constant ROUND_CNST = 1<<(s_GuardBits-1).
 *  Prototype:
 *    int32 VectorPower(int16 *psa_databuf, int16 s_ndata, int16 s_GuardBits)
 *
 *  Input Arguments:
 *    int16 *psa_databuf - Pointer to the vector; vector must reside in
 *                           gsa_RxToneBuf or gla_RxAccumBuf
 *      int16 s_ndata      - length of the vector
 *      int16 s_GuardBits  - the LSB preserved after rounding and shifting;
 *                           0 <= s_GuardBits <= 31
 *
 *  Output Arguments:
 *
 *  Return:
 *      int32 l_power    - total power
 *
 *  Notes:
 *      1.  The sum is accumulated in 2 40-bit accumulators and is not guaranteed to be
 *          valid for s_ndata > 2^9 = 512.
 *      2.  psa_databuf must be aligned to a longword boundary
 *------------------------------------------------------------------------
 *^^^
 */
int32 VectorPowerLoop(int32 psa_databuf, int16 s_ndata, int16 s_GuardBits, int16 s_XYmemory);
int32 VectorPower(int16 *psa_databuf, int16 s_offset, int16 s_ndata, int16 s_GuardBits)
{
   int32 psa_databufXY;
   int32 l_rx_power;
   int16 s_XYmemory;

   if(CheckXYAddrRange((int32 *)(void *)psa_databuf, X_MEM) == PASS)
      s_XYmemory = 0;   //X_MEM
   else if(CheckXYAddrRange((int32 *)(void *)psa_databuf, Y_MEM) == PASS)
      s_XYmemory = 1;   //Y_MEM
   else
      return 0;

   psa_databufXY = XYAddrDecode((int32 *)(void *)(&psa_databuf[s_offset]), ADDR_MODE_32);

   l_rx_power = VectorPowerLoop(psa_databufXY, s_ndata, s_GuardBits, s_XYmemory);
   return l_rx_power;
}
