/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   version.c
 *
 *   Variables containing version string.
 *
 *------------------------------------------------------------------------
 */
#include <typedef.h>
#include <version.h>

//XDSLRTFW-3364 (Start)

#define ASCII_MAP_FOR_0 (0x30)
#define ASCII_MAP_FOR_7 (0x37)


#if (((VERSION_PLATFORM & 0XF0)>>4) < 10)
#define STR_VERSION_PLATFORM_HI (ASCII_MAP_FOR_0 + ((VERSION_PLATFORM & 0XF0) >> 4))
#else
#define STR_VERSION_PLATFORM_HI (ASCII_MAP_FOR_7 + ((VERSION_PLATFORM & 0XF0) >> 4))
#endif

#if ((VERSION_PLATFORM & 0XF) < 10)
#define STR_VERSION_PLATFORM_LO (ASCII_MAP_FOR_0 + (VERSION_PLATFORM & 0XF))
#else
#define STR_VERSION_PLATFORM_LO (ASCII_MAP_FOR_7 + (VERSION_PLATFORM & 0XF))
#endif

#if (((VERSION_FEATURE & 0XF0)>>4) < 10)
#define STR_VERSION_FEATURE_HI (ASCII_MAP_FOR_0 + ((VERSION_FEATURE & 0XF0) >> 4))
#else
#define STR_VERSION_FEATURE_HI (ASCII_MAP_FOR_7 + ((VERSION_FEATURE & 0XF0) >> 4))
#endif

#if ((VERSION_FEATURE & 0XF) < 10)
#define STR_VERSION_FEATURE_LO (ASCII_MAP_FOR_0 + (VERSION_FEATURE & 0XF))
#else
#define STR_VERSION_FEATURE_LO (ASCII_MAP_FOR_7 + (VERSION_FEATURE & 0XF))
#endif

#if (VERSION_MAJOR < 10)
#define STR_VERSION_MAJOR    (ASCII_MAP_FOR_0 + (VERSION_MAJOR & 0xF))
#else
#define STR_VERSION_MAJOR    (ASCII_MAP_FOR_7 + (VERSION_MAJOR & 0xF))
#endif

#if (VERSION_MINOR < 10)
#define STR_VERSION_MINOR    (ASCII_MAP_FOR_0 + (VERSION_MINOR & 0xF))
#else
#define STR_VERSION_MINOR    (ASCII_MAP_FOR_7 + (VERSION_MINOR & 0xF))
#endif

#if (VERSION_REL_STATUS < 10)
#define STR_VERSION_REL_STATUS (ASCII_MAP_FOR_0 + (VERSION_REL_STATUS & 0xF))
#else
#define STR_VERSION_REL_STATUS (ASCII_MAP_FOR_7 + (VERSION_REL_STATUS & 0xF))
#endif

#if (((VERSION_APP_NUM & 0X30)>>4) < 10)
#define STR_VERSION_APP_NUM_HI (ASCII_MAP_FOR_0 + ((VERSION_APP_NUM & 0X30) >> 4))
#else
#define STR_VERSION_APP_NUM_HI (ASCII_MAP_FOR_7 + ((VERSION_APP_NUM & 0X30) >> 4))
#endif

#if ((VERSION_APP_NUM & 0XF) < 10)
#define STR_VERSION_APP_NUM_LO (ASCII_MAP_FOR_0 + (VERSION_APP_NUM & 0XF))
#else
#define STR_VERSION_APP_NUM_LO (ASCII_MAP_FOR_7 + (VERSION_APP_NUM & 0XF))
#endif

#if (((VERSION_TEST_FW_SOURCE & 0XF0)>>4) < 10)
#define STR_VERSION_TEST_FW_SOURCE_HI (ASCII_MAP_FOR_0 + ((VERSION_TEST_FW_SOURCE & 0XF0) >> 4))
#else
#define STR_VERSION_TEST_FW_SOURCE_HI (ASCII_MAP_FOR_7 + ((VERSION_TEST_FW_SOURCE & 0XF0) >> 4))
#endif

#if ((VERSION_TEST_FW_SOURCE & 0XF) < 10)
#define STR_VERSION_TEST_FW_SOURCE_LO (ASCII_MAP_FOR_0 + (VERSION_TEST_FW_SOURCE & 0XF))
#else
#define STR_VERSION_TEST_FW_SOURCE_LO (ASCII_MAP_FOR_7 + (VERSION_TEST_FW_SOURCE & 0XF))
#endif

#if (((VERSION_TEST_FW_NUM & 0XF0)>>4) < 10)
#define STR_VERSION_TEST_FW_NUM_HI (ASCII_MAP_FOR_0 + ((VERSION_TEST_FW_NUM & 0XF0) >> 4))
#else
#define STR_VERSION_TEST_FW_NUM_HI (ASCII_MAP_FOR_7 + ((VERSION_TEST_FW_NUM & 0XF0) >> 4))
#endif

#if ((VERSION_TEST_FW_NUM & 0XF) < 10)
#define STR_VERSION_TEST_FW_NUM_LO (ASCII_MAP_FOR_0 + (VERSION_TEST_FW_NUM & 0XF))
#else
#define STR_VERSION_TEST_FW_NUM_LO (ASCII_MAP_FOR_7 + (VERSION_TEST_FW_NUM & 0XF))
#endif

#define DOT              '.'
#define XTRACHAR1        '@'
#define XTRACHAR2        '('
#define XTRACHAR3        '#'
#define XTRACHAR4        ')'
#define LASTCHAR         '\0'
#define UNDERSCORE       '_'

#if (VERSION_REL_STATUS < 3)
   static const unsigned char what[] =
   {
      XTRACHAR1, XTRACHAR2, XTRACHAR3, XTRACHAR4,
      STR_VERSION_PLATFORM_LO, DOT,
      STR_VERSION_FEATURE_LO, DOT,
      STR_VERSION_MAJOR, DOT,
      STR_VERSION_MINOR, DOT,
      STR_VERSION_REL_STATUS, DOT,
      STR_VERSION_APP_NUM_LO, LASTCHAR
   };
#else
   static const unsigned char what[] =
   {
      XTRACHAR1, XTRACHAR2, XTRACHAR3, XTRACHAR4,
      STR_VERSION_PLATFORM_LO, DOT,
      STR_VERSION_FEATURE_LO, DOT,
      STR_VERSION_MAJOR, DOT,
      STR_VERSION_MINOR, DOT,
      STR_VERSION_REL_STATUS, DOT,
      STR_VERSION_APP_NUM_LO, UNDERSCORE,
      //STR_VERSION_TEST_FW_SOURCE_HI, STR_VERSION_TEST_FW_SOURCE_LO, DOT, // !! DO NOT USE THE FIELD VERSION_TEST_FW_SOURCE!! Reserved for future use
      STR_VERSION_TEST_FW_NUM_HI, STR_VERSION_TEST_FW_NUM_LO, LASTCHAR
   };
#endif

   //Refer to CMV INFO 54 in Message Catalog ver 2.9 or newer for format
   uint16 gusa_FW_version_number[5] =
   {
         (((VERSION_PLATFORM & 0xF) << 12) |\
          ((VERSION_FEATURE & 0xF) << 8) |\
          ((VERSION_MAJOR & 0xF) << 4) |\
          (VERSION_MINOR & 0xF)),

         (((VERSION_REL_STATUS & 0x3) << 8) |\
          (VERSION_APP_NUM & 0x3F)),

#if (VERSION_REL_STATUS < 3)
         (0),
#else
         //(((VERSION_TEST_FW_SOURCE & 0xFF) << 8) | (VERSION_TEST_FW_NUM & 0xFF)), // !! DO NOT USE THE FIELD VERSION_TEST_FW_SOURCE!! Reserved for future use
         (VERSION_TEST_FW_NUM & 0xFF),
#endif

         (0), //Value to be over written with 'Rx Microcode version number' at entry to showtime

         (0)  //Value to be over written with 'Tx Microcode version number' at entry to showtime
   };

//XDSLRTFW-3364 (End)
