/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2001 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Confidential.
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276 - 4000
 *   Fax   (781) 276 - 4001
 *
 *   version_amazonse.c
 *
 *   Variables containing version string.
 *
 *------------------------------------------------------------------------
 */
#include <typedef.h>

#ifdef AMAZON_AFE

   /***********************************************************************************************
   the FW "internal" version number consists of 4 8 bit fields:

   - 8 bit Version Major
   - 8 bit Version Minor
   - 16 bit Build

   since only 16 bits of this information can be transmitted in HS, the following bits are chosen:
   - 4 bit Version Major (4 least significant bits)
   - 8 bit Version Minor
   - 4 bit Build (4 most significant bits)

   Version Major describes the HW the FW is built for. Amazon-M has Version Major = 1.

   Version Minor is the FW version number.

   Build increments as new "sub versions" of a version (= version minor) get available and also codes other
   relevant information. The most significant 4 bits are those that are also transmitted in the HS message.
   The first build number of a new FW version is always 0.

   The next 4 bits of Build are for numbering of internal versions. This should also start with 0 for F1.0.
   The next 2 bits show the release state of the FW (0: released, 1: pre-release, i.e. testing is
   ongoing, 2: internal development version)
   The last 6 bit of the Build are used to indicate the "special application" of the respective
   binary (e.g. AnnexA: 1, AnnexB: 2, other binaries will be defined as they become relevant)

      Major.Minor.BuildVersionMSBExternal.BuildVersionLSBInternal.ReleaseState.SpecialApp

   ***********************************************************************************************/

   #define VERSION_MAJOR   3  /*    - 8 bit Version Major */
   #define VERSION_MINOR   3     /*    - 8 bit Version Minor */
   // 16 Bit Build
   #define SUBVERSION_OF_A_VERSION_MINOR  0   // Most significant 4 bits (External Build Number)
   #define INTERNALVERSIONS      1   // Next 4 bits (Internal Build Number : 0: First Release, 1: Second Release...)

   #define RELEASE_STATE_OF_FW      1  // Next 2 bits show the release state of the FW
                     // 0: released after IQ/FW testing to external customers
                     // 1: IQ/FW testing going on
                     // 2: internal development.


   /* The last 6 bits of the Build are used to indicate the "special application" of the respective
   binary (e.g. AnnexA: 1, AnnexB: 2, other binaries will be defined as they become relevant) */
   #ifdef ISDN
      #define FIRMWARE_MODE      2  // 1= Annex A, 2 = Annex B
   #else
      #define FIRMWARE_MODE      1  // 1= Annex A, 2 = Annex B
   #endif

   #define BYTE_1    VERSION_MAJOR
   #define BYTE_2    VERSION_MINOR
   #define BYTE_3    ((SUBVERSION_OF_A_VERSION_MINOR << 4) | (INTERNALVERSIONS))
   #define BYTE_4    ((RELEASE_STATE_OF_FW << 6) | (FIRMWARE_MODE))

   uint8 guca_VersionString[16]   = {BYTE_1, BYTE_2, BYTE_3, BYTE_4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

#else

/* Format of version string: PP-BRR.r.p.b-vvv
 *
 * PP  = project code
 * B   = build type (A = alpha, B = beta, R = release)
 * RR  = major revision number
 * r   = minor revision number
 * p   = patch number
 * b   = patch build number
 * vvv = variant indicator (for personal builds and special customer requests)
 *
 */

   uint8 guca_VersionString[]   = "CC-R01.0.0.0-000";
#endif
