/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*************************************************************************
* Aware DMT Technology. Proprietary and Confidential.
*
* ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
* TELEPHONE:       781.276.4000
* FAX:             781.276.4001
* WEB:             http://www.aware.com
*
* FILENAME:        xy_iof.c
*
* DESCRIPTION:     Functions for interfacing the XY memory
*
**************************************************************************/
#include "common.h"
#include "xy_iof.h"
#include "gdata.h"
#include "socrates_memrymap.h"

#define CHECK_XY_ADDR

int32 XYAddrDecode(int32 *pla_input, FlagT ft_AddrMode)
{
   int32 pla_input_in_words;

#ifdef ADSL_62
    // X-mem and Y-mem are 4K bytes
    if ((X_BEGIN <= (int32)pla_input) && (int32)pla_input < (X_BEGIN + 4*1024))
    {
      pla_input_in_words = (int32)pla_input - X_BEGIN;
    }
    else if ((Y_BEGIN <= (int32)pla_input) && (int32)pla_input < (Y_BEGIN + 4*1024))
    {
      pla_input_in_words = (int32)pla_input - Y_BEGIN;
    }
    else
    {
      return(ADDR_NOT_IN_XY);
    }

   if(ft_AddrMode == ADDR_MODE_16)
    {
      pla_input_in_words >>= 1;
    }
    else
    {
      pla_input_in_words >>= 2;
    }

   return(pla_input_in_words);

#else
   /* addr relative to XY Base Addr in words */
   pla_input_in_words = ( ((int32)pla_input -  XY_BASE_ADDR_IN_BYTES) >> LOG2_BYTES_PER_WORD );

    #ifdef CHECK_XY_ADDR
   if( (pla_input_in_words < XY_BUF_START) ||
      (pla_input_in_words >= XY_BUF_END) )
   {
      return(ADDR_NOT_IN_XY);
   }
    #endif

   if( pla_input_in_words > X_BUF_END) // Y memory
   {
      pla_input_in_words -= X_BUF_SIZE;
   }

   if(ft_AddrMode == ADDR_MODE_16)
      return(pla_input_in_words);
   else
      return(pla_input_in_words >> 1);
#endif

}

FlagT CheckXYAddrRange(int32 *pla_buf, int16 s_bufId) {

#ifdef CHECK_XY_ADDR
   #ifdef ADSL_62
        if ((s_bufId == X_MEM) && (X_BEGIN <= (int32)pla_buf) && (int32)pla_buf < (X_BEGIN + 4*1024))
        {
            return PASS;
        }
        else if ((s_bufId == Y_MEM) && (Y_BEGIN <= (int32)pla_buf) && (int32)pla_buf < (Y_BEGIN + 4*1024))
        {
            return PASS;
        }

        return FAIL;
   #else
      int16 i;
      /* addr relative to XY Base Addr in words */
      int32 pla_input_in_words;
      int16 sa_VectorizeXYCheck[NUM_BUFFER_ID*3] =
      {
         XY_MEM   , XY_BUF_START , XY_BUF_END,
         X_MEM , X_BUF_START  , X_BUF_END,
         Y_MEM , Y_BUF_START  , Y_BUF_END,
         XY_BUF_8X0, (X_BUF_START + XY_BUF_8X0_START), (X_BUF_START + XY_BUF_8X0_END),
         XY_BUF_8X1, (Y_BUF_START + XY_BUF_8X1_START), (Y_BUF_START + XY_BUF_8X1_END),
         XY_BUF_Y_TMP_DEC, (Y_BUF_START + XY_BUF_Y_DEC_TMP_START), (Y_BUF_START + XY_BUF_Y_DEC_TMP_END)
      };

      /* addr relative to XY Base Addr in words */
      pla_input_in_words = ( ((int32)pla_buf -  XY_BASE_ADDR_IN_BYTES) >> LOG2_BYTES_PER_WORD );

      for (i = 0; i < (NUM_BUFFER_ID*3); i+=3)
      {
         if (s_bufId == sa_VectorizeXYCheck[i])
         {
            if (pla_input_in_words >= sa_VectorizeXYCheck[i+1] && pla_input_in_words <= sa_VectorizeXYCheck[i+2])
            {
               return PASS;
            }
            break;
         }
      }
      return FAIL;
   #endif
#else
   return PASS;
#endif
}

// the same code applies to addresses of both 16-bit and 32-bit data
FlagT CheckValidModuloAddr(int32 pla_bufXY, int16 s_bufLen) {
   int16 i;
   int16 s_log2bufLen;

   // compute ceil(log2(s_bufLen))
   for(i=s_bufLen-1, s_log2bufLen=0; i>1; i >>= 1)
      s_log2bufLen++;

   s_log2bufLen++;

   // any buffer using modulo addressing must start at
   // a multiple of (1 << s_log2bufLen)
   if(pla_bufXY % (1 << s_log2bufLen) == 0)
      return PASS;
   else
      return FAIL;

}
