/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 1998-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
 *----------------------------------------------------------------------------
 *
 *   Aware DMT Technology. Proprietary and Condfidential
 *
 *   40 Middlesex Turnpike, Bedford, MA 01730-1413
 *   Phone (781) 276-4000
 *   FAX   (781) 276-4001
 *
 *   dataswap.c
 *
 *   Functions for performing data swapping between internal and external
 *   memories using XDMA engine.
 *
 *----------------------------------------------------------------------------
 */


// ****************************************************************************************************
// dataswap.c
// History :
//  27/05/2013 Varun : made some changes to CheckForDataSwap() function to make it work for VR9 as the old code
// was taken directly from danube
// Grep for "XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer"
//
// 15/12/2017 Sriram shastry: DCT tool does not work in ADSL mode for VRX518 FW R5
// Added Support towards VRX518 Platform for  debug traces ( Updated address field )
// Search  Pattern XDSLRTFW-3638
//****************************************************************************************************


#include <stdio.h>
#include "common.h"
#include "gdata.h"
#include "fifo.h"
#include "states.h"
#include "cmv.h"
#include "aux_regs.h"
#include "dataswap.h"
#include "trail.h"
#include "aux_reg_danube.h"

extern FlagT GetXdmaAccessStatus(void);

#ifdef DEBUG_TRACES
/* XMEM data buffer address */
DataSwapControl_t  gt_DataSwap;

/* Flags to indicate which data buffer in XMEM */
uint16  gus_DataBuf_InXmem;


/****************************************************************************
;   Prototype: void InitDataSwap (void)
;
;   Description: Function initializes the data swap state to a ready state
;
;   Arguments:
;       None
;
;   Return Value:
;       None
;
;****************************************************************************/
void InitDataSwap (void)
{
    gt_DataSwap.c_State = DATASWAP_READY;
    gus_DataBuf_InXmem = 0;
}


/****************************************************************************
;   Prototype: void CheckForDataSwap (void)
;
;   Description: Function checks to see whether the XDMA engine is idle.
;                If so, load XDMA registers and start XDMA.
;
;   Arguments:
;       None
;
;   Return Value:
;       None
;
;****************************************************************************/
void CheckForDataSwap (void)
{
    int32 l_SrcAddrEnd;



    /* Code swap and data swap share the same XDMA engine */
    if ((gs_CodeSwapStatus == CODESWAP_IDLE || gs_CodeSwapStatus == CODESWAP_ALL_DONE) &&
        (gt_DataSwap.c_State == DATASWAP_REQUESTED))
    {
      /* Don't start XDMA with size less than a longword */
      if (gt_DataSwap.s_BufSize < 4)
      {
         gt_DataSwap.c_State = DATASWAP_READY;
         return;
      }

      /* Reture if XDMA engine is busy */
      if (GetXdmaAccessStatus()== 0)
      {
#ifdef DEBUG_TRACES
         // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
         gul_DMA_Busy_Error++;
#endif // #ifdef DEBUG_TRACES
         return;
      }

        /* Compute source end address from buffer size */
        /* NOTE: The end address must be longword (32-bit) aligned minus 2 bytes */
        l_SrcAddrEnd = (gt_DataSwap.l_SrcAddr + gt_DataSwap.s_BufSize + 3)/4*4 - 2;


      SetDspReg(DSP_XDMA_SA_S, gt_DataSwap.l_SrcAddr);
      // program source end
   // l_Temp++;
      SetDspReg(DSP_XDMA_SA_E, l_SrcAddrEnd);

      // XDSLRTFW-597 FEATURE_ALL_ALL_ALL_Debug_Buffer(START_END)
      // program destination start
      // XDSLRTFW-3638 (Start)
      // NOTE :below DestAddr is  applicable for VRX21x platform
      // SetDspReg(DSP_XDMA_DA_S, (gt_DataSwap.l_DstAddr-XSDRAM_CACHE_IRAM_VRX218_ADDR));
      // Memory Map address
/*
      +----------+---------------------+---------+-------+
      |Platform  |CACHE_IRAM Available |ORIGIN   |LENGTH |
      +----------+---------------------+---------+-------+
      | VRX518   |YES                  |0x100000 |1024K  |
      +----------+---------------------+---------+-------+
      | VRX218   |YES                  |0x80000  |1024K  |
      +----------+---------------------+---------+-------+
*/
      SetDspReg(DSP_XDMA_DA_S, (gt_DataSwap.l_DstAddr-XSDRAM_CACHE_IRAM_VRX518_ADDR));
      // XDSLRTFW-3638 (End)

      // write to XCTRL
      SetDspReg(DSP_XDMA_CTRL, DSP_XDMA_CTRL_EN_MASK | DSP_XDMA_CTRL_WR_MASK);


        gt_DataSwap.c_State = DATASWAP_IN_PROGRESS;
    }

   /* Check for dataswap done */
    if ((gt_DataSwap.c_State == DATASWAP_IN_PROGRESS) && (GetXdmaAccessStatus()== 0))
    {
        /* Ready for next request */
        gt_DataSwap.c_State = DATASWAP_READY;
    }
}


/****************************************************************************
;   Prototype: int ReadXdmaStatus (void)
;
;   Description: Function reads the XDMA status register and return the status
;                of either idle or busy.
;
;           In case of XDMA error, exception handler is called.
;   Arguments:
;       None
;
;   Return Value:
;       0 - XDMA is idle, ready for next transfer
;       1 - XDMA is busy
;
;****************************************************************************/
int ReadXdmaStatus (void)
{
    int32 l_XdmaStatus = _lr(ARC_XDMA_STAT);

    if ((l_XdmaStatus & (XDMA_STAT_INT_ERR | XDMA_STAT_AHB_ERR)) != 0)
    {
        /* Handle & clean up XDMA engine error */
        gs_RxNextState = FAIL_RX;
        gpF_RxStateFunc = (PtrToFunc)ExceptionHandler;

        /* Set exception handler variable */
        gus_ExceptionState  = gs_RxState;

      if ((l_XdmaStatus & XDMA_STAT_INT_ERR) != 0)
      {
         gus_ExceptionCode   = E_CODE_DATASWAP_XDMA_ERROR;
      }
      else
      {
         gus_ExceptionCode   = E_CODE_DATASWAP_AHB_ERROR;
      }
    }

    return (l_XdmaStatus & XDMA_STAT_IN_PROC);
}
#endif // #ifdef DEBUG_TRACES

