;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        m2r.s
;
; DESCRIPTION:     This file contains the loop function used to map medley
;                  to reverb in med2rev.c
;
;*************************************************************************
.include "asm.h"
.include "xy_regs.h"
.data
sa_QuadMask:
   .size sa_QuadMask, 4*BYTES_PER_WORD
   .type sa_QuadMask, @object
   .align   BYTES_PER_WORD
   .half   0, 3, 1, 2

.text
;/********************************************************************************************
;  Subroutine Name: MedleyToReverbAccumLoop
;
;  Description:
;     This routine implements the loop that map a MEDLEY input into a REVERB signal and
;       then accumulates the rotated signal.
;
;  Prototype:
;       void MedleyToReverbAccumLoop(int32 pla_NoisePower, int32 psa_rec, int32 psa_ref,
;        int16 s_first_chan, int16 s_last_chan, int16 s_offset, int16 s_modulo);
;
;  Input Arguments:
;       pla_NoisePower -- XY address of the accum buffer (32-bit addressing mode) - in X Memory
;       psa_rec        -- XY address of the first channel of the received DMT tones (16-bit addressing mode) - in X memory
;       psa_reverb     -- XY address of the reference DMT tones (16-bit addressing mode) - in Y memory
;       s_first_chan   -- first channel
;       s_last_chan    -- last channel
;       s_offset       -- offset used to properly align the MEDLEY signal
;       s_modulo       -- length of the MEDLEY PN sequence
;
;
;  Output Arguments:
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;****************************************************************************/
;void MedleyToReverbAccumLoop(int32 pla_NoisePower, int32 psa_rec, int32 psa_reverb,
;        int16 s_first_chan, int16 s_last_chan, int16 s_offset, int16 s_modulo);

.global MedleyToReverbAccumLoop
MedleyToReverbAccumLoop:
   .equ MAX_NUM_TONES,  256
   ; Input Arguments
   ; %r0 = pla_NoisePower
   ; %r1 = psa_rec
   ; %r2 = psa_ref
   ; %r3 = s_first_chan
   ; %r4 = s_last_chan
   ; %r5 = s_offset
   ; %r6 = s_modulo
   .define pla_NoisePower, %r0
   .define psa_rec,        %r1
   .define psa_ref,        %r2
   .define s_first_chan,   %r3
   .define s_last_chan,    %r4
   .define s_offset,       %r5
   .define s_modulo,       %r6

   .define s_numChannels,  %r4   ; should be the same as s_last_chan
   .define s_2first_chan,  %r4 ; should be the same as s_last_chan
   .define psa_reverb,     %r7
   .define s_ref_offset,   %r7
   .define psa_medley,     %r7

   .define scratch,        %r8
   .define scratch1,       %r9
   .define s_real,         %r0
   .define s_imag,         %r1

   .define s_QuadRev,      %r2
   .define s_QuadMed,      %r3

   ; prolog: none since leaf function and no stack frame for auto variables

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up the window registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub   s_numChannels, s_last_chan, s_first_chan
   add.f s_numChannels, s_numChannels, 1
   mov   %lp_count, s_numChannels
   ble   9f

   ; psa_rec - received DMT tones
   sr  psa_rec, [%ax0]
   sr  0x2000_0001, [aux_mx0]       ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO

   ; pla_NoisePower - accumulators
   sr  pla_NoisePower, [%ax1]
   sr  0x1, [aux_mx1]               ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO

   ; if (s_offset > 0)
   sub.f 0, s_offset, 0
   asl   s_2first_chan, s_first_chan, 1
   ble   8f

   ; psa_reverb - reference REVERB DMT tones
   add psa_reverb, psa_ref, s_2first_chan
   sr  psa_reverb, [%ay0]
   sr  0x2000_0001, [aux_my0]             ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO

   add    s_ref_offset, s_2first_chan, s_offset
   sub.f  0, s_ref_offset, s_modulo
   sub.gt s_ref_offset, s_ref_offset, s_modulo
   add    psa_medley, psa_ref, s_ref_offset
   sr     psa_medley, [%ay1]
   and    s_modulo, s_modulo, ((1<<13) - 1)
   asl    scratch, s_modulo, 16
   or     scratch, scratch, 0x2000_0001
   sr     scratch, [aux_my1]           ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO, modulo = s_modulo

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; compute noise power and add it to the total power ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; find the quadrant of REVERB tone
   lsr   scratch, aux_y0_u, 30
   and   scratch, scratch, 0x2
   lsr   scratch1, aux_y0_u, 31
   or    scratch, scratch, scratch1
   asl   scratch, scratch, LOG2_BYTES_PER_WORD
   ldw   s_QuadRev, [sa_QuadMask, scratch]

   lp 5f
      ; find the quadrant of MEDLEY tone
      lsr   scratch, aux_y1_u, 30
      and   scratch, scratch, 0x2
      lsr   scratch1, aux_y1_u, 31
      or    scratch, scratch, scratch1
      asl   scratch, scratch, LOG2_BYTES_PER_WORD
      ldw   s_QuadMed, [sa_QuadMask, scratch]

      ; load received data into registers while waiting for s_QuadMed load
      asr   s_real, aux_x0_u, 16
      asr   s_imag, aux_x0_u, 16

      ; find the phase difference
      sub   scratch, s_QuadRev, s_QuadMed
      and.f   scratch, scratch, 0x3

        // goto 0 phase
        b.z 0f

        sub.f 0, scratch, 1
        b.z 1f

        sub.f 0, scratch, 2
        b.z 2f

        ; it`s gota be 270 phase
      ; phase(REVERB) - phase(MEDLEY) = 270deg
      3:
      add aux_x1_u, aux_x1_u, s_imag
      sub aux_x1_u, aux_x1_u, s_real
      b   4f

      ; phase(REVERB) - phase(MEDLEY) =   0deg
      ; 16-bit mode
      0:
      add aux_x1_u, aux_x1_u, s_real   ; aux_x1_u = gla_NoisePower
      add aux_x1_u, aux_x1_u, s_imag
      b   4f

      ; phase(REVERB) - phase(MEDLEY) =  90deg
      1:
      sub aux_x1_u, aux_x1_u, s_imag
      add aux_x1_u, aux_x1_u, s_real
      b   4f

      ; phase(REVERB) - phase(MEDLEY) = 180deg
      2:
      sub aux_x1_u, aux_x1_u, s_real
      sub aux_x1_u, aux_x1_u, s_imag


      4:
      ; find the quadrant of REVERB tone
      lsr   scratch, aux_y0_u, 30
      and   scratch, scratch, 0x2
      lsr   scratch1, aux_y0_u, 31
      or    scratch, scratch, scratch1
      asl   scratch, scratch, LOG2_BYTES_PER_WORD
      ldw   s_QuadRev, [sa_QuadMask, scratch]
   5:

   b 9f

   8:
   ; psa_ref - reference REVERB DMT tones
   asl s_2first_chan, s_2first_chan, LOG2_BYTES_PER_WORD
   add psa_ref, psa_ref, s_2first_chan
   sr  psa_ref, [%ay0]
   sr  0x2000_0001, [aux_my0]

   lp 7f ; if (s_offset == 0) the phase difference between the REVERB and MEDLEY tone
         ; will always be 0
      asr s_real, aux_x0_u, 16         ; aux_x0_u = received data
      asr s_imag, aux_x0_u, 16
      add aux_x1_u, aux_x1_u, s_real   ; aux_x1_u = gla_NoisePower
      add aux_x1_u, aux_x1_u, s_imag
   7:


   ; epilog: just return to the caller
   9:
      j    [%blink]
;/********************************************************************************************
;  Subroutine Name: MedleyToReverbAccumLoopXY
;
;  Description:
;     This routine implements the loop that map a MEDLEY input into a REVERB signal and
;       then accumulates the rotated signal.
;
;  Prototype:
;       void MedleyToReverbAccumLoopXY(int32 pla_NoisePower, int32 psa_rec, int32 psa_ref,
;        int16 s_first_chan, int16 s_last_chan, int16 s_offset, int16 s_modulo);
;
;  Input Arguments:
;       pla_NoisePower -- XY address of the accum buffer (32-bit addressing mode) - in X Memory
;       psa_rec        -- XY address of the first channel of the received DMT tones (16-bit addressing mode) - in Y memory
;       psa_reverb     -- XY address of the reference DMT tones (16-bit addressing mode) - in Y memory
;       s_first_chan   -- first channel
;       s_last_chan    -- last channel
;       s_offset       -- offset used to properly align the MEDLEY signal
;       s_modulo       -- length of the MEDLEY PN sequence
;
;
;  Output Arguments:
;
;  Return Value:
;     none
;
;  Global Variables:
;     none
;
;****************************************************************************/
;****************************************************************************/
;void MedleyToReverbAccumLoopXY(int32 pla_NoisePower, int32 psa_rec, int32 psa_reverb,
;        int16 s_first_chan, int16 s_last_chan, int16 s_offset, int16 s_modulo);

.global MedleyToReverbAccumLoopXY
MedleyToReverbAccumLoopXY:
;  .equ MAX_NUM_TONES,  256
   ; Input Arguments
   ; %r0 = pla_NoisePower
   ; %r1 = psa_rec
   ; %r2 = psa_ref
   ; %r3 = s_first_chan
   ; %r4 = s_last_chan
   ; %r5 = s_offset
   ; %r6 = s_modulo
   .define pla_NoisePower, %r0
   .define psa_rec,        %r1
   .define psa_ref,        %r2
   .define s_first_chan,   %r3
   .define s_last_chan,    %r4
   .define s_offset,       %r5
   .define s_modulo,       %r6

   .define s_numChannels,  %r4   ; should be the same as s_last_chan
   .define s_2first_chan,  %r4 ; should be the same as s_last_chan
   .define psa_reverb,     %r7
   .define s_ref_offset,   %r7
   .define psa_medley,     %r7

   .define scratch,        %r8
   .define scratch1,       %r9
   .define s_real,         %r0
   .define s_imag,         %r1

   .define s_QuadRev,      %r2
   .define s_QuadMed,      %r3

   ; prolog: none since leaf function and no stack frame for auto variables

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up the window registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   sub   s_numChannels, s_last_chan, s_first_chan
   add.f s_numChannels, s_numChannels, 1
   mov   %lp_count, s_numChannels
   ble   9f

   ; psa_rec - received DMT tones
   sr  psa_rec, [%ay2]
   sr  0x2000_0001, [aux_my2]       ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO

   ; pla_NoisePower - accumulators
   sr  pla_NoisePower, [%ax1]
   sr  0x1, [aux_mx1]               ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO

   ; if (s_offset > 0)
   sub.f 0, s_offset, 0
   asl   s_2first_chan, s_first_chan, 1
   ble   8f

   ; psa_reverb - reference REVERB DMT tones
   add psa_reverb, psa_ref, s_2first_chan
   sr  psa_reverb, [%ay0]
   sr  0x2000_0001, [aux_my0]             ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO

   add    s_ref_offset, s_2first_chan, s_offset
   sub.f  0, s_ref_offset, s_modulo
   sub.gt s_ref_offset, s_ref_offset, s_modulo
   add    psa_medley, psa_ref, s_ref_offset
   sr     psa_medley, [%ay1]
   and    s_modulo, s_modulo, ((1<<13) - 1)
   asl    scratch, s_modulo, 16
   or     scratch, scratch, 0x2000_0001
   sr     scratch, [aux_my1]           ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO, modulo = s_modulo

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; compute noise power and add it to the total power ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; find the quadrant of REVERB tone
   lsr   scratch, aux_y0_u, 30
   and   scratch, scratch, 0x2
   lsr   scratch1, aux_y0_u, 31
   or    scratch, scratch, scratch1
   asl   scratch, scratch, LOG2_BYTES_PER_WORD
   ldw   s_QuadRev, [sa_QuadMask, scratch]

   lp 5f
      ; find the quadrant of MEDLEY tone
      lsr   scratch, aux_y1_u, 30
      and   scratch, scratch, 0x2
      lsr   scratch1, aux_y1_u, 31
      or    scratch, scratch, scratch1
      asl   scratch, scratch, LOG2_BYTES_PER_WORD
      ldw   s_QuadMed, [sa_QuadMask, scratch]

      ; load received data into registers while waiting for s_QuadMed load
      asr   s_real, aux_y2_u, 16
      asr   s_imag, aux_y2_u, 16

      ; find the phase difference
      sub   scratch, s_QuadRev, s_QuadMed
      and.f   scratch, scratch, 0x3

        // goto 0 phase
        b.z 0f

        sub.f 0, scratch, 1
        b.z 1f

        sub.f 0, scratch, 2
        b.z 2f

        ; it`s gota be 270 phase
      ; phase(REVERB) - phase(MEDLEY) = 270deg
      3:
      add aux_x1_u, aux_x1_u, s_imag
      sub aux_x1_u, aux_x1_u, s_real
      b   4f

      ; phase(REVERB) - phase(MEDLEY) =   0deg
      ; 16-bit mode
      0:
      add aux_x1_u, aux_x1_u, s_real   ; aux_x1_u = gla_NoisePower
      add aux_x1_u, aux_x1_u, s_imag
      b   4f

      ; phase(REVERB) - phase(MEDLEY) =  90deg
      1:
      sub aux_x1_u, aux_x1_u, s_imag
      add aux_x1_u, aux_x1_u, s_real
      b   4f

      ; phase(REVERB) - phase(MEDLEY) = 180deg
      2:
      sub aux_x1_u, aux_x1_u, s_real
      sub aux_x1_u, aux_x1_u, s_imag


      4:
      ; find the quadrant of REVERB tone
      lsr   scratch, aux_y0_u, 30
      and   scratch, scratch, 0x2
      lsr   scratch1, aux_y0_u, 31
      or    scratch, scratch, scratch1
      asl   scratch, scratch, LOG2_BYTES_PER_WORD
      ldw   s_QuadRev, [sa_QuadMask, scratch]
   5:

   b 9f

   8:
   ; psa_ref - reference REVERB DMT tones
   asl s_2first_chan, s_2first_chan, LOG2_BYTES_PER_WORD
   add psa_ref, psa_ref, s_2first_chan
   sr  psa_ref, [%ay0]
   sr  0x2000_0001, [aux_my0]

   lp 7f ; if (s_offset == 0) the phase difference between the REVERB and MEDLEY tone
         ; will always be 0
      asr s_real, aux_y2_u, 16         ; aux_y2_u = received data
      asr s_imag, aux_y2_u, 16
      add aux_x1_u, aux_x1_u, s_real   ; aux_x1_u = gla_NoisePower
      add aux_x1_u, aux_x1_u, s_imag
   7:


   ; epilog: just return to the caller
   9:
      j    [%blink]


   .undef pla_NoisePower
   .undef psa_rec
   .undef psa_ref
   .undef s_numChannels
   .undef s_modulo
   .undef scratch
   .undef scratch1
   .undef s_real
   .undef s_imag
   .undef s_QuadRev
   .undef s_QuadMed
