;; **COPYRIGHT******************************************************************
;;    INTEL CONFIDENTIAL
;;    Copyright (C) 2017 Intel Corporation
;;    Copyright (C), 1994-2002 Aware Inc. All Rights Reserved.
;; ******************************************************************COPYRIGHT**
;; **DISCLAIMER*****************************************************************
;;   The source code contained or described herein and all documents related
;;   to the source code ("Material") are owned by Intel Corporation or its
;;   suppliers or licensors. Title to the Material remains with Intel
;;   Corporation or its suppliers and licensors. The Material may contain
;;   trade secrets and proprietary and confidential information of Intel
;;   Corporation and its suppliers and licensors, and is protected by
;;   worldwide copyright and trade secret laws and treaty provisions. No part
;;   of the Material may be used, copied, reproduced, modified, published,
;;   uploaded, posted, transmitted, distributed, or disclosed in any way
;;   without Intels prior express written permission.
;;
;;   No license under any patent, copyright, trade secret or other
;;   intellectual property right is granted to or conferred upon you by
;;   disclosure or delivery of the Materials, either expressly, by
;;   implication, inducement, estoppel or otherwise. Any license under
;;   such intellectual property rights must be express and approved by
;;   Intel in writing.
;; *****************************************************************DISCLAIMER**
;*************************************************************************
; Aware DMT Technology. Proprietary and Confidential.
;
; ADDRESS:         40 Middlesex Turnpike, Bedford, MA 01730-1413 USA
; TELEPHONE:       781.276.4000
; FAX:             781.276.4001
; WEB:             http://www.aware.com
;
; FILENAME:        vecmultloop.s
;
; DESCRIPTION:     Function for multiplying two vectors
;
;*************************************************************************
.include "asm.h"
.include "xy_regs.h"


.text

;******************************************************************************
; void VectorMultiplyLoop(int32 dest_arr, int32 src_arr1, int32 src_arr2, int32 src_shift_arr, int16 length)
.global VectorMultiplyLoop
VectorMultiplyLoop:
   ; Input Arguments
   ; %r0 = Start Address of destination array in Y memory
   ; %r1 = Start Address of source array 1 in X memory
   ; %r2 = Start Address of source array 2 in Y memory
   ; %r3 = Start address of shift array in X memory
   ; %r4 = Smallest array length

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up loop count for zero ovhd loop mechanism ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    add %r5,%r4,1
    lsr %r5,%r5,1
    mov.f %lp_count,%r5       ;Initialise loop counter - Dual
   blt 9f                  ; if (length <= 0) return

   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
   ; set up window registers ;
   ;;;;;;;;;;;;;;;;;;;;;;;;;;;
    sr %r1,[%ax0]
    sr 0x1,[aux_mx0]          ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO

    sr %r2,[%ay0]
    sr 0x1,[aux_my0]          ; offset = 1, postupdate, linear, 32-bit mode, AM_MODULO

    sr %r3,[%ax1]
    sr 0x2000_0001,[aux_mx1]     ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO

    sr %r0,[%ay1]
    sr 0x2000_0001,[aux_my1]     ; offset = 1, postupdate, linear, 16-bit mode, AM_MODULO
   nop
   nop

   lp 0f ; for(i=0; i<length; i++)
      ;multiply
      mul_op 0,aux_x0_u,aux_y0_u
      lr %r0, [%aux_xmac2]
      lr %r1, [%aux_xmac1]

      ;Shift result right and save @ destination addr
      asr %r2, aux_x1_u, 16
      sub %r2, 0x10, %r2
      asl aux_y1_u, %r0, %r2

      ;Shift result right and save @ destination addr
      asr %r3, aux_x1_u, 16
      sub %r3, 0x10, %r3
      asl aux_y1_u, %r1, %r3
   0:

   9:
   j [%blink]

;******************************************************************************




