/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// AFE_ModeSelection.c
//
// History
//
// 30 Aug 2011: Vinjam: Set VR9 LD mode through a CMV
//              CMV DSL 10 Bits(4:0) are used to set the line driver for ADSL mode
//              Grep for XDSLRTFW-141: Feature_ALL_ALL_ALL_CMV_LD_Mode
//
// 16 Feb 2012 Vinjam: LSBs of DAC1 are not calibration in 8-/12MHz modes.
//             In the VDSL mode all 14bit of the DAC will be use and the LSBs have to be calibrated. => 0x41ff
//             ADSL mode: ADSL mode uses the 8bit DAC with noise shaper. In this case the LSB in the DAC will be not used
//             and a calibration of the LSB is not needed (->0x01ff), but calibrating the LSB in the ADSL mode has
//             no impact on the DAC performance. Therefore 0x41ff can be used in ADSL as well. DAC1_CAL_1_AFE_SET(0x41FF);
//             Grep for XDSLRTFW-352 Bug_All_US_All_LsbOfDac1Calibration
//
// 26/11/2012 Kannan: Included header file for compilation
//        Grep for XDSLRTFW-541: Platform_VR9_VRX318
// 27/3/2013 Mahesh: Set proper DAC trim values in DAC1_MISC1 register
//    Grep for XDSLRTFW-785: Bug_All_All_All_PsdAfeReg
// ******************************************************************

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "common.h"
#include "typedef.h"
#include "gdata.h"  //XDSLRTFW-541: Platform_VR9_VRX318 (START_END)
#include "cmv.h"                 //SMS00972960
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_global_reg.h"
#include "vr9_afe_dig_filt_ch0_reg.h"
#include "vr9_afe_dig_ch0_reg.h"
#include "VR9_Afedata.h"
#include "AfeRdWrite.h"
#include "FilterTune.h"
#include "VR9_AfeFunc.h"
#include "VRX_AfeCommonData.h"

/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/
/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
void  VR9_InitAnalogRegs_Tx_Forced(void);
void  VR9_FilterConfigRegs_Tx_Forced(void);
void  VR9_InitAnalogRegs_Rx_Forced(void);
void  VR9_FilterConfigRegs_Rx_Forced(void);

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   VR9_ConfigAFETxPath()
**
** DESCRIPTION:   This function shall be called from ConfigEngineForLinkStart(),
**                ConfigEngineForPostGhs() and from the state where HW reconfig-
**                uration is done based on the messages exchanged in CD phase
**                for the all the VDSL modes.
**
** PARAMETERS:     1. us_TxMode is the mode for which AFE regsiters needs to be
**                    programmed.
**
** RETURN VALUE:   NONE
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2) UTP numbser SMS00946067,SMS00974862
**                  (3) VR9_AFEModeSelection.doc
**                  (4) VR9_AFE_mode_settings_v1.xls
** =============================================================================
*/

void VR9_ConfigAFETxPath(uint16 us_TxMode)
{
    VR9_InitAnalogRegs_Tx(us_TxMode);
    VR9_FilterConfigRegs_Tx(us_TxMode);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: VR9_ConfigAFETxPath_Forced()
**
** DESCRIPTION:   Debug function to overwrite the default Tx AFE config settings in the firmware.
**
** PARAMETERS:    NONE
**
**
** RETURN VALUE:  NONE
**
** NOTES:Reference:
**
**
**
** =============================================================================
*/
void VR9_ConfigAFETxPath_Forced(void)
{
    VR9_InitAnalogRegs_Tx_Forced();
    VR9_FilterConfigRegs_Tx_Forced();
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   VR9_ConfigAFERxPath()
**
** DESCRIPTION:   This function shall be called from ConfigEngineForLinkStart(),
**                ConfigEngineForPostGhs() and from the state where HW reconfig-
**                uration is done based on the messages exchanged in CD phase
**                for the all the VDSL modes.
**
** PARAMETERS:     1. us_RxMode is the mode for which AFE regsiters needs to be
**                    programmed.
**
** RETURN VALUE:   NONE
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2) UTP numbser SMS00946067,SMS00974862
**                  (3) VR9_AFEModeSelection.doc
**                  (4) VR9_AFE_mode_settings_v3.xls
** =============================================================================
*/

void VR9_ConfigAFERxPath(uint16 us_RxMode)
{
    VR9_InitAnalogRegs_Rx(us_RxMode);
    VR9_FilterConfigRegs_Rx(us_RxMode);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: VR9_ConfigAFERxPath_Forced()
**
** DESCRIPTION:   Debug function to overwrite the default Rx config settings in the firmware.
**
** PARAMETERS:    NONE
**
**
** RETURN VALUE:  NONE
**
** NOTES:Reference:
**
**
**
** =============================================================================
*/
void VR9_ConfigAFERxPath_Forced(void)
{
    VR9_InitAnalogRegs_Rx_Forced();
    VR9_FilterConfigRegs_Rx_Forced();
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   VR9_InitAnalogRegs_Tx()
**
** DESCRIPTION:   This function shall be called from VR9_ConfigAFETxPath(),
**                And initialises all the Analog registers in the TxPath
**
** PARAMETERS:     1. us_TxMode is the mode for which AFE regsiters needs to be
**                    programmed.
**
** RETURN VALUE:   NONE
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2) UTP numbser SMS00920529,SMS00974862
**                  (3) VR9_AFEModeSelection.doc
**                  (4) VR9_AFE_mode_settings_v3.xls
** TODO :Values will be changed later currently all registers are programmed for
**       default settings.
** =============================================================================
*/

void VR9_InitAnalogRegs_Tx(uint16 us_TxMode)
{

#ifdef VDSL_62
    switch(us_TxMode)
    {
    case VDSL_30:

        //LOCALBIASING Miller Capacitor ofCommon Mode Voltage Buffer
        BIAS_4_AFE_SET(0x344A);

        //POFIPOCO _PU
        //POFIPOCOADSL Mode Disabled
        //POFIPOCO VDSL Mode Enable
        //POFIPOCO Passive 1st Order LP Tuning<9:8>; 01
        //POFIPOCO Cutoff Frequency adjustment<7:4>0000=>POFIPOCO_LP1_NO_FILTERING
        //1000 =>POFIPOCO_GAIN_M4DB
        POFIPOCO_GAIN_AFE_SET(0x1508);

        //POFIPOCO_OP2_CASC_P10 : +10% (default)
        //POFIPOCO_ADSL_NO_FILTERING
        //POFIPOCO VDSL Mode  No Additional -12dB/-6dB Gain
        //VDSL Mode cutoff frequency in POFIPOCO.:40MHz
        POFIPOCO_TRIM_1_AFE_SET(0x4002);

        //POFIPOCO Tuning for VDSL/ADSL modes
        //POFIPOCO_OP2_IOUT_100P : 100% (default, VDSL Modes)
        //POFIPOCO_OP1_IOUT_100P : 100% (default, VDSL Modes)
        POFIPOCO_TRIM_2_AFE_SET(0x6E99);

        FilterTune(POFI_POCO_VDSL_40M); //POFI_POCO_VDSL_40M as per "VR9_AFE_mode_settings_v1.xls"

        //0b DAC1_DATA_2SCOMPLEMENT
        //0b DAC1_DATA_INTPATH : use output data from interpolation path
        //0000 0000 0000b DAC1_STATIC_DATA_MIN : minimum value
        DAC1_STATIC_AFE_SET(0x0000);

        //0b DAC1_REF_CAL_ENABLED
        //0b DAC1_LSBAQ_CAL_ENABLED
        //0b DAC1_MATRIX_CAL_ENABLED(must be same as DAC1_CAL_ENABLED)
        //0b DAC1_CAL_ENABLED
        //001 1111 1111b DAC1_CAL_FIX_DEFAULT: nominal
        //XDSLRTFW-352 Bug_All_US_All_LsbOfDac1Calibration (Start_End)
        DAC1_CAL_1_AFE_SET(0x41FF);

        //0b DAC1_CAL_RANDOM_ON
        //0b DAC1_SET_CAL_ALL_OFF : normal
        //0b DAC1_CAL_RESET_OFF : normal
        //001 1111 1111b DAC1_CAL_VAR_DEFAULT : nominal
        DAC1_CAL_2_AFE_SET(0x01FF);

        //0b DAC1_PU : Power Up
        //1010b: DAC1_GAIN_FINE_MIN : 1.1dB (10*0.11)
        //0010b DAC1_GAIN_COARSE_M1DB45 : -1.45dB (default)
      //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
        DAC1_MISC_1_AFE_SET(gus_DacTrimVal);

        //00b DAC1_CAL_CLK_NODIV : no division
        //1b DAC1_ROT_ENABLE
        //1b DAC1_VDSL : VDSL Mode = 13bit
        //0b DAC1_DSW_ENABLE : Enabled
        //000b DAC1_ISB_NO_DEM : no DEM
        //000b DAC1_MSB_NO_DEM : no DEM
        DAC1_MISC_2_AFE_SET(0x0600);

        //DAC2_STATIC_DATA_MIN 0 0000 0000 0000
        DAC2_STATIC_AFE_SET(0x0000);
        //000 1111 1111b DAC2_CAL_FIX_DEFAULT : nominal (default)
        DAC2_CAL_1_AFE_SET(0x00FF);

        if(gft_AEC_On)
        {
            //DAC2_SET_CAL_ALL_OFF : normal
            //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
            DAC2_CAL_2_AFE_SET(0x00FF);
            //DAC2_PU : Power Up
            //DAC2 Gain Setting; 0dB (default)
            DAC2_MISC_AFE_SET(0x0700);
        }
        else
        {
            //DAC2_SET_CAL_ALL_ON : all current cells in calibration
            //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
            DAC2_CAL_2_AFE_SET(0x20FF);
            //DAC2_PD : Power Down
            //DAC2 Gain Setting; 0dB (default)
            DAC2_MISC_AFE_SET(0x1700);

        }

        break;

    case VDSL_17:

        //LOCALBIASING Miller Capacitor ofCommon Mode Voltage Buffer
        BIAS_4_AFE_SET(0x344A);

        //POFIPOCO _PU
        //POFIPOCOADSL Mode Disabled
        //POFIPOCO VDSL Mode Enable
        //POFIPOCO Passive 1st Order LP Tuning<9:8>; 01
        //POFIPOCO Cutoff Frequency adjustment<7:4>0000=>POFIPOCO_LP1_NO_FILTERING
        //1000 =>POFIPOCO_GAIN_M4DB
        POFIPOCO_GAIN_AFE_SET(0x157A);

        //POFIPOCO_OP2_CASC_P10 : +10% (default)
        //POFIPOCO_ADSL_NO_FILTERING
        //POFIPOCO VDSL Mode  No Additional -12dB/-6dB Gain
        //VDSL Mode cutoff frequency in POFIPOCO.:40MHz
        POFIPOCO_TRIM_1_AFE_SET(0x4002);

        //POFIPOCO Tuning for VDSL/ADSL modes
        //POFIPOCO_OP2_IOUT_100P : 100% (default, VDSL Modes)
        //POFIPOCO_OP1_IOUT_100P : 100% (default, VDSL Modes)
        POFIPOCO_TRIM_2_AFE_SET(0x6E99);

        FilterTune(POFI_POCO_VDSL_40M); //POFI_POCO_VDSL_40M as per "VR9_AFE_mode_settings_v1.xls"

        //0b DAC1_DATA_2SCOMPLEMENT
        //0b DAC1_DATA_INTPATH : use output data from interpolation path
        //0000 0000 0000b DAC1_STATIC_DATA_MIN : minimum value
        DAC1_STATIC_AFE_SET(0x0000);

        //0b DAC1_REF_CAL_ENABLED
        //0b DAC1_LSBAQ_CAL_ENABLED
        //0b DAC1_MATRIX_CAL_ENABLED(must be same as DAC1_CAL_ENABLED)
        //0b DAC1_CAL_ENABLED
        //001 1111 1111b DAC1_CAL_FIX_DEFAULT: nominal
        DAC1_CAL_1_AFE_SET(0x41FF);

        //0b DAC1_CAL_RANDOM_ON
        //0b DAC1_SET_CAL_ALL_OFF : normal
        //0b DAC1_CAL_RESET_OFF : normal
        //001 1111 1111b DAC1_CAL_VAR_DEFAULT : nominal
        DAC1_CAL_2_AFE_SET(0x01FF);

        //0b DAC1_PU : Power Up
        //1010b: DAC1_GAIN_FINE_MIN : 1.1dB (10*0.11)
        //0010b DAC1_GAIN_COARSE_M1DB45 : -1.45dB (default)
       // DAC1_MISC_1_AFE_SET(0x00A2);
            //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
         DAC1_MISC_1_AFE_SET(gus_DacTrimVal);    //DAC1 COARSE & FINE GAIN settings;  CGain -1.45dB(default)

        //00b DAC1_CAL_CLK_NODIV : no division
        //1b DAC1_ROT_ENABLE
        //1b DAC1_VDSL : VDSL Mode = 13bit
        //0b DAC1_DSW_ENABLE : Enabled
        //000b DAC1_ISB_NO_DEM : no DEM
        //000b DAC1_MSB_NO_DEM : no DEM
        DAC1_MISC_2_AFE_SET(0x0600);

        //DAC2_STATIC_DATA_MIN 0 0000 0000 0000
        DAC2_STATIC_AFE_SET(0x0000);
        //000 1111 1111b DAC2_CAL_FIX_DEFAULT : nominal (default)
        DAC2_CAL_1_AFE_SET(0x00FF);

        if(gft_AEC_On)
        {
            //DAC2_SET_CAL_ALL_OFF : normal
            //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
            DAC2_CAL_2_AFE_SET(0x00FF);
            //DAC2_PU : Power Up
            //DAC2 Gain Setting; 0dB (default)
            DAC2_MISC_AFE_SET(0x0700);
        }
        else
        {
            //DAC2_SET_CAL_ALL_ON : all current cells in calibration
            //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
            DAC2_CAL_2_AFE_SET(0x20FF);
            //DAC2_PD : Power Down
            //DAC2 Gain Setting; 0dB (default)
            DAC2_MISC_AFE_SET(0x1700);
        }

        break;

    case VDSL_12:
        //LOCALBIASING Miller Capacitor ofCommon Mode Voltage Buffer
        BIAS_4_AFE_SET(0x344A);

        //POFIPOCO _PU
        //POFIPOCOADSL Mode Disabled
        //POFIPOCO VDSL Mode Enable
        //POFIPOCO Passive 1st Order LP Tuning<9:8>; 01
        //POFIPOCO Cutoff Frequency adjustment<7:4>0000=>POFIPOCO_LP1_NO_FILTERING
        //1000 =>POFIPOCO_GAIN_M4DB
        POFIPOCO_GAIN_AFE_SET(0x1508);

        //POFIPOCO_OP2_CASC_P10 : +10% (default)
        //POFIPOCO_ADSL_NO_FILTERING
        //POFIPOCO VDSL Mode  No Additional -12dB/-6dB Gain
        //VDSL Mode cutoff frequency in POFIPOCO.:40MHz
        POFIPOCO_TRIM_1_AFE_SET(0x4002);

        //POFIPOCO Tuning for VDSL/ADSL modes
        //POFIPOCO_OP2_IOUT_100P : 100% (default, VDSL Modes)
        //POFIPOCO_OP1_IOUT_100P : 100% (default, VDSL Modes)
        POFIPOCO_TRIM_2_AFE_SET(0x6E99);

        FilterTune(POFI_POCO_VDSL_40M); //POFI_POCO_VDSL_40M as per "VR9_AFE_mode_settings_v1.xls"

        //0b DAC1_DATA_2SCOMPLEMENT
        //0b DAC1_DATA_INTPATH : use output data from interpolation path
        //0000 0000 0000b DAC1_STATIC_DATA_MIN : minimum value
        DAC1_STATIC_AFE_SET(0x0000);

        //0b DAC1_REF_CAL_ENABLED
        //0b DAC1_LSBAQ_CAL_ENABLED
        //0b DAC1_MATRIX_CAL_ENABLED(must be same as DAC1_CAL_ENABLED)
        //0b DAC1_CAL_ENABLED
        //001 1111 1111b DAC1_CAL_FIX_DEFAULT: nominal
        //XDSLRTFW-352 Bug_All_US_All_LsbOfDac1Calibration (Start_End)
        DAC1_CAL_1_AFE_SET(0x41FF);

        //0b DAC1_CAL_RANDOM_ON
        //0b DAC1_SET_CAL_ALL_OFF : normal
        //0b DAC1_CAL_RESET_OFF : normal
        //001 1111 1111b DAC1_CAL_VAR_DEFAULT : nominal
        DAC1_CAL_2_AFE_SET(0x01FF);

        //0b DAC1_PU : Power Up
        //1010b: DAC1_GAIN_FINE_MIN : 1.1dB (10*0.11)
        //0010b DAC1_GAIN_COARSE_M1DB45 : -1.45dB (default)
        //DAC1_MISC_1_AFE_SET(0x00A2);
      //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
    DAC1_MISC_1_AFE_SET(gus_DacTrimVal);    //DAC1 COARSE & FINE GAIN settings;  CGain -1.45dB(default)

        //00b DAC1_CAL_CLK_NODIV : no division
        //1b DAC1_ROT_ENABLE
        //1b DAC1_VDSL : VDSL Mode = 13bit
        //0b DAC1_DSW_ENABLE : Enabled
        //000b DAC1_ISB_NO_DEM : no DEM
        //000b DAC1_MSB_NO_DEM : no DEM
        DAC1_MISC_2_AFE_SET(0x0600);

        //DAC2_STATIC_DATA_MIN 0 0000 0000 0000
        DAC2_STATIC_AFE_SET(0x0000);
        //000 1111 1111b DAC2_CAL_FIX_DEFAULT : nominal (default)
        DAC2_CAL_1_AFE_SET(0x00FF);

        if(gft_AEC_On)
        {
            //DAC2_SET_CAL_ALL_OFF : normal
            //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
            DAC2_CAL_2_AFE_SET(0x00FF);
            //DAC2_PU : Power Up
            //DAC2 Gain Setting; 0dB (default)
            DAC2_MISC_AFE_SET(0x0700);
        }
        else
        {
            //DAC2_SET_CAL_ALL_ON : all current cells in calibration
            //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
            DAC2_CAL_2_AFE_SET(0x20FF);
            //DAC2_PD : Power Down
            //DAC2 Gain Setting; 0dB (default)
            DAC2_MISC_AFE_SET(0x1700);
        }

        break;

    case VDSL_8:

        //LOCALBIASING Miller Capacitor ofCommon Mode Voltage Buffer
        BIAS_4_AFE_SET(0x344A);

        //POFIPOCO _PU
        //POFIPOCOADSL Mode Disabled
        //POFIPOCO VDSL Mode Enable
        //POFIPOCO Passive 1st Order LP Tuning<9:8>; 01
        //POFIPOCO Cutoff Frequency adjustment<7:4>0000=>POFIPOCO_LP1_NO_FILTERING
        //1000 =>POFIPOCO_GAIN_M4DB
        POFIPOCO_GAIN_AFE_SET(0x1508);

        //POFIPOCO_OP2_CASC_P10 : +10% (default)
        //POFIPOCO_ADSL_NO_FILTERING
        //POFIPOCO VDSL Mode  No Additional -12dB/-6dB Gain
        //VDSL Mode cutoff frequency in POFIPOCO.:40MHz
        POFIPOCO_TRIM_1_AFE_SET(0x4002);

        //POFIPOCO Tuning for VDSL/ADSL modes
        //POFIPOCO_OP2_IOUT_100P : 100% (default, VDSL Modes)
        //POFIPOCO_OP1_IOUT_100P : 100% (default, VDSL Modes)
        POFIPOCO_TRIM_2_AFE_SET(0x6E99);

        FilterTune(POFI_POCO_VDSL_40M); //POFI_POCO_VDSL_40M as per "VR9_AFE_mode_settings_v1.xls"

        //0b DAC1_DATA_2SCOMPLEMENT
        //0b DAC1_DATA_INTPATH : use output data from interpolation path
        //0000 0000 0000b DAC1_STATIC_DATA_MIN : minimum value
        DAC1_STATIC_AFE_SET(0x0000);

        //0b DAC1_REF_CAL_ENABLED
        //0b DAC1_LSBAQ_CAL_ENABLED
        //0b DAC1_MATRIX_CAL_ENABLED(must be same as DAC1_CAL_ENABLED)
        //0b DAC1_CAL_ENABLED
        //001 1111 1111b DAC1_CAL_FIX_DEFAULT: nominal
        //XDSLRTFW-352 Bug_All_US_All_LsbOfDac1Calibration (Start_End)
        DAC1_CAL_1_AFE_SET(0x41FF);

        //0b DAC1_CAL_RANDOM_ON
        //0b DAC1_SET_CAL_ALL_OFF : normal
        //0b DAC1_CAL_RESET_OFF : normal
        //001 1111 1111b DAC1_CAL_VAR_DEFAULT : nominal
        DAC1_CAL_2_AFE_SET(0x01FF);

        //0b DAC1_PU : Power Up
        //1010b: DAC1_GAIN_FINE_MIN : 1.1dB (10*0.11)
        //0010b DAC1_GAIN_COARSE_M1DB45 : -1.45dB (default)
        //DAC1_MISC_1_AFE_SET(0x00A2);
      //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
    DAC1_MISC_1_AFE_SET(gus_DacTrimVal);    //DAC1 COARSE & FINE GAIN settings;  CGain -1.45dB(default)

        //00b DAC1_CAL_CLK_NODIV : no division
        //1b DAC1_ROT_ENABLE
        //1b DAC1_VDSL : VDSL Mode = 13bit
        //0b DAC1_DSW_ENABLE : Enabled
        //000b DAC1_ISB_NO_DEM : no DEM
        //000b DAC1_MSB_NO_DEM : no DEM
        DAC1_MISC_2_AFE_SET(0x0600);

        //DAC2_STATIC_DATA_MIN 0 0000 0000 0000
        DAC2_STATIC_AFE_SET(0x0000);
        //000 1111 1111b DAC2_CAL_FIX_DEFAULT : nominal (default)
        DAC2_CAL_1_AFE_SET(0x00FF);
        //DAC2_SET_CAL_ALL_ON : all current cells in calibration
        //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
        DAC2_CAL_2_AFE_SET(0x20FF);
        //DAC2_PD : Power Down
        //DAC2 Gain Setting; 0dB (default)
        DAC2_MISC_AFE_SET(0x1700);

        break;

    default:
        break;
    }
    // Setting LD mode
    VR9_SetLDMode(LD_VH_VDSL);
#endif // for VDSL_62

#ifdef ADSL_62
    switch(us_TxMode)
    {
    case ADSL_B:

        //LOCALBIASING Miller Capacitor ofCommon Mode Voltage Buffer
        BIAS_4_AFE_SET(0x344A);

        //POFIPOCO _PU
        //POFIPOCOADSL Mode Enable
        //POFIPOCO VDSL Mode Disabled
        //POFIPOCO Passive 1st Order LP Tuning<9:8>; 01
        //1000 =>POFIPOCO_GAIN_M4DB
        //Based on the new settings from Villach, v6, to fix the wrong PSD shape and level.
        //POCO gains of 2dB,
        //POFIPOCO Cutoff Frequency adjustment<7:4>0000 =>POFIPOCO_LP1_ADJUST_2PF
        POFIPOCO_GAIN_AFE_SET(0x251D);
        //POFIPOCO_OP2_CASC_P10 : +10% (default)
        //POFIPOCO_VDSL_NO_FILTERING
        //POFIPOCO VDSL Mode  No Additional -12dB/-6dB Gain
        //Based on the new settings from Villach, v6, to fix the wrong PSD shape and level.
        //ADSL Mode cutoff frequency in POFIPOCO is 160kHz
        POFIPOCO_TRIM_1_AFE_SET(0x5F02);
        //POFIPOCO Tuning for VDSL/ADSL modes
        //001B POFIPOCO_OP2_IOUT_75P : 75% (default, ADSL Modes)
        //000B POFIPOCO_OP1_IOUT_50P : 50% (default, ADSL Modes)
        POFIPOCO_TRIM_2_AFE_SET(0x2299);

        //Based on the new settings from Villach, v6, to fix the wrong PSD shape and level.
        FilterTune(POFI_POCO_ADSL_160K); // POFI_POCO_ADSL_160K

        //0b DAC1_DATA_2SCOMPLEMENT
        //0b DAC1_DATA_INTPATH : use output data from interpolation path
        //0000 0000 1111b DAC1_STATIC_DATA
        DAC1_STATIC_AFE_SET(0x000F);

        //0b DAC1_REF_CAL_ENABLED
        //1b DAC1_LSBAQ_CAL_DISABLED : Calibration Disabled
        //0b DAC1_MATRIX_CAL_ENABLED(must be same as DAC1_CAL_ENABLED)
        //0b DAC1_CAL_ENABLED
        //001 1111 1111b DAC1_CAL_FIX_DEFAULT: nominal
        //XDSLRTFW-352 Bug_All_US_All_LsbOfDac1Calibration (Start_End)
        DAC1_CAL_1_AFE_SET(0x41FF);

        //0b DAC1_CAL_RANDOM_ON
        //0b DAC1_SET_CAL_ALL_OFF : normal
        //0b DAC1_CAL_RESET_OFF : normal
        //001 1111 1111b DAC1_CAL_VAR_DEFAULT : nominal
        DAC1_CAL_2_AFE_SET(0x01FF);

        //0b DAC1_PU : Power Up
        //1010b: DAC1_GAIN_FINE_MIN : 1.1dB (10*0.11)
        //0010b DAC1_GAIN_COARSE_M1DB45 : -1.45dB (default)
        //DAC1_MISC_1_AFE_SET(0x00A2);
      //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
    DAC1_MISC_1_AFE_SET(gus_DacTrimVal);    //DAC1 COARSE & FINE GAIN settings;  CGain -1.45dB(default)

        //00b DAC1_CAL_CLK_NODIV : no division
        //1b DAC1_ROT_ENABLE : Enabled (default)
        //0b DAC1_ADSL : ADSL Mode = 8bit (default)
        //0b DAC1_DSW_ENABLE : Enabled
        //000b DAC1_ISB_NO_DEM : no DEM
        //000b DAC1_MSB_NO_DEM : no DEM
        DAC1_MISC_2_AFE_SET(0x0400);

        //DAC2_STATIC_DATA_MIN 0 0000 0000 0000
        DAC2_STATIC_AFE_SET(0x0000);
        //000 1111 1111b DAC2_CAL_FIX_DEFAULT : nominal (default)
        DAC2_CAL_1_AFE_SET(0x00FF);
        //DAC2_SET_CAL_ALL_ON : all current cells in calibration
        //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
        DAC2_CAL_2_AFE_SET(0x20FF);
        //DAC2_PD : Power Down
        //DAC2 Gain Setting; 0dB (default)
        DAC2_MISC_AFE_SET(0x1700);


        break;
    case ADSL_A:

        //LOCALBIASING Miller Capacitor ofCommon Mode Voltage Buffer
        BIAS_4_AFE_SET(0x344A);
        //POFIPOCO _PU
        //POFIPOCOADSL Mode Enable
        //POFIPOCO VDSL Mode Disabled
        //POFIPOCO Passive 1st Order LP Tuning<9:8>; 01
        //POFIPOCO Cutoff Frequency adjustment<7:4>0000 =>POFIPOCO_LP1_ADJUST_2PF
        //1000 =>POFIPOCO_GAIN_M4DB
        POFIPOCO_GAIN_AFE_SET(0x251D);
        //POFIPOCO_OP2_CASC_P10 : +10% (default)
        //ADSL Mode cutoff frequency in POFIPOCO is 80kHz
        //POFIPOCO_VDSL_NO_FILTERING
        //POFIPOCO VDSL Mode  No Additional -12dB/-6dB Gain
        POFIPOCO_TRIM_1_AFE_SET(0x7F02);

        //POFIPOCO Tuning for VDSL/ADSL modes
        //001B POFIPOCO_OP2_IOUT_75P : 75% (default, ADSL Modes)
        //000B POFIPOCO_OP1_IOUT_50P : 50% (default, ADSL Modes)
        POFIPOCO_TRIM_2_AFE_SET(0x2299);

        FilterTune(POFI_POCO_ADSL_80K); //POFI_POCO_ADSL_80K in Annex A

        //0b DAC1_DATA_2SCOMPLEMENT
        //0b DAC1_DATA_INTPATH : use output data from interpolation path
        //0000 0000 1111b DAC1_STATIC_DATA
        DAC1_STATIC_AFE_SET(0x000F);

        //0b DAC1_REF_CAL_ENABLED
        //1b DAC1_LSBAQ_CAL_DISABLED : Calibration Disabled
        //0b DAC1_MATRIX_CAL_ENABLED(must be same as DAC1_CAL_ENABLED)
        //0b DAC1_CAL_ENABLED
        //001 1111 1111b DAC1_CAL_FIX_DEFAULT: nominal
        //XDSLRTFW-352 Bug_All_US_All_LsbOfDac1Calibration (Start_End)
        DAC1_CAL_1_AFE_SET(0x41FF);

        //0b DAC1_CAL_RANDOM_ON
        //0b DAC1_SET_CAL_ALL_OFF : normal
        //0b DAC1_CAL_RESET_OFF : normal
        //001 1111 1111b DAC1_CAL_VAR_DEFAULT : nominal
        DAC1_CAL_2_AFE_SET(0x01FF);

        //0b DAC1_PU : Power Up
        //1010b: DAC1_GAIN_FINE_MIN : 1.1dB (10*0.11)
        //0010b DAC1_GAIN_COARSE_M1DB45 : -1.45dB (default)
        //DAC1_MISC_1_AFE_SET(0x00A2);
      //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
    DAC1_MISC_1_AFE_SET(gus_DacTrimVal);    //DAC1 COARSE & FINE GAIN settings;  CGain -1.45dB(default)

        //00b DAC1_CAL_CLK_NODIV : no division
        //1b DAC1_ROT_ENABLE : Enabled (default)
        //0b DAC1_ADSL : ADSL Mode = 8bit (default)
        //0b DAC1_DSW_ENABLE : Enabled
        //000b DAC1_ISB_NO_DEM : no DEM
        //000b DAC1_MSB_NO_DEM : no DEM
        DAC1_MISC_2_AFE_SET(0x0400);

        //DAC2_STATIC_DATA_MIN 0 0000 0000 0000
        DAC2_STATIC_AFE_SET(0x0000);
        //000 1111 1111b DAC2_CAL_FIX_DEFAULT : nominal (default)
        DAC2_CAL_1_AFE_SET(0x00FF);
        //DAC2_SET_CAL_ALL_ON : all current cells in calibration
        //000 1111 1111DAC2_CAL_VAR_DEFAULT : nominal (default)
        DAC2_CAL_2_AFE_SET(0x20FF);
        //DAC2_PD : Power Down
        //DAC2 Gain Setting; 0dB (default)
        DAC2_MISC_AFE_SET(0x1700);

        break;
    default:
        break;
    }
    // Set LD mode
    //XDSLRTFW-141: Feature_ALL_ALL_ALL_CMV_LD_Mode (Start)
    //VR9_SetLDMode(LD_VH_ADSL);
     VR9_SetLDMode(gus_LD_Mode);
    //XDSLRTFW-141: Feature_ALL_ALL_ALL_CMV_LD_Mode (End)
   // XDSLRTFW-1630 (Start_End)
    gus_Choosen_LD_Mode = gus_LD_Mode;

#endif // for ADSL_62
} //end of VR9_InitAnalogRegs_Tx

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   VR9_InitAnalogRegs_Rx()
**
** DESCRIPTION:   This function shall be called from VR9_ConfigAFERxPath(),
**                And initialises all the Analog registers in the RxPath
**
** PARAMETERS:     1. us_RxMode is the mode for which AFE regsiters needs to be
**                    programmed.
**
** RETURN VALUE:   NONE
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2) UTP numbser SMS00920529,SMS00974862
**                  (3) VR9_AFEModeSelection.doc
**                  (4) VR9_AFE_mode_settings_v3.xls
** TODO :Values will be changed later currently all registers are programmed for
**       default settings.
** =============================================================================
*/
void VR9_InitAnalogRegs_Rx(uint16 us_RxMode)
{

    switch(us_RxMode)
    {
#ifdef VDSL_62
    case VDSL_30:

        //Adaptive Registers (Start)
        AGC1_RIN1_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_RIN2_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_RINX_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_ROUT2_AFE_SET(0xFFFF);    //Output Resistor of AGC1 HP1.
        AGC1_SHUNT1_AFE_SET(0x0000);   //RSHUNT Input A= OPEN (default)
        AGC1_SHUNT2_AFE_SET(0x0000);   //RSHUNT Input B= OPEN (default)
        AGC1_SHUNTX_AFE_SET(0x0000);   //RSHUNT Input C= OPEN (default)
        //0b AGC1_LEVELSHIFT_PU : Power Up
        //000b CIN_C_OPEN : CIN = OPEN (default)
        //0000b CIN_B_OPEN : CIN = OPEN (default)
        //0000000b AGC1_LP1_CUTOFF_MAX : maximum cutoff frequency
        AGC1_CPROG_AFE_SET(0x0000);
        //0b AGC1_LP1_PU : Power Up
        //0b AGC1_PU_SPEEDUP_ENABLE : Enabled (default)
        //00 0001 1111 1110BAGC1_GAIN_0DB : GAIN = 0dB
        AGC1_GAIN_AFE_SET(0x01FE);
        //Adaptive Registers (End)
        AGC1_HP_AFE_SET(0x9500);       //AGC1_HP1_PD : Power Down (default); etc
        //common Reg for VDSL/ADSL mode
        AGC1_OP1_CURR_AFE_SET(0xB092); //AGC1_VDSL:VDSL Mode = high bandwidth (default); etc

        //Adaptive Registers (Start_End)
        AGC2_INPUT_AFE_SET(0x0F0F);    //HP2 cutoff 2MHz,AGC2 gain 0dB (refer page 144)
        //0000100b AGC2_LP2_CAP_0P4F : 0.4pF
        //010101011b AGC2_LP2_GAIN_0DB : 0dB
        AGC2_FEEDB_AFE_SET(0x08AB);
        AGC2_MISC_AFE_SET(0x1C20);     //AGC2_OP_CMILLER_0dB, for AGC2 gain = 0dB (default),AGC2 PU;
        BIAS_2_AFE_SET(0xAAAA);        //Nominal values set for AGC1 LP1, AGC1 HP1 & AGC1 Levelshifter
        BIAS_3_AFE_SET(0x44AA);        //Nominal values set for POFIPOCO opamps
        //10b ADC_BIAS_SET_OP22_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP12_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP21_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP11_SAFE : safe (more power)
        ADC_BIAS_AFE_SET(0xAAFF);
        ADC_CLK_STG2_AFE_SET(0x0000);   //ADC Clocking Stage2 Power Up
        ADC_LNDEC_STG2_AFE_SET(0x0080); //ADC Line decoder Data Output Stage 2; Enable
        //ADC_DAC12_PU
        //ADC_DAC22_PU : Power Up
        //ADC Reference Trimming DAC12 & DAC22 ; 100% default
        ADC_DACS_STG2_AFE_SET(0x2020);
        //ADC_OVLD_PD : Power Down
        //ADC_OA11_PU : Power  Up
        //ADC_OA21_PU : Power  Up
        //ADC_OA12_PU : Power  Up
        //ADC_OA22_PU : Power  Up
        ADC_LOOPF_MISC_AFE_SET(0x8000);

        ADC_OVLD_AFE_SET(0x0700);       //ADC_OVLD_REF_1V2:ADC Overload Reference Voltage; 1.2V
        //0b ADC_COMP_STG2_PU : Power Up
        //11b ADC_COMPTRIMRANGE_STG2_MAX : maximum (default)
        //0b ADC_LOCALBIAS_PU : Power Up
        //100b ADC_IB_FLASH_30UA : 30uA (default)
        //0b ADC_COMP_STG1_PU : Power Up
        //0b ADC_COMPARATOR_LOWPOWER_DISABLED : Disabled
        ADC_COMP_STG12_AFE_SET(0x0343); //ADC trimming comparators for STG12
        //ADC_NO_RESET : normal (default)
        //ADC_DATAOUT_STG1_ENABLED : Enabled
        ADC_LNDEC_STG1_AFE_SET(0x0180); //ADC Stage1 selection settings
        //ADC_DAC11_PU : Power Up (1st DAC in Stage 1 of ADC)
        //ADC_DAC21_PU : Power Up (2nd DAC in Stage 1 of ADC)
        //10 0000b ADC_DAC21_REFTRIM_DEFAULT : 100% (default)
        ADC_DACS_STG1_AFE_SET(0x0020);

        ADC_DACEXT_AFE_SET(0x00FF);     //ADC Static Data Register for DACs
        //ADC_CLK_STG1_PU : Power Up ADC clocking in the stage 1.
        ADC_CLK_STG1_AFE_SET(0x0000);
        //ADC_DACCAL_PU : Power Up (DACs of stage 1 calibration)
        //11 1111 1111b ADCDAC_STG1_CAL_FIX_MAX : maximum
        ADC_DACCAL_1_AFE_SET(0x03FF);
        ADC_DACCAL_2_AFE_SET(0x007F);//ADC Comparator Calibration with DAC22 & DAC12

        //bits(13:8) will be programmed through FilterTune
        //ADC_C12HALFLSB_OFF : Normal (default)
        //ADC_C12FIX_ON : Normal (default)
        //0111b ADC_BITR12_1_0K5OHM : 0.5kOhm
        //0111b ADC_BITR12_2_0K5OHM : 0.5kOhm
        ADC_LOOPF2_1_AFE_SET(0x4077);   //ADC INTE12 Tuning;
        //1b  ADC_C22FIX_ON : Normal
        //10b ADC_LF2RES_37K50OHM : 37.50kOhm
        //01b ADC_BITR22_NORMAL : normal = differential input enabled
        ADC_LOOPF2_2_AFE_SET(0x4021);   //ADC INTE22 Tuning
        //ADC Gain & INTE11 Tuning
        //00000001b ADC_GAIN_0DB : 0dB
        ADC_LOOPF1_1_AFE_SET(0x4001);
        //1b ADC_C21FIX_ON : Normal (default)
        //0010b ADC_LF1RES_18K63OHM : 18.63kOhm
        // 01b ADC_BITR21_NORMAL : normal = differential input enabled
        ADC_LOOPF1_2_AFE_SET(0x4021);   //ADC INTE21 Tuning

        FilterTune (ADC_INTE11_VDSL_30); //ADC_LOOPF1_1
        FilterTune (ADC_INTE21_VDSL_30); //ADC_LOOPF1_2
        FilterTune (ADC_INTE12_VDSL_30); //ADC_LOOPF2_1
        FilterTune (ADC_INTE22_VDSL_30); //ADC_LOOPF2_2

        //ADC_COMP_QT_AFE_SET(0x2020);    //ADC Trimming comparator selction for STG12
        // Call ADC TrimLoad
        //This fn will program ADC_COMP_QT_AFE_SET
        ADC_Trim_Load(VDSL_30);
        //SMS00972960  - Start
        // Read back actual ADC trim values for the mode selected
        // 27/11/2009: Kannan; Reading back of ADC Trim values from the comparators is not working
        // The values which was loaded into the comparators has been verified from the winhost.
        // It is ok. Hence reading back is disabled now in the code.
        //If required in the future,  It needs tested and enabled.
        //ADC_Trim_Read_OverWrite(VDSL_12);
        //SMS00972960  - End
        break;

    case VDSL_17:

        //Adaptive Registers (Start)
        AGC1_RIN1_AFE_SET(0x7FFF);     //RIN = 192 Ohm
        AGC1_RIN2_AFE_SET(0xFFFF);     //RIN = 192 Ohm
        AGC1_RINX_AFE_SET(0x0000);     //RIN = Open
        AGC1_ROUT2_AFE_SET(0x0000);    //Open
        AGC1_SHUNT1_AFE_SET(0x0800);   //RSHUNT Input A=1440 Ohm
        AGC1_SHUNT2_AFE_SET(0x0000);   //RSHUNT Input B=OPEN (default)
        AGC1_SHUNTX_AFE_SET(0x80FF);   //RSHUNT Input C=360 Ohm. AGC1 Input C Off

        //0b AGC1_LEVELSHIFT_PU : Power Up
        //000b CIN_C_OPEN : CIN = OPEN (default)
        //1001b CIN_B_OPEN : CIN = 9pF
        //0000001b
        AGC1_CPROG_AFE_SET(0x0901);

        //0b AGC1_LP1_PU : Power Up
        //0b AGC1_PU_SPEEDUP_ENABLE : Enabled (default)
        //00 0001 1110 0010 GAIN = 4dB
        AGC1_GAIN_AFE_SET(0x01E2);
        //Adaptive Registers (End)

        AGC1_HP_AFE_SET(0x9500);       //AGC1_HP1_PD : Power Down (default); etc
        //common Reg for VDSL/ADSL mode
        AGC1_OP1_CURR_AFE_SET(0xB092); //AGC1_VDSL:VDSL Mode = high bandwidth (default); etc

        //Adaptive Registers (Start_End)
        AGC2_INPUT_AFE_SET(0x000F);    // RL1=0.8k Ohm; RQ1=RQ2=OPEN

        //0000001b 0.1pF
        //010101011b AGC2_LP2_GAIN_0DB : 0dB
        AGC2_FEEDB_AFE_SET(0x02AB);

        AGC2_MISC_AFE_SET(0x1C20);     //AGC2_OP_CMILLER_0dB, for AGC2 gain = 0dB (default),AGC2 PU;
        BIAS_2_AFE_SET(0xAAAA);        //Nominal values set for AGC1 LP1, AGC1 HP1 & AGC1 Levelshifter
        BIAS_3_AFE_SET(0x44AA);        //Nominal values set for POFIPOCO opamps
        //10b ADC_BIAS_SET_OP22_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP12_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP21_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP11_SAFE : safe (more power)
        ADC_BIAS_AFE_SET(0xAAFF);
        ADC_CLK_STG2_AFE_SET(0x0000);   //ADC Clocking Stage2 Power Up
        ADC_LNDEC_STG2_AFE_SET(0x0080); //ADC Line decoder Data Output Stage 2; Enable
        //ADC_DAC12_PU
        //ADC_DAC22_PU : Power Up
        //ADC Reference Trimming DAC12 & DAC22 ; 100% default
        ADC_DACS_STG2_AFE_SET(0x2020);

        //ADC_OVLD_PD : Power Down
        //ADC_OA11_PU : Power  Up
        //ADC_OA21_PU : Power  Up
        //ADC_OA12_PU : Power  Up
        //ADC_OA22_PU : Power  Up
        ADC_LOOPF_MISC_AFE_SET(0x8000);

        ADC_OVLD_AFE_SET(0x0700);       //ADC_OVLD_REF_1V2:ADC Overload Reference Voltage; 1.2V
        //0b ADC_COMP_STG2_PU : Power Up
        //11b ADC_COMPTRIMRANGE_STG2_MAX : maximum (default)
        //0b ADC_LOCALBIAS_PU : Power Up
        //100b ADC_IB_FLASH_30UA : 30uA (default)
        //0b ADC_COMP_STG1_PU : Power Up
        //0b ADC_COMPARATOR_LOWPOWER_DISABLED : Disabled
        ADC_COMP_STG12_AFE_SET(0x0343); //ADC trimming comparators for STG12
        //ADC_NO_RESET : normal (default)
        //ADC_DATAOUT_STG1_ENABLED : Enabled
        ADC_LNDEC_STG1_AFE_SET(0x0180); //ADC Stage1 selection settings

        //ADC_DAC11_PU : Power Up (1st DAC in Stage 1 of ADC)
        //ADC_DAC21_PU : Power Up (2nd DAC in Stage 1 of ADC)
        //10 0000b ADC_DAC21_REFTRIM_DEFAULT : 100% (default)
        ADC_DACS_STG1_AFE_SET(0x0020);

        ADC_DACEXT_AFE_SET(0x00FF);     //ADC Static Data Register for DACs
        //ADC_CLK_STG1_PU : Power Up ADC clocking in the stage 1.
        ADC_CLK_STG1_AFE_SET(0x0000);

        //ADC_DACCAL_PU : Power Up (DACs of stage 1 calibration)
        //11 1111 1111b ADCDAC_STG1_CAL_FIX_MAX : maximum
        ADC_DACCAL_1_AFE_SET(0x03FF);

        ADC_DACCAL_2_AFE_SET(0x007F);   //ADC Comparator Calibration with DAC22 & DAC12

        //bits(13:8) will be programmed through FilterTune
        //ADC_C12HALFLSB_OFF : Normal (default)
        //ADC_C12FIX_ON : Normal (default)
        //0111b ADC_BITR12_1_0K5OHM : 0.5kOhm
        //0111b ADC_BITR12_2_0K5OHM : 0.5kOhm
        ADC_LOOPF2_1_AFE_SET(0x4077);   //ADC INTE12 Tuning;
        //1b  ADC_C22FIX_ON : Normal
        //01b ADC_LF2RES_18K75OHM : 18.75kOhm
        //01b ADC_BITR22_NORMAL : normal = differential input enabled
        ADC_LOOPF2_2_AFE_SET(0x4011);   //ADC INTE22 Tuning

        //ADC Gain & INTE11 Tuning
        //00000001b ADC_GAIN_0DB : 0dB
        ADC_LOOPF1_1_AFE_SET(0x4001);

        //1b  ADC_C21FIX_ON : Normal (default)
        //0001b ADC_LF1RES_9K38OHM : 9.38kOhm
        //01b ADC_BITR21_NORMAL : normal = differential input enabled
        ADC_LOOPF1_2_AFE_SET(0x4011);   //ADC INTE21 Tuning

        FilterTune (ADC_INTE11_VDSL_17); //ADC_LOOPF1_1
        FilterTune (ADC_INTE21_VDSL_17); //ADC_LOOPF1_2
        FilterTune (ADC_INTE12_VDSL_17); //ADC_LOOPF2_1
        FilterTune (ADC_INTE22_VDSL_17); //ADC_LOOPF2_2

        //ADC_COMP_QT_AFE_SET(0x2020);    //ADC Trimming comparator selction for STG12
        // Call ADC TrimLoad
        //This fn will program ADC_COMP_QT_AFE_SET
        ADC_Trim_Load(VDSL_17);
        //SMS00972960  - Start
        // Read back actual ADC trim values for the mode selected
        // 27/11/2009: Kannan; Reading back of ADC Trim values from the comparators is not working
        // The values which was loaded into the comparators has been verified from the winhost.
        // It is ok. Hence reading back is disabled now in the code.
        //If required in the future,  It needs tested and enabled.
        //ADC_Trim_Read_OverWrite(VDSL_17);
        //SMS00972960  - End
        break;

    case VDSL_12:

        //Adaptive Registers (Start)
        AGC1_RIN1_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_RIN2_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_RINX_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_ROUT2_AFE_SET(0xFFFF);    //Output Resistor of AGC1 HP1.
        AGC1_SHUNT1_AFE_SET(0x0000);   //RSHUNT Input A= OPEN (default)
        AGC1_SHUNT2_AFE_SET(0x0000);   //RSHUNT Input B= OPEN (default)
        AGC1_SHUNTX_AFE_SET(0x0000);   //RSHUNT Input C= OPEN (default)
        //0b AGC1_LEVELSHIFT_PU : Power Up
        //000b CIN_C_OPEN : CIN = OPEN (default)
        //0000b CIN_B_OPEN : CIN = OPEN (default)
        //0000000b AGC1_LP1_CUTOFF_MAX : maximum cutoff frequency
        AGC1_CPROG_AFE_SET(0x0000);
        //0b AGC1_LP1_PU : Power Up
        //0b AGC1_PU_SPEEDUP_ENABLE : Enabled (default)
        //00 0001 1111 1110BAGC1_GAIN_0DB : GAIN = 0dB
        AGC1_GAIN_AFE_SET(0x01FE);
        //Adaptive Registers (End)
        AGC1_HP_AFE_SET(0x9500);       //AGC1_HP1_PD : Power Down (default); etc
        //common Reg for VDSL/ADSL mode
        AGC1_OP1_CURR_AFE_SET(0xB092); //AGC1_VDSL:VDSL Mode = high bandwidth (default); etc

        //Adaptive Registers (Start_End)
        AGC2_INPUT_AFE_SET(0x0F0F);    //HP2 cutoff 2MHz,AGC2 gain 0dB (refer page 144)
        //0000100b AGC2_LP2_CAP_0P4F : 0.4pF
        //010101011b AGC2_LP2_GAIN_0DB : 0dB
        AGC2_FEEDB_AFE_SET(0x08AB);
        AGC2_MISC_AFE_SET(0x1C20);     //AGC2_OP_CMILLER_0dB, for AGC2 gain = 0dB (default),AGC2 PU;
        BIAS_2_AFE_SET(0xAAAA);        //Nominal values set for AGC1 LP1, AGC1 HP1 & AGC1 Levelshifter
        BIAS_3_AFE_SET(0x44AA);        //Nominal values set for POFIPOCO opamps
        //10b ADC_BIAS_SET_OP22_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP12_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP21_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP11_SAFE : safe (more power)
        ADC_BIAS_AFE_SET(0xAAFF);
        ADC_CLK_STG2_AFE_SET(0x0000);   //ADC Clocking Stage2 Power Up
        ADC_LNDEC_STG2_AFE_SET(0x0080); //ADC Line decoder Data Output Stage 2; Enable
        //ADC_DAC12_PD
        //00 0000b ADC_DAC12_REFTRIM_MIN
        //ADC_DAC22_PU : Power Up
        //ADC Reference Trimming  DAC22 ; 100% default
        ADC_DACS_STG2_AFE_SET(0xA020);

        //ADC_OVLD_PD : Power Down
        //ADC_OA11_PU : Power  Up
        //ADC_OA21_PU : Power  Up
        //ADC_OA12_PU : Power  Up
        //ADC_OA22_PU : Power  Up
        ADC_LOOPF_MISC_AFE_SET(0x8000);

        ADC_OVLD_AFE_SET(0x0700);       //ADC_OVLD_REF_1V2:ADC Overload Reference Voltage; 1.2V

        //0b ADC_COMP_STG2_PU : Power Up
        //11b ADC_COMPTRIMRANGE_STG2_MAX : maximum (default)
        //0b ADC_LOCALBIAS_PU : Power Up
        //100b ADC_IB_FLASH_30UA : 30uA (default)
        //0b ADC_COMP_STG1_PU : Power Up
        //0b ADC_COMPARATOR_LOWPOWER_DISABLED : Disabled
        ADC_COMP_STG12_AFE_SET(0x0343); //ADC trimming comparators for STG12

        //ADC_NO_RESET : normal (default)
        //ADC_DATAOUT_STG1_ENABLED : Enabled
        ADC_LNDEC_STG1_AFE_SET(0x0180); //ADC Stage1 selection settings

        //ADC_DAC11_PU : Power Up (1st DAC in Stage 1 of ADC)
        //ADC_DAC21_PU : Power Up (2nd DAC in Stage 1 of ADC)
        //10 0000b ADC_DAC21_REFTRIM_DEFAULT : 100% (default)
        ADC_DACS_STG1_AFE_SET(0x0020);

        ADC_DACEXT_AFE_SET(0x00FF);     //ADC Static Data Register for DACs
        //ADC_CLK_STG1_PU : Power Up ADC clocking in the stage 1.
        ADC_CLK_STG1_AFE_SET(0x0000);

        //ADC_DACCAL_PU : Power Up (DACs of stage 1 calibration)
        //11 1111 1111b ADCDAC_STG1_CAL_FIX_MAX : maximum
        ADC_DACCAL_1_AFE_SET(0x03FF);

        ADC_DACCAL_2_AFE_SET(0x007F);   //ADC Comparator Calibration with DAC22 & DAC12

        //bits(13:8) will be programmed through FilterTune
        //ADC_C12HALFLSB_OFF : Normal (default)
        //ADC_C12FIX_ON : Normal (default)
        //0111b ADC_BITR12_1_0K5OHM : 0.5kOhm
        //0111b ADC_BITR12_2_0K5OHM : 0.5kOhm
        ADC_LOOPF2_1_AFE_SET(0x4077);   //ADC INTE12 Tuning;
        //1b  ADC_C22FIX_ON : Normal
        // 00b ADC_LF2RES_OPEN : OPEN (default)
        //01b ADC_BITR22_NORMAL : normal = differential input enabled
        ADC_LOOPF2_2_AFE_SET(0x4009);   //ADC INTE22 Tuning

        //ADC Gain & INTE11 Tuning
        //00000001b ADC_GAIN_0DB : 0dB
        ADC_LOOPF1_1_AFE_SET(0x4001);

        //1b  ADC_C21FIX_ON : Normal (default)
        //0100b ADC_LF1RES_59K50OHM : 59.50kOhm
        //01b ADC_BITR21_NORMAL : normal = differential input enabled
        ADC_LOOPF1_2_AFE_SET(0x4041);   //ADC INTE21 Tuning

        FilterTune (ADC_INTE11_VDSL_12); //ADC_LOOPF1_1
        FilterTune (ADC_INTE21_VDSL_12); //ADC_LOOPF1_2
        FilterTune (ADC_INTE22_VDSL_12); //ADC_LOOPF2_2


        //ADC_COMP_QT_AFE_SET(0x2020);    //ADC Trimming comparator selction for STG12
        // Call ADC TrimLoad
        //This fn will program ADC_COMP_QT_AFE_SET
        ADC_Trim_Load(VDSL_12);
        //SMS00972960  - Start
        // Read back actual ADC trim values for the mode selected
        // 27/11/2009: Kannan; Reading back of ADC Trim values from the comparators is not working
        // The values which was loaded into the comparators has been verified from the winhost.
        // It is ok. Hence reading back is disabled now in the code.
        //If required in the future,  It needs tested and enabled.
        //ADC_Trim_Read_OverWrite(VDSL_12);
        //SMS00972960  - End
        break;

    case VDSL_8:

        //Adaptive Registers (Start)
        AGC1_RIN1_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_RIN2_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_RINX_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
        AGC1_ROUT2_AFE_SET(0xFFFF);    //Output Resistor of AGC1 HP1.
        AGC1_SHUNT1_AFE_SET(0x0000);   //RSHUNT Input A= OPEN (default)
        AGC1_SHUNT2_AFE_SET(0x0000);   //RSHUNT Input B= OPEN (default)
        AGC1_SHUNTX_AFE_SET(0x0000);   //RSHUNT Input C= OPEN (default)
        //0b AGC1_LEVELSHIFT_PU : Power Up
        //000b CIN_C_OPEN : CIN = OPEN (default)
        //0000b CIN_B_OPEN : CIN = OPEN (default)
        //0000000b AGC1_LP1_CUTOFF_MAX : maximum cutoff frequency
        AGC1_CPROG_AFE_SET(0x0000);
        //0b AGC1_LP1_PU : Power Up
        //0b AGC1_PU_SPEEDUP_ENABLE : Enabled (default)
        //00 0001 1111 1110BAGC1_GAIN_0DB : GAIN = 0dB
        AGC1_GAIN_AFE_SET(0x01FE);
        //Adaptive Registers (End)
        AGC1_HP_AFE_SET(0x9500);       //AGC1_HP1_PD : Power Down (default); etc
        //common Reg for VDSL/ADSL mode
        AGC1_OP1_CURR_AFE_SET(0xB092); //AGC1_VDSL:VDSL Mode = high bandwidth (default); etc

        //Adaptive Registers (Start_End)
        AGC2_INPUT_AFE_SET(0x0F0F);    //HP2 cutoff 2MHz,AGC2 gain 0dB (refer page 144)
        //0000100b AGC2_LP2_CAP_0P4F : 0.4pF
        //010101011b AGC2_LP2_GAIN_0DB : 0dB
        AGC2_FEEDB_AFE_SET(0x08AB);
        AGC2_MISC_AFE_SET(0x1C20);     //AGC2_OP_CMILLER_0dB, for AGC2 gain = 0dB (default),AGC2 PU;
        BIAS_2_AFE_SET(0xAAAA);        //Nominal values set for AGC1 LP1, AGC1 HP1 & AGC1 Levelshifter
        BIAS_3_AFE_SET(0x44AA);        //Nominal values set for POFIPOCO opamps
        //10b ADC_BIAS_SET_OP22_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP12_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP21_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP11_SAFE : safe (more power)
        ADC_BIAS_AFE_SET(0xAAFF);
        ADC_CLK_STG2_AFE_SET(0x0000);   //ADC Clocking Stage2 Power Up
        ADC_LNDEC_STG2_AFE_SET(0x0080); //ADC Line decoder Data Output Stage 2; Enable
        //ADC_DAC12_PD
        //00 0000b ADC_DAC12_REFTRIM_MIN
        //ADC_DAC22_PU : Power Up
        //ADC Reference Trimming  DAC22 ; 100% default
        ADC_DACS_STG2_AFE_SET(0xA020);

        //ADC_OVLD_PD : Power Down
        //ADC_OA11_PU : Power  Up
        //ADC_OA21_PU : Power  Up
        //ADC_OA12_PU : Power  Up
        //ADC_OA22_PU : Power  Up
        ADC_LOOPF_MISC_AFE_SET(0x8000);

        ADC_OVLD_AFE_SET(0x0700);       //ADC_OVLD_REF_1V2:ADC Overload Reference Voltage; 1.2V

        //0b ADC_COMP_STG2_PU : Power Up
        //11b ADC_COMPTRIMRANGE_STG2_MAX : maximum (default)
        //0b ADC_LOCALBIAS_PU : Power Up
        //100b ADC_IB_FLASH_30UA : 30uA (default)
        //0b ADC_COMP_STG1_PU : Power Up
        //0b ADC_COMPARATOR_LOWPOWER_DISABLED : Disabled
        ADC_COMP_STG12_AFE_SET(0x0343); //ADC trimming comparators for STG12

        //ADC_NO_RESET : normal (default)
        //ADC_DATAOUT_STG1_ENABLED : Enabled
        ADC_LNDEC_STG1_AFE_SET(0x0180); //ADC Stage1 selection settings

        //ADC_DAC11_PU : Power Up (1st DAC in Stage 1 of ADC)
        //ADC_DAC21_PU : Power Up (2nd DAC in Stage 1 of ADC)
        //10 0000b ADC_DAC21_REFTRIM_DEFAULT : 100% (default)
        ADC_DACS_STG1_AFE_SET(0x0020);

        ADC_DACEXT_AFE_SET(0x00FF);     //ADC Static Data Register for DACs
        //ADC_CLK_STG1_PU : Power Up ADC clocking in the stage 1.
        ADC_CLK_STG1_AFE_SET(0x0000);

        //ADC_DACCAL_PU : Power Up (DACs of stage 1 calibration)
        //11 1111 1111b ADCDAC_STG1_CAL_FIX_MAX : maximum
        ADC_DACCAL_1_AFE_SET(0x03FF);

        ADC_DACCAL_2_AFE_SET(0x007F);   //ADC Comparator Calibration with DAC22 & DAC12

        //bits(13:8) will be programmed through FilterTune
        //ADC_C12HALFLSB_OFF : Normal (default)
        //ADC_C12FIX_ON : Normal (default)
        //0111b ADC_BITR12_1_0K5OHM : 0.5kOhm
        //0111b ADC_BITR12_2_0K5OHM : 0.5kOhm
        ADC_LOOPF2_1_AFE_SET(0x4077);   //ADC INTE12 Tuning;
        //1b  ADC_C22FIX_ON : Normal
        // 00b ADC_LF2RES_OPEN : OPEN (default)
        //01b ADC_BITR22_NORMAL : normal = differential input enabled
        ADC_LOOPF2_2_AFE_SET(0x4009);   //ADC INTE22 Tuning


        //ADC Gain & INTE11 Tuning
        //00000001b ADC_GAIN_0DB : 0dB
        ADC_LOOPF1_1_AFE_SET(0x4001);
        //1b  ADC_C21FIX_ON : Normal (default)
        //0100b ADC_LF1RES_59K50OHM : 59.50kOhm
        //01b ADC_BITR21_NORMAL : normal = differential input enabled
        ADC_LOOPF1_2_AFE_SET(0x4041);   //ADC INTE21 Tuning

        // ADC settings for VDSL_8 mode are same as VDSL12 mode.
        FilterTune (ADC_INTE11_VDSL_12); //ADC_LOOPF1_1
        FilterTune (ADC_INTE21_VDSL_12); //ADC_LOOPF1_2
        FilterTune (ADC_INTE22_VDSL_12); //ADC_LOOPF2_2

        //ADC_COMP_QT_AFE_SET(0x2020);    //ADC Trimming comparator selction for STG12
        // Call ADC TrimLoad
        //This fn will program ADC_COMP_QT_AFE_SET
        ADC_Trim_Load(VDSL_12); //TODO (confirm with Villach they say mode should be VDSL_12)
        //SMS00972960  - Start
        // Read back actual ADC trim values for the mode selected
        // 27/11/2009: Kannan; Reading back of ADC Trim values from the comparators is not working
        // The values which was loaded into the comparators has been verified from the winhost.
        // It is ok. Hence reading back is disabled now in the code.
        //If required in the future,  It needs tested and enabled.
        //ADC_Trim_Read_OverWrite(VDSL_12);
        //SMS00972960  - End
        break;

    default:
        break;
#endif //for VDSL_62
#ifdef ADSL_62
    case ADSL_B:
        //Adaptive Registers (Start)
        AGC1_RIN1_AFE_SET(0x7FFF);     //RIN = 360Ohm (default)
        AGC1_RIN2_AFE_SET(0x0007);     //RIN = 360Ohm (default)
        AGC1_RINX_AFE_SET(0x0000);     //RIN = 360Ohm (default)
        AGC1_ROUT2_AFE_SET(0x0000);    //Output Resistor of AGC1 HP1.
        AGC1_SHUNT1_AFE_SET(0x0000);   //RSHUNT Input A= OPEN (default)
        AGC1_SHUNT2_AFE_SET(0x0400);   //RSHUNT Input B= OPEN (default)
        AGC1_SHUNTX_AFE_SET(0x80FF);   //RSHUNT Input C= OPEN (default)
        //0b AGC1_LEVELSHIFT_PU : Power Up
        //000b CIN_C_OPEN : CIN = OPEN (default)
        //0000b CIN_B_OPEN : CIN = OPEN (default)
        //0000000b AGC1_LP1_CUTOFF_MAX : maximum cutoff frequency
        AGC1_CPROG_AFE_SET(0x0001);
        //0b AGC1_LP1_PU : Power Up
        //0b AGC1_PU_SPEEDUP_ENABLE : Enabled (default)
        //00 0001 1111 1110BAGC1_GAIN_0DB : GAIN = 0dB
        AGC1_GAIN_AFE_SET(0x0014);
        //Adaptive Registers (End)
        AGC1_HP_AFE_SET(0x9500);       //AGC1_HP1_PD : Power Down (default); etc
        //common Reg for VDSL/ADSL mode
        //AGC1_ADSL : ADSL Mode = low 1/f noise
        AGC1_OP1_CURR_AFE_SET(0x3092);

        //Adaptive Registers (Start_End)
        AGC2_INPUT_AFE_SET(0x0101);    //HP2 cutoff 0.5MHz,AGC2 gain -12dB (refer page 144)
        //0000100b AGC2_LP2_CAP_0P4F : 0.4pF
        //010101011b AGC2_LP2_GAIN_0DB : 0dB
        AGC2_FEEDB_AFE_SET(0x02AA);
        AGC2_MISC_AFE_SET(0x1C20);     //AGC2_OP_CMILLER_0dB, for AGC2 gain = 0dB (default),AGC2 PU;
        BIAS_2_AFE_SET(0xAAAA);        //Nominal values set for AGC1 LP1, AGC1 HP1 & AGC1 Levelshifter
        BIAS_3_AFE_SET(0x44AA);        //Nominal values set for POFIPOCO opamps
        //00b ADC_BIAS_SET_OP22_DEFAULT : default
        //00b ADC_BIAS_SET_OP12_DEFAULT : default
        //10b ADC_BIAS_SET_OP21_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP11_SAFE : safe (more power)
        ADC_BIAS_AFE_SET(0xAAFF);
        ADC_CLK_STG2_AFE_SET(0x0000);   //ADC Clocking Stage2 Power Down (default)
        ADC_LNDEC_STG2_AFE_SET(0x0080); //ADC Line decoder Data Output Stage 2; Disable
        //ADC_DAC12_PD :Power Down
        //00 0000b ADC_DAC12_REFTRIM_MIN
        //ADC_DAC22_PD : Power Down
        //00 0000b ADC_DAC22_REFTRIM_MIN
        ADC_DACS_STG2_AFE_SET(0xA020);

        //ADC_OVLD_PD : Power Down
        //ADC_OA11_PU : Power  Up
        //ADC_OA21_PU : Power  Up
        //ADC_OA12_PD : Power  Down (1st integrator in stage 2)
        //ADC_OA22_PD : Power  Down (2nd integrator in stage 2)
        ADC_LOOPF_MISC_AFE_SET(0x8000);

        ADC_OVLD_AFE_SET(0x0700);       //ADC_OVLD_REF_1V2:ADC Overload Reference Voltage; 1.2V
        //1b ADC_COMP_STG2_PD : ADC comparators stage 2 Power Down
        //0b ADC_LOCALBIAS_PU : Power Up
        //100b ADC_IB_FLASH_30UA : 30uA (default)
        //0b ADC_COMP_STG1_PU : Power Up
        //0b ADC_COMPARATOR_LOWPOWER_DISABLED : Disabled
        ADC_COMP_STG12_AFE_SET(0x0343); //ADC trimming comparators for STG12
        //ADC_NO_RESET : normal (default)
        //ADC_DATAOUT_STG1_ENABLED : Enabled
        ADC_LNDEC_STG1_AFE_SET(0x0180); //ADC Stage1 selection settings

        //ADC_DAC11_PU : Power Up (1st DAC in Stage 1 of ADC)
        //ADC_DAC21_PU : Power Up (2nd DAC in Stage 1 of ADC)
        //10 0000b ADC_DAC21_REFTRIM_DEFAULT : 100% (default)
        ADC_DACS_STG1_AFE_SET(0x0020);

        ADC_DACEXT_AFE_SET(0x00FF);     //ADC Static Data Register for DACs
        //ADC_CLK_STG1_PU : Power Up ADC clocking in the stage 1.
        ADC_CLK_STG1_AFE_SET(0x0000);

        //ADC_DACCAL_PU : Power Up (DACs of stage 1 calibration)
        //11 1111 1111b ADCDAC_STG1_CAL_FIX_MAX : maximum
        ADC_DACCAL_1_AFE_SET(0x03FF);

        ADC_DACCAL_2_AFE_SET(0x007F);   //ADC Comparator Calibration with DAC22 & DAC12

        //bits(13:8) will be programmed through FilterTune
        //ADC_C12HALFLSB_OFF : Normal (default)
        //ADC_C12FIX_ON : Normal (default)
        // 1000b ADC_BITR12_1_TO_VCM
        // 1000b ADC_BITR12_2_TO_VCM
        ADC_LOOPF2_1_AFE_SET(0x4077);   //ADC INTE12 Tuning;
        // 1b  ADC_C22FIX_ON : Normal
        //00b ADC_LF2RES_OPEN : OPEN (default)
        //10b ADC_BITR22_TO_VCM
        ADC_LOOPF2_2_AFE_SET(0x4009);   //ADC INTE22 Tuning

        //ADC Gain & INTE11 Tuning
        //00000001b ADC_GAIN_0DB : 0dB
        ADC_LOOPF1_1_AFE_SET(0x4001);

        //1b  ADC_C21FIX_ON : Normal (default)
        //1000b ADC_LF1RES_122K75OHM : 122.75kOhm
        //01b ADC_BITR21_NORMAL : normal = differential input enabled
        ADC_LOOPF1_2_AFE_SET(0x4041);   //ADC INTE21 Tuning

        //ADC modes are VDSL5 MHz.for ADSL2/2p
        //Minimum ADC mode should be VDSL12 settings,
        //don't use VDSL_5 as min settings for ADC mode.
        //FilterTune(ADC_INTE11_VDSL_5); //ADC_LOOPF1_1
        //FilterTune(ADC_INTE21_VDSL_5); //ADC_LOOPF1_2

         // ADC settings for VDSL_8 mode are same as VDSL12 and ADSL mode.
         FilterTune (ADC_INTE11_VDSL_12); //ADC_LOOPF1_1
         FilterTune (ADC_INTE21_VDSL_12); //ADC_LOOPF1_2
         FilterTune (ADC_INTE22_VDSL_12); //ADC_LOOPF2_2

        //ADC_COMP_QT_AFE_SET(0x2020);    //ADC Trimming comparator selction for STG12
        // Call ADC TrimLoad with VDSL5 mode
        //This fn will program ADC_COMP_QT_AFE_SET
        // see AFE spec page 15
        //ADC_Trim_Load(VDSL_5);
        //Load VDSL12 ADC trim values, since VDSL12 is the  minimum value which is supposed to be loaded
        ADC_Trim_Load(VDSL_12);
        //SMS00972960  - Start
        // Read back actual ADC trim values for the mode selected
        // 27/11/2009: Kannan; Reading back of ADC Trim values from the comparators is not working
        // The values which was loaded into the comparators has been verified from the winhost.
        // It is ok. Hence reading back is disabled now in the code.
        //If required in the future,  It needs tested and enabled.
        //ADC_Trim_Read_OverWrite(VDSL_5);
        //SMS00972960  - End
        break;
    case ADSL_A:
        //Adaptive Registers (Start)
        AGC1_RIN1_AFE_SET(0x03FF);     //RIN = 360Ohm (default)
        AGC1_RIN2_AFE_SET(0x0000);     //RIN = 360Ohm (default)
        AGC1_RINX_AFE_SET(0x000F);     //RIN = 360Ohm (default)
        AGC1_ROUT2_AFE_SET(0x0003);    //Output Resistor of AGC1 HP1.
        AGC1_SHUNT1_AFE_SET(0x0100);   //RSHUNT Input A= OPEN (default)
        AGC1_SHUNT2_AFE_SET(0x80FF);   //RSHUNT Input B= OPEN (default)
        AGC1_SHUNTX_AFE_SET(0x0000);   //RSHUNT Input C= OPEN (default)
        //0b AGC1_LEVELSHIFT_PU : Power Up
        //000b CIN_C_OPEN : CIN = OPEN (default)
        //0000b CIN_B_OPEN : CIN = OPEN (default)
        //0000000b AGC1_LP1_CUTOFF_MAX : maximum cutoff frequency
        AGC1_CPROG_AFE_SET(0x0042);
        //0b AGC1_LP1_PU : Power Up
        //0b AGC1_PU_SPEEDUP_ENABLE : Enabled (default)
        //00 0001 1111 1110BAGC1_GAIN_0DB : GAIN = 0dB
        AGC1_GAIN_AFE_SET(0x1000);
        //Adaptive Registers (End)
        //AGC1_HP1_PU : Power Up
        //001b AGC1_HP1_OP_IOUT_DEFAULT : nominal current (default)
        //1b AGC1_HP1_OP_CMILLER_MAX : maximum
        //111b AGC1_HP1_CAP_100PF : 100pF
        AGC1_HP_AFE_SET(0x1517);

        //AGC1_ADSL : ADSL Mode = low 1/f noise
        AGC1_OP1_CURR_AFE_SET(0x3092);

        //Adaptive Registers (Start_End)
        AGC2_INPUT_AFE_SET(0x0101);    //HP2 cutoff 0.5MHz,AGC2 gain -12dB (refer page 144)
        AGC2_FEEDB_AFE_SET(0x02AA);    //AGC2_LP2_GAIN_6dB,refer page 142 Table 56
        AGC2_MISC_AFE_SET(0x1C20);     //AGC2_OP_CMILLER_0dB, for AGC2 gain = 0dB (default),AGC2 PU;
        BIAS_2_AFE_SET(0xAAAA);        //Nominal values set for AGC1 LP1, AGC1 HP1 & AGC1 Levelshifter
        BIAS_3_AFE_SET(0x44AA);        //Nominal values set for POFIPOCO opamps
        //00b ADC_BIAS_SET_OP22_DEFAULT : default
        //00b ADC_BIAS_SET_OP12_DEFAULT : default
        //10b ADC_BIAS_SET_OP21_SAFE : safe (more power)
        //10b ADC_BIAS_SET_OP11_SAFE : safe (more power)
        ADC_BIAS_AFE_SET(0xAAFF);
        ADC_CLK_STG2_AFE_SET(0x0000);   //ADC Clocking Stage2 Power Down (default)
        ADC_LNDEC_STG2_AFE_SET(0x0080); //ADC Line decoder Data Output Stage 2;Disable
        //ADC_DAC12_PD :Power Down
        //00 0000b ADC_DAC12_REFTRIM_MIN
        //ADC_DAC22_PU : Power Down
        //00 0000b ADC_DAC22_REFTRIM_MIN
        ADC_DACS_STG2_AFE_SET(0xA020);

        //ADC_OVLD_PD : Power Down
        //ADC_OA11_PU : Power  Up
        //ADC_OA21_PU : Power  Up
        //ADC_OA12_PD : Power  Down (1st integrator in stage 2)
        //ADC_OA22_PD : Power  Down (2nd integrator in stage 2)
        ADC_LOOPF_MISC_AFE_SET(0x8000);

        ADC_OVLD_AFE_SET(0x0700);       //ADC_OVLD_REF_1V2:ADC Overload Reference Voltage; 1.2V
        //1b ADC_COMP_STG2_PD : ADC comparators stage 2 Power Down
        //0b ADC_LOCALBIAS_PU : Power Up
        //100b ADC_IB_FLASH_30UA : 30uA (default)
        //0b ADC_COMP_STG1_PU : Power Up
        //0b ADC_COMPARATOR_LOWPOWER_DISABLED : Disabled
        ADC_COMP_STG12_AFE_SET(0x0343); //ADC trimming comparators for STG12
        //ADC_NO_RESET : normal (default)
        //ADC_DATAOUT_STG1_ENABLED : Enabled
        ADC_LNDEC_STG1_AFE_SET(0x0180); //ADC Stage1 selection settings

        //ADC_DAC11_PU : Power Up (1st DAC in Stage 1 of ADC)
        //ADC_DAC21_PU : Power Up (2nd DAC in Stage 1 of ADC)
        //10 0000b ADC_DAC21_REFTRIM_DEFAULT : 100% (default)
        ADC_DACS_STG1_AFE_SET(0x0020);


        ADC_DACEXT_AFE_SET(0x00FF);     //ADC Static Data Register for DACs
        //ADC_CLK_STG1_PU : Power Up ADC clocking in the stage 1.
        ADC_CLK_STG1_AFE_SET(0x0000);

        //ADC_DACCAL_PU : Power Up (DACs of stage 1 calibration)
        //11 1111 1111b ADCDAC_STG1_CAL_FIX_MAX : maximum
        ADC_DACCAL_1_AFE_SET(0x03FF);

        ADC_DACCAL_2_AFE_SET(0x007F);   //ADC Comparator Calibration with DAC22 & DAC12

        //bits(13:8) will be programmed through FilterTune
        //ADC_C12HALFLSB_OFF : Normal (default)
        //ADC_C12FIX_ON : Normal (default)
        // 1000b ADC_BITR12_1_TO_VCM
        // 1000b ADC_BITR12_2_TO_VCM
        ADC_LOOPF2_1_AFE_SET(0x4077);   //ADC INTE12 Tuning;
        // 1b  ADC_C22FIX_ON : Normal
        //00b ADC_LF2RES_OPEN : OPEN (default)
        //10b ADC_BITR22_TO_VCM
        ADC_LOOPF2_2_AFE_SET(0x4009);   //ADC INTE22 Tuning

        //ADC Gain & INTE11 Tuning
        //00000001b ADC_GAIN_0DB : 0dB
        ADC_LOOPF1_1_AFE_SET(0x4001);

        //1b  ADC_C21FIX_ON : Normal (default)
        //1000b ADC_LF1RES_122K75OHM : 122.75kOhm
        //01b ADC_BITR21_NORMAL : normal = differential input enabled
        ADC_LOOPF1_2_AFE_SET(0x4041);   //ADC INTE21 Tuning

        //ADC modes are VDSL5 MHz.for ADSL2/2p
        //FilterTune(ADC_INTE11_VDSL_5); //ADC_LOOPF1_1
        //FilterTune(ADC_INTE21_VDSL_5); //ADC_LOOPF1_2
        // ADC settings for VDSL_8 mode are same as VDSL12 and ADSL mode.
        FilterTune (ADC_INTE11_VDSL_12); //ADC_LOOPF1_1
        FilterTune (ADC_INTE21_VDSL_12); //ADC_LOOPF1_2
        FilterTune (ADC_INTE22_VDSL_12); //ADC_LOOPF2_2

        //ADC_COMP_QT_AFE_SET(0x2020);    //ADC Trimming comparator selction for STG12
        // Call ADC TrimLoad with VDSL5 mode
        //This fn will program ADC_COMP_QT_AFE_SET
        // see AFE spec page 15
        //ADC_Trim_Load(VDSL_5);
        //Load VDSL12 ADC trim values, since VDSL12 is the  minimum value which is supposed to be loaded
        ADC_Trim_Load(VDSL_12);
        //SMS00972960  - Start
        // Read back actual ADC trim values for the mode selected
        // 27/11/2009: Kannan; Reading back of ADC Trim values from the comparators is not working
        // The values which was loaded into the comparators has been verified from the winhost.
        // It is ok. Hence reading back is disabled now in the code.
        //If required in the future,  It needs tested and enabled.
        //ADC_Trim_Read_OverWrite(VDSL_5);
        //SMS00972960  - End
        break;
    default:
        break;

#endif //for ADSL_62
    }
}


/*
** =============================================================================
**
** FUNCTION-NAME: VR9_FilterConfigRegs_Tx
**
** DESCRIPTION:   This function configures the filter related registors for the
**                Tx path
**
** PARAMETERS:     uint16 us_afeMode
**
** RETURN VALUE:   None
**
** NOTES:          Reference: (1) VR9_AFEModeSelection.doc
**                            (2) VR9_AFE_Analog_Dig_Regs_mode dependent.xls
**                            SMS00920537,SMS00974862
**                            VR9_AFE_mode_settings_v3.xls
** =============================================================================
*/
void VR9_FilterConfigRegs_Tx(uint16 us_afeMode)
{

    //0b DAC1_FILT_RST_ON Sw-reset is enabled (default)
    //0b DAC2_FILT_RST_ON Sw-reset is enabled (default)
    //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
    //0b FILT_GLP_TX1_RST_ON Sw-reset is enabled (default)
    //0b FILT_GLP_TX2_RST_ON Sw-reset is enabled (default)
    //RESET_CTL_AFE_SET(0x0010);
    VR9_AfeWrite(RESET_CTL, 0x0010, RESET_CTL_TX1_TX2_MASK);

    switch (us_afeMode)
    {
#ifdef VDSL_62    // VR9 VDSL build

    case VDSL_8:

//VR9_AFE_DIG_CH0 Registers

        //DAC1 digital core is in operating state
        //DAC1 digital core clock is enabled
        //DAC1 clock buffer is powerup
        //DAC1 digital data interface clock is enabled
        //DAC1 digital data interface clock inversion is disabled
        DAC1_CTL_AFE_SET(0x0043);
        //DAC2 digital core is in reset state
        //DAC2 digital core clock is disabled
        //DAC2 clock buffer is powerdown
        //DAC2 digital data interface clock is disabled
        //DAC2 digital data interface clock inversion is disabled
        DAC2_CTL_AFE_SET(0x0004);

//VR9_AFE_DIG_FILT_CH0 Registers

        //Tx1 bits(5,1:0)
        //01b Sampling FREQ1 216  MHz for DAC1 (default)
        //Transmit Path Trigger initialization disabled
        //Tx2 bits(6,3:2)
        //01b Sampling FREQ1 216  MHz for DAC2 (default)
        //Echo Path Trigger initialization enabled
        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default) |
        //Receive Path Trigger initialization disabled |moved to Rx side.
        //FGLB_CTRL1_AFE_SET(0x0045);
        VR9_AfeWrite(FGLB_CTRL1, 0x0045, FGLB_CTRL1_TX1_TX2_MASK);
        //Transmit Path Enable
        //Echo Path disable
        //Receive Path Enable => moved to RxConfiguration
        //FGLB_CTRL2_AFE_SET(0x0005);
        VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_TX1_TX2_MASK);
        // Tx 3GLP Error correction Filter
        //TX Error Correction Enabled
        //Initialization of TX Error Correction disabled
        //TX 3GLP Error Correction Bypass
        TX1ERRC_CTRL_AFE_SET(0x0011);
        // Tx 3GLP parity error detections
        TX1ERRC_ERRD_CTRL_AFE_SET(0x0001);
        // Tx path 1 BRWDF1 filter
        //Enabled TX BRWDF1 Filter
        //Initialization of TX BRWDF1 Filter disabled
        //Resets the filter upon internal detection of an overflow of the adaptors => enabled
        //Interpolation Factor 1.5
        TX1BRWDF1_CTRL_AFE_SET(0x0101);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX1BRWDF1_COEFF_G01_AFE_SET(0x0020);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX1BRWDF1_COEFF_G02_AFE_SET(0x017C);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX1BRWDF1_COEFF_G11_AFE_SET(0x005C);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX1BRWDF1_COEFF_G21_AFE_SET(0x00F0);
        // Tx Path 1 Noise shaper registers
        // Control register
        //TX Noise Shaper enabled
        //TX Noise Shaper Output Bitwidth 13 bits
        TX1NSH_CTRL_AFE_SET(0x0001);
        //EC Error Correction disabled
        //initialization of EC Error Correction enabled
        //EC 3GLP Error Correction Bypass disabled
        TX2ERRXC_CTRL_AFE_SET(0x0002);
        // EC 3GLP parity error detection control
        TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);
        // Echo/Tx path 2 BRWDF1 regs
        //EC BRWDF1 Filter Disabled
        //Initialization of EC BRWDF1 Filter disabled
        //Resets the filter upon internal detection of an overflow of the adaptors enabled
        TX2BRWDF1_CTRL_AFE_SET(0x0102);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX2BRWDF1_COEFF_G01_AFE_SET(0x0020);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX2BRWDF1_COEFF_G02_AFE_SET(0x017C);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX2BRWDF1_COEFF_G11_AFE_SET(0x005C);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX2BRWDF1_COEFF_G21_AFE_SET(0x00F0);
        // Echo/Tx path 2 noise shaper regs.
        //EC Noise Shaper disabled
        //Initialization of EC Noise Shaper enabled
        TX2NSH_CTRL_AFE_SET(0x0002);
        // AEC Programmable gain register
        //Gain Factor for AEC 00000b MIN
        //AEC Programmable Bypass 1b EN enabled
        TX2NSH_AEC_AFE_SET(0x0010);

//VR9_AFE_DIG_GLOBAL registers
        //0b EN_PIN_CLK_OUT Pin CLK_OUT is enabled (default)
        //0b EN_PIN_PLL_TEST_D Pin PLL_TEST_D is enabled (default)
        //1b SCDO_PP SCDO is push-pull
        PAD_CTL_AFE_SET(0x0010);
        //PLL_ADC_CLK_ON ADC clock is enabled => Moved to RxConfig
        //PLL_DAC1_CLK_ON DAC1 clock is enabled
        //PLL_DAC2_CLK_OFF DAC2 clock is disabled
        //PLL_CTL3_AFE_SET(0x0004);
        VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);

        //ADC/DAC1 FILT_CLK_ON
        //DAC2_FILT_CLK_ON Clock is disabled
        //bit4: 1b :FCSI_CLK_ON (default)
        //FILT_GLP_TX1_CLK_ON
        //FILT_GLP_TX2_CLK_OFF,FILT_GLP_RX_CLK_ON
        //011b DAC2_CLK_DEL3 startup delay
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_TX1_TX2_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled => Move to RxConfig
        //DAC1_FILT_RST_OFF
        //DAC2_FILT_RST_ON
        //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
        //FILT_GLP_TX1_RST_OFF
        //FILT_GLP_TX2_RST_ON,
        //FILT_GLP_RX_RST_OFF => Move to RxConfig
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_TX1_TX2_MASK);

        break;

    case VDSL_12:

//VR9_AFE_DIG_CH0 Registers

        //DAC1 digital core is in operating state
        //DAC1 digital core clock is enabled
        //DAC1 clock buffer is powerup
        //DAC1 digital data interface clock is enabled
        //DAC1 digital data interface clock inversion is disabled
        DAC1_CTL_AFE_SET(0x0043);
        if(gft_AEC_On)
        {
            //DAC2 digital core is in operating state
            //DAC2 digital core clock is enabled
            //DAC2 clock buffer is powerup
            //DAC2 digital data interface clock is enabled
            //DAC2 digital data interface clock inversion is disabled
            DAC2_CTL_AFE_SET(0x0043);
        }
        else
        {
            //DAC2 digital core is in reset state
            //DAC2 digital core clock is disabled
            //DAC2 clock buffer is powerdown
            //DAC2 digital data interface clock is disabled
            //DAC2 digital data interface clock inversion is disabled
            DAC2_CTL_AFE_SET(0x0004);
        }
//VR9_AFE_DIG_FILT_CH0 Registers

        if(gft_AEC_On)
        {
            //Tx1 bits(5,1:0)
            //01b Sampling FREQ1 216  MHz for DAC1 (default)
            //Transmit Path Trigger initialization disabled
            //Tx2 bits(6,3:2)
            //01b Sampling FREQ1 216  MHz for DAC2 (default)
            //Echo Path Trigger initialization disabled
            //Rx bits(7,4)
            //0b Sampling  FREQ1 144 MHz for ADC (default)
            //Receive Path Trigger initialization disabled
            //FGLB_CTRL1_AFE_SET(0x0005);
            VR9_AfeWrite(FGLB_CTRL1, 0x0005, FGLB_CTRL1_TX1_TX2_MASK);

            //Transmit Path Enable
            //Echo Path Enable
            //Receive Path Enable
            //FGLB_CTRL2_AFE_SET(0x0007);
            VR9_AfeWrite(FGLB_CTRL2, 0x0007, FGLB_CTRL2_TX1_TX2_MASK);
        }
        else
        {
            //Tx1 bits(5,1:0)
            //01b Sampling FREQ1 216  MHz for DAC1 (default)
            //Transmit Path Trigger initialization disabled
            //Tx2 bits(6,3:2)
            //01b Sampling FREQ1 216  MHz for DAC2 (default)
            //Echo Path Trigger initialization disabled
            //Rx bits(7,4)
            //0b Sampling  FREQ1 144 MHz for ADC (default)
            //Receive Path Trigger initialization disabled
            //FGLB_CTRL1_AFE_SET(0x0045);
            VR9_AfeWrite(FGLB_CTRL1, 0x0045, FGLB_CTRL1_TX1_TX2_MASK);
            //Transmit Path Enable
            //Echo Path disable
            //Receive Path Enable
            //FGLB_CTRL2_AFE_SET(0x0005);
            VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_TX1_TX2_MASK);
        }

        // Tx 3GLP Error correction Filter
        //TX Error Correction Enabled
        //Initialization of TX Error Correction disabled
        //TX 3GLP Error Correction Bypass
        TX1ERRC_CTRL_AFE_SET(0x0011);
        // Tx 3GLP parity error detections
        TX1ERRC_ERRD_CTRL_AFE_SET(0x0001);
        // Tx path 1 BRWDF1 filter
        //Enabled TX BRWDF1 Filter
        //Initialization of TX BRWDF1 Filter disabled
        //Resets the filter upon internal detection of an overflow of the adaptors => enabled
        //Interpolation Factor 1.5
        TX1BRWDF1_CTRL_AFE_SET(0x0101);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX1BRWDF1_COEFF_G01_AFE_SET(0x0020);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX1BRWDF1_COEFF_G02_AFE_SET(0x017C);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX1BRWDF1_COEFF_G11_AFE_SET(0x005C);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX1BRWDF1_COEFF_G21_AFE_SET(0x00F0);
        // Tx Path 1 Noise shaper registers
        // Control register
        //TX Noise Shaper enabled
        //TX Noise Shaper Output Bitwidth 13 bits
        TX1NSH_CTRL_AFE_SET(0x0001);
        if (gft_AEC_On)
        {
            //EC Error Correction enabled
            //EC 3GLP Error Correction Bypass enabled
            TX2ERRXC_CTRL_AFE_SET(0x0011);
            // EC 3GLP parity error detection control
            TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);
            // Echo/Tx path 2 BRWDF1 regs
            //EC BRWDF1 Filter enabled
            //Initialization of EC BRWDF1 Filter disabled
            //Resets the filter upon internal detection of an overflow of the adaptors enabled
            // Interpolation Factor = 1.5
            TX2BRWDF1_CTRL_AFE_SET(0x0101);
            // Tx WDF1 programmable coeff 1 in polyphase 0
            TX2BRWDF1_COEFF_G01_AFE_SET(0x0020);
            // Tx WDF1 programmable coeff 2 in polyphase 0
            TX2BRWDF1_COEFF_G02_AFE_SET(0x017C);
            // Tx WDF1 programmable coeff 1 in polyphase 1
            TX2BRWDF1_COEFF_G11_AFE_SET(0x005C);
            // Tx WDF1 programmable coeff 1 in polyphase 2
            TX2BRWDF1_COEFF_G21_AFE_SET(0x00F0);
            // Echo/Tx path 2 noise shaper regs.
            //EC Noise Shaper enabled
            //Initialization of EC Noise Shaper disabled
            TX2NSH_CTRL_AFE_SET(0x0001);
            // AEC Programmable gain register
            //Gain Factor for AEC 11111b MAX
            //AEC Programmable Bypass 1b EN enabled
            TX2NSH_AEC_AFE_SET(0x1F10);
        }
        else
        {
            //EC Error Correction disabled
            //initialization of EC Error Correction enabled
            //EC 3GLP Error Correction Bypass disabled
            TX2ERRXC_CTRL_AFE_SET(0x0002);
            // EC 3GLP parity error detection control
            TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);

            // Echo/Tx path 2 BRWDF1 regs
            //EC BRWDF1 Filter Disabled
            //Initialization of EC BRWDF1 Filter disabled
            //Resets the filter upon internal detection of an overflow of the adaptors enabled
            TX2BRWDF1_CTRL_AFE_SET(0x0102);
            // Tx WDF1 programmable coeff 1 in polyphase 0
            TX2BRWDF1_COEFF_G01_AFE_SET(0x0000);
            // Tx WDF1 programmable coeff 2 in polyphase 0
            TX2BRWDF1_COEFF_G02_AFE_SET(0x0000);
            // Tx WDF1 programmable coeff 1 in polyphase 1
            TX2BRWDF1_COEFF_G11_AFE_SET(0x0000);
            // Tx WDF1 programmable coeff 1 in polyphase 2
            TX2BRWDF1_COEFF_G21_AFE_SET(0x0000);
            // Echo/Tx path 2 noise shaper regs.
            //EC Noise Shaper disabled
            //Initialization of EC Noise Shaper enabled
            TX2NSH_CTRL_AFE_SET(0x0002);
            // AEC Programmable gain register
            //Gain Factor for AEC 00000b MIN
            //AEC Programmable Bypass 1b EN enabled
            TX2NSH_AEC_AFE_SET(0x0010);
        }

//VR9_AFE_DIG_GLOBAL registers
        //0b EN_PIN_CLK_OUT Pin CLK_OUT is enabled (default)
        //0b EN_PIN_PLL_TEST_D Pin PLL_TEST_D is enabled (default)
        //1b SCDO_PP SCDO is push-pull
        PAD_CTL_AFE_SET(0x0010);

        if(gft_AEC_On)
        {
            //PLL_ADC_CLK_ON ADC clock is enabled
            //PLL_DAC1_CLK_ON DAC1 clock is enabled
            //PLL_DAC2_CLK_ON DAC2 clock is enabled
            //PLL_CTL3_AFE_SET(0x0000);
            VR9_AfeWrite(PLL_CTL3, 0x0000, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
            //ADC/DAC1 FILT_CLK_ON
            //DAC2_FILT_CLK_ON Clock is enabled
            //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
            //FILT_GLP_TX2_CLK_ON,FILT_GLP_RX_CLK_ON
            //011b DAC2_CLK_DEL3 startup delay
            //CLOCKING_CTL_AFE_SET(0x30F7);
            VR9_AfeWrite(CLOCKING_CTL, 0x30F7, CLOCKING_CTL_TX1_TX2_MASK);
            //ADC_FILT_RST_OFF Sw-reset is disabled
            //DAC1_FILT_RST_OFF
            //DAC2_FILT_RST_OFF
            //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
            //FILT_GLP_TX2_RST_OFF,FILT_GLP_RX_RST_OFF
            //RESET_CTL_AFE_SET(0x00F7);
            VR9_AfeWrite(RESET_CTL, 0x00F7, RESET_CTL_TX1_TX2_MASK);
        }
        else
        {
            //PLL_ADC_CLK_ON ADC clock is enabled
            //PLL_DAC1_CLK_ON DAC1 clock is enabled
            //PLL_DAC2_CLK_OFF DAC2 clock is disabled
            //PLL_CTL3_AFE_SET(0x0004);
            VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
            //ADC/DAC1 FILT_CLK_ON
            //DAC2_FILT_CLK_ON Clock is disabled
            //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
            //FILT_GLP_TX2_CLK_OFF,FILT_GLP_RX_CLK_ON
            //011b DAC2_CLK_DEL3 startup delay
            //CLOCKING_CTL_AFE_SET(0x30B3);
            VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_TX1_TX2_MASK);
            //ADC_FILT_RST_OFF Sw-reset is disabled
            //DAC1_FILT_RST_OFF
            //DAC2_FILT_RST_ON
            //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
            //FILT_GLP_TX2_RST_ON,FILT_GLP_RX_RST_OFF
            //RESET_CTL_AFE_SET(0x00B3);
            VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_TX1_TX2_MASK);
        }

        break;

    case VDSL_17:


//VR9_AFE_DIG_CH0 Registers

        //DAC1 digital core is in operating state
        //DAC1 digital core clock is enabled
        //DAC1 clock buffer is powerup
        //DAC1 digital data interface clock is enabled
        //DAC1 digital data interface clock inversion is disabled
        DAC1_CTL_AFE_SET(0x0043);
        if(gft_AEC_On)
        {
            //DAC2 digital core is in operating state
            //DAC2 digital core clock is enabled
            //DAC2 clock buffer is powerup
            //DAC2 digital data interface clock is enabled
            //DAC2 digital data interface clock inversion is disabled
            DAC2_CTL_AFE_SET(0x0043);
        }
        else
        {
            //DAC2 digital core is in reset state
            //DAC2 digital core clock is disabled
            //DAC2 clock buffer is powerdown
            //DAC2 digital data interface clock is disabled
            //DAC2 digital data interface clock inversion is disabled
            DAC2_CTL_AFE_SET(0x0004);
        }

//VR9_AFE_DIG_FILT_CH0 Registers

        if(gft_AEC_On)
        {
            //Tx1 bits(5,1:0)
            //01b Sampling FREQ1 216  MHz for DAC1 (default)
            //Transmit Path Trigger initialization disabled
            //Tx2 bits(6,3:2)
            //01b Sampling FREQ1 216  MHz for DAC2 (default)
            //Echo Path Trigger initialization disabled
            //Rx bits(7,4)
            //0b Sampling  FREQ1 144 MHz for ADC (default)
            //Receive Path Trigger initialization disabled
            //FGLB_CTRL1_AFE_SET(0x0005);
            VR9_AfeWrite(FGLB_CTRL1, 0x0005, FGLB_CTRL1_TX1_TX2_MASK);
            //Transmit Path Enable
            //Echo Path Enable
            //Receive Path Enable
            //FGLB_CTRL2_AFE_SET(0x0007);
            VR9_AfeWrite(FGLB_CTRL2, 0x0007, FGLB_CTRL2_TX1_TX2_MASK);
        }
        else
        {
            //Tx1 bits(5,1:0)
            //01b Sampling FREQ1 216  MHz for DAC1 (default)
            //Transmit Path Trigger initialization disabled
            //Tx2 bits(6,3:2)
            //01b Sampling FREQ1 216  MHz for DAC2 (default)
            //Echo Path Trigger initialization disabled
            //Rx bits(7,4)
            //0b Sampling  FREQ1 144 MHz for ADC (default)
            //Receive Path Trigger initialization disabled
            //FGLB_CTRL1_AFE_SET(0x0045);
            VR9_AfeWrite(FGLB_CTRL1, 0x0045, FGLB_CTRL1_TX1_TX2_MASK);
            //Transmit Path Enable
            //Echo Path disable
            //Receive Path Enable
            //FGLB_CTRL2_AFE_SET(0x0005);
            VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_TX1_TX2_MASK);
        }
        // Tx 3GLP Error correction Filter
        //TX Error Correction Enabled
        //Initialization of TX Error Correction disabled
        //TX 3GLP Error Correction Bypass
        TX1ERRC_CTRL_AFE_SET(0x0011);
        // Tx 3GLP parity error detections
        TX1ERRC_ERRD_CTRL_AFE_SET(0x0001);
        // Tx path 1 BRWDF1 filter
        //Enabled TX BRWDF1 Filter
        //Initialization of TX BRWDF1 Filter disabled
        //Resets the filter upon internal detection of an overflow of the adaptors => enabled
        //Interpolation Factor 1.5
        TX1BRWDF1_CTRL_AFE_SET(0x0101);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX1BRWDF1_COEFF_G01_AFE_SET(0x0020);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX1BRWDF1_COEFF_G02_AFE_SET(0x017C);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX1BRWDF1_COEFF_G11_AFE_SET(0x005C);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX1BRWDF1_COEFF_G21_AFE_SET(0x00F0);
        // Tx Path 1 Noise shaper registers
        // Control register
        //TX Noise Shaper enabled
        //TX Noise Shaper Output Bitwidth 13 bits
        TX1NSH_CTRL_AFE_SET(0x0001);
        if (gft_AEC_On)
        {
            //EC Error Correction enabled
            //EC 3GLP Error Correction Bypass enabled
            TX2ERRXC_CTRL_AFE_SET(0x0011);
            // EC 3GLP parity error detection control
            TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);
            // Echo/Tx path 2 BRWDF1 regs
            //EC BRWDF1 Filter enabled
            //Initialization of EC BRWDF1 Filter disabled
            //Resets the filter upon internal detection of an overflow of the adaptors enabled
            // Interpolation Factor = 1.5
            TX2BRWDF1_CTRL_AFE_SET(0x0101);
            // Tx WDF1 programmable coeff 1 in polyphase 0
            TX2BRWDF1_COEFF_G01_AFE_SET(0x0020);
            // Tx WDF1 programmable coeff 2 in polyphase 0
            TX2BRWDF1_COEFF_G02_AFE_SET(0x017C);
            // Tx WDF1 programmable coeff 1 in polyphase 1
            TX2BRWDF1_COEFF_G11_AFE_SET(0x005C);
            // Tx WDF1 programmable coeff 1 in polyphase 2
            TX2BRWDF1_COEFF_G21_AFE_SET(0x00F0);
            // Echo/Tx path 2 noise shaper regs.
            //EC Noise Shaper enabled
            //Initialization of EC Noise Shaper disabled
            TX2NSH_CTRL_AFE_SET(0x0001);
            // AEC Programmable gain register
            //Gain Factor for AEC 11111b MAX
            //AEC Programmable Bypass 1b EN enabled
            TX2NSH_AEC_AFE_SET(0x1F10);
        }
        else
        {
            //EC Error Correction disabled
            //initialization of EC Error Correction enabled
            //EC 3GLP Error Correction Bypass disabled
            TX2ERRXC_CTRL_AFE_SET(0x0002);
            // EC 3GLP parity error detection control
            TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);

            // Echo/Tx path 2 BRWDF1 regs
            //EC BRWDF1 Filter Disabled
            //Initialization of EC BRWDF1 Filter disabled
            //Resets the filter upon internal detection of an overflow of the adaptors enabled
            TX2BRWDF1_CTRL_AFE_SET(0x0102);
            // Tx WDF1 programmable coeff 1 in polyphase 0
            TX2BRWDF1_COEFF_G01_AFE_SET(0x0020);
            // Tx WDF1 programmable coeff 2 in polyphase 0
            TX2BRWDF1_COEFF_G02_AFE_SET(0x017C);
            // Tx WDF1 programmable coeff 1 in polyphase 1
            TX2BRWDF1_COEFF_G11_AFE_SET(0x005C);
            // Tx WDF1 programmable coeff 1 in polyphase 2
            TX2BRWDF1_COEFF_G21_AFE_SET(0x00F0);
            // Echo/Tx path 2 noise shaper regs.
            //EC Noise Shaper disabled
            //Initialization of EC Noise Shaper enabled
            TX2NSH_CTRL_AFE_SET(0x0002);
            // AEC Programmable gain register
            //Gain Factor for AEC 00000b MIN
            //AEC Programmable Bypass 1b EN enabled
            TX2NSH_AEC_AFE_SET(0x0010);
        }
//VR9_AFE_DIG_GLOBAL registers
        //0b EN_PIN_CLK_OUT Pin CLK_OUT is enabled (default)
        //0b EN_PIN_PLL_TEST_D Pin PLL_TEST_D is enabled (default)
        //1b SCDO_PP SCDO is push-pull
        PAD_CTL_AFE_SET(0x0010);

        if(gft_AEC_On)
        {
            //PLL_ADC_CLK_ON ADC clock is enabled
            //PLL_DAC1_CLK_ON DAC1 clock is enabled
            //PLL_DAC2_CLK_ON DAC2 clock is enabled
            //PLL_CTL3_AFE_SET(0x0000);
            VR9_AfeWrite(PLL_CTL3, 0x0000, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
            //ADC/DAC1 FILT_CLK_ON
            //DAC2_FILT_CLK_ON Clock is enabled
            //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
            //FILT_GLP_TX2_CLK_ON,FILT_GLP_RX_CLK_ON
            //011b DAC2_CLK_DEL3 startup delay
            //CLOCKING_CTL_AFE_SET(0x30F7);
            VR9_AfeWrite(CLOCKING_CTL, 0x30F7, CLOCKING_CTL_TX1_TX2_MASK);
            //ADC_FILT_RST_OFF Sw-reset is disabled
            //DAC1_FILT_RST_OFF
            //DAC2_FILT_RST_OFF
            //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
            //FILT_GLP_TX2_RST_OFF,FILT_GLP_RX_RST_OFF
            //RESET_CTL_AFE_SET(0x00F7);
            VR9_AfeWrite(RESET_CTL, 0x00F7, RESET_CTL_TX1_TX2_MASK);
        }
        else
        {
            //PLL_ADC_CLK_ON ADC clock is enabled
            //PLL_DAC1_CLK_ON DAC1 clock is enabled
            //PLL_DAC2_CLK_OFF DAC2 clock is disabled
            //PLL_CTL3_AFE_SET(0x0004);
            VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
            //ADC/DAC1 FILT_CLK_ON
            //DAC2_FILT_CLK_ON Clock is disabled
            //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
            //FILT_GLP_TX2_CLK_OFF,FILT_GLP_RX_CLK_ON
            //011b DAC2_CLK_DEL3 startup delay
            //CLOCKING_CTL_AFE_SET(0x30B3);
            VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_TX1_TX2_MASK);
            //ADC_FILT_RST_OFF Sw-reset is disabled
            //DAC1_FILT_RST_OFF
            //DAC2_FILT_RST_ON
            //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
            //FILT_GLP_TX2_RST_ON,FILT_GLP_RX_RST_OFF
            //RESET_CTL_AFE_SET(0x00B3);
            VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_TX1_TX2_MASK);
        }

        break;

    case VDSL_30:


//VR9_AFE_DIG_CH0 Registers

        //DAC1 digital core is in operating state
        //DAC1 digital core clock is enabled
        //DAC1 clock buffer is powerup
        //DAC1 digital data interface clock is enabled
        //DAC1 digital data interface clock inversion is disabled
        DAC1_CTL_AFE_SET(0x0043);
        if(gft_AEC_On)
        {
            //DAC2 digital core is in operating state
            //DAC2 digital core clock is enabled
            //DAC2 clock buffer is powerup
            //DAC2 digital data interface clock is enabled
            //DAC2 digital data interface clock inversion is disabled
            DAC2_CTL_AFE_SET(0x0043);
        }
        else
        {
            //DAC2 digital core is in reset state
            //DAC2 digital core clock is disabled
            //DAC2 clock buffer is powerdown
            //DAC2 digital data interface clock is disabled
            //DAC2 digital data interface clock inversion is disabled
            DAC2_CTL_AFE_SET(0x0004);
        }

//VR9_AFE_DIG_FILT_CH0 Registers

        if (gft_AEC_On)
        {
            //Tx1 bits(5,1:0)
            //01b Sampling FREQ1 216  MHz for DAC1 (default)
            //Transmit Path Trigger initialization disabled
            //Tx2 bits(6,3:2)
            //01b Sampling FREQ1 216  MHz for DAC2 (default)
            //Echo Path Trigger initialization disabled
            //Rx bits(7,4)
            //1b Sampling  FREQ1 288 MHz for ADC (default)
            //Receive Path Trigger initialization disabled
            //FGLB_CTRL1_AFE_SET(0x0015);
            VR9_AfeWrite(FGLB_CTRL1, 0x0015, FGLB_CTRL1_TX1_TX2_MASK);
            //Transmit Path Enable
            //Echo Path Enable
            //Receive Path Enable
            //FGLB_CTRL2_AFE_SET(0x0007);
            VR9_AfeWrite(FGLB_CTRL2, 0x0007, FGLB_CTRL2_TX1_TX2_MASK);
        }
        else
        {
            //Tx1 bits(5,1:0)
            //01b Sampling FREQ1 216  MHz for DAC1 (default)
            //Transmit Path Trigger initialization disabled
            //Tx2 bits(6,3:2)
            //01b Sampling FREQ1 216  MHz for DAC2 (default)
            //Echo Path Trigger initialization enabled
            //Rx bits(7,4)
            //1b Sampling  FREQ1 288 MHz for ADC (default)
            //Receive Path Trigger initialization disabled
            //FGLB_CTRL1_AFE_SET(0x0055);
            VR9_AfeWrite(FGLB_CTRL1, 0x0055, FGLB_CTRL1_TX1_TX2_MASK);
            //Transmit Path Enable
            //Echo Path disable
            //Receive Path Enable
            //FGLB_CTRL2_AFE_SET(0x0005);
            VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_TX1_TX2_MASK);

        }
        // Tx 3GLP Error correction Filter
        //TX Error Correction Enabled
        //Initialization of TX Error Correction disabled
        //TX 3GLP Error Correction Bypass
        TX1ERRC_CTRL_AFE_SET(0x0011);
        // Tx 3GLP parity error detections
        TX1ERRC_ERRD_CTRL_AFE_SET(0x0001);
        // Tx path 1 BRWDF1 filter
        //Enabled TX BRWDF1 Filter
        //Initialization of TX BRWDF1 Filter disabled
        //Resets the filter upon internal detection of an overflow of the adaptors => enabled
        //Interpolation Factor 1.5
        TX1BRWDF1_CTRL_AFE_SET(0x0101);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX1BRWDF1_COEFF_G01_AFE_SET(0x0020);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX1BRWDF1_COEFF_G02_AFE_SET(0x017C);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX1BRWDF1_COEFF_G11_AFE_SET(0x005C);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX1BRWDF1_COEFF_G21_AFE_SET(0x00F0);
        // Tx Path 1 Noise shaper registers
        // Control register
        //TX Noise Shaper enabled
        //TX Noise Shaper Output Bitwidth 13 bits
        TX1NSH_CTRL_AFE_SET(0x0001);
        if (gft_AEC_On)
        {
            //EC Error Correction enabled
            //EC 3GLP Error Correction Bypass enabled
            TX2ERRXC_CTRL_AFE_SET(0x0011);
            // EC 3GLP parity error detection control
            TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);
            // Echo/Tx path 2 BRWDF1 regs
            //EC BRWDF1 Filter enabled
            //Initialization of EC BRWDF1 Filter disabled
            //Resets the filter upon internal detection of an overflow of the adaptors enabled
            // Interpolation Factor = 1.5
            TX2BRWDF1_CTRL_AFE_SET(0x0101);
            // Tx WDF1 programmable coeff 1 in polyphase 0
            TX2BRWDF1_COEFF_G01_AFE_SET(0x0020);
            // Tx WDF1 programmable coeff 2 in polyphase 0
            TX2BRWDF1_COEFF_G02_AFE_SET(0x017C);
            // Tx WDF1 programmable coeff 1 in polyphase 1
            TX2BRWDF1_COEFF_G11_AFE_SET(0x005C);
            // Tx WDF1 programmable coeff 1 in polyphase 2
            TX2BRWDF1_COEFF_G21_AFE_SET(0x00F0);
            // Echo/Tx path 2 noise shaper regs.
            //EC Noise Shaper enabled
            //Initialization of EC Noise Shaper disabled
            TX2NSH_CTRL_AFE_SET(0x0001);
            // AEC Programmable gain register
            //Gain Factor for AEC 11111b MAX
            //AEC Programmable Bypass 1b EN enabled
            TX2NSH_AEC_AFE_SET(0x1F10);
        }
        else
        {
            //EC Error Correction disabled
            //initialization of EC Error Correction enabled
            //EC 3GLP Error Correction Bypass disabled
            TX2ERRXC_CTRL_AFE_SET(0x0002);
            // EC 3GLP parity error detection control
            TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);

            // Echo/Tx path 2 BRWDF1 regs
            //EC BRWDF1 Filter Disabled
            //Initialization of EC BRWDF1 Filter disabled
            //Resets the filter upon internal detection of an overflow of the adaptors enabled
            TX2BRWDF1_CTRL_AFE_SET(0x0102);
            // Tx WDF1 programmable coeff 1 in polyphase 0
            TX2BRWDF1_COEFF_G01_AFE_SET(0x0000);
            // Tx WDF1 programmable coeff 2 in polyphase 0
            TX2BRWDF1_COEFF_G02_AFE_SET(0x0000);
            // Tx WDF1 programmable coeff 1 in polyphase 1
            TX2BRWDF1_COEFF_G11_AFE_SET(0x0000);
            // Tx WDF1 programmable coeff 1 in polyphase 2
            TX2BRWDF1_COEFF_G21_AFE_SET(0x0000);
            // Echo/Tx path 2 noise shaper regs.
            //EC Noise Shaper disabled
            //Initialization of EC Noise Shaper enabled
            TX2NSH_CTRL_AFE_SET(0x0002);
            // AEC Programmable gain register
            //Gain Factor for AEC 00000b MIN
            //AEC Programmable Bypass 1b EN enabled
            TX2NSH_AEC_AFE_SET(0x0010);
        }
//VR9_AFE_DIG_GLOBAL registers
        //0b EN_PIN_CLK_OUT Pin CLK_OUT is enabled (default)
        //0b EN_PIN_PLL_TEST_D Pin PLL_TEST_D is enabled (default)
        //1b SCDO_PP SCDO is push-pull
        PAD_CTL_AFE_SET(0x0010);

        if(gft_AEC_On)
        {
            //PLL_ADC_CLK_ON ADC clock is enabled
            //PLL_DAC1_CLK_ON DAC1 clock is enabled
            //PLL_DAC2_CLK_ON DAC2 clock is enabled
            //PLL_CTL3_AFE_SET(0x0000);
            VR9_AfeWrite(PLL_CTL3, 0x0000, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
            //ADC/DAC1 FILT_CLK_ON
            //DAC2_FILT_CLK_ON Clock is enabled
            //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
            //FILT_GLP_TX2_CLK_ON,FILT_GLP_RX_CLK_ON
            //011b DAC2_CLK_DEL3 startup delay
            //CLOCKING_CTL_AFE_SET(0x30F7);
            VR9_AfeWrite(CLOCKING_CTL, 0x30F7, CLOCKING_CTL_TX1_TX2_MASK);
            //ADC_FILT_RST_OFF Sw-reset is disabled
            //DAC1_FILT_RST_OFF
            //DAC2_FILT_RST_OFF
            //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
            //FILT_GLP_TX2_RST_OFF,FILT_GLP_RX_RST_OFF
            //RESET_CTL_AFE_SET(0x00F7);
            VR9_AfeWrite(RESET_CTL, 0x00F7, RESET_CTL_TX1_TX2_MASK);
        }
        else
        {
            //PLL_ADC_CLK_ON ADC clock is enabled
            //PLL_DAC1_CLK_ON DAC1 clock is enabled
            //PLL_DAC2_CLK_OFF DAC2 clock is disabled
            //PLL_CTL3_AFE_SET(0x0004);
            VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
            //ADC/DAC1 FILT_CLK_ON
            //DAC2_FILT_CLK_ON Clock is disabled
            //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
            //FILT_GLP_TX2_CLK_OFF,FILT_GLP_RX_CLK_ON
            //011b DAC2_CLK_DEL3 startup delay
            //CLOCKING_CTL_AFE_SET(0x30B3);
            VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_TX1_TX2_MASK);
            //ADC_FILT_RST_OFF Sw-reset is disabled
            //DAC1_FILT_RST_OFF
            //DAC2_FILT_RST_ON
            //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
            //FILT_GLP_TX2_RST_ON,FILT_GLP_RX_RST_OFF
            //RESET_CTL_AFE_SET(0x00B3);
            VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_TX1_TX2_MASK);
        }

        break;
#endif   // ifdef VDSL_62

#ifdef ADSL_62    // VR9 ADSL build
    case ADSL_A:


//VR9_AFE_DIG_CH0 Registers

        //DAC1 digital core is in operating state
        //DAC1 digital core clock is enabled
        //DAC1 clock buffer is powerup
        //DAC1 digital data interface clock is enabled
        //DAC1 digital data interface clock inversion is disabled
        DAC1_CTL_AFE_SET(0x0043);
        //DAC2 digital core is in reset state
        //DAC2 digital core clock is disabled
        //DAC2 clock buffer is powerdown
        //DAC2 digital data interface clock is disabled
        //DAC2 digital data interface clock inversion is disabled
        DAC2_CTL_AFE_SET(0x0004);

//VR9_AFE_DIG_FILT_CH0 Registers

        //Tx1 bits(5,1:0)
        //10b Sampling FREQ1 144  MHz for DAC1 (default)
        //Transmit Path Trigger initialization disabled
        //Tx2 bits(6,3:2)
        //10b Sampling FREQ1 144  MHz for DAC2 (default)
        //Echo Path Trigger initialization enabled
        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x004A);
        VR9_AfeWrite(FGLB_CTRL1, 0x004A, FGLB_CTRL1_TX1_TX2_MASK);
        //Transmit Path Enable
        //Echo Path disable
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0005);
        VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_TX1_TX2_MASK);
        // Tx 3GLP Error correction Filter
        //TX Error Correction Enabled
        //Initialization of TX Error Correction disabled
        //TX 3GLP Error Correction Bypass
        TX1ERRC_CTRL_AFE_SET(0x0011);
        // Tx 3GLP parity error detections
        TX1ERRC_ERRD_CTRL_AFE_SET(0x0001);
        // Tx path 1 BRWDF1 filter
        //Enabled TX BRWDF1 Filter
        //Initialization of TX BRWDF1 Filter disabled
        //Ennabled TX BRWDF1 Filter Bypass
        //Resets the filter upon internal detection of an overflow of the adaptors => enabled
        //Interpolation Factor 1.5
        TX1BRWDF1_CTRL_AFE_SET(0x0111);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX1BRWDF1_COEFF_G01_AFE_SET(0x0000);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX1BRWDF1_COEFF_G02_AFE_SET(0x0000);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX1BRWDF1_COEFF_G11_AFE_SET(0x0000);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX1BRWDF1_COEFF_G21_AFE_SET(0x0000);
        // Tx Path 1 Noise shaper registers
        // Control register
        //TX Noise Shaper enabled
        //TX Noise Shaper Output Bitwidth 8 bits
        TX1NSH_CTRL_AFE_SET(0x0201);
        //EC Error Correction disabled
        //initialization of EC Error Correction enabled
        //EC 3GLP Error Correction Bypass disabled
        TX2ERRXC_CTRL_AFE_SET(0x0002);
        // EC 3GLP parity error detection control
        TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);
        // Echo/Tx path 2 BRWDF1 regs
        //EC BRWDF1 Filter Disabled
        //Initialization of EC BRWDF1 Filter disabled
        //Resets the filter upon internal detection of an overflow of the adaptors enabled
        TX2BRWDF1_CTRL_AFE_SET(0x0102);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX2BRWDF1_COEFF_G01_AFE_SET(0x0020);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX2BRWDF1_COEFF_G02_AFE_SET(0x017C);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX2BRWDF1_COEFF_G11_AFE_SET(0x005C);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX2BRWDF1_COEFF_G21_AFE_SET(0x00F0);
        // Echo/Tx path 2 noise shaper regs.
        //EC Noise Shaper disabled
        //Initialization of EC Noise Shaper enabled
        TX2NSH_CTRL_AFE_SET(0x0002);
        // AEC Programmable gain register
        //Gain Factor for AEC 00000b MIN
        //AEC Programmable Bypass 1b EN enabled
        TX2NSH_AEC_AFE_SET(0x0010);
#if 0
        //As Per AFE teams Input PAD_CTL init must be done at the beginning of AFE initialization
        //Hence it is moved.
        //PAD_CTL has to be set to 0x0010 if only 1 AFE is mounted, 0x0000 otherwise.
//VR9_AFE_DIG_GLOBAL registers
        //0b EN_PIN_CLK_OUT Pin CLK_OUT is enabled (default)
        //0b EN_PIN_PLL_TEST_D Pin PLL_TEST_D is enabled (default)
        //1b SCDO_PP SCDO is push-pull
        PAD_CTL_AFE_SET(0x0010);
#endif
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_DAC1_CLK_ON DAC1 clock is enabled
        //PLL_DAC2_CLK_OFF DAC2 clock is disabled
        //PLL_CTL3_AFE_SET(0x0004);
        VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
        //ADC/DAC1 FILT_CLK_ON
        //DAC2_FILT_CLK_ON Clock is disabled
        //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
        //FILT_GLP_TX2_CLK_OFF,FILT_GLP_RX_CLK_ON
        //011b DAC2_CLK_DEL3 startup delay
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_TX1_TX2_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //DAC1_FILT_RST_OFF
        //DAC2_FILT_RST_ON
        //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
        //FILT_GLP_TX2_RST_ON,FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_TX1_TX2_MASK);

        break;

    case ADSL_B:

//VR9_AFE_DIG_CH0 Registers

        //DAC1 digital core is in operating state
        //DAC1 digital core clock is enabled
        //DAC1 clock buffer is powerup
        //DAC1 digital data interface clock is enabled
        //DAC1 digital data interface clock inversion is disabled
        DAC1_CTL_AFE_SET(0x0043);
        //DAC2 digital core is in reset state
        //DAC2 digital core clock is disabled
        //DAC2 clock buffer is powerdown
        //DAC2 digital data interface clock is disabled
        //DAC2 digital data interface clock inversion is disabled
        DAC2_CTL_AFE_SET(0x0004);

//VR9_AFE_DIG_FILT_CH0 Registers

        //Tx1 bits(5,1:0)
        //10b Sampling FREQ1 144  MHz for DAC1 (default)
        //Transmit Path Trigger initialization disabled
        //Tx2 bits(6,3:2)
        //10b Sampling FREQ1 144  MHz for DAC2 (default)
        //Echo Path Trigger initialization enabled
        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x004A);
        VR9_AfeWrite(FGLB_CTRL1, 0x004A, FGLB_CTRL1_TX1_TX2_MASK);
        //Transmit Path Enable
        //Echo Path disable
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0005);
        VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_TX1_TX2_MASK);
        // Tx 3GLP Error correction Filter
        //TX Error Correction Enabled
        //Initialization of TX Error Correction disabled
        //TX 3GLP Error Correction Bypass
        TX1ERRC_CTRL_AFE_SET(0x0011);
        // Tx 3GLP parity error detections
        TX1ERRC_ERRD_CTRL_AFE_SET(0x0001);
        // Tx path 1 BRWDF1 filter
        //Enabled TX BRWDF1 Filter
        //Initialization of TX BRWDF1 Filter disabled
        //Ennabled TX BRWDF1 Filter Bypass
        //Resets the filter upon internal detection of an overflow of the adaptors => enabled
        //Interpolation Factor 1.5
        TX1BRWDF1_CTRL_AFE_SET(0x0111);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX1BRWDF1_COEFF_G01_AFE_SET(0x0000);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX1BRWDF1_COEFF_G02_AFE_SET(0x0000);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX1BRWDF1_COEFF_G11_AFE_SET(0x0000);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX1BRWDF1_COEFF_G21_AFE_SET(0x0000);
        // Tx Path 1 Noise shaper registers
        // Control register
        //TX Noise Shaper enabled
        //TX Noise Shaper Output Bitwidth 8 bits
        TX1NSH_CTRL_AFE_SET(0x0201);
        //EC Error Correction disabled
        //initialization of EC Error Correction enabled
        //EC 3GLP Error Correction Bypass disabled
        TX2ERRXC_CTRL_AFE_SET(0x0002);
        // EC 3GLP parity error detection control
        TX2ERRXC_ERRD_CTRL_AFE_SET(0x0001);
        // Echo/Tx path 2 BRWDF1 regs
        //EC BRWDF1 Filter Disabled
        //Initialization of EC BRWDF1 Filter disabled
        //Resets the filter upon internal detection of an overflow of the adaptors enabled
        TX2BRWDF1_CTRL_AFE_SET(0x0102);
        // Tx WDF1 programmable coeff 1 in polyphase 0
        TX2BRWDF1_COEFF_G01_AFE_SET(0x0020);
        // Tx WDF1 programmable coeff 2 in polyphase 0
        TX2BRWDF1_COEFF_G02_AFE_SET(0x017C);
        // Tx WDF1 programmable coeff 1 in polyphase 1
        TX2BRWDF1_COEFF_G11_AFE_SET(0x005C);
        // Tx WDF1 programmable coeff 1 in polyphase 2
        TX2BRWDF1_COEFF_G21_AFE_SET(0x00F0);
        // Echo/Tx path 2 noise shaper regs.
        //EC Noise Shaper disabled
        //Initialization of EC Noise Shaper enabled
        TX2NSH_CTRL_AFE_SET(0x0002);
        // AEC Programmable gain register
        //Gain Factor for AEC 00000b MIN
        //AEC Programmable Bypass 1b EN enabled
        TX2NSH_AEC_AFE_SET(0x0010);
#if 0
        //As Per AFE teams Input PAD_CTL init must be done at the beginning of AFE initialization
        //Hence it is moved.
        //PAD_CTL has to be set to 0x0010 if only 1 AFE is mounted, 0x0000 otherwise.
//VR9_AFE_DIG_GLOBAL registers
        //0b EN_PIN_CLK_OUT Pin CLK_OUT is enabled (default)
        //0b EN_PIN_PLL_TEST_D Pin PLL_TEST_D is enabled (default)
        //1b SCDO_PP SCDO is push-pull
        PAD_CTL_AFE_SET(0x0010);
#endif
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_DAC1_CLK_ON DAC1 clock is enabled
        //PLL_DAC2_CLK_OFF DAC2 clock is disabled
        //PLL_CTL3_AFE_SET(0x0004);
        VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_TX1_TX2_MASK);
        //ADC/DAC1 FILT_CLK_ON
        //DAC2_FILT_CLK_ON Clock is disabled
        //FCSI_CLK_ON,FILT_GLP_TX1_CLK_ON
        //FILT_GLP_TX2_CLK_OFF,FILT_GLP_RX_CLK_ON
        //011b DAC2_CLK_DEL3 startup delay
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_TX1_TX2_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //DAC1_FILT_RST_OFF
        //DAC2_FILT_RST_ON
        //FCSI_RST_OFF,FILT_GLP_TX1_RST_OFF
        //FILT_GLP_TX2_RST_ON,FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_TX1_TX2_MASK);

        break;
#endif   // ifdef ADSL_62
    default:
        break;
    }
    return;
}

/*
** =============================================================================
**
** FUNCTION-NAME: VR9_FilterConfigRegs_Rx
**
** DESCRIPTION:   This function configures the filter related registors for the
**                Rx path
**
** PARAMETERS:     uint16 us_afeMode
**
** RETURN VALUE:   None
**
** NOTES:          Reference: (1) VR9_AFEModeSelection.doc
**                            (2) VR9_AFE_Analog_Dig_Regs_mode dependent.xls
**                            SMS00920537,SMS00974862
**                            VR9_AFE_mode_settings_v3.xls
** =============================================================================
*/
void VR9_FilterConfigRegs_Rx(uint16 us_afeMode)
{

    //0b ADC_FILT_RST_ON Sw-reset is enabled (default)
    //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
    //0b FILT_GLP_RX_RST_ON Sw-reset is enabled (default)
    //RESET_CTL_AFE_SET(0x0010);
    VR9_AfeWrite(RESET_CTL, 0x0010, RESET_CTL_RX_MASK);

    switch (us_afeMode)
    {
#ifdef VDSL_62    // VR9 VDSL build

    case VDSL_8:

//VR9_AFE_DIG_CH0 Registers

        //ADC digital data interface is in operation state
        //ADC digital data interface clock is enabled
        //ADC digital data interface clock inversion is enabled
        ADC_CTL_AFE_SET(0x0041);

//VR9_AFE_DIG_FILT_CH0 Registers
        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x0045);
        VR9_AfeWrite(FGLB_CTRL1, 0x0045, FGLB_CTRL1_RX_MASK);
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0004);
        VR9_AfeWrite(FGLB_CTRL2, 0x0004, FGLB_CTRL2_RX_MASK);

        // Rx Polyphase FIR: Cancel Logic + COMB1 regs.
        // Control Register
        //Enabled RXCMB1 Filter
        //Initialization of RXCMB1 Filter disabled
        //CL2 (2nd Branch) Cancellation Logic Enabled
        RXCMB1_CTRL_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_0_AFE_SET(0x03BF);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_1_AFE_SET(0x038C);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_2_AFE_SET(0x0059);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_3_AFE_SET(0x00F1);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_4_AFE_SET(0x0006);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_5_AFE_SET(0x036F);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_6_AFE_SET(0x03DC);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_7_AFE_SET(0x0010);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_8_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_9_AFE_SET(0x0000);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_10_AFE_SET(0x0000);

        // Rx BRWDF1 polyphase filter regs.
        // Control register
        //Enabled RX BRWDF1 Filter
        //Initialization of RX BRWDF1 Filter disabled
        //11b BYP decimators and filters are bypassed
        //Filter upon internal detection of an overflow => Enabled
        RXBRWDF1_CTRL_AFE_SET(0x0131);
        // Rx WDF1 programmable adaptor G1 coeffs.
        RXBRWDF1_COEFF_G1_AFE_SET(0x0000);
        // Rx WDF1 programmable adaptor G3 coeffs.
        RXBRWDF1_COEFF_G3_AFE_SET(0x0000);

//VR9_AFE_DIG_GLOBAL registers
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_CTL3_AFE_SET(0x0000);
        VR9_AfeWrite(PLL_CTL3, 0x0000, PLL_CTL3_PLL_DIS_RX_MASK);
        //ADCFILT_CLK_ON
        //bit4:1b :FCSI_CLK_ON:default
        //FILT_GLP_RX_CLK_ON
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_RX_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
        //FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_RX_MASK);

        break;

    case VDSL_12:

//VR9_AFE_DIG_CH0 Registers

        //ADC digital data interface is in operation state
        //ADC digital data interface clock is enabled
        //ADC digital data interface clock inversion is enabled
        ADC_CTL_AFE_SET(0x0041);

//VR9_AFE_DIG_FILT_CH0 Registers
        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x0005);
        VR9_AfeWrite(FGLB_CTRL1, 0x0005, FGLB_CTRL1_RX_MASK);
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0004);
        VR9_AfeWrite(FGLB_CTRL2, 0x0004, FGLB_CTRL2_RX_MASK);

        // Rx Polyphase FIR: Cancel Logic + COMB1 regs.
        // Control Register
        //Enabled RXCMB1 Filter
        //Initialization of RXCMB1 Filter disabled
        //CL2 (2nd Branch) Cancellation Logic Enabled
        RXCMB1_CTRL_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_0_AFE_SET(0x03BF);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_1_AFE_SET(0x038C);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_2_AFE_SET(0x0059);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_3_AFE_SET(0x00F1);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_4_AFE_SET(0x0006);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_5_AFE_SET(0x036F);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_6_AFE_SET(0x03DC);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_7_AFE_SET(0x0010);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_8_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_9_AFE_SET(0x0000);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_10_AFE_SET(0x0000);

        // Rx BRWDF1 polyphase filter regs.
        // Control register
        //Enabled RX BRWDF1 Filter
        //Initialization of RX BRWDF1 Filter disabled
        //11b BYP decimators and filters are bypassed
        //Filter upon internal detection of an overflow => Enabled
        RXBRWDF1_CTRL_AFE_SET(0x0131);
        // Rx WDF1 programmable adaptor G1 coeffs.
        RXBRWDF1_COEFF_G1_AFE_SET(0x0000);
        // Rx WDF1 programmable adaptor G3 coeffs.
        RXBRWDF1_COEFF_G3_AFE_SET(0x0000);
//VR9_AFE_DIG_GLOBAL registers
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_CTL3_AFE_SET(0x0000);
        VR9_AfeWrite(PLL_CTL3, 0x0000, PLL_CTL3_PLL_DIS_RX_MASK);
        //ADCFILT_CLK_ON
        //bit4:1b :FCSI_CLK_ON:default
        //FILT_GLP_RX_CLK_ON
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_RX_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
        //FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_RX_MASK);

        break;

    case VDSL_17:

//VR9_AFE_DIG_CH0 Registers

        //ADC digital data interface is in operation state
        //ADC digital data interface clock is enabled
        //ADC digital data interface clock inversion is enabled
        ADC_CTL_AFE_SET(0x0041);

//VR9_AFE_DIG_FILT_CH0 Registers
        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x0005);
        VR9_AfeWrite(FGLB_CTRL1, 0x0045, FGLB_CTRL1_RX_MASK);
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0004);
        VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_RX_MASK);

        // Rx Polyphase FIR: Cancel Logic + COMB1 regs.
        // Control Register
        //Enabled RXCMB1 Filter
        //Initialization of RXCMB1 Filter disabled
        //CL2 (2nd Branch) Cancellation Logic Enabled
        RXCMB1_CTRL_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_0_AFE_SET(0x03A8);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_1_AFE_SET(0x038E);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_2_AFE_SET(0x00A4);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_3_AFE_SET(0x00B8);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_4_AFE_SET(0x0369);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_5_AFE_SET(0x03A8);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_6_AFE_SET(0x0053);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_7_AFE_SET(0x03F3);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_8_AFE_SET(0x03D9);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_9_AFE_SET(0x0000);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_10_AFE_SET(0x0000);

        // Rx BRWDF1 polyphase filter regs.
        // Control register
        //Enabled RX BRWDF1 Filter
        //Initialization of RX BRWDF1 Filter disabled
        //11b BYP decimators and filters are bypassed
        //Filter upon internal detection of an overflow => Enabled
        RXBRWDF1_CTRL_AFE_SET(0x0131);
        // Rx WDF1 programmable adaptor G1 coeffs.
        RXBRWDF1_COEFF_G1_AFE_SET(0x0000);
        // Rx WDF1 programmable adaptor G3 coeffs.
        RXBRWDF1_COEFF_G3_AFE_SET(0x0000);
//VR9_AFE_DIG_GLOBAL registers
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_CTL3_AFE_SET(0x0000);
        VR9_AfeWrite(PLL_CTL3, 0x0000, PLL_CTL3_PLL_DIS_RX_MASK);
        //ADCFILT_CLK_ON
        //bit4:1b :FCSI_CLK_ON:default
        //FILT_GLP_RX_CLK_ON
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_RX_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
        //FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_RX_MASK);

        break;

    case VDSL_30:

//VR9_AFE_DIG_CH0 Registers

        //ADC digital data interface is in operation state
        //ADC digital data interface clock is enabled
        //ADC digital data interface clock inversion is enabled
        ADC_CTL_AFE_SET(0x0041);

//VR9_AFE_DIG_FILT_CH0 Registers
        //Rx bits(7,4)
        //1b Sampling  FREQ1 288 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x0015);
        VR9_AfeWrite(FGLB_CTRL1, 0x0015, FGLB_CTRL1_RX_MASK);
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0004);
        VR9_AfeWrite(FGLB_CTRL2, 0x0004, FGLB_CTRL2_RX_MASK);

        // Rx Polyphase FIR: Cancel Logic + COMB1 regs.
        // Control Register
        //Enabled RXCMB1 Filter
        //Initialization of RXCMB1 Filter disabled
        //CL2 (2nd Branch) Cancellation Logic Enabled
        RXCMB1_CTRL_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_0_AFE_SET(0x03CD);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_1_AFE_SET(0x0373);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_2_AFE_SET(0x03E6);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_3_AFE_SET(0x00EB);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_4_AFE_SET(0x00C0);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_5_AFE_SET(0x03B9);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_6_AFE_SET(0x0380);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_7_AFE_SET(0x03DA);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_8_AFE_SET(0x0000);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_9_AFE_SET(0x0000);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_10_AFE_SET(0x0000);

        // Rx BRWDF1 polyphase filter regs.
        // Control register
        //Enabled RX BRWDF1 Filter
        //Initialization of RX BRWDF1 Filter disabled
        //00b NO_BYP: decimators and filters are not bypassed (default)
        //Fiilter upon internal detection of an overflow => Enabled
        RXBRWDF1_CTRL_AFE_SET(0x0101);
        // Rx WDF1 programmable adaptor G1 coeffs.
        RXBRWDF1_COEFF_G1_AFE_SET(0x0047);
        // Rx WDF1 programmable adaptor G3 coeffs.
        RXBRWDF1_COEFF_G3_AFE_SET(0x012C);
//VR9_AFE_DIG_GLOBAL registers
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_CTL3_AFE_SET(0x0000);
        VR9_AfeWrite(PLL_CTL3, 0x0000, PLL_CTL3_PLL_DIS_RX_MASK);
        //ADCFILT_CLK_ON
        //bit4:1b :FCSI_CLK_ON:default
        //FILT_GLP_RX_CLK_ON
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_RX_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
        //FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_RX_MASK);

        break;
#endif   // ifdef VDSL_62

#ifdef ADSL_62    // VR9 ADSL build
    case ADSL_A:

//VR9_AFE_DIG_CH0 Registers

        //ADC digital data interface is in operation state
        //ADC digital data interface clock is enabled
        //ADC digital data interface clock inversion is enabled
        ADC_CTL_AFE_SET(0x0041);

//VR9_AFE_DIG_FILT_CH0 Registers
        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x004A);
        VR9_AfeWrite(FGLB_CTRL1, 0x004A, FGLB_CTRL1_RX_MASK);
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0004);
        VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_RX_MASK);

        // Rx Polyphase FIR: Cancel Logic + COMB1 regs.
        // Control Register
        //Enabled RXCMB1 Filter
        //Initialization of RXCMB1 Filter disabled
        //CL2 (2nd Branch) Cancellation Logic disabled
        RXCMB1_CTRL_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_0_AFE_SET(0x03BF);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_1_AFE_SET(0x038C);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_2_AFE_SET(0x0059);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_3_AFE_SET(0x00F1);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_4_AFE_SET(0x0006);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_5_AFE_SET(0x036F);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_6_AFE_SET(0x03DC);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_7_AFE_SET(0x0010);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_8_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_9_AFE_SET(0x0000);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_10_AFE_SET(0x0000);

        // Rx BRWDF1 polyphase filter regs.
        // Control register
        //Enabled RX BRWDF1 Filter
        //Initialization of RX BRWDF1 Filter disabled
        //11b BYP decimators and filters are bypassed
        //Filter upon internal detection of an overflow => Enabled
        RXBRWDF1_CTRL_AFE_SET(0x0131);
        // Rx WDF1 programmable adaptor G1 coeffs.
        RXBRWDF1_COEFF_G1_AFE_SET(0x0000);
        // Rx WDF1 programmable adaptor G3 coeffs.
        RXBRWDF1_COEFF_G3_AFE_SET(0x0000);
//VR9_AFE_DIG_GLOBAL registers
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_CTL3_AFE_SET(0x0000);
        VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_RX_MASK);
        //ADCFILT_CLK_ON
        //bit4:1b :FCSI_CLK_ON:default
        //FILT_GLP_RX_CLK_ON
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_RX_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
        //FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_RX_MASK);

        break;

    case ADSL_B:

//VR9_AFE_DIG_CH0 Registers

        //ADC digital data interface is in operation state
        //ADC digital data interface clock is enabled
        //ADC digital data interface clock inversion is enabled
        ADC_CTL_AFE_SET(0x0041);

//VR9_AFE_DIG_FILT_CH0 Registers

        //Rx bits(7,4)
        //0b Sampling  FREQ1 144 MHz for ADC (default)
        //Receive Path Trigger initialization disabled
        //FGLB_CTRL1_AFE_SET(0x004A);
        VR9_AfeWrite(FGLB_CTRL1, 0x004A, FGLB_CTRL1_RX_MASK);
        //Receive Path Enable
        //FGLB_CTRL2_AFE_SET(0x0004);
        VR9_AfeWrite(FGLB_CTRL2, 0x0005, FGLB_CTRL2_RX_MASK);

        // Rx Polyphase FIR: Cancel Logic + COMB1 regs.
        // Control Register
        //Enabled RXCMB1 Filter
        //Initialization of RXCMB1 Filter disabled
        //CL2 (2nd Branch) Cancellation Logic disabled
        RXCMB1_CTRL_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_0_AFE_SET(0x03BF);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_1_AFE_SET(0x038C);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_2_AFE_SET(0x0059);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_3_AFE_SET(0x00F1);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_4_AFE_SET(0x0006);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_5_AFE_SET(0x036F);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_6_AFE_SET(0x03DC);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_7_AFE_SET(0x0010);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_8_AFE_SET(0x0001);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_9_AFE_SET(0x0000);
        // Rx CLCCMB1 H20, H21 programmable subfilter coeffs.
        RXCMB1_COEFF_10_AFE_SET(0x0000);

        // Rx BRWDF1 polyphase filter regs.
        // Control register
        //Enabled RX BRWDF1 Filter
        //Initialization of RX BRWDF1 Filter disabled
        //11b BYP decimators and filters are bypassed
        //Filter upon internal detection of an overflow => Enabled
        RXBRWDF1_CTRL_AFE_SET(0x0131);
        // Rx WDF1 programmable adaptor G1 coeffs.
        RXBRWDF1_COEFF_G1_AFE_SET(0x0000);
        // Rx WDF1 programmable adaptor G3 coeffs.
        RXBRWDF1_COEFF_G3_AFE_SET(0x0000);
//VR9_AFE_DIG_GLOBAL registers
        //PLL_ADC_CLK_ON ADC clock is enabled
        //PLL_CTL3_AFE_SET(0x0000);
        VR9_AfeWrite(PLL_CTL3, 0x0004, PLL_CTL3_PLL_DIS_RX_MASK);
        //ADCFILT_CLK_ON
        //bit4:1b :FCSI_CLK_ON:default
        //FILT_GLP_RX_CLK_ON
        //CLOCKING_CTL_AFE_SET(0x30B3);
        VR9_AfeWrite(CLOCKING_CTL, 0x30B3, CLOCKING_CTL_RX_MASK);
        //ADC_FILT_RST_OFF Sw-reset is disabled
        //bit4:1b FCSI_RST_OFF Sw-reset is disabled,
        //FILT_GLP_RX_RST_OFF
        //RESET_CTL_AFE_SET(0x00B3);
        VR9_AfeWrite(RESET_CTL, 0x00B3, RESET_CTL_RX_MASK);

        break;
#endif   // ifdef ADSL_62

    default:
        break;
    }
    return;
}

/*
** =============================================================================
**
** FUNCTION-NAME: AFEModeSelect_HS_Init()
**
** DESCRIPTION:   This function shall be called before handshake
**                This function will configure the AFE Tx/Rx paths
**                Default configuration for VDSL mode is VDSL_8
**                AnnexA/AnnexB ADSL setting will be chosen based on
**                compile switch ISDN.(Danube implementation)
** PARAMETERS:    none
**
** RETURN VALUE:   None
**
** NOTES:          Reference: (1) VR9_AFEModeSelection.doc
**                            (2) VR9_AFE_Analog_Dig_Regs_mode dependent.xls
**                            SMS00920529
**
** =============================================================================
*/

extern FlagT gft_ByPassAfe;

void AFEModeSelect_HS_Init(void)
{
    // this check is to support VR9 bring-up only
    if (gft_ByPassAfe)
    {
        return;
    }

#ifdef VDSL_62
    VR9_ConfigAFETxPath(VDSL_8);
    VR9_ConfigAFERxPath(VDSL_8);
#else
#ifdef ADSL_62
#ifdef ISDN
    VR9_ConfigAFETxPath(ADSL_B);
    VR9_ConfigAFERxPath(ADSL_B);

#else
    VR9_ConfigAFETxPath(ADSL_A);
    VR9_ConfigAFERxPath(ADSL_A);

#endif
#endif //for ADSL_62
#endif //for VDSL_62

    VR9_ResetOutDigitalBlocks();
}
#ifndef ADSL_62
/*
** =============================================================================
**
** FUNCTION-NAME: AFEModeSelect_HS_Exit()
**
** DESCRIPTION:   This function shall be called after handshake is finished,
**                before the channel discovery & after the final profile
**                selection is done
**
** PARAMETERS:    uint16 us_ProfileSelected
**
** RETURN VALUE:   None
**
** NOTES:          Reference: (1) VR9_AFEModeSelection.doc
**                            (2) VR9_AFE_Analog_Dig_Regs_mode dependent.xls
**                            SMS00920529
**
** =============================================================================
*/
void AFEModeSelect_HS_Exit(uint16 us_ProfileSelected)
{

    switch (us_ProfileSelected)
    {
    case CNFG_V2_PROFILE_30A_MASK:
        gs_AFE_RxMode = VDSL_30;
        gs_AFE_TxMode = VDSL_30;
        gft_AEC_On = TRUE;
        break;

    case CNFG_V2_PROFILE_8A_MASK:
    case CNFG_V2_PROFILE_8B_MASK:
    case CNFG_V2_PROFILE_8C_MASK:
    case CNFG_V2_PROFILE_8D_MASK:
        gs_AFE_RxMode = VDSL_8;
        gs_AFE_TxMode = VDSL_8;
        gft_AEC_On = FALSE;
        break;

    case CNFG_V2_PROFILE_12A_MASK:
    case CNFG_V2_PROFILE_12B_MASK:
        gs_AFE_RxMode = VDSL_12;
        gs_AFE_TxMode = VDSL_12;
        gft_AEC_On = FALSE;
        break;

    case CNFG_V2_PROFILE_17A_MASK:
        gs_AFE_RxMode = VDSL_17;
        gs_AFE_TxMode = VDSL_17;
        gft_AEC_On = FALSE;
        break;

    default:
        break;

    }
    // configure AFE based on the mode selected after GHS
    VR9_ConfigAFETxPath(gs_AFE_TxMode);
    VR9_ConfigAFERxPath(gs_AFE_RxMode);

    return;
}
#endif // not ADSL_62
/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: VR9_InitAnalogRegs_Tx_Forced()
**
** DESCRIPTION:   Debug function to overwrite the default Tx AFE analog register
**                settings in the firmware.
**
** PARAMETERS:    NONE
**
**
** RETURN VALUE:  NONE
**
** NOTES:Reference:
**
**
**
** =============================================================================
*/
void VR9_InitAnalogRegs_Tx_Forced(void)
{
    return;
}
/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: VR9_InitAnalogRegs_Rx_Forced()
**
** DESCRIPTION:   Debug function to overwrite the default Rx AFE analog register
**                settings in the firmware.
**
** PARAMETERS:    NONE
**
**
** RETURN VALUE:  NONE
**
** NOTES:Reference:
**
**
**
** =============================================================================
*/
void VR9_InitAnalogRegs_Rx_Forced(void)
{
    AGC1_RIN1_AFE_SET(gus_AGC1_RIN1_Overwrite);
    AGC1_RIN2_AFE_SET(gus_AGC1_RIN2_Overwrite);
    AGC1_SHUNT1_AFE_SET(gus_AGC1_SHUNT1_Overwrite);
    AGC1_SHUNT2_AFE_SET(gus_AGC1_SHUNT2_Overwrite);
    AGC1_SHUNTX_AFE_SET(gus_AGC1_SHUNTX_Overwrite);
    AGC1_CPROG_AFE_SET(gus_AGC1_CPROG_Overwrite);

    return;
}
/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: VR9_FilterConfigRegs_Tx_Forced()
**
** DESCRIPTION:   Debug function to overwrite the default Tx AFE filter config
**                registers in the firmware.
**
** PARAMETERS:    NONE
**
**
** RETURN VALUE:  NONE
**
** NOTES:Reference:
**
**
**
** =============================================================================
*/
void VR9_FilterConfigRegs_Tx_Forced(void)
{
    return;
}
/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME: VR9_FilterConfigRegs_Rx_Forced()
**
** DESCRIPTION:   Debug function to overwrite the default Rx AFE filter config
**                registers in the firmware.
**
** PARAMETERS:    NONE
**
**
** RETURN VALUE:  NONE
**
** NOTES:Reference:
**
**
**
** =============================================================================
*/
void VR9_FilterConfigRegs_Rx_Forced(void)
{
    return;
}
