/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
// ******************************************************************
// AfeAnalogRegInit.c
//
// History
//
// 23/07/2010 Nihar: Tx power boost by 1db post G.hs against all COs
//                   in all modes in Anx-A
//                   Grep for PERF_US_ALL_ALL_TxPwrBoost1dB
// 13/03/2014 Sriram Shastry : Increase US data rate against  BRCM CO for A.1.4.3 24 HDSL NEXT impairment_testprofile AU_RA_L_30000K
//          Grep for XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise
// ******************************************************************
#include "common.h"
#include "typedef.h"
#include "AfeRdWrite.h"
#include "VR9_Afedata.h"
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_global_reg.h"
#include "vr9_afe_dig_ch0_reg.h"
#include "vr9_afe_dig_filt_ch0_reg.h"
#include "vr9_afe_glp_slave_reg.h"
#include "VR9_AfeFunc.h"
#include "VRX_AfeCommonData.h"

/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/
/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  VR9_AfeInitAnalogRegistersReset
**
** DESCRIPTION:    This function writes the reset values into AFE analog global
**                 registers.
**
** PARAMETERS:     None.
**
** RETURN VALUE:   none
**
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2) VR9_AFE_Analog_Dig_Regs_Default.xls;
**                   SMS00920520
**
** =============================================================================
*/

void VR9_AfeInitAnalogRegistersReset(void)
{

    //a) LDO, PAD_CTL and BIAS_1 registers has to be set at the very begining of the register initializations.
    //b) LDO has to be set with value 0x8402.
    //c) PAD_CTL has to be set to 0x0010 if only 1 AFE is mounted, 0x0000 otherwise.
    //This is done, since the AFE voltage is set to 1.1V
    LDO_AFE_SET(0x8402);  //Line Driver Supply Output Voltage Setting; 16V (default)
    if(gft_PowerUpLink)
    {
        //Initialize these registers only during power on reset.
        //Note: Do not touch these registers on subsequent retrains after PowerOn
        //Based on v6 settings BIAS_1[5:4] :    10b  (BIAS_TEMPCOEFF_N: negative)
        //to avoid gain variation over the temperature
        BIAS_1_AFE_SET(0x852B);        //Bits <12:8> should be copied using EfuseCopy
    }
    //VR9_AFE_DIG_GLOBAL registers
    //0b EN_PIN_CLK_OUT Pin CLK_OUT is enabled (default)
    //0b EN_PIN_PLL_TEST_D Pin PLL_TEST_D is enabled (default)
    //1b SCDO_PP SCDO is push-pull
    PAD_CTL_AFE_SET(0x0010);

    AGC1_RIN1_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
    AGC1_RIN2_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
    AGC1_RINX_AFE_SET(0x00FF);     //RIN = 360Ohm (default)
    AGC1_ROUT2_AFE_SET(0xFFFF);    //AGC1 LP1 gain = 0dB
    AGC1_SHUNT1_AFE_SET(0x0000);   //RSHUNT Input A= OPEN (default)
    AGC1_SHUNT2_AFE_SET(0x0000);   //RSHUNT Input B= OPEN (default)
    AGC1_SHUNTX_AFE_SET(0x0000);   //RSHUNT Input C= OPEN (default)
    AGC1_CPROG_AFE_SET(0x8000);    //AGC1_LEVELSHIFT_PD : Power Down (default)
    AGC1_GAIN_AFE_SET(0x81FE);     //AGC1_GAIN_0DB : GAIN = 0dB (default)
    AGC1_HP_AFE_SET(0x9500);       //AGC1_HP1_PD : Power Down (default); etc

    //common Reg for VDSL/ADSL mode
    AGC1_OP1_CURR_AFE_SET(0xB092); //AGC1_VDSL : VDSL Mode = high bandwidth (default); etc

    TBUF_RCTUNING_AFE_SET(0x8800); //RCTUNING_PD :Power Down (default); RC_CALIB_OFF : OFF (default), etc
    AGC2_INPUT_AFE_SET(0x00FF);    //AGC2_RIN_1_400OHM : RL1 = 0.40kOhm (default), etc
    AGC2_FEEDB_AFE_SET(0x00AA);    //AGC2_LP2_GAIN_3P5DB : 3.5dB (default); etc
    AGC2_MISC_AFE_SET(0x1C21);     //AGC2_OP_CMILLER_0dB : for AGC2 gain = 0dB (default); etc

    if(gft_PowerUpLink)
    {

        //Initialize these registers only during power on reset.
        //Note: Do not touch these registers on subsequent retrains after PowerOn
        ADC_LOOPF2_1_AFE_SET(0x4088);   //ADC INTE12 Tuning;
        ADC_LOOPF2_2_AFE_SET(0x4002);   //ADC INTE22 Tuning
        ADC_LOOPF1_1_AFE_SET(0x4080);   //ADC Gain & INTE11 Tuning
        ADC_LOOPF1_2_AFE_SET(0x4002);   //ADC INTE21 Tuning
    }

    BIAS_2_AFE_SET(0xAAAA);        //Nominal values set for AGC1 LP1, AGC1 HP1 & AGC1 Levelshifter
    BIAS_3_AFE_SET(0x44AA);        //Nominal values set for POFIPOCO opamps
    BIAS_4_AFE_SET(0x344A);        //Current of Common Mode Voltage Buffer

    //common Reg for VDSL/ADSL mode
    POFIPOCO_GAIN_AFE_SET(0x95BC);  //POFIPOCO Passive 1st Order LP Tuning<9:8>;
    //POFIPOCO Cutoff Frequency adjustment<7:4>
    //1100BPOFIPOCO_GAIN_0DB : 0dB (default)<3:0)
    //common Reg for VDSL/ADSL mode
    POFIPOCO_TRIM_1_AFE_SET(0x4002);//POFIPOCO VDSL/ADSL Mode Setting; No filtering(default)
    //common Reg for VDSL/ADSL mode
    POFIPOCO_TRIM_2_AFE_SET(0x6E99);//POFIPOCO Tuning for VDSL/ADSL modes
    DAC1_STATIC_AFE_SET(0x0000);    //DAC1 Data Format, 2's complement (default)
    DAC1_CAL_1_AFE_SET(0x41FF);     //DAC1 Calibration Enable/Disable
    DAC1_CAL_2_AFE_SET(0x21FF);     //DAC1 Variable Calibration Cycle
    DAC1_MISC_1_AFE_SET(0x10A2);    //DAC1 COARSE & FINE GAIN settings;  CGain -1.45dB(default)
    //common Reg for VDSL/ADSL mode
    DAC1_MISC_2_AFE_SET(0x0400);    //DAC1 Mode Setting for VDSL/ADSL; ADSL Mode = 8bit (default)
    DAC2_STATIC_AFE_SET(0x0000);    //DAC2 Data Format; 2's complement (default)
    DAC2_CAL_1_AFE_SET(0x00FF);     //DAC2 Calibration Digital Enable/Disable; Enabled (default)
    DAC2_CAL_2_AFE_SET(0x20FF);     //DAC2 Variable Calibration Cycle; Sets nominal value(default)
    DAC2_MISC_AFE_SET(0x1700);      //DAC2 Gain Setting; 0dB (default)

#if 0 //VR9_BRINGUP
    //This is done, since the AFE voltage is set to 1.1V
    //As Per AFE teams Input LDO init must be done at the beginning of AFE initialization
    //Hence it is moved.
    LDO_AFE_SET(0x8402);            //Line Driver Supply Output Voltage Setting; 16V (default)
#endif

    ADC_BIAS_AFE_SET(0x00AA);       //ADC Interpolator Bias Current 100% (defalut)
    ADC_CLK_STG2_AFE_SET(0x8000);   //ADC Clocking Stage2 Power Down (default)
    ADC_LNDEC_STG2_AFE_SET(0x0000); //ADC Line decoder Data Output Stage 2; Enable/Disable
    ADC_DACS_STG2_AFE_SET(0xA0A0);  //ADC Reference Trimming DAC12 & DAC22 ; 100% default

    //ADC_LOOPF2_1_AFE_SET(0x4088);   //ADC INTE12 Tuning;
    //ADC_LOOPF2_2_AFE_SET(0x4002);   //ADC INTE22 Tuning

    ADC_LOOPF_MISC_AFE_SET(0x800F); //ADC Integrators Power Down settings; Power Down(default)
    ADC_OVLD_AFE_SET(0x0500);       //ADC Overload Reference Voltage; 1.0V (default)
    ADC_COMP_QT_AFE_SET(0x2020);    //ADC Trimming comparator selction for STG12
    ADC_COMP_STG12_AFE_SET(0x0BCB); //ADC trimming comparators for STG12
    ADC_LNDEC_STG1_AFE_SET(0x0100); //ADC Stage1 selection settings
    ADC_DACS_STG1_AFE_SET(0x80A0);  //ADC Reference Trimming DAC21; 100% default

    //   ADC_LOOPF1_1_AFE_SET(0x4080);   //ADC Gain & INTE11 Tuning
    //   ADC_LOOPF1_2_AFE_SET(0x4002);   //ADC INTE21 Tuning

    ADC_DACEXT_AFE_SET(0x00FF);     //ADC Static Data Register for DACs
    ADC_CLK_STG1_AFE_SET(0x8000);   //ADC Clocking Stage1 Power Up/Down
    ADC_DACCAL_1_AFE_SET(0x807F);   //ADC Comparator Calibration with DAC21 & DAC11
    ADC_DACCAL_2_AFE_SET(0x007F);   //ADC Comparator Calibration with DAC22 & DAC12
}

// PERF_US_ALL_ALL_TxPwrBoost1dB (Start)
/*******************************************************************************
*
*  Prototype: void IncreaseTxPowerInAFE_VR9 (void)
*
*  This function reconfigures AFE post handshake to Boost the Tx Power in the AFE.
*
*  Input Arguments:
*
*  Output Arguments:
*
*  Returns:
*
*  Global Variables:
*
*******************************************************************************/
// PERF_US_ALL_ALL_TxPwrBoost1dB (Start)
//XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise (Start)
// XDSLRTFW-1891:ADSL: PSD violation in all modes (Start)
C_SCOPE void IncreaseTxPowerInAFE_VR9(void)
{
   uint16 us_POFIPOCO_gain;
   us_POFIPOCO_gain = POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_AFE_GET;
   us_POFIPOCO_gain++;
   if (gft_AFEPowerBoost == TRUE)
      us_POFIPOCO_gain++;
   if (us_POFIPOCO_gain > 0xF)
      us_POFIPOCO_gain = 0xF;

   POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_AFE_SET(us_POFIPOCO_gain);
}
// XDSLRTFW-1891:ADSL: PSD violation in all modes (End)
//XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise (End)
// PERF_US_ALL_ALL_TxPwrBoost1dB (End)
