/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2009 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE =
** CCASE_DATE =
**
** =============================================================================
**
** Contents:   Inside this file the Filter Tuning for the AFE is implemented.
**
** Functions:  FilterTune()
**
**
** =============================================================================
**
** References: XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**
** =============================================================================
** History:
**
** Date        Author            Comment
**                               Creation
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    =
 CCASE_VERSION =
***C*E*************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES

** =============================================================================
*/

#include "typedef.h"
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_global_reg.h"
#include "VR9_Afedata.h"
#include "AfeRdWrite.h"
#include "FilterTune.h"
#include "VR9_AfeFunc.h"
#include "VRX_AfeCommonData.h"

/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   FilterTune()
**
** DESCRIPTION:     The Function calls "Compute_N" (which calculates the Value N)
**                   for different cases as per given in the VR9 Spec
**                  (see EQ 2 in section 2.5.1 and Table 28 and Table 29 of Ref )
**                  The value N shall be computed for the POFIPOCO filter as well
**                  as for the 2 INTE in the each stage (Stage1 & Stage2)of ADC.
**                  The equation for the computation is given below.
**                  N = (Nfix + Nuser)* (CNT/(CNTnom + Cgain)) - (Nfix + Coffset)
**
**                 tuning_word=floor((Nfix+Nuser)*((CNTnom+Cgain)/CNT)-(Nfix+Coffset));
**                 maximum value is 4096, typical values are below 600.
**
** PARAMETERS:     1. gus_RCtimeConst is the o/p of the function MeasureRC()
**                2. Filter parameters are defined in "FilterTune.h"
**                 3. Registers to be programmed POFIPOCO_TRIM_2(AFE_BASE + 0x1a)
**                                               POFIPOCO_GAIN (AFE_BASE + 0x18)
**                                               ADC_LOOPF1_1 (AFE_BASE + 0x34)
**                                               ADC_LOOPF1_2 (AFE_BASE + 0x35)
**                                               ADC_LOOPF2_1 (AFE_BASE + 0x2C)
**                                               ADC_LOOPF2_2 (AFE_BASE + 0x2D)
**
** RETURN VALUE:   NONE
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2) UTP numbser SMS00904144
**                   The constants were defined in FilterTune.h as per the
**                   tables 28 and 29 in the aboves, FilterTune.h has to be
**                   modified if there are any changes in these tables.
** =============================================================================
*/



void FilterTune (uint16 us_Filter)
{

   uint16 us_TuningWord = 0;
   switch( us_Filter )
   {
      //// Tuning Constants for POFIPOCO for ADSL mode
      case POFI_POCO_ADSL_80K:
         us_TuningWord = Compute_N_POFI( NFIX_ADSL_80K,
                                    NUSER_ADSL_80K,
                                    COFFSET_ADSL_80K,
                                    INV_CNTNOM_PLUS_CGAIN_ADSL_80K);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)lower 6 bits ??
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)upper 2 bits ??
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_ADSL_160K:
         us_TuningWord = Compute_N_POFI( NFIX_ADSL_160K,
                                    NUSER_ADSL_160K,
                                    COFFSET_ADSL_160K,
                                    INV_CNTNOM_PLUS_CGAIN_ADSL_160K);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_ADSL_320K:
         us_TuningWord = Compute_N_POFI( NFIX_ADSL_320K,
                                    NUSER_ADSL_320K,
                                    COFFSET_ADSL_320K,
                                    INV_CNTNOM_PLUS_CGAIN_ADSL_320K);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_ADSL_640K:
         us_TuningWord = Compute_N_POFI( NFIX_ADSL_640K,
                                    NUSER_ADSL_640K,
                                    COFFSET_ADSL_640K,
                                    INV_CNTNOM_PLUS_CGAIN_ADSL_640K);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_ADSL_1280K:
         us_TuningWord = Compute_N_POFI( NFIX_ADSL_1280K,
                                    NUSER_ADSL_1280K,
                                    COFFSET_ADSL_1280K,
                                    INV_CNTNOM_PLUS_CGAIN_ADSL_1280K);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_ADSL_2560K:
         us_TuningWord = Compute_N_POFI( NFIX_ADSL_2560K,
                                    NUSER_ADSL_2560K,
                                    COFFSET_ADSL_2560K,
                                    INV_CNTNOM_PLUS_CGAIN_ADSL_2560K);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      // Tuning Constants for POFIPOCO for VDSL mode
      case POFI_POCO_VDSL_5M:
         us_TuningWord = Compute_N_POFI( NFIX_VDSL_5M,
                                    NUSER_VDSL_5M,
                                    COFFSET_VDSL_5M,
                                    INV_CNTNOM_PLUS_CGAIN_VDSL_5M);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_VDSL_10M:
         us_TuningWord = Compute_N_POFI( NFIX_VDSL_10M,
                                    NUSER_VDSL_10M,
                                    COFFSET_VDSL_10M,
                                    INV_CNTNOM_PLUS_CGAIN_VDSL_10M);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_VDSL_20M:
         us_TuningWord = Compute_N_POFI( NFIX_VDSL_20M,
                                    NUSER_VDSL_20M,
                                    COFFSET_VDSL_20M,
                                    INV_CNTNOM_PLUS_CGAIN_VDSL_20M);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_VDSL_33M:
         us_TuningWord = Compute_N_POFI( NFIX_VDSL_33M,
                                    NUSER_VDSL_33M,
                                    COFFSET_VDSL_33M,
                                    INV_CNTNOM_PLUS_CGAIN_VDSL_33M);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;
      case POFI_POCO_VDSL_40M:
         us_TuningWord = Compute_N_POFI( NFIX_VDSL_40M,
                                    NUSER_VDSL_40M,
                                    COFFSET_VDSL_40M,
                                    INV_CNTNOM_PLUS_CGAIN_VDSL_40M);
         us_TuningWord = ((us_TuningWord) < (0xFF) ? (us_TuningWord) : (0xFF));
         //POFIPOCO_PRG_R - of Reg POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
         //Tuning of the overall cutoff frequency in POFIPOCO
         POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(us_TuningWord & 0x3F);
         //POFIPOCO_TRIM_CP1 - of Reg POFIPOCO_GAIN (AFE_BASE + 0x18)
         //Tuning of the passive 1st order lowpass at the input of the
         //POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for
         //POFIPOCO (see POFIPOCO_PRG_R)
         POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET((us_TuningWord >> 6) & 0x3);
         break;

      //***********************************************************************
      // STAGE1, INTEGRATOR 1  in reg (AFE_BASE + 0x34)
      // ADC INTE11 Tuning - Tuning of the 1st Integrator's Time Constant
      // in stage 1 of the ADC. The tuning word is calculated by the VR9-D.
      // The programming is binary coded.
      //macro to be used ADC_LOOPF1_1_ADC_BITC11_AFE_SET
      //************************************************************************
      case ADC_INTE11_VDSL_30:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE11_VDSL_30,
                                       NUSER_ADC_INTE11_VDSL_30,
                                       COFFSET_ADC_INTE11_VDSL_30,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_30,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_1_ADC_BITC11_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE11_VDSL_17:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE11_VDSL_17,
                                       NUSER_ADC_INTE11_VDSL_17,
                                       COFFSET_ADC_INTE11_VDSL_17,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_17,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_1_ADC_BITC11_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE11_VDSL_12:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE11_VDSL_12,
                                       NUSER_ADC_INTE11_VDSL_12,
                                       COFFSET_ADC_INTE11_VDSL_12,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_12,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_1_ADC_BITC11_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE11_VDSL_5:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE11_VDSL_5,
                                       NUSER_ADC_INTE11_VDSL_5,
                                       COFFSET_ADC_INTE11_VDSL_5,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_5,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_1_ADC_BITC11_AFE_SET(us_TuningWord);
         break;

      //************************************************************************
      // STAGE1, INTEGRATOR 2 in reg (AFE_BASE + 0x35)
      // ADC INTE21 Tuning - Tuning of the 2nd Integrator's Time Constant
      // in stage 1 of the ADC. The tuning word is calculated by the VR9-D.
      // The programming is binary coded. */
      //macro to be used ADC_LOOPF1_2_ADC_BITC21_AFE_SET
      //************************************************************************
      case ADC_INTE21_VDSL_30:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE21_VDSL_30,
                                       NUSER_ADC_INTE21_VDSL_30,
                                       COFFSET_ADC_INTE21_VDSL_30,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_30,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_2_ADC_BITC21_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE21_VDSL_17:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE21_VDSL_17,
                                       NUSER_ADC_INTE21_VDSL_17,
                                       COFFSET_ADC_INTE21_VDSL_17,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_17,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_2_ADC_BITC21_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE21_VDSL_12:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE21_VDSL_12,
                                       NUSER_ADC_INTE21_VDSL_12,
                                       COFFSET_ADC_INTE21_VDSL_12,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_12,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_2_ADC_BITC21_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE21_VDSL_5:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE21_VDSL_5,
                                       NUSER_ADC_INTE21_VDSL_5,
                                       COFFSET_ADC_INTE21_VDSL_5,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_5,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF1_2_ADC_BITC21_AFE_SET(us_TuningWord);
         break;

      //************************************************************************
      // STAGE2, INTEGRATOR 1 in reg (AFE_BASE + 0x2c)
      // ADC INTE12 Tuning - Tuning of the 1st Integrator's Time Constant
      // in stage 2 of the ADC. The tuning word is calculated by the VR9-D.
      // The programming is binary coded.
      //macro to be used ADC_LOOPF2_1_ADC_BITC12_AFE_SET
      //************************************************************************
      case ADC_INTE12_VDSL_30:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE12_VDSL_30,
                                       NUSER_ADC_INTE12_VDSL_30,
                                       COFFSET_ADC_INTE12_VDSL_30,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_30,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF2_1_ADC_BITC12_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE12_VDSL_17:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE12_VDSL_17,
                                       NUSER_ADC_INTE12_VDSL_17,
                                       COFFSET_ADC_INTE12_VDSL_17,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_17,
                                       gus_RCtimeConstCNT);

         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF2_1_ADC_BITC12_AFE_SET(us_TuningWord);
         break;

      //************************************************************************
      // STAGE2, INTEGRATOR 2 in reg (AFE_BASE + 0x2d)
      // ADC INTE22 Tuning - Tuning of the 2nd Integrator's Time Constant
      // in stage 2 of the ADC. The tuning word is calculated by the VR9-D.
      // The programming is binary coded.
      //macro to be used ADC_LOOPF2_2_ADC_BITC22_AFE_SET
      //************************************************************************
      case ADC_INTE22_VDSL_30:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE22_VDSL_30,
                                       NUSER_ADC_INTE22_VDSL_30,
                                       COFFSET_ADC_INTE22_VDSL_30,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_30,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF2_2_ADC_BITC22_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE22_VDSL_17:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE22_VDSL_17,
                                       NUSER_ADC_INTE22_VDSL_17,
                                       COFFSET_ADC_INTE22_VDSL_17,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_17,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF2_2_ADC_BITC22_AFE_SET(us_TuningWord);
         break;
      case ADC_INTE22_VDSL_12:
         us_TuningWord = Compute_N_ADC(NFIX_ADC_INTE22_VDSL_12,
                                       NUSER_ADC_INTE22_VDSL_12,
                                       COFFSET_ADC_INTE22_VDSL_12,
                                       CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_12,
                                       gus_RCtimeConstCNT);
         us_TuningWord = ((us_TuningWord) < (0x3F) ? (us_TuningWord) : (0x3F));
         ADC_LOOPF2_2_ADC_BITC22_AFE_SET(us_TuningWord);
         break;

      default:
         break;
   }

}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   Compute_N_POFI()
**
** DESCRIPTION:     The Function calculates the Value N
**                  The equation for the computation is given below.
**                  N = (Nfix + Nuser)* (CNT/(CNTnom + Cgain)) - (Nfix + Coffset)
**
** PARAMETERS:     1. CNT => gus_RCtimeConst is the o/p of the function MeasureRC()
**                2. Nfix ,Nuser,Coffset, 1/((CNTnom + Cgain)
**
** RETURN VALUE:   N value
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
** =============================================================================
*/


uint16 Compute_N_POFI(uint16 us_Nfix, uint16 us_Nuser,
      uint16 us_Coffset,uint16 us_invOfCnomPlusCGain)
{

   uint32 ul_var1,ul_var2;
   uint16 us_var1,us_var2,us_var3,us_var_out;
   uint16 us_RndConst=0x8000;
   uint16 us_RndConst8 = 0x0080;

   us_var1 = us_Nfix + us_Nuser;
   //(Nfix + Nuser) * (CNT)
   ul_var2 = us_var1 * gus_RCtimeConstCNT;
   us_var2 = us_invOfCnomPlusCGain;//ie.,((1<<24)-1)/CNTnomPCG; This will be constant */
   //Rounding (add 0x80) for 1/(CNTnom + Cgain) before  right shift by 8
   us_var2 += us_RndConst8;
   //right shift by 8 to avoid saturation => ((1<<16)-1)/CNTnomPCG with rounding;
   us_var2 >>=8;
   //(Nfix + Nuser) * (CNT)*((1<<16)-1)/CNTnomPCG
   ul_var1 = ul_var2 * us_var2;
   // Add Rounding constant (0x8000) before right shift
   ul_var1 += us_RndConst;
   //(Nfix + Nuser) * (CNT)/CNTnomPCG
   us_var_out = (uint16 )(ul_var1 >>16);
   // Nfix + Coffset
   us_var3 = us_Nfix + us_Coffset;
   //N = (Nfix + Nuser) * (CNT)/(CNTnom + Cgain)) - (Nfix + Coffset)
   us_var_out -= us_var3;
   return(us_var_out);
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   Compute_N_ADC()
**
** DESCRIPTION:     The Function calculates the Value N for the ADC filters
**                  The equation for the computation is given below.
**                  N = (Nfix + Nuser)* ((CNTnom + Cgain)/CNT) - (Nfix + Coffset)
**
** PARAMETERS:     1. CNT => gus_RCtimeConst is the o/p of the function MeasureRC()
**                2. Nfix ,Nuser,Coffset, CNTnom + Cgain
**
** RETURN VALUE:   N value
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
** =============================================================================
*/

uint16 Compute_N_ADC(uint16 us_Nfix, uint16 us_Nuser, uint16 us_Coffset, uint16 CNTnomPCG,uint16 us_RCtimeConstCNT)
{
   uint32 ul_var2;
   uint16 us_var1,us_var3,us_var_out;
   uint8 uc_RndConst = 0x80;

   us_var1 = us_Nfix + us_Nuser;
   //(Nfix + Nuser) * (CNTnom + Cgain)
   ul_var2 = us_var1 * CNTnomPCG;
   // scale up in order to get maximum precision, multiplication with scaleFactor=256
   ul_var2 <<= 7;
   ul_var2 /= us_RCtimeConstCNT;
   ul_var2 <<= 1;
   //round: add scaleFactor/2
   ul_var2 += uc_RndConst;
   //right shift by 7 to avoid saturation => ((1<<16)-1)/CNTnomPCG with rounding;
   //(Nfix + Nuser) * (CNTnomPCG) / CNT
   ul_var2 >>=8;
   us_var_out = (uint16)(ul_var2);
   // Nfix + Coffset
   us_var3 = us_Nfix + us_Coffset;
   //N = (((Nfix + Nuser) * (CNTnomPCG)) / CNT) - (Nfix + Coffset)
   us_var_out -= us_var3;
   return(us_var_out);
}
