/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// FuseCopy.c
//
// History
//
// 29/09/2010 Nihar: Prevent VDSL FW to start if AFE register is fused to a defined value.
//                          This is a way to use the VR9 as AR10 till the time AR10 is officially available.
//                      Grep for XDSLRTFW-178
//
// 23/03.2011 Vinjam: ARX208 support in VR9 ADSL Firmware
//            Grep for XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV
// 27/03/2013 Mahesh Set proper fuse data in AFE regs BIAS1 & DAC1_MISC1
//                      Grep for XDSLRTFW-785: Bug_All_All_All_PsdAfeReg
// ******************************************************************
/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "typedef.h"
#include "AfeRdWrite.h"
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_global_reg.h"
#include "vr9_afe_dig_ch0_reg.h"
#include "vr9_afe_dig_filt_ch0_reg.h"
#include "vr9_afe_glp_slave_reg.h"
#include "VR9_AfeFunc.h"
#include "VR9_Afedata.h"
#include "VRX_AfeCommonData.h"
/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

#define  DEF_BGAP_TRIM    (123)  //TBD
/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/


      //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
extern uint16 gus_DacTrimVal;
/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  VR9_EfuseCopy
**
** DESCRIPTION:    This routine shall be part of the power up
**                 initialization sequence of the firmware.
**
** PARAMETERS:     None.
**
** RETURN VALUE:
**
**
** NOTES:          Reference: (1) VR9_EFusing.doc;
**                            SMS00920525
**
** =============================================================================
*/
uint16 gus_fuse_read_ok = 0; //Debug

//XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start_End)
uint16 gus_AfeChipId = 0;

void VR9_EfuseCopy()
{

// Based on the sequence from Brandner Stefan, 23.02.10
//;################################################## ; read fuse values into fuse_latch register
//uc_wr ( reg_bank_a_pad_ctl, FFFFh )                 ; switch SCDO to PushPull, disable clk_out and PLL_Test_d
//uc_wr ( reg_bank_e_fuse_ctl, 0017h )                ; Switch on clock for efuse block
//uc_wr ( reg_bank_e_fuse_ctl, 0014h )                ; 1. Turn the efuse wrapper power on;  deactivate  isolation.
//uc_wr ( reg_bank_e_fuse_ctl, 0004h )                ; 2. Reset efuse_wrapper; preset efuse_latches regs to 1
//uc_wr ( reg_bank_e_fuse_ctl, 1014h )                ;    efb_resn = 1; enable fuse_ready_out on GPIO1
//uc_wr ( reg_bank_e_fuse_ctl, 1814h )                ; 3. Activate the fuse read input
//pin ( GPIO_1    , Z, 10 US )                        ; 4. Wait until output ready out goes active (high)
//uc_wr ( reg_bank_e_fuse_ctl, 0017h )                ; 6. Deactivate fuse read input; Isolate and turn off the efuse wrapper
//;################################################## ; read out reg-bank-efuse regs
//uc_rd ( reg_bank_e_fuse_stat_7, 0000h )             ; Fuse[127:112]   ; reserve
//uc_rd ( reg_bank_e_fuse_stat_6, 0000h )             ; Fuse[111: 96]   ; DAC Biasing
//uc_rd ( reg_bank_e_fuse_stat_5, 0000h )             ; Fuse[ 95: 80]   ; Bandgap
//uc_rd ( reg_bank_e_fuse_stat_4, 0000h )             ; Fuse[ 79: 64]   ; Version
//uc_rd ( reg_bank_e_fuse_stat_3, 0000h )             ; Fuse[ 63: 48]   ; PSB Number
//uc_rd ( reg_bank_e_fuse_stat_2, 0000h )             ; Fuse[ 47: 32]   ; PSB Number
//uc_rd ( reg_bank_e_fuse_stat_1, 0000h )             ; Fuse[ 31: 16]   ; Lotnumber
//uc_rd ( reg_bank_e_fuse_stat_0, 0000h )             ; Fuse[ 15:  0]   ; Lotnumber

    FUSE_CTL_AFE_SET(0xFFFF);
    FUSE_CTL_AFE_SET(0x0017);
    FUSE_CTL_AFE_SET(0x0014);
    FUSE_CTL_AFE_SET(0x0004);
    FUSE_CTL_AFE_SET(0x1014);
    FUSE_CTL_AFE_SET(0x1814);
    wait_ms(1);
    FUSE_CTL_AFE_SET(0x0017);

    //XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start)
    //ChipID is represented as 0xA22, 0xA21, 0xA11 etc.. for different AFE versions.
    //ARX208 with FUSE_STAT_4 = 0xA22A:  gusa_AfeChipId[0] = 0x5,  gusa_AfeChipId[1] = 0xA22
    // XDSLRTFW-178 (Start_End)
    gft_NoVDSLIndication = 0;
    gus_AfeChipId = FUSE_STAT_4_AFE_GET;

    switch(gus_AfeChipId & 0xF)
    {
        case AFE_SUB_VERSION_ARX208_LSN:
            gusa_AfeChipId[0] = AFE_CHIP_ID_ARX208;
            gusa_AfeChipId[1] = ((gus_AfeChipId >> 4)&0x0FFF);
            // XDSLRTFW-178 (Start_End)
            gft_NoVDSLIndication = 1;
            break;

        default:
            //valid for all AFE_SUB_VERSION_XRX208 chips
            gusa_AfeChipId[0] = AFE_CHIP_ID_VRX208;
            gusa_AfeChipId[1] = gus_AfeChipId;
            break;
    }

    switch(gusa_AfeChipId[1])
    {
        case AFE_SUB_VERSION_VRX208_A11:
            gus_BandGapTrimming = DEF_BGAP_TRIM;
            break;

        default:
            //Copy bandgap trimming information for all A2X chip sets except for A11 chip sets, as A11 chip sets are not fused.
            //valid for all AFE_SUB_VERSION_XRX208 chips
      //XDSLRTFW-785: Bug_All_All_All_PsdAfeReg [Start_End]
            gus_BandGapTrimming = (FUSE_STAT_5_AFE_GET & 0x1F);
            //Set Band Gap trimming bits through read modify functions currently only for A2X chipsets.
            BIAS_1_BIAS_BGP_AFE_SET(gus_BandGapTrimming);
            gus_DacTrimVal = FUSE_STAT_6_AFE_GET;
            break;
    }
    //XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (End)

    gus_fuse_read_ok = 1234; //Debug
}
