/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "common.h"
#include "typedef.h"
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_ch0_reg.h"
#include "vr9_afe_glp_slave_reg.h"
#include "AfeRdWrite.h"
#include "VR9_Afedata.h"
#include "VR9_AfeFunc.h"
#include "VRX_AfeCommonData.h"
/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  VR9_PowerUpAfeAnalog
**
** DESCRIPTION:    Power up sequence for all blocks located in the AFE
**             After configuring the AFE registers for the handshake operation,
**             Power up the different blocks in the AFE followed by
**             the line driver. The power down bits correspoding to the several
**             blocks shall be configured to turn ON the blocks.
**             Check shall be done in such a way that if the block if already ON
**             do not turn it ON again to avoid glitches on the line.
**
**          Line driver shall be powered ON after powering up the AFE blocks
**          There is no special sequence that needs to be followed for powering
**          up the blocks inside the AFE.
**
** PARAMETERS:     None.
**
** RETURN VALUE:   none
**
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                   SMS00920538
**
** =============================================================================
*/

void VR9_PowerUpAfeAnalog(void)
{
   //AGC1_LEVELSHIFT_PD of Reg AGC1_CPROG (AFE_BASE + 0x7)
   //AGC1 Levelshifter Power UP - Sets the Power UP Mode for the
   //Levelshifter of the input network in AGC1
   if(AGC1_CPROG_AGC1_PD_LS_AFE_GET != AGC1_PD_LS_AGC1_LEVELSHIFT_PU)
      AGC1_CPROG_AGC1_PD_LS_AFE_SET(AGC1_PD_LS_AGC1_LEVELSHIFT_PU);

   //AGC1_PD_OP1 - of Reg AGC1_GAIN (AFE_BASE + 0x8)
   //AGC1 LP1 Power Up - Sets the Power UP Mode for LP1 in AGC1
   if(AGC1_GAIN_AGC1_PD_OP1_AFE_GET != AGC1_PD_OP1_AGC1_LP1_PU)
      AGC1_GAIN_AGC1_PD_OP1_AFE_SET(AGC1_PD_OP1_AGC1_LP1_PU);

   //AGC1_PD_OP2 - of Reg AGC1_HP (AFE_BASE + 0x9)
   //AGC1 HP1 Power Up - Sets the Power UP Mode of HP1 in AGC1
   if(AGC1_HP_AGC1_PD_OP2_AFE_GET != AGC1_PD_OP2_AGC1_HP1_PU)
      AGC1_HP_AGC1_PD_OP2_AFE_SET(AGC1_PD_OP2_AGC1_HP1_PU);

   //RCTUNING_PD - of Reg TBUF_RCTUNING (AFE_BASE + 0x10)
   //RC TUNING Power Up - Sets the Power Up Mode for RC measurement
   //block
//Power Down
   if(TBUF_RCTUNING_RCTUNING_PD_AFE_GET != RCTUNING_PD_RCTUNING_PD)
      TBUF_RCTUNING_RCTUNING_PD_AFE_SET(RCTUNING_PD_RCTUNING_PD);

   //Enabled for Initial testing phase
   // TODO will be removed for the releases.
#if 1
   //TBUF_PD - in Reg TBUF_RCTUNING (AFE_BASE + 0x10)
   //TESTBUFFER Power Up - Sets the Power Up Mode for the Testbuffer
   if(TBUF_RCTUNING_TBUF_PD_AFE_GET != TBUF_PD_TBUF_PU)
      TBUF_RCTUNING_TBUF_PD_AFE_SET(TBUF_PD_TBUF_PU);
#endif

   //AGC2_PD - AGC2_MISC (AFE_BASE + 0x13)
   //AGC2 Power Up - Sets the Power UP Mode for AGC2
   if(AGC2_MISC_AGC2_PD_AFE_GET != AGC2_PD_AGC2_PU)
      AGC2_MISC_AGC2_PD_AFE_SET(AGC2_PD_AGC2_PU);

   //CLK_BIAS_PD In Reg BIAS_1 (AFE_BASE + 0x14)
   //CLOCKING BIASING Power up - Sets the Power Up Mode for the
   //Biasing of the clock distribution
   if(BIAS_1_CLK_BIAS_PD_AFE_GET != CLK_BIAS_PD_CLK_BIAS_PU)
      BIAS_1_CLK_BIAS_PD_AFE_SET(CLK_BIAS_PD_CLK_BIAS_PU);

   //LOCALBIAS_PD Reg BIAS_1 (AFE_BASE + 0x14)
   //LOCALBIASING Power up - Sets the Power up Mode for the Local
   //Biasing
   if(BIAS_1_LOCALBIAS_PD_AFE_GET != LOCALBIAS_PD_LOCALBIAS_PU)
      BIAS_1_LOCALBIAS_PD_AFE_SET(LOCALBIAS_PD_LOCALBIAS_PU);

   //CENTRALBIAS_PD Reg BIAS_1 (AFE_BASE + 0x14)
   //CENTRALBIASING Power up - Sets the Power up Mode for the Central
   //Biasing
   if(BIAS_1_CENTRALBIAS_PD_AFE_GET != CENTRALBIAS_PD_CENTRALBIAS_PU)
      BIAS_1_CENTRALBIAS_PD_AFE_SET(CENTRALBIAS_PD_CENTRALBIAS_PU);

   //POFIPOCO_PD - For  POFIPOCO_GAIN (AFE_BASE + 0x18)
   //POFIPOCO Power Up - Sets the Power Up Mode for POFIPOCO.
   if(POFIPOCO_GAIN_POFIPOCO_PD_AFE_GET != POFIPOCO_PD_POFIPOCO_PU)
      POFIPOCO_GAIN_POFIPOCO_PD_AFE_SET(POFIPOCO_PD_POFIPOCO_PU);

   //DAC1_PD_BIAS - For DAC1_MISC_1 (AFE_BASE + 0x1e)
   //DAC1 Power Up - Sets the Power Up Mode for DAC1
   if(DAC1_MISC_1_DAC1_PD_BIAS_AFE_GET != DAC1_PD_BIAS_DAC1_PU)
      DAC1_MISC_1_DAC1_PD_BIAS_AFE_SET(DAC1_PD_BIAS_DAC1_PU);
   if(gft_AEC_On)
   {
      //DAC2_PD_BIAS - For DAC2_MISC (AFE_BASE + 0x23)
      //DAC2 Power Up - Sets the Power Up Mode for DAC2
      if(DAC2_MISC_DAC2_PD_BIAS_AFE_GET != DAC2_PD_BIAS_DAC2_PU)
         DAC2_MISC_DAC2_PD_BIAS_AFE_SET(DAC2_PD_BIAS_DAC2_PU);
   }

   //ADC_PD_CLK_STG2 - For ADC_CLK_STG2 (AFE_BASE + 0x29)
   //ADC Clocking Stage2 Power Up - Sets the Power Up Mode for the
   //ADC clocking in the stage 2
   if(ADC_CLK_STG2_ADC_PD_CLK_STG2_AFE_GET != ADC_PD_CLK_STG2_ADC_CLK_STG2_PU)
      ADC_CLK_STG2_ADC_PD_CLK_STG2_AFE_SET(ADC_PD_CLK_STG2_ADC_CLK_STG2_PU);

   //ADC_PD_DAC12 - For ADC_DACS_STG2 (AFE_BASE + 0x2b)
   //ADC DAC12 Power Up - Sets the Power Up Mode for the 1st DAC in
   //stage 2 of the ADC
   if(ADC_DACS_STG2_ADC_PD_DAC12_AFE_GET != ADC_PD_DAC12_ADC_DAC12_PU)
      ADC_DACS_STG2_ADC_PD_DAC12_AFE_SET(ADC_PD_DAC12_ADC_DAC12_PU);

   //ADC_PD_DAC22 - For ADC_DACS_STG2 (AFE_BASE + 0x2b)
   //ADC DAC22 Power up - Sets the Power Up mode for the 2nd DAC in
   //stage 2 of the ADC.
   if(ADC_DACS_STG2_ADC_PD_DAC22_AFE_GET != ADC_PD_DAC22_ADC_DAC22_PU)
      ADC_DACS_STG2_ADC_PD_DAC22_AFE_SET(ADC_PD_DAC22_ADC_DAC22_PU);

   //ADC_PD_OVLD - For ADC_LOOPF_MISC (AFE_BASE + 0x2e)
   //ADC Overload Power Up - Sets the Power Up Mode for the Overload
   //Circuit in the ADC
   if(ADC_LOOPF_MISC_ADC_PD_OVLD_AFE_GET != ADC_PD_OVLD_ADC_OVLD_PU)
      ADC_LOOPF_MISC_ADC_PD_OVLD_AFE_SET(ADC_PD_OVLD_ADC_OVLD_PU);

   //ADC_PD_OA11 - For ADC_LOOPF_MISC (AFE_BASE + 0x2e)
   //ADC INTE11 Power Up - Sets the Power Up Mode for the
   //1st Integrator in stage 1 of the ADC
   if(ADC_LOOPF_MISC_ADC_PD_OA11_AFE_GET != ADC_PD_OA11_ADC_OA11_PU)
      ADC_LOOPF_MISC_ADC_PD_OA11_AFE_SET(ADC_PD_OA11_ADC_OA11_PU);

   //ADC_PD_OA21 - For ADC_LOOPF_MISC (AFE_BASE + 0x2e)
   //ADC INTE21 Power Up - Sets the Power Up Mode for the
   //2nd Integrator in stage 1 of the ADC
   if(ADC_LOOPF_MISC_ADC_PD_OA21_AFE_GET != ADC_PD_OA21_ADC_OA21_PU)
      ADC_LOOPF_MISC_ADC_PD_OA21_AFE_SET(ADC_PD_OA21_ADC_OA21_PU);

   //ADC_PD_OA12 - For ADC_LOOPF_MISC (AFE_BASE + 0x2e)
   //ADC INTE12 Power up - Sets the Power up Mode for the
   //1st Integrator in stage 2 of the ADC.
   if(ADC_LOOPF_MISC_ADC_PD_OA12_AFE_GET != ADC_PD_OA12_ADC_OA12_PU)
      ADC_LOOPF_MISC_ADC_PD_OA12_AFE_SET(ADC_PD_OA12_ADC_OA12_PU);

   //ADC_PD_OA22 - For ADC_LOOPF_MISC (AFE_BASE + 0x2e)
   //ADC INTE22 Power Up - Sets the Power Up Mode for the
   //2nd Integrator in stage 2 of the ADC
   if(ADC_LOOPF_MISC_ADC_PD_OA22_AFE_GET != ADC_PD_OA22_ADC_OA22_PU)
      ADC_LOOPF_MISC_ADC_PD_OA22_AFE_SET(ADC_PD_OA22_ADC_OA22_PU);


   //ADC_PDQ_COMPTOP_STG2 - For Reg ADC_COMP_QT (AFE_BASE + 0x30)
   //ADC Top Comparator Stage 2 Power Down/up - Sets the Power Down/Up
   //Mode for the Top Comparator (MSB) in stage 2 of the ADC.
   //This comparator is only used during ADC comparator trimming phase.
   //In the application this Comparator must be in Power Down

//Power Down

   if(ADC_COMP_QT_ADC_PDQ_COMPTOP_STG2_AFE_GET !=
               ADC_PDQ_COMPTOP_STG2_ADC_COMPTOP_STG2_PDQ)
      ADC_COMP_QT_ADC_PDQ_COMPTOP_STG2_AFE_SET(
            ADC_PDQ_COMPTOP_STG2_ADC_COMPTOP_STG2_PDQ);


   //ADC_PDQ_COMPTOP_STG1 - For Reg ADC_COMP_QT (AFE_BASE + 0x30)
   //ADC Top Comparator Stage 1 Power Down/Up - Sets the Power Down/Up
   //Mode for the Top Comparator (MSB) in stage 1 of the ADC.
   //This comparator is only used during ADC comparator trimming phase.
   //In the application this Comparator must be in Power Down.
//Power Down

   if(ADC_COMP_QT_ADC_PDQ_COMPTOP_STG1_AFE_GET !=
         ADC_PDQ_COMPTOP_STG1_ADC_COMPTOP_STG1_PDQ)
      ADC_COMP_QT_ADC_PDQ_COMPTOP_STG1_AFE_SET(
         ADC_PDQ_COMPTOP_STG1_ADC_COMPTOP_STG1_PDQ);

   //ADC_PD_COMP_STG2 - For ADC_COMP_STG12 (AFE_BASE + 0x31)
   //ADC Comparators Stage 2 Power Up - Sets the Power Up Mode for the
   //Comparators in stage 2 of the ADC.
   if(ADC_COMP_STG12_ADC_PD_COMP_STG2_AFE_GET != ADC_PD_COMP_STG2_ADC_COMP_STG2_PU)
      ADC_COMP_STG12_ADC_PD_COMP_STG2_AFE_SET(ADC_PD_COMP_STG2_ADC_COMP_STG2_PU);


   //ADC_PD_COMP_STG1 - For Reg ADC_COMP_STG12 (AFE_BASE + 0x31)
   //ADC Comparators Stage 1 Power Up - Sets the Power up Mode for the
   //Comparators in stage 1 of the ADC
   if(ADC_COMP_STG12_ADC_PD_COMP_STG1_AFE_GET != ADC_PD_COMP_STG1_ADC_COMP_STG1_PU)
      ADC_COMP_STG12_ADC_PD_COMP_STG1_AFE_SET(ADC_PD_COMP_STG1_ADC_COMP_STG1_PU);


   //ADC_LOCALBIAS_PD - For Reg ADC_COMP_STG12 (AFE_BASE + 0x31)
   //ADC Biasing Power Up - Sets the Power Up Mode for the Local
   //Biasing of the ADC
   if(ADC_COMP_STG12_ADC_LOCALBIAS_PD_AFE_GET != ADC_LOCALBIAS_PD_ADC_LOCALBIAS_PU)
      ADC_COMP_STG12_ADC_LOCALBIAS_PD_AFE_SET(ADC_LOCALBIAS_PD_ADC_LOCALBIAS_PU);

   //ADC_PD_DAC11 - For Reg ADC_DACS_STG1 (AFE_BASE + 0x33)
   //ADC DAC11 Power Up - Sets the Power Up Mode for the
   //1st DAC in stage 1 of the ADC
   if(ADC_DACS_STG1_ADC_PD_DAC11_AFE_GET != ADC_PD_DAC11_ADC_DAC11_PU)
      ADC_DACS_STG1_ADC_PD_DAC11_AFE_SET(ADC_PD_DAC11_ADC_DAC11_PU);

   //ADC_PD_DAC21 - For Reg ADC_DACS_STG1 (AFE_BASE + 0x33)
   //ADC DAC21 Power Up - Sets the Power Up Mode for the
   //2nd DAC in stage 1 of the ADC
   if(ADC_DACS_STG1_ADC_PD_DAC21_AFE_GET != ADC_PD_DAC21_ADC_DAC21_PU)
      ADC_DACS_STG1_ADC_PD_DAC21_AFE_SET(ADC_PD_DAC21_ADC_DAC21_PU);

   //ADC_PD_CLK_STG1 - For Reg ADC_CLK_STG1 (AFE_BASE + 0x37)
   //ADC Clocking Stage1 Power Up - Sets the Power Up Mode for the ADC
   //clocking in the stage 1
   if(ADC_CLK_STG1_ADC_PD_CLK_STG1_AFE_GET != ADC_PD_CLK_STG1_ADC_CLK_STG1_PU)
      ADC_CLK_STG1_ADC_PD_CLK_STG1_AFE_SET(ADC_PD_CLK_STG1_ADC_CLK_STG1_PU);

   //ADC_PD_DACCAL_DIG - in Reg ADC_DACCAL_1 (AFE_BASE + 0x38)
   //ADC DAC Calibration State Machine Power Up - Sets the Power up Mode
   //for the DACs Calibration State machine in stage 1 of the ADC. Only the DACs
   //of stage 1 are calibrated

#if 1
// Power Up
   if(ADC_DACCAL_1_ADC_PD_DACCAL_DIG_AFE_GET != ADC_PD_DACCAL_DIG_ADC_DACCAL_PU)
      ADC_DACCAL_1_ADC_PD_DACCAL_DIG_AFE_SET(ADC_PD_DACCAL_DIG_ADC_DACCAL_PU  );
#endif

   //??GLP_SLAVE PMA_REGFILE PMA registers
    //PLL powerdown (bit'2) is read only register
#if 0

   //PLL_PD - in Reg PMA_STARTUP_CTRL (GLP_SLAVE_BASE + 0x13)
   //PLL powerdown (bit'2) is read only register.
   // And these values depends upon Register Bypass bit.(bit 0)
#endif

   //?? VINAX_AFE_DIG_CH0 registers

   //DAC1_PD_CLKBUF - in Reg DAC1_CTL (VINAX_AFE_DIG_CH0_BASE + 0x1)
   //DAC1 Clocking Control Register
   //DAC1 clock buffer is powered up
   if(DAC1_CTL_DAC1_PD_CLKBUF_AFE_GET != DAC1_PD_CLKBUF_DIS)
      DAC1_CTL_DAC1_PD_CLKBUF_AFE_SET(DAC1_PD_CLKBUF_DIS);

   //DAC2_PD_CLKBUF in Reg DAC2_CTL (VINAX_AFE_DIG_CH0_BASE + 0x2)
   //DAC2 Clocking Control Register
   //DAC2 clock buffer is powered up
   if(gft_AEC_On)
   {
      if(DAC2_CTL_DAC2_PD_CLKBUF_AFE_GET != DAC2_PD_CLKBUF_DIS)
         DAC2_CTL_DAC2_PD_CLKBUF_AFE_SET(DAC2_PD_CLKBUF_DIS);
   }
   //LDO_PD_HREG16 in Reg  LDO (AFE_BASE + 0x24)
   //LDO for Line Driver Supply PowerUp - Sets the Power Down/Up
   //Mode for the Linear Voltage Regulator, generating the Line Driver Supply
   //Voltage
   if(LDO_LDO_PD_HREG16_AFE_GET != LDO_PD_HREG16_LDO_HREG16_PU)
      LDO_LDO_PD_HREG16_AFE_SET(LDO_PD_HREG16_LDO_HREG16_PU);
}
