/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// SetLDMode.c
//
// History
//
// 30/8/2011 Vinjam: Integrated "DSL_PPE_CLOCK_CONTROL" code from VR9 VDSL2 code (544316)
//          Add PPE clock change CMV as DSL 15. Bits 0:1 are the new clock setting,
//           Bit 4 is a trigger bit that will be cleared by FW after the register write is done.
//           Grep for XDSLRTFW-315: Feature_ALL_ALL_ALL_DSL_PPE_CLOCK_CONTROL
// *******************************************************************************************


/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "typedef.h"
#include "AfeRdWrite.h"
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_global_reg.h"
#include "vr9_afe_dig_ch0_reg.h"
#include "vr9_afe_dig_filt_ch0_reg.h"
#include "vr9_afe_glp_slave_reg.h"
#include "VR9_Afedata.h"
#include "VR9_AfeFunc.h"
#include "data_alloc.h"
/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/
/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/
DATA_XILVB_B4_SHOW_INIT_BEGIN
uint16 gusa_LD_CTL_DOUT[SIZE_LD_CTL_DOUT]=
{
   0x200,  //LD_PDN -> GPIO_LD_CTL <15:0>
   0x1,    //   "   -> GPIO_LD_DOUT<15:0>
   0x700,  //LD_VL_ADSL
   0x7,
   0x700,  //LD_L_ADSL
   0x6,
   0x700,  //LD_M_ADSL
   0x5,
   0x700,  //LD_H_ADSL
   0x4,
   0x600,  //LD_VH_ADSL
   0x7,
   0x700,  //LD_VL_VDSL
   0x3,
   0x700,  //LD_L_VDSL
   0x2,
   0x700,  //LD_M_VDSL
   0x1,
   0x700,  //LD_H_VDSL
   0,
   0x600,  //LD_VH_VDSL
   0x3
};
DATA_MAP_END
uint16 gus_CurrLDMode = LD_PDN; //By default Line Driver is in Power down mode,
/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  VR9_GetLDMode
**
** DESCRIPTION:    Get the Line driver mode from the AFE Digital Reg and
**                 is being used now. it is common
**                 function for Low noise(ADSL) and VDSL LD modes.
**
** PARAMETERS:     None
**
** RETURN VALUE:   One of the 11 modes listed in the #define
**
**
** NOTES:          Reference: (1) VR9_LineDriver.doc
**                            SMS00920542
**
** =============================================================================
*/

uint16 VR9_GetLDMode()
{
   uint16  us_ld_ctl, us_ld_dout, i = 0;
   uint16  us_curr_LDmode = LD_MODE_INVALID; //Initialize with Invalid LD Mode

   us_ld_ctl = GPIO_LD_CTL_AFE_GET;     //LD_CTL
   us_ld_dout = GPIO_LD_DOUT_AFE_GET;   //LD_DOUT

   while(i < SIZE_LD_CTL_DOUT)
   {
      if ((us_ld_ctl == gusa_LD_CTL_DOUT[i]) && (us_ld_dout == gusa_LD_CTL_DOUT[i+1]))
         break;
      i = i + 2;
   }

   if (i < SIZE_LD_CTL_DOUT)
   {
      us_curr_LDmode = (i >> 1);
   }

   return us_curr_LDmode;
} //VR9_GetLDMode()

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  VR9_SetLDMode
**
** DESCRIPTION:    Set the Line driver mode only if change in the
**                 mode being used and mode required, it is common
**                 function for Low noise(ADSL) and VDSL LD modes.
**                 Update the LD mode is being used in a variable for debug.
**
** PARAMETERS:     us_LDMode --> Pass One of the 11 modes listed in the #define
**
** RETURN VALUE:
**
**
** NOTES:          Reference: (1) VR9_LineDriver.doc
**                            SMS00920542
**
** =============================================================================
*/

void VR9_SetLDMode(uint16 us_RequiredLDMode)
{

   gus_CurrLDMode = VR9_GetLDMode();
   if ((gus_CurrLDMode != us_RequiredLDMode) && (us_RequiredLDMode <= LD_VH_VDSL))
   {
      //if Change in the LD mode, then change it.
      GPIO_LD_CTL_AFE_SET(gusa_LD_CTL_DOUT[us_RequiredLDMode << 1]);
      GPIO_LD_DOUT_AFE_SET(gusa_LD_CTL_DOUT[(us_RequiredLDMode << 1)+1]);
      gus_CurrLDMode = us_RequiredLDMode; //Update the LD mode is being set.
   }
} //VR9_SetLDMode()
