/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// ThreeGLP_Interface.c
//
// History
//
// 24/03/2011 Vinjam: Add "enable FIFOs" in FIFO init function and
//            renamed "VR9_A2x_FIFO_FIX( )" to "VR9_Init_AFE_FIFOs( )"
//            Grep for XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO
//
//09/11/2012 Kannan: VRX318 specific 3GLP changes from sudhakar singapore team.
//Grep for: "XDSLRTFW-541: Platform_VRX318"
//
//15/01/2013 Kannan: commented un used 3GLP codes.
//Grep for: "XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication"
//
// ******************************************************************

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "common.h"

#ifdef ADSL_62
    #include "const.h"
#else
    #include "vdsl_xception.h"
#endif
#include "typedef.h"
#include "AfeRdWrite.h"
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_global_reg.h"
#include "vr9_afe_dig_ch0_reg.h"
#include "vr9_afe_glp_slave_reg.h"
#include "vr9_afe_dig_filt_ch0_reg.h"
#include "LL_IOf.h"
#include "glptop_reg.h" //For GLP_TOP_STATUS
#include "glpm_reg.h"   //For GLPM_PLL_STATUS
#include "errc_reg.h"
#include "VR9_Afedata.h"
#include "VR9_AfeFunc.h"
#include "str_memmap.h"


/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/
#define bitmask(msb,lsb) ((((uint32)1<<(msb-lsb+1))-1) <<lsb)  // It gives a mask from msb...lsb with 1's
#define nbitmask(msb,lsb) (~(bitmask(msb,lsb))) // This gives a mask from msb...lsb with 0's

#define GLP_RD_WR_TIMEOUT                 (5000)   // TBD
#define GLPTOP_TIMEOUT_EXCEPTION_ERROR    (0x1000) // TBD
#define GLPMPLL_TIMEOUT_EXCEPTION_ERROR   (0x1001) // TBD
#define GLPMFR_TIMEOUT_EXCEPTION_ERROR    (0x1002) // TBD
/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
void GLPEnModulationTX1();
void GLPEnModulationTX2();
void GLPEnModulationTX3();
void GLPEnModulationDisTX1();
void GLPEnModulationDisTX2();
void GLPEnModulationDisTX3();
void GlpFifoCfg_0 (void);
void ErrCorrBypass_0(void);
//uint16 GlpWait4Ready_0(void);  //Not being used for 3GLP, XDSLRTFW-181
void GlpEn_0(void);
void GlpLoadEn(int slice);
void GlpLoadDis(int slice);
/*
** =============================================================================
**
** FUNCTION-NAME:  VR9_3GLP_Init_AFE
**
** DESCRIPTION:    This routine intializes the AFE (slave) portion of the
**                 3GLP Interface.
**
** PARAMETERS:     FlagT ft_BondedMode
**
** RETURN VALUE:   None
**
** NOTES:          Reference: (1) VR9_3GLP_IF.doc
**                            SMS00920523
**
** =============================================================================
*/
void VR9_3GLP_Init_AFE (FlagT ft_BondedMode)
{
   // HSFPGA_SSC(device,r.PAD_CTL,'0010');
   PAD_CTL_SCDO_PPEN_AFE_SET(SCDO_PPEN_SCDO_PP);     // set SSC.SCDO push pull

   // HSFPGA_SSC(device,r.GLP_CTL0,'0020','0020');
   GLP_CTL0_GLP_PDI_EN_AFE_SET(GLP_PDI_EN_GLP_PDI_EN);   // set GLP_PDI enable

   // HSFPGA_SSC(device,r.BIAS_1,'0000','000B');
   VR9_AfeWrite(BIAS_1,0x0, 0xB);      // Power up BIAS block

   // HSFPGA_SSC(device,r.GLP_CTL0,'0000','0011');
   VR9_AfeWrite(GLP_CTL0, 0x0, 0x11);

   // HSFPGA_SSC(device,r.GLP_CTL0,'0001','0001');
   GLP_CTL0_GLP_FCTRES_N_AFE_SET(GLP_FCTRES_N_GLP_NORMAL);

   // GLP_BERT_CTRL resvalue=00c00
   VR9_AfeWrite(GLP_BERT_CTRL, 0x00C0, 0x00C0);

   // Initializations specific to AFE chip
   // HSFPGA_SSC(device,r.RESET_CTL,'00F7','00F7');
   VR9_AfeWrite(RESET_CTL, 0xF7, 0xF7);   // disable force reset

   // HSFPGA_SSC(device,r.CLOCKING_CTL,'01F7','01F7');   %enable clocks RX/TX1/TX2
   VR9_AfeWrite(CLOCKING_CTL, 0x1F7, 0x1F7);

   // HSFPGA_SSC(device,r.GLP_CTL0,'000E','000E'); %glp_rx_data_clkout_en
   VR9_AfeWrite(GLP_CTL0, 0xE, 0xE);

   // HSFPGA_SSC(device,r.GLP_CTL1,'0000','0700'); %glp_rx_data_ctl
   VR9_AfeWrite(GLP_CTL1, 0x0, 0x700);

//   VR9_AfeWrite(GLP_FR_CTRL, 0x0300, 0x0300);  //CRC override



   //Increase data amplitude to maximum
   VR9_AfeWrite(TX_A_CTRL, 0x800F, 0x800F);

   //Increase transmitter termination to increase amplitude some more
   VR9_AfeWrite(TX_RTERM, 0x0010, 0xFFFF);

   //Enable the watch dog
   VR9_AfeWrite(GLP_FR_CTRL3, 0x0000, 0x0400);

   //Set watch dog timer
   VR9_AfeWrite(GLP_FR_WDG_CFG, 0xFFF0, 0xFFFF);



   return;
}
/*
** =============================================================================
**
** FUNCTION-NAME:  VR9_3GLP_Init_DFE
**
** DESCRIPTION:    This routine intializes the DFE (master) portion of the
**                 3GLP Interface.
**
** PARAMETERS:     FlagT ft_BondedMode
**                 FlagT ft_AEC_On
**
** RETURN VALUE:   None
**
** NOTES:          Reference: (1) VR9_3GLP_IF.doc;
**                            SMS00920523
**
** =============================================================================
*/
//Mei debug
FlagT gft_Enable3GLPLpbk;
void VR9_3GLP_Init_DFE (FlagT ft_BondedMode,
                        FlagT ft_AEC_On)
{
   uint32 data;
   uint16 us_timeout = 0;
   int slice;

   // GlpDeassertReset()   - Start
   // Deassert the function reset to the GLP Macro
   // By default, the GLP macro is in reset state
   ReadCoreReg(GLP_TOP_CFG, &data);
   data = data | 1 << 4 | 1 << 12;
   WriteCoreReg(GLP_TOP_CFG, data);
   // GlpDeassertReset()   - End

   if (ft_BondedMode)
   {
      // Bundle Mode: duo Modem Mode with 2 independent
      // 3GLP macros
      ReadCoreReg(GLP_TOP_CFG, &data);
      data = data | 1 << 31;
      WriteCoreReg(GLP_TOP_CFG, data);
   }

      //GlpMacroPLLCfg() - Start
      WriteCoreReg(GLPM_PLL_A_CTRL1, 0x1200);
      WriteCoreReg(GLPM_PLL_A_CTRL2, 0x3956);
      WriteCoreReg(GLPM_PLL_A_CTRL3, 0x0900);
      //GlpMacroPLLCfg() - End

   // GLPMacroCfg(int bundled)   - Start
   if (!ft_BondedMode)
   {
      //GlpMacroTx1AsData() - Start
      WriteCoreReg(GLPM_TX1_A_CTRL2, 0x0702);
      //GlpMacroTx1AsData() - End

      //GlpMacroTx2AsData() - Start
      WriteCoreReg(GLPM_TX2_A_CTRL2, 0x0702);
      //GlpMacroTx2AsData() - End

      // GlpMacroTx3AsClk() - Start
      // TX3      = clock (common for single & dual mode)
      // GLP Macro TX3 as clock
      // GLPM_TX3_CTRL1   : ei_en         -> 1
      ReadCoreReg(GLPM_TX3_CTRL1, &data);
      data = data | (1 << 2);
      WriteCoreReg(GLPM_TX3_CTRL1, data);
      // GLPM_TX3_A_CTRL1 : ctrl          -> 00010000
      //                  : clk_byp_en    -> 1
      ReadCoreReg(GLPM_TX3_A_CTRL1, &data);
      data = data & nbitmask(15,8) | (0x10 << 8) | (1 << 0);
      WriteCoreReg(GLPM_TX3_A_CTRL1, data);

      // GLPM_TX3_A_CTRL2 : predrv_ser_en -> 1000010
      //                  : ser_en        -> 1
      ReadCoreReg(GLPM_TX3_A_CTRL2, &data);
   //   data = data & nbitmask(14,8) | (0x42 << 8)| 1 << 15;
      WriteCoreReg(GLPM_TX3_A_CTRL2, 0xC707);
      // GlpMacroTx3AsClk() - End

      // GLP Macro TX4 power down
      // GlpMacroTx4PD() - Start
      ReadCoreReg(GLPM_TX4_CTRL1, &data);
      data &= nbitmask(0,0);
      WriteCoreReg(GLPM_TX4_CTRL1, data);
      // GlpMacroTx4PD() - End
   }
   // GLPMacroCfg(int bundled)   - End

if(gft_Enable3GLPLpbk == 1)
{
   // AfeLoopCfg() - Start
   // Configure the AFE loop (digital filters only)
   //XDSLRTFW-2169 (START)
   VR9_AfeWrite(GPIO_OMUX_CTL_1, 0x1000, 0x1000);
   VR9_AfeWrite(GPIO_CTL, 0x007F, 0x007F);
   VR9_AfeWrite(TX1ERRC_CTRL, 0x0010, 0x0010);
   VR9_AfeWrite(TX2ERRXC_CTRL, 0x0010, 0x0010);
   VR9_AfeWrite(TX1ERRC_ERRD_CTRL, 0x0011, 0x0011);
   VR9_AfeWrite(TX2ERRXC_ERRD_CTRL, 0x0011, 0x0011);
   VR9_AfeWrite(FGLB_CTRL2, 0x0007, 0x0007);
   VR9_AfeWrite(GLP_CTL0, 0x0021, 0x0021);
   VR9_AfeWrite(GLP_FR_CTRL3, 0x0403, 0x0403);
   VR9_AfeWrite(GLP_CTL0, 0x0031, 0x0031);
   VR9_AfeWrite(CLOCKING_CTL, 0x00F0, 0x00F0);
   VR9_AfeWrite(RESET_CTL, 0x00F0, 0x00F0);
   VR9_AfeWrite(GLP_CTL0, 0x003F, 0x003F);
   VR9_AfeWrite(FGLB_DIFI_TLOOP, 0x0001, 0x0001);
   //XDSLRTFW-2169 (END)
   // AfeLoopCfg() - End
}
else
{

  // LDO to 1.5v
  // VR9_AfeWrite(0x0324, 0x843D, 0xFFFF);

  VR9_AfeWrite(GLP_CTL0, 0x0020, 0x0020);

  // Power up bias block
  VR9_AfeWrite(BIAS_1, 0x0000, 0x000B);

   /*
  ;##############################################################################
   uc_wrs ( reg_bank_c_gpio_omux_ctl_1, 1000h )    ;
  ;##############################################################################
  */
  VR9_AfeWrite(GPIO_OMUX_CTL_1, 0x1000, 0xFFFF);

  /*
  ;##############################################################################
   uc_wrs ( reg_bank_c_gpio_ctl, 007Fh )           ; gpio(7) enabled
  ;##############################################################################
  */
  VR9_AfeWrite(GPIO_CTL, 0x007F, 0xFFFF);
/*
  ;##############################################################################
  ; enable all slices
  ;##############################################################################
   uc_wrs ( fglb_ctrl2, 0007h )                    ; rx_en=1,tx1_en=1,tx2_en=1
*/
  VR9_AfeWrite(FGLB_CTRL2, 0x007, 0xFFFF);
  /*
  ;##############################################################################
  ; enable glp module
  ;##############################################################################
   uc_wrs ( reg_bank_f_glp_ctl0, 0021h )           ; glp_pdi_en=1
   uc_wrs ( glp_regfile_fr_ctrl3, 0403h )          ; rx_enables=01,tx_enable=1
   uc_wrs ( reg_bank_f_glp_ctl0, 0031h )           ; glp_pdi_en=1,glp_en=1
   uc_wrs ( reg_bank_a_clocking_ctl, 00F0h )       ; glp_xxx_local_clk_en=111
   uc_wrs ( reg_bank_a_reset_ctl, 00F0h )          ; glp_xxx_force_rstq=111
   uc_wrs ( reg_bank_f_glp_ctl0, 003Fh )           ; glp_xxx_clkout_en=111
  */

  if(gft_Enable3GLPLpbk == 2)
   VR9_AfeWrite(FGLB_DIFI_TLOOP, 0x0001, 0x0001);

} //if(gft_Enable3GLPLpbk == 1)

 // New sequence initialization for A14b metal fix
   for (slice =1; slice <7; slice++) {
    GlpLoadEn(slice);
    wait_ms(1);
    GlpLoadDis(slice);
   }

#ifdef VRX318
   //XDSLRTFW-541: Platform_VRX318 (START)
   // invert the TX1 lane
   ReadCoreReg(GLPM_TX1_CTRL1, &data);
   data = data | (1 << 1);
   WriteCoreReg(GLPM_TX1_CTRL1, data);
   // invert the RX1 lane
   ReadCoreReg(GLPM_RX1_CTRL1, &data);
   data = data | (1 << 2);
   WriteCoreReg(GLPM_RX1_CTRL1, data);
   //XDSLRTFW-541: Platform_VRX318 (END)
#endif  //VRX318

   return;
}


void GlpLoadEn(int slice) {

  int data;
  switch (slice) {

  case 1: {
    ReadCoreReg(GLPM_TX1_CTRL1, &data);
    data |= 1 <<4;
    WriteCoreReg(GLPM_TX1_CTRL1, data);
  }
    break;

  case 2: {
    ReadCoreReg(GLPM_TX2_CTRL1, &data);
    data |= 1 <<4;
    WriteCoreReg(GLPM_TX2_CTRL1, data);
  }
    break;

  case 3: {
    ReadCoreReg(GLPM_TX3_CTRL1, &data);
    data |= 1 <<4;
    WriteCoreReg(GLPM_TX3_CTRL1, data);
  }
    break;

  case 4: {
    ReadCoreReg(GLPM_TX4_CTRL1, &data);
    data |= 1 <<4;
    WriteCoreReg(GLPM_TX4_CTRL1, data);
  }
    break;

  case 5: {
    ReadCoreReg(GLPM_RX1_CTRL1, &data);
    data |= 1 <<1;
    WriteCoreReg(GLPM_RX1_CTRL1, data);
  }
    break;

  case 6: {
    ReadCoreReg(GLPM_RX2_CTRL1, &data);
    data |= 1 <<1;
    WriteCoreReg(GLPM_RX2_CTRL1, data);
  }
    break;

  }

}


void GlpLoadDis(int slice) {
  int data;
  switch (slice) {

  case 1: {
    ReadCoreReg(GLPM_TX1_CTRL1, &data);
    data &= nbitmask(4,4);
    WriteCoreReg(GLPM_TX1_CTRL1, data);
  }
    break;

  case 2: {
    ReadCoreReg(GLPM_TX2_CTRL1, &data);
    data &= nbitmask(4,4);
    WriteCoreReg(GLPM_TX2_CTRL1, data);
  }
    break;

  case 3: {
    ReadCoreReg(GLPM_TX3_CTRL1, &data);
    data &= nbitmask(4,4);
    WriteCoreReg(GLPM_TX3_CTRL1, data);
  }
    break;

  case 4: {
    ReadCoreReg(GLPM_TX4_CTRL1, &data);
    data &= nbitmask(4,4);
    WriteCoreReg(GLPM_TX4_CTRL1, data);
  }
    break;

  case 5: {
    ReadCoreReg(GLPM_RX1_CTRL1, &data);
    data &= nbitmask(1,1);
    WriteCoreReg(GLPM_RX1_CTRL1, data);
  }
    break;

  case 6: {
    ReadCoreReg(GLPM_RX2_CTRL1, &data);
    data &= nbitmask(1,1);
    WriteCoreReg(GLPM_RX2_CTRL1, data);
  }
    break;

  }

}
void GlpEn_0()
{
   uint32 data;

   VR9_AfeWrite(GLP_FR_CTRL, 0x4000, 0x4040);  //ready = 0 override

   //Enable GLP
   GLP_CTL0_GLP_EN_AFE_SET(GLP_EN_GLP_EN);          // Enable GLP

   // GlPEn_0() - Start
   // Enable the GLP for Slice0 (single channel)
   ReadCoreReg(GLP_TOP_CFG, &data);
   data = data | (1 << 0);
   WriteCoreReg(GLP_TOP_CFG, data);
   // GlPEn_0() - End



}

/******************************************************************
 * Function    : GlpFifoCfg_0
 * Description : Configure the GLP FIFOs for sigle channel
 ******************************************************************/
void GlpFifoCfg_0 (void)
{
  uint32 data;
  // TX0 FIFO
  ReadCoreReg(GLP_TX0FIFO_CFG, &data);
  data = data | 1 << 0;
  WriteCoreReg(GLP_TX0FIFO_CFG, data);
  // RX0 FIFO
  ReadCoreReg(GLP_RX0FIFO_CFG, &data);
  data = data | 1 << 0;
  WriteCoreReg(GLP_RX0FIFO_CFG, data);
}


void GlpMacroRx2PD(void)
{
  uint32 data;
  ReadCoreReg(GLPM_RX2_CTRL1, &data);
  data &= nbitmask(0,0);
  WriteCoreReg(GLPM_RX2_CTRL1, data);
}

/******************************************************************
 * Function    : ErrCorrBypass_0
 * Description : Enable the error Correction in bypass mode (single)
 ******************************************************************/
void ErrCorrBypass_0(void)
{
  uint32 data;
  ReadCoreReg(ERRC_RX1_CTRL, &data);
  data = data & nbitmask(1,1) | 1 << 4
              | 0 << 1 ;
  WriteCoreReg(ERRC_RX1_CTRL, data);
}

/******************************************************************
 * Function    : GlpWait4Ready_0
 * Description : Wait for the GLP ready for single channel
 ******************************************************************/
/*
//COMMENTED SINCE THIS IS NOT BEING USED FOR 3GLP
//XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START)
uint16 GlpWait4Ready_0 (void)
{
   uint32 ul_timeout;
   uint32 data;
   data = 0;

   //1 MS timeout is OK, since this routine will be called during powerup
   //initialization
   do
   {
      ReadCoreReg (GLP_TOP_STATUS, &data);
      data = data & (1 << 0);
      ul_timeout++;
   } while( (data == 0x0) && (ul_timeout < (1 << 16)));

   if (ul_timeout >= (1 << 16))
   {
      //Log Exception code in gul_ExceptionCode
      //Port number in which Error occured <16>
      //3GLP startup procedure is not successful <15:0>
      gul_ExceptionCode = 0x84;
      return 1;
   }
   else
      return 0;
}
//XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (END)
*/
//XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (Start_End)
void VR9_Init_AFE_FIFOs(void)
{
 uint16 us_temp;

    //XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (Start)

   //enable the FIFO's
   //VR9(r.GLP_RXFIFO_CTL, '0081');
   VR9_AfeWrite(GLP_RXFIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.GLP_TX0FIFO_CTL,'0081');
   VR9_AfeWrite(GLP_TX0FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.GLP_TX1FIFO_CTL,'0081');
   VR9_AfeWrite(GLP_TX1FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.ADC_FIFO_CTL,   '0081');
   VR9_AfeWrite(ADC_FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.DAC1_FIFO_CTL,  '0081');
   VR9_AfeWrite(DAC1_FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.DAC2_FIFO_CTL,  '0081');
   VR9_AfeWrite(DAC2_FIFO_CTL, 0x81, 0xFFFF);

   //set the INIT bit
   //VR9(r.GLP_RXFIFO_CTL, '0083');
   VR9_AfeWrite(GLP_RXFIFO_CTL, 0x83, 0xFFFF);
   //VR9(r.GLP_TX0FIFO_CTL,'0083');
   VR9_AfeWrite(GLP_TX0FIFO_CTL, 0x83, 0xFFFF);
   //VR9(r.GLP_TX1FIFO_CTL,'0083');
   VR9_AfeWrite(GLP_TX1FIFO_CTL, 0x83, 0xFFFF);
   //VR9(r.ADC_FIFO_CTL,   '0083');
   VR9_AfeWrite(ADC_FIFO_CTL, 0x83, 0xFFFF);
   //VR9(r.DAC1_FIFO_CTL,  '0083');
   VR9_AfeWrite(DAC1_FIFO_CTL, 0x83, 0xFFFF);
   //VR9(r.DAC2_FIFO_CTL,  '0083');
   VR9_AfeWrite(DAC2_FIFO_CTL, 0x83, 0xFFFF);

   //release the INIT bit
   //VR9(r.GLP_RXFIFO_CTL, '0081');
   VR9_AfeWrite(GLP_RXFIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.GLP_TX0FIFO_CTL,'0081');
   VR9_AfeWrite(GLP_TX0FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.GLP_TX1FIFO_CTL,'0081');
   VR9_AfeWrite(GLP_TX1FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.ADC_FIFO_CTL,   '0081');
   VR9_AfeWrite(ADC_FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.DAC1_FIFO_CTL,  '0081');
   VR9_AfeWrite(DAC1_FIFO_CTL, 0x81, 0xFFFF);
   //VR9(r.DAC2_FIFO_CTL,  '0081');
   VR9_AfeWrite(DAC2_FIFO_CTL, 0x81, 0xFFFF);

    //XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (End)


   //% Clear status information
   //VR9(r.GLP_RXFIFO_STAT);
   us_temp = VR9_AfeRead(GLP_RXFIFO_STAT);
   //VR9(r.GLP_TX0FIFO_STAT);
   us_temp = VR9_AfeRead(GLP_TX0FIFO_STAT);
   //VR9(r.GLP_TX1FIFO_STAT);
   us_temp = VR9_AfeRead(GLP_TX1FIFO_STAT);
   //VR9(r.ADC_FIFO_STAT);
   us_temp = VR9_AfeRead(ADC_FIFO_STAT);
   //VR9(r.DAC1_FIFO_STAT);
   us_temp = VR9_AfeRead(DAC1_FIFO_STAT);
   //VR9(r.DAC2_FIFO_STAT);
   us_temp = VR9_AfeRead(DAC2_FIFO_STAT);

}

/*
** =============================================================================
**
** FUNCTION-NAME:  VR9_3GLP_ManualBringUp(uint8 ch_no)
**
** DESCRIPTION:    This routine brings up the GLP Macro manually.
**
** PARAMETERS:     uint8 ch_no
**
** RETURN VALUE:   None
**
** NOTES:          Reference: (1) VR9_3GLP_IF.doc;
**                            SMS00920523
** =============================================================================
*/
/*
//COMMENTED SINCE THIS IS NOT BEING USED FOR 3GLP
//XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START)
void VR9_3GLP_ManualBringUp(uint8 ch_no)
{
   uint32 data, addr, tmp, addr2;
   uint16 us_timeout = 0;

   addr = (ch_no == 0) ? GLPM_GLP_FR_CTRL_0 : GLPM_GLP_FR_CTRL_1;

   ReadCoreReg(addr, &data);
   data &= 0x0;   // reset all bits (default = 0x0)
   data = data
      | 1 << 2  // IB_AL = 1
      | 1 << 8  // OVR_CRC = 1
      | 1 << 9  // WD_AL = 1
      | 1 << 10 // IB_AL =1
      | 1 << 11 // FM_AL =1
      | 1 << 12 // RMT_AL =1
      | 1 << 13 // TX_RDY =1
      | 1 << 14 // WD_CHK =1
      ;
   WriteCoreReg(addr, data);

   addr = (ch_no == 0) ? GLPM_GLP_FR_MISC_0 : GLPM_GLP_FR_MISC_1;

   // Make sure Watchdogs are disabled;
   ReadCoreReg(addr, &data);
   data |= 1 << 10;  // WDG_DIS =1
   WriteCoreReg(addr, data);

   // Full bypass of the PMA
   ReadCoreReg(GLPM_PMA_STARTUP_CTRL, &data);
   data = data & nbitmask(2,2)
      | 1 << 0  // BYPASS = 1
      | 1 << 1  // PLL_RSN = 1
      | 0 << 2  // PLL_PD = 0
      ;
   WriteCoreReg(GLPM_PMA_STARTUP_CTRL, data);

   // Wait for the PLL ready (bit4 : ready)
   data = 0;
   while ((data != (1 << 4)) &&
      (us_timeout < GLP_RD_WR_TIMEOUT))
   {
      ReadCoreReg (GLPM_PLL_STATUS, &data);
      data = data & (1 << 4);
      us_timeout++;
   }
   if (us_timeout >= GLP_RD_WR_TIMEOUT)
   {
      gul_ExceptionCode = GLPMPLL_TIMEOUT_EXCEPTION_ERROR;
      EnterFailStates(E_CODE_GLP_EXCEPTION);
   }

   // Enable GLP MAcro
   if (ch_no == 0)
   {
      ReadCoreReg(GLP_TOP_CFG, &data);
      data = data | 1 << 0;
      WriteCoreReg(GLP_TOP_CFG, data);
   }
   else
   {
      ReadCoreReg(GLP_TOP_CFG, &data);
      data = data | 1 << 8;
      WriteCoreReg(GLP_TOP_CFG, data);
   }

   // start the PMD
   ReadCoreReg(GLPM_PMA_STARTUP_CTRL, &data);
   data = data & nbitmask(5,5)
      | 0 << 5 // PD = 0
      | 1 << 3 // RSTN_DIG = 1
      | 1 << 4 // RSTN_PMD = 1
      | 1 << 6 // CLK_EN = 1
      | 1 << 9 // STARTUP_RDY = 1
      ;
   WriteCoreReg(GLPM_PMA_STARTUP_CTRL, data);

   addr = (ch_no == 0) ? GLPM_GLP_FR_WD_AL_0 : GLPM_GLP_FR_WD_AL_1;

   // Override the word alignment index
   ReadCoreReg(addr, &data);
   data = data |  1 << 6 ; // OVR_IDX = 1
   WriteCoreReg(addr, data);

   addr = (ch_no == 0) ?  GLPM_GLP_FR_CTRL_0 : GLPM_GLP_FR_CTRL_1;

   // WD_CHK
   ReadCoreReg(addr, &data);
   data = data | 1<< 6;
   WriteCoreReg(addr, data);

   data = 0;
   while ((data != 0x6e78) &&
      (us_timeout < GLP_RD_WR_TIMEOUT))
   {
      // increment the index
      addr  = (ch_no == 0) ? GLPM_GLP_FR_WD_AL_0 : GLPM_GLP_FR_WD_AL_1;
      addr2 = (ch_no == 0) ? GLPM_GLP_FR_RX_UNIQ_WD_0 :GLPM_GLP_FR_RX_UNIQ_WD_1;
      ReadCoreReg(addr, &tmp);
      tmp = tmp & bitmask(5,0) | 1 << 6;
      tmp = tmp++ % (38); // should be less than deframer frame length
      WriteCoreReg(addr, tmp);
      ReadCoreReg(addr2, &data);
      data = data & 0x6e78;
      us_timeout++;
   }
   if (us_timeout >= GLP_RD_WR_TIMEOUT)
   {
      gul_ExceptionCode = GLPMFR_TIMEOUT_EXCEPTION_ERROR;
      EnterFailStates(E_CODE_GLP_EXCEPTION);
   }

   addr  = (ch_no == 0) ? GLPM_GLP_FR_CTRL_0 : GLPM_GLP_FR_CTRL_1;
   // Set the word alignment status bits
   ReadCoreReg(addr, &data);
   data |=  1 << 1; // WD_AL = 1
   WriteCoreReg(addr, data);

   // set remote alignment
   ReadCoreReg(addr, &data);
   data |= 1 << 3 | 1 << 4; // FM_AL = 1, RMT_FM_AL = 1
   WriteCoreReg(addr, data);

   // set Transmit set ready
   ReadCoreReg(addr, &data);
   data |= 1 << 5; //  TX_RDY = 1
   WriteCoreReg(addr, data);

   // deassert the word check, otherwise the deframer looks for unique word
   ReadCoreReg(addr, &data);
   data = data & nbitmask(14,14);
   WriteCoreReg(addr, data);

   return;
}
//XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (END)
*/
