/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "common.h"

#ifdef ADSL_62
    #include "const.h"
    #include "gdata.h"
#else
    #include "vdsl_xception.h"
#endif
#include "typedef.h"
#include "AfeRdWrite.h"
#include "vr9_afe_glp_slave_reg.h"
#include "LL_IOf.h"
#include "glptop_reg.h" //For GLP_TOP_STATUS
#include "glpm_reg.h"   //For GLPM_PLL_STATUS
#include "VR9_Afedata.h"
#include "VR9_AfeFunc.h"



//Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status (Start)
/*
** =============================================================================
**
** FUNCTION-NAME:  Update_GLP_OverFlowCounters()
**
** DESCRIPTION:    This routine updates counter w.r.t the 3GLP block status like
**                   overflow underflow and ready status.
**
** PARAMETERS:     none
**
** RETURN VALUE:   None
**
** NOTES:
** =============================================================================
*/
void Update_GLP_OverFlowCounters(uint8 ch_no)
{
   uint32 ul_data,ul_addr,ul_addr1, ul_addr2,ul_addr3;
   uint32 ul_mask;
   ul_addr = GLP_TOP_STATUS;
   if(ch_no == 0)
   {
      ul_mask  = GLP_TOP_STATUS_NRDY0_MASK;
      ul_addr1 = GLPM_GLP_FR_ERR_0;
      ul_addr2 = GLP_TX0FIFO_CFG;
      ul_addr3 = GLP_RX0FIFO_CFG;
   }
   else
   {
      ul_mask  = GLP_TOP_STATUS_NRDY1_MASK;
      ul_addr1 = GLPM_GLP_FR_ERR_1;
      ul_addr2 = GLP_TX1FIFO_CFG;
      ul_addr3 = GLP_RX1FIFO_CFG;
   }

   ReadCoreReg(GLP_TOP_STATUS, &ul_data); //Reference: VR9ssc.pdf
   if(ul_data & ul_mask)
   {
      gt_RdyOvfUdfStatus.s_DS_GLP_SYNC_ERR[ch_no]++;
   }
   // Reset Sticky bit
   SetCoreReg(GLP_TOP_STATUS,ul_mask);

   ReadCoreReg(ul_addr1, &ul_data); // Clear on Read ??
   //GLPM_GLP_FR_ERR_1_TOT_ERR_MASK(0xffff) and GLPM_GLP_FR_ERR_0_TOT_ERR_MASK(0xffff) are same
   if(ul_data & GLPM_GLP_FR_ERR_0_TOT_ERR_MASK)
      gt_RdyOvfUdfStatus.s_DS_GLP_FR_ERR[ch_no]++;

   ReadCoreReg(ul_addr2, &ul_data);
   if(ul_data & GLP_TX0FIFO_CFG_OVF_MASK)
   {
      gt_RdyOvfUdfStatus.s_US_GLP_DFE_FIFO_ERR_OVF[ch_no]++; //DFE ->3GLP overflow
   }
   if(ul_data & GLP_TX0FIFO_CFG_UDF_MASK)
   {
      gt_RdyOvfUdfStatus.s_US_GLP_DFE_FIFO_ERR_UDF[ch_no]++; //DFE ->3GLP underflow
   }
   // Reset sticky bits of UDF,OVF
   SetCoreReg(ul_addr2,(uint32)(GLP_TX0FIFO_CFG_UDF_MASK|GLP_TX0FIFO_CFG_OVF_MASK));

   ReadCoreReg(ul_addr3, &ul_data);
   if(ul_data & GLP_RX0FIFO_CFG_OVF_MASK)
   {
      gt_RdyOvfUdfStatus.s_DS_GLP_DFE_FIFO_ERR_OVF[ch_no]++; //3GLP ->DFE overflow
   }
   if(ul_data & GLP_RX0FIFO_CFG_UDF_MASK)
   {
      gt_RdyOvfUdfStatus.s_DS_GLP_DFE_FIFO_ERR_UDF[ch_no]++; //3GLP ->DFE underflow
   }
   // Reset sticky bits of UDF & OVF
   SetCoreReg(ul_addr3,(uint32)(GLP_TX0FIFO_CFG_UDF_MASK|GLP_TX0FIFO_CFG_OVF_MASK));

}
//Feature_ALL_ALL_ALL_AFE_DFE_3GLP_Status (End)
