/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//*******************************************************************
// VR9_AfeFunc.c
//
// History
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
//
// 24/06/2011 Kannan: Added function to power down & up the POFIPOCO,
//                    it was used to measure the POFIPOCO noise introduced
//                    in the DS Receiver.
//                    Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
// 20/09/2011 Anantha Ramu: Brought up Annex M feature
//                   Grep for XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M
//*****************************************************************************

#include "typedef.h"
#include "vr9_afe_analog_reg.h"
#include "vr9_afe_dig_filt_ch0_reg.h"
#include "VR9_Afedata.h"
#include "gdata.h"
#include "VR9_AfeFunc.h"
#include "AfeRdWrite.h"
#include "cmv.h"
#include "hndshk_Data.h"
#include "VRX_AfeCommonData.h"

#ifdef ADSL_62
#include "ifx_vdsl2_afe_memmap.h"
#endif
/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

#ifdef   VDSL_62
#define MAX_PGA_VR9   (60 << 8) //27dB in AGC1,27dB in AGC2, 6 dB in AGC3(8.8format)
#define MIN_PGA_VR9   (-12 <<8) //-6dB in AGC1 & -6dB in AGC2   (8.8 format)
#define AGC2_MIN_PGA (-6 << 8) //AGC2 min setting for 2MHz HP2 cutoff(8.8 format)
#endif
#ifdef   ADSL_62
#define MAX_PGA_VR9   (42 << 8) //27dB in AGC1,27dB in AGC2, 0 dB in AGC3(8.8format)
#define MIN_PGA_VR9   (-12 <<8) //-6dB in AGC1 & -6dB in AGC2   (8.8 format)
#define AGC2_MIN_PGA  (-6 << 8)//AGC2 min setting for 0.5MHz HP2 cutoff
#endif

#define AGC1_MAX_PGA (27) //Max setting in AGC1 (8.8 format)
#define AGC1_MIN_PGA (-6) //Min setting in AGC1 (8.8 format)
#define AGC2_MAX_PGA (27) //Max gain setting in AGC2(8.8 format)
#define AGC3_MAX_PGA (6 ) //Max gain setting in AGC3 (8.8 format)
#define AGC3_MIN_PGA (0 ) //Min gain setting in AGC3 (8.8 format)

/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   void BgSetPGA(void)
**
** DESCRIPTION:   This background function calculates the PGA setting
**
** PARAMETERS:       gs_PGA_required (I): required gain (dB in 8.8 format)
**                   guc_PgaTrainingState (O): status indicator
**                   gs_PGA_reg_setting (O): register value for PGA gain (RX_GAIN)
**                   gs_PGA_set (O): actual gain (dB in 8.8 format)
**
** RETURN VALUE:   NONE
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2)UTP numbser SMS00920546
** Registers used :
**          AGC1_CPROG,AGC1_ROUT2
**          AGC2 fixed gain in AGC2_INPUT
**          AGC2 variable gain AGC2_FEEDB
**          AGC3 gain programming in ADC_LOOPF1_1<7:0>
**
** TODO Revisit this paremeters Section
** =============================================================================
*/
void BgPGA(void)
{
    uint16 s_Gain1_Reg_set;
    uint16 s_Gain2_Reg_set;

#if 0
    if(((gs_PgaHandlerRun == 0)&& (gft_EnableDoublePGATrain == TRUE))
            || (gft_EnableDoublePGATrain == FALSE))
    {
        if (gft_EnableDoublePGATrain == FALSE)
        {
            //To start with AGC2 overall gain should be -6dB
            gs_AGC2_Fixed_Gain = -12;
            gs_AGC2_Gain_Set = 6;
            gs_AGC3_Gain_Set = 0;
        }

        // AGC1 Var gain = Total PGA Required - AGC2 var gain set - AGC2 Fixed gain - AGC3 var gain set
        s_Gain1_Reg_set = VR9_CalcAGC1(gs_PGA_required - ((gs_AGC2_Fixed_Gain + gs_AGC2_Gain_Set + gs_AGC3_Gain_Set) << 8));
    }

    if(((gs_PgaHandlerRun == 1) && (gft_EnableDoublePGATrain == TRUE))
            || (gft_EnableDoublePGATrain == FALSE))
    {
        // AGC2 Var gain = Total PGA Required - AGC1 gain set - AGC2 Fixed gain
        s_Gain = gs_PGA_required - ((gs_AGC1_Gain_Set + gs_AGC2_Fixed_Gain) << 8);
        s_Gain2_Reg_set = VR9_CalcAGC2(s_Gain);
    }
#else
    s_Gain1_Reg_set = VR9_CalcAGC1(gs_PGA_required - gs_AGC1_Margin );
    s_Gain2_Reg_set = VR9_CalcAGC2(gs_PGA_required - (gs_AGC1_Gain_Set << 8));
#endif
    guc_PgaTrainingState = TRAINING_DONE;
}


void SetPGA(void)
{
    if(((gs_PgaHandlerRun == 0)&& (gft_EnableDoublePGATrain == TRUE))
            || (gft_EnableDoublePGATrain == FALSE))
    {
        // program AGC1 settings
        AGC1_GAIN_AGC1_PRG_GAIN_AFE_SET(gs_Agc_prg_gain[guc_gain1_idx]);
        AGC1_ROUT2_AGC1_PRG_ROUT2_AFE_SET(gus_AGC1_Rout);
    }

    if(((gs_PgaHandlerRun == 1) && (gft_EnableDoublePGATrain == TRUE))
            || (gft_EnableDoublePGATrain == FALSE))
    {
        //AGC2gain1(Fixed Gain)
        AGC2_INPUT_AFE_SET(gus_AGC2_Fixed);

        //AGC2gain2(Variable Gain)
        AGC2_FEEDB_AGC2_PRG_GAIN_AFE_SET(gs_Agc_prg_gain[guc_gain2_idx]);
        //AGC2 Miller Capacitor programming
        AGC2_MISC_AGC2_PRG_CMILLER_AFE_SET(guc_agc2_cmiller);
#ifndef ADSL_62
        //Don't use AGC3 for ADSL modes after init with 0dB
        //Init is done at AFE_ModeSelection.c
        //AGC3 programming
        ADC_LOOPF1_1_ADC_BITR11_AFE_SET(gus_AGC3_set);
#endif

    }


}

void Reconfig_AFE(void)
{
//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (Start)
         if ((gl_SelectedMode == (MODE_G992_5 | ANNEX_M)))
         {
            POFIPOCO_TRIM_1_AFE_SET(0x5F02);
         }
         if ((gl_SelectedMode == (MODE_G992_3 | ANNEX_M)))
         {
            POFIPOCO_TRIM_1_AFE_SET(0x5F02);
         }
//XDSLRTFW-212 Feature_US_BisPlus_ALL_Bringup_Annex_M (End)

}

//void EnableAfeDataProcessing(void)
//{
//    // to be added if needed for VR9
//}

void SetInitialPgaToMax(void)
{
    gs_PGA_required = gs_max_pga_setting;
}

void AdjustPathGain(void)
{
    // to be added
}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   int16 VR9_CalcAGC1(int16 s_PGA_required)
**
** DESCRIPTION:   This function calculates the Gain setting on AGC1
**
** PARAMETERS:       gs_PGA_required (I): required gain (dB in 8.8 format)
**
** RETURN VALUE:   AGC1 reg setting
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2)UTP numbser SMS00920546
** =============================================================================
*/
int16 VR9_CalcAGC1(int16 s_PGA_required)
{
    int16 s_PGA;

    gus_AGC1_Rout = AGC1_PRG_ROUT2_AGC1_HP1_0DB; //Initialise to default

    s_PGA = s_PGA_required >> 8; //Convert to dB Format

    // Check that new setting will not exceed hardware capabilities
    if (s_PGA > (int16)AGC1_MAX_PGA) s_PGA = (int16)AGC1_MAX_PGA;

    if (s_PGA < -3) //(AGC1 < -3)
    {
        gs_AGC1_Gain_Set = AGC1_MIN_PGA;   //Set AGC1 to -6dB
        guc_gain1_idx  = AGC1_PRG_GAIN_SETTINGS-1; // gain1 Index for gs_Agc_prg_gain
    } else if (s_PGA < 0)   //(-3 <= AGC1 < 0)
    {
        gs_AGC1_Gain_Set = (-3);   //Set AGC1 to -3dB
        guc_gain1_idx  = AGC1_PRG_GAIN_SETTINGS-2; // gain1 Index for gs_Agc_prg_gain
    } else
    {
        gs_AGC1_Gain_Set = s_PGA;   // 0<=AGC1<=27
        // gain1 Index for gs_Agc_prg_gain
        guc_gain1_idx  = (AGC1_PRG_GAIN_SETTINGS-2)- gs_AGC1_Gain_Set -1;
    }


    //O/p Resistor setting of AGC1 HP1. The value must be
    //selected according to the AGC1 LP1 gain.
    // -6 dB to 12 dB the setting is 0xFFFF
    // Refer to AFE spec page 152.

    if((gs_AGC1_Gain_Set - 12) > 0)
    gus_AGC1_Rout >>= gs_AGC1_Gain_Set - 12;    //AGC1_ROUT2 Register setting.

#ifndef ADSL_62
    // AGC1 HP1 should be open for 17A & 30A profile
    if ( (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_17A_MASK) ||
            (gt_ProfileAct.us_ProfileSelected & CNFG_V2_PROFILE_30A_MASK) )
    {
        gus_AGC1_Rout = 0x0;
    }
#endif //#ifndef ADSL_62

#ifdef ISDN
    // AGC1 HP1 should be open for ADSL AnxB mode.
    gus_AGC1_Rout = 0x0;
#endif

    if (gft_EnableDoublePGATrain != FALSE)
    {
        gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Fixed_Gain + gs_AGC2_Gain_Set + gs_AGC3_Gain_Set) << 8); //8.8 format
    }

    gs_PGA1_set = gs_PGA_set;

    return(gs_Agc_prg_gain[guc_gain1_idx]); // AGC1 register Setting

}

/*
** =============================================================================
** FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:   int16 VR9_CalcAGC2(int16 s_PGA_required)
**
** DESCRIPTION:   This function calculates the Gain setting on AGC1
**
** PARAMETERS:       gs_PGA_required (I): required gain (dB in 8.8 format)
**
** RETURN VALUE:   AGC2 reg setting
**
** NOTES:Reference: (1)XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
**                  (2)UTP numbser SMS00920546
** =============================================================================
*/

int16 VR9_CalcAGC2(int16 s_PGA_required)
{
    int16 s_PGA;
    uint16 us_NumShifts = 0;

    gs_AGC2_Gain_Set = 0; // AGC2 gain
    gs_AGC3_Gain_Set = 0; // AGC3 gain

    gus_AGC3_set =0x7f;       // Register(ADC_LOOPF1_1) setting for AGC3
    s_PGA = s_PGA_required >> 8;  //Convert to dB Format
#ifdef VDSL_62
    gus_AGC2_Fixed = 0x000F; // Setting for -6dB
    gs_AGC2_Fixed_Gain = -6;   //-6dB
    if (s_PGA >= 6 )
    {
        s_PGA = s_PGA - 6 ; //Remove -6dB AGC2 fixed gain and use 0dB
        gus_AGC2_Fixed = 0x0F0F; // Setting for 0 dB
        gs_AGC2_Fixed_Gain = 0;   //0dB
    }
#endif
#ifdef ADSL_62
    gus_AGC2_Fixed = 0x0101; // Setting for -12dB
    gs_AGC2_Fixed_Gain = -12;
    s_PGA = s_PGA - gs_AGC2_Fixed_Gain;
#endif

    // Check that new setting will not exceed hardware capabilities
    if (s_PGA > (int16)AGC2_MAX_PGA +AGC3_MAX_PGA)
    s_PGA = (int16)AGC2_MAX_PGA + AGC3_MAX_PGA; //Max for AGC2Var(27)+AGC3(6) => 33dB
    if (s_PGA < 0) s_PGA = 0;   //Min for AGC2_Var + AGC3

    /* Apply gain setting */
    // Measure AGC2 variable gain
    while ((s_PGA >= (3)) && (us_NumShifts < 9) )
    {
        s_PGA       -= (3);  // Gain in 3dB Steps
        gs_AGC2_Gain_Set += 3;
        us_NumShifts++;
    }
#ifndef ADSL_62
    //Don't use AGC3 for ADSL modes after init with 0dB
    // Measure AGC3 gain after AGC1 and AGC2 are programmed.
    gs_AGC3_Gain_Set = s_PGA;
#endif

    // AGC2 gain2( variable gain) Setting
    if ( gs_AGC2_Gain_Set > 0)
    {
        guc_gain2_idx = (AGC1_PRG_GAIN_SETTINGS-2)- gs_AGC2_Gain_Set +2;

        if (gs_AGC2_Gain_Set == 3)
        guc_agc2_cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_3dB; //AGC2 Variable gain +3dB
        else if (gs_AGC2_Gain_Set == 6)
        guc_agc2_cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_6dB; //AGC2 Variable gain +6dB
        else
        guc_agc2_cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_9dB; //AGC2 Variable gain +9 to 27 dB
    }
    else if (gs_AGC2_Gain_Set == 0)
    {
        guc_gain2_idx = (AGC1_PRG_GAIN_SETTINGS-2);
        guc_agc2_cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_0dB;    //AGC2 Variable gain +0dB
    }

    gs_PGA_set = ((gs_AGC1_Gain_Set + gs_AGC2_Fixed_Gain + gs_AGC2_Gain_Set + gs_AGC3_Gain_Set) << 8); //8.8 format

    // AGC3 gain Setting for programmin ADC_LOOPF1_1
    gus_AGC3_set >>= (6 - gs_AGC3_Gain_Set);   // AGC3 register Setting
    return(gs_Agc_prg_gain[guc_gain2_idx]);   // AGC2 register Setting

}

/*^^^
*------------------------------------------------------------------------
*
*  Description: Function to Initialize the AFE registers for
*           PGA(AGC1) training
*
*  Prototype: void BgInitAFE_RegsPGA_VR9(void)
*  This function sets up AFE filter parameters for the VDSL PGA training
*           in specific to AGC1 training as HP1 is put to bypass
*
*  Input Arguments: none
*
*  Output Arguments: none
*
*  Return: none
*
*------------------------------------------------------------------------
*^^^
*/
void InitAFE_RegsPGA_ADSL_VR9 (void)
{

#ifndef ISDN
    //Anx A
    //if (loop < 1.5kft)
    if (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_1500F)
    {
      gs_AGC1_Gain_Set = -6; //-6dB
      //AGC1 gain set to -6dB
      AGC1_GAIN_AFE_SET(AGC1_PRG_GAIN_AGC1_GAIN_M6DB); //AGC1 gain for -6dB
      //Change ROUT value as per AGC1 gain
      AGC1_ROUT2_AFE_SET(0xFFFF); //ROUT for AGC1 gain of -6dB
    } //else if (loop < 4.5kft)
    else if (gs_hsk_tone_power_dB > MINIMUM_GHS_TONE_PWR_AT_4500F)
    {
      gs_AGC1_Gain_Set = 0; //0dB
      //AGC1 gain set to 0dB
      AGC1_GAIN_AFE_SET(AGC1_PRG_GAIN_AGC1_GAIN_0DB); //AGC1 gain for 0dB
      //Change ROUT value as per AGC1 gain
      AGC1_ROUT2_AFE_SET(0xFFFF); //ROUT for AGC1 gain of 0dB
    }else
    {
      gs_AGC1_Gain_Set = 12; //+12dB
      //AGC1 gain set to +12dB
      AGC1_GAIN_AFE_SET(AGC1_PRG_GAIN_AGC1_GAIN_12DB); //AGC1 gain for +12dB
      //Change ROUT value as per AGC1 gain
      AGC1_ROUT2_AFE_SET(0xFFFF); //ROUT for AGC1 gain of 12dB
    }
#else
    //Anx B
    AGC1_ROUT2_AFE_SET(0x0);//HP1 is not being used for AnxB & J
    //AGC1 Gain set to 0dB for AnxB
    AGC1_GAIN_AFE_SET(0x01FE); //01FE as default for 0dB
    gs_AGC1_Gain_Set = 0; //0dB
#endif
    //AGC2_FEEDB, LP2 open; Gain of 0dB
    //AGC2 var gain set to 0dB
    AGC2_FEEDB_AFE_SET(0x00AB);
    // Put HP2 to bypass mode for AGC1 training(AGC2 fixed =-18dB)
    AGC2_INPUT_AFE_SET(0x1000);
#ifndef ADSL_62
    //Don't use AGC3 for ADSL modes after init with 0dB
    //Init is done at AFE_ModeSelection.c
    ADC_LOOPF1_1_ADC_BITR11_AFE_SET(0x01);// AGC3 gain set to 0 dB
#endif
    guc_agc2_cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_0dB;
    //AGC2 Miller Capacitor programming
    AGC2_MISC_AGC2_PRG_CMILLER_AFE_SET(guc_agc2_cmiller);
    gs_AGC2_Fixed_Gain  = -18;
    gs_AGC2_Gain_Set = 0;
    gs_AGC3_Gain_Set = 0;
    gs_PGA_set = (gs_AGC1_Gain_Set + gs_AGC2_Fixed_Gain + gs_AGC2_Gain_Set + gs_AGC3_Gain_Set) << 8;
    if (gft_HybridTrainEnable == 1)
    {
        int16 s_HybGainIndex = (gs_LoadHybIndex * VR9_HYB_AFE_REG_GAINS);
        gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET] = gs_PGA_set;
        gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET] = gs_AGC1_Gain_Set;
        gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET] = gs_AGC2_Gain_Set;
        gsa_HybGain[s_HybGainIndex + AGC2_FIXED_GAIN_SET_OFFSET] = gs_AGC2_Fixed_Gain;
        gsa_HybGain[s_HybGainIndex + AGC3_GAIN_SET_OFFSET] = gs_AGC3_Gain_Set;
    }
}

/*^^^
*------------------------------------------------------------------------
*
*  Description: Function to Initialize the AFE registers for
*           PGA training
*
*  Prototype: void RestoreAFE_RegsforAGC2_VR9(void)
*  This function restores HP2 filter for AGC2 training
*
*
*  Input Arguments: none
*
*  Output Arguments: none
*
*  Return: none
*
*------------------------------------------------------------------------
*^^^
*/
void RestoreAFE_RegsAGC2_ADSL_VR9(void)
{
    if (gs_PgaHandlerRun ==1)
    {
        // Enable HP2, LP2,AGC2gain1 -12dB
        AGC2_INPUT_AFE_SET(0x0101);
        //AGC2_LP2_CAP_0P2F & AGC2gain2 0dB
        //AGC2_FEEDB_AFE_SET(0x02AB);
        AGC2_FEEDB_AFE_SET(0x02AA);
        guc_agc2_cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_6dB;    //AGC2 Variable gain +6dB
        //AGC2 Miller Capacitor programming
        AGC2_MISC_AGC2_PRG_CMILLER_AFE_SET(guc_agc2_cmiller);
        gs_AGC2_Fixed_Gain  = -12;
        gs_AGC2_Gain_Set = 6;
        if (gft_HybridTrainEnable == 1)
        {
            int16 s_HybGainIndex = (gs_LoadHybIndex * VR9_HYB_AFE_REG_GAINS);
            gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
            gs_AGC3_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC3_GAIN_SET_OFFSET];
            gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET] = gs_AGC2_Gain_Set;
            gsa_HybGain[s_HybGainIndex + AGC2_FIXED_GAIN_SET_OFFSET] = gs_AGC2_Fixed_Gain;
            gs_PGA_set = gs_AGC1_Gain_Set+gs_AGC2_Fixed_Gain+gs_AGC2_Gain_Set+gs_AGC3_Gain_Set;
            gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET] = gs_PGA_set;
        } else
        {
            gs_PGA_set = gs_AGC1_Gain_Set+gs_AGC2_Fixed_Gain+gs_AGC2_Gain_Set+gs_AGC3_Gain_Set;
        }
    }
}

/*******************************************************************************
**
** Prototype: void  BGCheckADCOverflow_VR9(void)
**
**  This background function checks the ADC overlow  interrupt bit and clears it
**
**   Input Arguments:
**
**   Output Arguments:
**
**   Returns:
**
**   Global Variables:
**       gft_ADCOverflowed -- Indication whether ADC overflowed.
**
*******************************************************************************/
void CheckADCOverflow_ADSL_VR9(void)
{
    uint16 s_reg;
    gft_ADCOverflowed = 0;
    s_reg = FGLB_FILT_STAT_RX_CMB1_OVL_AFE_GET;
    s_reg =  s_reg >>8;
    gft_ADCOverflowed      =  s_reg &(0x8B); // mask for Rx Overflow status
}

#ifdef ADSL_62

// Feature_DS_BisPlus_ALL_VR9QLNCalib (Start)
/*******************************************************************************
**
** Prototype: void  ProgHyb_QlnHlog(void)
**
**  This function overwrites the hybrid parameters for Hlog/Qln/PCB computations
**
**   Input Arguments:
**
**   Output Arguments:
**
**   Returns:
**
**   Global Variables:
**       None
**
*******************************************************************************/
void ProgHyb_QlnHlog(void)
{
    // Taking a backup of the hybrid parameters
    gus_AGC1_RIN1 = AGC1_RIN1_AFE_GET;
    gus_AGC1_RIN2 = AGC1_RIN2_AFE_GET;
    gus_AGC1_RINX = AGC1_RINX_AFE_GET;
    gus_AGC1_SHUNT1 = AGC1_SHUNT1_AFE_GET;
    gus_AGC1_SHUNT2 = AGC1_SHUNT2_AFE_GET;
    gus_AGC1_SHUNTX = AGC1_SHUNTX_AFE_GET;
    gus_AGC1_CPROG = AGC1_CPROG_AFE_GET;
    gus_AGC2_LP2_CAP = AGC2_FEEDB_AGC2_PRG_CFB_AFE_GET;
#ifdef ISDN    // Annex-B
    // QLN, Hlog/Hlin calibration Hybrid values received from Tina (27th April'10)
    // For BJ Hybrid v1.0 ADSL Annex B
    // RLa=180  RQa=1e10  RLb=720  RQb=17280  CQb_int=1e-100 RLc=1e10 RQc=360 CQc_int=1e-100
    AGC1_RIN1_AFE_SET(0xFFFF);
    AGC1_RIN2_AFE_SET(0x000F);
    AGC1_RINX_AFE_SET(0x0000);
    AGC1_SHUNT1_AFE_SET(0x0000);
    AGC1_SHUNT2_AFE_SET(0x1000);
    AGC1_SHUNTX_AFE_SET(0x80FF); // Bit 15 needs to be set, but the Matlab doesn't set this bit ???
    AGC1_CPROG_AFE_SET(0x0000);
#else    // Annex-A
    // Currently Annex-A hybrids are the default ones.
    // Need to get the correct settings for Hlog/Qln/PCB computations from Villach
    AGC1_RIN1_AFE_SET(0x03FF);     //RIN = 360Ohm (default)
    AGC1_RIN2_AFE_SET(0x0000);     //RIN = 360Ohm (default)
    AGC1_RINX_AFE_SET(0x000F);     //RIN = 360Ohm (default)
    AGC1_SHUNT1_AFE_SET(0x0100);   //RSHUNT Input A= OPEN (default)
    AGC1_SHUNT2_AFE_SET(0x80FF);   //RSHUNT Input B= OPEN (default)
    AGC1_SHUNTX_AFE_SET(0x0000);   //RSHUNT Input C= OPEN (default)
    //AGC1_PRG_CFB is set to Min capacitor value to avoid using LP1. LP1 attenuates high freq bins
    //beyond bin no 150 onwards(Plus mode). This is observed while doing QLN calibration. i.e
    //Rx Inverse Filter compensation.
    AGC1_CPROG_AFE_SET(0x0000);    //AGC1_PRG_CFB is to (0x00) (6:0) min capacitor
    //Keep LP2 cap to open while doing QLN & Hlog measurement;
    AGC2_FEEDB_AGC2_PRG_CFB_AFE_SET(AGC2_PRG_CFB_AGC2_LP2_CAP_OPEN);
#endif      // ifdef ISDN
    guc_BkgdTaskState = BKGDTASK_DONE;
    return;
}
/*******************************************************************************
**
** Prototype: void  RestoreHyb_QlnHlog(void)
**
**  This function restores the hybrid parameters after Hlog/Qln/PCB computations
**
**   Input Arguments:
**
**   Output Arguments:
**
**   Returns:
**
**   Global Variables:
**       None
**
*******************************************************************************/
void RestoreHyb_QlnHlog(void)
{
    // Restore back the hybrid values
    AGC1_RIN1_AFE_SET(gus_AGC1_RIN1);
    AGC1_RIN2_AFE_SET(gus_AGC1_RIN2);
    AGC1_RINX_AFE_SET(gus_AGC1_RINX);
    AGC1_SHUNT1_AFE_SET(gus_AGC1_SHUNT1);
    AGC1_SHUNT2_AFE_SET(gus_AGC1_SHUNT2);
    AGC1_SHUNTX_AFE_SET(gus_AGC1_SHUNTX);
    AGC1_CPROG_AFE_SET(gus_AGC1_CPROG);
#ifndef  ISDN
    //AnxA
    AGC2_FEEDB_AGC2_PRG_CFB_AFE_SET(gus_AGC2_LP2_CAP);
#endif
    guc_BkgdTaskState = BKGDTASK_DONE;
    return;
}

// Feature_DS_BisPlus_ALL_VR9QLNCalib (End)
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
/*******************************************************************************
**
** Prototype: void  POFIPOCO_PowerDown(void)
**
**  This function power down the POFIPOCO
**
**   Input Arguments:
**
**   Output Arguments:
**
**   Returns:
**
**   Global Variables:
**       None
**
*******************************************************************************/
void POFIPOCO_PowerDown(void)
{
   POFIPOCO_GAIN_POFIPOCO_PD_AFE_SET(POFIPOCO_PD_POFIPOCO_PD);
}

/*******************************************************************************
**
** Prototype: void  POFIPOCO_PowerUp(void)
**
**  This function power up the POFIPOCO
**
**   Input Arguments:
**
**   Output Arguments:
**
**   Returns:
**
**   Global Variables:
**       None
**
*******************************************************************************/
void POFIPOCO_PowerUp(void)
{
   POFIPOCO_GAIN_POFIPOCO_PD_AFE_SET(POFIPOCO_PD_POFIPOCO_PU);
}
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)

#endif
