/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//*******************************************************************
// VR9_AfeHybr.c
//
// History
//
// 29/11/2010 Palaksha/Bhadra: Added Framework to integrate hybrid training
//            modules to "SLEEP" state codeswap page.
//            Grep for "XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo"
//
// ******************************************************************

//*****************************************************************************

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "typedef.h"
#include "AfeRdWrite.h"
#include "hndshk_Data.h"
#include "vr9_afe_analog_reg.h"
#include "VR9_Afedata.h"
#include "VR9_AfeFunc.h"
#include "gdata.h"
#include "VRX_AfeCommonData.h"
//#include "afe_data.h"

/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/

/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/
extern void SetPGA();
void PgmHybrGain(void);
/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void LoadHybridHPFAndPGA_VR9(void)
{
   unsigned short *pHybRegSetting;
   int16 s_HybGainIndex;

   pHybRegSetting = gusa_InitHybridSettings + (gs_LoadHybIndex * VR9_HYB_NUM_AFE_REGS);
   //Program VR9 AFE Line Adapdation Registers, i.e Hybrid Registers
   AGC1_RIN1_AFE_SET(*pHybRegSetting++);
   AGC1_RIN2_AFE_SET(*pHybRegSetting++);
   AGC1_RINX_AFE_SET(*pHybRegSetting++);
   AGC1_SHUNT1_AFE_SET(*pHybRegSetting++);
   AGC1_SHUNT2_AFE_SET(*pHybRegSetting++);
   AGC1_SHUNTX_AGC1_PRG_RSHUNTX_AFE_SET(*pHybRegSetting++);
   AGC1_CPROG_AFE_SET(*pHybRegSetting);

   if (gs_LoadAllPGAGains == 0)
   {
      // Do these initializations during PGA training.
      if (gs_PgaHandlerRun ==0)
         InitAFE_RegsPGA_ADSL_VR9(); //Init for PGA1 training
      else if (gs_PgaHandlerRun ==1)
      {
         //Program AGC1 Gain for PGA2 Training
         s_HybGainIndex = (gs_LoadHybIndex * VR9_HYB_AFE_REG_GAINS);
         guc_gain1_idx = gsa_HybGain[s_HybGainIndex + GAIN1_IDX_OFFSET];
         gus_AGC1_Rout = gsa_HybGain[s_HybGainIndex + AGC1_ROUT_OFFSET];
         gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
         gs_PgaHandlerRun = 0; //Changed to "0" to program AGC1 gain Regs
         SetPGA(); //SetPGA() is called directly since PgmHybrGain() was called in TC task.
         gs_PgaHandlerRun = 1; //Restore back
         //Enable HPF
         RestoreAFE_RegsAGC2_ADSL_VR9();
      }
   }
   //Load AFE gains which was computed earlier
   if (gs_LoadAllPGAGains == 1)
      PgmHybrGain();

//   guc_PgaState = TRAINING_DONE;
}
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void PgmHybrGain(void)
{
      int16 s_HybGainIndex = (gs_LoadHybIndex * VR9_HYB_AFE_REG_GAINS);

      gs_PGA_required = gsa_HybGain[s_HybGainIndex + PGA_REQ_OFFSET]; //gs_PGA_required offset 1
      gs_PGA_set = gsa_HybGain[s_HybGainIndex + PGA_SET_OFFSET];      //gs_PGA_set offset 2
      guc_gain1_idx = gsa_HybGain[s_HybGainIndex + GAIN1_IDX_OFFSET];   //gain1 index offset 3
      guc_gain2_idx = gsa_HybGain[s_HybGainIndex + GAIN2_IDX_OFFSET];   //gain2 index offset 4
      gus_AGC1_Rout = gsa_HybGain[s_HybGainIndex + AGC1_ROUT_OFFSET];   //AGC1 Rout offset 5
      gus_AGC2_Fixed = gsa_HybGain[s_HybGainIndex + AGC2_FIXED_GAIN_OFFSET];  //AGC2 Fixed gain offset 6
      gus_AGC3_set = gsa_HybGain[s_HybGainIndex + AGC3_GAIN_OFFSET];    //AGC3 gain offset 7
      guc_agc2_cmiller = gsa_HybGain[s_HybGainIndex + AGC2_MILLERCAP_OFFSET];  //AGC2 Miller Cap offset 8
      gs_AGC1_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC1_GAIN_SET_OFFSET];
      gs_AGC2_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC2_GAIN_SET_OFFSET];
      gs_AGC2_Fixed_Gain = gsa_HybGain[s_HybGainIndex + AGC2_FIXED_GAIN_SET_OFFSET];
      gs_AGC3_Gain_Set = gsa_HybGain[s_HybGainIndex + AGC3_GAIN_SET_OFFSET];
      //Disabled here to write the all AFE gain registers once using SetPGA() and
      //Reenable the flag after SetPGA.
      gft_EnableDoublePGATrain = FALSE;
      SetPGA(); //SetPGA() is called directly since PgmHybrGain() was called in TC task.
      gft_EnableDoublePGATrain = TRUE;
}

/*******************************************************************************
*
*   Prototype: void UpdateHybridBuffer_VR9(void)
*
*  This function shall make use of the global variable: gs_HybIndex and
*  global pointer to Hybrid array gusa_InitHybridSettings to update the hybrid
*  buffer with the special Hybrid settings to provide -6dB gain as input to the AGC1.
*  The initialization of the Hybrid pointer based on appropriate mode and profile
*  has been considered to be handled outside this function and in function
*  ConfigTaskLayerForPostGhs(void) above.
*
*  Input Arguments:
*  Global Variables:
*  Pointer to hybrid 2D array: gusa_InitHybridSettings[I]
*  Hybrid array index corresponding to the row: gs_HybIndex
*
*
*   Output Arguments:
*
*   Returns:
*
*******************************************************************************/
//XDSLRTFW-364: Feature_DS_All_All_NLNF_FilterDetect Integrate_HybridPGA_Algo (Start_End)
C_SCOPE void UpdateHybridBuffer_VR9(void)
{
   unsigned short *pHybRegSetting;
   uint32 i;
   pHybRegSetting = gusa_InitHybridSettings + (gs_HybIndex * VR9_HYB_NUM_AFE_REGS);
   for (i = 0; i < VR9_HYB_NUM_AFE_REGS; i++)
   {
      pHybRegSetting[i] = gusa_SpecialHybSetting[i];
   }
}
