/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// VR9_Afedata.c
//
// History
//
// 29/09/2010 Nihar: Prevent VDSL FW to start if AFE register is fused to a defined value.
//                          This is a way to use the VR9 as AR10 till the time AR10 is officially available.
//                      Grep for XDSLRTFW-178
//
// 22/03/2011 Vinjam: Added "ARX208" support through DSL CMV.
//            Grep for XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV
//
// 24/06/2011 Kannan: CSA#4 Loop Hybrid Index is considered as straight, since it gave
//                    the hybrid metric as close to straight loop hybrid index.
//                    If a particular Hybrid input path is open, then make the corresponding
//                   shunt register to 0x80FF
//                    Grep for XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA
//
// 15/01/2013 Kannan: variable defintion for AFE init fail indication
//                    Grep for XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication
//
// 16/05/2013 Kannan: Moved the variables of adc trimming from  adcTrimming.c to
//                    the code swap page declared here under
//                    "DATA_XILVB_B4_SHOW_INIT_BEGIN"
//                    Grep for "XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException"
//
// 13/03/2014 Sriram Shastry : Increase US data rate against  BRCM CO for A.1.4.3 24 HDSL NEXT impairment_testprofile AU_RA_L_30000K
//              Grep for XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/
#include "common.h"
#include "data_alloc.h"
#include "VR9_Afe_typedef.h"
#include "VR9_Afe_const.h"
#include "vr9_afe_analog_reg.h"
//XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (START)
#include "vr9_afe_dig_filt_ch0_reg.h"
#include "vr9_afe_dig_global_reg.h"
#include "vr9_afe_dig_ch0_reg.h"
//XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (END)

/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL TYPES
** =============================================================================
*/


/*
** =============================================================================
**                           LOCAL DATA
** =============================================================================
*/
DATA_XILVB_B4_SHOW_INIT_BEGIN
//XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (START)
        adc_trim_t gt_adc_trim; //SMS00972960
        uint16 gusa_AfeAdcTrimRegsAddr[]={
           FGLB_CTRL1,
           PLL_CTL3,
           ADC_CTL,
           ADC_CTL,
           ADC_CTL,
           ADC_LNDEC_STG1,   //initialize ADC, force reset ADC
           ADC_LNDEC_STG1,   //release reset ADC
           ADC_BIAS,
           ADC_CLK_STG1,
           ADC_CLK_STG2,
           ADC_LNDEC_STG1,
           ADC_LNDEC_STG2,
           ADC_DACS_STG1,
           ADC_DACS_STG2,
           ADC_OVLD,
           ADC_COMP_STG12,   //set trimming range for ADC's
           ADC_DACCAL_1,     //configure ADC for trimming
           ADC_DACCAL_2,
           ADC_LOOPF_MISC,
           ADC_LOOPF1_1,
           ADC_LOOPF1_2,
           ADC_LOOPF2_1,
           ADC_LOOPF2_2,
           FGLB_CTRL2
        };

        uint16 gusa_AfeAdcTrimRegs_VDSL30[]={
           0x0015,        //set ADC clock frequency to 576MHz
           0x0006,        //DAC1 and DAC2 PLL clock output DISABLED
           0x0000,        //reset ADC digital data interface
           0x0001,        //release this reset
           0x0041,        //enable the ADC digital data interface clock
           0x0000,        //force reset ADC
           0x0100,        //release reset ADC
           0xAAFF,
           0x0000,
           0x0000,
           0x0180,
           0x0080,
           0x0020,
           0xA020,
           0x0700,
           0x0343,        //
           0xA87F,        //configure ADC for trimming; adc_pd_caldig1=1, adc_cal_21=1, adc_dac_xtra_LSB_21=1
           0xA87F,        //adc_dac_ext_data=1, adc_cal_22=1, adc_dac_xtra_LSB_22=1
           0x800A,        //adc_pd_oa11=adc_pd_oa12=1
           0x4080,        //input of INTE11 to vcm
           0x0506,        //I/P of INTE21 to vcm, INTE21 in buf mode, INTE21 to 5 (avoid peaking in transfer function)
           0x4088,        //input of INTE12 to vcm
           0x0582,        //I/P of INTE22 to vcm, INTE22 in buf mode, INTE22 to 5 (avoid peaking in transfer function)
           0x0004         //enable RX-path
        };

        uint16 gusa_AfeAdcTrimRegs_VDSL17_12[]={
           0x0005,        //set ADC clock frequency to 288MHz
           0x0006,        //DAC1 and DAC2 PLL clock output DISABLED
           0x0000,        //reset ADC digital data interface
           0x0001,        //release this reset
           0x0041,        //enable the ADC digital data interface clock
           0x0000,        //force reset ADC
           0x0100,        //release reset ADC
           0xAAFF,
           0x0000,
           0x0000,
           0x0180,
           0x0080,
           0x0020,
           0xA020,
           0x0700,
           0x0343,        //
           0xA87F,        //configure ADC for trimming; adc_pd_caldig1=1, adc_cal_21=1, adc_dac_xtra_LSB_21=1
           0xA87F,        //adc_dac_ext_data=1, adc_cal_22=1, adc_dac_xtra_LSB_22=1
           0x800A,        //adc_pd_oa11=adc_pd_oa12=1
           0x4080,        //input of INTE11 to vcm
           0x0506,        //I/P of INTE21 to vcm, INTE21 in buf mode, INTE21 to 5 (avoid peaking in transfer function)
           0x4088,        //input of INTE12 to vcm
           0x0582,        //I/P of INTE22 to vcm, INTE22 in buf mode, INTE22 to 5 (avoid peaking in transfer function)
           0x0004         //enable RX-path
        };

        uint16 gusa_AfeAdcTrimRegs_VDSL05[]={
           0x0005,     //set ADC clock frequency to 288MHz
           0x0006,     //DAC1 and DAC2 PLL clock output DISABLED
           0x0000,     //reset ADC digital data interface
           0x0001,     //release this reset
           0x0041,     //enable the ADC digital data interface clock
           0x0000,     //force reset ADC
           0x0100,     //release reset ADC
           0xAAFF,
           0x0000,
           0x8000,     //clocking STG2 in PowerDown
           0x0180,
           0x0000,     //LNDEC STG2 disabled
           0x0020,
           0xA0A0,     //DACs of STG2 are in PowerDown
           0x0700,
           0x0B43,     //ADC STG2 in Power Down
           0xA87F,     //configure ADC for trimming; adc_pd_caldig1=1, adc_cal_21=1, adc_dac_xtra_LSB_21=1
           0xA87F,     //adc_dac_ext_data=1, adc_cal_22=1, adc_dac_xtra_LSB_22=1
           0x800B,     //adc_pd_oa11=adc_pd_oa12=adc_pd_oa22=1
           0x4080,     //input of INTE11 to vcm
           0x0506,     //I/P of INTE21 to vcm, INTE21 in buf mode, INTE21 to 5 (avoid peaking in transfer function)
           0x4088,     //input of INTE12 to vcm
           0x0582,     //I/P of INTE22 to vcm, INTE22 in buf mode, INTE22 to 5 (avoid peaking in transfer function)
           0x0004      //enable RX-path
        };
//XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (END)

//PGA (AGC1,AGC2 & AGC3 )related variables
// Table for gain of LP1 in AGC1
//refer page 158 of XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
int16 gs_Agc_prg_gain[AGC1_PRG_GAIN_SETTINGS] =
   {
      AGC1_PRG_GAIN_AGC1_GAIN_27DB,
      AGC1_PRG_GAIN_AGC1_GAIN_26DB,
      AGC1_PRG_GAIN_AGC1_GAIN_25DB,
      AGC1_PRG_GAIN_AGC1_GAIN_24DB,
      AGC1_PRG_GAIN_AGC1_GAIN_23DB,
      AGC1_PRG_GAIN_AGC1_GAIN_22DB,
      AGC1_PRG_GAIN_AGC1_GAIN_21DB,
          AGC1_PRG_GAIN_AGC1_GAIN_20DB,
      AGC1_PRG_GAIN_AGC1_GAIN_19DB,
      AGC1_PRG_GAIN_AGC1_GAIN_18DB,
      AGC1_PRG_GAIN_AGC1_GAIN_17DB,
      AGC1_PRG_GAIN_AGC1_GAIN_16DB,
      AGC1_PRG_GAIN_AGC1_GAIN_15DB,
      AGC1_PRG_GAIN_AGC1_GAIN_14DB,
      AGC1_PRG_GAIN_AGC1_GAIN_13DB,
      AGC1_PRG_GAIN_AGC1_GAIN_12DB,
      AGC1_PRG_GAIN_AGC1_GAIN_11DB,
      AGC1_PRG_GAIN_AGC1_GAIN_10DB,
      AGC1_PRG_GAIN_AGC1_GAIN_9DB,
      AGC1_PRG_GAIN_AGC1_GAIN_8DB,
      AGC1_PRG_GAIN_AGC1_GAIN_7DB,
      AGC1_PRG_GAIN_AGC1_GAIN_6DB,
      AGC1_PRG_GAIN_AGC1_GAIN_5DB,
      AGC1_PRG_GAIN_AGC1_GAIN_4DB,
      AGC1_PRG_GAIN_AGC1_GAIN_3DB,
      AGC1_PRG_GAIN_AGC1_GAIN_2DB,
      AGC1_PRG_GAIN_AGC1_GAIN_1DB,
      AGC1_PRG_GAIN_AGC1_GAIN_0DB,
      AGC1_PRG_GAIN_AGC1_GAIN_M3DB,
      AGC1_PRG_GAIN_AGC1_GAIN_M6DB //-6dB  //As Per V1.1 Spec
   };

#ifdef ISDN
//Hybrid settings for different profiles
uint16 gusa_HybridSetting_ADSL_B[VR9_NUM_ADAP_HYB_SETTINGS][VR9_HYB_NUM_AFE_REGS]=
{
        //Order of the 7 AFE registers in the array below:
   //AGC1_RIN1,AGC1_RIN2,AGC1_RINX,AGC1_SHUNT1,AGC1_SHUNT2,AGC1_SHUNTX,AGC1_CPROG,
      //For QLN,Hlog,Hlin calculation you should use the following setting,
      //which is equal to the first of the training settings below:
                {0x7FFF,0x0007,0x0000,0x0000,0x0400,0x80FF, 0x0001}, //BJ Index 0 (default)
#if 1
      //At present default hyb settings is enabled for AnxB.
      //Other hyb settings may enabled if required, on straight loop we didn't
      //see much performance improvement as compared to default one.
                {0xFFFF,0x000F,0x0000,0x0000,0x1000,0x80FF, 0x0001}, //BJ Index 1
                {0xFFFF,0x000F,0x0000,0x0000,0x1000,0x80FF, 0x0101}, //BJ Index 2
      {0xFFFF,0x000F,0x0000,0x0000,0x1000,0x80FF, 0x0201}, //BJ Index 3
      {0xFFFF,0x0007,0x0000,0x0000,0x0000,0x80FF, 0x0201}, //BJ Index 4
      {0xFFFF,0x0007,0x0000,0x0000,0x0000,0x80FF, 0x0301}, //BJ Index 5
      {0xFFFF,0x0007,0x0000,0x0000,0x0000,0x80FF, 0x0401}, //BJ Index 6
      {0xFFFF,0x000F,0x0000,0x0000,0x0100,0x80FF, 0x0201}, //BJ Index 7
      {0xFFFF,0x000F,0x0000,0x0000,0x0100,0x80FF, 0x0301}, //BJ Index 8
      {0xFFFF,0x000F,0x0000,0x0000,0x0100,0x80FF, 0x0401}, //BJ Index 9
      {0xFFFF,0x3FFF,0x0000,0x0400,0x00F0,0x80FF, 0x0201}, //BJ Index 10
      {0xFFFF,0x3FFF,0x0000,0x0400,0x00F0,0x80FF, 0x0301}, //BJ Index 11
      {0xFFFF,0x3FFF,0x0000,0x0400,0x00F0,0x80FF, 0x0401}, //BJ Index 12
      {0xFFFF,0x003F,0x0000,0x0000,0x0200,0x80FF, 0x0C01}, //ADSL 3km BJ-Hybrid V1.0:  BJ Index 13
      {0x7FFF,0x00FF,0x0000,0x0000,0x0080,0x80FF, 0x0801}, //ADSL 1km BJ-Hybrid V1.0: BJ Index 14
      {0xFFFF,0x003F,0x0000,0x0400,0x2000,0x80FF, 0x0F01} //ADSL 3km BJ-Hybrid V1.0 no splitter: BJ Index 15
#endif
};
#else
//AnxA
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (START)
uint16 gusa_HybridSetting_ADSL_A[VR9_NUM_ADAP_HYB_SETTINGS][VR9_HYB_NUM_AFE_REGS]=
{
      //{AGC1_RIN1,AGC1_RIN2,AGC1_RINX,AGC1_SHUNT1,AGC1_SHUNT2,AGC1_SHUNTX,AGC1_CPROG}
      {0x03FF, 0x0000, 0x000F, 0x0100, 0x80FF, 0x0000, 0x0042},  //A Index 0, 17.5 Kft, BT 0
      {0x01FF, 0x0000, 0x000F, 0x0000, 0x80FF, 0x0000, 0x0042},  //A Index 1, CSA#4             => let's declare this also as a straight loop setting until further investigation
      {0xFFFF, 0x000F, 0x000F, 0x2000, 0x0100, 0x0000, 0x0042},  //A Index 2, 12 Kft, BT 150
      {0xFFFF, 0x0003, 0x001F, 0x0000, 0x2000, 0x0000, 0x0042},  //A Index 3, 7 Kft, BT 200
      {0x7FFF, 0x0007, 0x000F, 0x0800, 0x1000, 0x0000, 0x0042},  //A Index 4, 9 Kft, BT 200
      {0xFFFF, 0x000F, 0x000F, 0x0200, 0x0200, 0x0000, 0x0042},  //A Index 5, 15 Kft, BT 200
      {0xFFFF, 0x001F, 0x000F, 0x2000, 0x0000, 0x0000, 0x0042},  //A Index 6, 12 Kft, BT 250
      {0x7FFF, 0x003F, 0x000F, 0x0800, 0x0000, 0x0000, 0x0042},  //A Index 7, 15 Kft, BT 300
      {0x7FFF, 0x007F, 0x000F, 0x2000, 0x0000, 0x0000, 0x0042},  //A Index 8, 17.5 Kft, BT 300
      {0xFFFF, 0x0007, 0x003F, 0x0000, 0x0000, 0x0000, 0x0042},  //A Index 9, 12 Kft, BT 350_new
      {0xFFFF, 0x001F, 0x001F, 0x2000, 0x0000, 0x0000, 0x0042},  //A Index 10, 15 Kft, BT 400
      {0x7FFF, 0x000F, 0x001F, 0x0000, 0x0000, 0x0000, 0x0042},  //A Index 11, 17.5 Kft, BT 400
      {0xFFFF, 0x0001, 0x07FF, 0x0000, 0x2000, 0x0000, 0x0042},  //A Index 12, 12 Kft, BT 500
      {0xFFFF, 0x0007, 0x01FF, 0x0100, 0x1000, 0x2000, 0x0042},  //A Index 13, 17.5 Kft, BT 500
      {0x001F, 0x0000, 0x3FFF, 0x1000, 0x80FF, 0x00F8, 0x0042},  //A Index 14, 15 Kft, BT 600
      {0x7FFF, 0x0003, 0x7FFF, 0x1000, 0x0800, 0x0200, 0x0042},  //A Index 15, 17.5 Kft, BT 600
      {0x1FFF, 0x0001, 0xFFFF, 0x0000, 0x2000, 0x1000, 0x0042},  //A Index 16, 15 Kft, BT 700
      {0x00FF, 0x0000, 0xFFFF, 0x0200, 0x80FF, 0x0000, 0x0042},  //A Index 17, 15 Kft, BT 800
      {0x007F, 0x0000, 0x3FFF, 0x0000, 0x80FF, 0x1000, 0x0042},  //A Index 18, 17.5 Kft, BT 800
      {0x007F, 0x0000, 0x3FFF, 0x0800, 0x80FF, 0x0000, 0x0042},  //A Index 19, 15 Kft, BT 900
      {0x003F, 0x0000, 0x01FF, 0x0200, 0x80FF, 0x1000, 0x0042},  //A Index 20, 17.5 Kft, BT 1000
      {0x000F, 0x0000, 0x000F, 0x1000, 0x80FF, 0x0000, 0x0042},  //A Index 21, 15 Kft, BT 1250
      {0x001F, 0x0000, 0x001F, 0x0400, 0x80FF, 0x0000, 0x0042},  //A Index 22, 17.5 Kft, BT 1250
      {0x007F, 0x0000, 0x000F, 0x00F0, 0x80FF, 0x1000, 0x0042},  //A Index 23, 17.5 Kft, BT 1500  => to be clarified with Kai/Tina: Why is the performance so low ???
      {0x3FFF, 0x0000, 0x000F, 0x00F8, 0x80FF, 0x0000, 0x0042},  //A Index 24, ANSI #13
      {0x3FFF, 0x0000, 0x000F, 0x00F8, 0x80FF, 0x0000, 0x0042},  //A Index 25, ANSI #13   //Repeat
      {0x3FFF, 0x0000, 0x000F, 0x00F8, 0x80FF, 0x0000, 0x0042},  //A Index 26, ANSI #13   //Repeat
      {0x3FFF, 0x0000, 0x000F, 0x00F8, 0x80FF, 0x0000, 0x0042}  //A Index 27, ANSI #13    //Repeat
};
//XDSLRTFW-253 PERF_DS_PlusBisDmt_ALL_BT_Loops_NMSA (END)

#endif //#ifdef ISDN

#ifndef ADSL_62
DATA_MAP_END
#endif
FlagT gft_ADCOverflowed = FALSE;
uint8 guc_agc2_cmiller = AGC2_PRG_CMILLER_AGC2_OP_CMILLER_0dB; //AGC2 Miller Capacitor at AGC2_MISC default
int16  gs_AGC2_Fixed_Gain = 0; //AGC2 Fixed gain
int16 gs_PGA1_set = 0; // AGC1 gain
int16 gs_PgaHandlerRun = 0;
int16 gs_PGA_Handler_count = 0;
int16 gs_AGC1_Margin = 0;
int16 gs_ADC_margin = 0;

uint16 *gusa_InitHybridSettings;

//XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start_End)
uint16 gusa_AfeChipId[2];

uint16 gus_BandGapTrimming = 0;
uint16 gusa_HybMetric[VR9_NUM_ADAP_HYB_SETTINGS];
int16 gsa_HybGain[VR9_NUM_ADAP_HYB_SETTINGS*VR9_HYB_AFE_REG_GAINS];
int16 gs_LoadAllPGAGains = 0;
int32 gla_HybRevRefPwr[VR9_NUM_ADAP_HYB_SETTINGS];
//int16 gsa_SignalPSD[(HYB_DECIM_POINTS+1)*VR9_NUM_ADAP_HYB_SETTINGS];
int32 gla_BgHybAccumBuf[2*(HYB_DECIM_FACTOR * HYB_DECIM_POINTS + 1)];
//XDSLRTFW-1727
#ifdef ISDN
uint16 gusa_RxL2CombinGains[512];
#endif
#ifdef ADSL_62
DATA_MAP_END
#endif



/*
** =============================================================================
**                           LOCAL FUNCTION PROTOTYPES
** =============================================================================
*/

/*
** =============================================================================
**                           IMPLEMENTATION
** =============================================================================
*/
