/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C) 2005 - Infineon Technologies
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/***C***************************************************************************
** The 'CCASE' lines will be filled by ClearCase upon checkin,
** please do not change this information manually!
**
** =============================================================================
**
** All rights reserved.
** =============================================================================
**
** =============================================================================
**
** This document contains proprietary information belonging to Infineon
** Technologies. Passing on and copying of this document, and communication of
** its contents is not permitted without prior written authorisation.
**
** =============================================================================
**
**
** =============================================================================
**
** Revision Information :
**
** CCASE_FILE = "VersionInfo.c"
** CCASE_DATE = "Wed Aug  3 16:16:17 2005"
**
** =============================================================================
**
** Contents:   Inside this file the VersionInfo is implemented.
**
** Functions:  GetVersionInfo()
**             - This function gets all informations about the Hardware-, ROM-
**               and Firmware Version.
**
**             SetSystemVendorID()
**          -   Set the SystemVendorID which represents the manufacturer of
**              the xDSL-Board.
**
**             FillSystemVendorID()
**          - Fill the array of the SystemVendorID.
**
** =============================================================================
**
** References: <List of related design documents>
**
** =============================================================================
** History:
**
** Date        Author        Comment
** 2005-05-03  Wehmann       Creation
** 2009        Tung Le       ported from IFX source to VR9
** =============================================================================
**
Additional version control information
********************************************************************************
 CCASE_USER    = "wehmann"
 CCASE_VERSION = "\main\9"
*******************************************************************************/

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include "common.h"
#include "typedef.h"
#include "Cust_CmvDefinitions.h"
#include "VersionInfo.h"
#include "eoc.h"
#include "gdata.h"
#include "version.c"
/*
** =============================================================================
**                           LOCAL DEFINITIONS
** =============================================================================
*/

/* PayLoadSize for filled response message */
#define PAYLOAD_SIZE_VERSION_INFO    6
#define PAYLOAD_SIZE_SYS_VENDOR_ID   6
#define RESERVED_VALUE               0x0000

   /*
   ** =============================================================================
   **                           LOCAL DATA
   ** =============================================================================
   */


   /*
   ** =============================================================================
   **                           GLOBAL DATA
   ** =============================================================================
   */

   /*
   ** =============================================================================
   **                           LOCAL FUNCTION PROTOTYPES
   ** =============================================================================
   */

   /*
   ** =============================================================================
   **                           IMPLEMENTATION
   ** =============================================================================
   */
   /*
   ** =============================================================================
   ** FUNCTION-DESCRIPTION
   **
   ** FUNCTION-NAME:  GetVersionInfo()
   **
   ** DESCRIPTION:    This function gets version information about the Hardware-, ROM-
   **                 and Firmware Version.
   **
   ** PARAMETERS:     *us_PayLoadSize (uint16 / unsigned short)
   **                 - Payload size in actual message.
   **
   **                 uc_Length (uint8 / unsigned char)
   **                 - uc_Length parameter from header.
   **
   **                 Payload[] (uint16 / unsigned short)
   **                 - Array with the payload elements.
   **
   ** RETURN VALUE:   uc_MsgExecuted (uint8 / unsigned char)
   **                 - Value for function code creation.
   **
   ** NOTES:          OK!
   ** =============================================================================
   */
   uint8 GetVersionInfo(uint16 *us_PayLoadSize, uint8 uc_Length, uint16 PayLoad[]){

      uint32 ul_TempValue;
      uint8  uc_MsgExecuted = CMV_WITHOUT_ERRORS;

      /*
      ** Is length parameter correct
      */
      if(uc_Length == (PAYLOAD_SIZE_VERSION_INFO >> 1)){

         /*
         ** Hardware Version Number
         ** (Get info from DFE register)
         */
         PayLoad[1] = RESERVED_VALUE;
//    This field has to be updated with the VR9 hardware version information.
//        Loading it with the reserved value for the time being.
         PayLoad[0] = RESERVED_VALUE;
//       PayLoad[0] = (PLL_CHIPCFG_RegRead() & CHIPCFG_HW_VER_MASK) >> 16;

         /*
         ** ROM Code Version Number
         ** (Get info from header file)
         */
         PayLoad[3] = (VER_ROM_PRODUCT << 8) | VER_ROM_FEATURE;
         PayLoad[2] = (VER_ROM_MAINTENANCE << 8) | VER_ROM_DEBUG;

         /*
         ** Firmware Version Number
         ** (Get info from header file)
         */
         ul_TempValue = VERSION_MAJOR << 8;
         ul_TempValue = (ul_TempValue | VERSION_MINOR) << 4;
         ul_TempValue = (ul_TempValue | SUBVERSION_OF_A_VERSION_MINOR) << 4;
         ul_TempValue = (ul_TempValue | INTERNALVERSIONS) << 2;
         ul_TempValue = (ul_TempValue | RELEASE_STATE_OF_FW) << 6;
         ul_TempValue |= FIRMWARE_MODE;

         PayLoad[4] = ul_TempValue;
         PayLoad[5] = ul_TempValue >> 16;

         /* Change PayLoadSize for resonse message */
         *us_PayLoadSize = PAYLOAD_SIZE_VERSION_INFO;
      }
      else{
         uc_MsgExecuted = CMV_WRONG_PARAMETER;
      }

      return uc_MsgExecuted;
   }



