/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _FILTERTUNE_H
#define _FILTERTUNE_H

//***************************************************************************
// Tuning Constants for POFIPOCO for ADSL mode
// Refer page:91 of  XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
//***************************************************************************
#define  POFI_POCO_ADSL_80K                  (1)
#define  NFIX_ADSL_80K        (55)
#define  NUSER_ADSL_80K       (24)
#define  CGAIN_ADSL_80K       (0)
#define  COFFSET_ADSL_80K     (0)
#define  CNTNOM_ADSL_80K      (479)
#define  CNTNOM_PLUS_CGAIN_ADSL_80K (CNTNOM_ADSL_80K + CGAIN_ADSL_80K)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_80K
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADSL_80K is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADSL_80K   0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_80K

#define  POFI_POCO_ADSL_160K                 (2)
#define  NFIX_ADSL_160K       (55)
#define  NUSER_ADSL_160K      (24)
#define  CGAIN_ADSL_160K      (0)
#define  COFFSET_ADSL_160K    (0)
#define  CNTNOM_ADSL_160K     (479)
#define  CNTNOM_PLUS_CGAIN_ADSL_160K (CNTNOM_ADSL_160K + CGAIN_ADSL_160K)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_160K
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADSL_160K is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADSL_160K 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_160K

#define  POFI_POCO_ADSL_320K                 (3)
#define  NFIX_ADSL_320K       (55)
#define  NUSER_ADSL_320K      (24)
#define  CGAIN_ADSL_320K      (0)
#define  COFFSET_ADSL_320K    (0)
#define  CNTNOM_ADSL_320K     (479)
#define  CNTNOM_PLUS_CGAIN_ADSL_320K (CNTNOM_ADSL_320K + CGAIN_ADSL_320K)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_320K
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADSL_320K is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADSL_320K  0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_320K

#define  POFI_POCO_ADSL_640K                 (4)
#define  NFIX_ADSL_640K       (55)
#define  NUSER_ADSL_640K      (24)
#define  CGAIN_ADSL_640K      (0)
#define  COFFSET_ADSL_640K    (0)
#define  CNTNOM_ADSL_640K     (479)
#define  CNTNOM_PLUS_CGAIN_ADSL_640K (CNTNOM_ADSL_640K + CGAIN_ADSL_640K)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_640K
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADSL_640K is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADSL_640K  0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_640K

#define  POFI_POCO_ADSL_1280K                (5)
#define  NFIX_ADSL_1280K      (55)
#define  NUSER_ADSL_1280K     (24)
#define  CGAIN_ADSL_1280K     (0)
#define  COFFSET_ADSL_1280K   (0)
#define  CNTNOM_ADSL_1280K    (479)
#define  CNTNOM_PLUS_CGAIN_ADSL_1280K (CNTNOM_ADSL_1280K + CGAIN_ADSL_1280K)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_1280K
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADSL_1280K is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADSL_1280K 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_1280K

#define  POFI_POCO_ADSL_2560K                (6)
#define  NFIX_ADSL_2560K      (55)
#define  NUSER_ADSL_2560K     (24)
#define  CGAIN_ADSL_2560K     (0)
#define  COFFSET_ADSL_2560K   (0)
#define  CNTNOM_ADSL_2560K    (479)
#define  CNTNOM_PLUS_CGAIN_ADSL_2560K (CNTNOM_ADSL_2560K + CGAIN_ADSL_2560K)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_2560K
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADSL_2560K is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADSL_2560K 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADSL_2560K

//***************************************************************************
// Tuning Constants for POFIPOCO for VDSL mode
// Refer page:91 of  XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
//***************************************************************************

#define  POFI_POCO_VDSL_5M                   (7)
#define  NFIX_VDSL_5M         (65)
#define  NUSER_VDSL_5M        (28)
#define  CGAIN_VDSL_5M        (0)
#define  COFFSET_VDSL_5M      (0)
#define  CNTNOM_VDSL_5M       (479)
#define  CNTNOM_PLUS_CGAIN_VDSL_5M (CNTNOM_VDSL_5M + CGAIN_VDSL_5M)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_5M
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_VDSL_5M is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_VDSL_5M 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_5M

#define  POFI_POCO_VDSL_10M                  (8)
#define  NFIX_VDSL_10M        (65)
#define  NUSER_VDSL_10M       (28)
#define  CGAIN_VDSL_10M       (0)
#define  COFFSET_VDSL_10M     (0)
#define  CNTNOM_VDSL_10M      (479)
#define  CNTNOM_PLUS_CGAIN_VDSL_10M (CNTNOM_VDSL_10M + CGAIN_VDSL_10M)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_10M
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_VDSL_10M is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_VDSL_10M 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_10M

#define  POFI_POCO_VDSL_20M                  (9)
#define  NFIX_VDSL_20M        (65)
#define  NUSER_VDSL_20M       (28)
#define  CGAIN_VDSL_20M       (0)
#define  COFFSET_VDSL_20M     (0)
#define  CNTNOM_VDSL_20M      (479)
#define  CNTNOM_PLUS_CGAIN_VDSL_20M (CNTNOM_VDSL_20M + CGAIN_VDSL_20M)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_20M
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_VDSL_20M is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_VDSL_20M 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_20M

#define  POFI_POCO_VDSL_33M                  (10)
#define  NFIX_VDSL_33M        (65)
#define  NUSER_VDSL_33M       (28)
#define  CGAIN_VDSL_33M       (0)
#define  COFFSET_VDSL_33M     (0)
#define  CNTNOM_VDSL_33M      (479)
#define  CNTNOM_PLUS_CGAIN_VDSL_33M (CNTNOM_VDSL_33M + CGAIN_VDSL_33M)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_33M
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_VDSL_33M is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_VDSL_33M 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_33M

#define  POFI_POCO_VDSL_40M                  (11)
#define  NFIX_VDSL_40M        (65)
#define  NUSER_VDSL_40M       (28)
#define  CGAIN_VDSL_40M       (0)
#define  COFFSET_VDSL_40M     (0)
#define  CNTNOM_VDSL_40M      (479)
#define  CNTNOM_PLUS_CGAIN_VDSL_40M (CNTNOM_VDSL_40M + CGAIN_VDSL_40M)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_40M
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_VDSL_40M is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_VDSL_40M 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_VDSL_40M

//*****************************************************************************
// Tuning Constants for MASH ADC
// Refer page:92 of  XWAY_VRX208_V1.0_Design_Spec_Rev1.0_20090417.pdf
//*****************************************************************************
//=============================================================================
// STAGE1, INTEGRATOR 1 constants definitions
// ADC INTE11 Tuning - Tuning of the 1st Integrator's Time Constant
//      in stage 1 of the ADC. The tuning word is calculated by the VR9-D.
//      The programming is binary coded.
//macro ADC_LOOPF1_1_ADC_BITC11_AFE_SET
//=============================================================================

#define  ADC_INTE11_VDSL_30                  (12)
#define  NFIX_ADC_INTE11_VDSL_30     (32)
#define  NUSER_ADC_INTE11_VDSL_30    (18)
#define  CGAIN_ADC_INTE11_VDSL_30    (0)
#define  COFFSET_ADC_INTE11_VDSL_30  (6)
#define  CNTNOM_ADC_INTE11_VDSL_30   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_30 (CNTNOM_ADC_INTE11_VDSL_30 + CGAIN_ADC_INTE11_VDSL_30)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_30
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_30 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_30 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_30

#define  ADC_INTE11_VDSL_17                  (13)
#define  NFIX_ADC_INTE11_VDSL_17     (32)
#define  NUSER_ADC_INTE11_VDSL_17    (25)
#define  CGAIN_ADC_INTE11_VDSL_17    (0)
#define  COFFSET_ADC_INTE11_VDSL_17  (10)
#define  CNTNOM_ADC_INTE11_VDSL_17   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_17 (CNTNOM_ADC_INTE11_VDSL_17 + CGAIN_ADC_INTE11_VDSL_17)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_17
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_17 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_17 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_17

#define  ADC_INTE11_VDSL_12                  (14)
#define  NFIX_ADC_INTE11_VDSL_12     (32)
#define  NUSER_ADC_INTE11_VDSL_12    (25)
#define  CGAIN_ADC_INTE11_VDSL_12    (0)
#define  COFFSET_ADC_INTE11_VDSL_12  (11)
#define  CNTNOM_ADC_INTE11_VDSL_12   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_12 (CNTNOM_ADC_INTE11_VDSL_12 + CGAIN_ADC_INTE11_VDSL_12)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_12
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_12 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_12 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_12

#define  ADC_INTE11_VDSL_5                   (15)
#define  NFIX_ADC_INTE11_VDSL_5      (32)
#define  NUSER_ADC_INTE11_VDSL_5     (14)
#define  CGAIN_ADC_INTE11_VDSL_5     (0)
#define  COFFSET_ADC_INTE11_VDSL_5   (10)
#define  CNTNOM_ADC_INTE11_VDSL_5    (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_5 (CNTNOM_ADC_INTE11_VDSL_5 + CGAIN_ADC_INTE11_VDSL_5)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_5
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_5 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_5 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE11_VDSL_5

//*****************************************************************************
// STAGE1, INTEGRATOR 2
// ADC INTE21 Tuning - Tuning of the 2nd Integrator's Time Constant
// in stage 1 of the ADC. The tuning word is calculated by the VR9-D.
// The programming is binary coded. */
// macros  ADC_LOOPF1_2_ADC_BITC21_AFE_SET
//*****************************************************************************

#define  ADC_INTE21_VDSL_30                  (16)
#define  NFIX_ADC_INTE21_VDSL_30     (32)
#define  NUSER_ADC_INTE21_VDSL_30    (9)
#define  CGAIN_ADC_INTE21_VDSL_30    (0)
#define  COFFSET_ADC_INTE21_VDSL_30  (8)
#define  CNTNOM_ADC_INTE21_VDSL_30   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_30 (CNTNOM_ADC_INTE21_VDSL_30 + CGAIN_ADC_INTE21_VDSL_30)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_30
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_30 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_30 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_30

#define  ADC_INTE21_VDSL_17                  (17)
#define  NFIX_ADC_INTE21_VDSL_17     (32)
#define  NUSER_ADC_INTE21_VDSL_17    (37)
#define  CGAIN_ADC_INTE21_VDSL_17    (0)
#define  COFFSET_ADC_INTE21_VDSL_17  (10)
#define  CNTNOM_ADC_INTE21_VDSL_17   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_17 (CNTNOM_ADC_INTE21_VDSL_17 + CGAIN_ADC_INTE21_VDSL_17)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_17
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_17 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_17 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_17

#define  ADC_INTE21_VDSL_12                  (18)
#define  NFIX_ADC_INTE21_VDSL_12     (32)
#define  NUSER_ADC_INTE21_VDSL_12    (36)
#define  CGAIN_ADC_INTE21_VDSL_12    (0)
#define  COFFSET_ADC_INTE21_VDSL_12  (11)
#define  CNTNOM_ADC_INTE21_VDSL_12   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_12 (CNTNOM_ADC_INTE21_VDSL_12 + CGAIN_ADC_INTE21_VDSL_12)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_12
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_12 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_12 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_12

#define  ADC_INTE21_VDSL_5                   (19)
#define  NFIX_ADC_INTE21_VDSL_5     (32)
#define  NUSER_ADC_INTE21_VDSL_5    (30)
#define  CGAIN_ADC_INTE21_VDSL_5    (0)
#define  COFFSET_ADC_INTE21_VDSL_5  (10)
#define  CNTNOM_ADC_INTE21_VDSL_5   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_5 (CNTNOM_ADC_INTE21_VDSL_5 + CGAIN_ADC_INTE21_VDSL_5)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_5
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_5 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_5 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE21_VDSL_5

//*****************************************************************************
// STAGE2, INTEGRATOR 1
// ADC INTE12 Tuning - Tuning of the 1st Integrator's Time Constant
// in stage 2 of the ADC. The tuning word is calculated by the VR9-D.
// The programming is binary coded.
//macro ADC_LOOPF2_1_ADC_BITC12_AFE_SET
//*****************************************************************************

#define  ADC_INTE12_VDSL_30                  (20)
#define  NFIX_ADC_INTE12_VDSL_30     (32)
#define  NUSER_ADC_INTE12_VDSL_30    (21)
#define  CGAIN_ADC_INTE12_VDSL_30    (0)
#define  COFFSET_ADC_INTE12_VDSL_30  (14)
#define  CNTNOM_ADC_INTE12_VDSL_30   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_30 (CNTNOM_ADC_INTE12_VDSL_30 + CGAIN_ADC_INTE12_VDSL_30)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_30
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_30 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_30 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_30

#define  ADC_INTE12_VDSL_17                  (21)
#define  NFIX_ADC_INTE12_VDSL_17     (32)
#define  NUSER_ADC_INTE12_VDSL_17    (30)
#define  CGAIN_ADC_INTE12_VDSL_17    (0)
#define  COFFSET_ADC_INTE12_VDSL_17  (17)
#define  CNTNOM_ADC_INTE12_VDSL_17   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_17 (CNTNOM_ADC_INTE12_VDSL_17 + CGAIN_ADC_INTE12_VDSL_17)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_17
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_17 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_17 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE12_VDSL_17

//*****************************************************************************
// STAGE2, INTEGRATOR 2
// ADC INTE22 Tuning - Tuning of the 2nd Integrator's Time Constant
// in stage 2 of the ADC. The tuning word is calculated by the VR9-D.
// The programming is binary coded.
//macro ADC_LOOPF2_2_ADC_BITC22_AFE_SET
//*****************************************************************************

#define  ADC_INTE22_VDSL_30                  (22)
#define  NFIX_ADC_INTE22_VDSL_30     (32)
#define  NUSER_ADC_INTE22_VDSL_30    (10)
#define  CGAIN_ADC_INTE22_VDSL_30    (0)
#define  COFFSET_ADC_INTE22_VDSL_30  (10)
#define  CNTNOM_ADC_INTE22_VDSL_30   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_30 (CNTNOM_ADC_INTE22_VDSL_30 + CGAIN_ADC_INTE22_VDSL_30)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_30
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_30 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_30 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_30

#define  ADC_INTE22_VDSL_17                   (23)
#define  NFIX_ADC_INTE22_VDSL_17     (32)
#define  NUSER_ADC_INTE22_VDSL_17    (40)
#define  CGAIN_ADC_INTE22_VDSL_17    (0)
#define  COFFSET_ADC_INTE22_VDSL_17  (17)
#define  CNTNOM_ADC_INTE22_VDSL_17   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_17 (CNTNOM_ADC_INTE22_VDSL_17 + CGAIN_ADC_INTE22_VDSL_17)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_17
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_17 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_17 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_17

#define  ADC_INTE22_VDSL_12                  (24)
#define  NFIX_ADC_INTE22_VDSL_12     (32)
#define  NUSER_ADC_INTE22_VDSL_12    (38)
#define  CGAIN_ADC_INTE22_VDSL_12    (0)
#define  COFFSET_ADC_INTE22_VDSL_12  (17)
#define  CNTNOM_ADC_INTE22_VDSL_12   (479)
#define  CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_12 (CNTNOM_ADC_INTE22_VDSL_12 + CGAIN_ADC_INTE22_VDSL_12)
// The below define should be calculated as ((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_12
// Value 2^24 (instead of 2^16) is chosen to keep the precision.
// if CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_12 is 479 then ((2^24)-1)/479 => 0x88D1
#define  INV_CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_12 0x88D1 //((2^24)-1)/CNTNOM_PLUS_CGAIN_ADC_INTE22_VDSL_12


/**********************************************************************
 * FUNCTIONS
 **********************************************************************/
 extern void FilterTune (uint16 us_Filter);
 extern uint16 Compute_N_POFI(uint16 us_Nfix, uint16 us_Nuser, uint16 us_Coffset,uint16 us_invOfCnomPlusCGain);
 extern uint16 Compute_N_ADC(uint16 us_Nfix, uint16 us_Nuser, uint16 us_Coffset, uint16 CNTnomPCG, uint16 us_RCtimeConstCNT);
#endif
