/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
//*******************************************************************
// VR9_AfeFunc.h
//
// History
//
// 14/05/2010 Nihar: QLN/HLOG calibration for Annex-B DMT, ADSL2/2+
//             Grep for Feature_DS_BisPlus_ALL_VR9QLNCalib
//
// 23/07/2010 Nihar: Tx power boost by 1db post G.hs against all COs
//                   in all modes in Anx-A
//                   Grep for PERF_US_ALL_ALL_TxPwrBoost1dB
//
// 24/03/2011 Vinjam: Add "enable FIFOs" in FIFO init function and
//            renamed "VR9_A2x_FIFO_FIX( )" to "VR9_Init_AFE_FIFOs( )"
//            Grep for XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO
//
// 26/11/2012 Kannan: declared function prototype for VRX318.
//            Grep for XDSLRTFW-541: Platform_VRX318
//
// 15/01/2013 Kannan: commented un used 3GLP funtion declaration
//            Grep for XDSLRTFW-181: XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication
//*****************************************************************************

#ifndef _AFE_FUNC_H
#define _AFE_FUNC_H

void VR9_InitAnalogRegs_Tx(uint16 us_TxMode);
void VR9_InitAnalogRegs_Rx(uint16 us_RxMode);
void VR9_FilterConfigRegs_Tx(uint16 us_TxMode);
void VR9_FilterConfigRegs_Rx(uint16 us_RxMode);
void VR9_ConfigAFETxPath(uint16 us_TxMode);
void VR9_ConfigAFERxPath(uint16 us_RxMode);
void AFEModeSelect_HS_Init(void);
void AFEModeSelect_HS_Exit(uint16 us_ProfileSelected);
void VR9_SetLDMode(uint16 us_LDMode);
void VR9_3GLP_Init_AFE (FlagT ft_BondedMode);
void VR9_3GLP_Init_DFE (FlagT ft_BondedMode,
FlagT ft_AEC_On);
//XDSLRTFW-181 VR9_VRX318_AFE_Init_Fail_Indication (START_END)
//void VR9_3GLP_ManualBringUp(uint8 ch_no); //Not being used for 3GLP, XDSLRTFW-181
void ADC_Trim_Run (uint16 us_mode, uint8 *uca_threshtrim_stg12,
uint8 *uca_fullscaletrim_stg12);
void ADC_Trim_Do(uint16 us_stage, uint8 *uca_trim_val_thresCOMP);
void ADC_Trim_Comp_Write(uint16 comp_nr,
uint16 stage, uint8 uc_trimvalue);
uint8 ADC_Trim_Comp_Read(uint16 comp_nr, uint16 stage);
void VR9_ADC_Trim();
void ADC_Trim_Load (uint16 mode);
void ADC_Trim_Read(uint16 mode);    //SMS00972960
void ADC_Trim_Read_OverWrite (uint16 mode);  //SMS00972960
void VR9_ADC_Trim_Workaround(void);
void VR9_AfeInitAnalogRegistersReset();
void VR9_Afe_Dig_Global_Regs_Reset(void);
void VR9_Glp_Slave_Regs_Reset(void);
void VR9_Afe_Dig_Filt_CH0_Regs_Reset(void);
void VR9_Afe_Dig_CH0_Regs_Reset(void);
void VR9_AfeInitDigitalRegistersReset(void);
void WaitForAfeBusy(void);
void WaitForAfeDone(void);

uint16 VR9_AfeRead(uint16 us_addr);
void VR9_AfeWrite(uint16 us_addr,
uint16 us_data, uint16 us_mask);
void VR9_SSC_init(void);
void VR9_AFE_Flush(void);
void wait_ms(uint16 msec);
void FilterTune(uint16 us_Filter);
uint16 Compute_N(uint16 us_Nfix, uint16 us_Nuser,
uint16 us_Coffset,uint16 us_invOfCnomPlusCGain);
void VR9_EfuseCopy();
int16 SetAfeTxGain(int16 s_gain);
uint16 SetAFEAnalogCutback(uint16 us_cutbacks);
//XDSLRTFW-541: Platform_VRX318 (START)
#ifdef VRX318
void PowerBoost3GLP(void);
#endif //#VRX318
//XDSLRTFW-541: Platform_VRX318 (END)
uint16 VR9_InitAFEPowerUp(void);
uint16 VR9_AFE_IF_Statuscheck (uint8 port_num);
void VR9_PowerUpAfeAnalog(void);
FlagT VR9_MeasureRC(void);
void InitRCCalibMode(void);
void InitRCMeasMode(void);
uint16 ReadRCCnt(uint16 us_mode);
uint16 VR9_GetLDMode();
void VR9_SetLDMode(uint16 us_RequiredLDMode);

int16 VR9_CalcAGC1(int16 s_PGA_required);
int16 VR9_CalcAGC2(int16 s_PGA_required);
void BGCheckADCOverflow_VR9(void);
void BgInitAFE_RegsPGA_VR9 (void);
void BgRestoreAFE_RegsforAGC2_VR9(void);
void BgSetHybrid_VR9(void);
void BgHybTrCalcMetric_VR9(void);
void PgmBestHybrGain(void);
void InitAFE_RegsPGA_ADSL_VR9 (void);
void RestoreAFE_RegsAGC2_ADSL_VR9(void);
void CheckADCOverflow_ADSL_VR9(void);
void VR9_ResetOutDigitalBlocks(void);

//XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (Start_End)
void VR9_Init_AFE_FIFOs(void);

// Feature_DS_BisPlus_ALL_VR9QLNCalib (Start)
void ProgHyb_QlnHlog(void);
void RestoreHyb_QlnHlog(void);
// Feature_DS_BisPlus_ALL_VR9QLNCalib (End)
void LoadHybridHPFAndPGA_VR9(void);
void UpdateHybridBuffer_VR9(void);
void VR9_ConfigAFETxPath_Forced(void);
void VR9_ConfigAFERxPath_Forced(void);
void Update_GLP_OverFlowCounters(uint8 ch_no);
void ProgramOSCDriveLevel(uint16 us_data); //XDSLRTFW-2442 (Start_End)
// PERF_US_ALL_ALL_TxPwrBoost1dB (Start-End)
extern LoadingFunction IncreaseTxPowerInAFE_VR9;     // XDSLRTFW-1891(Start_End)
#endif   // _AFE_FUNC_H
