/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VR9_AFE_CONST_H
#define _VR9_AFE_CONST_H

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: VR9_Afe_const.h
;
;  This file contains constants used by VR9 AFE related files.
;
*****************************************************************************/

// ******************************************************************
// VR9_Afe_const.h
//
// History
//
// 23/03.2011 Vinjam: ARX208 support in VR9 ADSL Firmware
//            Grep for XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV
//
// 05/09/2011 Vinjam: Added hashdefine to detect No LIF module
//            Grep for XDSLRTFW-200: Feature_ALL_ALL_ALL_Detect_No_LIF_Module
//
// 26/11/2012 Kannan: Added hashdefine mask to detect LIF module
//            Grep for "XDSLRTFW-541: Platform_VRX318"
// ******************************************************************

#include "common.h"
#include "vrx5afe_mode_defines.h"

#ifdef ADSL_62
// ADSL PGA Handler Substates
#define PGA_INIT                       (200)
#define PGA_CLEAR_OVERFLOW             (201)
#define BOOST_PGA_GAIN                 (202)
#define PGA_SET_ADC_OVERFLOWS          (203)
#define PGA_WAIT_ADC_OVERFLOWS         (204)
#define PGA_CHECK_ADC_OVERFLOW         (205)
#define SET_PGA_WAIT                   (206)
#define PGA_RX_PWR_INITIALIZE          (207)
#define SET_PGA                        (208)
#define PGA_WAIT                       (209)
#define PGA_START_AGC2_COMPUTATION     (210)
#define PGA_DOUBLE_TRN_DONE            (211)
#endif //ADSL_62



#define AGC1_PRG_GAIN_SETTINGS      30
//To change the No of Hyb settings, the given below MACRO needs to
//be changed along with gusa_HybridSetting_ADSL_B[] init also should be
//changed.
#define ANX_B_NUM_HYBS              (16)
#define ANX_A_NUM_HYBS              (28)

#ifdef ISDN
#define VR9_NUM_ADAP_HYB_SETTINGS   ANX_B_NUM_HYBS  // No of Hybrid settings for AnxB
#else
#define VR9_NUM_ADAP_HYB_SETTINGS   ANX_A_NUM_HYBS  // No of Hybrid settings for AnxA
#endif

#define VRX_HYB_NUM_AFE_REGS        (7)
//No of gsa_HybGain[] gain offset's
#define VRX_HYB_AFE_REG_GAINS       (22)

// CPE hybrid types:
#define VR9_HYB_TYPE_NONE           (0x0)
#define VR9_HYB_TYPE_A              (0x1) //Adaptive hybrid for Annex A
#define VR9_HYB_TYPE_B              (0x2) //Adaptive hybrid for Annex B
#define VR9_HYB_TYPE_BJ             (0x3) //Adaptive hybrid for Annex BJ
//XDSLRTFW-200: Feature_ALL_ALL_ALL_Detect_No_LIF_Module (Start_End)
#define VR9_HYB_TYPE_UNKNOWN        (0x7) //No hybrid or unknown hybrid
#define VR9_LIF_DET_TYPE_A          (0x6)   //GPIO_DIN[2:0] = 110 Type A  Hybrid Module
#define VR9_LIF_DET_TYPE_B          (0x5)   //GPIO_DIN[2:0] = 101 Type B  Hybrid Module
#define VR9_LIF_DET_TYPE_BJ            (0x3)   //GPIO_DIN[2:0] = 011 Type BJ Hybrid Module
//XDSLRTFW-200: Feature_ALL_ALL_ALL_Detect_No_LIF_Module (Start_End)
#define VR9_NO_LIF_MODULE           (0x7)   //GPIO_DIN[2:0] = 111 No LIF Module
#define VR9_HYB_TYPE_AUTO           (0xF) //Get the hybrid type from chip automatically

//XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start)
#define AFE_CHIP_ID_VRX208          (4)
#define AFE_CHIP_ID_ARX208          (5)

#define AFE_SUB_VERSION_VRX208_A11      (0x0A11)
#define AFE_SUB_VERSION_VRX208_A21      (0x0A21)
#define AFE_SUB_VERSION_VRX208_A22      (0x0A22)

#define AFE_SUB_VERSION_ARX208_A22      (0xA22A)
#define AFE_SUB_VERSION_ARX208_LSN      (0xA)  //LSN stands for Lower Significant Nibble
//XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (End)


#endif /* _VR9_AFE_CONST_H */

