/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright (C), 1994-2006 Aware Inc. All Rights Reserved.
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VR9_AFE_TYPEDEF_H
#define _VR9_AFE_TYPEDEF_H
#include "VR9_Afe_const.h"
#include "VRX_AfeCommonConst.h"

/****************************************************************************
;  Aware DMT Technology. Proprietary and Confidential.
;
;   40 Middlesex Turnpike, Bedford, MA 01730-1413
;  Phone (781) 276 - 4000
;   Fax   (781) 276 - 4001
;
;
;  File Name: VR9_Afe_typedef.h
;
;  This file contains type definitions used by VR9 Afe related files.
;
*****************************************************************************/

//ADC trimming typedef declaration - Start
typedef struct
{
   //CMV offset: [0]
   //Bit 0: 0 -> Read trim(def); 1 -> over write trim
   //Bit 1: 0 -> over write stage 1 only; 1 -> over write stage 1 & 2 both;
   //Note: Bit 1 will be used along with Bit 0
   uint16 us_options;    // 2 bytes

   //CMV offset: [1] to [16]
   //Stage1: [1] to [8]; Stage2: [9] to [16]
   uint8  uca_thrshtrim_in_use_stg12[NUM_ADC_TRIM_STG*NUM_ADC_TRIM_COMP_PER_STG];//2*16 = 32 bytes

   //CMV offset: [17]; Stage1: Low Byte; Stage2: High Byte
   uint8  uca_fscletrim_in_use_stg12[NUM_ADC_TRIM_STG]; //2*1 = 2 bytes

   //CMV offset: [18] to [57];
   //Mode VDSL30: Stage1: [18] to [25]; Stage2: [26] to [33];
   //Mode VDSL_17_12: Stage1: [34] to [41]; Stage2: [42] to [49];
   //Mode VDSL05: Stage1: [50] to [57]; Stage2: Nil;

   //First 32 loc for VDSL30, next 32 for VDSL17_12 and last 16 loc for VDSL05
   uint8  uca_adc_threshtrim_stg12[ADC_THRESH_TRIM_LOC_STG12]; //32+32+16 = 80 bytes

   //CMV offset: [58] to [60]
   //Mode VDSL30: [58] Stage1: Low Byte; Stage2: High Byte;
   //Mode VDSL_17_12: [59] Stage1: Low Byte; Stage2: High Byte;
   //Mode VDSL05: [60] Stage1: Low Byte; Stage2: Nil;

   //First 2 loc for VDSL30, next 2 for VDSL17_12 and last 1 loc for VDSL05
   uint8  uca_adc_fullscaletrim_stg12[ADC_FULLSCALE_TRIM_LOC_STG12]; //2+2+1 = 5 bytes
   uint8  uc_dummy; //1 byte; Purpose fully added to avoid overwriting by CMV on adjacent byte.
} adc_trim_t;

//Buffer location details for ADC threshold trim and full scale trim.
//uint8 uca_adc_threshtrim_stg12[ADC_THRESH_TRIM_LOC_STG12];
//First 32 locations for VDSL30, next 32 locations for VDSL17_12 and last 16
//locations for VDSL05
//VDSL30, 17, 12 has 2 stages, and VDSL5 has 1 stage.
//For each stage requires 16 locations.
//Format: Index 0 to 14 --> Stage1 Comparator (15 locations)
//        Index 15  --> Stage1 CompTop        (1 location)
//        Index 16 to 30 --> Stage2 Comparator (15 locations)
//        Index 31  --> Stage2 CompTop         (1 location)
//        ..
//        ..
//        For VDSL5
//Format: Index 64 to 78 --> Stage1 Comparator (15 locations)
//        Index 79  --> Stage1 CompTop         (1 location)

//uint8 uca_adc_fullscaletrim_stg12[ADC_FULLSCALE_TRIM_LOC_STG12];
//First 2 locations for VDSL30, next 2 locations for VDSL17_12 and last 1
//locations for VDSL05
//No of Full scale trim locations = (2*(2*1)+(1) = 5 locations
//        Index 0  --> Full Scale Trim Stage1 <5:0>  (1 location)
//        Index 1  --> Full Scale Trim Stage2 <13:8> (1 location)
//          ...
//        Index 4  --> VDSL5 mode Full Scale Trim Stage1 <5:0>
//ADC trimming typedef declaration - End



typedef struct
{
   int16    s_HybridIndex;
   uint16   us_gain1_set;
   uint16   us_gain2_set;
   uint16   us_AGC1_Rout;
   uint16   us_AGC2_Fixed;
   uint16   us_AGC3_Set;
}best_Hybr_Sel_t;

#endif /* _VR9_AFE_TYPEDEF_H */

