/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VR9_AFEDATA_H
#define _VR9_AFEDATA_H
// ******************************************************************
// VR9_Afedata.h
//
// History
//
// 29/09/2010 Nihar: Prevent VDSL FW to start if AFE register is fused to a defined value.
//                          This is a way to use the VR9 as AR10 till the time AR10 is officially available.
//                      Grep for XDSLRTFW-178
//
// 22/03/2011 Vinjam: Added "ARX208" support through DSL CMV.
//            Grep for XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV
//
// 15/01/2013 Kannan: AFE init fail exception code variable declaration
//            Grep for XDSLRTFW-181: VR9_VRX318_AFE_Init_Fail_Indication
//
// 16/05/2013 Kannan: adc trim related variable declaration.
//            Grep for "XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException"
//
// 13/03/2014 Sriram Shastry : Increase US data rate against  BRCM CO for A.1.4.3 24 HDSL NEXT impairment_testprofile AU_RA_L_30000K
//          Grep for XDSLRTFW-1464 : Perf_US_Plus_AnxA_BRCM_USPerf24HDSLNoise
// ******************************************************************
#include "typedef.h"
#include "VR9_Afe_const.h"
#include "VR9_Afe_typedef.h"

//XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (START)
extern adc_trim_t gt_adc_trim; //SMS00972960
extern uint16 gusa_AfeAdcTrimRegsAddr[];
extern uint16 gusa_AfeAdcTrimRegs_VDSL30[];
extern uint16 gusa_AfeAdcTrimRegs_VDSL17_12[];
extern uint16 gusa_AfeAdcTrimRegs_VDSL05[];
//XDSLRTFW-938 Improvement_VR9_VRX318_AdcTrimException (END)

extern adc_trim_t gt_adc_trim; //SMS00972960
extern int16 gs_PGA1_set; // AGC1 gain
extern FlagT gft_ADCOverflowed;
extern uint8 guc_agc2_cmiller; //AGC2 Miller Capacitor at AGC2_MISC default
extern int16 gs_PgaHandlerRun;
extern int16 gs_PGA_Handler_count;
extern int16 gs_AGC1_Margin;
extern int16 gs_ADC_margin;

extern int16 gs_Agc_prg_gain[AGC1_PRG_GAIN_SETTINGS];
extern int16  gs_AGC2_Fixed_Gain; //AGC2 Fixed gain
extern uint16 gusa_HybridSetting_ADSL_B[VR9_NUM_ADAP_HYB_SETTINGS][VR9_HYB_NUM_AFE_REGS];
extern uint16 gusa_HybridSetting_ADSL_A[VR9_NUM_ADAP_HYB_SETTINGS][VR9_HYB_NUM_AFE_REGS];
extern uint16 gusa_SpecialHybSetting[VR9_HYB_NUM_AFE_REGS];
extern uint16 *gusa_InitHybridSettings;

//XDSLRTFW-278: Feature_AB_ALL_ALL_ARX208_Support_DSL_CMV (Start_End)
extern uint16 gusa_AfeChipId[];

extern uint16 gus_BandGapTrimming;
extern uint16 gusa_HybMetric[VR9_NUM_ADAP_HYB_SETTINGS];
extern int16 gsa_HybGain[VR9_NUM_ADAP_HYB_SETTINGS*VR9_HYB_AFE_REG_GAINS];
extern int16 gs_LoadAllPGAGains;
extern int32 gla_HybRevRefPwr[VR9_NUM_ADAP_HYB_SETTINGS];
//extern int16 gsa_SignalPSD[(HYB_DECIM_POINTS+1)*VR9_NUM_ADAP_HYB_SETTINGS];
extern int32 gla_BgHybAccumBuf[2*(HYB_DECIM_FACTOR * HYB_DECIM_POINTS + 1)];
#endif /* _VR9_AFEDATA_H */
