/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _ERRC_H
#define _ERRC_H


#define ERRC_BASE 0x20ce40

/** Control Register - This register controls the RX 3GLP Error correction Filter */
#define ERRC_RX1_CTRL (ERRC_BASE + 0x0)

/** Filter Bypass - enables TX 3GLP Error Correction Bypass */
#define ERRC_RX1_CTRL_BYP_MASK 0x10
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1

/** Initialization of Error Correction - enables initialization of TX Error Correction */
#define ERRC_RX1_CTRL_INIT_MASK 0x2
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Error correction Enable - enables TX Error Correction */
#define ERRC_RX1_CTRL_EN_MASK 0x1
/** disabled (default) */
#ifndef EN_DIS
#define EN_DIS 0x0
#endif
/** enabled */
#ifndef EN_EN
#define EN_EN 0x1
#endif


/** Error Detection Control Register - This register controls the TX 3GLP Parity Error detections in Error Correction Filter */
#define ERRC_RX1_ERRD_CTRL (ERRC_BASE + 0x4)

/** Selecting Type of Parity Errors Detected for Event Counter - selects source for Parity Error Event Counter */
#define ERRC_RX1_ERRD_CTRL_ERRD_SEL_MASK 0x300
/** Single (default) */
#define ERRD_SEL_SING 0x0
/** Double */
#define ERRD_SEL_DOUB 0x1
/** Triple */
#define ERRD_SEL_TRIP 0x2
/** Quadruple */
#define ERRD_SEL_QUAD 0x3

/** Selecting the source for Parity Error Detection - selects source of the Parity Error Detection  */
#define ERRC_RX1_ERRD_CTRL_PERR_SEL_MASK 0x10
/** MSB parity error and normal parity error (default) */
#define PERR_SEL_MSB_NOR 0x0
/** Only MSB parity error */
#define PERR_SEL_MSB_ONLY 0x1

/** MSB Parity Error Detection Enable - enables MSB (3 bits) parity Error Detection */
#define ERRC_RX1_ERRD_CTRL_MSB_ERRD_EN_MASK 0x1
/** disabled */
#define MSB_ERRD_EN_DIS 0x0
/** enabled (default) */
#define MSB_ERRD_EN_EN 0x1


/** Status Register - This register shows the status of the WLSat Overflow */
#define ERRC_RX1_STAT (ERRC_BASE + 0x8)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define ERRC_RX1_STAT_OVL_MASK 0x1
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Saturation Counter Register - This register shows the number of times saturation has been detected. */
#define ERRC_RX1_SAT_CNT (ERRC_BASE + 0xc)

/** Saturation Counter - Collect the number of times saturation has been detected. Reset to 0 when DSP reads. */
#define ERRC_RX1_SAT_CNT_SATCNT_MASK 0xffff


/** Error Detection Counter Register - This register shows the number of times error has been detected. */
#define ERRC_RX1_ERR_CNT (ERRC_BASE + 0x10)

/** Error Counter - Collect the number of times rrror has been detected. Reset to 0 when DSP reads. */
#define ERRC_RX1_ERR_CNT_ERRCNT_MASK 0xffff


/** Control Register - This register controls the RX 3GLP Error correction Filter */
#define ERRC_RX2_CTRL (ERRC_BASE + 0x40)

/** Filter Bypass - enables TX 3GLP Error Correction Bypass */
#define ERRC_RX2_CTRL_BYP_MASK 0x10
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1

/** Initialization of Error Correction - enables initialization of TX Error Correction */
#define ERRC_RX2_CTRL_INIT_MASK 0x2
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Error correction Enable - enables TX Error Correction */
#define ERRC_RX2_CTRL_EN_MASK 0x1
/** disabled (default) */
#ifndef EN_DIS
#define EN_DIS 0x0
#endif
/** enabled */
#ifndef EN_EN
#define EN_EN 0x1
#endif

/** Error Detection Control Register - This register controls the TX 3GLP Parity Error detections in Error Correction Filter */
#define ERRC_RX2_ERRD_CTRL (ERRC_BASE + 0x44)

/** Selecting Type of Parity Errors Detected for Event Counter - selects source for Parity Error Event Counter */
#define ERRC_RX2_ERRD_CTRL_ERRD_SEL_MASK 0x300
/** Single (default) */
#define ERRD_SEL_SING 0x0
/** Double */
#define ERRD_SEL_DOUB 0x1
/** Triple */
#define ERRD_SEL_TRIP 0x2
/** Quadruple */
#define ERRD_SEL_QUAD 0x3

/** Selecting the source for Parity Error Detection - selects source of the Parity Error Detection  */
#define ERRC_RX2_ERRD_CTRL_PERR_SEL_MASK 0x10
/** MSB parity error and normal parity error (default) */
#define PERR_SEL_MSB_NOR 0x0
/** Only MSB parity error */
#define PERR_SEL_MSB_ONLY 0x1

/** MSB Parity Error Detection Enable - enables MSB (3 bits) parity Error Detection */
#define ERRC_RX2_ERRD_CTRL_MSB_ERRD_EN_MASK 0x1
/** disabled */
#define MSB_ERRD_EN_DIS 0x0
/** enabled (default) */
#define MSB_ERRD_EN_EN 0x1


/** Status Register - This register shows the status of the WLSat Overflow */
#define ERRC_RX2_STAT (ERRC_BASE + 0x48)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define ERRC_RX2_STAT_OVL_MASK 0x1
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Saturation Counter Register - This register shows the number of times saturation has been detected. */
#define ERRC_RX2_SAT_CNT (ERRC_BASE + 0x4c)

/** Saturation Counter - Collect the number of times saturation has been detected. Reset to 0 when DSP reads. */
#define ERRC_RX2_SAT_CNT_SATCNT_MASK 0xffff


/** Error Detection Counter Register - This register shows the number of times error has been detected. */
#define ERRC_RX2_ERR_CNT (ERRC_BASE + 0x50)

/** Error Counter - Collect the number of times rrror has been detected. Reset to 0 when DSP reads. */
#define ERRC_RX2_ERR_CNT_ERRCNT_MASK 0xffff

#endif /* _ERRC_H */
