/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GLPM_H
#define _GLPM_H


#define GLPM_BASE 0x20cc00

/** Framer Control Register - This Register controls the override of status or behavior of the Framer. */
#define GLPM_GLP_FR_CTRL_0 (GLPM_BASE + 0x0)

/** Override Word Check - Controls override of unique word checking. */
#define GLPM_GLP_FR_CTRL_0_OVR_WD_CHK_MASK 0x4000
/** No override */
#define OVR_WD_CHK_NO_OVR 0x0
/** Override */
#define OVR_WD_CHK_OVR 0x1

/** Override Transmit ready - Controls override of transmit ready status. */
#define GLPM_GLP_FR_CTRL_0_OVR_TX_RDY_MASK 0x2000
/** No override */
#define OVR_TX_RDY_NO_OVR 0x0
/** Override */
#define OVR_TX_RDY_OVR 0x1

/** Override remote alignment - Controls override of remote alignment status. */
#define GLPM_GLP_FR_CTRL_0_OVR_RMT_AL_MASK 0x1000
/** No override */
#define OVR_RMT_AL_NO_OVR 0x0
/** Override */
#define OVR_RMT_AL_OVR 0x1

/** Override frame alignment - Controls override of frame alignment status. */
#define GLPM_GLP_FR_CTRL_0_OVR_FM_AL_MASK 0x800
/** No override */
#define OVR_FM_AL_NO_OVR 0x0
/** Override */
#define OVR_FM_AL_OVR 0x1

/** Override inband alignment - Controls override of inband alignment status. */
#define GLPM_GLP_FR_CTRL_0_OVR_IB_AL_MASK 0x400
/** No override */
#define OVR_IB_AL_NO_OVR 0x0
/** Override */
#define OVR_IB_AL_OVR 0x1

/** Override word alignment - Controls override of word alignment status. */
#define GLPM_GLP_FR_CTRL_0_OVR_WD_AL_MASK 0x200
/** No override */
#define OVR_WD_AL_NO_OVR 0x0
/** Override */
#define OVR_WD_AL_OVR 0x1

/** Override CRC status - Controls override of CRC detection status of de-framer. */
#define GLPM_GLP_FR_CTRL_0_OVR_CRC_MASK 0x100

/** Word Check - Overrides Unique word checking enable status when OVR_WD_CHK is OVR. */
#define GLPM_GLP_FR_CTRL_0_WD_CHK_MASK 0x40
/** Enable */
#define WD_CHK_EN 0x0
/** Disable */
#define WD_CHK_DIS 0x1

/** Transmit ready Status - Overrides Framer Transmit Ready status bit when OVR_TX_RDY is OVR. */
#define GLPM_GLP_FR_CTRL_0_TX_RDY_MASK 0x20
/** Not Ready */
#define TX_RDY_NOT_RDY 0x0
/** Ready */
#define TX_RDY_RDY 0x1

/** Remote Frame Alignment Status - Overrides Remote Framer alignment status bit when OVR_RMT_AL is OVR. */
#define GLPM_GLP_FR_CTRL_0_RMT_FM_AL_MASK 0x10
/** Not Align */
#define RMT_FM_AL_NOT_AL 0x0
/** Align */
#define RMT_FM_AL_AL 0x1

/** Frame Alignment Status - Overrides Frame alignment status bit when OVR_FM_AL is OVR. */
#define GLPM_GLP_FR_CTRL_0_FM_AL_MASK 0x8
/** Not Align */
#define FM_AL_NOT_AL 0x0
/** Align */
#define FM_AL_AL 0x1

/** Inband Alignment Status - Overrides Framer inband alignment status bit when OVR_IB_AL is OVR. */
#define GLPM_GLP_FR_CTRL_0_IB_AL_MASK 0x4
/** Not Align */
#define IB_AL_NOT_AL 0x0
/** Align */
#define IB_AL_AL 0x1

/** Word Alignment Status - Overrides Framer word alignment status bit when OVR_WD_AL is OVR. */
#define GLPM_GLP_FR_CTRL_0_WD_AL_MASK 0x2
/** Not Align */
#define WD_AL_NOT_AL 0x0
/** Align */
#define WD_AL_AL 0x1

/** CRC detection status - Overrides CRC detection status of de-framer when OVR_CRC bit is OVR. */
#define GLPM_GLP_FR_CTRL_0_CRC_MASK 0x1

#define GLPM_GLP_FR_CTRL_1 (GLPM_BASE + 0x4)

/** Override Word Check - Controls override of unique word checking. */
#define GLPM_GLP_FR_CTRL_1_OVR_WD_CHK_MASK 0x4000
/** No override */
#define OVR_WD_CHK_NO_OVR 0x0
/** Override */
#define OVR_WD_CHK_OVR 0x1

/** Override Transmit ready - Controls override of transmit ready status. */
#define GLPM_GLP_FR_CTRL_1_OVR_TX_RDY_MASK 0x2000
/** No override */
#define OVR_TX_RDY_NO_OVR 0x0
/** Override */
#define OVR_TX_RDY_OVR 0x1

/** Override remote alignment - Controls override of remote alignment status. */
#define GLPM_GLP_FR_CTRL_1_OVR_RMT_AL_MASK 0x1000
/** No override */
#define OVR_RMT_AL_NO_OVR 0x0
/** Override */
#define OVR_RMT_AL_OVR 0x1

/** Override frame alignment - Controls override of frame alignment status. */
#define GLPM_GLP_FR_CTRL_1_OVR_FM_AL_MASK 0x800
/** No override */
#define OVR_FM_AL_NO_OVR 0x0
/** Override */
#define OVR_FM_AL_OVR 0x1

/** Override inband alignment - Controls override of inband alignment status. */
#define GLPM_GLP_FR_CTRL_1_OVR_IB_AL_MASK 0x400
/** No override */
#define OVR_IB_AL_NO_OVR 0x0
/** Override */
#define OVR_IB_AL_OVR 0x1

/** Override word alignment - Controls override of word alignment status. */
#define GLPM_GLP_FR_CTRL_1_OVR_WD_AL_MASK 0x200
/** No override */
#define OVR_WD_AL_NO_OVR 0x0
/** Override */
#define OVR_WD_AL_OVR 0x1

/** Override CRC status - Controls override of CRC detection status of de-framer. */
#define GLPM_GLP_FR_CTRL_1_OVR_CRC_MASK 0x100

/** Word Check - Overrides Unique word checking enable status when OVR_WD_CHK is OVR. */
#define GLPM_GLP_FR_CTRL_1_WD_CHK_MASK 0x40
/** Enable */
#define WD_CHK_EN 0x0
/** Disable */
#define WD_CHK_DIS 0x1

/** Transmit ready Status - Overrides Framer Transmit Ready status bit when OVR_TX_RDY is OVR. */
#define GLPM_GLP_FR_CTRL_1_TX_RDY_MASK 0x20
/** Not Ready */
#define TX_RDY_NOT_RDY 0x0
/** Ready */
#define TX_RDY_RDY 0x1

/** Remote Frame Alignment Status - Overrides Remote Framer alignment status bit when OVR_RMT_AL is OVR. */
#define GLPM_GLP_FR_CTRL_1_RMT_FM_AL_MASK 0x10
/** Not Align */
#define RMT_FM_AL_NOT_AL 0x0
/** Align */
#define RMT_FM_AL_AL 0x1

/** Frame Alignment Status - Overrides Frame alignment status bit when OVR_FM_AL is OVR. */
#define GLPM_GLP_FR_CTRL_1_FM_AL_MASK 0x8
/** Not Align */
#define FM_AL_NOT_AL 0x0
/** Align */
#define FM_AL_AL 0x1

/** Inband Alignment Status - Overrides Framer inband alignment status bit when OVR_IB_AL is OVR. */
#define GLPM_GLP_FR_CTRL_1_IB_AL_MASK 0x4
/** Not Align */
#define IB_AL_NOT_AL 0x0
/** Align */
#define IB_AL_AL 0x1

/** Word Alignment Status - Overrides Framer word alignment status bit when OVR_WD_AL is OVR. */
#define GLPM_GLP_FR_CTRL_1_WD_AL_MASK 0x2
/** Not Align */
#define WD_AL_NOT_AL 0x0
/** Align */
#define WD_AL_AL 0x1

/** CRC detection status - Overrides CRC detection status of de-framer when OVR_CRC bit is OVR. */
#define GLPM_GLP_FR_CTRL_1_CRC_MASK 0x1
/** Framer Status Register - This Register is the Framer's status register. */
#define GLPM_GLP_FR_STATUS_0 (GLPM_BASE + 0x8)

/** FSM State - Framer State Machine. */
#define GLPM_GLP_FR_STATUS_0_STATE_MASK 0x7000
/** Off */
#define STATE_OFF 0x0
/** Initialise Phy */
#define STATE_INIT_PHY 0x1
/** Word Lock */
#define STATE_WORD_LOCK 0x2
/** Bit Lock */
#define STATE_BIT_LOCK 0x3
/** Bit Lock Wait */
#define STATE_BIT_LOCK_WAIT 0x4
/** Frame Lock */
#define STATE_FRAME_LOCK 0x5
/** Wait for other framer lock */
#define STATE_WAIT_FOR_OTHER 0x6
/** Ready */
#define STATE_READY 0x7

/** Override Inband Control bits - Inband Control to be transmitted. */
#define GLPM_GLP_FR_STATUS_0_IBCTRL_MASK 0xf00

/** PMD/PHY Enable - Framer to PHY enable status. */
#define GLPM_GLP_FR_STATUS_0_PHY_EN_MASK 0x80
/** Enable */
#define PHY_EN_EN 0x0
/** Disable */
#define PHY_EN_DIS 0x1

/** Word Check - Unique word checking enable status. */
#define GLPM_GLP_FR_STATUS_0_WD_CHK_MASK 0x40
/** Enable */
#define WD_CHK_EN 0x0
/** Disable */
#define WD_CHK_DIS 0x1

/** Transmit ready Status - Framer Transmit Ready status bit. */
#define GLPM_GLP_FR_STATUS_0_TX_RDY_MASK 0x20
/** Not Ready */
#define TX_RDY_NOT_RDY 0x0
/** Ready */
#define TX_RDY_RDY 0x1

/** Remote Frame Alignment Status - Remote Framer alignment status bit. */
#define GLPM_GLP_FR_STATUS_0_RMT_FM_AL_MASK 0x10
/** Not Align */
#define RMT_FM_AL_NOT_AL 0x0
/** Align */
#define RMT_FM_AL_AL 0x1

/** Frame Alignment Status - Frame alignment status bit. */
#define GLPM_GLP_FR_STATUS_0_FM_AL_MASK 0x8
/** Not Align */
#define FM_AL_NOT_AL 0x0
/** Align */
#define FM_AL_AL 0x1

/** Inband Alignment Status - Framer inband alignment status bit. */
#define GLPM_GLP_FR_STATUS_0_IB_AL_MASK 0x4
/** Not Align */
#define IB_AL_NOT_AL 0x0
/** Align */
#define IB_AL_AL 0x1

/** Word Alignment Status - Framer word alignment status bit. */
#define GLPM_GLP_FR_STATUS_0_WD_AL_MASK 0x2
/** Not Align */
#define WD_AL_NOT_AL 0x0
/** Align */
#define WD_AL_AL 0x1

/** CRC detection status - CRC detection status of de-framer. */
#define GLPM_GLP_FR_STATUS_0_CRC_MASK 0x1


/** Framer Word Align Index Register - This Register controls the behavior of the Framer. */
#define GLPM_GLP_FR_WD_AL_0 (GLPM_BASE + 0x10)

/** Enable override of Word Alignment Index - Controls override of Word Alignment Index for de-framer. */
#define GLPM_GLP_FR_WD_AL_0_OVR_IDX_MASK 0x40
/** No override */
#define OVR_IDX_NO_OVR 0x0
/** Override */
#define OVR_IDX_OVR 0x1

/** Deframer Word Alignment Index - Overrides or reads Word Alignment Index of the deframer. Override value written when OVR_IDX is 1. */
#define GLPM_GLP_FR_WD_AL_0_IDX_MASK 0x3f

#define GLPM_GLP_FR_WD_AL_1 (GLPM_BASE + 0x14)

/** Enable override of Word Alignment Index - Controls override of Word Alignment Index for de-framer. */
#define GLPM_GLP_FR_WD_AL_1_OVR_IDX_MASK 0x40
/** No override */
#define OVR_IDX_NO_OVR 0x0
/** Override */
#define OVR_IDX_OVR 0x1

/** Deframer Word Alignment Index - Overrides or reads Word Alignment Index of the deframer. Override value written when OVR_IDX is 1. */
#define GLPM_GLP_FR_WD_AL_1_IDX_MASK 0x3f


/** Framer Miscellaneuos Control Register - This Register controls the behavior of the Framer. */
#define GLPM_GLP_FR_MISC_0 (GLPM_BASE + 0x18)

/** Debug Mode Enable - Bit used to enable stepped debug mode in framer state machine. */
#define GLPM_GLP_FR_MISC_0_DBG_MODE_MASK 0x2000
/** Enable */
#define DBG_MODE_EN 0x0
/** Disable */
#define DBG_MODE_DIS 0x1

/** Transmit Corrupt CRC - Bit used to send corrupt CRC in the corresponding framer. */
#define GLPM_GLP_FR_MISC_0_TX_BADCRC_MASK 0x1800

/** Watchdog disable bit - Bit used to disable watchdog function. */
#define GLPM_GLP_FR_MISC_0_WDG_DIS_MASK 0x400
/** Enable */
#define WDG_DIS_EN 0x0
/** Disable */
#define WDG_DIS_DIS 0x1

/** PMD/PHY Enable - This overrides the Framer to PHY enable bit when OVR_PHY_EN is OVR. */
#define GLPM_GLP_FR_MISC_0_PHY_EN_MASK 0x200
/** Enable */
#define PHY_EN_EN 0x0
/** Disable */
#define PHY_EN_DIS 0x1

/** Override PMD/PHY Enable - Controls override of PHY enable. */
#define GLPM_GLP_FR_MISC_0_OVR_PHY_EN_MASK 0x100
/** No override */
#define OVR_PHY_EN_NO_OVR 0x0
/** Override */
#define OVR_PHY_EN_OVR 0x1

/** Override Inband Control bits - This overrides the Inband Control to be transmitted when OVR_IB_EN is EN. */
#define GLPM_GLP_FR_MISC_0_IBCTRL_MASK 0xf0

/** Inband Control Override Enable - Bit used to enable override of Inband Control bits in framer. */
#define GLPM_GLP_FR_MISC_0_OVR_IB_EN_MASK 0x8
/** Disable */
#define OVR_IB_EN_DIS 0x0
/** Enable */
#define OVR_IB_EN_EN 0x1

/** RX Enables - Enables for de-framer module (RX). */
#define GLPM_GLP_FR_MISC_0_RX_EN_MASK 0x4
/** Disable */
#define RX_EN_DIS 0x0
/** Enable */
#define RX_EN_EN 0x1

/** TX Enables - Enables for framer modules (TX). */
#define GLPM_GLP_FR_MISC_0_TX_EN_MASK 0x3
/** Enable TX Lane 1 */
#define TX_EN_EN_RX_1 0x1
/** Enable TX Lane 2 */
#define TX_EN_EN_RX_2 0x2

#define GLPM_GLP_FR_MISC_1 (GLPM_BASE + 0x1C)

/** Debug Mode Enable - Bit used to enable stepped debug mode in framer state machine. */
#define GLPM_GLP_FR_MISC_1_DBG_MODE_MASK 0x2000
/** Enable */
#define DBG_MODE_EN 0x0
/** Disable */
#define DBG_MODE_DIS 0x1

/** Transmit Corrupt CRC - Bit used to send corrupt CRC in the corresponding framer. */
#define GLPM_GLP_FR_MISC_1_TX_BADCRC_MASK 0x1800

/** Watchdog disable bit - Bit used to disable watchdog function. */
#define GLPM_GLP_FR_MISC_1_WDG_DIS_MASK 0x400
/** Enable */
#define WDG_DIS_EN 0x0
/** Disable */
#define WDG_DIS_DIS 0x1

/** PMD/PHY Enable - This overrides the Framer to PHY enable bit when OVR_PHY_EN is OVR. */
#define GLPM_GLP_FR_MISC_1_PHY_EN_MASK 0x200
/** Enable */
#define PHY_EN_EN 0x0
/** Disable */
#define PHY_EN_DIS 0x1

/** Override PMD/PHY Enable - Controls override of PHY enable. */
#define GLPM_GLP_FR_MISC_1_OVR_PHY_EN_MASK 0x100
/** No override */
#define OVR_PHY_EN_NO_OVR 0x0
/** Override */
#define OVR_PHY_EN_OVR 0x1

/** Override Inband Control bits - This overrides the Inband Control to be transmitted when OVR_IB_EN is EN. */
#define GLPM_GLP_FR_MISC_1_IBCTRL_MASK 0xf0

/** Inband Control Override Enable - Bit used to enable override of Inband Control bits in framer. */
#define GLPM_GLP_FR_MISC_1_OVR_IB_EN_MASK 0x8
/** Disable */
#define OVR_IB_EN_DIS 0x0
/** Enable */
#define OVR_IB_EN_EN 0x1

/** RX Enables - Enables for de-framer module (RX). */
#define GLPM_GLP_FR_MISC_1_RX_EN_MASK 0x4
/** Disable */
#define RX_EN_DIS 0x0
/** Enable */
#define RX_EN_EN 0x1

/** TX Enables - Enables for framer modules (TX). */
#define GLPM_GLP_FR_MISC_1_TX_EN_MASK 0x3
/** Enable TX Lane 1 */
#define TX_EN_EN_RX_1 0x1
/** Enable TX Lane 2 */
#define TX_EN_EN_RX_2 0x2


/** Framer Bit Lock Count Register - This register is used to configure the number of consecutive unique words the framer will receive before getting bit alignment. */
#define GLPM_GLP_FR_BITLOCK_0 (GLPM_BASE + 0x20)

/** Framer Bit Lock Counter Limit - Sets the counter value in framer for bit alignment. */
#define GLPM_GLP_FR_BITLOCK_0_CNT_MASK 0xff


/** Framer Watchdog Configuration Register - This register is used to configure the limit for the framer's watchdog. */
#define GLPM_GLP_FR_WDG_CFG_0 (GLPM_BASE + 0x28)

/** Framer Watchdog Timer Limit - Sets the watchdog timer limit for the framer to restart word alignment search. */
#define GLPM_GLP_FR_WDG_CFG_0_TIMER_LIM_MASK 0xffff


/** Framer Error Limit Register - This Register sets limits based on the error events that control state machine. */
#define GLPM_GLP_FR_ERR_LIM_0 (GLPM_BASE + 0x30)

/** Minimum count of no error received - Sets the minimum count of "no errors" condition received before resetting framer's error counter. */
#define GLPM_GLP_FR_ERR_LIM_0_MIN_NO_MASK 0xff00

/** Maximum CRC errors received - Sets the maximum number of CRC errors received before framer re-starts word alignment search. */
#define GLPM_GLP_FR_ERR_LIM_0_MAX_CRC_MASK 0xff


/** Framer Unique Word Configuration Register - This register is used to configure the unique word used for framing. */
#define GLPM_GLP_FR_UNIQ_WD_0 (GLPM_BASE + 0x38)

/** Framer Unique Word - Sets the unique word in framer for word alignment. */
#define GLPM_GLP_FR_UNIQ_WD_0_WORD_MASK 0xffff


/** Framer Received Unique Word Register - This register is used to read the received unique word in deframer 1. */
#define GLPM_GLP_FR_RX_UNIQ_WD_0 (GLPM_BASE + 0x40)

/** Framer Unique Word - Reads the received unique word in deframer for word alignment. */
#define GLPM_GLP_FR_RX_UNIQ_WD_0_WORD_MASK 0xffff

/** Framer Received Unique Word Register - This register is used to read the received unique word in deframer 1. */
#define GLPM_GLP_FR_RX_UNIQ_WD_1 (GLPM_BASE + 0x44)

/** Framer Unique Word - Reads the received unique word in deframer for word alignment. */
#define GLPM_GLP_FR_RX_UNIQ_WD_1_WORD_MASK 0xffff

/** Framer Error Register - This Register is for reading of the total errors received. */
#define GLPM_GLP_FR_ERR_0 (GLPM_BASE + 0x48)

/** Total Number of errors received - Total number of errors received. */
#define GLPM_GLP_FR_ERR_0_TOT_ERR_MASK 0xffff

/** Framer Error Register - This Register is for reading of the total errors received. */
#define GLPM_GLP_FR_ERR_1 (GLPM_BASE + 0x4C)


/** BIST Control Register - This Register is the BIST's control register. */
#define GLPM_GLP_BIST_CTRL (GLPM_BASE + 0x50)

/** Enable Bist - Override of BIST enable when OVR_EN is OVR. */
#define GLPM_GLP_BIST_CTRL_EN_MASK 0x40
/** Enable */
#define GLPM_GLP_BIST_CTRL_EN 0x0
/** Disable */
#define GLPM_GLP_BIST_CTRL_DIS 0x1

/** Enable Override of Bist Enable - Controls override of BIST enable. */
#define GLPM_GLP_BIST_CTRL_OVR_EN_MASK 0x20
/** No override */
#define OVR_EN_NO_OVR 0x0
/** Override */
#define OVR_EN_OVR 0x1

/** RX Enables - Enables for RX Lanes for BIST loop. */
#define GLPM_GLP_BIST_CTRL_RX_EN_MASK 0x18
/** Enable RX BIST 1 */
#define RX_EN_RX_BIST_EN_1 0x1
/** Enable RX BIST 2 */
#define RX_EN_RX_BIST_EN_2 0x2

/** TX Enables - Enables for TX Lanes for BIST loop. */
#define GLPM_GLP_BIST_CTRL_TX_EN_MASK 0x6
/** Enable TX BIST 1 */
#define TX_EN_TX_BIST_EN_1 0x1
/** Enable TX BIST 2 */
#define TX_EN_TX_BIST_EN_2 0x2

/** Bypass - TX_EN and RX_EN will select the respective slices for BIST when BYPASS is EN.  */
#define GLPM_GLP_BIST_CTRL_BYPASS_MASK 0x1
/** Disable Bypass */
#define BYPASS_DIS 0x0
/** Enable Bypass */
#define BYPASS_EN 0x1


/** Phase Lock Count Register - This Register is the BIST's phase lock count register. */
#define GLPM_GLP_BIST_PHLOCK (GLPM_BASE + 0x54)

/** Phase Lock Count - Programs the counter value for the BIST to achieve phase lock. */
#define GLPM_GLP_BIST_PHLOCK_COUNT_MASK 0x3ff


/** Bist Endcount Register - This Register is the BIST's word count register. */
#define GLPM_GLP_BIST_END (GLPM_BASE + 0x58)

/** Word Count - Programs the number of words for the BIST to check for errors. */
#define GLPM_GLP_BIST_END_COUNT_MASK 0x3ff


/** BERT Termination Count Register - This Register is the BERT's termination count register. */
#define GLPM_GLP_BERT_TERM (GLPM_BASE + 0x5c)

/** Word Count - Read the number of words BERT receives at termination. */
#define GLPM_GLP_BERT_TERM_COUNT_MASK 0x3ff


/** BERT Error Count Register - This Register is the BERT's Error count register. */
#define GLPM_GLP_BERT_ERR (GLPM_BASE + 0x60)

/** Word Count - Read the number of accumulated bit errors. */
#define GLPM_GLP_BERT_ERR_COUNT_MASK 0x3ff


/** BERT Control Register - This Register is the BERTs' control register. */
#define GLPM_GLP_BERT_CTRL (GLPM_BASE + 0x64)

/** Loopback Enables - Loopback enables for respective BERTs.  */
#define GLPM_GLP_BERT_CTRL_LOOPEN_MASK 0x600
/** Enable Loopback in BERT 1 */
#define LOOPEN_BERT1_EN 0x1
/** Enable Loopback in BERT 2 */
#define LOOPEN_BERT2_EN 0x2

/** LFSR Enable - LSFR Data from BERTs will be used for scrambling data from PHY if enabled.  */
#define GLPM_GLP_BERT_CTRL_SELFSYNC_EN_MASK 0x180
/** Enable Self Sync in BERT 1 */
#define SELFSYNC_EN_BERT1_EN 0x1
/** Enable Self Sync in BERT 2 */
#define SELFSYNC_EN_BERT2_EN 0x2

/** Scramble Enable - Data from BERTs will be used for scrambling data to PHY if enabled.  */
#define GLPM_GLP_BERT_CTRL_SCR_EN_MASK 0x40
/** Disable */
#define SCR_EN_DIS 0x0
/** Enable */
#define SCR_EN_EN 0x1

/** BERT Error Count reset - Resets the BERT Error Count Register of the enabled BERT.  */
#define GLPM_GLP_BERT_CTRL_ERR_RST_MASK 0x20
/** No Reset */
#define ERR_RST_NO_RST 0x0
/** Reset */
#define ERR_RST_RST 0x1

/** BERT Word Count reset - Resets the BERT Termination Count Register of the enabled BERT.  */
#define GLPM_GLP_BERT_CTRL_WRD_RST_MASK 0x10
/** No Reset */
#define WRD_RST_NO_RST 0x0
/** Reset */
#define WRD_RST_RST 0x1

/** BERT RX Resets - Reset Bits (Active low) for each BERT RX. */
#define GLPM_GLP_BERT_CTRL_RX_RST_MASK 0xc
/** Reset */
#define RX_RST_RST 0x0
/** No Reset */
#define RX_RST_NO_RST 0x1

/** BERT TX Resets - Reset Bits (Active low) for each BERT TX. */
#define GLPM_GLP_BERT_CTRL_TX_RST_MASK 0x3
/** Reset */
#define TX_RST_RST 0x0
/** No Reset */
#define TX_RST_NO_RST 0x1


/** 3GLP Control Register - This register is used for general control in the 3GLP. */
#define GLPM_GLP_GLP_CTRL (GLPM_BASE + 0x68)

/** CRC value sent - This CRC value will be transmitted to core when 3GLP is not ready and MSK_EN is enabled. */
#define GLPM_GLP_GLP_CTRL_CRC_VAL_MASK 0x40

/** Data masking enable - Enables data masking at core interface. A all-zeros data word will be transmitted when 3GLP is not ready. */
#define GLPM_GLP_GLP_CTRL_MSK_EN_MASK 0x20
/** Disable */
#define MSK_EN_DIS 0x0
/** Enable */
#define MSK_EN_EN 0x1

/** Clock switching enable - Enables clock switching at core interface. A 144MHz clock will be transmitted when 3GLP is not ready. */
#define GLPM_GLP_GLP_CTRL_CLK_SW_MASK 0x10
/** Disable */
#define CLK_SW_DIS 0x0
/** Enable */
#define CLK_SW_EN 0x1

/** Control - Selects Inband bits mapping to TX 2 CDR control. */
#define GLPM_GLP_GLP_CTRL_TX2_CDR_SEL_MASK 0xc
/** Selects RX1 Inband Control 1 */
#define TX2_CDR_SEL_SEL_0 0x0
/** Selects RX1 Inband Control 2 */
#define TX2_CDR_SEL_SEL_1 0x1
/** Selects RX2 Inband Control 1 */
#define TX2_CDR_SEL_SEL_2 0x2
/** Selects RX2 Inband Control 2 */
#define TX2_CDR_SEL_SEL_3 0x3

/** Control - Selects Inband bits mapping to TX 1 CDR control. */
#define GLPM_GLP_GLP_CTRL_TX1_CDR_SEL_MASK 0x3
/** Selects RX1 Inband Control 1 */
#define TX1_CDR_SEL_SEL_0 0x0
/** Selects RX1 Inband Control 2 */
#define TX1_CDR_SEL_SEL_1 0x1
/** Selects RX2 Inband Control 1 */
#define TX1_CDR_SEL_SEL_2 0x2
/** Selects RX2 Inband Control 2 */
#define TX1_CDR_SEL_SEL_3 0x3


/** 3GLP Miscellaneous Register - This register is used for miscellaneous control or reading bits. */
#define GLPM_GLP_GLP_MISC (GLPM_BASE + 0x6c)

/** Status - Miscellaneous Status bits. */
#define GLPM_GLP_GLP_MISC_STATUS_2_MASK 0xf000

/** Status - Miscellaneous Status bits. */
#define GLPM_GLP_GLP_MISC_STATUS_1_MASK 0xf00

/** Control - Miscellaneous Control bits. */
#define GLPM_GLP_GLP_MISC_CTRL_MASK 0xff


/** Start Up Control Register - PMA Start Up Register */
#define GLPM_PMA_STARTUP_CTRL (GLPM_BASE + 0x80)

/** Skip Calibration - Skip Calibration bit. */
#define GLPM_PMA_STARTUP_CTRL_SKIP_CAL_MASK 0x400

/** Startup Ready - Start up Ready bit. The PHY ready status is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_STARTUP_RDY_MASK 0x200

/** CAL Enable - The Calibration Enable is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_CAL_EN_MASK 0x100

/** CDR Enable - CDR Enable. The is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_CDR_EN_MASK 0x80

/** Clock Enable - High Speed Clock Enable is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_CLK_EN_MASK 0x40

/** Powerdown - Powerdown bit is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_PD_MASK 0x20

/** Reset PMD - The PMD reset is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_RSTN_PMD_MASK 0x10

/** Reset Digital - Digital reset to all blocks in PMA slices is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_RSTN_DIG_MASK 0x8

/** PLL Powerdown - PLL powerdown is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_PLL_PD_MASK 0x4

/** PLL reset - PLL reset bit. The PLL reset is overridden by this value when bypass is enabled. */
#define GLPM_PMA_STARTUP_CTRL_PLL_RSTN_MASK 0x2

/** Bypass - Register Bypass bit. Start-up state machine control outputs will be overridden by register values when enabled.  */
#define GLPM_PMA_STARTUP_CTRL_BYPASS_MASK 0x1
/** Disable */
#define BYPASS_DIS 0x0
/** Enable */
#define BYPASS_EN 0x1


/** State Register - PMA Start Up State Register */
#define GLPM_PMA_STATE (GLPM_BASE + 0x84)

/** Start Up SM State - PMA Start-Up State Machine. */
#define GLPM_PMA_STATE_STATE_MASK 0x7
/** Power Up PLL */
#define STATE_ST_POWERUP_PLL 0x0
/** Release High Freqency Reset */
#define STATE_ST_RELEASE_HF_RESET 0x1
/** Release High Freqency Clocks */
#define STATE_ST_RELEASE_HF_CLOCKS 0x2
/** Release Digital Reset */
#define STATE_ST_RELEASE_DIG_RESET 0x3
/** Enable Calibration */
#define STATE_ST_EN_CAL 0x4
/** Finish */
#define STATE_FINISH 0x5


/** Control 1 Register - This Register is for controlling the PMA portion of PLL SLICE behavior. */
#define GLPM_PLL_CTRL1 (GLPM_BASE + 0x88)

/** CONST_SDM - 16 LSBs of the CONST_SDM. */
#define GLPM_PLL_CTRL1_CONST_SDM_MASK 0xffff


/** Control 2 Register - This Register is for controlling the PMA portion of PLL SLICE behavior. */
#define GLPM_PLL_CTRL2 (GLPM_BASE + 0x8c)

/** plldigtest_r */
#define GLPM_PLL_CTRL2_PLLDIGTEST_MASK 0xf800

/** pll_enwavegen_r */
#define GLPM_PLL_CTRL2_PLL_ENWAVEGEN_MASK 0x400
/** Disable */
#define PLL_ENWAVEGEN_DIS 0x0
/** Enable */
#define PLL_ENWAVEGEN_EN 0x1

/** pll_ensdm_r */
#define GLPM_PLL_CTRL2_PLL_ENSDM_MASK 0x200
/** Disable */
#define PLL_ENSDM_DIS 0x0
/** Enable */
#define PLL_ENSDM_EN 0x1

/** en_const_sdm_r */
#define GLPM_PLL_CTRL2_EN_CONST_SDM_MASK 0x100
/** Disable */
#define EN_CONST_SDM_DIS 0x0
/** Enable */
#define EN_CONST_SDM_EN 0x1

/** CONST_SDM - 8 MSBs of the CONST_SDM. */
#define GLPM_PLL_CTRL2_CONST_SDM_MASK 0xff


/** Control 3 Register - This Register is for controlling the PMA portion of PLL SLICE behavior. */
#define GLPM_PLL_CTRL3 (GLPM_BASE + 0x90)

/** en_ext_selvco_r */
#define GLPM_PLL_CTRL3_EXT_SELVCO_MASK 0x3e00

/** ext_VCO_vctrl_mux_r */
#define GLPM_PLL_CTRL3_EXT_VCO_VCTRL_MUX_MASK 0x180

/** ext_MMD_div_ratio_r */
#define GLPM_PLL_CTRL3_EXT_MMD_DIV_RATIO_MASK 0x70

/** en_ext_selvco_r */
#define GLPM_PLL_CTRL3_EN_EXT_SELVCO_MASK 0x8
/** Disable */
#define EN_EXT_SELVCO_DIS 0x0
/** Enable */
#define EN_EXT_SELVCO_EN 0x1

/** en_ext_VCO_vctrl_mux_r */
#define GLPM_PLL_CTRL3_EN_EXT_VCO_VCTRL_MUX_MASK 0x4
/** Disable */
#define EN_EXT_VCO_VCTRL_MUX_DIS 0x0
/** Enable */
#define EN_EXT_VCO_VCTRL_MUX_EN 0x1

/** en_ext_MMD_div_ratio_r */
#define GLPM_PLL_CTRL3_EN_EXT_MMD_DIV_RATIO_MASK 0x2
/** Disable */
#define EN_EXT_MMD_DIV_RATIO_DIS 0x0
/** Enable */
#define EN_EXT_MMD_DIV_RATIO_EN 0x1

/** en_binary_cal_r */
#define GLPM_PLL_CTRL3_EN_BIN_CAL_MASK 0x1
/** Disable */
#define EN_BIN_CAL_DIS 0x0
/** Enable */
#define EN_BIN_CAL_EN 0x1


/** Control 4 Register - This Register is for controlling the PMA portion of PLL SLICE behavior. */
#define GLPM_PLL_CTRL4 (GLPM_BASE + 0x94)

/** pllmod_r - First (Least Significant) word of the PLLMOD. */
#define GLPM_PLL_CTRL4_PLLMOD_MASK 0xffff


/** Control 5 Register - This Register is for controlling the PMA portion of PLL SLICE behavior. */
#define GLPM_PLL_CTRL5 (GLPM_BASE + 0x98)

/** pllmod_r - Second word of the PLLMOD. */
#define GLPM_PLL_CTRL5_PLLMOD_MASK 0xffff


/** Control 6 Register - This Register is for controlling the PMA portion of PLL SLICE behavior. */
#define GLPM_PLL_CTRL6 (GLPM_BASE + 0x9c)

/** pllmod_r - Third word of the PLLMOD. */
#define GLPM_PLL_CTRL6_PLLMOD_MASK 0xffff


/** Control 7 Register - This Register is for controlling the PMA portion of PLL SLICE behavior. */
#define GLPM_PLL_CTRL7 (GLPM_BASE + 0xa0)

/** pllmod_r - Fourth (Most significant) word of the PLLMOD. */
#define GLPM_PLL_CTRL7_PLLMOD_MASK 0xffff


/** Analog Control 1 Register - This Register is for controlling of analog PLL SLICE behavior. */
#define GLPM_PLL_A_CTRL1 (GLPM_BASE + 0xa4)

/** pfd_force_up_r */
#define GLPM_PLL_A_CTRL1_PFD_FORCE_UP_MASK 0x8000

/** pfd_force_dw_r */
#define GLPM_PLL_A_CTRL1_PFD_FORCE_DW_MASK 0x4000

/** cp_sel_r */
#define GLPM_PLL_A_CTRL1_CP_SEL_MASK 0x3800

/** cp_ref_sel_r */
#define GLPM_PLL_A_CTRL1_CP_REF_SEL_MASK 0x600

/** cp_force_fix_p_bias_r */
#define GLPM_PLL_A_CTRL1_CP_FORCE_FIX_P_BIAS_MASK 0x100

/** biastrim */
#define GLPM_PLL_A_CTRL1_BIASTRIM_MASK 0xff


/** Analog Control 2 Register - This Register is for controlling of analog PLL SLICE behavior. */
#define GLPM_PLL_A_CTRL2 (GLPM_BASE + 0xa8)

/** lf_mode_r */
#define GLPM_PLL_A_CTRL2_LF_MODE_MASK 0x4000

/** ldo_vref_sel_r */
#define GLPM_PLL_A_CTRL2_LDO_VREF_SEL_MASK 0x3800

/** div_clk_o_mtr_en_r */
#define GLPM_PLL_A_CTRL2_DIV_CLK_O_MTR_EN_MASK 0x400
/** Disable */
#define DIV_CLK_O_MTR_EN_DIS 0x0
/** Enable */
#define DIV_CLK_O_MTR_EN_EN 0x1

/** current_sel_ref_mux_r */
#define GLPM_PLL_A_CTRL2_CURR_SEL_REF_MUX_MASK 0x300

/** current_sel_pi_r */
#define GLPM_PLL_A_CTRL2_CURR_SEL_PI_MASK 0xc0

/** current_sel_lf_r */
#define GLPM_PLL_A_CTRL2_CURR_SEL_LF_MASK 0x30

/** current_sel_ldo_r */
#define GLPM_PLL_A_CTRL2_CURR_SEL_LDO_MASK 0xc

/** current_sel_div2_r */
#define GLPM_PLL_A_CTRL2_CURR_SEL_DIV2_MASK 0x3


/** Analog Control 3 Register - This Register is for controlling of analog PLL SLICE behavior. */
#define GLPM_PLL_A_CTRL3 (GLPM_BASE + 0xac)

/** mmd_r */
#define GLPM_PLL_A_CTRL3_MMD_MASK 0xe000

/** vco_vctrl_when_ct_r */
#define GLPM_PLL_A_CTRL3_VCO_VCTRL_WHEN_CT_MASK 0x1800

/** test_ext_fd_in_en_r */
#define GLPM_PLL_A_CTRL3_TEST_EXT_FD_IN_EN_MASK 0x400
/** Disable */
#define TEST_EXT_FD_IN_EN_DIS 0x0
/** Enable */
#define TEST_EXT_FD_IN_EN_EN 0x1

/** refclk_sel_r */
#define GLPM_PLL_A_CTRL3_REFCLK_SEL_MASK 0x200

/** refclk_o_en_r */
#define GLPM_PLL_A_CTRL3_REFCLK_O_EN_MASK 0x100
/** Disable */
#define REFCLK_O_EN_DIS 0x0
/** Enable */
#define REFCLK_O_EN_EN 0x1

/** ref_clk_o_mtr_en_r */
#define GLPM_PLL_A_CTRL3_REF_CLK_O_MTR_EN_MASK 0x80
/** Disable */
#define REF_CLK_O_MTR_EN_DIS 0x0
/** Enable */
#define REF_CLK_O_MTR_EN_EN 0x1

/** pwd_vrefs_r */
#define GLPM_PLL_A_CTRL3_PWD_VREFS_MASK 0x40

/** pwd_lf_r */
#define GLPM_PLL_A_CTRL3_PWD_LF_MASK 0x20

/** pwd_ldo_vco_r */
#define GLPM_PLL_A_CTRL3_PWD_LDO_VCO_MASK 0x10

/** pwd_fd_in_buffer_r */
#define GLPM_PLL_A_CTRL3_PWD_FD_IN_BUFFER_MASK 0x8

/** pwd_div2_r */
#define GLPM_PLL_A_CTRL3_PWD_DIV2_MASK 0x4

/** pwd_cp_r */
#define GLPM_PLL_A_CTRL3_PWD_CP_MASK 0x2

/** pwd_bias_r */
#define GLPM_PLL_A_CTRL3_PWD_BIAS_MASK 0x1


/** PLL Status Register - This Register is for reading PLL status. */
#define GLPM_PLL_STATUS (GLPM_BASE + 0xb0)

/** Startup Ready */
#define GLPM_PLL_STATUS_STARTUP_RDY_MASK 0x40

/** Lock */
#define GLPM_PLL_STATUS_LOCK_MASK 0x20

/** Ready */
#define GLPM_PLL_STATUS_READY_MASK 0x10

/** Force Start */
#define GLPM_PLL_STATUS_FORCE_START_MASK 0x2

/** Force Lock */
#define GLPM_PLL_STATUS_FORCE_LOCK_MASK 0x1


/** Control 1 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX1_CTRL1 (GLPM_BASE + 0xc0)

/** pi_ctrl_r - For pi_ctrl. */
#define GLPM_TX1_CTRL1_PI_CTRL_MASK 0x3f00

/** load_r - For pi_ctrl. */
#define GLPM_TX1_CTRL1_LOAD_MASK 0x10

/** force_r */
#define GLPM_TX1_CTRL1_FORCE_MASK 0x8

/** ei_en_r */
#define GLPM_TX1_CTRL1_EI_EN_MASK 0x4
/** Disable */
#define EI_EN_DIS 0x0
/** Enable */
#define EI_EN_EN 0x1

/** Invert Enable - Enables the inversion of data. */
#define GLPM_TX1_CTRL1_INV_EN_MASK 0x2
/** Disable */
#define INV_EN_DIS 0x0
/** Enable */
#define INV_EN_EN 0x1

/** Enable - Enable bit. */
#define GLPM_TX1_CTRL1_EN_MASK 0x1
/** Disable */
#define GLPM_TX1_CTRL1_DIS 0x0
/** Enable */
#define GLPM_TX1_CTRL1_EN 0x1


/** TX Control 2 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX1_CTRL2 (GLPM_BASE + 0xc4)

/** rterm_r - Configures termination resistors in PHY. */
#define GLPM_TX1_CTRL2_RTERM_MASK 0x3e00

/** Enable Programmable TX Data - Enable Programmable Data for TX. */
#define GLPM_TX1_CTRL2_PRG_EN_MASK 0x100
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1

/** Programmable TX Data - Programmable Data for TX to PHY. */
#define GLPM_TX1_CTRL2_PRG_DATA_MASK 0xff


/** Control 3 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX1_CTRL3 (GLPM_BASE + 0xc8)

/** counter_limit_r */
#define GLPM_TX1_CTRL3_CNTR_LIM_MASK 0xffff


/** Analog Control 1 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX1_A_CTRL1 (GLPM_BASE + 0xcc)

/** control_r */
#define GLPM_TX1_A_CTRL1_CTRL_MASK 0xff00

/** diffout_en_r */
#define GLPM_TX1_A_CTRL1_DIFFOUT_EN_MASK 0x10

/** deemph_en_r */
#define GLPM_TX1_A_CTRL1_DEEMPH_EN_MASK 0x8
/** Disable */
#define DEEMPH_EN_DIS 0x0
/** Enable */
#define DEEMPH_EN_EN 0x1

/** clkmode_en_r - Clock mode enable for PHY. */
#define GLPM_TX1_A_CTRL1_CLKMODE_EN_MASK 0x4
/** Disable */
#define CLKMODE_EN_DIS 0x0
/** Enable */
#define CLKMODE_EN_EN 0x1

/** clk_edge_sel_r - Clock edge select for PHY. */
#define GLPM_TX1_A_CTRL1_CLK_EDGE_SEL_MASK 0x2

/** clk_byp_en_r - Clock bypass enable for PHY. */
#define GLPM_TX1_A_CTRL1_CLK_BYP_EN_MASK 0x1
/** Disable */
#define CLK_BYP_EN_DIS 0x0
/** Enable */
#define CLK_BYP_EN_EN 0x1


/** Analog Control 2 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX1_A_CTRL2 (GLPM_BASE + 0xd0)

/** ser_en_r */
#define GLPM_TX1_A_CTRL2_SER_EN_MASK 0x8000

/** predrv_ser_en_r */
#define GLPM_TX1_A_CTRL2_PREDRV_SER_EN_MASK 0x7f00

/** predrv_par_en_r */
#define GLPM_TX1_A_CTRL2_PREDRV_PAR_EN_MASK 0xf0

/** iout_r */
#define GLPM_TX1_A_CTRL2_IOUT_MASK 0xf


/** Modulation Configuration 1 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX1_MOD1 (GLPM_BASE + 0xd4)

/** skew_period_flip - if mod_out_flip_i = 0, skew_period_flip_i = 0 will add skew to down */
#define GLPM_TX1_MOD1_SKEW_PERIOD_FLIP_MASK 0x2000

/** Mod_out_skew_en - Enable skew to CDR CTRL */
#define GLPM_TX1_MOD1_SKEW_EN_MASK 0x1000

/** Mod_flip - Bit to flip the CDR CTRL to start modulation pulses with up or down */
#define GLPM_TX1_MOD1_FLIP_MASK 0x800

/** Modulation Period */
#define GLPM_TX1_MOD1_PERIOD_MASK 0x7ff


/** Modulation Configuration 2 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX1_MOD2 (GLPM_BASE + 0xd8)

/** Skew Period - The user defined occurance period for skew. */
#define GLPM_TX1_MOD2_SKEW_PERIOD_MASK 0xffff


/** Modulation Configuration 3 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX1_MOD3 (GLPM_BASE + 0xdc)

/** mod_en_r - Modulation enable for PHY. */
#define GLPM_TX1_MOD3_MOD_EN_MASK 0x400
/** Disable */
#define MOD_EN_DIS 0x0
/** Enable */
#define MOD_EN_EN 0x1

/** Modulation Override - Modulation override enable for PHY. */
#define GLPM_TX1_MOD3_MOD_OVR_MASK 0x200

/** BIST Modulation Enable - Bist modulation enable for PHY. */
#define GLPM_TX1_MOD3_BIST_MOD_EN_MASK 0x100
/** Disable */
#define BIST_MOD_EN_DIS 0x0
/** Enable */
#define BIST_MOD_EN_EN 0x1

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define GLPM_TX1_MOD3_TESTBUS_BIST_EN_MASK 0x80

/** Testbus Enable - Enables Test bus in PMD. */
#define GLPM_TX1_MOD3_TESTBUS_EN_MASK 0x40

/** Modulation pulses - The number of up or down modulation pulses. */
#define GLPM_TX1_MOD3_AMP_MASK 0x3f


/** Control 1 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX2_CTRL1 (GLPM_BASE + 0xe0)

/** pi_ctrl_r - For pi_ctrl. */
#define GLPM_TX2_CTRL1_PI_CTRL_MASK 0x3f00

/** load_r - For pi_ctrl. */
#define GLPM_TX2_CTRL1_LOAD_MASK 0x10

/** force_r */
#define GLPM_TX2_CTRL1_FORCE_MASK 0x8

/** ei_en_r */
#define GLPM_TX2_CTRL1_EI_EN_MASK 0x4
/** Disable */
#define EI_EN_DIS 0x0
/** Enable */
#define EI_EN_EN 0x1

/** Invert Enable - Enables the inversion of data. */
#define GLPM_TX2_CTRL1_INV_EN_MASK 0x2
/** Disable */
#define INV_EN_DIS 0x0
/** Enable */
#define INV_EN_EN 0x1

/** Enable - Enable bit. */
#define GLPM_TX2_CTRL1_EN_MASK 0x1
/** Disable */
#define GLPM_TX2_CTRL1_DIS 0x0
/** Enable */
#define GLPM_TX2_CTRL1_EN 0x1


/** TX Control 2 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX2_CTRL2 (GLPM_BASE + 0xe4)

/** rterm_r - Configures termination resistors in PHY. */
#define GLPM_TX2_CTRL2_RTERM_MASK 0x3e00

/** Enable Programmable TX Data - Enable Programmable Data for TX. */
#define GLPM_TX2_CTRL2_PRG_EN_MASK 0x100
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1

/** Programmable TX Data - Programmable Data for TX to PHY. */
#define GLPM_TX2_CTRL2_PRG_DATA_MASK 0xff


/** Control 3 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX2_CTRL3 (GLPM_BASE + 0xe8)

/** counter_limit_r */
#define GLPM_TX2_CTRL3_CNTR_LIM_MASK 0xffff


/** Analog Control 1 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX2_A_CTRL1 (GLPM_BASE + 0xec)

/** control_r */
#define GLPM_TX2_A_CTRL1_CTRL_MASK 0xff00

/** diffout_en_r */
#define GLPM_TX2_A_CTRL1_DIFFOUT_EN_MASK 0x10

/** deemph_en_r */
#define GLPM_TX2_A_CTRL1_DEEMPH_EN_MASK 0x8
/** Disable */
#define DEEMPH_EN_DIS 0x0
/** Enable */
#define DEEMPH_EN_EN 0x1

/** clkmode_en_r - Clock mode enable for PHY. */
#define GLPM_TX2_A_CTRL1_CLKMODE_EN_MASK 0x4
/** Disable */
#define CLKMODE_EN_DIS 0x0
/** Enable */
#define CLKMODE_EN_EN 0x1

/** clk_edge_sel_r - Clock edge select for PHY. */
#define GLPM_TX2_A_CTRL1_CLK_EDGE_SEL_MASK 0x2

/** clk_byp_en_r - Clock bypass enable for PHY. */
#define GLPM_TX2_A_CTRL1_CLK_BYP_EN_MASK 0x1
/** Disable */
#define CLK_BYP_EN_DIS 0x0
/** Enable */
#define CLK_BYP_EN_EN 0x1


/** Analog Control 2 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX2_A_CTRL2 (GLPM_BASE + 0xf0)

/** ser_en_r */
#define GLPM_TX2_A_CTRL2_SER_EN_MASK 0x8000

/** predrv_ser_en_r */
#define GLPM_TX2_A_CTRL2_PREDRV_SER_EN_MASK 0x7f00

/** predrv_par_en_r */
#define GLPM_TX2_A_CTRL2_PREDRV_PAR_EN_MASK 0xf0

/** iout_r */
#define GLPM_TX2_A_CTRL2_IOUT_MASK 0xf


/** Modulation Configuration 1 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX2_MOD1 (GLPM_BASE + 0xf4)

/** skew_period_flip - if mod_out_flip_i = 0, skew_period_flip_i = 0 will add skew to down */
#define GLPM_TX2_MOD1_SKEW_PERIOD_FLIP_MASK 0x2000

/** Mod_out_skew_en - Enable skew to CDR CTRL */
#define GLPM_TX2_MOD1_SKEW_EN_MASK 0x1000

/** Mod_flip - Bit to flip the CDR CTRL to start modulation pulses with up or down */
#define GLPM_TX2_MOD1_FLIP_MASK 0x800

/** Modulation Period */
#define GLPM_TX2_MOD1_PERIOD_MASK 0x7ff


/** Modulation Configuration 2 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX2_MOD2 (GLPM_BASE + 0xf8)

/** Skew Period - The user defined occurance period for skew. */
#define GLPM_TX2_MOD2_SKEW_PERIOD_MASK 0xffff


/** Modulation Configuration 3 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX2_MOD3 (GLPM_BASE + 0xfc)

/** mod_en_r - Modulation enable for PHY. */
#define GLPM_TX2_MOD3_MOD_EN_MASK 0x400
/** Disable */
#define MOD_EN_DIS 0x0
/** Enable */
#define MOD_EN_EN 0x1

/** Modulation Override - Modulation override enable for PHY. */
#define GLPM_TX2_MOD3_MOD_OVR_MASK 0x200

/** BIST Modulation Enable - Bist modulation enable for PHY. */
#define GLPM_TX2_MOD3_BIST_MOD_EN_MASK 0x100
/** Disable */
#define BIST_MOD_EN_DIS 0x0
/** Enable */
#define BIST_MOD_EN_EN 0x1

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define GLPM_TX2_MOD3_TESTBUS_BIST_EN_MASK 0x80

/** Testbus Enable - Enables Test bus in PMD. */
#define GLPM_TX2_MOD3_TESTBUS_EN_MASK 0x40

/** Modulation pulses - The number of up or down modulation pulses. */
#define GLPM_TX2_MOD3_AMP_MASK 0x3f


/** Control 1 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX3_CTRL1 (GLPM_BASE + 0x100)

/** pi_ctrl_r - For pi_ctrl. */
#define GLPM_TX3_CTRL1_PI_CTRL_MASK 0x3f00

/** load_r - For pi_ctrl. */
#define GLPM_TX3_CTRL1_LOAD_MASK 0x10

/** force_r */
#define GLPM_TX3_CTRL1_FORCE_MASK 0x8

/** ei_en_r */
#define GLPM_TX3_CTRL1_EI_EN_MASK 0x4
/** Disable */
#define EI_EN_DIS 0x0
/** Enable */
#define EI_EN_EN 0x1

/** Invert Enable - Enables the inversion of data. */
#define GLPM_TX3_CTRL1_INV_EN_MASK 0x2
/** Disable */
#define INV_EN_DIS 0x0
/** Enable */
#define INV_EN_EN 0x1

/** Enable - Enable bit. */
#define GLPM_TX3_CTRL1_EN_MASK 0x1
/** Disable */
#define GLPM_TX3_CTRL1_DIS 0x0
/** Enable */
#define GLPM_TX3_CTRL1_EN 0x1


/** TX Control 2 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX3_CTRL2 (GLPM_BASE + 0x104)

/** rterm_r - Configures termination resistors in PHY. */
#define GLPM_TX3_CTRL2_RTERM_MASK 0x3e00

/** Enable Programmable TX Data - Enable Programmable Data for TX. */
#define GLPM_TX3_CTRL2_PRG_EN_MASK 0x100
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1

/** Programmable TX Data - Programmable Data for TX to PHY. */
#define GLPM_TX3_CTRL2_PRG_DATA_MASK 0xff


/** Control 3 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX3_CTRL3 (GLPM_BASE + 0x108)

/** counter_limit_r */
#define GLPM_TX3_CTRL3_CNTR_LIM_MASK 0xffff


/** Analog Control 1 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX3_A_CTRL1 (GLPM_BASE + 0x10c)

/** control_r */
#define GLPM_TX3_A_CTRL1_CTRL_MASK 0xff00

/** diffout_en_r */
#define GLPM_TX3_A_CTRL1_DIFFOUT_EN_MASK 0x10

/** deemph_en_r */
#define GLPM_TX3_A_CTRL1_DEEMPH_EN_MASK 0x8
/** Disable */
#define DEEMPH_EN_DIS 0x0
/** Enable */
#define DEEMPH_EN_EN 0x1

/** clkmode_en_r - Clock mode enable for PHY. */
#define GLPM_TX3_A_CTRL1_CLKMODE_EN_MASK 0x4
/** Disable */
#define CLKMODE_EN_DIS 0x0
/** Enable */
#define CLKMODE_EN_EN 0x1

/** clk_edge_sel_r - Clock edge select for PHY. */
#define GLPM_TX3_A_CTRL1_CLK_EDGE_SEL_MASK 0x2

/** clk_byp_en_r - Clock bypass enable for PHY. */
#define GLPM_TX3_A_CTRL1_CLK_BYP_EN_MASK 0x1
/** Disable */
#define CLK_BYP_EN_DIS 0x0
/** Enable */
#define CLK_BYP_EN_EN 0x1


/** Analog Control 2 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX3_A_CTRL2 (GLPM_BASE + 0x110)

/** ser_en_r */
#define GLPM_TX3_A_CTRL2_SER_EN_MASK 0x8000

/** predrv_ser_en_r */
#define GLPM_TX3_A_CTRL2_PREDRV_SER_EN_MASK 0x7f00

/** predrv_par_en_r */
#define GLPM_TX3_A_CTRL2_PREDRV_PAR_EN_MASK 0xf0

/** iout_r */
#define GLPM_TX3_A_CTRL2_IOUT_MASK 0xf


/** Modulation Configuration 1 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX3_MOD1 (GLPM_BASE + 0x114)

/** skew_period_flip - if mod_out_flip_i = 0, skew_period_flip_i = 0 will add skew to down */
#define GLPM_TX3_MOD1_SKEW_PERIOD_FLIP_MASK 0x2000

/** Mod_out_skew_en - Enable skew to CDR CTRL */
#define GLPM_TX3_MOD1_SKEW_EN_MASK 0x1000

/** Mod_flip - Bit to flip the CDR CTRL to start modulation pulses with up or down */
#define GLPM_TX3_MOD1_FLIP_MASK 0x800

/** Modulation Period */
#define GLPM_TX3_MOD1_PERIOD_MASK 0x7ff


/** Modulation Configuration 2 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX3_MOD2 (GLPM_BASE + 0x118)

/** Skew Period - The user defined occurance period for skew. */
#define GLPM_TX3_MOD2_SKEW_PERIOD_MASK 0xffff


/** Modulation Configuration 3 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX3_MOD3 (GLPM_BASE + 0x11c)

/** mod_en_r - Modulation enable for PHY. */
#define GLPM_TX3_MOD3_MOD_EN_MASK 0x400
/** Disable */
#define MOD_EN_DIS 0x0
/** Enable */
#define MOD_EN_EN 0x1

/** Modulation Override - Modulation override enable for PHY. */
#define GLPM_TX3_MOD3_MOD_OVR_MASK 0x200

/** BIST Modulation Enable - Bist modulation enable for PHY. */
#define GLPM_TX3_MOD3_BIST_MOD_EN_MASK 0x100
/** Disable */
#define BIST_MOD_EN_DIS 0x0
/** Enable */
#define BIST_MOD_EN_EN 0x1

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define GLPM_TX3_MOD3_TESTBUS_BIST_EN_MASK 0x80

/** Testbus Enable - Enables Test bus in PMD. */
#define GLPM_TX3_MOD3_TESTBUS_EN_MASK 0x40

/** Modulation pulses - The number of up or down modulation pulses. */
#define GLPM_TX3_MOD3_AMP_MASK 0x3f


/** Control 1 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX4_CTRL1 (GLPM_BASE + 0x120)

/** pi_ctrl_r - For pi_ctrl. */
#define GLPM_TX4_CTRL1_PI_CTRL_MASK 0x3f00

/** load_r - For pi_ctrl. */
#define GLPM_TX4_CTRL1_LOAD_MASK 0x10

/** force_r */
#define GLPM_TX4_CTRL1_FORCE_MASK 0x8

/** ei_en_r */
#define GLPM_TX4_CTRL1_EI_EN_MASK 0x4
/** Disable */
#define EI_EN_DIS 0x0
/** Enable */
#define EI_EN_EN 0x1

/** Invert Enable - Enables the inversion of data. */
#define GLPM_TX4_CTRL1_INV_EN_MASK 0x2
/** Disable */
#define INV_EN_DIS 0x0
/** Enable */
#define INV_EN_EN 0x1

/** Enable - Enable bit. */
#define GLPM_TX4_CTRL1_EN_MASK 0x1
/** Disable */
#define GLPM_TX4_CTRL1_DIS 0x0
/** Enable */
#define GLPM_TX4_CTRL1_EN 0x1


/** TX Control 2 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX4_CTRL2 (GLPM_BASE + 0x124)

/** rterm_r - Configures termination resistors in PHY. */
#define GLPM_TX4_CTRL2_RTERM_MASK 0x3e00

/** Enable Programmable TX Data - Enable Programmable Data for TX. */
#define GLPM_TX4_CTRL2_PRG_EN_MASK 0x100
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1

/** Programmable TX Data - Programmable Data for TX to PHY. */
#define GLPM_TX4_CTRL2_PRG_DATA_MASK 0xff


/** Control 3 Register - This Register is for controlling of TX SLICE behavior. */
#define GLPM_TX4_CTRL3 (GLPM_BASE + 0x128)

/** counter_limit_r */
#define GLPM_TX4_CTRL3_CNTR_LIM_MASK 0xffff


/** Analog Control 1 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX4_A_CTRL1 (GLPM_BASE + 0x12c)

/** control_r */
#define GLPM_TX4_A_CTRL1_CTRL_MASK 0xff00

/** diffout_en_r */
#define GLPM_TX4_A_CTRL1_DIFFOUT_EN_MASK 0x10

/** deemph_en_r */
#define GLPM_TX4_A_CTRL1_DEEMPH_EN_MASK 0x8
/** Disable */
#define DEEMPH_EN_DIS 0x0
/** Enable */
#define DEEMPH_EN_EN 0x1

/** clkmode_en_r - Clock mode enable for PHY. */
#define GLPM_TX4_A_CTRL1_CLKMODE_EN_MASK 0x4
/** Disable */
#define CLKMODE_EN_DIS 0x0
/** Enable */
#define CLKMODE_EN_EN 0x1

/** clk_edge_sel_r - Clock edge select for PHY. */
#define GLPM_TX4_A_CTRL1_CLK_EDGE_SEL_MASK 0x2

/** clk_byp_en_r - Clock bypass enable for PHY. */
#define GLPM_TX4_A_CTRL1_CLK_BYP_EN_MASK 0x1
/** Disable */
#define CLK_BYP_EN_DIS 0x0
/** Enable */
#define CLK_BYP_EN_EN 0x1


/** Analog Control 2 Register - This Register is for controlling of analog TX SLICE behavior. */
#define GLPM_TX4_A_CTRL2 (GLPM_BASE + 0x130)

/** ser_en_r */
#define GLPM_TX4_A_CTRL2_SER_EN_MASK 0x8000

/** predrv_ser_en_r */
#define GLPM_TX4_A_CTRL2_PREDRV_SER_EN_MASK 0x7f00

/** predrv_par_en_r */
#define GLPM_TX4_A_CTRL2_PREDRV_PAR_EN_MASK 0xf0

/** iout_r */
#define GLPM_TX4_A_CTRL2_IOUT_MASK 0xf


/** Modulation Configuration 1 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX4_MOD1 (GLPM_BASE + 0x134)

/** skew_period_flip - if mod_out_flip_i = 0, skew_period_flip_i = 0 will add skew to down */
#define GLPM_TX4_MOD1_SKEW_PERIOD_FLIP_MASK 0x2000

/** Mod_out_skew_en - Enable skew to CDR CTRL */
#define GLPM_TX4_MOD1_SKEW_EN_MASK 0x1000

/** Mod_flip - Bit to flip the CDR CTRL to start modulation pulses with up or down */
#define GLPM_TX4_MOD1_FLIP_MASK 0x800

/** Modulation Period */
#define GLPM_TX4_MOD1_PERIOD_MASK 0x7ff


/** Modulation Configuration 2 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX4_MOD2 (GLPM_BASE + 0x138)

/** Skew Period - The user defined occurance period for skew. */
#define GLPM_TX4_MOD2_SKEW_PERIOD_MASK 0xffff


/** Modulation Configuration 3 Register - This Register is the configuration of the Modulation. */
#define GLPM_TX4_MOD3 (GLPM_BASE + 0x13c)

/** mod_en_r - Modulation enable for PHY. */
#define GLPM_TX4_MOD3_MOD_EN_MASK 0x400
/** Disable */
#define MOD_EN_DIS 0x0
/** Enable */
#define MOD_EN_EN 0x1

/** Modulation Override - Modulation override enable for PHY. */
#define GLPM_TX4_MOD3_MOD_OVR_MASK 0x200

/** BIST Modulation Enable - Bist modulation enable for PHY. */
#define GLPM_TX4_MOD3_BIST_MOD_EN_MASK 0x100
/** Disable */
#define BIST_MOD_EN_DIS 0x0
/** Enable */
#define BIST_MOD_EN_EN 0x1

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define GLPM_TX4_MOD3_TESTBUS_BIST_EN_MASK 0x80

/** Testbus Enable - Enables Test bus in PMD. */
#define GLPM_TX4_MOD3_TESTBUS_EN_MASK 0x40

/** Modulation pulses - The number of up or down modulation pulses. */
#define GLPM_TX4_MOD3_AMP_MASK 0x3f


/** RX Control 1 Register - This Register is for controlling of RX SLICE behavior. */
#define GLPM_RX1_CTRL1 (GLPM_BASE + 0x140)

/** pi_ctrl_r */
#define GLPM_RX1_CTRL1_PI_CTRL_MASK 0x3f00

/** sel_offset_r */
#define GLPM_RX1_CTRL1_SEL_OFFSET_MASK 0xf0

/** BYPASS */
#define GLPM_RX1_CTRL1_BYPASS_MASK 0x8
/** Disable */
#define BYPASS_DIS 0x0
/** Enable */
#define BYPASS_EN 0x1

/** Invert Enable - Enables the inversion of RX data. */
#define GLPM_RX1_CTRL1_INV_EN_MASK 0x4

/** load_r */
#define GLPM_RX1_CTRL1_LOAD_MASK 0x2

/** Enable - Enable bit. */
#define GLPM_RX1_CTRL1_EN_MASK 0x1
/** Disable */
#define GLPM_RX1_CTRL1_DIS 0x0
/** Enable */
#define GLPM_RX1_CTRL1_EN 0x1


/** RX Control 2 Register - This Register is for controlling of RX SLICE behavior. */
#define GLPM_RX1_CTRL2 (GLPM_BASE + 0x144)

/** rterm_r - Configures termination resistors in PHY. */
#define GLPM_RX1_CTRL2_RTERM_MASK 0x3e00

/** Enable Programmable RX Data - Enable Programmable Data for RX. */
#define GLPM_RX1_CTRL2_PRG_EN_MASK 0x100
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1

/** Programmable RX Data - Programmable Data for RX. */
#define GLPM_RX1_CTRL2_DATA_MASK 0xff


/** CDR Configuration Register - This Register is for Configuration of CDR CTRL. */
#define GLPM_RX1_CDR (GLPM_BASE + 0x148)

/** sum_int - SUM_INT. */
#define GLPM_RX1_CDR_SUM_INT_MASK 0x200

/** xor_inv - XOR_INV. */
#define GLPM_RX1_CDR_XOR_INV_MASK 0x100

/** dumpint - dumpint. */
#define GLPM_RX1_CDR_DUMPINT_MASK 0x70

/** comp - Comp. */
#define GLPM_RX1_CDR_COMP_MASK 0x7


/** EI Register - This Register is for Configuration of EI detect. */
#define GLPM_RX1_EI (GLPM_BASE + 0x14c)

/** ei_endcount_r */
#define GLPM_RX1_EI_ENDCNT_MASK 0xffff


/** CAL Register - This Register is for Configuration of CAL. */
#define GLPM_RX1_CAL (GLPM_BASE + 0x150)

/** cal_fail_r */
#define GLPM_RX1_CAL_CAL_FAIL_MASK 0x200

/** inv_dir_r */
#define GLPM_RX1_CAL_INV_DIR_MASK 0x100

/** comp_count_r */
#define GLPM_RX1_CAL_COMP_CNT_MASK 0xf0

/** smp_count_r */
#define GLPM_RX1_CAL_SMP_CNT_MASK 0xf


/** Analog Control Register - This Register is for controlling of analog RX SLICE behavior. */
#define GLPM_RX1_A_CTRL (GLPM_BASE + 0x154)

/** output_cm_sel_r */
#define GLPM_RX1_A_CTRL_OUTPUT_CM_SEL_MASK 0x7000

/** EMP */
#define GLPM_RX1_A_CTRL_EMP_MASK 0xc00

/** double_tailcur_r */
#define GLPM_RX1_A_CTRL_DB_TAILCUR_MASK 0x200

/** cdr_on_n_r */
#define GLPM_RX1_A_CTRL_CDR_ON_N_MASK 0x100

/** control_r */
#define GLPM_RX1_A_CTRL_CTRL_MASK 0xff


/** Test Control Register - This Register is for Test control of RX SLICE. */
#define GLPM_RX1_TEST_CTRL (GLPM_BASE + 0x158)

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define GLPM_RX1_TEST_CTRL_TESTBUS_BIST_EN_MASK 0x2
/** Disable */
#define TESTBUS_BIST_EN_DIS 0x0
/** Enable */
#define TESTBUS_BIST_EN_EN 0x1

/** Testbus Enable - Enables Test bus in PMD. */
#define GLPM_RX1_TEST_CTRL_TESTBUS_EN_MASK 0x1
/** Disable */
#define TESTBUS_EN_DIS 0x0
/** Enable */
#define TESTBUS_EN_EN 0x1


/** RX Control 1 Register - This Register is for controlling of RX SLICE behavior. */
#define GLPM_RX2_CTRL1 (GLPM_BASE + 0x160)

/** pi_ctrl_r */
#define GLPM_RX2_CTRL1_PI_CTRL_MASK 0x3f00

/** sel_offset_r */
#define GLPM_RX2_CTRL1_SEL_OFFSET_MASK 0xf0

/** BYPASS */
#define GLPM_RX2_CTRL1_BYPASS_MASK 0x8
/** Disable */
#define BYPASS_DIS 0x0
/** Enable */
#define BYPASS_EN 0x1

/** Invert Enable - Enables the inversion of RX data. */
#define GLPM_RX2_CTRL1_INV_EN_MASK 0x4

/** load_r */
#define GLPM_RX2_CTRL1_LOAD_MASK 0x2

/** Enable - Enable bit. */
#define GLPM_RX2_CTRL1_EN_MASK 0x1
/** Disable */
#define GLPM_RX2_CTRL1_DIS 0x0
/** Enable */
#define GLPM_RX2_CTRL1_EN 0x1


/** RX Control 2 Register - This Register is for controlling of RX SLICE behavior. */
#define GLPM_RX2_CTRL2 (GLPM_BASE + 0x164)

/** rterm_r - Configures termination resistors in PHY. */
#define GLPM_RX2_CTRL2_RTERM_MASK 0x3e00

/** Enable Programmable RX Data - Enable Programmable Data for RX. */
#define GLPM_RX2_CTRL2_PRG_EN_MASK 0x100
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1

/** Programmable RX Data - Programmable Data for RX. */
#define GLPM_RX2_CTRL2_DATA_MASK 0xff


/** CDR Configuration Register - This Register is for Configuration of CDR CTRL. */
#define GLPM_RX2_CDR (GLPM_BASE + 0x168)

/** sum_int - SUM_INT. */
#define GLPM_RX2_CDR_SUM_INT_MASK 0x200

/** xor_inv - XOR_INV. */
#define GLPM_RX2_CDR_XOR_INV_MASK 0x100

/** dumpint - dumpint. */
#define GLPM_RX2_CDR_DUMPINT_MASK 0x70

/** comp - Comp. */
#define GLPM_RX2_CDR_COMP_MASK 0x7


/** EI Register - This Register is for Configuration of EI detect. */
#define GLPM_RX2_EI (GLPM_BASE + 0x16c)

/** ei_endcount_r */
#define GLPM_RX2_EI_ENDCNT_MASK 0xffff


/** CAL Register - This Register is for Configuration of CAL. */
#define GLPM_RX2_CAL (GLPM_BASE + 0x170)

/** cal_fail_r */
#define GLPM_RX2_CAL_CAL_FAIL_MASK 0x200

/** inv_dir_r */
#define GLPM_RX2_CAL_INV_DIR_MASK 0x100

/** comp_count_r */
#define GLPM_RX2_CAL_COMP_CNT_MASK 0xf0

/** smp_count_r */
#define GLPM_RX2_CAL_SMP_CNT_MASK 0xf


/** Analog Control Register - This Register is for controlling of analog RX SLICE behavior. */
#define GLPM_RX2_A_CTRL (GLPM_BASE + 0x174)

/** output_cm_sel_r */
#define GLPM_RX2_A_CTRL_OUTPUT_CM_SEL_MASK 0x7000

/** EMP */
#define GLPM_RX2_A_CTRL_EMP_MASK 0xc00

/** double_tailcur_r */
#define GLPM_RX2_A_CTRL_DB_TAILCUR_MASK 0x200

/** cdr_on_n_r */
#define GLPM_RX2_A_CTRL_CDR_ON_N_MASK 0x100

/** control_r */
#define GLPM_RX2_A_CTRL_CTRL_MASK 0xff


/** Test Control Register - This Register is for Test control of RX SLICE. */
#define GLPM_RX2_TEST_CTRL (GLPM_BASE + 0x178)

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define GLPM_RX2_TEST_CTRL_TESTBUS_BIST_EN_MASK 0x2
/** Disable */
#define TESTBUS_BIST_EN_DIS 0x0
/** Enable */
#define TESTBUS_BIST_EN_EN 0x1

/** Testbus Enable - Enables Test bus in PMD. */
#define GLPM_RX2_TEST_CTRL_TESTBUS_EN_MASK 0x1
/** Disable */
#define TESTBUS_EN_DIS 0x0
/** Enable */
#define TESTBUS_EN_EN 0x1

#endif /* _GLPM_H */
