/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GLPTOP_H
#define _GLPTOP_H


#define GLPTOP_BASE 0x20ce00

/** 3GLP Top level configuration Register - 3GLP top level configuration register */
#define GLP_TOP_CFG (GLPTOP_BASE + 0x0)

/** 3GLP Bundle Mode */
#define GLP_TOP_CFG_MODE_MASK 0x80000000
/** Single Modem Mode with 2 TX path and 1 RX path active. */
#define MODE_GLP_MODE_0 0x0
/** duo Modem Mode with 2 independent 3GLP macros. */
#define MODE_GLP_MODE_1 0x1

/** 3GLP Bypass Clock Selection */
#define GLP_TOP_CFG_BYPCLK_MASK 0x8000000
/** Not bypassed. */
#define BYPCLK_BYPCLK_0 0x0
/** Bypassed clock input is taken from the DFE @ 144 MHz. */
#define BYPCLK_BYPCLK_1 0x1

/** RX Path 1 (Macro 1, RX path) */
#define GLP_TOP_CFG_RXCG1_MASK 0x200000
/** 3GLP Macro 1, RX path, output clock is disabled */
#define RXCG1_GLP0_RXCG1_0 0x0
/** 3GLP Macro 1, RX path, output clock is enabled (default) */
#define RXCG1_GLP0_RXCG1_1 0x1

/** TX Path 1 (Macro 1, TX path) */
#define GLP_TOP_CFG_TXCG1_MASK 0x100000
/** 3GLP Macro 1, TX path, output clock is disabled */
#define TXCG1_GLP0_TXCG1_0 0x0
/** 3GLP Macro 1, TX path, output clock is enabled (default) */
#define TXCG1_GLP0_TXCG1_1 0x1

/** RX Path 0 (Macro 0, RX path) */
#define GLP_TOP_CFG_RXCG0_MASK 0x20000
/** 3GLP Macro 0, RX path, output clock is disabled */
#define RXCG0_GLP0_RXCG0_0 0x0
/** 3GLP Macro 0, RX path, output clock is enabled (default) */
#define RXCG0_GLP0_RXCG0_1 0x1

/** TX Path 0 (Macro 0, TX path) */
#define GLP_TOP_CFG_TXCG0_MASK 0x10000
/** 3GLP Macro 0, TX path, output clock is disabled */
#define TXCG0_GLP0_TXCG0_0 0x0
/** 3GLP Macro 0, TX path, output clock is enabled (default) */
#define TXCG0_GLP0_TXCG0_1 0x1

/** 3GLP Macro 1 Reset */
#define GLP_TOP_CFG_RST1_MASK 0x1000
/** 3GLP Macro 1 is reseted */
#define RST1_GLP1_RST_0 0x0
/** 3GLP Macro 1 is in normal operation */
#define RST1_GLP1_RST_1 0x1

/** 3GLP Macro 1 Enable */
#define GLP_TOP_CFG_EN1_MASK 0x100
/** 3GLP Macro 1 is disabled */
#define EN1_GLP1_EN_0 0x0
/** 3GLP Macro 1 is enabled */
#define EN1_GLP1_EN_1 0x1

/** 3GLP Macro 0 Reset */
#define GLP_TOP_CFG_RST0_MASK 0x10
/** 3GLP Macro 0 is reseted */
#define RST0_GLP0_RST_0 0x0
/** 3GLP Macro 0 is in normal operation */
#define RST0_GLP0_RST_1 0x1

/** 3GLP Macro 0 Enable */
#define GLP_TOP_CFG_EN0_MASK 0x1
/** 3GLP Macro 0 is disabled */
#define EN0_GLP0_EN_0 0x0
/** 3GLP Macro 0 is enabled */
#define EN0_GLP0_EN_1 0x1


/** 3GLP Top level Status register - 3GLP top level Status register */
#define GLP_TOP_STATUS (GLPTOP_BASE + 0x4)

/** 3GLP Macro 1 is Not Ready (sticky) - This bit tracks if RDY1 has been deasserted some time in the past. Clear by DSP writing 1B to this position. This is simply a latch high sticky bit on the invert of the RDY0 status. */
#define GLP_TOP_STATUS_NRDY1_MASK 0x1000
/** 3GLP Macro 1 is ready. */
#define NRDY1_GLP_NRDY_0 0x0
/** 3GLP Macro 1 has been not ready(unlock) in the past. */
#define NRDY1_GLP_NRDY_1 0x1

/** 3GLP Macro 1 is Ready ( Startup Procedure Successful) */
#define GLP_TOP_STATUS_RDY1_MASK 0x100
/** 3GLP Macro 1 is not ready. */
#define RDY1_GLP_RDY_0 0x0
/** 3GLP Macro 1 is ready. */
#define RDY1_GLP_RDY_1 0x1

/** 3GLP Macro 0 is Not Ready (sticky) - This bit tracks if RDY0 has been deasserted some time in the past. Clear by DSP writing 1B to this position. This is simply a latch high sticky bit on the invert of the RDY0 status. */
#define GLP_TOP_STATUS_NRDY0_MASK 0x10
/** 3GLP Macro 0 is ready. */
#define NRDY0_GLP_NRDY_0 0x0
/** 3GLP Macro 0 has been not ready(unlock) in the past. */
#define NRDY0_GLP_NRDY_1 0x1

/** 3GLP Macro 0 is Ready ( Startup Procedure Successful) */
#define GLP_TOP_STATUS_RDY0_MASK 0x1
/** 3GLP Macro 0 is not ready. */
#define RDY0_GLP_RDY_0 0x0
/** 3GLP Macro 0 is ready. */
#define RDY0_GLP_RDY_1 0x1


/** 3GLP0 Input FIFO Configuration register - 3GLP TX FIFO Configuration register (from DFE to 3GLP macro 0) */
#define GLP_TX0FIFO_CFG (GLPTOP_BASE + 0x10)

/** FIFO Overflow status (sticky) */
#define GLP_TX0FIFO_CFG_OVF_MASK 0x80000000
/** no FIFO overflow detected. */
#define OVF_OVF_0 0x0
/** Some time in the past, the FIFO has detected overflow. DSP can clear this bit by writing '1'. */
#define OVF_OVF_1 0x1

/** FIFO Underflow status (sticky) */
#define GLP_TX0FIFO_CFG_UDF_MASK 0x10000000
/** no FIFO underflow detected. */
#define UDF_UDF_0 0x0
/** Some time in the past, the FIFO has detected underflow. DSP can clear this bit by writing '1'. */
#define UDF_UDF_1 0x1

/** FIFO Fill State - For debug purpose only. Provide information regarding the FIFO fill level. Unsigned integer. Nominally around 8, underflow threshold if below 4 and overflow threshold if over 12. */
#define GLP_TX0FIFO_CFG_STATE_MASK 0x1f0000

/** Debug FIFO */
#define GLP_TX0FIFO_CFG_DBG_MASK 0x8
/** normal operation. */
#define DBG_DBG_0 0x0
/** Disable the FIFO Feature where overflow/underflow detection is used to stop writing or ensure reading out only 0. Test purpose only. */
#define DBG_DBG_1 0x1

/** Hold FIFO */
#define GLP_TX0FIFO_CFG_HLD_MASK 0x4
/** Normal operation. */
#define HLD_HOLD_0 0x0
/** hold the FIFO operation. Read/write to FIFO will be disabled when this bit is active. */
#define HLD_HOLD_1 0x1

/** Initialize FIFO - This bit reinitialize the read/write pointers to the reset value. Note that setting and releasing this bit must be synchronized by hardware to the respective clock domains of the input/output pointers. Note that proper initialization can only take place by ensuring HLD bit is 0. */
#define GLP_TX0FIFO_CFG_INIT_MASK 0x2
/** Normal Operation. */
#define INIT_INIT_0 0x0
/** Reset the FIFO pointers to the reset value. */
#define INIT_INIT_1 0x1

/** FIFO Enable - When disabled, the read/write pointers are also restored to the reset value. */
#define GLP_TX0FIFO_CFG_EN_MASK 0x1
/** Disable FIFO. */
#define EN_EN_0 0x0
/** Enable FIFO. */
#define EN_EN_1 0x1


/** 3GLP0 Output FIFO Configuration register - 3GLP RX FIFO Configuration register (from 3GLP macro 0 to DFE) */
#define GLP_RX0FIFO_CFG (GLPTOP_BASE + 0x18)

/** FIFO Overflow status (sticky) */
#define GLP_RX0FIFO_CFG_OVF_MASK 0x80000000
/** no FIFO overflow detected. */
#define OVF_OVF_0 0x0
/** Some time in the past, the FIFO has detected overflow. DSP can clear this bit by writing '1'. */
#define OVF_OVF_1 0x1

/** FIFO Underflow status (sticky) */
#define GLP_RX0FIFO_CFG_UDF_MASK 0x10000000
/** no FIFO underflow detected. */
#define UDF_UDF_0 0x0
/** Some time in the past, the FIFO has detected underflow. DSP can clear this bit by writing '1'. */
#define UDF_UDF_1 0x1

/** FIFO Fill State - For debug purpose only. Provide information regarding the FIFO fill level. Unsigned integer. Norminally around 8, underflow threshold if below 4 and overflow threshold if over 12. */
#define GLP_RX0FIFO_CFG_STATE_MASK 0x1f0000

/** Debug FIFO */
#define GLP_RX0FIFO_CFG_DBG_MASK 0x8
/** normal operation. */
#define DBG_DBG_0 0x0
/** Disable the FIFO Feature where overflow/underflow detection is used to stop writing or ensure reading out only 0. Test purpose only. */
#define DBG_DBG_1 0x1

/** Hold FIFO */
#define GLP_RX0FIFO_CFG_HLD_MASK 0x4
/** Normal operation. */
#define HLD_HOLD_0 0x0
/** hold the FIFO operation. Read/write to FIFO will be disabled when this bit is active. */
#define HLD_HOLD_1 0x1

/** Initialize FIFO - This bit reinitialize the read/write pointers to the reset value. Note that setting and releasing this bit must be synchronized by hardware to the respective clock domains of the input/output pointers. Note that proper initialization can only take place by ensuring HLD bit is 0. */
#define GLP_RX0FIFO_CFG_INIT_MASK 0x2
/** Normal Operation. */
#define INIT_INIT_0 0x0
/** Reset the FIFO pointers to the reset value. */
#define INIT_INIT_1 0x1

/** FIFO Enable - When disabled, the read/write pointers are also restored to the reset value. */
#define GLP_RX0FIFO_CFG_EN_MASK 0x1
/** Disable FIFO. */
#define EN_EN_0 0x0
/** Enable FIFO. */
#define EN_EN_1 0x1


/** 3GLP1 Input FIFO Configuration register - 3GLP TX FIFO Configuration register (from DFE to 3GLP macro 1) */
#define GLP_TX1FIFO_CFG (GLPTOP_BASE + 0x20)

/** FIFO Overflow status (sticky) */
#define GLP_TX1FIFO_CFG_OVF_MASK 0x80000000
/** no FIFO overflow detected. */
#define OVF_OVF_0 0x0
/** Some time in the past, the FIFO has detected overflow. DSP can clear this bit by writing '1'. */
#define OVF_OVF_1 0x1

/** FIFO Underflow status (sticky) */
#define GLP_TX1FIFO_CFG_UDF_MASK 0x10000000
/** no FIFO underflow detected. */
#define UDF_UDF_0 0x0
/** Some time in the past, the FIFO has detected underflow. DSP can clear this bit by writing '1'. */
#define UDF_UDF_1 0x1

/** FIFO Fill State - For debug purpose only. Provide information regarding the FIFO fill level. Unsigned integer. Norminally around 8, underflow threshold if below 4 and overflow threshold if over 12. */
#define GLP_TX1FIFO_CFG_STATE_MASK 0x1f0000

/** Debug FIFO */
#define GLP_TX1FIFO_CFG_DBG_MASK 0x8
/** normal operation. */
#define DBG_DBG_0 0x0
/** Disable the FIFO Feature where overflow/underflow detection is used to stop writing or ensure reading out only 0. Test purpose only. */
#define DBG_DBG_1 0x1

/** Hold FIFO */
#define GLP_TX1FIFO_CFG_HLD_MASK 0x4
/** Normal operation. */
#define HLD_HOLD_0 0x0
/** hold the FIFO operation. Read/write to FIFO will be disabled when this bit is active. */
#define HLD_HOLD_1 0x1

/** Initialize FIFO - This bit reinitialize the read/write pointers to the reset value. Note that setting and releasing this bit must be synchronized by hardware to the respective clock domains of the input/output pointers. Note that proper initialization can only take place by ensuring HLD bit is 0. */
#define GLP_TX1FIFO_CFG_INIT_MASK 0x2
/** Normal Operation. */
#define INIT_INIT_0 0x0
/** Reset the FIFO pointers to the reset value. */
#define INIT_INIT_1 0x1

/** FIFO Enable - When disabled, the read/write pointers are also restored to the reset value. */
#define GLP_TX1FIFO_CFG_EN_MASK 0x1
/** Disable FIFO. */
#define EN_EN_0 0x0
/** Enable FIFO. */
#define EN_EN_1 0x1


/** 3GLP1 Output FIFO Configuration register - 3GLP RX FIFO Configuration register (from 3GLP macro 1 to DFE) */
#define GLP_RX1FIFO_CFG (GLPTOP_BASE + 0x28)

/** FIFO Overflow status (sticky) */
#define GLP_RX1FIFO_CFG_OVF_MASK 0x80000000
/** no FIFO overflow detected. */
#define OVF_OVF_0 0x0
/** Some time in the past, the FIFO has detected overflow. DSP can clear this bit by writing '1'. */
#define OVF_OVF_1 0x1

/** FIFO Underflow status (sticky) */
#define GLP_RX1FIFO_CFG_UDF_MASK 0x10000000
/** no FIFO underflow detected. */
#define UDF_UDF_0 0x0
/** Some time in the past, the FIFO has detected underflow. DSP can clear this bit by writing '1'. */
#define UDF_UDF_1 0x1

/** FIFO Fill State - For debug purpose only. Provide information regarding the FIFO fill level. Unsigned integer. Norminally around 8, underflow threshold if below 4 and overflow threshold if over 12. */
#define GLP_RX1FIFO_CFG_STATE_MASK 0x1f0000

/** Debug FIFO */
#define GLP_RX1FIFO_CFG_DBG_MASK 0x8
/** normal operation. */
#define DBG_DBG_0 0x0
/** Disable the FIFO Feature where overflow/underflow detection is used to stop writing or ensure reading out only 0. Test purpose only. */
#define DBG_DBG_1 0x1

/** Hold FIFO */
#define GLP_RX1FIFO_CFG_HLD_MASK 0x4
/** Normal operation. */
#define HLD_HOLD_0 0x0
/** hold the FIFO operation. Read/write to FIFO will be disabled when this bit is active. */
#define HLD_HOLD_1 0x1

/** Initialize FIFO - This bit reinitialize the read/write pointers to the reset value. Note that setting and releasing this bit must be synchronized by hardware to the respective clock domains of the input/output pointers. Note that proper initialization can only take place by ensuring HLD bit is 0. */
#define GLP_RX1FIFO_CFG_INIT_MASK 0x2
/** Normal Operation. */
#define INIT_INIT_0 0x0
/** Reset the FIFO pointers to the reset value. */
#define INIT_INIT_1 0x1

/** FIFO Enable - When disabled, the read/write pointers are also restored to the reset value. */
#define GLP_RX1FIFO_CFG_EN_MASK 0x1
/** Disable FIFO. */
#define EN_EN_0 0x0
/** Enable FIFO. */
#define EN_EN_1 0x1


/** 3GLP Miscellaneous register - Reserved for test purpose. */
#define GLP_MISC_TOP (GLPTOP_BASE + 0x3c)

/** TestBit 7 - Reserved for test purpose */
#define GLP_MISC_TB7_MASK 0x80

/** TestBit 6 - Reserved for test purpose */
#define GLP_MISC_TB6_MASK 0x40

/** TestBit 5 - Reserved for test purpose */
#define GLP_MISC_TB5_MASK 0x20

/** TestBit 4 - Reserved for test purpose */
#define GLP_MISC_TB4_MASK 0x10

/** TestBit 3 - Reserved for test purpose */
#define GLP_MISC_TB3_MASK 0x8

/** TestBit 2 - Reserved for test purpose */
#define GLP_MISC_TB2_MASK 0x4

/** TestBit 1 - Port 1, default '0' is allowing RX FIFO port 1 enable to control the RX path 0 strobe to DFE. With '1' the RX path 0 strobe to DFE is always on regardless of the RXFIFO enable. */
#define GLP_MISC_TB1_MASK 0x2

/** TestBit 0 - Port 0, default '0' is allowing RX FIFO port 0 enable to control the RX path 0 strobe to DFE. With '1' the RX path 0 strobe to DFE is always on regardless of the RXFIFO enable. */
#define GLP_MISC_TB0_MASK 0x1

#endif /* _GLPTOP_H */
