/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VR9_AFE_ANALOG_REG_H
#define _VR9_AFE_ANALOG_REG_H


#define AFE_BASE 0x300

/** Control Register */
#define AGC1_RIN1 (AFE_BASE + 0x0)
#define AGC1_RIN1_AFE_GET VR9_AfeRead(AGC1_RIN1)
#define AGC1_RIN1_AFE_SET(val) VR9_AfeWrite(AGC1_RIN1, (val), 0xFFFF)

/** AGC1 Input Resistor INPUT A - Selects the input resistor of input path A in AGC1. */
#define AGC1_RIN1_AGC1_PRG_RIN1_MASK 0xffff
#define AGC1_RIN1_AGC1_PRG_RIN1_AFE_GET ((VR9_AfeRead(AGC1_RIN1) & AGC1_RIN1_AGC1_PRG_RIN1_MASK) >> 0)
#define AGC1_RIN1_AGC1_PRG_RIN1_AFE_SET(val) VR9_AfeWrite(AGC1_RIN1, (val) << 0, AGC1_RIN1_AGC1_PRG_RIN1_MASK)
/** RIN = OPEN */
#define AGC1_PRG_RIN1_RIN_A_OPEN 0x0
/** RIN = 2880Ohm */
#define AGC1_PRG_RIN1_RIN_A_2880OHM 0x1
/** RIN = 1440Ohm */
#define AGC1_PRG_RIN1_RIN_A_1440OHM 0x3
/** RIN = 960Ohm */
#define AGC1_PRG_RIN1_RIN_A_960OHM 0x7
/** RIN = 720Ohm */
#define AGC1_PRG_RIN1_RIN_A_720OHM 0xf
/** RIN = 576Ohm */
#define AGC1_PRG_RIN1_RIN_A_576OHM 0x1f
/** RIN = 480Ohm */
#define AGC1_PRG_RIN1_RIN_A_480OHM 0x3f
/** RIN = 411Ohm */
#define AGC1_PRG_RIN1_RIN_A_411OHM 0x7f
/** RIN = 360Ohm (default) */
#define AGC1_PRG_RIN1_RIN_A_360OHM 0xff
/** RIN = 320Ohm */
#define AGC1_PRG_RIN1_RIN_A_320OHM 0x1ff
/** RIN = 288Ohm */
#define AGC1_PRG_RIN1_RIN_A_288OHM 0x3ff
/** RIN = 262Ohm */
#define AGC1_PRG_RIN1_RIN_A_262OHM 0x7ff
/** RIN = 240Ohm */
#define AGC1_PRG_RIN1_RIN_A_240OHM 0xfff
/** RIN = 222OHM */
#define AGC1_PRG_RIN1_RIN_A_222OHM 0x1fff
/** RIN = 206Ohm */
#define AGC1_PRG_RIN1_RIN_A_206OHM 0x3fff
/** RIN = 192Ohm */
#define AGC1_PRG_RIN1_RIN_A_192OHM 0x7fff
/** RIN = 180Ohm */
#define AGC1_PRG_RIN1_RIN_A_180OHM 0xffff


/** Control Register */
#define AGC1_RIN2 (AFE_BASE + 0x1)
#define AGC1_RIN2_AFE_GET VR9_AfeRead(AGC1_RIN2)
#define AGC1_RIN2_AFE_SET(val) VR9_AfeWrite(AGC1_RIN2, (val), 0xFFFF)

/** AGC1 Input Resistor INPUT B - Selects the input resistor of input path B in AGC1. */
#define AGC1_RIN2_AGC1_PRG_RIN2_MASK 0xffff
#define AGC1_RIN2_AGC1_PRG_RIN2_AFE_GET ((VR9_AfeRead(AGC1_RIN2) & AGC1_RIN2_AGC1_PRG_RIN2_MASK) >> 0)
#define AGC1_RIN2_AGC1_PRG_RIN2_AFE_SET(val) VR9_AfeWrite(AGC1_RIN2, (val) << 0, AGC1_RIN2_AGC1_PRG_RIN2_MASK)
/** RIN = OPEN */
#define AGC1_PRG_RIN2_RIN_B_OPEN 0x0
/** RIN = 2880Ohm */
#define AGC1_PRG_RIN2_RIN_B_2880OHM 0x1
/** RIN = 1440Ohm */
#define AGC1_PRG_RIN2_RIN_B_1440OHM 0x3
/** RIN = 960Ohm */
#define AGC1_PRG_RIN2_RIN_B_960OHM 0x7
/** RIN = 720Ohm */
#define AGC1_PRG_RIN2_RIN_B_720OHM 0xf
/** RIN = 576Ohm */
#define AGC1_PRG_RIN2_RIN_B_576OHM 0x1f
/** RIN = 480Ohm */
#define AGC1_PRG_RIN2_RIN_B_480OHM 0x3f
/** RIN = 411Ohm */
#define AGC1_PRG_RIN2_RIN_B_411OHM 0x7f
/** RIN = 360Ohm (default) */
#define AGC1_PRG_RIN2_RIN_B_360OHM 0xff
/** RIN = 320Ohm */
#define AGC1_PRG_RIN2_RIN_B_320OHM 0x1ff
/** RIN = 288Ohm */
#define AGC1_PRG_RIN2_RIN_B_288OHM 0x3ff
/** RIN = 262Ohm */
#define AGC1_PRG_RIN2_RIN_B_262OHM 0x7ff
/** RIN = 240Ohm */
#define AGC1_PRG_RIN2_RIN_B_240OHM 0xfff
/** RIN = 222OHM */
#define AGC1_PRG_RIN2_RIN_B_222OHM 0x1fff
/** RIN = 206Ohm */
#define AGC1_PRG_RIN2_RIN_B_206OHM 0x3fff
/** RIN = 192Ohm */
#define AGC1_PRG_RIN2_RIN_B_192OHM 0x7fff
/** RIN = 180Ohm */
#define AGC1_PRG_RIN2_RIN_B_180OHM 0xffff


/** Control Register */
#define AGC1_RINX (AFE_BASE + 0x2)
#define AGC1_RINX_AFE_GET VR9_AfeRead(AGC1_RINX)
#define AGC1_RINX_AFE_SET(val) VR9_AfeWrite(AGC1_RINX, (val), 0xFFFF)

/** AGC1 Input Resistor INPUT C - Selects the input resistor of input path C in AGC1. */
#define AGC1_RINX_AGC1_PRG_RINX_MASK 0xffff
#define AGC1_RINX_AGC1_PRG_RINX_AFE_GET ((VR9_AfeRead(AGC1_RINX) & AGC1_RINX_AGC1_PRG_RINX_MASK) >> 0)
#define AGC1_RINX_AGC1_PRG_RINX_AFE_SET(val) VR9_AfeWrite(AGC1_RINX, (val) << 0, AGC1_RINX_AGC1_PRG_RINX_MASK)
/** RIN = OPEN */
#define AGC1_PRG_RINX_RIN_C_OPEN 0x0
/** RIN = 2880Ohm */
#define AGC1_PRG_RINX_RIN_C_2880OHM 0x1
/** RIN = 1440Ohm */
#define AGC1_PRG_RINX_RIN_C_1440OHM 0x3
/** RIN = 960Ohm */
#define AGC1_PRG_RINX_RIN_C_960OHM 0x7
/** RIN = 720Ohm */
#define AGC1_PRG_RINX_RIN_C_720OHM 0xf
/** RIN = 576Ohm */
#define AGC1_PRG_RINX_RIN_C_576OHM 0x1f
/** RIN = 480Ohm */
#define AGC1_PRG_RINX_RIN_C_480OHM 0x3f
/** RIN = 411Ohm */
#define AGC1_PRG_RINX_RIN_C_411OHM 0x7f
/** RIN = 360Ohm (default) */
#define AGC1_PRG_RINX_RIN_C_360OHM 0xff
/** RIN = 320Ohm */
#define AGC1_PRG_RINX_RIN_C_320OHM 0x1ff
/** RIN = 288Ohm */
#define AGC1_PRG_RINX_RIN_C_288OHM 0x3ff
/** RIN = 262Ohm */
#define AGC1_PRG_RINX_RIN_C_262OHM 0x7ff
/** RIN = 240Ohm */
#define AGC1_PRG_RINX_RIN_C_240OHM 0xfff
/** RIN = 222OHM */
#define AGC1_PRG_RINX_RIN_C_222OHM 0x1fff
/** RIN = 206Ohm */
#define AGC1_PRG_RINX_RIN_C_206OHM 0x3fff
/** RIN = 192Ohm */
#define AGC1_PRG_RINX_RIN_C_192OHM 0x7fff
/** RIN = 180Ohm */
#define AGC1_PRG_RINX_RIN_C_180OHM 0xffff


/** Control Register */
#define AGC1_ROUT2 (AFE_BASE + 0x3)
#define AGC1_ROUT2_AFE_GET VR9_AfeRead(AGC1_ROUT2)
#define AGC1_ROUT2_AFE_SET(val) VR9_AfeWrite(AGC1_ROUT2, (val), 0xFFFF)

/** AGC1 HP1 Output Resistor - Sets the value for the Output Resistor of AGC1 HP1. The value must be selected according to the AGC1 LP1 gain. */
#define AGC1_ROUT2_AGC1_PRG_ROUT2_MASK 0xffff
#define AGC1_ROUT2_AGC1_PRG_ROUT2_AFE_GET ((VR9_AfeRead(AGC1_ROUT2) & AGC1_ROUT2_AGC1_PRG_ROUT2_MASK) >> 0)
#define AGC1_ROUT2_AGC1_PRG_ROUT2_AFE_SET(val) VR9_AfeWrite(AGC1_ROUT2, (val) << 0, AGC1_ROUT2_AGC1_PRG_ROUT2_MASK)
/** OPEN */
#define AGC1_PRG_ROUT2_AGC1_HP1_OPEN 0x0
/** AGC1 LP1 gain = 27dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_27DB 0x1
/** AGC1 LP1 gain = 26dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_26DB 0x3
/** AGC1 LP1 gain = 25dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_25DB 0x7
/** AGC1 LP1 gain = 24dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_24DB 0xf
/** AGC1 LP1 gain = 23dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_23DB 0x1f
/** AGC1 LP1 gain = 22dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_22DB 0x3f
/** AGC1 LP1 gain = 21dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_21DB 0x7f
/** AGC1 LP1 gain = 20dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_20DB 0xff
/** AGC1 LP1 gain = 19dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_19DB 0x1ff
/** AGC1 LP1 gain = 18dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_18DB 0x3ff
/** AGC1 LP1 gain = 17dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_17DB 0x7ff
/** AGC1 LP1 gain = 16dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_16DB 0xfff
/** AGC1 LP1 gain = 15dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_15DB 0x1fff
/** AGC1 LP1 gain = 14dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_14DB 0x3fff
/** AGC1 LP1 gain = 13dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_13DB 0x7fff
/** AGC1 LP1 gain = 12dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_12DB 0xffff
/** AGC1 LP1 gain = 11dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_11DB 0xffff
/** AGC1 LP1 gain = 10dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_10DB 0xffff
/** AGC1 LP1 gain = 9dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_9DB 0xffff
/** AGC1 LP1 gain = 8dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_8DB 0xffff
/** AGC1 LP1 gain = 7dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_7DB 0xffff
/** AGC1 LP1 gain = 6dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_6DB 0xffff
/** AGC1 LP1 gain = 5dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_5DB 0xffff
/** AGC1 LP1 gain = 4dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_4DB 0xffff
/** AGC1 LP1 gain = 3dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_3DB 0xffff
/** AGC1 LP1 gain = 2dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_2DB 0xffff
/** AGC1 LP1 gain = 1dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_1DB 0xffff
/** AGC1 LP1 gain = 0dB (default) */
#define AGC1_PRG_ROUT2_AGC1_HP1_0DB 0xffff
/** AGC1 LP1 gain = -3dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_M3DB 0xffff
/** AGC1 LP1 gain = -6dB */
#define AGC1_PRG_ROUT2_AGC1_HP1_M6DB 0xffff


/** Control Register */
#define AGC1_SHUNT1 (AFE_BASE + 0x4)
#define AGC1_SHUNT1_AFE_GET VR9_AfeRead(AGC1_SHUNT1)
#define AGC1_SHUNT1_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNT1, (val), 0xFFFF)

/** AGC1 INPUT A On/Off - Enables/Disables the input path A in AGC1. */
#define AGC1_SHUNT1_AGC1_PRG_IN1_SWITCH_MASK 0x8000
#define AGC1_SHUNT1_AGC1_PRG_IN1_SWITCH_AFE_GET ((VR9_AfeRead(AGC1_SHUNT1) & AGC1_SHUNT1_AGC1_PRG_IN1_SWITCH_MASK) >> 15)
#define AGC1_SHUNT1_AGC1_PRG_IN1_SWITCH_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNT1, (val) << 15, AGC1_SHUNT1_AGC1_PRG_IN1_SWITCH_MASK)
/** input path is disabled (shortcut of differential signal lines and set to 1.65V (=3.3V/2)) */
#define AGC1_PRG_IN1_SWITCH_AGC1_A_DISABLE 0x1
/** normal operation, input path is enabled (default) */
#define AGC1_PRG_IN1_SWITCH_AGC1_A_ENABLE 0x0

/** AGC1 Shunt Resistor INPUT A - Selects the shunt resistor of input path A in AGC1. */
#define AGC1_SHUNT1_AGC1_PRG_RSHUNT1_MASK 0x7fff
#define AGC1_SHUNT1_AGC1_PRG_RSHUNT1_AFE_GET ((VR9_AfeRead(AGC1_SHUNT1) & AGC1_SHUNT1_AGC1_PRG_RSHUNT1_MASK) >> 0)
#define AGC1_SHUNT1_AGC1_PRG_RSHUNT1_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNT1, (val) << 0, AGC1_SHUNT1_AGC1_PRG_RSHUNT1_MASK)
/** RSHUNT = OPEN (default) */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_OPEN 0x0
/** RSHUNT = 360Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_360OHM 0xff
/** RSHUNT = 411Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_411OHM 0xfe
/** RSHUNT = 480Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_480OHM 0xfc
/** RSHUNT = 576Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_576OHM 0xf8
/** RSHUNT = 720Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_720OHM 0xf0
/** RSHUNT = 960Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_960OHM 0xe0
/** RSHUNT = 1440Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_1440OHM 0xc0
/** RSHUNT = 2880Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_2880OHM 0x80
/** RSHUNT = 5760Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_5760OHM 0x100
/** RSHUNT = 8640Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_8640OHM 0x200
/** RSHUNT = 11520Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_11520OHM 0x400
/** RSHUNT = 14400Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_14400OHM 0x800
/** RSHUNT = 17280Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_17280OHM 0x1000
/** RSHUNT = 20160Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_20160OHM 0x2000
/** RSHUNT = 23040Ohm */
#define AGC1_PRG_RSHUNT1_RSHUNT_A_23040OHM 0x4000


/** Control Register */
#define AGC1_SHUNT2 (AFE_BASE + 0x5)
#define AGC1_SHUNT2_AFE_GET VR9_AfeRead(AGC1_SHUNT2)
#define AGC1_SHUNT2_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNT2, (val), 0xFFFF)

/** AGC1 INPUT B On/Off - Enables/Disables the input path B in AGC1. */
#define AGC1_SHUNT2_AGC1_PRG_IN2_SWITCH_MASK 0x8000
#define AGC1_SHUNT2_AGC1_PRG_IN2_SWITCH_AFE_GET ((VR9_AfeRead(AGC1_SHUNT2) & AGC1_SHUNT2_AGC1_PRG_IN2_SWITCH_MASK) >> 15)
#define AGC1_SHUNT2_AGC1_PRG_IN2_SWITCH_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNT2, (val) << 15, AGC1_SHUNT2_AGC1_PRG_IN2_SWITCH_MASK)
/** input path is disabled (shortcut of differential signal lines and set to 1.65V (=3.3V/2)) */
#define AGC1_PRG_IN2_SWITCH_AGC1_B_DISABLE 0x1
/** normal operation, input path is enabled (default) */
#define AGC1_PRG_IN2_SWITCH_AGC1_B_ENABLE 0x0

/** AGC1 Shunt Resistor INPUT B - Selects the shunt resistor of input path B in AGC1. */
#define AGC1_SHUNT2_AGC1_PRG_RSHUNT2_MASK 0x7fff
#define AGC1_SHUNT2_AGC1_PRG_RSHUNT2_AFE_GET ((VR9_AfeRead(AGC1_SHUNT2) & AGC1_SHUNT2_AGC1_PRG_RSHUNT2_MASK) >> 0)
#define AGC1_SHUNT2_AGC1_PRG_RSHUNT2_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNT2, (val) << 0, AGC1_SHUNT2_AGC1_PRG_RSHUNT2_MASK)
/** RSHUNT = OPEN (default) */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_OPEN 0x0
/** RSHUNT = 360Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_360OHM 0xff
/** RSHUNT = 411Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_411OHM 0xfe
/** RSHUNT = 480Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_480OHM 0xfc
/** RSHUNT = 576Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_576OHM 0xf8
/** RSHUNT = 720Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_720OHM 0xf0
/** RSHUNT = 960Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_960OHM 0xe0
/** RSHUNT = 1440Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_1440OHM 0xc0
/** RSHUNT = 2880Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_2880OHM 0x80
/** RSHUNT = 5760Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_5760OHM 0x100
/** RSHUNT = 8640Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_8640OHM 0x200
/** RSHUNT = 11520Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_11520OHM 0x400
/** RSHUNT = 14400Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_14400OHM 0x800
/** RSHUNT = 17280Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_17280OHM 0x1000
/** RSHUNT = 20160Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_20160OHM 0x2000
/** RSHUNT = 23040Ohm */
#define AGC1_PRG_RSHUNT2_RSHUNT_B_23040OHM 0x4000


/** Control Register */
#define AGC1_SHUNTX (AFE_BASE + 0x6)
#define AGC1_SHUNTX_AFE_GET VR9_AfeRead(AGC1_SHUNTX)
#define AGC1_SHUNTX_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNTX, (val), 0xFFFF)

/** AGC1 INPUT C On/Off - Enables/Disables the input path C in AGC1. */
#define AGC1_SHUNTX_AGC1_PRG_INX_SWITCH_MASK 0x8000
#define AGC1_SHUNTX_AGC1_PRG_INX_SWITCH_AFE_GET ((VR9_AfeRead(AGC1_SHUNTX) & AGC1_SHUNTX_AGC1_PRG_INX_SWITCH_MASK) >> 15)
#define AGC1_SHUNTX_AGC1_PRG_INX_SWITCH_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNTX, (val) << 15, AGC1_SHUNTX_AGC1_PRG_INX_SWITCH_MASK)
/** input path is disabled (shortcut of differential signal lines and set to 1.65V (=3.3V/2)) */
#define AGC1_PRG_INX_SWITCH_AGC1_C_DISABLE 0x1
/** normal operation, input path is enabled (default) */
#define AGC1_PRG_INX_SWITCH_AGC1_C_ENABLE 0x0

/** AGC1 Shunt Resistor INPUT C - Selects the shunt resistor of input path C in AGC1. */
#define AGC1_SHUNTX_AGC1_PRG_RSHUNTX_MASK 0x7fff
#define AGC1_SHUNTX_AGC1_PRG_RSHUNTX_AFE_GET ((VR9_AfeRead(AGC1_SHUNTX) & AGC1_SHUNTX_AGC1_PRG_RSHUNTX_MASK) >> 0)
#define AGC1_SHUNTX_AGC1_PRG_RSHUNTX_AFE_SET(val) VR9_AfeWrite(AGC1_SHUNTX, (val) << 0, AGC1_SHUNTX_AGC1_PRG_RSHUNTX_MASK)
/** RSHUNT = OPEN (default) */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_OPEN 0x0
/** RSHUNT = 360Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_360OHM 0xff
/** RSHUNT = 411Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_411OHM 0xfe
/** RSHUNT = 480Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_480OHM 0xfc
/** RSHUNT = 576Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_576OHM 0xf8
/** RSHUNT = 720Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_720OHM 0xf0
/** RSHUNT = 960Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_960OHM 0xe0
/** RSHUNT = 1440Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_1440OHM 0xc0
/** RSHUNT = 2880Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_2880OHM 0x80
/** RSHUNT = 5760Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_5760OHM 0x100
/** RSHUNT = 8640Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_8640OHM 0x200
/** RSHUNT = 11520Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_11520OHM 0x400
/** RSHUNT = 14400Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_14400OHM 0x800
/** RSHUNT = 17280Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_17280OHM 0x1000
/** RSHUNT = 20160Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_20160OHM 0x2000
/** RSHUNT = 23040Ohm */
#define AGC1_PRG_RSHUNTX_RSHUNT_C_23040OHM 0x4000


/** Control Register */
#define AGC1_CPROG (AFE_BASE + 0x7)
#define AGC1_CPROG_AFE_GET VR9_AfeRead(AGC1_CPROG)
#define AGC1_CPROG_AFE_SET(val) VR9_AfeWrite(AGC1_CPROG, (val), 0xFFFF)

/** AGC1 Levelshifter Power Down - Sets the Power Down Mode for the Levelshifter of the input network in AGC1. */
#define AGC1_CPROG_AGC1_PD_LS_MASK 0x8000
#define AGC1_CPROG_AGC1_PD_LS_AFE_GET ((VR9_AfeRead(AGC1_CPROG) & AGC1_CPROG_AGC1_PD_LS_MASK) >> 15)
#define AGC1_CPROG_AGC1_PD_LS_AFE_SET(val) VR9_AfeWrite(AGC1_CPROG, (val) << 15, AGC1_CPROG_AGC1_PD_LS_MASK)
/** Power Up */
#define AGC1_PD_LS_AGC1_LEVELSHIFT_PU 0x0
/** Power Down (default) */
#define AGC1_PD_LS_AGC1_LEVELSHIFT_PD 0x1

/** AGC1 Input Capacitor INPUT C - Selects the input capacitor of input path C in AGC1. */
#define AGC1_CPROG_AGC1_PRG_CINX_MASK 0x7000
#define AGC1_CPROG_AGC1_PRG_CINX_AFE_GET ((VR9_AfeRead(AGC1_CPROG) & AGC1_CPROG_AGC1_PRG_CINX_MASK) >> 12)
#define AGC1_CPROG_AGC1_PRG_CINX_AFE_SET(val) VR9_AfeWrite(AGC1_CPROG, (val) << 12, AGC1_CPROG_AGC1_PRG_CINX_MASK)
/** CIN = OPEN (default) */
#define AGC1_PRG_CINX_CIN_C_OPEN 0x0
/** CIN = 10pF */
#define AGC1_PRG_CINX_CIN_C_10PF 0x1
/** CIN = 20pF */
#define AGC1_PRG_CINX_CIN_C_20PF 0x2
/** CIN = 30pF */
#define AGC1_PRG_CINX_CIN_C_30PF 0x3
/** CIN = 40pF */
#define AGC1_PRG_CINX_CIN_C_40PF 0x6
/** CIN = 50pF */
#define AGC1_PRG_CINX_CIN_C_50PF 0x7

/** AGC1 Input Capacitor INPUT B - Selects the input capacitor of input path B in AGC1. */
#define AGC1_CPROG_AGC1_PRG_CIN2_MASK 0xf00
#define AGC1_CPROG_AGC1_PRG_CIN2_AFE_GET ((VR9_AfeRead(AGC1_CPROG) & AGC1_CPROG_AGC1_PRG_CIN2_MASK) >> 8)
#define AGC1_CPROG_AGC1_PRG_CIN2_AFE_SET(val) VR9_AfeWrite(AGC1_CPROG, (val) << 8, AGC1_CPROG_AGC1_PRG_CIN2_MASK)
/** CIN = OPEN (default) */
#define AGC1_PRG_CIN2_CIN_B_OPEN 0x0
/** CIN = 1pF */
#define AGC1_PRG_CIN2_CIN_B_1PF 0x1
/** CIN = 2pF */
#define AGC1_PRG_CIN2_CIN_B_2PF 0x2
/** CIN = 3pF */
#define AGC1_PRG_CIN2_CIN_B_3PF 0x3
/** CIN = 4pF */
#define AGC1_PRG_CIN2_CIN_B_4PF 0x4
/** CIN = 5pF */
#define AGC1_PRG_CIN2_CIN_B_5PF 0x5
/** CIN = 6pF */
#define AGC1_PRG_CIN2_CIN_B_6PF 0x6
/** CIN = 7pF */
#define AGC1_PRG_CIN2_CIN_B_7PF 0x7
/** CIN = 8pF */
#define AGC1_PRG_CIN2_CIN_B_8PF 0x8
/** CIN = 9pF */
#define AGC1_PRG_CIN2_CIN_B_9PF 0x9
/** CIN = 10pF */
#define AGC1_PRG_CIN2_CIN_B_10PF 0xa
/** CIN = 11pF */
#define AGC1_PRG_CIN2_CIN_B_11PF 0xb
/** CIN = 12pF */
#define AGC1_PRG_CIN2_CIN_B_12PF 0xc
/** CIN = 13pF */
#define AGC1_PRG_CIN2_CIN_B_13PF 0xd
/** CIN = 14pF */
#define AGC1_PRG_CIN2_CIN_B_14PF 0xe
/** CIN = 15pF */
#define AGC1_PRG_CIN2_CIN_B_15PF 0xf

/** AGC1 LP1 Cutoff Frequency - Selects the cutoff frequency of LP1 in AGC1. The programming is binary coded. */
#define AGC1_CPROG_AGC1_PRG_CFB_MASK 0x7f
#define AGC1_CPROG_AGC1_PRG_CFB_AFE_GET ((VR9_AfeRead(AGC1_CPROG) & AGC1_CPROG_AGC1_PRG_CFB_MASK) >> 0)
#define AGC1_CPROG_AGC1_PRG_CFB_AFE_SET(val) VR9_AfeWrite(AGC1_CPROG, (val) << 0, AGC1_CPROG_AGC1_PRG_CFB_MASK)
/** maximum cutoff frequency (default) */
#define AGC1_PRG_CFB_AGC1_LP1_CUTOFF_MAX 0x0
/** minimum cutoff frequency */
#define AGC1_PRG_CFB_AGC1_LP1_CUTOFF_MIN 0x7f


/** Control Register */
#define AGC1_GAIN (AFE_BASE + 0x8)
#define AGC1_GAIN_AFE_GET VR9_AfeRead(AGC1_GAIN)
#define AGC1_GAIN_AFE_SET(val) VR9_AfeWrite(AGC1_GAIN, (val), 0xFFFF)

/** AGC1 LP1 Power Down - Sets the Power Down Mode for LP1 in AGC1. */
#define AGC1_GAIN_AGC1_PD_OP1_MASK 0x8000
#define AGC1_GAIN_AGC1_PD_OP1_AFE_GET ((VR9_AfeRead(AGC1_GAIN) & AGC1_GAIN_AGC1_PD_OP1_MASK) >> 15)
#define AGC1_GAIN_AGC1_PD_OP1_AFE_SET(val) VR9_AfeWrite(AGC1_GAIN, (val) << 15, AGC1_GAIN_AGC1_PD_OP1_MASK)
/** Power Up */
#define AGC1_PD_OP1_AGC1_LP1_PU 0x0
/** Power Down (default) */
#define AGC1_PD_OP1_AGC1_LP1_PD 0x1

/** AGC1 Speed Up of Power Up - Enables/Disables the recovery circuit for the common mode voltage during the Power Up phase of the operational amplifier in AGC1. */
#define AGC1_GAIN_AGC1_INHIBIT_UNLOCK_MASK 0x4000
#define AGC1_GAIN_AGC1_INHIBIT_UNLOCK_AFE_GET ((VR9_AfeRead(AGC1_GAIN) & AGC1_GAIN_AGC1_INHIBIT_UNLOCK_MASK) >> 14)
#define AGC1_GAIN_AGC1_INHIBIT_UNLOCK_AFE_SET(val) VR9_AfeWrite(AGC1_GAIN, (val) << 14, AGC1_GAIN_AGC1_INHIBIT_UNLOCK_MASK)
/** Enabled (default) */
#define AGC1_INHIBIT_UNLOCK_AGC1_PU_SPEEDUP_ENABLE 0x0
/** Disabled */
#define AGC1_INHIBIT_UNLOCK_AGC1_PU_SPEEDUP_DISABLE 0x1

/** AGC1 LP1 Gain - Selects the gain of LP1 in AGC1. */
#define AGC1_GAIN_AGC1_PRG_GAIN_MASK 0x3fff
#define AGC1_GAIN_AGC1_PRG_GAIN_AFE_GET ((VR9_AfeRead(AGC1_GAIN) & AGC1_GAIN_AGC1_PRG_GAIN_MASK) >> 0)
#define AGC1_GAIN_AGC1_PRG_GAIN_AFE_SET(val) VR9_AfeWrite(AGC1_GAIN, (val) << 0, AGC1_GAIN_AGC1_PRG_GAIN_MASK)
/** GAIN = 27dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_27DB 0x2000
/** GAIN = 26dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_26DB 0x1000
/** GAIN = 25dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_25DB 0x800
/** GAIN = 24dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_24DB 0x100
/** GAIN = 23dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_23DB 0x4
/** GAIN = 22dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_22DB 0x200
/** GAIN = 21dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_21DB 0x80
/** GAIN = 20dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_20DB 0x140
/** GAIN = 19dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_19DB 0x50
/** GAIN = 18dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_18DB 0xc0
/** GAIN = 17dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_17DB 0x14
/** GAIN = 16dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_16DB 0x210
/** GAIN = 15dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_15DB 0xa0
/** GAIN = 14dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_14DB 0x64
/** GAIN = 13dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_13DB 0x94
/** GAIN = 12dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_12DB 0xb0
/** GAIN = 11dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_11DB 0xd4
/** GAIN = 10dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_10DB 0x308
/** GAIN = 9dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_9DB 0xa8
/** GAIN = 8dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_8DB 0xe8
/** GAIN = 7dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_7DB 0x1e8
/** GAIN = 6dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_6DB 0xbc
/** GAIN = 5dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_5DB 0xa2
/** GAIN = 4dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_4DB 0x1e2
/** GAIN = 3dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_3DB 0xaa
/** GAIN = 2dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_2DB 0xba
/** GAIN = 1dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_1DB 0xbe
/** GAIN = 0dB (default) */
#define AGC1_PRG_GAIN_AGC1_GAIN_0DB 0x1fe
/** GAIN = -3dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_M3DB 0xab
/** GAIN = -6dB */
#define AGC1_PRG_GAIN_AGC1_GAIN_M6DB 0x7F6


/** Control Register */
#define AGC1_HP (AFE_BASE + 0x9)
#define AGC1_HP_AFE_GET VR9_AfeRead(AGC1_HP)
#define AGC1_HP_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val), 0xFFFF)

/** AGC1 HP1 Power Down - Sets the Power Down Mode of HP1 in AGC1. */
#define AGC1_HP_AGC1_PD_OP2_MASK 0x8000
#define AGC1_HP_AGC1_PD_OP2_AFE_GET ((VR9_AfeRead(AGC1_HP) & AGC1_HP_AGC1_PD_OP2_MASK) >> 15)
#define AGC1_HP_AGC1_PD_OP2_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val) << 15, AGC1_HP_AGC1_PD_OP2_MASK)
/** Power Up */
#define AGC1_PD_OP2_AGC1_HP1_PU 0x0
/** Power Down (default) */
#define AGC1_PD_OP2_AGC1_HP1_PD 0x1

/** AGC1 Output Stage Current Opamp HP1 - Programs the current in the output stage of the operational amplifier of HP1 in AGC1.The programming is binary coded. */
#define AGC1_HP_AGC1_PRG_OP2_IOUT_MASK 0x7000
#define AGC1_HP_AGC1_PRG_OP2_IOUT_AFE_GET ((VR9_AfeRead(AGC1_HP) & AGC1_HP_AGC1_PRG_OP2_IOUT_MASK) >> 12)
#define AGC1_HP_AGC1_PRG_OP2_IOUT_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val) << 12, AGC1_HP_AGC1_PRG_OP2_IOUT_MASK)
/** minimum current */
#define AGC1_PRG_OP2_IOUT_AGC1_HP1_OP_IOUT_MIN 0x0
/** nominal current (default) */
#define AGC1_PRG_OP2_IOUT_AGC1_HP1_OP_IOUT_DEFAULT 0x1
/** maximum current */
#define AGC1_PRG_OP2_IOUT_AGC1_HP1_OP_IOUT_MAX 0x7

/** AGC1 Input Stage Current Opamp HP1 - Programs the current in the input and common mode stage of the operational amplifier of HP1 in AGC1.The programming is binary coded. */
#define AGC1_HP_AGC1_PRG_OP2_IIN_MASK 0xc00
#define AGC1_HP_AGC1_PRG_OP2_IIN_AFE_GET ((VR9_AfeRead(AGC1_HP) & AGC1_HP_AGC1_PRG_OP2_IIN_MASK) >> 10)
#define AGC1_HP_AGC1_PRG_OP2_IIN_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val) << 10, AGC1_HP_AGC1_PRG_OP2_IIN_MASK)
/** minimum current */
#define AGC1_PRG_OP2_IIN_AGC1_HP1_OP_IIN_MIN 0x0
/** nominal current (default) */
#define AGC1_PRG_OP2_IIN_AGC1_HP1_OP_IIN_DEFAULT 0x1
/** maximum current */
#define AGC1_PRG_OP2_IIN_AGC1_HP1_OP_IIN_MAX 0x3

/** AGC1 Miller Capacitor Opamp HP1 - Programs the Miller Capacitor in the operational amplifier of HP1 in AGC1. */
#define AGC1_HP_AGC1_PRG_OP2_CC_MASK 0x100
#define AGC1_HP_AGC1_PRG_OP2_CC_AFE_GET ((VR9_AfeRead(AGC1_HP) & AGC1_HP_AGC1_PRG_OP2_CC_MASK) >> 8)
#define AGC1_HP_AGC1_PRG_OP2_CC_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val) << 8, AGC1_HP_AGC1_PRG_OP2_CC_MASK)
/** minimum */
#define AGC1_PRG_OP2_CC_AGC1_HP1_OP_CMILLER_MIN 0x0
/** maximum (default) */
#define AGC1_PRG_OP2_CC_AGC1_HP1_OP_CMILLER_MAX 0x1

/** AGC1 Levelshifter Voltage - Selects the voltage shift done by the levelshifter in AGC1. */
#define AGC1_HP_AGC1_PRG_LEVSHIFTVSH_MASK 0xc0
#define AGC1_HP_AGC1_PRG_LEVSHIFTVSH_AFE_GET ((VR9_AfeRead(AGC1_HP) & AGC1_HP_AGC1_PRG_LEVSHIFTVSH_MASK) >> 6)
#define AGC1_HP_AGC1_PRG_LEVSHIFTVSH_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val) << 6, AGC1_HP_AGC1_PRG_LEVSHIFTVSH_MASK)
/** voltage shift VDD-200mV (default) */
#define AGC1_PRG_LEVSHIFTVSH_AGC1_LVLSHIFT_VDD_M_200MV 0x0
/** voltage shift VDD-270mV */
#define AGC1_PRG_LEVSHIFTVSH_AGC1_LVLSHIFT_VDD_M_270MV 0x1
/** voltage shift VDD-340mV */
#define AGC1_PRG_LEVSHIFTVSH_AGC1_LVLSHIFT_VDD_M_340MV 0x2
/** voltage shift VDD-410mV */
#define AGC1_PRG_LEVSHIFTVSH_AGC1_LVLSHIFT_VDD_M_410MV 0x3

/** AGC1 HP1 Input Resistor Setting - Selects the input resistor of the AGC1 HP1. */
#define AGC1_HP_AGC1_PRG_HPRIN_MASK 0x30
#define AGC1_HP_AGC1_PRG_HPRIN_AFE_GET ((VR9_AfeRead(AGC1_HP) & AGC1_HP_AGC1_PRG_HPRIN_MASK) >> 4)
#define AGC1_HP_AGC1_PRG_HPRIN_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val) << 4, AGC1_HP_AGC1_PRG_HPRIN_MASK)
/** OPEN (default) */
#define AGC1_PRG_HPRIN_AGC1_HP1_R_OPEN 0x0
/** 22.5kOhm */
#define AGC1_PRG_HPRIN_AGC1_HP1_R_22K5OHM 0x1
/** 17.5kOhm */
#define AGC1_PRG_HPRIN_AGC1_HP1_R_17K5OHM 0x2

/** AGC1 HP1 Feedback Capacitor Setting - Selects the feedback capacitor of the AGC1 HP1. */
#define AGC1_HP_AGC1_PRG_HPCAP_MASK 0x7
#define AGC1_HP_AGC1_PRG_HPCAP_AFE_GET ((VR9_AfeRead(AGC1_HP) & AGC1_HP_AGC1_PRG_HPCAP_MASK) >> 0)
#define AGC1_HP_AGC1_PRG_HPCAP_AFE_SET(val) VR9_AfeWrite(AGC1_HP, (val) << 0, AGC1_HP_AGC1_PRG_HPCAP_MASK)
/** OPEN (default) */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_OPEN 0x0
/** 10pF */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_10PF 0x4
/** 20pF */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_20PF 0x2
/** 30pF */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_30PF 0x6
/** 70pF */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_70PF 0x1
/** 80pF */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_80PF 0x5
/** 90pF */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_90PF 0x3
/** 100pF */
#define AGC1_PRG_HPCAP_AGC1_HP1_CAP_100PF 0x7


/** Control Register */
#define AGC1_OP1_CURR (AFE_BASE + 0xa)
#define AGC1_OP1_CURR_AFE_GET VR9_AfeRead(AGC1_OP1_CURR)
#define AGC1_OP1_CURR_AFE_SET(val) VR9_AfeWrite(AGC1_OP1_CURR, (val), 0xFFFF)

/** AGC1 Mode of Opamp LP1 - Selects the Mode (VDSL/ADSL) of the operational amplifier of LP1 in AGC1. */
#define AGC1_OP1_CURR_AGC1_VDSL_MASK 0x8000
#define AGC1_OP1_CURR_AGC1_VDSL_AFE_GET ((VR9_AfeRead(AGC1_OP1_CURR) & AGC1_OP1_CURR_AGC1_VDSL_MASK) >> 15)
#define AGC1_OP1_CURR_AGC1_VDSL_AFE_SET(val) VR9_AfeWrite(AGC1_OP1_CURR, (val) << 15, AGC1_OP1_CURR_AGC1_VDSL_MASK)
/** ADSL Mode = low 1/f noise */
#define AGC1_VDSL_AGC1_ADSL 0x0
/** VDSL Mode = high bandwidth (default) */
#define AGC1_VDSL_AGC1_VDSL 0x1

/** AGC1 Input Stage Current Opamp LP1 - Programs the current in the input stage of the operational amplifier of LP1 in AGC1.The programming is binary coded. */
#define AGC1_OP1_CURR_AGC1_PRG_OP1_IIN_MASK 0x7000
#define AGC1_OP1_CURR_AGC1_PRG_OP1_IIN_AFE_GET ((VR9_AfeRead(AGC1_OP1_CURR) & AGC1_OP1_CURR_AGC1_PRG_OP1_IIN_MASK) >> 12)
#define AGC1_OP1_CURR_AGC1_PRG_OP1_IIN_AFE_SET(val) VR9_AfeWrite(AGC1_OP1_CURR, (val) << 12, AGC1_OP1_CURR_AGC1_PRG_OP1_IIN_MASK)
/** minimum current */
#define AGC1_PRG_OP1_IIN_AGC1_LP1_OP_IIN_MIN 0x0
/** nominal current (default) */
#define AGC1_PRG_OP1_IIN_AGC1_LP1_OP_IIN_DEFAULT 0x3
/** maximum current */
#define AGC1_PRG_OP1_IIN_AGC1_LP1_OP_IIN_MAX 0x7

/** AGC1 Output Stage Current Opamp LP1 - Programs the current in the output stage of the operational amplifier of LP1 in AGC1.The programming is binary coded. */
#define AGC1_OP1_CURR_AGC1_PRG_OP1_IOUT_MASK 0xf00
#define AGC1_OP1_CURR_AGC1_PRG_OP1_IOUT_AFE_GET ((VR9_AfeRead(AGC1_OP1_CURR) & AGC1_OP1_CURR_AGC1_PRG_OP1_IOUT_MASK) >> 8)
#define AGC1_OP1_CURR_AGC1_PRG_OP1_IOUT_AFE_SET(val) VR9_AfeWrite(AGC1_OP1_CURR, (val) << 8, AGC1_OP1_CURR_AGC1_PRG_OP1_IOUT_MASK)
/** maximum current (default) */
#define AGC1_PRG_OP1_IOUT_AGC1_LP1_OP_IOUT_MAX 0x0
/** minimum current */
#define AGC1_PRG_OP1_IOUT_AGC1_LP1_OP_IOUT_MIN 0xf

/** AGC1 Common Mode Stage Current Opamp LP1 - Programs the current in the common mode stage of the operational amplifier of LP1 in AGC1.The programming is binary coded. */
#define AGC1_OP1_CURR_AGC1_PRG_OP1_ICM_MASK 0xf0
#define AGC1_OP1_CURR_AGC1_PRG_OP1_ICM_AFE_GET ((VR9_AfeRead(AGC1_OP1_CURR) & AGC1_OP1_CURR_AGC1_PRG_OP1_ICM_MASK) >> 4)
#define AGC1_OP1_CURR_AGC1_PRG_OP1_ICM_AFE_SET(val) VR9_AfeWrite(AGC1_OP1_CURR, (val) << 4, AGC1_OP1_CURR_AGC1_PRG_OP1_ICM_MASK)
/** minimum current */
#define AGC1_PRG_OP1_ICM_AGC1_LP1_OP_ICM_MIN 0x0
/** nominal current (default) */
#define AGC1_PRG_OP1_ICM_AGC1_LP1_OP_ICM_DEFAULT 0x9
/** maximum current */
#define AGC1_PRG_OP1_ICM_AGC1_LP1_OP_ICM_MAX 0xf

/** AGC1 Miller Capacitor Opamp LP1 - Programs the Miller Capacitor in the operational amplifier of LP1 in AGC1. */
#define AGC1_OP1_CURR_AGC1_PRG_OP1_CC_MASK 0xf
#define AGC1_OP1_CURR_AGC1_PRG_OP1_CC_AFE_GET ((VR9_AfeRead(AGC1_OP1_CURR) & AGC1_OP1_CURR_AGC1_PRG_OP1_CC_MASK) >> 0)
#define AGC1_OP1_CURR_AGC1_PRG_OP1_CC_AFE_SET(val) VR9_AfeWrite(AGC1_OP1_CURR, (val) << 0, AGC1_OP1_CURR_AGC1_PRG_OP1_CC_MASK)
/** minimum */
#define AGC1_PRG_OP1_CC_AGC1_LP1_OP_CMILLER_MIN 0x0
/** nominal (default) */
#define AGC1_PRG_OP1_CC_AGC1_LP1_OP_CMILLER_DEFAULT 0x2
/** maximum */
#define AGC1_PRG_OP1_CC_AGC1_LP1_OP_CMILLER_MAX 0xf


/** Control Register */
#define TBUF_RCTUNING (AFE_BASE + 0x10)
#define TBUF_RCTUNING_AFE_GET VR9_AfeRead(TBUF_RCTUNING)
#define TBUF_RCTUNING_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val), 0xFFFF)

/** RC TUNING Power Down - Sets the Power Down Mode for RC measurement block */
#define TBUF_RCTUNING_RCTUNING_PD_MASK 0x8000
#define TBUF_RCTUNING_RCTUNING_PD_AFE_GET ((VR9_AfeRead(TBUF_RCTUNING) & TBUF_RCTUNING_RCTUNING_PD_MASK) >> 15)
#define TBUF_RCTUNING_RCTUNING_PD_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val) << 15, TBUF_RCTUNING_RCTUNING_PD_MASK)
/** Power Up */
#define RCTUNING_PD_RCTUNING_PU 0x0
/** Power Down (default) */
#define RCTUNING_PD_RCTUNING_PD 0x1

/** RC TUNING Calibration Mode - Sets the calibration mode for RC measurement */
#define TBUF_RCTUNING_RCTUNING_CALIB_MASK 0x1000
#define TBUF_RCTUNING_RCTUNING_CALIB_AFE_GET ((VR9_AfeRead(TBUF_RCTUNING) & TBUF_RCTUNING_RCTUNING_CALIB_MASK) >> 12)
#define TBUF_RCTUNING_RCTUNING_CALIB_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val) << 12, TBUF_RCTUNING_RCTUNING_CALIB_MASK)
/** calibration mode OFF (default) */
#define RCTUNING_CALIB_RC_CALIB_OFF 0x0
/** calibration mode ON */
#define RCTUNING_CALIB_RC_CALIB_ON 0x1

/** TESTBUFFER Power Down - Sets the Power Down Mode for the Testbuffer */
#define TBUF_RCTUNING_TBUF_PD_MASK 0x800
#define TBUF_RCTUNING_TBUF_PD_AFE_GET ((VR9_AfeRead(TBUF_RCTUNING) & TBUF_RCTUNING_TBUF_PD_MASK) >> 11)
#define TBUF_RCTUNING_TBUF_PD_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val) << 11, TBUF_RCTUNING_TBUF_PD_MASK)
/** Power Up */
#define TBUF_PD_TBUF_PU 0x0
/** Power Down (default) */
#define TBUF_PD_TBUF_PD 0x1

/** TESTBUFFER Gain 2 - Selects a gain of -12dB for measuring ADC loopfilter signals (high bandwidth) */
#define TBUF_RCTUNING_TBUF_MASH_M12DB_MASK 0x200
#define TBUF_RCTUNING_TBUF_MASH_M12DB_AFE_GET ((VR9_AfeRead(TBUF_RCTUNING) & TBUF_RCTUNING_TBUF_MASH_M12DB_MASK) >> 9)
#define TBUF_RCTUNING_TBUF_MASH_M12DB_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val) << 9, TBUF_RCTUNING_TBUF_MASH_M12DB_MASK)
/** normal mode (default) */
#define TBUF_MASH_M12DB_TBUF_M12DB_OFF 0x0
/** Enable -12dB gain */
#define TBUF_MASH_M12DB_TBUF_M12DB_ON 0x1

/** TESTBUFFER GAIN 1 - Selects a gain of -6dB for measuring ADC loopfilter signals (high bandwidth) */
#define TBUF_RCTUNING_TBUF_MASH_M6DB_MASK 0x100
#define TBUF_RCTUNING_TBUF_MASH_M6DB_AFE_GET ((VR9_AfeRead(TBUF_RCTUNING) & TBUF_RCTUNING_TBUF_MASH_M6DB_MASK) >> 8)
#define TBUF_RCTUNING_TBUF_MASH_M6DB_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val) << 8, TBUF_RCTUNING_TBUF_MASH_M6DB_MASK)
/** normal mode (default) */
#define TBUF_MASH_M6DB_TBUF_M6DB_OFF 0x0
/** Enable -6dB gain */
#define TBUF_MASH_M6DB_TBUF_M6DB_ON 0x1

/** TESTBUFFER ADC Signal Selection - Select the internal ADC signal to be measured via the testbuffer. */
#define TBUF_RCTUNING_TBUF_ADC_SEL_MASK 0x70
#define TBUF_RCTUNING_TBUF_ADC_SEL_AFE_GET ((VR9_AfeRead(TBUF_RCTUNING) & TBUF_RCTUNING_TBUF_ADC_SEL_MASK) >> 4)
#define TBUF_RCTUNING_TBUF_ADC_SEL_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val) << 4, TBUF_RCTUNING_TBUF_ADC_SEL_MASK)
/** no ADC signal selected, floating (default) */
#define TBUF_ADC_SEL_TBUF_SEL_ADC_OFF 0x0
/** Select ADC input */
#define TBUF_ADC_SEL_TBUF_SEL_ADC_INPUT 0x1
/** Select ouput of loopfilter 1 in stage 1 of the ADC */
#define TBUF_ADC_SEL_TBUF_SEL_ADC_INTE11 0x2
/** Select ouput of loopfilter 2 in stage 1 of the ADC */
#define TBUF_ADC_SEL_TBUF_SEL_ADC_INTE21 0x3
/** Select ouput of loopfilter 1 in stage 2 of the ADC */
#define TBUF_ADC_SEL_TBUF_SEL_ADC_INTE12 0x4
/** Select ouput of loopfilter 2 in stage 2 of the ADC */
#define TBUF_ADC_SEL_TBUF_SEL_ADC_INTE22 0x5

/** TESTBUFFER Main Signal Selection - Selects the signal to be measured via the Testbuffer */
#define TBUF_RCTUNING_TBUF_PRG_OUTPUT_MASK 0x3
#define TBUF_RCTUNING_TBUF_PRG_OUTPUT_AFE_GET ((VR9_AfeRead(TBUF_RCTUNING) & TBUF_RCTUNING_TBUF_PRG_OUTPUT_MASK) >> 0)
#define TBUF_RCTUNING_TBUF_PRG_OUTPUT_AFE_SET(val) VR9_AfeWrite(TBUF_RCTUNING, (val) << 0, TBUF_RCTUNING_TBUF_PRG_OUTPUT_MASK)
/** Select ADC loopfilter signals (default) */
#define TBUF_PRG_OUTPUT_TBUF_SEL_ADC 0x0
/** Select AGC1 output */
#define TBUF_PRG_OUTPUT_TBUF_SEL_AGC1 0x1
/** Select AGC2 output */
#define TBUF_PRG_OUTPUT_TBUF_SEL_AGC2 0x2
/** Select RX input (INPUT C) */
#define TBUF_PRG_OUTPUT_TBUF_SEL_RX 0x3


/** Control Register */
#define AGC2_INPUT (AFE_BASE + 0x11)
#define AGC2_INPUT_AFE_GET VR9_AfeRead(AGC2_INPUT)
#define AGC2_INPUT_AFE_SET(val) VR9_AfeWrite(AGC2_INPUT, (val), 0xFFFF)

/** AGC2 Shunt Resistor - Sets the shunt resistor of path 1 and path 2 in the AGC2. */
#define AGC2_INPUT_AGC2_PRG_RSHUNT_MASK 0xc000
#define AGC2_INPUT_AGC2_PRG_RSHUNT_AFE_GET ((VR9_AfeRead(AGC2_INPUT) & AGC2_INPUT_AGC2_PRG_RSHUNT_MASK) >> 14)
#define AGC2_INPUT_AGC2_PRG_RSHUNT_AFE_SET(val) VR9_AfeWrite(AGC2_INPUT, (val) << 14, AGC2_INPUT_AGC2_PRG_RSHUNT_MASK)
/** RQ1 = OPEN, RQ2 = OPEN (default) */
#define AGC2_PRG_RSHUNT_AGC2_RSHUNT_OPEN 0x0
/** RQ1 = 0.8kOhm, RQ2 = OPEN */
#define AGC2_PRG_RSHUNT_AGC2_RSHUNT_RQ1_800OHM 0x1
/** RQ1 = OPEN, RQ2 = 0.8kOhm */
#define AGC2_PRG_RSHUNT_AGC2_RSHUNT_RQ2_800OHM 0x2
/** RQ1 = 0.8Ohm, RQ2 = 0.8kOhm */
#define AGC2_PRG_RSHUNT_AGC2_RSHUNT_RQ1RQ2_800OHM 0x3

/** AGC2 Input Network - Sets the input network of the AGC2. There are 3 input pathes: path 1 (bit7...bit0) and path 2 (bit) including a decoupling capacitor for HP functionality with variable input resistor for AGC2; path 3 (bit12) with a fixed resistor only, which must be used in Buffer Mode of AGC2 to measure the signal power at AGC1 output (see AGC2 block diagram). */
#define AGC2_INPUT_AGC2_PRG_RIN_MASK 0x1fff
#define AGC2_INPUT_AGC2_PRG_RIN_AFE_GET ((VR9_AfeRead(AGC2_INPUT) & AGC2_INPUT_AGC2_PRG_RIN_MASK) >> 0)
#define AGC2_INPUT_AGC2_PRG_RIN_AFE_SET(val) VR9_AfeWrite(AGC2_INPUT, (val) << 0, AGC2_INPUT_AGC2_PRG_RIN_MASK)
/** OPEN */
#define AGC2_PRG_RIN_AGC2_RIN_OPEN 0x0
/** RL1 = 3.2kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_1_3200OHM 0x1
/** RL1 = 1.6kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_1_1600OHM 0x3
/** RL1 = 1.066kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_1_1066OHM 0x7
/** RL1 = 0.8kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_1_800OHM 0xf
/** RL1 = 0.64kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_1_640OHM 0x1f
/** RL1 = 0.53kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_1_533OHM 0x3f
/** RL1 = 0.46kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_1_457OHM 0x7f
/** RL1 = 0.40kOhm (default) */
#define AGC2_PRG_RIN_AGC2_RIN_1_400OHM 0xff
/** RL2 = 3.2kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_2_3200OHM 0x1ff
/** RL2 = 1.6kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_2_1600OHM 0x3ff
/** RL2 = 1.066kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_2_1066OHM 0x7ff
/** RL2 = 0.8kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_2_800OHM 0xfff
/** RL3 = 3.2kOhm */
#define AGC2_PRG_RIN_AGC2_RIN_BUFFER_MODE 0x1000


/** Control Register */
#define AGC2_FEEDB (AFE_BASE + 0x12)
#define AGC2_FEEDB_AFE_GET VR9_AfeRead(AGC2_FEEDB)
#define AGC2_FEEDB_AFE_SET(val) VR9_AfeWrite(AGC2_FEEDB, (val), 0xFFFF)

/** AGC2 LP2 Feedback Capacitor - Selects the feedback capacitor of the AGC2 LP2. The programming is binary coded. The stepsize is 100fF */
#define AGC2_FEEDB_AGC2_PRG_CFB_MASK 0xfe00
#define AGC2_FEEDB_AGC2_PRG_CFB_AFE_GET ((VR9_AfeRead(AGC2_FEEDB) & AGC2_FEEDB_AGC2_PRG_CFB_MASK) >> 9)
#define AGC2_FEEDB_AGC2_PRG_CFB_AFE_SET(val) VR9_AfeWrite(AGC2_FEEDB, (val) << 9, AGC2_FEEDB_AGC2_PRG_CFB_MASK)
/** OPEN (default) */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_OPEN 0x0
/** 0.1pF */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_0P1F 0x1
/** 0.2pF */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_0P2F 0x2
/** 0.4pF */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_0P4F 0x4
/** 0.8pF */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_0P8F 0x8
/** 1.6pF */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_1P6F 0x10
/** 3.2pF */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_3P2F 0x20
/** 6.4pF */
#define AGC2_PRG_CFB_AGC2_LP2_CAP_6P4F 0x40

/** AGC2 LP2 Gain - Sets the gain of LP2 in AGC2. */
#define AGC2_FEEDB_AGC2_PRG_GAIN_MASK 0x1ff
#define AGC2_FEEDB_AGC2_PRG_GAIN_AFE_GET ((VR9_AfeRead(AGC2_FEEDB) & AGC2_FEEDB_AGC2_PRG_GAIN_MASK) >> 0)
#define AGC2_FEEDB_AGC2_PRG_GAIN_AFE_SET(val) VR9_AfeWrite(AGC2_FEEDB, (val) << 0, AGC2_FEEDB_AGC2_PRG_GAIN_MASK)
/** OPEN (all feedback resistors are switched off) */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_OPEN 0x0
/** 27dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_27DB 0x100
/** 24dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_24DB 0x80
/** 21dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_21DB 0xc0
/** 18dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_18DB 0xa0
/** 15dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_15DB 0xb0
/** 12dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_12DB 0xa8
/** 9dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_9DB 0xbc
/** 6dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_6DB 0xaa
/** 3.5dB (default) */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_3P5DB 0x1fe
/** 0dB */
#define AGC2_PRG_GAIN_AGC2_LP2_GAIN_0DB 0xab


/** Control Register */
#define AGC2_MISC (AFE_BASE + 0x13)
#define AGC2_MISC_AFE_GET VR9_AfeRead(AGC2_MISC)
#define AGC2_MISC_AFE_SET(val) VR9_AfeWrite(AGC2_MISC, (val), 0xFFFF)

/** Testloop: Analog Loopback - Closes the analog loopback from DAC1 output to AGC2 input (AGC2_PRG_RIN must be set to 0, during loopback !) */
#define AGC2_MISC_ALOOP_MASK 0x8000
#define AGC2_MISC_ALOOP_AFE_GET ((VR9_AfeRead(AGC2_MISC) & AGC2_MISC_ALOOP_MASK) >> 15)
#define AGC2_MISC_ALOOP_AFE_SET(val) VR9_AfeWrite(AGC2_MISC, (val) << 15, AGC2_MISC_ALOOP_MASK)
/** loopback is opened (default) */
#define ALOOP_ALOOP_OPEN 0x0
/** loopback is closed */
#define ALOOP_ALOOP_CLOSED 0x1

/** AGC2 Quiescent Current Control of Opamp - Enables/Disables the control of the quiescent current in the operational amplifier. */
#define AGC2_MISC_AGC2_QC_ON_MASK 0x1000
#define AGC2_MISC_AGC2_QC_ON_AFE_GET ((VR9_AfeRead(AGC2_MISC) & AGC2_MISC_AGC2_QC_ON_MASK) >> 12)
#define AGC2_MISC_AGC2_QC_ON_AFE_SET(val) VR9_AfeWrite(AGC2_MISC, (val) << 12, AGC2_MISC_AGC2_QC_ON_MASK)
/** Disabled */
#define AGC2_QC_ON_AGC2_QC_DISABLED 0x0
/** Enabled (default) */
#define AGC2_QC_ON_AGC2_QC_ENABLED 0x1

/** AGC2 Miller Capacitor of Opamp - Programs the Miller Capacitor of the operational amplifier. The settings are related to AGC2 gain. */
#define AGC2_MISC_AGC2_PRG_CMILLER_MASK 0xc00
#define AGC2_MISC_AGC2_PRG_CMILLER_AFE_GET ((VR9_AfeRead(AGC2_MISC) & AGC2_MISC_AGC2_PRG_CMILLER_MASK) >> 10)
#define AGC2_MISC_AGC2_PRG_CMILLER_AFE_SET(val) VR9_AfeWrite(AGC2_MISC, (val) << 10, AGC2_MISC_AGC2_PRG_CMILLER_MASK)
/** for AGC2 gain = +9dB...+27dB */
#define AGC2_PRG_CMILLER_AGC2_OP_CMILLER_9dB 0x0
/** for AGC2 gain = +6dB */
#define AGC2_PRG_CMILLER_AGC2_OP_CMILLER_6dB 0x1
/** for AGC2 gain = +3dB */
#define AGC2_PRG_CMILLER_AGC2_OP_CMILLER_3dB 0x2
/** for AGC2 gain = 0dB (default) */
#define AGC2_PRG_CMILLER_AGC2_OP_CMILLER_0dB 0x3

/** AGC2 Input Stage gm of Opamp - Programs the gm in the input stage of the operational amplifier. */
#define AGC2_MISC_AGC2_PRG_GM_MASK 0x380
#define AGC2_MISC_AGC2_PRG_GM_AFE_GET ((VR9_AfeRead(AGC2_MISC) & AGC2_MISC_AGC2_PRG_GM_MASK) >> 7)
#define AGC2_MISC_AGC2_PRG_GM_AFE_SET(val) VR9_AfeWrite(AGC2_MISC, (val) << 7, AGC2_MISC_AGC2_PRG_GM_MASK)
/** OFF (default) */
#define AGC2_PRG_GM_AGC2_OP_GM_OFF 0x0
/** INF */
#define AGC2_PRG_GM_AGC2_OP_GM_INF 0x4
/** 300Ohm */
#define AGC2_PRG_GM_AGC2_OP_GM_300OHM 0x6
/** 150Ohm */
#define AGC2_PRG_GM_AGC2_OP_GM_150OHM 0x7

/** AGC2 Output Stage Current of Opamp - Programs the current in the output stage of the operational amplifier.The programming is binary coded. */
#define AGC2_MISC_AGC2_PRG_IOUT_MASK 0x70
#define AGC2_MISC_AGC2_PRG_IOUT_AFE_GET ((VR9_AfeRead(AGC2_MISC) & AGC2_MISC_AGC2_PRG_IOUT_MASK) >> 4)
#define AGC2_MISC_AGC2_PRG_IOUT_AFE_SET(val) VR9_AfeWrite(AGC2_MISC, (val) << 4, AGC2_MISC_AGC2_PRG_IOUT_MASK)
/** minimum current */
#define AGC2_PRG_IOUT_AGC2_OP_IOUT_MIN 0x0
/** nominal current (default) */
#define AGC2_PRG_IOUT_AGC2_OP_IOUT_DEFAULT 0x2
/** maximum current */
#define AGC2_PRG_IOUT_AGC2_OP_IOUT_MAX 0x7

/** AGC2 Power Down - Sets the Power Down Mode for AGC2 */
#define AGC2_MISC_AGC2_PD_MASK 0x1
#define AGC2_MISC_AGC2_PD_AFE_GET ((VR9_AfeRead(AGC2_MISC) & AGC2_MISC_AGC2_PD_MASK) >> 0)
#define AGC2_MISC_AGC2_PD_AFE_SET(val) VR9_AfeWrite(AGC2_MISC, (val) << 0, AGC2_MISC_AGC2_PD_MASK)
/** Power Up */
#define AGC2_PD_AGC2_PU 0x0
/** Power Down (default) */
#define AGC2_PD_AGC2_PD 0x1


/** Control Register */
#define BIAS_1 (AFE_BASE + 0x14)
#define BIAS_1_AFE_GET VR9_AfeRead(BIAS_1)
#define BIAS_1_AFE_SET(val) VR9_AfeWrite(BIAS_1, (val), 0xFFFF)

/** LOCALBIASING Bias Current of Common Mode Voltage Buffer (0.7V). - Programs the biasing current of the common mode voltage buffer carrying the 0.7V internal common mode voltagefor AGC2, ADC opamps, Testbuffer. The stepsize is 12.5%. */
#define BIAS_1_BIAS_PRG_IB_OPA_VCM_MASK 0xe000
#define BIAS_1_BIAS_PRG_IB_OPA_VCM_AFE_GET ((VR9_AfeRead(BIAS_1) & BIAS_1_BIAS_PRG_IB_OPA_VCM_MASK) >> 13)
#define BIAS_1_BIAS_PRG_IB_OPA_VCM_AFE_SET(val) VR9_AfeWrite(BIAS_1, (val) << 13, BIAS_1_BIAS_PRG_IB_OPA_VCM_MASK)
/** 50% */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_50 0x0
/** 62.5% */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_62P5 0x1
/** 75% */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_75 0x2
/** 87.5% */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_87P5 0x3
/** 100% (nominal) */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_100 0x4
/** 112.5% */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_112P5 0x5
/** 125% */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_125 0x6
/** 137.5% */
#define BIAS_PRG_IB_OPA_VCM_BIAS_IB_OP_VCM0V7_137P5 0x7

/** CENTRALBIASING Trimming Common Mode voltage - Sets the common mode voltage of the Analog Front End (ideal: 0.7V between CREF and CREFGND). The stepsize is 4mV. These bits are fused in the Analog Front End and must be reprogrammed after supply startup with the values from fuse register Nr. XXXXX. */
#define BIAS_1_BIAS_BGP_MASK 0x1f00
#define BIAS_1_BIAS_BGP_AFE_GET ((VR9_AfeRead(BIAS_1) & BIAS_1_BIAS_BGP_MASK) >> 8)
#define BIAS_1_BIAS_BGP_AFE_SET(val) VR9_AfeWrite(BIAS_1, (val) << 8, BIAS_1_BIAS_BGP_MASK)
/** Vcm = MAX */
#define BIAS_BGP_BGP_TRIM_MAX 0x10
/** Vcm = MAX-1*4mV */
#define BIAS_BGP_BGP_TRIM_MAXM4MV 0x11
/** Vcm = MAX-2*4mV */
#define BIAS_BGP_BGP_TRIM_MAXM8MV 0x12
/** Vcm = MAX-3*4mV */
#define BIAS_BGP_BGP_TRIM_MAXM12MV 0x13
/** Vcm = MAX-15*4mV */
#define BIAS_BGP_BGP_TRIM_HALF4MV 0x1f
/** Vcm = MAX-16*4mV */
#define BIAS_BGP_BGP_TRIM_HALF 0x0
/** Vcm = MAX-17*4mV */
#define BIAS_BGP_BGP_TRIM_HALFM4MV 0x1
/** Vcm = MAX-63*4mV */
#define BIAS_BGP_BGP_TRIM_MIN 0xf

/** CENTRALBIASING Temperature coefficient of Bandgap - Sets the temperature coefficient the reference voltage in the Bandgap */
#define BIAS_1_BIAS_CENTER_BGP_MASK 0x30
#define BIAS_1_BIAS_CENTER_BGP_AFE_GET ((VR9_AfeRead(BIAS_1) & BIAS_1_BIAS_CENTER_BGP_MASK) >> 4)
#define BIAS_1_BIAS_CENTER_BGP_AFE_SET(val) VR9_AfeWrite(BIAS_1, (val) << 4, BIAS_1_BIAS_CENTER_BGP_MASK)
/** very positiv */
#define BIAS_CENTER_BGP_BIAS_TEMPCOEFF_VP 0x0
/** positiv (default) */
#define BIAS_CENTER_BGP_BIAS_TEMPCOEFF_P 0x1
/** negativ */
#define BIAS_CENTER_BGP_BIAS_TEMPCOEFF_N 0x2
/** very negativ */
#define BIAS_CENTER_BGP_BIAS_TEMPCOEFF_VN 0x3

/** CLOCKING BIASING Power Down - Sets the Power Down Mode for the Biasing of the clock distribution */
#define BIAS_1_CLK_BIAS_PD_MASK 0x8
#define BIAS_1_CLK_BIAS_PD_AFE_GET ((VR9_AfeRead(BIAS_1) & BIAS_1_CLK_BIAS_PD_MASK) >> 3)
#define BIAS_1_CLK_BIAS_PD_AFE_SET(val) VR9_AfeWrite(BIAS_1, (val) << 3, BIAS_1_CLK_BIAS_PD_MASK)
/** Power Up */
#define CLK_BIAS_PD_CLK_BIAS_PU 0x0
/** Power Down (default) */
#define CLK_BIAS_PD_CLK_BIAS_PD 0x1

/** LOCALBIASING Power Down - Sets the Power Down Mode for the Local Biasing */
#define BIAS_1_LOCALBIAS_PD_MASK 0x2
#define BIAS_1_LOCALBIAS_PD_AFE_GET ((VR9_AfeRead(BIAS_1) & BIAS_1_LOCALBIAS_PD_MASK) >> 1)
#define BIAS_1_LOCALBIAS_PD_AFE_SET(val) VR9_AfeWrite(BIAS_1, (val) << 1, BIAS_1_LOCALBIAS_PD_MASK)
/** Power Up */
#define LOCALBIAS_PD_LOCALBIAS_PU 0x0
/** Power Down (default) */
#define LOCALBIAS_PD_LOCALBIAS_PD 0x1

/** CENTRALBIASING Power Down - Sets the Power Down Mode for the Central Biasing */
#define BIAS_1_CENTRALBIAS_PD_MASK 0x1
#define BIAS_1_CENTRALBIAS_PD_AFE_GET ((VR9_AfeRead(BIAS_1) & BIAS_1_CENTRALBIAS_PD_MASK) >> 0)
#define BIAS_1_CENTRALBIAS_PD_AFE_SET(val) VR9_AfeWrite(BIAS_1, (val) << 0, BIAS_1_CENTRALBIAS_PD_MASK)
/** Power Up */
#define CENTRALBIAS_PD_CENTRALBIAS_PU 0x0
/** Power Down (default) */
#define CENTRALBIAS_PD_CENTRALBIAS_PD 0x1


/** Control Register */
#define BIAS_2 (AFE_BASE + 0x15)
#define BIAS_2_AFE_GET VR9_AfeRead(BIAS_2)
#define BIAS_2_AFE_SET(val) VR9_AfeWrite(BIAS_2, (val), 0xFFFF)

/** LOCALBIASING Bias Current of AGC2 LP2 - Programs the biasing current of the AGC2 LP2. The stepsize is 6.25%. */
#define BIAS_2_BIAS_PRG_IB_AGC2_MASK 0xf000
#define BIAS_2_BIAS_PRG_IB_AGC2_AFE_GET ((VR9_AfeRead(BIAS_2) & BIAS_2_BIAS_PRG_IB_AGC2_MASK) >> 12)
#define BIAS_2_BIAS_PRG_IB_AGC2_AFE_SET(val) VR9_AfeWrite(BIAS_2, (val) << 12, BIAS_2_BIAS_PRG_IB_AGC2_MASK)
/** 37.5% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_37P5 0x0
/** 43.75% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_43P75 0x1
/** 50% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_50 0x2
/** 56.25% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_56P25 0x3
/** 62.5% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_62P5 0x4
/** 68.75% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_68P75 0x5
/** 75% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_75 0x6
/** 81.25% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_81P25 0x7
/** 87.5% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_87P5 0x8
/** 93.75% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_93P75 0x9
/** 100% (nominal) */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_100 0xa
/** 106.25% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_106P25 0xb
/** 112.5% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_112P5 0xc
/** 118.75% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_118P75 0xd
/** 125% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_125 0xe
/** 131.25% */
#define BIAS_PRG_IB_AGC2_BIAS_IB_AGC2_LP2_131P25 0xf

/** LOCALBIASING Bias Current of AGC1 Levelshifter - Programs the biasing current of the AGC1 Levelshifter. The stepsize is 6.25%. */
#define BIAS_2_BIAS_PRG_IB_LEVELSHIFT_MASK 0xf00
#define BIAS_2_BIAS_PRG_IB_LEVELSHIFT_AFE_GET ((VR9_AfeRead(BIAS_2) & BIAS_2_BIAS_PRG_IB_LEVELSHIFT_MASK) >> 8)
#define BIAS_2_BIAS_PRG_IB_LEVELSHIFT_AFE_SET(val) VR9_AfeWrite(BIAS_2, (val) << 8, BIAS_2_BIAS_PRG_IB_LEVELSHIFT_MASK)
/** 37.5% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_37P5 0x0
/** 43.75% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_43P75 0x1
/** 50% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_50 0x2
/** 56.25% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_56P25 0x3
/** 62.5% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_62P5 0x4
/** 68.75% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_68P75 0x5
/** 75% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_75 0x6
/** 81.25% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_81P25 0x7
/** 87.5% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_87P5 0x8
/** 93.75% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_93P75 0x9
/** 100% (nominal) */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_100 0xa
/** 106.25% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_106P25 0xb
/** 112.5% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_112P5 0xc
/** 118.75% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_118P75 0xd
/** 125% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_125 0xe
/** 131.25% */
#define BIAS_PRG_IB_LEVELSHIFT_BIAS_IB_AGC1_LVLSHIFT_131P25 0xf

/** LOCALBIASING Bias Current of AGC1 HP1 - Programs the biasing current of the AGC1 HP1. The stepsize is 6.25%. */
#define BIAS_2_BIAS_PRG_IB_AGC1_OP2_MASK 0xf0
#define BIAS_2_BIAS_PRG_IB_AGC1_OP2_AFE_GET ((VR9_AfeRead(BIAS_2) & BIAS_2_BIAS_PRG_IB_AGC1_OP2_MASK) >> 4)
#define BIAS_2_BIAS_PRG_IB_AGC1_OP2_AFE_SET(val) VR9_AfeWrite(BIAS_2, (val) << 4, BIAS_2_BIAS_PRG_IB_AGC1_OP2_MASK)
/** 37.5% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_37P5 0x0
/** 43.75% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_43P75 0x1
/** 50% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_50 0x2
/** 56.25% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_56P25 0x3
/** 62.5% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_62P5 0x4
/** 68.75% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_68P75 0x5
/** 75% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_75 0x6
/** 81.25% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_81P25 0x7
/** 87.5% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_87P5 0x8
/** 93.75% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_93P75 0x9
/** 100% (nominal) */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_100 0xa
/** 106.25% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_106P25 0xb
/** 112.5% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_112P5 0xc
/** 118.75% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_118P75 0xd
/** 125% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_125 0xe
/** 131.25% */
#define BIAS_PRG_IB_AGC1_OP2_BIAS_IB_AGC1_HP1_131P25 0xf

/** LOCALBIASING Bias Current of AGC1 LP1 - Programs the biasing current of the AGC1 LP1. The stepsize is 6.25%. */
#define BIAS_2_BIAS_PRG_IB_AGC1_OP1_MASK 0xf
#define BIAS_2_BIAS_PRG_IB_AGC1_OP1_AFE_GET ((VR9_AfeRead(BIAS_2) & BIAS_2_BIAS_PRG_IB_AGC1_OP1_MASK) >> 0)
#define BIAS_2_BIAS_PRG_IB_AGC1_OP1_AFE_SET(val) VR9_AfeWrite(BIAS_2, (val) << 0, BIAS_2_BIAS_PRG_IB_AGC1_OP1_MASK)
/** 37.5% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_37P5 0x0
/** 43.75% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_43P75 0x1
/** 50% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_50 0x2
/** 56.25% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_56P25 0x3
/** 62.5% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_62P5 0x4
/** 68.75% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_68P75 0x5
/** 75% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_75 0x6
/** 81.25% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_81P25 0x7
/** 87.5% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_87P5 0x8
/** 93.75% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_93P75 0x9
/** 100% (nominal) */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_100 0xa
/** 106.25% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_106P25 0xb
/** 112.5% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_112P5 0xc
/** 118.75% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_118P75 0xd
/** 125% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_125 0xe
/** 131.25% */
#define BIAS_PRG_IB_AGC1_OP1_BIAS_IB_AGC1_LP1_131P25 0xf


/** Control Register */
#define BIAS_3 (AFE_BASE + 0x16)
#define BIAS_3_AFE_GET VR9_AfeRead(BIAS_3)
#define BIAS_3_AFE_SET(val) VR9_AfeWrite(BIAS_3, (val), 0xFFFF)

/** LOCALBIASING Bias Current of Clocking Distribution - Programs the biasing current of the clocking distribution buffers. The stepsize is 12.5%. */
#define BIAS_3_BIAS_PRG_IB_CLOCKING_MASK 0x7000
#define BIAS_3_BIAS_PRG_IB_CLOCKING_AFE_GET ((VR9_AfeRead(BIAS_3) & BIAS_3_BIAS_PRG_IB_CLOCKING_MASK) >> 12)
#define BIAS_3_BIAS_PRG_IB_CLOCKING_AFE_SET(val) VR9_AfeWrite(BIAS_3, (val) << 12, BIAS_3_BIAS_PRG_IB_CLOCKING_MASK)
/** 50% */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_50 0x0
/** 62.5% */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_62P5 0x1
/** 75% */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_75 0x2
/** 87.5% */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_87P5 0x3
/** 100% (nominal) */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_100 0x4
/** 112.5% */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_112P5 0x5
/** 125% */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_125 0x6
/** 137.5% */
#define BIAS_PRG_IB_CLOCKING_BIAS_IB_CLK_137P5 0x7

/** LOCALBIASING Bias Current of Testbuffer - Programs the biasing current of the Testbuffer. The stepsize is 12.5%. */
#define BIAS_3_BIAS_PRG_IB_TESTBUFFER_MASK 0x700
#define BIAS_3_BIAS_PRG_IB_TESTBUFFER_AFE_GET ((VR9_AfeRead(BIAS_3) & BIAS_3_BIAS_PRG_IB_TESTBUFFER_MASK) >> 8)
#define BIAS_3_BIAS_PRG_IB_TESTBUFFER_AFE_SET(val) VR9_AfeWrite(BIAS_3, (val) << 8, BIAS_3_BIAS_PRG_IB_TESTBUFFER_MASK)
/** 50% */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_50 0x0
/** 62.5% */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_62P5 0x1
/** 75% */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_75 0x2
/** 87.5% */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_87P5 0x3
/** 100% (nominal) */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_100 0x4
/** 112.5% */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_112P5 0x5
/** 125% */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_125 0x6
/** 137.5% */
#define BIAS_PRG_IB_TESTBUFFER_BIAS_IB_TBUF_137P5 0x7

/** LOCALBIASING Bias Current of POFIPOCO Opamp 1 - Programs the biasing current of the POFIPOCO operational amplifier 1. The stepsize is 6.25%. */
#define BIAS_3_BIAS_PRG_IB_POCO_OP2_MASK 0xf0
#define BIAS_3_BIAS_PRG_IB_POCO_OP2_AFE_GET ((VR9_AfeRead(BIAS_3) & BIAS_3_BIAS_PRG_IB_POCO_OP2_MASK) >> 4)
#define BIAS_3_BIAS_PRG_IB_POCO_OP2_AFE_SET(val) VR9_AfeWrite(BIAS_3, (val) << 4, BIAS_3_BIAS_PRG_IB_POCO_OP2_MASK)
/** 37.5% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_37P5 0x0
/** 43.75% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_43P75 0x1
/** 50% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_50 0x2
/** 56.25% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_56P25 0x3
/** 62.5% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_62P5 0x4
/** 68.75% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_68P75 0x5
/** 75% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_75 0x6
/** 81.25% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_81P25 0x7
/** 87.5% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_87P5 0x8
/** 93.75% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_93P75 0x9
/** 100% (nominal) */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_100 0xa
/** 106.25% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_106P25 0xb
/** 112.5% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_112P5 0xc
/** 118.75% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_118P75 0xd
/** 125% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_125 0xe
/** 131.25% */
#define BIAS_PRG_IB_POCO_OP2_BIAS_IB_POFIPOCO_OP2_131P25 0xf

/** LOCALBIASING Bias Current of POFIPOCO Opamp 1 - Programs the biasing current of the POFIPOCO operational amplifier 1. The stepsize is 6.25%. */
#define BIAS_3_BIAS_PRG_IB_POCO_OP1_MASK 0xf
#define BIAS_3_BIAS_PRG_IB_POCO_OP1_AFE_GET ((VR9_AfeRead(BIAS_3) & BIAS_3_BIAS_PRG_IB_POCO_OP1_MASK) >> 0)
#define BIAS_3_BIAS_PRG_IB_POCO_OP1_AFE_SET(val) VR9_AfeWrite(BIAS_3, (val) << 0, BIAS_3_BIAS_PRG_IB_POCO_OP1_MASK)
/** 37.5% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_37P5 0x0
/** 43.75% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_43P75 0x1
/** 50% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_50 0x2
/** 56.25% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_56P25 0x3
/** 62.5% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_62P5 0x4
/** 68.75% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_68P75 0x5
/** 75% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_75 0x6
/** 81.25% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_81P25 0x7
/** 87.5% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_87P5 0x8
/** 93.75% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_93P75 0x9
/** 100% (nominal) */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_100 0xa
/** 106.25% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_106P25 0xb
/** 112.5% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_112P5 0xc
/** 118.75% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_118P75 0xd
/** 125% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_125 0xe
/** 131.25% */
#define BIAS_PRG_IB_POCO_OP1_BIAS_IB_POFIPOCO_OP1_131P25 0xf


/** Control Register */
#define BIAS_4 (AFE_BASE + 0x17)
#define BIAS_4_AFE_GET VR9_AfeRead(BIAS_4)
#define BIAS_4_AFE_SET(val) VR9_AfeWrite(BIAS_4, (val), 0xFFFF)

/** LOCALBIASING Miller Capacitor of Common Mode Voltage Buffer (0.7V for DACs). - Programs the Miller Capacitor of the common mode voltage buffer's (0.7V for DAC) operational amplifier.The programming is thermometer coded. */
#define BIAS_4_BIAS_PRGMILLERCBUFFER_MASK 0x7000
#define BIAS_4_BIAS_PRGMILLERCBUFFER_AFE_GET ((VR9_AfeRead(BIAS_4) & BIAS_4_BIAS_PRGMILLERCBUFFER_MASK) >> 12)
#define BIAS_4_BIAS_PRGMILLERCBUFFER_AFE_SET(val) VR9_AfeWrite(BIAS_4, (val) << 12, BIAS_4_BIAS_PRGMILLERCBUFFER_MASK)
/** minimum (default) */
#define BIAS_PRGMILLERCBUFFER_BIAS_CMILLER_REFBUFFER_DAC_MIN 0x0
/** nominal (default) */
#define BIAS_PRGMILLERCBUFFER_BIAS_CMILLER_REFBUFFER_DAC_DEFAULT 0x1
/** maximum (default) */
#define BIAS_PRGMILLERCBUFFER_BIAS_CMILLER_REFBUFFER_DAC_MAX 0x7

/** LOCALBIASING Biasing Current of Common Mode Voltage Buffer (0.7V for DACs) - Programs the biasing current of the common mode voltage buffer carrying the 0.7V internal common mode voltage for DAC1, DAC2 and DAC of ADC. The stepsize is 6.25%. */
#define BIAS_4_BIAS_PRG_IB_OPAREFBUFFER_MASK 0x700
#define BIAS_4_BIAS_PRG_IB_OPAREFBUFFER_AFE_GET ((VR9_AfeRead(BIAS_4) & BIAS_4_BIAS_PRG_IB_OPAREFBUFFER_MASK) >> 8)
#define BIAS_4_BIAS_PRG_IB_OPAREFBUFFER_AFE_SET(val) VR9_AfeWrite(BIAS_4, (val) << 8, BIAS_4_BIAS_PRG_IB_OPAREFBUFFER_MASK)
/** 50% */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_50 0x0
/** 62.5% */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_62P5 0x1
/** 75% */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_75 0x2
/** 87.5% */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_87P5 0x3
/** 100% (nominal) */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_100 0x4
/** 112.5% */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_112P5 0x5
/** 125% */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_125 0x6
/** 137.5% */
#define BIAS_PRG_IB_OPAREFBUFFER_BIAS_IB_REFBUFFER_DAC_137P5 0x7

/** LOCALBIAS Common Mode Voltage for DAC1, POFIPOCO and AGC1 - Programs the common mode voltage for DAC1, POFIPOCO and AGC1. */
#define BIAS_4_BIAS_TRIM_VOUT_1V5_MASK 0x70
#define BIAS_4_BIAS_TRIM_VOUT_1V5_AFE_GET ((VR9_AfeRead(BIAS_4) & BIAS_4_BIAS_TRIM_VOUT_1V5_MASK) >> 4)
#define BIAS_4_BIAS_TRIM_VOUT_1V5_AFE_SET(val) VR9_AfeWrite(BIAS_4, (val) << 4, BIAS_4_BIAS_TRIM_VOUT_1V5_MASK)
/** 1.28V */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V28 0x0
/** 1.34V */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V34 0x1
/** 1.41V */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V41 0x2
/** 1.45V */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V45 0x3
/** 1.50V (default) */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V50 0x4
/** 1.56V */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V56 0x5
/** 1.63V */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V63 0x6
/** 1.70V */
#define BIAS_TRIM_VOUT_1V5_BIAS_TRIM_1V5_VREF_1V70 0x7

/** LOCALBIASING Bias Current of Common Mode Voltage Buffer (1.5V). - Programs the biasing current of the common mode voltage buffer carrying the 1.5V internal common mode voltage for DAC1, POFIPOCO and AGC1. The stepsize is 6.25%. */
#define BIAS_4_BIAS_PRG_IB_BUFFER_1V5_MASK 0xf
#define BIAS_4_BIAS_PRG_IB_BUFFER_1V5_AFE_GET ((VR9_AfeRead(BIAS_4) & BIAS_4_BIAS_PRG_IB_BUFFER_1V5_MASK) >> 0)
#define BIAS_4_BIAS_PRG_IB_BUFFER_1V5_AFE_SET(val) VR9_AfeWrite(BIAS_4, (val) << 0, BIAS_4_BIAS_PRG_IB_BUFFER_1V5_MASK)
/** 37.5% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_37P5 0x0
/** 43.75% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_43P75 0x1
/** 50% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_50 0x2
/** 56.25% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_56P25 0x3
/** 62.5% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_62P5 0x4
/** 68.75% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_68P75 0x5
/** 75% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_75 0x6
/** 81.25% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_81P25 0x7
/** 87.5% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_87P5 0x8
/** 93.75% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_93P75 0x9
/** 100% (nominal) */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_100 0xa
/** 106.25% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_106P25 0xb
/** 112.5% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_112P5 0xc
/** 118.75% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_118P75 0xd
/** 125% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_125 0xe
/** 131.25% */
#define BIAS_PRG_IB_BUFFER_1V5_BIAS_IB_REFBUFFER_1V5_131P25 0xf


/** Control Register */
#define POFIPOCO_GAIN (AFE_BASE + 0x18)
#define POFIPOCO_GAIN_AFE_GET VR9_AfeRead(POFIPOCO_GAIN)
#define POFIPOCO_GAIN_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val), 0xFFFF)

/** POFIPOCO Power Down - Sets the Power Down Mode for POFIPOCO. */
#define POFIPOCO_GAIN_POFIPOCO_PD_MASK 0x8000
#define POFIPOCO_GAIN_POFIPOCO_PD_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_PD_MASK) >> 15)
#define POFIPOCO_GAIN_POFIPOCO_PD_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 15, POFIPOCO_GAIN_POFIPOCO_PD_MASK)
/** Power Up */
#define POFIPOCO_PD_POFIPOCO_PU 0x0
/** Power Down (default) */
#define POFIPOCO_PD_POFIPOCO_PD 0x1

/** POFIPOCO Speed Up of Power Up - Enables/Disables the recovery circuit for the common mode voltage during the Power Up phase in the operational amplifiers of POFIPOCO. */
#define POFIPOCO_GAIN_POFIPOCO_INHIBIT_UNLOCK_MASK 0x4000
#define POFIPOCO_GAIN_POFIPOCO_INHIBIT_UNLOCK_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_INHIBIT_UNLOCK_MASK) >> 14)
#define POFIPOCO_GAIN_POFIPOCO_INHIBIT_UNLOCK_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 14, POFIPOCO_GAIN_POFIPOCO_INHIBIT_UNLOCK_MASK)
/** Enabled (default) */
#define POFIPOCO_INHIBIT_UNLOCK_POFIPOCO_PU_SPEEDUP_ENABLE 0x0
/** Disabled */
#define POFIPOCO_INHIBIT_UNLOCK_POFIPOCO_PU_SPEEDUP_DISABLE 0x1

/** POFIPOCO ADSL Mode Enable - Enables/Disables the ADSL Mode in POFIPOCO. */
#define POFIPOCO_GAIN_POFIPOCO_ADSL_MASK 0x2000
#define POFIPOCO_GAIN_POFIPOCO_ADSL_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_ADSL_MASK) >> 13)
#define POFIPOCO_GAIN_POFIPOCO_ADSL_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 13, POFIPOCO_GAIN_POFIPOCO_ADSL_MASK)
/** ADSL Mode Disabled (default) */
#define POFIPOCO_ADSL_POFIPOCO_ADSL_DISABLE 0x0
/** ADSL Mode Enabled */
#define POFIPOCO_ADSL_POFIPOCO_ADSL_ENABLE 0x1

/**  POFIPOCO VDSL Mode Enable - Enables/Disables the VDSL Mode in POFIPOCO. */
#define POFIPOCO_GAIN_POFIPOCO_VDSL_MASK 0x1000
#define POFIPOCO_GAIN_POFIPOCO_VDSL_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_VDSL_MASK) >> 12)
#define POFIPOCO_GAIN_POFIPOCO_VDSL_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 12, POFIPOCO_GAIN_POFIPOCO_VDSL_MASK)
/** VDSL Mode Disabled */
#define POFIPOCO_VDSL_POFIPOCO_VDSL_DISABLE 0x0
/** VDSL Mode Enabled (default) */
#define POFIPOCO_VDSL_POFIPOCO_VDSL_ENABLE 0x1

/** POFIPOCO Cascode Programming Opamp 1 - Sets the biasing voltage of the cascodes in the operational amplifier 1 of POFIPOCO. */
#define POFIPOCO_GAIN_POFIPOCO_RCASC_1_MASK 0xc00
#define POFIPOCO_GAIN_POFIPOCO_RCASC_1_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_RCASC_1_MASK) >> 10)
#define POFIPOCO_GAIN_POFIPOCO_RCASC_1_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 10, POFIPOCO_GAIN_POFIPOCO_RCASC_1_MASK)
/** nominal setting */
#define POFIPOCO_RCASC_1_POFIPOCO_OP1_CASC_DEFAULT 0x0
/** +10% (default) */
#define POFIPOCO_RCASC_1_POFIPOCO_OP1_CASC_P10 0x1
/** -10% */
#define POFIPOCO_RCASC_1_POFIPOCO_OP1_CASC_M10 0x2

/** POFIPOCO Passive 1st Order LP Tuning - Tuning of the passive 1st order lowpass at the input of the POFIPOCO.These bits correspond to the 2 MSBs of the Tuning Word for POFIPOCO (see POFIPOCO_PRG_R),which is calculated by the VR9-D. */
#define POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_MASK 0x300
#define POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_MASK) >> 8)
#define POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 8, POFIPOCO_GAIN_POFIPOCO_TRIM_CP1_MASK)
/** Maximum cutoff frequency */
#define POFIPOCO_TRIM_CP1_POFIPOCO_LP1_CUTOFF_MAX 0x0
/** Minimum cutoff frequency */
#define POFIPOCO_TRIM_CP1_POFIPOCO_LP1_CUTOFF_MIN 0x3

/** POFIPOCO Cutoff Frequency adjustment - Adjusts the cutoff frequency of the passive 1st order lowpass at the input of the POFIPOCO according to its gain setting.These bits must be set in combination with the POFIPOCO gain. */
#define POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_CP1_MASK 0xf0
#define POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_CP1_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_CP1_MASK) >> 4)
#define POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_CP1_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 4, POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_CP1_MASK)
/** no filtering */
#define POFIPOCO_PRG_GAIN_CP1_POFIPOCO_LP1_NO_FILTERING 0x0
/** VDSL: for gain = -12dB...-10dB, ADSL: -12dB...3dB */
#define POFIPOCO_PRG_GAIN_CP1_POFIPOCO_LP1_ADJUST_2PF 0x1
/** VDSL: for gain = -9dB...-5dB, ADSL: not allowed */
#define POFIPOCO_PRG_GAIN_CP1_POFIPOCO_LP1_ADJUST_2P5PF 0x3
/** VDSL: for gain = -4dB...-1dB, ADSL: not allowed */
#define POFIPOCO_PRG_GAIN_CP1_POFIPOCO_LP1_ADJUST_3PF 0x7
/** VDSL: for gain = 0dB...3dB, ADSL: not allowed */
#define POFIPOCO_PRG_GAIN_CP1_POFIPOCO_LP1_ADJUST_4PF 0xf

/** POFIPOCO Gain Setting - Sets the gain of POFIPOCO. The programming is binary coded. The stepsize is 1dB */
#define POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_MASK 0xf
#define POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_AFE_GET ((VR9_AfeRead(POFIPOCO_GAIN) & POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_MASK) >> 0)
#define POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_AFE_SET(val) VR9_AfeWrite(POFIPOCO_GAIN, (val) << 0, POFIPOCO_GAIN_POFIPOCO_PRG_GAIN_MASK)
/** -12dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M12DB 0x0
/** -11dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M11DB 0x1
/** -10dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M10DB 0x2
/** -9dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M9DB 0x3
/** -8dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M8DB 0x4
/** -7dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M7DB 0x5
/** -6dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M6DB 0x6
/** -5dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M5DB 0x7
/** -4dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M4DB 0x8
/** -3dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M3DB 0x9
/** -2dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M2DB 0xa
/** -1dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_M1DB 0xb
/** 0dB (default) */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_0DB 0xc
/** 1dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_1DB 0xd
/** 2dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_2DB 0xe
/** 3dB */
#define POFIPOCO_PRG_GAIN_POFIPOCO_GAIN_3DB 0xf


/** Control Register */
#define POFIPOCO_TRIM_1 (AFE_BASE + 0x19)
#define POFIPOCO_TRIM_1_AFE_GET VR9_AfeRead(POFIPOCO_TRIM_1)
#define POFIPOCO_TRIM_1_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_1, (val), 0xFFFF)

/** POFIPOCO Cascode Programming Opamp 2 - Sets the biasing voltage of the cascodes in the operational amplifier 2 of POFIPOCO. */
#define POFIPOCO_TRIM_1_POFIPOCO_RCASC_2_MASK 0xc000
#define POFIPOCO_TRIM_1_POFIPOCO_RCASC_2_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_1) & POFIPOCO_TRIM_1_POFIPOCO_RCASC_2_MASK) >> 14)
#define POFIPOCO_TRIM_1_POFIPOCO_RCASC_2_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_1, (val) << 14, POFIPOCO_TRIM_1_POFIPOCO_RCASC_2_MASK)
/** nominal setting */
#define POFIPOCO_RCASC_2_POFIPOCO_OP2_CASC_DEFAULT 0x0
/** +10% (default) */
#define POFIPOCO_RCASC_2_POFIPOCO_OP2_CASC_P10 0x1
/** -10% */
#define POFIPOCO_RCASC_2_POFIPOCO_OP2_CASC_M10 0x2

/** POFIPOCO ADSL Mode Setting - Sets the ADSL Mode cutoff frequency in POFIPOCO. */
#define POFIPOCO_TRIM_1_POFIPOCO_PRG_ADSL_C_MASK 0x3f00
#define POFIPOCO_TRIM_1_POFIPOCO_PRG_ADSL_C_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_1) & POFIPOCO_TRIM_1_POFIPOCO_PRG_ADSL_C_MASK) >> 8)
#define POFIPOCO_TRIM_1_POFIPOCO_PRG_ADSL_C_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_1, (val) << 8, POFIPOCO_TRIM_1_POFIPOCO_PRG_ADSL_C_MASK)
/** no filtering (default) */
#define POFIPOCO_PRG_ADSL_C_POFIPOCO_ADSL_NO_FILTERING 0x0
/** 2560kHz */
#define POFIPOCO_PRG_ADSL_C_POFIPOCO_ADSL_2560KHZ 0x1
/** 1280kHz */
#define POFIPOCO_PRG_ADSL_C_POFIPOCO_ADSL_1280KHZ 0x3
/** 640kHz */
#define POFIPOCO_PRG_ADSL_C_POFIPOCO_ADSL_640KHZ 0x7
/** 320kHz */
#define POFIPOCO_PRG_ADSL_C_POFIPOCO_ADSL_320KMHZ 0xf
/** 160kHz */
#define POFIPOCO_PRG_ADSL_C_POFIPOCO_ADSL_160KHZ 0x1f
/** 80kHz */
#define POFIPOCO_PRG_ADSL_C_POFIPOCO_ADSL_80KHZ 0x3f

/** POFIPOCO VDSL Mode Additional -12dB Gain - Adds an additional gain of -12dB in VDSL Mode in POFIPOCO. */
#define POFIPOCO_TRIM_1_POFIPOCO_VDSL_M12DB_MASK 0x80
#define POFIPOCO_TRIM_1_POFIPOCO_VDSL_M12DB_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_1) & POFIPOCO_TRIM_1_POFIPOCO_VDSL_M12DB_MASK) >> 7)
#define POFIPOCO_TRIM_1_POFIPOCO_VDSL_M12DB_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_1, (val) << 7, POFIPOCO_TRIM_1_POFIPOCO_VDSL_M12DB_MASK)
/** no additional gain (default) */
#define POFIPOCO_VDSL_M12DB_POFIPOCO_VDSL_M12DB_OFF 0x0
/** -12dB additional gain */
#define POFIPOCO_VDSL_M12DB_POFIPOCO_VDSL_M12DB_ON 0x1

/** POFIPOCO VDSL Mode Additional -6dB Gain - Adds an additional gain of -6dB in VDSL Mode in POFIPOCO. */
#define POFIPOCO_TRIM_1_POFIPOCO_VDSL_M6DB_MASK 0x40
#define POFIPOCO_TRIM_1_POFIPOCO_VDSL_M6DB_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_1) & POFIPOCO_TRIM_1_POFIPOCO_VDSL_M6DB_MASK) >> 6)
#define POFIPOCO_TRIM_1_POFIPOCO_VDSL_M6DB_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_1, (val) << 6, POFIPOCO_TRIM_1_POFIPOCO_VDSL_M6DB_MASK)
/** no additional gain (default) */
#define POFIPOCO_VDSL_M6DB_POFIPOCO_VDSL_M6DB_OFF 0x0
/** -6dB additional gain */
#define POFIPOCO_VDSL_M6DB_POFIPOCO_VDSL_M6DB_ON 0x1

/** POFIPOCO VDSL Mode Setting - Sets the VDSL Mode cutoff frequency in POFIPOCO. */
#define POFIPOCO_TRIM_1_POFIPOCO_PRG_VDSL_C_MASK 0x1f
#define POFIPOCO_TRIM_1_POFIPOCO_PRG_VDSL_C_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_1) & POFIPOCO_TRIM_1_POFIPOCO_PRG_VDSL_C_MASK) >> 0)
#define POFIPOCO_TRIM_1_POFIPOCO_PRG_VDSL_C_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_1, (val) << 0, POFIPOCO_TRIM_1_POFIPOCO_PRG_VDSL_C_MASK)
/** no filtering */
#define POFIPOCO_PRG_VDSL_C_POFIPOCO_VDSL_NO_FILTERING 0x0
/** 40MHz (default) */
#define POFIPOCO_PRG_VDSL_C_POFIPOCO_VDSL_40MHZ 0x2
/** 33MHz */
#define POFIPOCO_PRG_VDSL_C_POFIPOCO_VDSL_33MHZ 0x1
/** 20MHz */
#define POFIPOCO_PRG_VDSL_C_POFIPOCO_VDSL_20MHZ 0x6
/** 10MHz */
#define POFIPOCO_PRG_VDSL_C_POFIPOCO_VDSL_10MHZ 0xe
/** 5MHz */
#define POFIPOCO_PRG_VDSL_C_POFIPOCO_VDSL_5MHZ 0x1e


/** Control Register */
#define POFIPOCO_TRIM_2 (AFE_BASE + 0x1a)
#define POFIPOCO_TRIM_2_AFE_GET VR9_AfeRead(POFIPOCO_TRIM_2)
#define POFIPOCO_TRIM_2_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_2, (val), 0xFFFF)

/** POFIPOCO Output Stage Current Opamp 2 - Programs the current in the output stage of the operational amplifier 2 in POFIPOCO.The programming is Mode dependent (ADSL,VDSL). The programming is thermometer coded. The stepsize is 25% */
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_2_MASK 0xe000
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_2_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_2) & POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_2_MASK) >> 13)
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_2_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_2, (val) << 13, POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_2_MASK)
/** 50% */
#define POFIPOCO_PRG_IOUT_2_POFIPOCO_OP2_IOUT_50P 0x0
/** 75% (default, ADSL Modes) */
#define POFIPOCO_PRG_IOUT_2_POFIPOCO_OP2_IOUT_75P 0x1
/** 100% (default, VDSL Modes) */
#define POFIPOCO_PRG_IOUT_2_POFIPOCO_OP2_IOUT_100P 0x3
/** 125% */
#define POFIPOCO_PRG_IOUT_2_POFIPOCO_OP2_IOUT_125P 0x7

/** POFIPOCO Output Stage Current Opamp 1 - Programs the current in the output stage of the operational amplifier 1 in POFIPOCO.The programming is Mode dependent (ADSL,VDSL). The programming is thermometer coded. The stepsize is 25% */
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_1_MASK 0x1c00
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_1_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_2) & POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_1_MASK) >> 10)
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_1_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_2, (val) << 10, POFIPOCO_TRIM_2_POFIPOCO_PRG_IOUT_1_MASK)
/** 50% (default, ADSL Modes) */
#define POFIPOCO_PRG_IOUT_1_POFIPOCO_OP1_IOUT_50P 0x0
/** 75% */
#define POFIPOCO_PRG_IOUT_1_POFIPOCO_OP1_IOUT_75P 0x1
/** 100% (default, VDSL Modes) */
#define POFIPOCO_PRG_IOUT_1_POFIPOCO_OP1_IOUT_100P 0x3
/** 125% */
#define POFIPOCO_PRG_IOUT_1_POFIPOCO_OP1_IOUT_125P 0x7

/** POFIPOCO Input Stage Current Opamp 2 - Programs the current in the input and common mode stage of the operational amplifier 2 in POFIPOCO.The programming is binary coded. The stepsize is 16% */
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_2_MASK 0x300
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_2_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_2) & POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_2_MASK) >> 8)
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_2_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_2, (val) << 8, POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_2_MASK)
/** minimum current */
#define POFIPOCO_PRG_IIN_2_POFIPOCO_OP2_IIN_MIN 0x0
/** nominal current (default) */
#define POFIPOCO_PRG_IIN_2_POFIPOCO_OP2_IIN_DEFAULT 0x2
/** maximum current */
#define POFIPOCO_PRG_IIN_2_POFIPOCO_OP2_IIN_MAX 0x3

/** POFIPOCO Input Stage Current Opamp 1 - Programs the current in the input and common mode stage of the operational amplifier 1 in POFIPOCO.The programming is binary coded. The stepsize is 16% */
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_1_MASK 0xc0
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_1_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_2) & POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_1_MASK) >> 6)
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_1_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_2, (val) << 6, POFIPOCO_TRIM_2_POFIPOCO_PRG_IIN_1_MASK)
/** minimum current */
#define POFIPOCO_PRG_IIN_1_POFIPOCO_OP1_IIN_MIN 0x0
/** nominal current (default) */
#define POFIPOCO_PRG_IIN_1_POFIPOCO_OP1_IIN_DEFAULT 0x2
/** maximum current */
#define POFIPOCO_PRG_IIN_1_POFIPOCO_OP1_IIN_MAX 0x3

/** POFIPOCO Main Tuning - Tuning of the overall cutoff frequency in POFIPOCO. The Tuning Word is calculated by the VR9-D. */
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_R_MASK 0x3f
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_GET ((VR9_AfeRead(POFIPOCO_TRIM_2) & POFIPOCO_TRIM_2_POFIPOCO_PRG_R_MASK) >> 0)
#define POFIPOCO_TRIM_2_POFIPOCO_PRG_R_AFE_SET(val) VR9_AfeWrite(POFIPOCO_TRIM_2, (val) << 0, POFIPOCO_TRIM_2_POFIPOCO_PRG_R_MASK)
/** Maximum cutoff frequency */
#define POFIPOCO_PRG_R_POFIPOCO_CUTOFF_MAX 0x0
/** Minimum cutoff frequency */
#define POFIPOCO_PRG_R_POFIPOCO_CUTOFF_MIN 0x3f


/** Control Register */
#define DAC1_STATIC (AFE_BASE + 0x1b)
#define DAC1_STATIC_AFE_GET VR9_AfeRead(DAC1_STATIC)
#define DAC1_STATIC_AFE_SET(val) VR9_AfeWrite(DAC1_STATIC, (val), 0xFFFF)

/** DAC1 Data Format - Selects the data format of DAC1 (only valid for data coming from interpolation path). */
#define DAC1_STATIC_DAC1_DATA_FORMAT_MASK 0x4000
#define DAC1_STATIC_DAC1_DATA_FORMAT_AFE_GET ((VR9_AfeRead(DAC1_STATIC) & DAC1_STATIC_DAC1_DATA_FORMAT_MASK) >> 14)
#define DAC1_STATIC_DAC1_DATA_FORMAT_AFE_SET(val) VR9_AfeWrite(DAC1_STATIC, (val) << 14, DAC1_STATIC_DAC1_DATA_FORMAT_MASK)
/** 2's complement (default) */
#define DAC1_DATA_FORMAT_DAC1_DATA_2SCOMPLEMENT 0x0
/** binary offset */
#define DAC1_DATA_FORMAT_DAC1_DATA_BINARYOFFSET 0x1

/** DAC1 Input Source Selection - Selects the data source (output of Interpolation path OR static data from register) for the input of DAC1. */
#define DAC1_STATIC_DAC1_PRG_STATIC_MASK 0x2000
#define DAC1_STATIC_DAC1_PRG_STATIC_AFE_GET ((VR9_AfeRead(DAC1_STATIC) & DAC1_STATIC_DAC1_PRG_STATIC_MASK) >> 13)
#define DAC1_STATIC_DAC1_PRG_STATIC_AFE_SET(val) VR9_AfeWrite(DAC1_STATIC, (val) << 13, DAC1_STATIC_DAC1_PRG_STATIC_MASK)
/** use output data from interpolation path (default) */
#define DAC1_PRG_STATIC_DAC1_DATA_INTPATH 0x0
/** use static data from register */
#define DAC1_PRG_STATIC_DAC1_DATA_STATIC 0x1

/** DAC1 Static Data - Sets static data input for DAC1. The data are binary coded. */
#define DAC1_STATIC_DAC1_STATIC_DATA_MASK 0x1fff
#define DAC1_STATIC_DAC1_STATIC_DATA_AFE_GET ((VR9_AfeRead(DAC1_STATIC) & DAC1_STATIC_DAC1_STATIC_DATA_MASK) >> 0)
#define DAC1_STATIC_DAC1_STATIC_DATA_AFE_SET(val) VR9_AfeWrite(DAC1_STATIC, (val) << 0, DAC1_STATIC_DAC1_STATIC_DATA_MASK)
/** minimum value (default) */
#define DAC1_STATIC_DATA_DAC1_STATIC_DATA_MIN 0x0
/** maximum value */
#define DAC1_STATIC_DATA_DAC1_STATIC_DATA_MAX 0x1fff


/** Control Register */
#define DAC1_CAL_1 (AFE_BASE + 0x1c)
#define DAC1_CAL_1_AFE_GET VR9_AfeRead(DAC1_CAL_1)
#define DAC1_CAL_1_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_1, (val), 0xFFFF)

/** DAC1 Calibration Reference Cells - Enables/Disables the Calibration of the Reference cells of DAC1. */
#define DAC1_CAL_1_DAC1_NOCAL_REF_MASK 0x8000
#define DAC1_CAL_1_DAC1_NOCAL_REF_AFE_GET ((VR9_AfeRead(DAC1_CAL_1) & DAC1_CAL_1_DAC1_NOCAL_REF_MASK) >> 15)
#define DAC1_CAL_1_DAC1_NOCAL_REF_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_1, (val) << 15, DAC1_CAL_1_DAC1_NOCAL_REF_MASK)
/** Calibration Enabled (default) */
#define DAC1_NOCAL_REF_DAC1_REF_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC1_NOCAL_REF_DAC1_REF_CAL_DISABLED 0x1

/** DAC1 Calibration of LSBA cells Enable/Disable - Enables/Disables the Calibration of the LSBA cells of DAC1. */
#define DAC1_CAL_1_DAC1_NOCAL_LSBAQ_MASK 0x4000
#define DAC1_CAL_1_DAC1_NOCAL_LSBAQ_AFE_GET ((VR9_AfeRead(DAC1_CAL_1) & DAC1_CAL_1_DAC1_NOCAL_LSBAQ_MASK) >> 14)
#define DAC1_CAL_1_DAC1_NOCAL_LSBAQ_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_1, (val) << 14, DAC1_CAL_1_DAC1_NOCAL_LSBAQ_MASK)
/** Calibration Enabled */
#define DAC1_NOCAL_LSBAQ_DAC1_LSBAQ_CAL_ENABLED 0x0
/** Calibration Disabled (default) */
#define DAC1_NOCAL_LSBAQ_DAC1_LSBAQ_CAL_DISABLED 0x1

/** DAC1 Calibration Analog Enable/Disable - Enables/Disables the Calibration in the analog part of DAC1 (must be set to the same value as DAC1_NOCAL). */
#define DAC1_CAL_1_DAC1_NOCAL_MATRIX_MASK 0x2000
#define DAC1_CAL_1_DAC1_NOCAL_MATRIX_AFE_GET ((VR9_AfeRead(DAC1_CAL_1) & DAC1_CAL_1_DAC1_NOCAL_MATRIX_MASK) >> 13)
#define DAC1_CAL_1_DAC1_NOCAL_MATRIX_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_1, (val) << 13, DAC1_CAL_1_DAC1_NOCAL_MATRIX_MASK)
/** Calibration Enabled (default) */
#define DAC1_NOCAL_MATRIX_DAC1_MATRIX_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC1_NOCAL_MATRIX_DAC1_MATRIX_CAL_DISABLED 0x1

/** DAC1 Calibration Digital Enable/Disable -  Enables/Disables the Calibration in the digital part of DAC1. */
#define DAC1_CAL_1_DAC1_NOCAL_MASK 0x1000
#define DAC1_CAL_1_DAC1_NOCAL_AFE_GET ((VR9_AfeRead(DAC1_CAL_1) & DAC1_CAL_1_DAC1_NOCAL_MASK) >> 12)
#define DAC1_CAL_1_DAC1_NOCAL_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_1, (val) << 12, DAC1_CAL_1_DAC1_NOCAL_MASK)
/** Calibration Enabled (default) */
#define DAC1_NOCAL_DAC1_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC1_NOCAL_DAC1_CAL_DISABLED 0x1

/** DAC1 Fixed Calibration Cycle - Sets the fixed calibration cycle in the DAC1. */
#define DAC1_CAL_1_DAC1_CAL_NFIX_MASK 0x7ff
#define DAC1_CAL_1_DAC1_CAL_NFIX_AFE_GET ((VR9_AfeRead(DAC1_CAL_1) & DAC1_CAL_1_DAC1_CAL_NFIX_MASK) >> 0)
#define DAC1_CAL_1_DAC1_CAL_NFIX_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_1, (val) << 0, DAC1_CAL_1_DAC1_CAL_NFIX_MASK)
/** minimum */
#define DAC1_CAL_NFIX_DAC1_CAL_FIX_MIN 0x0
/** nominal (default) */
#define DAC1_CAL_NFIX_DAC1_CAL_FIX_DEFAULT 0x1ff
/** maximum */
#define DAC1_CAL_NFIX_DAC1_CAL_FIX_MAX 0x7ff


/** Control Register */
#define DAC1_CAL_2 (AFE_BASE + 0x1d)
#define DAC1_CAL_2_AFE_GET VR9_AfeRead(DAC1_CAL_2)
#define DAC1_CAL_2_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_2, (val), 0xFFFF)

/** DAC1 Random Calibration - Enables/Disables the use of a variable calibration time in DAC1. */
#define DAC1_CAL_2_DAC1_RANDOM_OFF_MASK 0x4000
#define DAC1_CAL_2_DAC1_RANDOM_OFF_AFE_GET ((VR9_AfeRead(DAC1_CAL_2) & DAC1_CAL_2_DAC1_RANDOM_OFF_MASK) >> 14)
#define DAC1_CAL_2_DAC1_RANDOM_OFF_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_2, (val) << 14, DAC1_CAL_2_DAC1_RANDOM_OFF_MASK)
/** Enable variable calibration time (default) */
#define DAC1_RANDOM_OFF_DAC1_CAL_RANDOM_ON 0x0
/** Disable variable calibration time */
#define DAC1_RANDOM_OFF_DAC1_CAL_RANDOM_OFF 0x1

/** DAC1 Calibration of Current Cells - Sets all current cells of DAC1 in calibration mode (no current cell is connected to the output of the DAC1). */
#define DAC1_CAL_2_DAC1_SET_CAL_ALL_MASK 0x2000
#define DAC1_CAL_2_DAC1_SET_CAL_ALL_AFE_GET ((VR9_AfeRead(DAC1_CAL_2) & DAC1_CAL_2_DAC1_SET_CAL_ALL_MASK) >> 13)
#define DAC1_CAL_2_DAC1_SET_CAL_ALL_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_2, (val) << 13, DAC1_CAL_2_DAC1_SET_CAL_ALL_MASK)
/** normal */
#define DAC1_SET_CAL_ALL_DAC1_SET_CAL_ALL_OFF 0x0
/** all current cells in calibration (default) */
#define DAC1_SET_CAL_ALL_DAC1_SET_CAL_ALL_ON 0x1

/** DAC1 Calibration Shift Register Reset - Resets the Shift Register Logic used for Calibration in DAC1. */
#define DAC1_CAL_2_DAC1_RESET_CAL_MASK 0x1000
#define DAC1_CAL_2_DAC1_RESET_CAL_AFE_GET ((VR9_AfeRead(DAC1_CAL_2) & DAC1_CAL_2_DAC1_RESET_CAL_MASK) >> 12)
#define DAC1_CAL_2_DAC1_RESET_CAL_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_2, (val) << 12, DAC1_CAL_2_DAC1_RESET_CAL_MASK)
/** normal (default) */
#define DAC1_RESET_CAL_DAC1_CAL_RESET_OFF 0x0
/** Reset is active */
#define DAC1_RESET_CAL_DAC1_CAL_RESET_ON 0x1

/** DAC1 Variable Calibration Cycle - Sets the variable calibration cycle in DAC1. */
#define DAC1_CAL_2_DAC1_CAL_NVAR_MASK 0x7ff
#define DAC1_CAL_2_DAC1_CAL_NVAR_AFE_GET ((VR9_AfeRead(DAC1_CAL_2) & DAC1_CAL_2_DAC1_CAL_NVAR_MASK) >> 0)
#define DAC1_CAL_2_DAC1_CAL_NVAR_AFE_SET(val) VR9_AfeWrite(DAC1_CAL_2, (val) << 0, DAC1_CAL_2_DAC1_CAL_NVAR_MASK)
/** minimum */
#define DAC1_CAL_NVAR_DAC1_CAL_VAR_MIN 0x0
/** nominal (default) */
#define DAC1_CAL_NVAR_DAC1_CAL_VAR_DEFAULT 0x1ff
/** maximum */
#define DAC1_CAL_NVAR_DAC1_CAL_VAR_MAX 0x7ff


/** Control Register */
#define DAC1_MISC_1 (AFE_BASE + 0x1e)
#define DAC1_MISC_1_AFE_GET VR9_AfeRead(DAC1_MISC_1)
#define DAC1_MISC_1_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_1, (val), 0xFFFF)

/** DAC1 Power Down - Sets the Power Down Mode for DAC1. */
#define DAC1_MISC_1_DAC1_PD_BIAS_MASK 0x1000
#define DAC1_MISC_1_DAC1_PD_BIAS_AFE_GET ((VR9_AfeRead(DAC1_MISC_1) & DAC1_MISC_1_DAC1_PD_BIAS_MASK) >> 12)
#define DAC1_MISC_1_DAC1_PD_BIAS_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_1, (val) << 12, DAC1_MISC_1_DAC1_PD_BIAS_MASK)
/** Power Up */
#define DAC1_PD_BIAS_DAC1_PU 0x0
/** Power Down (default) */
#define DAC1_PD_BIAS_DAC1_PD 0x1

/** DAC1 Clock Inversion - Inverts the input clock of the digital part of DAC1. */
#define DAC1_MISC_1_DAC1_CLK_DIG_INV_MASK 0x800
#define DAC1_MISC_1_DAC1_CLK_DIG_INV_AFE_GET ((VR9_AfeRead(DAC1_MISC_1) & DAC1_MISC_1_DAC1_CLK_DIG_INV_MASK) >> 11)
#define DAC1_MISC_1_DAC1_CLK_DIG_INV_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_1, (val) << 11, DAC1_MISC_1_DAC1_CLK_DIG_INV_MASK)
/** clock is not inverted (default) */
#define DAC1_CLK_DIG_INV_DAC1_CLK_DIG_NO_INV 0x0
/** clock is inverted */
#define DAC1_CLK_DIG_INV_DAC1_CLK_DIG_INV 0x1

/** DAC1 Clock Delay - Programs the delay of the input clock of the digital part of DAC1. */
#define DAC1_MISC_1_DAC1_REG_DEL_MASK 0x600
#define DAC1_MISC_1_DAC1_REG_DEL_AFE_GET ((VR9_AfeRead(DAC1_MISC_1) & DAC1_MISC_1_DAC1_REG_DEL_MASK) >> 9)
#define DAC1_MISC_1_DAC1_REG_DEL_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_1, (val) << 9, DAC1_MISC_1_DAC1_REG_DEL_MASK)
/** minimum delay (default) */
#define DAC1_REG_DEL_DAC1_REG_DEL_MIN 0x0
/** maximum delay */
#define DAC1_REG_DEL_DAC1_REG_DEL_MAX 0x3

/** DAC1 Fine Gain Setting - Sets the fine gain in DAC1. The programming is binary coded. The stepsize is +0.11dB. */
#define DAC1_MISC_1_DAC1_TRIM_FINE_MASK 0xf0
#define DAC1_MISC_1_DAC1_TRIM_FINE_AFE_GET ((VR9_AfeRead(DAC1_MISC_1) & DAC1_MISC_1_DAC1_TRIM_FINE_MASK) >> 4)
#define DAC1_MISC_1_DAC1_TRIM_FINE_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_1, (val) << 4, DAC1_MISC_1_DAC1_TRIM_FINE_MASK)
/** 0dB */
#define DAC1_TRIM_FINE_DAC1_GAIN_FINE_MIN 0x0
/** 1.65dB (=15*0.11dB) */
#define DAC1_TRIM_FINE_DAC1_GAIN_FINE_MAX 0xf

/** DAC1 Coarse Gain Setting - Sets the coarse gain in DAC1. The total DAC1 gain is the sum of Coarse Gain + Fine Gain. */
#define DAC1_MISC_1_DAC1_TRIM_COARSE_MASK 0xf
#define DAC1_MISC_1_DAC1_TRIM_COARSE_AFE_GET ((VR9_AfeRead(DAC1_MISC_1) & DAC1_MISC_1_DAC1_TRIM_COARSE_MASK) >> 0)
#define DAC1_MISC_1_DAC1_TRIM_COARSE_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_1, (val) << 0, DAC1_MISC_1_DAC1_TRIM_COARSE_MASK)
/** -2.90dB */
#define DAC1_TRIM_COARSE_DAC1_GAIN_COARSE_M2DB90 0x1
/** -1.45dB (default) */
#define DAC1_TRIM_COARSE_DAC1_GAIN_COARSE_M1DB45 0x2
/** -0.25dB */
#define DAC1_TRIM_COARSE_DAC1_GAIN_COARSE_M0DB25 0x4
/** +0.85dB */
#define DAC1_TRIM_COARSE_DAC1_GAIN_COARSE_0DB85 0x8


/** Control Register */
#define DAC1_MISC_2 (AFE_BASE + 0x1f)
#define DAC1_MISC_2_AFE_GET VR9_AfeRead(DAC1_MISC_2)
#define DAC1_MISC_2_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_2, (val), 0xFFFF)

/** DAC1 Calibration Engine Clock Divider - Sets the division factor for the clock of calibration engine in the DAC digital part. */
#define DAC1_MISC_2_DAC1_CLK_DIV_MASK 0x3000
#define DAC1_MISC_2_DAC1_CLK_DIV_AFE_GET ((VR9_AfeRead(DAC1_MISC_2) & DAC1_MISC_2_DAC1_CLK_DIV_MASK) >> 12)
#define DAC1_MISC_2_DAC1_CLK_DIV_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_2, (val) << 12, DAC1_MISC_2_DAC1_CLK_DIV_MASK)
/** no division (default) */
#define DAC1_CLK_DIV_DAC1_CAL_CLK_NODIV 0x0
/** division by 2 */
#define DAC1_CLK_DIV_DAC1_CAL_CLK_DIV2 0x1
/** division by 4 */
#define DAC1_CLK_DIV_DAC1_CAL_CLK_DIV4 0x2
/** division by 8 */
#define DAC1_CLK_DIV_DAC1_CAL_CLK_DIV8 0x3

/** DAC1 Reference Cells Cyclic Calibration - Enables/Disables the cyclic calibration of the reference current cell of DAC1. */
#define DAC1_MISC_2_DAC1_ENABLE_ROT_MASK 0x400
#define DAC1_MISC_2_DAC1_ENABLE_ROT_AFE_GET ((VR9_AfeRead(DAC1_MISC_2) & DAC1_MISC_2_DAC1_ENABLE_ROT_MASK) >> 10)
#define DAC1_MISC_2_DAC1_ENABLE_ROT_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_2, (val) << 10, DAC1_MISC_2_DAC1_ENABLE_ROT_MASK)
/** Disabled */
#define DAC1_ENABLE_ROT_DAC1_ROT_DISABLE 0x0
/** Enabled (default) */
#define DAC1_ENABLE_ROT_DAC1_ROT_ENABLE 0x1

/** DAC1 Mode Setting - Selets the Mode (VDSL/ADSL) of DAC1. In ADSL Mode only the MSB current cells are used. */
#define DAC1_MISC_2_DAC1_DATA_MODE_MASK 0x200
#define DAC1_MISC_2_DAC1_DATA_MODE_AFE_GET ((VR9_AfeRead(DAC1_MISC_2) & DAC1_MISC_2_DAC1_DATA_MODE_MASK) >> 9)
#define DAC1_MISC_2_DAC1_DATA_MODE_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_2, (val) << 9, DAC1_MISC_2_DAC1_DATA_MODE_MASK)
/** ADSL Mode = 8bit (default) */
#define DAC1_DATA_MODE_DAC1_ADSL 0x0
/** VDSL Mode = 13bit */
#define DAC1_DATA_MODE_DAC1_VDSL 0x1

/** DAC1 Dummy Cell Switching - Enables/Disables the switching of the dummy current cells in DAC1. */
#define DAC1_MISC_2_DAC1_DISABLE_DSW_MASK 0x100
#define DAC1_MISC_2_DAC1_DISABLE_DSW_AFE_GET ((VR9_AfeRead(DAC1_MISC_2) & DAC1_MISC_2_DAC1_DISABLE_DSW_MASK) >> 8)
#define DAC1_MISC_2_DAC1_DISABLE_DSW_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_2, (val) << 8, DAC1_MISC_2_DAC1_DISABLE_DSW_MASK)
/** Enabled (default) */
#define DAC1_DISABLE_DSW_DAC1_DSW_ENABLE 0x0
/** Disabled */
#define DAC1_DISABLE_DSW_DAC1_DSW_DISABLE 0x1

/** DAC1 DEM Mode ISB Cells - Sets the Dynamic Element Matching Mode for the ISB current cells in DAC1 (only values '000'...'101' are valid). */
#define DAC1_MISC_2_DAC1_DEM_MODE_ISB_MASK 0x70
#define DAC1_MISC_2_DAC1_DEM_MODE_ISB_AFE_GET ((VR9_AfeRead(DAC1_MISC_2) & DAC1_MISC_2_DAC1_DEM_MODE_ISB_MASK) >> 4)
#define DAC1_MISC_2_DAC1_DEM_MODE_ISB_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_2, (val) << 4, DAC1_MISC_2_DAC1_DEM_MODE_ISB_MASK)
/** no DEM (default) */
#define DAC1_DEM_MODE_ISB_DAC1_ISB_NO_DEM 0x0
/** CLA1 */
#define DAC1_DEM_MODE_ISB_DAC1_ISB_CLA1 0x1
/** CLA1 */
#define DAC1_DEM_MODE_ISB_DAC1_ISB_CLA2 0x2
/** CLA1 */
#define DAC1_DEM_MODE_ISB_DAC1_ISB_CLA3 0x3
/** CLA1 */
#define DAC1_DEM_MODE_ISB_DAC1_ISB_CLA4 0x4
/** DWA (Dynamic Weigthed Averaging) */
#define DAC1_DEM_MODE_ISB_DAC1_ISB_DWA 0x5

/** DAC1 DEM Mode MSB Cells - Sets the Dynamic Element Matching Mode for the MSB current cells in DAC1 (only values '000'...'101' are valid). */
#define DAC1_MISC_2_DAC1_DEM_MODE_MSB_MASK 0x7
#define DAC1_MISC_2_DAC1_DEM_MODE_MSB_AFE_GET ((VR9_AfeRead(DAC1_MISC_2) & DAC1_MISC_2_DAC1_DEM_MODE_MSB_MASK) >> 0)
#define DAC1_MISC_2_DAC1_DEM_MODE_MSB_AFE_SET(val) VR9_AfeWrite(DAC1_MISC_2, (val) << 0, DAC1_MISC_2_DAC1_DEM_MODE_MSB_MASK)
/** no DEM (default) */
#define DAC1_DEM_MODE_MSB_DAC1_MSB_NO_DEM 0x0
/** CLA1 */
#define DAC1_DEM_MODE_MSB_DAC1_MSB_CLA1 0x1
/** CLA1 */
#define DAC1_DEM_MODE_MSB_DAC1_MSB_CLA2 0x2
/** CLA1 */
#define DAC1_DEM_MODE_MSB_DAC1_MSB_CLA3 0x3
/** CLA1 */
#define DAC1_DEM_MODE_MSB_DAC1_MSB_CLA4 0x4
/** DWA (Dynamic Weigthed Averaging) */
#define DAC1_DEM_MODE_MSB_DAC1_MSB_DWA 0x5


/** Control Register */
#define DAC2_STATIC (AFE_BASE + 0x20)
#define DAC2_STATIC_AFE_GET VR9_AfeRead(DAC2_STATIC)
#define DAC2_STATIC_AFE_SET(val) VR9_AfeWrite(DAC2_STATIC, (val), 0xFFFF)

/** DAC2 Data Format - Selects the data format of DAC2 (only valid for data coming from interpolation path). */
#define DAC2_STATIC_DAC2_DATA_FORMAT_MASK 0x4000
#define DAC2_STATIC_DAC2_DATA_FORMAT_AFE_GET ((VR9_AfeRead(DAC2_STATIC) & DAC2_STATIC_DAC2_DATA_FORMAT_MASK) >> 14)
#define DAC2_STATIC_DAC2_DATA_FORMAT_AFE_SET(val) VR9_AfeWrite(DAC2_STATIC, (val) << 14, DAC2_STATIC_DAC2_DATA_FORMAT_MASK)
/** 2's complement (default) */
#define DAC2_DATA_FORMAT_DAC2_DATA_2SCOMPLEMENT 0x0
/** binary offset */
#define DAC2_DATA_FORMAT_DAC2_DATA_BINARYOFFSET 0x1

/** DAC1 Input Source Selection - Selects the data source (output of Interpolation path OR static data from register) for the input of DAC1. */
#define DAC2_STATIC_DAC2_PRG_STATIC_MASK 0x2000
#define DAC2_STATIC_DAC2_PRG_STATIC_AFE_GET ((VR9_AfeRead(DAC2_STATIC) & DAC2_STATIC_DAC2_PRG_STATIC_MASK) >> 13)
#define DAC2_STATIC_DAC2_PRG_STATIC_AFE_SET(val) VR9_AfeWrite(DAC2_STATIC, (val) << 13, DAC2_STATIC_DAC2_PRG_STATIC_MASK)
/** use output data from interpolation path (default) */
#define DAC2_PRG_STATIC_DAC2_DATA_INTPATH 0x0
/** use static data from register */
#define DAC2_PRG_STATIC_DAC2_DATA_STATIC 0x1

/** DAC2 Static Data - Sets static data input for DAC2. The data are binary coded. */
#define DAC2_STATIC_DAC2_STATIC_DATA_MASK 0x1fff
#define DAC2_STATIC_DAC2_STATIC_DATA_AFE_GET ((VR9_AfeRead(DAC2_STATIC) & DAC2_STATIC_DAC2_STATIC_DATA_MASK) >> 0)
#define DAC2_STATIC_DAC2_STATIC_DATA_AFE_SET(val) VR9_AfeWrite(DAC2_STATIC, (val) << 0, DAC2_STATIC_DAC2_STATIC_DATA_MASK)
/** minimum value (default) */
#define DAC2_STATIC_DATA_DAC2_STATIC_DATA_MIN 0x0
/** maximum value */
#define DAC2_STATIC_DATA_DAC2_STATIC_DATA_MAX 0x1fff


/** Control Register */
#define DAC2_CAL_1 (AFE_BASE + 0x21)
#define DAC2_CAL_1_AFE_GET VR9_AfeRead(DAC2_CAL_1)
#define DAC2_CAL_1_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_1, (val), 0xFFFF)

/** DAC2 Calibration Reference Cells - Enables/Disables the Calibration of the Reference cells of DAC2. */
#define DAC2_CAL_1_DAC2_NOCAL_REFERENCE_MASK 0x8000
#define DAC2_CAL_1_DAC2_NOCAL_REFERENCE_AFE_GET ((VR9_AfeRead(DAC2_CAL_1) & DAC2_CAL_1_DAC2_NOCAL_REFERENCE_MASK) >> 15)
#define DAC2_CAL_1_DAC2_NOCAL_REFERENCE_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_1, (val) << 15, DAC2_CAL_1_DAC2_NOCAL_REFERENCE_MASK)
/** Calibration Enabled (default) */
#define DAC2_NOCAL_REFERENCE_DAC2_REF_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC2_NOCAL_REFERENCE_DAC2_REF_CAL_DISABLED 0x1

/** DAC2 Calibration of MSB and ISB cells Enable/Disable - Enables/Disables the Calibration of the MSB and ISB cells of DAC2. */
#define DAC2_CAL_1_DAC2_NOCAL_MSB_ISB_MASK 0x4000
#define DAC2_CAL_1_DAC2_NOCAL_MSB_ISB_AFE_GET ((VR9_AfeRead(DAC2_CAL_1) & DAC2_CAL_1_DAC2_NOCAL_MSB_ISB_MASK) >> 14)
#define DAC2_CAL_1_DAC2_NOCAL_MSB_ISB_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_1, (val) << 14, DAC2_CAL_1_DAC2_NOCAL_MSB_ISB_MASK)
/** Calibration Enabled (default) */
#define DAC2_NOCAL_MSB_ISB_DAC2_MSB_ISB_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC2_NOCAL_MSB_ISB_DAC2_MSB_ISB_CAL_DISABLED 0x1

/** DAC2 Calibration of LSB cells Enable/Disable - Enables/Disables the Calibration of the LSB cells of DAC2. */
#define DAC2_CAL_1_DAC2_NOCAL_LSB_MASK 0x2000
#define DAC2_CAL_1_DAC2_NOCAL_LSB_AFE_GET ((VR9_AfeRead(DAC2_CAL_1) & DAC2_CAL_1_DAC2_NOCAL_LSB_MASK) >> 13)
#define DAC2_CAL_1_DAC2_NOCAL_LSB_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_1, (val) << 13, DAC2_CAL_1_DAC2_NOCAL_LSB_MASK)
/** Calibration Enabled (default) */
#define DAC2_NOCAL_LSB_DAC2_LSB_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC2_NOCAL_LSB_DAC2_LSB_CAL_DISABLED 0x1

/** DAC2 Calibration Digital Enable/Disable -  Enables/Disables the Calibration in the digital part of DAC2. */
#define DAC2_CAL_1_DAC2_NOCAL_MASK 0x1000
#define DAC2_CAL_1_DAC2_NOCAL_AFE_GET ((VR9_AfeRead(DAC2_CAL_1) & DAC2_CAL_1_DAC2_NOCAL_MASK) >> 12)
#define DAC2_CAL_1_DAC2_NOCAL_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_1, (val) << 12, DAC2_CAL_1_DAC2_NOCAL_MASK)
/** Calibration Enabled (default) */
#define DAC2_NOCAL_DAC2_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC2_NOCAL_DAC2_CAL_DISABLED 0x1

/** DAC2 Calibration Root Reference Cell - Enables/Disables the Calibration of the root reference cell of DAC2. */
#define DAC2_CAL_1_DAC2_NOCAL_ROOT_MASK 0x800
#define DAC2_CAL_1_DAC2_NOCAL_ROOT_AFE_GET ((VR9_AfeRead(DAC2_CAL_1) & DAC2_CAL_1_DAC2_NOCAL_ROOT_MASK) >> 11)
#define DAC2_CAL_1_DAC2_NOCAL_ROOT_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_1, (val) << 11, DAC2_CAL_1_DAC2_NOCAL_ROOT_MASK)
/** Calibration Enabled (default) */
#define DAC2_NOCAL_ROOT_DAC2_ROOTREF_CAL_ENABLED 0x0
/** Calibration Disabled */
#define DAC2_NOCAL_ROOT_DAC2_ROOTREF_CAL_DISABLED 0x1

/** DAC2 Fixed Calibration Cycle - Sets the fixed calibration cycle in the DAC2. */
#define DAC2_CAL_1_DAC2_CAL_NFIX_MASK 0x7ff
#define DAC2_CAL_1_DAC2_CAL_NFIX_AFE_GET ((VR9_AfeRead(DAC2_CAL_1) & DAC2_CAL_1_DAC2_CAL_NFIX_MASK) >> 0)
#define DAC2_CAL_1_DAC2_CAL_NFIX_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_1, (val) << 0, DAC2_CAL_1_DAC2_CAL_NFIX_MASK)
/** minimum */
#define DAC2_CAL_NFIX_DAC2_CAL_FIX_MIN 0x0
/** nominal (default) */
#define DAC2_CAL_NFIX_DAC2_CAL_FIX_DEFAULT 0xff
/** maximum */
#define DAC2_CAL_NFIX_DAC2_CAL_FIX_MAX 0x7ff


/** Control Register */
#define DAC2_CAL_2 (AFE_BASE + 0x22)
#define DAC2_CAL_2_AFE_GET VR9_AfeRead(DAC2_CAL_2)
#define DAC2_CAL_2_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_2, (val), 0xFFFF)

/** DAC2 Random Calibration - Enables/Disables the use of a variable calibration time in DAC2. */
#define DAC2_CAL_2_DAC2_RANDOM_OFF_MASK 0x4000
#define DAC2_CAL_2_DAC2_RANDOM_OFF_AFE_GET ((VR9_AfeRead(DAC2_CAL_2) & DAC2_CAL_2_DAC2_RANDOM_OFF_MASK) >> 14)
#define DAC2_CAL_2_DAC2_RANDOM_OFF_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_2, (val) << 14, DAC2_CAL_2_DAC2_RANDOM_OFF_MASK)
/** Enable variable calibration time (default) */
#define DAC2_RANDOM_OFF_DAC2_CAL_RANDOM_ON 0x0
/** Disable variable calibration time */
#define DAC2_RANDOM_OFF_DAC2_CAL_RANDOM_OFF 0x1

/** DAC2 Calibration of Current Cells - Sets all current cells of DAC2 in calibration mode (no current cell is connected to the output of the DAC2).This setting is important to disconnect completely the ECHO-path from the RX-path. */
#define DAC2_CAL_2_DAC2_SET_CAL_ALL_MASK 0x2000
#define DAC2_CAL_2_DAC2_SET_CAL_ALL_AFE_GET ((VR9_AfeRead(DAC2_CAL_2) & DAC2_CAL_2_DAC2_SET_CAL_ALL_MASK) >> 13)
#define DAC2_CAL_2_DAC2_SET_CAL_ALL_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_2, (val) << 13, DAC2_CAL_2_DAC2_SET_CAL_ALL_MASK)
/** normal */
#define DAC2_SET_CAL_ALL_DAC2_SET_CAL_ALL_OFF 0x0
/** all current cells in calibration (default) */
#define DAC2_SET_CAL_ALL_DAC2_SET_CAL_ALL_ON 0x1

/** DAC2 Calibration Shift Register Reset - Resets the Shift Register Logic used for Calibration in DAC2. */
#define DAC2_CAL_2_DAC2_RESET_CAL_MASK 0x1000
#define DAC2_CAL_2_DAC2_RESET_CAL_AFE_GET ((VR9_AfeRead(DAC2_CAL_2) & DAC2_CAL_2_DAC2_RESET_CAL_MASK) >> 12)
#define DAC2_CAL_2_DAC2_RESET_CAL_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_2, (val) << 12, DAC2_CAL_2_DAC2_RESET_CAL_MASK)
/** normal (default) */
#define DAC2_RESET_CAL_DAC2_CAL_RESET_OFF 0x0
/** Reset is active */
#define DAC2_RESET_CAL_DAC2_CAL_RESET_ON 0x1

/** DAC2 Variable Calibration Cycle - Sets the variable calibration cycle in the DAC2. */
#define DAC2_CAL_2_DAC2_CAL_NVAR_MASK 0x7ff
#define DAC2_CAL_2_DAC2_CAL_NVAR_AFE_GET ((VR9_AfeRead(DAC2_CAL_2) & DAC2_CAL_2_DAC2_CAL_NVAR_MASK) >> 0)
#define DAC2_CAL_2_DAC2_CAL_NVAR_AFE_SET(val) VR9_AfeWrite(DAC2_CAL_2, (val) << 0, DAC2_CAL_2_DAC2_CAL_NVAR_MASK)
/** minimum */
#define DAC2_CAL_NVAR_DAC2_CAL_VAR_MIN 0x0
/** nominal (default) */
#define DAC2_CAL_NVAR_DAC2_CAL_VAR_DEFAULT 0xff
/** maximum */
#define DAC2_CAL_NVAR_DAC2_CAL_VAR_MAX 0x7ff


/** Control Register */
#define DAC2_MISC (AFE_BASE + 0x23)
#define DAC2_MISC_AFE_GET VR9_AfeRead(DAC2_MISC)
#define DAC2_MISC_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val), 0xFFFF)

/** DAC2 Power Down - Sets the Power Down Mode for DAC2. */
#define DAC2_MISC_DAC2_PD_BIAS_MASK 0x1000
#define DAC2_MISC_DAC2_PD_BIAS_AFE_GET ((VR9_AfeRead(DAC2_MISC) & DAC2_MISC_DAC2_PD_BIAS_MASK) >> 12)
#define DAC2_MISC_DAC2_PD_BIAS_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val) << 12, DAC2_MISC_DAC2_PD_BIAS_MASK)
/** Power Up */
#define DAC2_PD_BIAS_DAC2_PU 0x0
/** Power Down (default) */
#define DAC2_PD_BIAS_DAC2_PD 0x1

/** DAC2 Reference Cells Cyclic Calibration - Enables/Disables the cyclic calibration of the reference current cell of DAC2. */
#define DAC2_MISC_DAC2_ENABLE_ROT_MASK 0x400
#define DAC2_MISC_DAC2_ENABLE_ROT_AFE_GET ((VR9_AfeRead(DAC2_MISC) & DAC2_MISC_DAC2_ENABLE_ROT_MASK) >> 10)
#define DAC2_MISC_DAC2_ENABLE_ROT_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val) << 10, DAC2_MISC_DAC2_ENABLE_ROT_MASK)
/** Disabled */
#define DAC2_ENABLE_ROT_DAC2_ROT_DISABLE 0x0
/** Enabled (default) */
#define DAC2_ENABLE_ROT_DAC2_ROT_ENABLE 0x1

/** DAC2 Interleaving IB current cells - Enables/Disables interleaving of ISB current cells in DAC2. */
#define DAC2_MISC_DAC2_IL_ENABLE_ISB_MASK 0x200
#define DAC2_MISC_DAC2_IL_ENABLE_ISB_AFE_GET ((VR9_AfeRead(DAC2_MISC) & DAC2_MISC_DAC2_IL_ENABLE_ISB_MASK) >> 9)
#define DAC2_MISC_DAC2_IL_ENABLE_ISB_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val) << 9, DAC2_MISC_DAC2_IL_ENABLE_ISB_MASK)
/** Disabled */
#define DAC2_IL_ENABLE_ISB_DAC2_IL_ISB_DISABLED 0x0
/** Enabled (default) */
#define DAC2_IL_ENABLE_ISB_DAC2_IL_ISB_ENABLED 0x1

/** DAC2 Interleaving MSB current cells - Enables/Disables interleaving of MSB current cells in DAC2. */
#define DAC2_MISC_DAC2_IL_ENABLE_MSB_MASK 0x100
#define DAC2_MISC_DAC2_IL_ENABLE_MSB_AFE_GET ((VR9_AfeRead(DAC2_MISC) & DAC2_MISC_DAC2_IL_ENABLE_MSB_MASK) >> 8)
#define DAC2_MISC_DAC2_IL_ENABLE_MSB_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val) << 8, DAC2_MISC_DAC2_IL_ENABLE_MSB_MASK)
/** Disabled */
#define DAC2_IL_ENABLE_MSB_DAC2_IL_MSB_DISABLED 0x0
/** Enabled (default) */
#define DAC2_IL_ENABLE_MSB_DAC2_IL_MSB_ENABLED 0x1

/** DAC2 Clock Inversion - Inverts the input clock of the digital part of DAC2. */
#define DAC2_MISC_DAC2_CLK_DIG_INV_MASK 0x80
#define DAC2_MISC_DAC2_CLK_DIG_INV_AFE_GET ((VR9_AfeRead(DAC2_MISC) & DAC2_MISC_DAC2_CLK_DIG_INV_MASK) >> 7)
#define DAC2_MISC_DAC2_CLK_DIG_INV_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val) << 7, DAC2_MISC_DAC2_CLK_DIG_INV_MASK)
/** clock is not inverted (default) */
#define DAC2_CLK_DIG_INV_DAC2_CLK_DIG_NO_INV 0x0
/** clock is inverted */
#define DAC2_CLK_DIG_INV_DAC2_CLK_DIG_INV 0x1

/** DAC2 Clock Delay - Programs the delay of the input clock of the digital part of DAC2. */
#define DAC2_MISC_DAC2_REG_DEL_MASK 0x60
#define DAC2_MISC_DAC2_REG_DEL_AFE_GET ((VR9_AfeRead(DAC2_MISC) & DAC2_MISC_DAC2_REG_DEL_MASK) >> 5)
#define DAC2_MISC_DAC2_REG_DEL_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val) << 5, DAC2_MISC_DAC2_REG_DEL_MASK)
/** minimum delay (default) */
#define DAC2_REG_DEL_DAC2_REG_DEL_MIN 0x0
/** maximum delay */
#define DAC2_REG_DEL_DAC2_REG_DEL_MAX 0x3

/** DAC2 Gain Setting - Sets the gain in DAC2. The programming is binary coded. */
#define DAC2_MISC_DAC2_BIASCURRENT_CTRL_MASK 0x1f
#define DAC2_MISC_DAC2_BIASCURRENT_CTRL_AFE_GET ((VR9_AfeRead(DAC2_MISC) & DAC2_MISC_DAC2_BIASCURRENT_CTRL_MASK) >> 0)
#define DAC2_MISC_DAC2_BIASCURRENT_CTRL_AFE_SET(val) VR9_AfeWrite(DAC2_MISC, (val) << 0, DAC2_MISC_DAC2_BIASCURRENT_CTRL_MASK)
/** 0dB (default) */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_0DB 0x0
/** -0.26dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M0DB26 0x1
/** -0.52dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M0DB52 0x2
/** -0.79dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M0DB79 0x3
/** -1.07dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M1DB07 0x4
/** -1.36dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M1DB36 0x5
/** -1.66dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M1DB66 0x6
/** -1.97dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M1DB97 0x7
/** -2.30dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M2DB30 0x8
/** -2.63dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M2DB63 0x9
/** -2.98dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M2DB98 0xa
/** -3.34dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M3DB34 0xb
/** -3.72dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M3DB72 0xc
/** -4.12dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M4DB12 0xd
/** -4.53dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M4DB53 0xe
/** -4.97dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M4DB97 0xf
/** -5.43dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M5DB43 0x10
/** -5.91dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M5DB91 0x11
/** -6.42dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M6DB42 0x12
/** -6.97dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M6DB97 0x13
/** -7.55dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M7DB55 0x14
/** -8.17dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M8DB17 0x15
/** -8.84dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M8DB84 0x16
/** -9.57dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M9DB57 0x17
/** -10.36dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M10DB36 0x18
/** -11.24dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M11DB24 0x19
/** -12.21dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M12DB21 0x1a
/** -13.31dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M13DB31 0x1b
/** -14.56dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M14DB56 0x1c
/** -16.02dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M16DB02 0x1d
/** -17.79dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M17DB79 0x1e
/** -20dB */
#define DAC2_BIASCURRENT_CTRL_DAC2_GAIN_M20DB 0x1f


/** Control Register */
#define LDO (AFE_BASE + 0x24)
#define LDO_AFE_GET VR9_AfeRead(LDO)
#define LDO_AFE_SET(val) VR9_AfeWrite(LDO, (val), 0xFFFF)

/** NIX - NIX */
#define LDO_NIX_MASK 0x8000
#define LDO_NIX_AFE_GET ((VR9_AfeRead(LDO) & LDO_NIX_MASK) >> 15)
#define LDO_NIX_AFE_SET(val) VR9_AfeWrite(LDO, (val) << 15, LDO_NIX_MASK)

/** LDO for Analog Front End Supply Output Voltage Setting - Sets the output voltage level for the Linear Voltage Regulator, generating the Supply Voltage for the Analog Front End (1.5V). The programming is binary coded. The stepsize is 0.05V. */
#define LDO_LDO_PRG_HREG1_MASK 0xf00
#define LDO_LDO_PRG_HREG1_AFE_GET ((VR9_AfeRead(LDO) & LDO_LDO_PRG_HREG1_MASK) >> 8)
#define LDO_LDO_PRG_HREG1_AFE_SET(val) VR9_AfeWrite(LDO, (val) << 8, LDO_LDO_PRG_HREG1_MASK)
/** 0.95V output voltage */
#define LDO_PRG_HREG1_LDO_HREG1_OUTPUT_MIN 0x0
/** 1.5V output voltage (default) */
#define LDO_PRG_HREG1_LDO_HREG1_OUTPUT_DEFAULT 0xb
/** 1.7V output voltage */
#define LDO_PRG_HREG1_LDO_HREG1_OUTPUT_MAX 0xf

/** LDO for Line Driver Supply Power Down - Sets the Power Down Mode for the Linear Voltage Regulator, generating the Line Driver Supply Voltage. */
#define LDO_LDO_PD_HREG16_MASK 0x80
#define LDO_LDO_PD_HREG16_AFE_GET ((VR9_AfeRead(LDO) & LDO_LDO_PD_HREG16_MASK) >> 7)
#define LDO_LDO_PD_HREG16_AFE_SET(val) VR9_AfeWrite(LDO, (val) << 7, LDO_LDO_PD_HREG16_MASK)
/** Power Up */
#define LDO_PD_HREG16_LDO_HREG16_PU 0x0
/** Power Down (default) */
#define LDO_PD_HREG16_LDO_HREG16_PD 0x1

/** LDO for Line Driver Supply Current Limitation Setting - Sets the Current Limitation for the Linear Voltage Regulator, generating the Line Driver Supply Voltage. */
#define LDO_LDO_PRG_HREG16_CURR_MASK 0x30
#define LDO_LDO_PRG_HREG16_CURR_AFE_GET ((VR9_AfeRead(LDO) & LDO_LDO_PRG_HREG16_CURR_MASK) >> 4)
#define LDO_LDO_PRG_HREG16_CURR_AFE_SET(val) VR9_AfeWrite(LDO, (val) << 4, LDO_LDO_PRG_HREG16_CURR_MASK)
/** Minimum */
#define LDO_PRG_HREG16_CURR_LDO_HREG16_CURRLIM_MIN 0x0
/** Maximum (default) */
#define LDO_PRG_HREG16_CURR_LDO_HREG16_CURRLIM_MAX 0x3

/** LDO for Line Driver Supply Output Voltage Setting - Sets the output voltage level for the Linear Voltage Regulator, generating the Line Driver Supply Voltage. The programming is binary coded. The stepsize is 0.5V. */
#define LDO_LDO_PRG_HREG16_MASK 0xf
#define LDO_LDO_PRG_HREG16_AFE_GET ((VR9_AfeRead(LDO) & LDO_LDO_PRG_HREG16_MASK) >> 0)
#define LDO_LDO_PRG_HREG16_AFE_SET(val) VR9_AfeWrite(LDO, (val) << 0, LDO_LDO_PRG_HREG16_MASK)
/** 9.5V output voltage */
#define LDO_PRG_HREG16_LDO_HREG16_OUTPUT_MIN 0x0
/** 17V output voltage */
#define LDO_PRG_HREG16_LDO_HREG16_OUTPUT_MAX 0xf
/** 16V output voltage (default) */
#define LDO_PRG_HREG16_LDO_HREG16_OUTPUT_DEFAULT 0xd


/** Control Register */
#define ADC_BIAS (AFE_BASE + 0x28)
#define ADC_BIAS_AFE_GET VR9_AfeRead(ADC_BIAS)
#define ADC_BIAS_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val), 0xFFFF)

/** ADC INTE22 Bias Settings Opamp - Programs the internal Biasing Settings for the 2nd operational amplifier in stage 2 of the ADC. */
#define ADC_BIAS_ADC_BIAS_SET_OA22_MASK 0xc000
#define ADC_BIAS_ADC_BIAS_SET_OA22_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_SET_OA22_MASK) >> 14)
#define ADC_BIAS_ADC_BIAS_SET_OA22_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 14, ADC_BIAS_ADC_BIAS_SET_OA22_MASK)
/** default */
#define ADC_BIAS_SET_OA22_ADC_BIAS_SET_OP22_DEFAULT 0x0
/** 75% of power */
#define ADC_BIAS_SET_OA22_ADC_BIAS_SET_OP22_75 0x1
/** safe (more power) */
#define ADC_BIAS_SET_OA22_ADC_BIAS_SET_OP22_SAFE 0x2
/** not used */
#define ADC_BIAS_SET_OA22_ADC_BIAS_SET_OP22_NU 0x3

/** ADC INTE12 Bias Settings Opamp - Programs the internal Biasing Settings for the 1st operational amplifier in stage 2 of the ADC. */
#define ADC_BIAS_ADC_BIAS_SET_OA12_MASK 0x3000
#define ADC_BIAS_ADC_BIAS_SET_OA12_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_SET_OA12_MASK) >> 12)
#define ADC_BIAS_ADC_BIAS_SET_OA12_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 12, ADC_BIAS_ADC_BIAS_SET_OA12_MASK)
/** default */
#define ADC_BIAS_SET_OA12_ADC_BIAS_SET_OP12_DEFAULT 0x0
/** 75% of power */
#define ADC_BIAS_SET_OA12_ADC_BIAS_SET_OP12_75 0x1
/** safe (more power) */
#define ADC_BIAS_SET_OA12_ADC_BIAS_SET_OP12_SAFE 0x2
/** not used */
#define ADC_BIAS_SET_OA12_ADC_BIAS_SET_OP12_NU 0x3

/** ADC INTE21 Bias Settings Opamp - Programs the internal Biasing Settings for the 2nd operational amplifier in stage 1 of the ADC. */
#define ADC_BIAS_ADC_BIAS_SET_OA21_MASK 0xc00
#define ADC_BIAS_ADC_BIAS_SET_OA21_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_SET_OA21_MASK) >> 10)
#define ADC_BIAS_ADC_BIAS_SET_OA21_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 10, ADC_BIAS_ADC_BIAS_SET_OA21_MASK)
/** default */
#define ADC_BIAS_SET_OA21_ADC_BIAS_SET_OP21_DEFAULT 0x0
/** 75% of power */
#define ADC_BIAS_SET_OA21_ADC_BIAS_SET_OP21_75 0x1
/** safe (more power) */
#define ADC_BIAS_SET_OA21_ADC_BIAS_SET_OP21_SAFE 0x2
/** not used */
#define ADC_BIAS_SET_OA21_ADC_BIAS_SET_OP21_NU 0x3

/** ADC INTE11 Bias Settings Opamp - Programs the internal Biasing Settings for the 1st operational amplifier in stage 1 of the ADC. */
#define ADC_BIAS_ADC_BIAS_SET_OA11_MASK 0x300
#define ADC_BIAS_ADC_BIAS_SET_OA11_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_SET_OA11_MASK) >> 8)
#define ADC_BIAS_ADC_BIAS_SET_OA11_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 8, ADC_BIAS_ADC_BIAS_SET_OA11_MASK)
/** default */
#define ADC_BIAS_SET_OA11_ADC_BIAS_SET_OP11_DEFAULT 0x0
/** 75% of power */
#define ADC_BIAS_SET_OA11_ADC_BIAS_SET_OP11_75 0x1
/** safe (more power) */
#define ADC_BIAS_SET_OA11_ADC_BIAS_SET_OP11_SAFE 0x2
/** not used */
#define ADC_BIAS_SET_OA11_ADC_BIAS_SET_OP11_NU 0x3

/** ADC INTE22 Bias Current - Sets the Biasing Current for the 2nd operational amplifier in stage 2 of the ADC. */
#define ADC_BIAS_ADC_BIAS_PRG_OP22_MASK 0xc0
#define ADC_BIAS_ADC_BIAS_PRG_OP22_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_PRG_OP22_MASK) >> 6)
#define ADC_BIAS_ADC_BIAS_PRG_OP22_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 6, ADC_BIAS_ADC_BIAS_PRG_OP22_MASK)
/** 50% */
#define ADC_BIAS_PRG_OP22_ADC_IB_OP22_50 0x0
/** 75% */
#define ADC_BIAS_PRG_OP22_ADC_IB_OP22_75 0x1
/** 100% (default) */
#define ADC_BIAS_PRG_OP22_ADC_IB_OP22_100 0x2
/** 125% */
#define ADC_BIAS_PRG_OP22_ADC_IB_OP22_125 0x2

/** ADC INTE12 Bias Current - Sets the Biasing Current for the 1st operational amplifier in stage 2 of the ADC. */
#define ADC_BIAS_ADC_BIAS_PRG_OP12_MASK 0x30
#define ADC_BIAS_ADC_BIAS_PRG_OP12_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_PRG_OP12_MASK) >> 4)
#define ADC_BIAS_ADC_BIAS_PRG_OP12_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 4, ADC_BIAS_ADC_BIAS_PRG_OP12_MASK)
/** 50% */
#define ADC_BIAS_PRG_OP12_ADC_IB_OP12_50 0x0
/** 75% */
#define ADC_BIAS_PRG_OP12_ADC_IB_OP12_75 0x1
/** 100% (default) */
#define ADC_BIAS_PRG_OP12_ADC_IB_OP12_100 0x2
/** 125% */
#define ADC_BIAS_PRG_OP12_ADC_IB_OP12_125 0x2

/** ADC INTE21 Bias Current - Sets the Biasing Current for the 2nd operational amplifier in stage 1 of the ADC. */
#define ADC_BIAS_ADC_BIAS_PRG_OP21_MASK 0xc
#define ADC_BIAS_ADC_BIAS_PRG_OP21_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_PRG_OP21_MASK) >> 2)
#define ADC_BIAS_ADC_BIAS_PRG_OP21_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 2, ADC_BIAS_ADC_BIAS_PRG_OP21_MASK)
/** 50% */
#define ADC_BIAS_PRG_OP21_ADC_IB_OP21_50 0x0
/** 75% */
#define ADC_BIAS_PRG_OP21_ADC_IB_OP21_75 0x1
/** 100% (default) */
#define ADC_BIAS_PRG_OP21_ADC_IB_OP21_100 0x2
/** 125% */
#define ADC_BIAS_PRG_OP21_ADC_IB_OP21_125 0x2

/** ADC INTE11 Bias Current - Sets the Biasing Current for the 1st operational amplifier in stage 1 of the ADC. */
#define ADC_BIAS_ADC_BIAS_PRG_OP11_MASK 0x3
#define ADC_BIAS_ADC_BIAS_PRG_OP11_AFE_GET ((VR9_AfeRead(ADC_BIAS) & ADC_BIAS_ADC_BIAS_PRG_OP11_MASK) >> 0)
#define ADC_BIAS_ADC_BIAS_PRG_OP11_AFE_SET(val) VR9_AfeWrite(ADC_BIAS, (val) << 0, ADC_BIAS_ADC_BIAS_PRG_OP11_MASK)
/** 50% */
#define ADC_BIAS_PRG_OP11_ADC_IB_OP11_50 0x0
/** 75% */
#define ADC_BIAS_PRG_OP11_ADC_IB_OP11_75 0x1
/** 100% (default) */
#define ADC_BIAS_PRG_OP11_ADC_IB_OP11_100 0x2
/** 125% */
#define ADC_BIAS_PRG_OP11_ADC_IB_OP11_125 0x2


/** Control Register */
#define ADC_CLK_STG2 (AFE_BASE + 0x29)
#define ADC_CLK_STG2_AFE_GET VR9_AfeRead(ADC_CLK_STG2)
#define ADC_CLK_STG2_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG2, (val), 0xFFFF)

/** ADC Clocking Stage2 Power Down - Sets the Power Down Mode for the ADC clocking in the stage 2. */
#define ADC_CLK_STG2_ADC_PD_CLK_STG2_MASK 0x8000
#define ADC_CLK_STG2_ADC_PD_CLK_STG2_AFE_GET ((VR9_AfeRead(ADC_CLK_STG2) & ADC_CLK_STG2_ADC_PD_CLK_STG2_MASK) >> 15)
#define ADC_CLK_STG2_ADC_PD_CLK_STG2_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG2, (val) << 15, ADC_CLK_STG2_ADC_PD_CLK_STG2_MASK)
/** Power Up */
#define ADC_PD_CLK_STG2_ADC_CLK_STG2_PU 0x0
/** Power Down (default) */
#define ADC_PD_CLK_STG2_ADC_CLK_STG2_PD 0x1

/** ADC Clock Pulse Width Programming Stage 2 - Programs the width of the comparators clock high pulse in the stage 2 of the ADC.During this period the comparator is able to process data. The programming is binary coded. */
#define ADC_CLK_STG2_ADC_PRG_MCLKWIDTH_STG2_MASK 0x70
#define ADC_CLK_STG2_ADC_PRG_MCLKWIDTH_STG2_AFE_GET ((VR9_AfeRead(ADC_CLK_STG2) & ADC_CLK_STG2_ADC_PRG_MCLKWIDTH_STG2_MASK) >> 4)
#define ADC_CLK_STG2_ADC_PRG_MCLKWIDTH_STG2_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG2, (val) << 4, ADC_CLK_STG2_ADC_PRG_MCLKWIDTH_STG2_MASK)
/** minimum ELD (default) */
#define ADC_PRG_MCLKWIDTH_STG2_ADC_COMPCLKWIDTH_STG1_MIN 0x0
/** maximum ELD */
#define ADC_PRG_MCLKWIDTH_STG2_ADC_COMPCLKWIDTH_STG1_MAX 0x7

/** ADC Enable Excess Loop Delay Programming Stage 2 - Enables/Disables Excess Loop Delay programming in the stage 2 of the ADC. If this bit is not set, the programming of the Excess Loop Delay has no effect. */
#define ADC_CLK_STG2_ADC_DELAY_ENABLE_STG2_MASK 0x8
#define ADC_CLK_STG2_ADC_DELAY_ENABLE_STG2_AFE_GET ((VR9_AfeRead(ADC_CLK_STG2) & ADC_CLK_STG2_ADC_DELAY_ENABLE_STG2_MASK) >> 3)
#define ADC_CLK_STG2_ADC_DELAY_ENABLE_STG2_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG2, (val) << 3, ADC_CLK_STG2_ADC_DELAY_ENABLE_STG2_MASK)
/** Disabled (default) */
#define ADC_DELAY_ENABLE_STG2_ADC_ELDPROG_STG2_DISABLED 0x0
/** Enabled */
#define ADC_DELAY_ENABLE_STG2_ADC_ELDPROG_STG2_ENABLED 0x1

/** ADC Excess Loop Delay Stage 2 - Programs the Excess Loop Delay (ELD) in the stage 2 of the ADC, which has influence on the stability of the feedback loop.The programming is binary coded. */
#define ADC_CLK_STG2_ADC_PRG_ELD_STG2_MASK 0x7
#define ADC_CLK_STG2_ADC_PRG_ELD_STG2_AFE_GET ((VR9_AfeRead(ADC_CLK_STG2) & ADC_CLK_STG2_ADC_PRG_ELD_STG2_MASK) >> 0)
#define ADC_CLK_STG2_ADC_PRG_ELD_STG2_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG2, (val) << 0, ADC_CLK_STG2_ADC_PRG_ELD_STG2_MASK)
/** maximum ELD (default) */
#define ADC_PRG_ELD_STG2_ADC_ELD_STG2_MAX 0x0
/** minimum ELD */
#define ADC_PRG_ELD_STG2_ADC_ELD_STG2_MIN 0x7


/** Control Register */
#define ADC_LNDEC_STG2 (AFE_BASE + 0x2a)
#define ADC_LNDEC_STG2_AFE_GET VR9_AfeRead(ADC_LNDEC_STG2)
#define ADC_LNDEC_STG2_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG2, (val), 0xFFFF)

/** ADC Enable Data Output Stage 2 - Enables/Disables the data output in stage 2 of the ADC. */
#define ADC_LNDEC_STG2_ADC_EN_OUT_STG2_MASK 0x80
#define ADC_LNDEC_STG2_ADC_EN_OUT_STG2_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG2) & ADC_LNDEC_STG2_ADC_EN_OUT_STG2_MASK) >> 7)
#define ADC_LNDEC_STG2_ADC_EN_OUT_STG2_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG2, (val) << 7, ADC_LNDEC_STG2_ADC_EN_OUT_STG2_MASK)
/** Disabled (default) */
#define ADC_EN_OUT_STG2_ADC_DATAOUT_STG2_DISABLED 0x0
/** Enabled */
#define ADC_EN_OUT_STG2_ADC_DATAOUT_STG2_ENABLED 0x1

/** ADC Downrater Stage 2 Clock Inversion - Inverts the input clock of the Downrater in stage 2 of the ADC. */
#define ADC_LNDEC_STG2_ADC_INVCLK_OUT_STG2_MASK 0x40
#define ADC_LNDEC_STG2_ADC_INVCLK_OUT_STG2_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG2) & ADC_LNDEC_STG2_ADC_INVCLK_OUT_STG2_MASK) >> 6)
#define ADC_LNDEC_STG2_ADC_INVCLK_OUT_STG2_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG2, (val) << 6, ADC_LNDEC_STG2_ADC_INVCLK_OUT_STG2_MASK)
/** clock is not inverted (default) */
#define ADC_INVCLK_OUT_STG2_ADC_DOWNRATER_STG2_CLK_NO_INV 0x0
/** clock is inverted */
#define ADC_INVCLK_OUT_STG2_ADC_DOWNRATER_STG2_CLK_INV 0x1

/** ADC Line Decoder Stage 2 Clock Inversion - Inverts the input clock of the Line Decoder in stage 2 of the ADC. */
#define ADC_LNDEC_STG2_ADC_INVCLK_LNDEC_STG2_MASK 0x20
#define ADC_LNDEC_STG2_ADC_INVCLK_LNDEC_STG2_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG2) & ADC_LNDEC_STG2_ADC_INVCLK_LNDEC_STG2_MASK) >> 5)
#define ADC_LNDEC_STG2_ADC_INVCLK_LNDEC_STG2_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG2, (val) << 5, ADC_LNDEC_STG2_ADC_INVCLK_LNDEC_STG2_MASK)
/** clock is not inverted (default) */
#define ADC_INVCLK_LNDEC_STG2_ADC_LNDEC_STG2_CLK_NO_INV 0x0
/** clock is inverted */
#define ADC_INVCLK_LNDEC_STG2_ADC_LNDEC_STG2_CLK_INV 0x1

/** ADC Enable Line Decoder Clock Delay Programming Stage 2 - Enables/Disables clock delay programming in the stage 2 of the ADC. If this bit is not set, the programming of the delay for the Line Decoder has no effect. */
#define ADC_LNDEC_STG2_ADC_DLYEN_CLK_LNDEC_STG2_MASK 0x8
#define ADC_LNDEC_STG2_ADC_DLYEN_CLK_LNDEC_STG2_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG2) & ADC_LNDEC_STG2_ADC_DLYEN_CLK_LNDEC_STG2_MASK) >> 3)
#define ADC_LNDEC_STG2_ADC_DLYEN_CLK_LNDEC_STG2_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG2, (val) << 3, ADC_LNDEC_STG2_ADC_DLYEN_CLK_LNDEC_STG2_MASK)
/** Disabled (default) */
#define ADC_DLYEN_CLK_LNDEC_STG2_ADC_LNDEC_CLKDELAY_PRG_STG2_DISABLED 0x0
/** Enabled */
#define ADC_DLYEN_CLK_LNDEC_STG2_ADC_LNDEC_CLKDELAY_PRG_STG2_ENABLED 0x1

/** ADC Line Decoder Clock Delay Programming Stage 2 - Programs the delay of the clock for the Line Decoder in stage 2 of the ADC. The programming is binary coded. */
#define ADC_LNDEC_STG2_ADC_PRG_CLK_LNDEC_DELAY_STG2_MASK 0x7
#define ADC_LNDEC_STG2_ADC_PRG_CLK_LNDEC_DELAY_STG2_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG2) & ADC_LNDEC_STG2_ADC_PRG_CLK_LNDEC_DELAY_STG2_MASK) >> 0)
#define ADC_LNDEC_STG2_ADC_PRG_CLK_LNDEC_DELAY_STG2_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG2, (val) << 0, ADC_LNDEC_STG2_ADC_PRG_CLK_LNDEC_DELAY_STG2_MASK)
/** minimum (default) */
#define ADC_PRG_CLK_LNDEC_DELAY_STG2_ADC_LNDEC_CLKDELAY_STG2_MIN 0x0
/** maximum */
#define ADC_PRG_CLK_LNDEC_DELAY_STG2_ADC_LNDEC_CLKDELAY_STG2_MAX 0x7


/** Control Register */
#define ADC_DACS_STG2 (AFE_BASE + 0x2b)
#define ADC_DACS_STG2_AFE_GET VR9_AfeRead(ADC_DACS_STG2)
#define ADC_DACS_STG2_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG2, (val), 0xFFFF)

/** ADC DAC12 Power Down - Sets the Power Down Mode for the 1st DAC in stage 2 of the ADC. */
#define ADC_DACS_STG2_ADC_PD_DAC12_MASK 0x8000
#define ADC_DACS_STG2_ADC_PD_DAC12_AFE_GET ((VR9_AfeRead(ADC_DACS_STG2) & ADC_DACS_STG2_ADC_PD_DAC12_MASK) >> 15)
#define ADC_DACS_STG2_ADC_PD_DAC12_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG2, (val) << 15, ADC_DACS_STG2_ADC_PD_DAC12_MASK)
/** Power Up */
#define ADC_PD_DAC12_ADC_DAC12_PU 0x0
/** Power Down (default) */
#define ADC_PD_DAC12_ADC_DAC12_PD 0x1

/** ADC Reference Trimming DAC12 - Programs the biasing current for the 1st DAC in stage 2 of the ADC. The programming is binary coded.The stepsize is 0.625%. */
#define ADC_DACS_STG2_ADC_DACREFTRIM12_MASK 0x3f00
#define ADC_DACS_STG2_ADC_DACREFTRIM12_AFE_GET ((VR9_AfeRead(ADC_DACS_STG2) & ADC_DACS_STG2_ADC_DACREFTRIM12_MASK) >> 8)
#define ADC_DACS_STG2_ADC_DACREFTRIM12_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG2, (val) << 8, ADC_DACS_STG2_ADC_DACREFTRIM12_MASK)
/** 80% */
#define ADC_DACREFTRIM12_ADC_DAC12_REFTRIM_MIN 0x0
/** 100% (default) */
#define ADC_DACREFTRIM12_ADC_DAC12_REFTRIM_DEFAULT 0x20
/** 119.375% */
#define ADC_DACREFTRIM12_ADC_DAC12_REFTRIM_MAX 0x3f

/** ADC DAC22 Power Down - Sets the Power Down mode for the 2nd DAC in stage 2 of the ADC. */
#define ADC_DACS_STG2_ADC_PD_DAC22_MASK 0x80
#define ADC_DACS_STG2_ADC_PD_DAC22_AFE_GET ((VR9_AfeRead(ADC_DACS_STG2) & ADC_DACS_STG2_ADC_PD_DAC22_MASK) >> 7)
#define ADC_DACS_STG2_ADC_PD_DAC22_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG2, (val) << 7, ADC_DACS_STG2_ADC_PD_DAC22_MASK)
/** Power Up */
#define ADC_PD_DAC22_ADC_DAC22_PU 0x0
/** Power Down (default) */
#define ADC_PD_DAC22_ADC_DAC22_PD 0x1

/** ADC Reference Trimming DAC22 - Programs the biasing current for the 2nd DAC in stage 2 of the ADC. The programming is binary coded.The stepsize is 0.625%. */
#define ADC_DACS_STG2_ADC_DACREFTRIM22_MASK 0x3f
#define ADC_DACS_STG2_ADC_DACREFTRIM22_AFE_GET ((VR9_AfeRead(ADC_DACS_STG2) & ADC_DACS_STG2_ADC_DACREFTRIM22_MASK) >> 0)
#define ADC_DACS_STG2_ADC_DACREFTRIM22_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG2, (val) << 0, ADC_DACS_STG2_ADC_DACREFTRIM22_MASK)
/** 80% */
#define ADC_DACREFTRIM22_ADC_DAC22_REFTRIM_MIN 0x0
/** 100% (default) */
#define ADC_DACREFTRIM22_ADC_DAC22_REFTRIM_DEFAULT 0x20
/** 119.375% */
#define ADC_DACREFTRIM22_ADC_DAC22_REFTRIM_MAX 0x3f


/** Control Register */
#define ADC_LOOPF2_1 (AFE_BASE + 0x2c)
#define ADC_LOOPF2_1_AFE_GET VR9_AfeRead(ADC_LOOPF2_1)
#define ADC_LOOPF2_1_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_1, (val), 0xFFFF)

/** ADC INTE12 Half Unity Capacitor - Halfes the stepsize in the capacitor array of the 1st Integrator in stage 2 of the ADC, by adding 1/2 of the Unity capacitor in the array.This means in other words, a finer programming of Integrator Time Constant is enabled. */
#define ADC_LOOPF2_1_ADC_C12HALFLSB_MASK 0x8000
#define ADC_LOOPF2_1_ADC_C12HALFLSB_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_1) & ADC_LOOPF2_1_ADC_C12HALFLSB_MASK) >> 15)
#define ADC_LOOPF2_1_ADC_C12HALFLSB_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_1, (val) << 15, ADC_LOOPF2_1_ADC_C12HALFLSB_MASK)
/** Normal (default) */
#define ADC_C12HALFLSB_ADC_C12HALFLSB_OFF 0x0
/** Half LSB Capacitor is ON */
#define ADC_C12HALFLSB_ADC_C12HALFLSB_ON 0x1

/** ADC INTE12 Fixed Capacitor - Sets the Fixed Capacitor in the capacitor array of the 1st integrator in stage 2 of the ADC. */
#define ADC_LOOPF2_1_ADC_C12FIX_MASK 0x4000
#define ADC_LOOPF2_1_ADC_C12FIX_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_1) & ADC_LOOPF2_1_ADC_C12FIX_MASK) >> 14)
#define ADC_LOOPF2_1_ADC_C12FIX_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_1, (val) << 14, ADC_LOOPF2_1_ADC_C12FIX_MASK)
/** Fixed Capacitor switched OFF = only for testing */
#define ADC_C12FIX_ADC_C12FIX_OFF 0x0
/** Normal (default) */
#define ADC_C12FIX_ADC_C12FIX_ON 0x1

/** ADC INTE12 Tuning - Tuning of the 1st Integrator's Time Constant in stage 2 of the ADC. The tuning word is calculated by the VR9-D. The programming is binary coded. */
#define ADC_LOOPF2_1_ADC_BITC12_MASK 0x3f00
#define ADC_LOOPF2_1_ADC_BITC12_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_1) & ADC_LOOPF2_1_ADC_BITC12_MASK) >> 8)
#define ADC_LOOPF2_1_ADC_BITC12_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_1, (val) << 8, ADC_LOOPF2_1_ADC_BITC12_MASK)
/** minimum time constant */
#define ADC_BITC12_ADC_C12_MIN 0x0
/** maximum time constant */
#define ADC_BITC12_ADC_C12_MAX 0x3f

/** ADC INTE12 Input Resistor Path 1 - Configures the input path 1 of the 1st integrator in stage 2 of the ADC. */
#define ADC_LOOPF2_1_ADC_BITR121_MASK 0xf0
#define ADC_LOOPF2_1_ADC_BITR121_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_1) & ADC_LOOPF2_1_ADC_BITR121_MASK) >> 4)
#define ADC_LOOPF2_1_ADC_BITR121_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_1, (val) << 4, ADC_LOOPF2_1_ADC_BITR121_MASK)
/** OPEN (default) */
#define ADC_BITR121_ADC_BITR12_1_OPEN 0x0
/** 2kOhm */
#define ADC_BITR121_ADC_BITR12_1_2KOHM 0x1
/** 1kOhm */
#define ADC_BITR121_ADC_BITR12_1_1KOHM 0x3
/** 0.5kOhm */
#define ADC_BITR121_ADC_BITR12_1_0K5OHM 0x7
/** differential input shortcut to common mode of 0.7V (default) */
#define ADC_BITR121_ADC_BITR12_1_TO_VCM 0x8

/** ADC INTE12 Input Resistor Path 2 - Configures the input path 2 of the 1st integrator in stage 2 of the ADC. */
#define ADC_LOOPF2_1_ADC_BITR122_MASK 0xf
#define ADC_LOOPF2_1_ADC_BITR122_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_1) & ADC_LOOPF2_1_ADC_BITR122_MASK) >> 0)
#define ADC_LOOPF2_1_ADC_BITR122_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_1, (val) << 0, ADC_LOOPF2_1_ADC_BITR122_MASK)
/** OPEN (default) */
#define ADC_BITR122_ADC_BITR12_2_OPEN 0x0
/** 2kOhm */
#define ADC_BITR122_ADC_BITR12_2_2KOHM 0x1
/** 1kOhm */
#define ADC_BITR122_ADC_BITR12_2_1KOHM 0x3
/** 0.5kOhm */
#define ADC_BITR122_ADC_BITR12_2_0K5OHM 0x7
/** differential input shortcut to common mode of 0.7V (default) */
#define ADC_BITR122_ADC_BITR12_2_TO_VCM 0x8


/** Control Register */
#define ADC_LOOPF2_2 (AFE_BASE + 0x2d)
#define ADC_LOOPF2_2_AFE_GET VR9_AfeRead(ADC_LOOPF2_2)
#define ADC_LOOPF2_2_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val), 0xFFFF)

/** ADC INTE22 Half Unity Capacitor - Halfes the stepsize in the capacitor array of the 2nd Integrator in stage 2 of the ADC, by adding 1/2 of the Unity capacitor in the array.This means in other words, a finer programming of Integrator Time Constant is enabled. */
#define ADC_LOOPF2_2_ADC_C22HALFLSB_MASK 0x8000
#define ADC_LOOPF2_2_ADC_C22HALFLSB_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_2) & ADC_LOOPF2_2_ADC_C22HALFLSB_MASK) >> 15)
#define ADC_LOOPF2_2_ADC_C22HALFLSB_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val) << 15, ADC_LOOPF2_2_ADC_C22HALFLSB_MASK)
/** Normal (default) */
#define ADC_C22HALFLSB_ADC_C22HALFLSB_OFF 0x0
/** Half LSB Capacitor is ON */
#define ADC_C22HALFLSB_ADC_C22HALFLSB_ON 0x1

/** ADC INTE22 Fixed Capacitor - Sets the Fixed Capacitor in the capacitor array of the 2nd integrator in stage 2 of the ADC. */
#define ADC_LOOPF2_2_ADC_C22FIX_MASK 0x4000
#define ADC_LOOPF2_2_ADC_C22FIX_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_2) & ADC_LOOPF2_2_ADC_C22FIX_MASK) >> 14)
#define ADC_LOOPF2_2_ADC_C22FIX_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val) << 14, ADC_LOOPF2_2_ADC_C22FIX_MASK)
/** Fixed Capacitor switched OFF = only for testing */
#define ADC_C22FIX_ADC_C22FIX_OFF 0x0
/** Normal (default) */
#define ADC_C22FIX_ADC_C22FIX_ON 0x1

/** ADC INTE22 Tuning - Tuning of the 2nd Integrator's Time Constant in stage 2 of the ADC. The tuning word is calculated by the VR9-D. The programming is binary coded. */
#define ADC_LOOPF2_2_ADC_BITC22_MASK 0x3f00
#define ADC_LOOPF2_2_ADC_BITC22_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_2) & ADC_LOOPF2_2_ADC_BITC22_MASK) >> 8)
#define ADC_LOOPF2_2_ADC_BITC22_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val) << 8, ADC_LOOPF2_2_ADC_BITC22_MASK)
/** minimum time constant */
#define ADC_BITC22_ADC_C22_MIN 0x0
/** maximum time constant */
#define ADC_BITC22_ADC_C22_MAX 0x3f

/** ADC INTE22 Buffer Mode - Sets the Buffer Mode of the 2nd integrator in stage 2 of the ADC. */
#define ADC_LOOPF2_2_ADC_BUFF22_MASK 0x80
#define ADC_LOOPF2_2_ADC_BUFF22_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_2) & ADC_LOOPF2_2_ADC_BUFF22_MASK) >> 7)
#define ADC_LOOPF2_2_ADC_BUFF22_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val) << 7, ADC_LOOPF2_2_ADC_BUFF22_MASK)
/** Buffer Mode OFF = Feedbackresistor is switched OFF (default) */
#define ADC_BUFF22_ADC_BUFF22_OFF 0x0
/** Buffer Mode ON = Feedbackresistor is switched ON */
#define ADC_BUFF22_ADC_BUFF22_ON 0x1

/** ADC Loopfilter Stage 2 - Sets the feedback resistor of the loopfilter in stage 2 of the ADC. */
#define ADC_LOOPF2_2_ADC_LF2RES_MASK 0x30
#define ADC_LOOPF2_2_ADC_LF2RES_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_2) & ADC_LOOPF2_2_ADC_LF2RES_MASK) >> 4)
#define ADC_LOOPF2_2_ADC_LF2RES_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val) << 4, ADC_LOOPF2_2_ADC_LF2RES_MASK)
/** OPEN (default) */
#define ADC_LF2RES_ADC_LF2RES_OPEN 0x0
/** 18.75kOhm */
#define ADC_LF2RES_ADC_LF2RES_18K75OHM 0x1
/** 37.50kOhm */
#define ADC_LF2RES_ADC_LF2RES_37K50OHM 0x2

/** ADC INTE12 Buffer Mode - Sets the Buffer Mode of the 1st integrator in stage 2 of the ADC. */
#define ADC_LOOPF2_2_ADC_BUFF12_MASK 0xc
#define ADC_LOOPF2_2_ADC_BUFF12_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_2) & ADC_LOOPF2_2_ADC_BUFF12_MASK) >> 2)
#define ADC_LOOPF2_2_ADC_BUFF12_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val) << 2, ADC_LOOPF2_2_ADC_BUFF12_MASK)
/** Buffer Mode OFF (default) */
#define ADC_BUFF12_ADC_BUFF12_ON_OPEN 0x0
/** Buffer Mode ON (2kOhm feedback resistor) */
#define ADC_BUFF12_ADC_BUFF12_ON_2KOHM 0x1
/** Buffer Mode ON (4kOhm feedback resistor) */
#define ADC_BUFF12_ADC_BUFF12_ON_4KOHM 0x1

/** ADC INTE22 Input Resistor - Configures the input of the 2nd integrator in stage 2 of the ADC. */
#define ADC_LOOPF2_2_ADC_BITR22_MASK 0x3
#define ADC_LOOPF2_2_ADC_BITR22_AFE_GET ((VR9_AfeRead(ADC_LOOPF2_2) & ADC_LOOPF2_2_ADC_BITR22_MASK) >> 0)
#define ADC_LOOPF2_2_ADC_BITR22_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF2_2, (val) << 0, ADC_LOOPF2_2_ADC_BITR22_MASK)
/** Input OPEN */
#define ADC_BITR22_ADC_BITR22_OPEN 0x0
/** normal = differential input enabled */
#define ADC_BITR22_ADC_BITR22_NORMAL 0x1
/** differential input shortcut to common mode of 0.7V (default) */
#define ADC_BITR22_ADC_BITR22_TO_VCM 0x2


/** Control Register */
#define ADC_LOOPF_MISC (AFE_BASE + 0x2e)
#define ADC_LOOPF_MISC_AFE_GET VR9_AfeRead(ADC_LOOPF_MISC)
#define ADC_LOOPF_MISC_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val), 0xFFFF)

/** ADC Overload Power Down - Sets the Power Down Mode for the Overload Circuit in the ADC. */
#define ADC_LOOPF_MISC_ADC_PD_OVLD_MASK 0x8000
#define ADC_LOOPF_MISC_ADC_PD_OVLD_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_PD_OVLD_MASK) >> 15)
#define ADC_LOOPF_MISC_ADC_PD_OVLD_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 15, ADC_LOOPF_MISC_ADC_PD_OVLD_MASK)
/** Power Up */
#define ADC_PD_OVLD_ADC_OVLD_PU 0x0
/** Power Down (default) */
#define ADC_PD_OVLD_ADC_OVLD_PD 0x1

/** ADC Overload Clock Divider Setting - Sets the clock frequency of the Overload circuit in the ADC. */
#define ADC_LOOPF_MISC_ADC_CLKDIV_OVLD_MASK 0x4000
#define ADC_LOOPF_MISC_ADC_CLKDIV_OVLD_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_CLKDIV_OVLD_MASK) >> 14)
#define ADC_LOOPF_MISC_ADC_CLKDIV_OVLD_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 14, ADC_LOOPF_MISC_ADC_CLKDIV_OVLD_MASK)
/** normal (default) */
#define ADC_CLKDIV_OVLD_ADC_OVLD_CLK_NORMAL 0x0
/** division by 2 */
#define ADC_CLKDIV_OVLD_ADC_OVLD_CLK_DIV2 0x1

/** ADC Enable Overload Clock - Enables/Disables the clock of the Overload circuit in the ADC. */
#define ADC_LOOPF_MISC_ADC_CLKEN_OVLD_MASK 0x2000
#define ADC_LOOPF_MISC_ADC_CLKEN_OVLD_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_CLKEN_OVLD_MASK) >> 13)
#define ADC_LOOPF_MISC_ADC_CLKEN_OVLD_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 13, ADC_LOOPF_MISC_ADC_CLKEN_OVLD_MASK)
/** Disabled (default) */
#define ADC_CLKEN_OVLD_ADC_OVLD_CLK_DISABLED 0x0
/** Enabled */
#define ADC_CLKEN_OVLD_ADC_OVLD_CLK_ENABLED 0x1

/** ADC Enable Overload Digital - Enables/Disables the digital block of the overload circuit in the ADC. */
#define ADC_LOOPF_MISC_ADC_DIGEN_OVLD_MASK 0x1000
#define ADC_LOOPF_MISC_ADC_DIGEN_OVLD_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_DIGEN_OVLD_MASK) >> 12)
#define ADC_LOOPF_MISC_ADC_DIGEN_OVLD_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 12, ADC_LOOPF_MISC_ADC_DIGEN_OVLD_MASK)
/** Disabled (default) */
#define ADC_DIGEN_OVLD_ADC_OVLD_DIG_DISABLED 0x0
/** Enabled */
#define ADC_DIGEN_OVLD_ADC_OVLD_DIG_ENABLED 0x1

/** ADC Overload Signal Selection - Selets the Overload Signal used to control the loopfilters and DACs.It can be taken directly from the Overload Block itself or it can be generated by an Interrupt coming from the digital core. */
#define ADC_LOOPF_MISC_ADC_OVLD_INTERRUPT_CTL_MASK 0x100
#define ADC_LOOPF_MISC_ADC_OVLD_INTERRUPT_CTL_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_OVLD_INTERRUPT_CTL_MASK) >> 8)
#define ADC_LOOPF_MISC_ADC_OVLD_INTERRUPT_CTL_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 8, ADC_LOOPF_MISC_ADC_OVLD_INTERRUPT_CTL_MASK)
/** no Interrupt is used (default) */
#define ADC_OVLD_INTERRUPT_CTL_ADC_OVLD_INTERRUPT_NOTUSED 0x0
/** Interrupt is used */
#define ADC_OVLD_INTERRUPT_CTL_ADC_OVLD_INTERRUPT_USED 0x1

/** ADC Overload Signal Pulse Width - Selects if Overload Control Signal is directly the Overload Signal (short pulse) or an output pulse from a digital circuit (large pulse) */
#define ADC_LOOPF_MISC_ADC_OVLD_SELOUT_MASK 0x80
#define ADC_LOOPF_MISC_ADC_OVLD_SELOUT_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_OVLD_SELOUT_MASK) >> 7)
#define ADC_LOOPF_MISC_ADC_OVLD_SELOUT_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 7, ADC_LOOPF_MISC_ADC_OVLD_SELOUT_MASK)
/** short pulse (default) */
#define ADC_OVLD_SELOUT_ADC_OVLD_SIGNAL_SHORTPULSE 0x0
/** large pulse */
#define ADC_OVLD_SELOUT_ADC_OVLD_SIGNAL_LARGEPULSE 0x1

/** ADC INTE11 Power Down - Sets the Power Down Mode for the 1st Integrator in stage 1 of the ADC. */
#define ADC_LOOPF_MISC_ADC_PD_OA11_MASK 0x8
#define ADC_LOOPF_MISC_ADC_PD_OA11_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_PD_OA11_MASK) >> 3)
#define ADC_LOOPF_MISC_ADC_PD_OA11_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 3, ADC_LOOPF_MISC_ADC_PD_OA11_MASK)
/** Power Up */
#define ADC_PD_OA11_ADC_OA11_PU 0x0
/** Power Down (default) */
#define ADC_PD_OA11_ADC_OA11_PD 0x1

/** ADC INTE21 Power Down - Sets the Power Down Mode for the 2nd Integrator in stage 1 of the ADC. */
#define ADC_LOOPF_MISC_ADC_PD_OA21_MASK 0x4
#define ADC_LOOPF_MISC_ADC_PD_OA21_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_PD_OA21_MASK) >> 2)
#define ADC_LOOPF_MISC_ADC_PD_OA21_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 2, ADC_LOOPF_MISC_ADC_PD_OA21_MASK)
/** Power Up */
#define ADC_PD_OA21_ADC_OA21_PU 0x0
/** Power Down (default) */
#define ADC_PD_OA21_ADC_OA21_PD 0x1

/** ADC INTE12 Power Down - Sets the Power Down Mode for the 1st Integrator in stage 2 of the ADC. */
#define ADC_LOOPF_MISC_ADC_PD_OA12_MASK 0x2
#define ADC_LOOPF_MISC_ADC_PD_OA12_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_PD_OA12_MASK) >> 1)
#define ADC_LOOPF_MISC_ADC_PD_OA12_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 1, ADC_LOOPF_MISC_ADC_PD_OA12_MASK)
/** Power Up */
#define ADC_PD_OA12_ADC_OA12_PU 0x0
/** Power Down (default) */
#define ADC_PD_OA12_ADC_OA12_PD 0x1

/** ADC INTE22 Power Down - Sets the Power Down Mode for the 2nd Integrator in stage 2 of the ADC. */
#define ADC_LOOPF_MISC_ADC_PD_OA22_MASK 0x1
#define ADC_LOOPF_MISC_ADC_PD_OA22_AFE_GET ((VR9_AfeRead(ADC_LOOPF_MISC) & ADC_LOOPF_MISC_ADC_PD_OA22_MASK) >> 0)
#define ADC_LOOPF_MISC_ADC_PD_OA22_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF_MISC, (val) << 0, ADC_LOOPF_MISC_ADC_PD_OA22_MASK)
/** Power Up */
#define ADC_PD_OA22_ADC_OA22_PU 0x0
/** Power Down (default) */
#define ADC_PD_OA22_ADC_OA22_PD 0x1


/** Control Register */
#define ADC_OVLD (AFE_BASE + 0x2f)
#define ADC_OVLD_AFE_GET VR9_AfeRead(ADC_OVLD)
#define ADC_OVLD_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val), 0xFFFF)

/** ADC Overload Signal Pulse Width Length Setting - Programs the pulse width of the Overload control signal in the ADC, which is generated by the digital overload circuit. */
#define ADC_OVLD_ADC_OVLD_LEN_MASK 0x1000
#define ADC_OVLD_ADC_OVLD_LEN_AFE_GET ((VR9_AfeRead(ADC_OVLD) & ADC_OVLD_ADC_OVLD_LEN_MASK) >> 12)
#define ADC_OVLD_ADC_OVLD_LEN_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val) << 12, ADC_OVLD_ADC_OVLD_LEN_MASK)
/** minimum pulse width (default) */
#define ADC_OVLD_LEN_ADC_OVLD_SIGNAL_PULSEWIDTH_MIN 0x0
/** maximum pulse width */
#define ADC_OVLD_LEN_ADC_OVLD_SIGNAL_PULSEWIDTH_MAX 0xf

/** ADC Overload Selection DAC11 - Selects the action during overload for 1st DAC in stage 1 of the ADC. If this bit is set, the DAC gets only static data from the register ADC_DACEXT. */
#define ADC_OVLD_ADC_OVLD1_SELDAC_MASK 0x800
#define ADC_OVLD_ADC_OVLD1_SELDAC_AFE_GET ((VR9_AfeRead(ADC_OVLD) & ADC_OVLD_ADC_OVLD1_SELDAC_MASK) >> 11)
#define ADC_OVLD_ADC_OVLD1_SELDAC_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val) << 11, ADC_OVLD_ADC_OVLD1_SELDAC_MASK)
/** no action (default) */
#define ADC_OVLD1_SELDAC_ADC_OVLD_DAC11_NOACTION 0x0
/** static data for DAC11 */
#define ADC_OVLD1_SELDAC_ADC_OVLD_DAC11_STATIC_DATA 0x1

/** ADC Overload Reference Voltage - Sets the Overload Reference Voltage level in the ADC. When this level is reached at INTE11 output, an overload pulse is generated. */
#define ADC_OVLD_ADC_OVLD_REF_MASK 0x700
#define ADC_OVLD_ADC_OVLD_REF_AFE_GET ((VR9_AfeRead(ADC_OVLD) & ADC_OVLD_ADC_OVLD_REF_MASK) >> 8)
#define ADC_OVLD_ADC_OVLD_REF_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val) << 8, ADC_OVLD_ADC_OVLD_REF_MASK)
/** 0.2V */
#define ADC_OVLD_REF_ADC_OVLD_REF_0V2 0x0
/** 0.3V */
#define ADC_OVLD_REF_ADC_OVLD_REF_0V3 0x1
/** 0.4V */
#define ADC_OVLD_REF_ADC_OVLD_REF_0V4 0x2
/** 0.5V */
#define ADC_OVLD_REF_ADC_OVLD_REF_0V5 0x3
/** 0.9V */
#define ADC_OVLD_REF_ADC_OVLD_REF_0V9 0x4
/** 1.0V (default) */
#define ADC_OVLD_REF_ADC_OVLD_REF_1V0 0x5
/** 1.1V */
#define ADC_OVLD_REF_ADC_OVLD_REF_1V1 0x6
/** 1.2V */
#define ADC_OVLD_REF_ADC_OVLD_REF_1V2 0x7

/** ADC Enable Overload Switch Control Stage 2 - Enables/Disables the Overload Switch Control for the Loopfilters of stage 2 in the ADC. If this bit is not set, the overload control signal has no effect. */
#define ADC_OVLD_ADC_OVLD2_EN_SW_CTL_MASK 0x80
#define ADC_OVLD_ADC_OVLD2_EN_SW_CTL_AFE_GET ((VR9_AfeRead(ADC_OVLD) & ADC_OVLD_ADC_OVLD2_EN_SW_CTL_MASK) >> 7)
#define ADC_OVLD_ADC_OVLD2_EN_SW_CTL_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val) << 7, ADC_OVLD_ADC_OVLD2_EN_SW_CTL_MASK)
/** Disabled (default) */
#define ADC_OVLD2_EN_SW_CTL_ADC_OVLD_SW_CTL_STG2_DISABLED 0x0
/** Enabled */
#define ADC_OVLD2_EN_SW_CTL_ADC_OVLD_SW_CTL_STG2_ENABLED 0x1

/** ADC Overload Selection Stage 2 - Selects the action during overload for the loopfilters of stage 2 in the ADC. */
#define ADC_OVLD_ADC_OVLD2_SEL_MASK 0x70
#define ADC_OVLD_ADC_OVLD2_SEL_AFE_GET ((VR9_AfeRead(ADC_OVLD) & ADC_OVLD_ADC_OVLD2_SEL_MASK) >> 4)
#define ADC_OVLD_ADC_OVLD2_SEL_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val) << 4, ADC_OVLD_ADC_OVLD2_SEL_MASK)
/** no action (default) */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_NOACTION 0x0
/** control of R12 switches */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_R12 0x1
/** control of BUFF12 switches */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_BUFF12 0x2
/** control of R12 + BUFF12 switches */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_R12_BUFF12 0x3
/** control of BUFF22 switches */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_BUFF22 0x4
/** control of R12 + BUF22 switches */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_R12_BUFF22 0x5
/** control of BUF12 + BUFF22 switches */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_BUFF12_BUFF22 0x6
/** control of R12 + BUFF12 + BUFF22 switches */
#define ADC_OVLD2_SEL_ADC_OVLD_SEL_STG2_R12_BUFF12_BUFF22 0x7

/** ADC Enable Overload Switch Control Stage 1 - Enables/Disables the Overload Switch Control for the Loopfilters of stage 1 in the ADC. If this bit is not set, the overload control signal has no effect. */
#define ADC_OVLD_ADC_OVLD1_EN_SW_CTL_MASK 0x8
#define ADC_OVLD_ADC_OVLD1_EN_SW_CTL_AFE_GET ((VR9_AfeRead(ADC_OVLD) & ADC_OVLD_ADC_OVLD1_EN_SW_CTL_MASK) >> 3)
#define ADC_OVLD_ADC_OVLD1_EN_SW_CTL_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val) << 3, ADC_OVLD_ADC_OVLD1_EN_SW_CTL_MASK)
/** Disabled (default) */
#define ADC_OVLD1_EN_SW_CTL_ADC_OVLD_SW_CTL_STG1_DISABLED 0x0
/** Enabled */
#define ADC_OVLD1_EN_SW_CTL_ADC_OVLD_SW_CTL_STG1_ENABLED 0x1

/** ADC Overload Selection Stage 1 - Selects the action during overload state for the loopfilters of stage 1 in the ADC. */
#define ADC_OVLD_ADC_OVLD1_SEL_MASK 0x7
#define ADC_OVLD_ADC_OVLD1_SEL_AFE_GET ((VR9_AfeRead(ADC_OVLD) & ADC_OVLD_ADC_OVLD1_SEL_MASK) >> 0)
#define ADC_OVLD_ADC_OVLD1_SEL_AFE_SET(val) VR9_AfeWrite(ADC_OVLD, (val) << 0, ADC_OVLD_ADC_OVLD1_SEL_MASK)
/** no action (default) */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_NOACTION 0x0
/** control of R11 switches */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_R11 0x1
/** control of BUFF11 switches */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_BUFF11 0x2
/** control of R11 + BUFF1 switches */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_R11_BUFF11 0x3
/** control of BUFF21 switches */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_BUFF21 0x4
/** control of R11 + BUF21 switches */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_R11_BUFF21 0x5
/** control of BUF11 + BUFF21 switches */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_BUFF11_BUFF21 0x6
/** control of R11 + BUFF11 + BUFF21 switches */
#define ADC_OVLD1_SEL_ADC_OVLD_SEL_STG1_R11_BUFF11_BUFF21 0x7


/** Control Register */
#define ADC_COMP_QT (AFE_BASE + 0x30)
#define ADC_COMP_QT_AFE_GET VR9_AfeRead(ADC_COMP_QT)
#define ADC_COMP_QT_AFE_SET(val) VR9_AfeWrite(ADC_COMP_QT, (val), 0xFFFF)

/** ADC Top Comparator Select Stage 2 - Selects the Top Comparator in stage 2 of the ADC during Fullscale Trimming. */
#define ADC_COMP_QT_ADC_SELECT_COMPTOP_STG2_MASK 0x8000
#define ADC_COMP_QT_ADC_SELECT_COMPTOP_STG2_AFE_GET ((VR9_AfeRead(ADC_COMP_QT) & ADC_COMP_QT_ADC_SELECT_COMPTOP_STG2_MASK) >> 15)
#define ADC_COMP_QT_ADC_SELECT_COMPTOP_STG2_AFE_SET(val) VR9_AfeWrite(ADC_COMP_QT, (val) << 15, ADC_COMP_QT_ADC_SELECT_COMPTOP_STG2_MASK)
/** Top Comparator NOT selected (default) */
#define ADC_SELECT_COMPTOP_STG2_ADC_COMPTOP_STG2_NOT_SELECTED 0x0
/** Top Comparator selected */
#define ADC_SELECT_COMPTOP_STG2_ADC_COMPTOP_STG2_SELECTED 0x1

/** ADC Top Comparator Stage 2 Power Down - Sets the Power Down Mode for the Top Comparator (MSB) in stage 2 of the ADC. This comparator is only used during ADC comparator trimming phase. In the application this Comparator must be in Power Down. */
#define ADC_COMP_QT_ADC_PDQ_COMPTOP_STG2_MASK 0x4000
#define ADC_COMP_QT_ADC_PDQ_COMPTOP_STG2_AFE_GET ((VR9_AfeRead(ADC_COMP_QT) & ADC_COMP_QT_ADC_PDQ_COMPTOP_STG2_MASK) >> 14)
#define ADC_COMP_QT_ADC_PDQ_COMPTOP_STG2_AFE_SET(val) VR9_AfeWrite(ADC_COMP_QT, (val) << 14, ADC_COMP_QT_ADC_PDQ_COMPTOP_STG2_MASK)
/** Power Down (default) */
#define ADC_PDQ_COMPTOP_STG2_ADC_COMPTOP_STG2_PDQ 0x0
/** Power Up */
#define ADC_PDQ_COMPTOP_STG2_ADC_COMPTOP_STG2_PUQ 0x1

/** ADC Comparator Reference Trimming Stage 2 - Sets the Trimming value for the comparators reference voltage in stage 2 of the ADC. This value is set during Fullscale Trimming in stage 2 of the ADC. */
#define ADC_COMP_QT_ADC_COMPREFTRIM_STG2_MASK 0x3f00
#define ADC_COMP_QT_ADC_COMPREFTRIM_STG2_AFE_GET ((VR9_AfeRead(ADC_COMP_QT) & ADC_COMP_QT_ADC_COMPREFTRIM_STG2_MASK) >> 8)
#define ADC_COMP_QT_ADC_COMPREFTRIM_STG2_AFE_SET(val) VR9_AfeWrite(ADC_COMP_QT, (val) << 8, ADC_COMP_QT_ADC_COMPREFTRIM_STG2_MASK)
/** minimum */
#define ADC_COMPREFTRIM_STG2_ADC_COMPREFTRIM_STG2_MIN 0x0
/** maximum */
#define ADC_COMPREFTRIM_STG2_ADC_COMPREFTRIM_STG2_MAX 0x3f

/** ADC Top Comparator Select Stage 1 - Selects the Top Comparator in stage 1 of the ADC during Fullscale Trimming. */
#define ADC_COMP_QT_ADC_SELECT_COMPTOP_STG1_MASK 0x80
#define ADC_COMP_QT_ADC_SELECT_COMPTOP_STG1_AFE_GET ((VR9_AfeRead(ADC_COMP_QT) & ADC_COMP_QT_ADC_SELECT_COMPTOP_STG1_MASK) >> 7)
#define ADC_COMP_QT_ADC_SELECT_COMPTOP_STG1_AFE_SET(val) VR9_AfeWrite(ADC_COMP_QT, (val) << 7, ADC_COMP_QT_ADC_SELECT_COMPTOP_STG1_MASK)
/** Top Comparator NOT selected (default) */
#define ADC_SELECT_COMPTOP_STG1_ADC_COMPTOP_STG1_NOT_SELECTED 0x0
/** Top Comparator selected */
#define ADC_SELECT_COMPTOP_STG1_ADC_COMPTOP_STG1_SELECTED 0x1

/** ADC Top Comparator Stage 1 Power Down - Sets the Power Down Mode for the Top Comparator (MSB) in stage 1 of the ADC. This comparator is only used during ADC comparator trimming phase. In the application this Comparator must be in Power Down. */
#define ADC_COMP_QT_ADC_PDQ_COMPTOP_STG1_MASK 0x40
#define ADC_COMP_QT_ADC_PDQ_COMPTOP_STG1_AFE_GET ((VR9_AfeRead(ADC_COMP_QT) & ADC_COMP_QT_ADC_PDQ_COMPTOP_STG1_MASK) >> 6)
#define ADC_COMP_QT_ADC_PDQ_COMPTOP_STG1_AFE_SET(val) VR9_AfeWrite(ADC_COMP_QT, (val) << 6, ADC_COMP_QT_ADC_PDQ_COMPTOP_STG1_MASK)
/** Power Down (default) */
#define ADC_PDQ_COMPTOP_STG1_ADC_COMPTOP_STG1_PDQ 0x0
/** Power Up */
#define ADC_PDQ_COMPTOP_STG1_ADC_COMPTOP_STG1_PUQ 0x1

/** ADC Comparator Reference Trimming Stage 1 - Sets the Trimming value for the comparators reference voltage in stage 1 of the ADC. This value is set during Fullscale Trimming in stage 1 of the ADC. */
#define ADC_COMP_QT_ADC_COMPREFTRIM_STG1_MASK 0x3f
#define ADC_COMP_QT_ADC_COMPREFTRIM_STG1_AFE_GET ((VR9_AfeRead(ADC_COMP_QT) & ADC_COMP_QT_ADC_COMPREFTRIM_STG1_MASK) >> 0)
#define ADC_COMP_QT_ADC_COMPREFTRIM_STG1_AFE_SET(val) VR9_AfeWrite(ADC_COMP_QT, (val) << 0, ADC_COMP_QT_ADC_COMPREFTRIM_STG1_MASK)
/** minimum */
#define ADC_COMPREFTRIM_STG1_ADC_COMPREFTRIM_STG1_MIN 0x0
/** maximum */
#define ADC_COMPREFTRIM_STG1_ADC_COMPREFTRIM_STG1_MAX 0x3f


/** Control Register */
#define ADC_COMP_STG12 (AFE_BASE + 0x31)
#define ADC_COMP_STG12_AFE_GET VR9_AfeRead(ADC_COMP_STG12)
#define ADC_COMP_STG12_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val), 0xFFFF)

/** ADC Comparators Stage 2 Power Down - Sets the Power Down Mode for the Comparators in stage 2 of the ADC. */
#define ADC_COMP_STG12_ADC_PD_COMP_STG2_MASK 0x800
#define ADC_COMP_STG12_ADC_PD_COMP_STG2_AFE_GET ((VR9_AfeRead(ADC_COMP_STG12) & ADC_COMP_STG12_ADC_PD_COMP_STG2_MASK) >> 11)
#define ADC_COMP_STG12_ADC_PD_COMP_STG2_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val) << 11, ADC_COMP_STG12_ADC_PD_COMP_STG2_MASK)
/** Power Up */
#define ADC_PD_COMP_STG2_ADC_COMP_STG2_PU 0x0
/** Power Down (default) */
#define ADC_PD_COMP_STG2_ADC_COMP_STG2_PD 0x1

/** ADC Trimming Range Comparators Stage 2 - Sets the Trimming Range for the Comparators in stage 2 of the ADC. The programming is binary coded. */
#define ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG2_MASK 0x300
#define ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG2_AFE_GET ((VR9_AfeRead(ADC_COMP_STG12) & ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG2_MASK) >> 8)
#define ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG2_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val) << 8, ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG2_MASK)
/** minimum */
#define ADC_COMPTRIMRANGE_STG2_ADC_COMPTRIMRANGE_STG2_MIN 0x0
/** maximum (default) */
#define ADC_COMPTRIMRANGE_STG2_ADC_COMPTRIMRANGE_STG2_MAX 0x3

/** ADC Biasing Power Down - Sets the Power Down Mode for the Local Biasing of the ADC. */
#define ADC_COMP_STG12_ADC_LOCALBIAS_PD_MASK 0x80
#define ADC_COMP_STG12_ADC_LOCALBIAS_PD_AFE_GET ((VR9_AfeRead(ADC_COMP_STG12) & ADC_COMP_STG12_ADC_LOCALBIAS_PD_MASK) >> 7)
#define ADC_COMP_STG12_ADC_LOCALBIAS_PD_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val) << 7, ADC_COMP_STG12_ADC_LOCALBIAS_PD_MASK)
/** Power Up */
#define ADC_LOCALBIAS_PD_ADC_LOCALBIAS_PU 0x0
/** Power Down (default) */
#define ADC_LOCALBIAS_PD_ADC_LOCALBIAS_PD 0x1

/** ADC Biasing Comparators - Programs the input biasing current for the Comparators biasing circuit in the ADC. */
#define ADC_COMP_STG12_ADC_PRG_IBIAS_FLASH_MASK 0x70
#define ADC_COMP_STG12_ADC_PRG_IBIAS_FLASH_AFE_GET ((VR9_AfeRead(ADC_COMP_STG12) & ADC_COMP_STG12_ADC_PRG_IBIAS_FLASH_MASK) >> 4)
#define ADC_COMP_STG12_ADC_PRG_IBIAS_FLASH_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val) << 4, ADC_COMP_STG12_ADC_PRG_IBIAS_FLASH_MASK)
/** 26uA */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_26UA 0x0
/** 27uA */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_27UA 0x1
/** 28uA */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_28UA 0x2
/** 29uA */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_29UA 0x3
/** 30uA (default) */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_30UA 0x4
/** 31uA */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_31UA 0x5
/** 32uA */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_32UA 0x6
/** 33uA */
#define ADC_PRG_IBIAS_FLASH_ADC_IB_FLASH_33UA 0x7

/** ADC Comparators Stage 1 Power Down - Sets the Power Down Mode for the Comparators in stage 1 of the ADC. */
#define ADC_COMP_STG12_ADC_PD_COMP_STG1_MASK 0x8
#define ADC_COMP_STG12_ADC_PD_COMP_STG1_AFE_GET ((VR9_AfeRead(ADC_COMP_STG12) & ADC_COMP_STG12_ADC_PD_COMP_STG1_MASK) >> 3)
#define ADC_COMP_STG12_ADC_PD_COMP_STG1_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val) << 3, ADC_COMP_STG12_ADC_PD_COMP_STG1_MASK)
/** Power Up */
#define ADC_PD_COMP_STG1_ADC_COMP_STG1_PU 0x0
/** Power Down (default) */
#define ADC_PD_COMP_STG1_ADC_COMP_STG1_PD 0x1

/** ADC Low Power Mode Comparators - Enables/Disables the Low Power Mode for the Comparators in stage 1 and 2 of the ADC. */
#define ADC_COMP_STG12_ADC_LOWPOWER_MASK 0x4
#define ADC_COMP_STG12_ADC_LOWPOWER_AFE_GET ((VR9_AfeRead(ADC_COMP_STG12) & ADC_COMP_STG12_ADC_LOWPOWER_MASK) >> 2)
#define ADC_COMP_STG12_ADC_LOWPOWER_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val) << 2, ADC_COMP_STG12_ADC_LOWPOWER_MASK)
/** Disabled (default) */
#define ADC_LOWPOWER_ADC_COMPARATOR_LOWPOWER_DISABLED 0x0
/** Enabled */
#define ADC_LOWPOWER_ADC_COMPARATOR_LOWPOWER_ENABLED 0x1

/** ADC Trimming Range Comparators Stage 1 - Sets the Trimming Range for the Comparators in stage 1 of the ADC. The programming is binary coded. */
#define ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG1_MASK 0x3
#define ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG1_AFE_GET ((VR9_AfeRead(ADC_COMP_STG12) & ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG1_MASK) >> 0)
#define ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG1_AFE_SET(val) VR9_AfeWrite(ADC_COMP_STG12, (val) << 0, ADC_COMP_STG12_ADC_COMPTRIMRANGE_STG1_MASK)
/** minimum */
#define ADC_COMPTRIMRANGE_STG1_ADC_COMPTRIMRANGE_STG1_MIN 0x0
/** maximum (default) */
#define ADC_COMPTRIMRANGE_STG1_ADC_COMPTRIMRANGE_STG1_MAX 0x3


/** Control Register */
#define ADC_LNDEC_STG1 (AFE_BASE + 0x32)
#define ADC_LNDEC_STG1_AFE_GET VR9_AfeRead(ADC_LNDEC_STG1)
#define ADC_LNDEC_STG1_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val), 0xFFFF)

/** ADC Output Clock Selection - Selects which clock (from stage 1 or stage 2 of ADC) is used Decimation Path in the Digital Core. */
#define ADC_LNDEC_STG1_ADC_SELECT_CLKOUT_MASK 0x2000
#define ADC_LNDEC_STG1_ADC_SELECT_CLKOUT_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_SELECT_CLKOUT_MASK) >> 13)
#define ADC_LNDEC_STG1_ADC_SELECT_CLKOUT_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 13, ADC_LNDEC_STG1_ADC_SELECT_CLKOUT_MASK)
/** use clock from stage 1 (default) */
#define ADC_SELECT_CLKOUT_ADC_CLKOUT_SEL_STG1 0x0
/** use clock from stage 2 */
#define ADC_SELECT_CLKOUT_ADC_CLKOUT_SEL_STG2 0x1

/** ADC Digital Part Clock Inversion - Inverts the input clock of the digital part in the ADC. */
#define ADC_LNDEC_STG1_ADC_INV_CLKOUT_CORE_MASK 0x1000
#define ADC_LNDEC_STG1_ADC_INV_CLKOUT_CORE_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_INV_CLKOUT_CORE_MASK) >> 12)
#define ADC_LNDEC_STG1_ADC_INV_CLKOUT_CORE_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 12, ADC_LNDEC_STG1_ADC_INV_CLKOUT_CORE_MASK)
/** clock is not inverted (default) */
#define ADC_INV_CLKOUT_CORE_ADC_DIGPART_CLK_NO_INV 0x0
/** clock is inverted */
#define ADC_INV_CLKOUT_CORE_ADC_DIGPART_CLK_INV 0x1

/** ADC Reset Logic Clock Inversion - Inverts the input clock of the Reset Logic in the ADC. */
#define ADC_LNDEC_STG1_ADC_INVCLK_RSTQ_MASK 0x800
#define ADC_LNDEC_STG1_ADC_INVCLK_RSTQ_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_INVCLK_RSTQ_MASK) >> 11)
#define ADC_LNDEC_STG1_ADC_INVCLK_RSTQ_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 11, ADC_LNDEC_STG1_ADC_INVCLK_RSTQ_MASK)
/** clock is not inverted (default) */
#define ADC_INVCLK_RSTQ_ADC_RESET_CLK_NO_INV 0x0
/** clock is inverted */
#define ADC_INVCLK_RSTQ_ADC_RESET_CLK_INV 0x1

/** ADC Software Reset - Forces a Software Reset in the ADC. */
#define ADC_LNDEC_STG1_ADC_FORCE_RSTQ_MASK 0x100
#define ADC_LNDEC_STG1_ADC_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_FORCE_RSTQ_MASK) >> 8)
#define ADC_LNDEC_STG1_ADC_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 8, ADC_LNDEC_STG1_ADC_FORCE_RSTQ_MASK)
/** normal (default) */
#define ADC_FORCE_RSTQ_ADC_NO_RESET 0x0
/** in reset */
#define ADC_FORCE_RSTQ_ADC_FORCE_RESET 0x1

/** ADC Enable Data Output Stage 1 - Enables/Disables the data output in stage 1 of the ADC. */
#define ADC_LNDEC_STG1_ADC_EN_OUT_STG1_MASK 0x80
#define ADC_LNDEC_STG1_ADC_EN_OUT_STG1_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_EN_OUT_STG1_MASK) >> 7)
#define ADC_LNDEC_STG1_ADC_EN_OUT_STG1_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 7, ADC_LNDEC_STG1_ADC_EN_OUT_STG1_MASK)
/** Disabled (default) */
#define ADC_EN_OUT_STG1_ADC_DATAOUT_STG1_DISABLED 0x0
/** Enabled */
#define ADC_EN_OUT_STG1_ADC_DATAOUT_STG1_ENABLED 0x1

/** ADC Downrater Stage 1 Clock Inversion - Inverts the input clock of the Downrater in stage 1 of the ADC. */
#define ADC_LNDEC_STG1_ADC_INVCLK_OUT_STG1_MASK 0x40
#define ADC_LNDEC_STG1_ADC_INVCLK_OUT_STG1_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_INVCLK_OUT_STG1_MASK) >> 6)
#define ADC_LNDEC_STG1_ADC_INVCLK_OUT_STG1_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 6, ADC_LNDEC_STG1_ADC_INVCLK_OUT_STG1_MASK)
/** clock is not inverted (default) */
#define ADC_INVCLK_OUT_STG1_ADC_DOWNRATER_STG1_CLK_NO_INV 0x0
/** clock is inverted */
#define ADC_INVCLK_OUT_STG1_ADC_DOWNRATER_STG1_CLK_INV 0x1

/** ADC Line Decoder Stage 1 Clock Inversion - Inverts the input clock of the Line Decoder in stage 1 of the ADC. */
#define ADC_LNDEC_STG1_ADC_INVCLK_LNDEC_STG1_MASK 0x20
#define ADC_LNDEC_STG1_ADC_INVCLK_LNDEC_STG1_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_INVCLK_LNDEC_STG1_MASK) >> 5)
#define ADC_LNDEC_STG1_ADC_INVCLK_LNDEC_STG1_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 5, ADC_LNDEC_STG1_ADC_INVCLK_LNDEC_STG1_MASK)
/** clock is not inverted (default) */
#define ADC_INVCLK_LNDEC_STG1_ADC_LNDEC_STG1_CLK_NO_INV 0x0
/** clock is inverted */
#define ADC_INVCLK_LNDEC_STG1_ADC_LNDEC_STG1_CLK_INV 0x1

/** ADC Enable Line Decoder Clock Delay Programming Stage 1 - Enables/Disables clock delay programming in the stage 1 of the ADC. If this bit is not set, the programming of the delay for the Line Decoder has no effect. */
#define ADC_LNDEC_STG1_ADC_DLYEN_CLK_LNDEC_STG1_MASK 0x8
#define ADC_LNDEC_STG1_ADC_DLYEN_CLK_LNDEC_STG1_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_DLYEN_CLK_LNDEC_STG1_MASK) >> 3)
#define ADC_LNDEC_STG1_ADC_DLYEN_CLK_LNDEC_STG1_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 3, ADC_LNDEC_STG1_ADC_DLYEN_CLK_LNDEC_STG1_MASK)
/** Disabled (default) */
#define ADC_DLYEN_CLK_LNDEC_STG1_ADC_LNDEC_CLKDELAY_PRG_STG1_DISABLED 0x0
/** Enabled */
#define ADC_DLYEN_CLK_LNDEC_STG1_ADC_LNDEC_CLKDELAY_PRG_STG1_ENABLED 0x1

/** ADC Line Decoder Clock Delay Programming Stage 1 - Programs the delay of the clock for the Line Decoder in stage 1 of the ADC. The programming is binary coded. */
#define ADC_LNDEC_STG1_ADC_PRG_CLK_LNDEC_DELAY_STG1_MASK 0x7
#define ADC_LNDEC_STG1_ADC_PRG_CLK_LNDEC_DELAY_STG1_AFE_GET ((VR9_AfeRead(ADC_LNDEC_STG1) & ADC_LNDEC_STG1_ADC_PRG_CLK_LNDEC_DELAY_STG1_MASK) >> 0)
#define ADC_LNDEC_STG1_ADC_PRG_CLK_LNDEC_DELAY_STG1_AFE_SET(val) VR9_AfeWrite(ADC_LNDEC_STG1, (val) << 0, ADC_LNDEC_STG1_ADC_PRG_CLK_LNDEC_DELAY_STG1_MASK)
/** minimum (default) */
#define ADC_PRG_CLK_LNDEC_DELAY_STG1_ADC_LNDEC_CLKDELAY_STG1_MIN 0x0
/** maximum */
#define ADC_PRG_CLK_LNDEC_DELAY_STG1_ADC_LNDEC_CLKDELAY_STG1_MAX 0x7


/** Control Register */
#define ADC_DACS_STG1 (AFE_BASE + 0x33)
#define ADC_DACS_STG1_AFE_GET VR9_AfeRead(ADC_DACS_STG1)
#define ADC_DACS_STG1_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG1, (val), 0xFFFF)

/** ADC DAC11 Power Down - Sets the Power Down Mode for the 1st DAC in stage 1 of the ADC. */
#define ADC_DACS_STG1_ADC_PD_DAC11_MASK 0x8000
#define ADC_DACS_STG1_ADC_PD_DAC11_AFE_GET ((VR9_AfeRead(ADC_DACS_STG1) & ADC_DACS_STG1_ADC_PD_DAC11_MASK) >> 15)
#define ADC_DACS_STG1_ADC_PD_DAC11_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG1, (val) << 15, ADC_DACS_STG1_ADC_PD_DAC11_MASK)
/** Power Up */
#define ADC_PD_DAC11_ADC_DAC11_PU 0x0
/** Power Down (default) */
#define ADC_PD_DAC11_ADC_DAC11_PD 0x1

/** ADC DAC21 Power Down - Sets the Power Down Mode for the 2nd DAC in stage 1 of the ADC. */
#define ADC_DACS_STG1_ADC_PD_DAC21_MASK 0x80
#define ADC_DACS_STG1_ADC_PD_DAC21_AFE_GET ((VR9_AfeRead(ADC_DACS_STG1) & ADC_DACS_STG1_ADC_PD_DAC21_MASK) >> 7)
#define ADC_DACS_STG1_ADC_PD_DAC21_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG1, (val) << 7, ADC_DACS_STG1_ADC_PD_DAC21_MASK)
/** Power Up */
#define ADC_PD_DAC21_ADC_DAC21_PU 0x0
/** Power Down (default) */
#define ADC_PD_DAC21_ADC_DAC21_PD 0x1

/** ADC Reference Trimming DAC21 - Programs the biasing current for the 2nd DAC in stage 1 of the ADC. The programming is binary coded.The stepsize is 0.625%. */
#define ADC_DACS_STG1_ADC_DACREFTRIM21_MASK 0x3f
#define ADC_DACS_STG1_ADC_DACREFTRIM21_AFE_GET ((VR9_AfeRead(ADC_DACS_STG1) & ADC_DACS_STG1_ADC_DACREFTRIM21_MASK) >> 0)
#define ADC_DACS_STG1_ADC_DACREFTRIM21_AFE_SET(val) VR9_AfeWrite(ADC_DACS_STG1, (val) << 0, ADC_DACS_STG1_ADC_DACREFTRIM21_MASK)
/** 80% */
#define ADC_DACREFTRIM21_ADC_DAC21_REFTRIM_MIN 0x0
/** 100% (default) */
#define ADC_DACREFTRIM21_ADC_DAC21_REFTRIM_DEFAULT 0x20
/** 119.375% */
#define ADC_DACREFTRIM21_ADC_DAC21_REFTRIM_MAX 0x3f


/** Control Register */
#define ADC_LOOPF1_1 (AFE_BASE + 0x34)
#define ADC_LOOPF1_1_AFE_GET VR9_AfeRead(ADC_LOOPF1_1)
#define ADC_LOOPF1_1_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_1, (val), 0xFFFF)

/** ADC INTE11 Half Unity Capacitor - Halfes the stepsize in the capacitor array of the 1st Integrator in stage 1 of the ADC, by adding 1/2 of the Unity capacitor in the array.This means in other words, a finer programming of Integrator Time Constant is enabled. */
#define ADC_LOOPF1_1_ADC_C11HALFLSB_MASK 0x8000
#define ADC_LOOPF1_1_ADC_C11HALFLSB_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_1) & ADC_LOOPF1_1_ADC_C11HALFLSB_MASK) >> 15)
#define ADC_LOOPF1_1_ADC_C11HALFLSB_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_1, (val) << 15, ADC_LOOPF1_1_ADC_C11HALFLSB_MASK)
/** Normal (default) */
#define ADC_C11HALFLSB_ADC_C11HALFLSB_OFF 0x0
/** Half LSB Capacitor is ON */
#define ADC_C11HALFLSB_ADC_C11HALFLSB_ON 0x1

/** ADC INTE11 Fixed Capacitor - Sets the Fixed Capacitor in the capacitor array of the 1st integrator in stage 1 of the ADC. */
#define ADC_LOOPF1_1_ADC_C11FIX_MASK 0x4000
#define ADC_LOOPF1_1_ADC_C11FIX_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_1) & ADC_LOOPF1_1_ADC_C11FIX_MASK) >> 14)
#define ADC_LOOPF1_1_ADC_C11FIX_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_1, (val) << 14, ADC_LOOPF1_1_ADC_C11FIX_MASK)
/** Fixed Capacitor switched OFF = only for testing */
#define ADC_C11FIX_ADC_C11FIX_OFF 0x0
/** Normal (default) */
#define ADC_C11FIX_ADC_C11FIX_ON 0x1

/** ADC INTE11 Tuning - Tuning of the 1st Integrator's Time Constant in stage 1 of the ADC. The tuning word is calculated by the VR9-D. The programming is binary coded. */
#define ADC_LOOPF1_1_ADC_BITC11_MASK 0x3f00
#define ADC_LOOPF1_1_ADC_BITC11_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_1) & ADC_LOOPF1_1_ADC_BITC11_MASK) >> 8)
#define ADC_LOOPF1_1_ADC_BITC11_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_1, (val) << 8, ADC_LOOPF1_1_ADC_BITC11_MASK)
/** minimum time constant */
#define ADC_BITC11_ADC_C11_MIN 0x0
/** maximum time constant */
#define ADC_BITC11_ADC_C11_MAX 0x3f

/** ADC Gain Programming - Selects the gain of the ADC. The programming is thermometer coded. */
#define ADC_LOOPF1_1_ADC_BITR11_MASK 0xff
#define ADC_LOOPF1_1_ADC_BITR11_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_1) & ADC_LOOPF1_1_ADC_BITR11_MASK) >> 0)
#define ADC_LOOPF1_1_ADC_BITR11_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_1, (val) << 0, ADC_LOOPF1_1_ADC_BITR11_MASK)
/** Input OPEN */
#define ADC_BITR11_ADC_INPUT_OPEN 0x0
/** 0dB */
#define ADC_BITR11_ADC_GAIN_0DB 0x1
/** 1dB */
#define ADC_BITR11_ADC_GAIN_1DB 0x3
/** 2dB */
#define ADC_BITR11_ADC_GAIN_2DB 0x7
/** 3dB */
#define ADC_BITR11_ADC_GAIN_3DB 0xf
/** 4dB */
#define ADC_BITR11_ADC_GAIN_4DB 0x1f
/** 5dB */
#define ADC_BITR11_ADC_GAIN_5DB 0x3f
/** 6dB */
#define ADC_BITR11_ADC_GAIN_6DB 0x7f
/** differential input shortcut to common mode of 0.7V (default) */
#define ADC_BITR11_ADC_INPUT_TO_VCM 0x80


/** Control Register */
#define ADC_LOOPF1_2 (AFE_BASE + 0x35)
#define ADC_LOOPF1_2_AFE_GET VR9_AfeRead(ADC_LOOPF1_2)
#define ADC_LOOPF1_2_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val), 0xFFFF)

/** ADC INTE21 Half Unity Capacitor - Halfes the stepsize in the capacitor array of the 2nd Integrator in stage 1 of the ADC, by adding 1/2 of the Unity capacitor in the array.This means in other words, a finer programming of Integrator Time Constant is enabled. */
#define ADC_LOOPF1_2_ADC_C21HALFLSB_MASK 0x8000
#define ADC_LOOPF1_2_ADC_C21HALFLSB_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_2) & ADC_LOOPF1_2_ADC_C21HALFLSB_MASK) >> 15)
#define ADC_LOOPF1_2_ADC_C21HALFLSB_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val) << 15, ADC_LOOPF1_2_ADC_C21HALFLSB_MASK)
/** Normal (default) */
#define ADC_C21HALFLSB_ADC_C21HALFLSB_OFF 0x0
/** Half LSB Capacitor is ON */
#define ADC_C21HALFLSB_ADC_C21HALFLSB_ON 0x1

/** ADC INTE21 Fixed Capacitor - Sets the Fixed Capacitor in the capacitor array of the 2nd integrator in stage 1 of the ADC. */
#define ADC_LOOPF1_2_ADC_C21FIX_MASK 0x4000
#define ADC_LOOPF1_2_ADC_C21FIX_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_2) & ADC_LOOPF1_2_ADC_C21FIX_MASK) >> 14)
#define ADC_LOOPF1_2_ADC_C21FIX_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val) << 14, ADC_LOOPF1_2_ADC_C21FIX_MASK)
/** Fixed Capacitor switched OFF = only for testing */
#define ADC_C21FIX_ADC_C21FIX_OFF 0x0
/** Normal (default) */
#define ADC_C21FIX_ADC_C21FIX_ON 0x1

/** ADC INTE21 Tuning - Tuning of the 2nd Integrator's Time Constant in stage 1 of the ADC. The tuning word is calculated by the VR9-D. The programming is binary coded. */
#define ADC_LOOPF1_2_ADC_BITC21_MASK 0x3f00
#define ADC_LOOPF1_2_ADC_BITC21_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_2) & ADC_LOOPF1_2_ADC_BITC21_MASK) >> 8)
#define ADC_LOOPF1_2_ADC_BITC21_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val) << 8, ADC_LOOPF1_2_ADC_BITC21_MASK)
/** minimum time constant */
#define ADC_BITC21_ADC_C21_MIN 0x0
/** maximum time constant */
#define ADC_BITC21_ADC_C21_MAX 0x3f

/** ADC Loopfilter Stage 1 - Sets the feedback resistor of the loopfilter in stage 1 of the ADC. */
#define ADC_LOOPF1_2_ADC_LF1RES_MASK 0xf0
#define ADC_LOOPF1_2_ADC_LF1RES_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_2) & ADC_LOOPF1_2_ADC_LF1RES_MASK) >> 4)
#define ADC_LOOPF1_2_ADC_LF1RES_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val) << 4, ADC_LOOPF1_2_ADC_LF1RES_MASK)
/** OPEN (default) */
#define ADC_LF1RES_ADC_LF1RES_OPEN 0x0
/** 9.38kOhm */
#define ADC_LF1RES_ADC_LF1RES_9K38OHM 0x1
/** 18.63kOhm */
#define ADC_LF1RES_ADC_LF1RES_18K63OHM 0x2
/** 59.50kOhm */
#define ADC_LF1RES_ADC_LF1RES_59K50OHM 0x4
/** 122.75kOhm */
#define ADC_LF1RES_ADC_LF1RES_122K75OHM 0x8

/** ADC INTE11 Buffer Mode - Sets the Buffer Mode of the 1st integrator in stage 1 of the ADC. */
#define ADC_LOOPF1_2_ADC_BUFF11_MASK 0x8
#define ADC_LOOPF1_2_ADC_BUFF11_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_2) & ADC_LOOPF1_2_ADC_BUFF11_MASK) >> 3)
#define ADC_LOOPF1_2_ADC_BUFF11_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val) << 3, ADC_LOOPF1_2_ADC_BUFF11_MASK)
/** Buffer Mode OFF = Feedbackresistor is switched OFF (default) */
#define ADC_BUFF11_ADC_BUFF11_OFF 0x0
/** Buffer Mode ON = Feedbackresistor is switched ON */
#define ADC_BUFF11_ADC_BUFF11_ON 0x1

/** ADC INTE21 Buffer Mode - Sets the Buffer Mode of the 2nd integrator in stage 1 of the ADC. */
#define ADC_LOOPF1_2_ADC_BUFF21_MASK 0x4
#define ADC_LOOPF1_2_ADC_BUFF21_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_2) & ADC_LOOPF1_2_ADC_BUFF21_MASK) >> 2)
#define ADC_LOOPF1_2_ADC_BUFF21_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val) << 2, ADC_LOOPF1_2_ADC_BUFF21_MASK)
/** Buffer Mode OFF = Feedbackresistor is switched OFF (default) */
#define ADC_BUFF21_ADC_BUFF21_OFF 0x0
/** Buffer Mode ON = Feedbackresistor is switched ON */
#define ADC_BUFF21_ADC_BUFF21_ON 0x1

/** ADC INTE21 Input Resistor - Configures the input of the 2nd integrator in stage 1 of the ADC. */
#define ADC_LOOPF1_2_ADC_BITR21_MASK 0x3
#define ADC_LOOPF1_2_ADC_BITR21_AFE_GET ((VR9_AfeRead(ADC_LOOPF1_2) & ADC_LOOPF1_2_ADC_BITR21_MASK) >> 0)
#define ADC_LOOPF1_2_ADC_BITR21_AFE_SET(val) VR9_AfeWrite(ADC_LOOPF1_2, (val) << 0, ADC_LOOPF1_2_ADC_BITR21_MASK)
/** Input OPEN */
#define ADC_BITR21_ADC_BITR21_OPEN 0x0
/** normal = differential input enabled */
#define ADC_BITR21_ADC_BITR21_NORMAL 0x1
/** differential input shortcut to common mode of 0.7V (default) */
#define ADC_BITR21_ADC_BITR21_TO_VCM 0x2


/** Control Register */
#define ADC_DACEXT (AFE_BASE + 0x36)
#define ADC_DACEXT_AFE_GET VR9_AfeRead(ADC_DACEXT)
#define ADC_DACEXT_AFE_SET(val) VR9_AfeWrite(ADC_DACEXT, (val), 0xFFFF)

/** ADC Static Data Register for DACs - Sets the value of the static data used for all DACs in the ADC during Comparators calibration. The programming is thermometer coded. */
#define ADC_DACEXT_ADC_DAC_REGDATA_MASK 0xffff
#define ADC_DACEXT_ADC_DAC_REGDATA_AFE_GET ((VR9_AfeRead(ADC_DACEXT) & ADC_DACEXT_ADC_DAC_REGDATA_MASK) >> 0)
#define ADC_DACEXT_ADC_DAC_REGDATA_AFE_SET(val) VR9_AfeWrite(ADC_DACEXT, (val) << 0, ADC_DACEXT_ADC_DAC_REGDATA_MASK)
/** minimum value */
#define ADC_DAC_REGDATA_ADC_DAC_STATICDATA_MIN 0x0
/** maximum value */
#define ADC_DAC_REGDATA_ADC_DAC_STATICDATA_MAX 0xffff


/** Control Register */
#define ADC_CLK_STG1 (AFE_BASE + 0x37)
#define ADC_CLK_STG1_AFE_GET VR9_AfeRead(ADC_CLK_STG1)
#define ADC_CLK_STG1_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG1, (val), 0xFFFF)

/** ADC Clocking Stage1 Power Down - Sets the Power Down Mode for the ADC clocking in the stage 1. */
#define ADC_CLK_STG1_ADC_PD_CLK_STG1_MASK 0x8000
#define ADC_CLK_STG1_ADC_PD_CLK_STG1_AFE_GET ((VR9_AfeRead(ADC_CLK_STG1) & ADC_CLK_STG1_ADC_PD_CLK_STG1_MASK) >> 15)
#define ADC_CLK_STG1_ADC_PD_CLK_STG1_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG1, (val) << 15, ADC_CLK_STG1_ADC_PD_CLK_STG1_MASK)
/** Power Up */
#define ADC_PD_CLK_STG1_ADC_CLK_STG1_PU 0x0
/** Power Down (default) */
#define ADC_PD_CLK_STG1_ADC_CLK_STG1_PD 0x1

/** ADC Enable ELD Extended Range Half Speed Mode - Enables/Disables the extended Range (50%...25%) of the Excess Loop Delay (ELD) in the ADC. Enabling is valid only, if the ADC operates at half speed (288MHz). This bit is for test purposes only. */
#define ADC_CLK_STG1_ADC_ELD_SLOW_50TO25_MASK 0x200
#define ADC_CLK_STG1_ADC_ELD_SLOW_50TO25_AFE_GET ((VR9_AfeRead(ADC_CLK_STG1) & ADC_CLK_STG1_ADC_ELD_SLOW_50TO25_MASK) >> 9)
#define ADC_CLK_STG1_ADC_ELD_SLOW_50TO25_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG1, (val) << 9, ADC_CLK_STG1_ADC_ELD_SLOW_50TO25_MASK)
/** Disabled (default) */
#define ADC_ELD_SLOW_50TO25_ADC_ELD_SLOW_50TO25_OFF 0x0
/** Enabled */
#define ADC_ELD_SLOW_50TO25_ADC_ELD_SLOW_50TO25_ON 0x1

/** ADC Enable ELD Extended Range High Speed Mode - Enables/Disables the extended Range (100%...50%) of the Excess Loop Delay (ELD) in the ADC. Enabling is valid only, if the ADC operates at full speed (576MHz). This bit is for test purposes only. */
#define ADC_CLK_STG1_ADC_ELD_FAST_100TO50_MASK 0x100
#define ADC_CLK_STG1_ADC_ELD_FAST_100TO50_AFE_GET ((VR9_AfeRead(ADC_CLK_STG1) & ADC_CLK_STG1_ADC_ELD_FAST_100TO50_MASK) >> 8)
#define ADC_CLK_STG1_ADC_ELD_FAST_100TO50_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG1, (val) << 8, ADC_CLK_STG1_ADC_ELD_FAST_100TO50_MASK)
/** Disabled (default) */
#define ADC_ELD_FAST_100TO50_ADC_ELD_FAST_100TO50_OFF 0x0
/** Enabled */
#define ADC_ELD_FAST_100TO50_ADC_ELD_FAST_100TO50_ON 0x1

/** ADC Clock Pulse Width Programming Stage 1 - Programs the width of the comparators clock high pulse in the stage 1 of the ADC. During this period the comparator is able to process data. The programming is binary coded. */
#define ADC_CLK_STG1_ADC_PRG_MCLKWIDTH_STG1_MASK 0x70
#define ADC_CLK_STG1_ADC_PRG_MCLKWIDTH_STG1_AFE_GET ((VR9_AfeRead(ADC_CLK_STG1) & ADC_CLK_STG1_ADC_PRG_MCLKWIDTH_STG1_MASK) >> 4)
#define ADC_CLK_STG1_ADC_PRG_MCLKWIDTH_STG1_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG1, (val) << 4, ADC_CLK_STG1_ADC_PRG_MCLKWIDTH_STG1_MASK)
/** minimum ELD (default) */
#define ADC_PRG_MCLKWIDTH_STG1_ADC_COMPCLKWIDTH_STG1_MIN 0x0
/** maximum ELD */
#define ADC_PRG_MCLKWIDTH_STG1_ADC_COMPCLKWIDTH_STG1_MAX 0x7

/** ADC Enable Excess Loop Delay Programming Stage 1 - Enables/Disables Excess Loop Delay programming in the stage 1 of the ADC. If this bit is not set, the programming of the Excess Loop Delay has no effect. */
#define ADC_CLK_STG1_ADC_DELAY_ENABLE_STG1_MASK 0x8
#define ADC_CLK_STG1_ADC_DELAY_ENABLE_STG1_AFE_GET ((VR9_AfeRead(ADC_CLK_STG1) & ADC_CLK_STG1_ADC_DELAY_ENABLE_STG1_MASK) >> 3)
#define ADC_CLK_STG1_ADC_DELAY_ENABLE_STG1_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG1, (val) << 3, ADC_CLK_STG1_ADC_DELAY_ENABLE_STG1_MASK)
/** Disabled (default) */
#define ADC_DELAY_ENABLE_STG1_ADC_ELDPROG_STG1_DISABLED 0x0
/** Enabled */
#define ADC_DELAY_ENABLE_STG1_ADC_ELDPROG_STG1_ENABLED 0x1

/** ADC Excess Loop Delay Stage 1 - Programs the Excess Loop Delay (ELD) in the stage 1 of the ADC, which has influence on the stability of the feedback loop. The programming is binary coded. */
#define ADC_CLK_STG1_ADC_PRG_ELD_STG1_MASK 0x7
#define ADC_CLK_STG1_ADC_PRG_ELD_STG1_AFE_GET ((VR9_AfeRead(ADC_CLK_STG1) & ADC_CLK_STG1_ADC_PRG_ELD_STG1_MASK) >> 0)
#define ADC_CLK_STG1_ADC_PRG_ELD_STG1_AFE_SET(val) VR9_AfeWrite(ADC_CLK_STG1, (val) << 0, ADC_CLK_STG1_ADC_PRG_ELD_STG1_MASK)
/** maximum ELD (default) */
#define ADC_PRG_ELD_STG1_ADC_ELD_STG1_MAX 0x0
/** minimum ELD */
#define ADC_PRG_ELD_STG1_ADC_ELD_STG1_MIN 0x7


/** Control Register */
#define ADC_DACCAL_1 (AFE_BASE + 0x38)
#define ADC_DACCAL_1_AFE_GET VR9_AfeRead(ADC_DACCAL_1)
#define ADC_DACCAL_1_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_1, (val), 0xFFFF)

/** ADC DAC Calibration State Machine Power Down - Sets the Power Down Mode for the DACs Calibration State machine in stage 1 of the ADC. Only the DACs of stage 1 are calibrated. */
#define ADC_DACCAL_1_ADC_PD_DACCAL_DIG_MASK 0x8000
#define ADC_DACCAL_1_ADC_PD_DACCAL_DIG_AFE_GET ((VR9_AfeRead(ADC_DACCAL_1) & ADC_DACCAL_1_ADC_PD_DACCAL_DIG_MASK) >> 15)
#define ADC_DACCAL_1_ADC_PD_DACCAL_DIG_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_1, (val) << 15, ADC_DACCAL_1_ADC_PD_DACCAL_DIG_MASK)
/** Power Up */
#define ADC_PD_DACCAL_DIG_ADC_DACCAL_PU 0x0
/** Power Down (default) */
#define ADC_PD_DACCAL_DIG_ADC_DACCAL_PD 0x1

/** ADC Comparator Calibration with DAC21 - Enables/Disables the extra 1/2LSB for the 2nd DAC in stage 1 of the ADC used during Comparator calibration. Usually DAC21 will be used to calibrate the comparators in stage 1 of the ADC. */
#define ADC_DACCAL_1_ADC_COMPCAL21_MASK 0x2000
#define ADC_DACCAL_1_ADC_COMPCAL21_AFE_GET ((VR9_AfeRead(ADC_DACCAL_1) & ADC_DACCAL_1_ADC_COMPCAL21_MASK) >> 13)
#define ADC_DACCAL_1_ADC_COMPCAL21_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_1, (val) << 13, ADC_DACCAL_1_ADC_COMPCAL21_MASK)
/** Disabled (default) */
#define ADC_COMPCAL21_ADC_COMPCAL21_DISABLED 0x0
/** Enabled */
#define ADC_COMPCAL21_ADC_COMPCAL21_ENABLED 0x1

/** ADC Comparator Calibration with DAC11 - Enables/Disables the extra 1/2LSB for the 1st DAC in stage 1 of the ADC used during Comparator calibration. Usually DAC11 will NOT be used to calibrate the comparators in stage 1 of the ADC. */
#define ADC_DACCAL_1_ADC_COMPCAL11_MASK 0x1000
#define ADC_DACCAL_1_ADC_COMPCAL11_AFE_GET ((VR9_AfeRead(ADC_DACCAL_1) & ADC_DACCAL_1_ADC_COMPCAL11_MASK) >> 12)
#define ADC_DACCAL_1_ADC_COMPCAL11_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_1, (val) << 12, ADC_DACCAL_1_ADC_COMPCAL11_MASK)
/** Disabled (default) */
#define ADC_COMPCAL11_ADC_COMPCAL11_DISABLED 0x0
/** Enabled */
#define ADC_COMPCAL11_ADC_COMPCAL11_ENABLED 0x1

/** ADC DAC21 Polarity Extra 1/2LSB - Sets the polarity of the extra 1/2LSB for the 2nd DAC in stage 1 of the ADC used during Comparator calibration. */
#define ADC_DACCAL_1_ADC_XTRA_LSB_DAC21_MASK 0x800
#define ADC_DACCAL_1_ADC_XTRA_LSB_DAC21_AFE_GET ((VR9_AfeRead(ADC_DACCAL_1) & ADC_DACCAL_1_ADC_XTRA_LSB_DAC21_MASK) >> 11)
#define ADC_DACCAL_1_ADC_XTRA_LSB_DAC21_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_1, (val) << 11, ADC_DACCAL_1_ADC_XTRA_LSB_DAC21_MASK)
/** +1/2LSB (default) */
#define ADC_XTRA_LSB_DAC21_ADC_DAC21_EXTRA_LSB_POS 0x0
/** -1/2LSB */
#define ADC_XTRA_LSB_DAC21_ADC_DAC21_EXTRA_LSB_NEG 0x1

/** ADC DAC11 Polarity Extra 1/2LSB - Sets the polarity of the extra 1/2LSB for the 1st DAC in stage 1 of the ADC used during Comparator calibration. */
#define ADC_DACCAL_1_ADC_XTRA_LSB_DAC11_MASK 0x400
#define ADC_DACCAL_1_ADC_XTRA_LSB_DAC11_AFE_GET ((VR9_AfeRead(ADC_DACCAL_1) & ADC_DACCAL_1_ADC_XTRA_LSB_DAC11_MASK) >> 10)
#define ADC_DACCAL_1_ADC_XTRA_LSB_DAC11_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_1, (val) << 10, ADC_DACCAL_1_ADC_XTRA_LSB_DAC11_MASK)
/** +1/2LSB (default) */
#define ADC_XTRA_LSB_DAC11_ADC_DAC11_EXTRA_LSB_POS 0x0
/** -1/2LSB */
#define ADC_XTRA_LSB_DAC11_ADC_DAC11_EXTRA_LSB_NEG 0x1

/** ADC DACs stage 1 Fixed Calibration Cycle - Sets the fixed calibration cycle for the DACs in stage 1 of the ADC. */
#define ADC_DACCAL_1_ADC_DACCAL_NFIX_STG1_MASK 0x3ff
#define ADC_DACCAL_1_ADC_DACCAL_NFIX_STG1_AFE_GET ((VR9_AfeRead(ADC_DACCAL_1) & ADC_DACCAL_1_ADC_DACCAL_NFIX_STG1_MASK) >> 0)
#define ADC_DACCAL_1_ADC_DACCAL_NFIX_STG1_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_1, (val) << 0, ADC_DACCAL_1_ADC_DACCAL_NFIX_STG1_MASK)
/** minimum */
#define ADC_DACCAL_NFIX_STG1_ADCDAC_STG1_CAL_FIX_MIN 0x0
/** nominal (default) */
#define ADC_DACCAL_NFIX_STG1_ADCDAC_STG1_CAL_FIX_DEFAULT 0x7f
/** maximum */
#define ADC_DACCAL_NFIX_STG1_ADCDAC_STG1_CAL_FIX_MAX 0x3ff


/** Control Register */
#define ADC_DACCAL_2 (AFE_BASE + 0x39)
#define ADC_DACCAL_2_AFE_GET VR9_AfeRead(ADC_DACCAL_2)
#define ADC_DACCAL_2_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_2, (val), 0xFFFF)

/** ADC DACs Enable Static Data - Enables/Disables static data input for the DACs in the ADC. */
#define ADC_DACCAL_2_ADC_DAC_EXTDATA_MASK 0x8000
#define ADC_DACCAL_2_ADC_DAC_EXTDATA_AFE_GET ((VR9_AfeRead(ADC_DACCAL_2) & ADC_DACCAL_2_ADC_DAC_EXTDATA_MASK) >> 15)
#define ADC_DACCAL_2_ADC_DAC_EXTDATA_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_2, (val) << 15, ADC_DACCAL_2_ADC_DAC_EXTDATA_MASK)
/** normal data (default) */
#define ADC_DAC_EXTDATA_ADC_DAC_NORMAL_DATA 0x0
/** static data */
#define ADC_DAC_EXTDATA_ADC_DAC_STATIC_DATA 0x1

/** ADC Comparator Calibration with DAC22 - Enables/Disables the extra 1/2LSB for the 2nd DAC in stage 2 of the ADC used during Comparator calibration. Usually DAC21 will be used to calibrate the comparators in stage 2 of the ADC. */
#define ADC_DACCAL_2_ADC_COMPCAL22_MASK 0x2000
#define ADC_DACCAL_2_ADC_COMPCAL22_AFE_GET ((VR9_AfeRead(ADC_DACCAL_2) & ADC_DACCAL_2_ADC_COMPCAL22_MASK) >> 13)
#define ADC_DACCAL_2_ADC_COMPCAL22_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_2, (val) << 13, ADC_DACCAL_2_ADC_COMPCAL22_MASK)
/** Disabled (default) */
#define ADC_COMPCAL22_ADC_COMPCAL22_DISABLED 0x0
/** Enabled */
#define ADC_COMPCAL22_ADC_COMPCAL22_ENABLED 0x1

/** ADC Comparator Calibration with DAC12 - Enables/Disables the extra 1/2LSB for the 1st DAC in stage 2 of the ADC used during Comparator calibration. Usually DAC12 will NOT be used to calibrate the comparators in stage 2 of the ADC. */
#define ADC_DACCAL_2_ADC_COMPCAL12_MASK 0x1000
#define ADC_DACCAL_2_ADC_COMPCAL12_AFE_GET ((VR9_AfeRead(ADC_DACCAL_2) & ADC_DACCAL_2_ADC_COMPCAL12_MASK) >> 12)
#define ADC_DACCAL_2_ADC_COMPCAL12_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_2, (val) << 12, ADC_DACCAL_2_ADC_COMPCAL12_MASK)
/** Disabled (default) */
#define ADC_COMPCAL12_ADC_COMPCAL12_DISABLED 0x0
/** Enabled */
#define ADC_COMPCAL12_ADC_COMPCAL12_ENABLED 0x1

/** ADC DAC22 Polarity Extra 1/2LSB - Sets the polarity of the extra 1/2LSB for the 2nd DAC in stage 2 of the ADC used during Comparator calibration. */
#define ADC_DACCAL_2_ADC_XTRA_LSB_DAC22_MASK 0x800
#define ADC_DACCAL_2_ADC_XTRA_LSB_DAC22_AFE_GET ((VR9_AfeRead(ADC_DACCAL_2) & ADC_DACCAL_2_ADC_XTRA_LSB_DAC22_MASK) >> 11)
#define ADC_DACCAL_2_ADC_XTRA_LSB_DAC22_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_2, (val) << 11, ADC_DACCAL_2_ADC_XTRA_LSB_DAC22_MASK)
/** +1/2LSB (default) */
#define ADC_XTRA_LSB_DAC22_ADC_DAC22_EXTRA_LSB_POS 0x0
/** -1/2LSB */
#define ADC_XTRA_LSB_DAC22_ADC_DAC22_EXTRA_LSB_NEG 0x1

/** ADC DAC12 Polarity Extra 1/2LSB - Sets the polarity of the extra 1/2LSB for the 1st DAC in stage 2 of the ADC used during Comparator calibration. */
#define ADC_DACCAL_2_ADC_XTRA_LSB_DAC12_MASK 0x400
#define ADC_DACCAL_2_ADC_XTRA_LSB_DAC12_AFE_GET ((VR9_AfeRead(ADC_DACCAL_2) & ADC_DACCAL_2_ADC_XTRA_LSB_DAC12_MASK) >> 10)
#define ADC_DACCAL_2_ADC_XTRA_LSB_DAC12_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_2, (val) << 10, ADC_DACCAL_2_ADC_XTRA_LSB_DAC12_MASK)
/** +1/2LSB (default) */
#define ADC_XTRA_LSB_DAC12_ADC_DAC12_EXTRA_LSB_POS 0x0
/** -1/2LSB */
#define ADC_XTRA_LSB_DAC12_ADC_DAC12_EXTRA_LSB_NEG 0x1

/** ADC DACs stage 1 Variable Calibration Cycle - Sets the variable calibration cycle for the DACs in stage 1 of the ADC */
#define ADC_DACCAL_2_ADC_DACCAL_NVAR_STG1_MASK 0x3ff
#define ADC_DACCAL_2_ADC_DACCAL_NVAR_STG1_AFE_GET ((VR9_AfeRead(ADC_DACCAL_2) & ADC_DACCAL_2_ADC_DACCAL_NVAR_STG1_MASK) >> 0)
#define ADC_DACCAL_2_ADC_DACCAL_NVAR_STG1_AFE_SET(val) VR9_AfeWrite(ADC_DACCAL_2, (val) << 0, ADC_DACCAL_2_ADC_DACCAL_NVAR_STG1_MASK)
/** minimum */
#define ADC_DACCAL_NVAR_STG1_ADCDAC_STG1_CAL_VAR_MIN 0x0
/** nominal (default) */
#define ADC_DACCAL_NVAR_STG1_ADCDAC_STG1_CAL_VAR_DEFAULT 0x7f
/** maximum */
#define ADC_DACCAL_NVAR_STG1_ADCDAC_STG1_CAL_VAR_MAX 0x3ff

#endif /* _VR9_AFE_ANALOG_REG_H */
