/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
// ******************************************************************
// vr9_afe_dig_ch0_reg.h
//
// History
//
// 29/03/2011 Vinjam: Add "enable FIFOs" in FIFO init function and
//            renamed "VR9_A2x_FIFO_FIX( )" to "VR9_Init_AFE_FIFOs( )"
//            Grep for XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO
// ******************************************************************

#ifndef _VINAX_AFE_DIG_CH0_H
#define _VINAX_AFE_DIG_CH0_H


#define VINAX_AFE_DIG_CH0_BASE 0x400

/** ADC Clocking Control Register - ADC Clocking Control Register */
#define ADC_CTL (VINAX_AFE_DIG_CH0_BASE + 0x0)
#define ADC_CTL_AFE_GET VR9_AfeRead(ADC_CTL)
#define ADC_CTL_AFE_SET(val) VR9_AfeWrite(ADC_CTL, (val), 0xFFFF)

/** ADC Functional Reset - resets ADC digital data interface (active low) */
#define ADC_CTL_ADC_FCTRES_N_MASK 0x1
#define ADC_CTL_ADC_FCTRES_N_AFE_GET ((VR9_AfeRead(ADC_CTL) & ADC_CTL_ADC_FCTRES_N_MASK) >> 0)
#define ADC_CTL_ADC_FCTRES_N_AFE_SET(val) VR9_AfeWrite(ADC_CTL, (val) << 0, ADC_CTL_ADC_FCTRES_N_MASK)
/** ADC digital data interface is in reset state (default) */
#define ADC_FCTRES_N_EN 0x0
/** ADC digital data interface is in operation state */
#define ADC_FCTRES_N_DIS 0x1

/** ADC Clock Output Enable - enables ADC digital data interface clock */
#define ADC_CTL_ADC_CLKOUT_ENABLE_MASK 0x40
#define ADC_CTL_ADC_CLKOUT_ENABLE_AFE_GET ((VR9_AfeRead(ADC_CTL) & ADC_CTL_ADC_CLKOUT_ENABLE_MASK) >> 6)
#define ADC_CTL_ADC_CLKOUT_ENABLE_AFE_SET(val) VR9_AfeWrite(ADC_CTL, (val) << 6, ADC_CTL_ADC_CLKOUT_ENABLE_MASK)
/** ADC digital data interface clock is disabled (default) */
#define ADC_CLKOUT_ENABLE_DIS 0x0
/** ADC digital data interface clock is enabled */
#define ADC_CLKOUT_ENABLE_EN 0x1

/** ADC Clock Output Inversion - inverts ADC digital data interface clock */
#define ADC_CTL_ADC_INV_CLKOUT_MASK 0x80
#define ADC_CTL_ADC_INV_CLKOUT_AFE_GET ((VR9_AfeRead(ADC_CTL) & ADC_CTL_ADC_INV_CLKOUT_MASK) >> 7)
#define ADC_CTL_ADC_INV_CLKOUT_AFE_SET(val) VR9_AfeWrite(ADC_CTL, (val) << 7, ADC_CTL_ADC_INV_CLKOUT_MASK)
/** ADC digital data interface clock inversion is disabled (default) */
#define ADC_INV_CLKOUT_DIS 0x0
/** ADC digital data interface clock inversion is enabled */
#define ADC_INV_CLKOUT_EN 0x1


/** DAC1 Clocking Control Register - DAC1 Clocking Control Register */
#define DAC1_CTL (VINAX_AFE_DIG_CH0_BASE + 0x1)
#define DAC1_CTL_AFE_GET VR9_AfeRead(DAC1_CTL)
#define DAC1_CTL_AFE_SET(val) VR9_AfeWrite(DAC1_CTL, (val), 0xFFFF)

/** DAC1 Functional Reset - resets DAC1 digital core (active low) */
#define DAC1_CTL_DAC1_FCTRES_N_MASK 0x1
#define DAC1_CTL_DAC1_FCTRES_N_AFE_GET ((VR9_AfeRead(DAC1_CTL) & DAC1_CTL_DAC1_FCTRES_N_MASK) >> 0)
#define DAC1_CTL_DAC1_FCTRES_N_AFE_SET(val) VR9_AfeWrite(DAC1_CTL, (val) << 0, DAC1_CTL_DAC1_FCTRES_N_MASK)
/** DAC1 digital core is in reset state (default) */
#define DAC1_FCTRES_N_EN 0x0
/** DAC1 digital core is in operating state */
#define DAC1_FCTRES_N_DIS 0x1

/** DAC1 Clock Input Enable - enables DAC1 digital core clock */
#define DAC1_CTL_DAC1_CLK_ENABLE_MASK 0x2
#define DAC1_CTL_DAC1_CLK_ENABLE_AFE_GET ((VR9_AfeRead(DAC1_CTL) & DAC1_CTL_DAC1_CLK_ENABLE_MASK) >> 1)
#define DAC1_CTL_DAC1_CLK_ENABLE_AFE_SET(val) VR9_AfeWrite(DAC1_CTL, (val) << 1, DAC1_CTL_DAC1_CLK_ENABLE_MASK)
/** DAC1 digital core clock is disabled (default) */
#define DAC1_CLK_ENABLE_DIS 0x0
/** DAC1 digital core clock is enabled */
#define DAC1_CLK_ENABLE_EN 0x1

/** DAC1 Powerdown Switch - controls DAC1 clock buffer */
#define DAC1_CTL_DAC1_PD_CLKBUF_MASK 0x4
#define DAC1_CTL_DAC1_PD_CLKBUF_AFE_GET ((VR9_AfeRead(DAC1_CTL) & DAC1_CTL_DAC1_PD_CLKBUF_MASK) >> 2)
#define DAC1_CTL_DAC1_PD_CLKBUF_AFE_SET(val) VR9_AfeWrite(DAC1_CTL, (val) << 2, DAC1_CTL_DAC1_PD_CLKBUF_MASK)
/** DAC1 clock buffer is powerup */
#define DAC1_PD_CLKBUF_DIS 0x0
/** DAC1 clock buffer is powerdown (default) */
#define DAC1_PD_CLKBUF_EN 0x1

/** DAC1 Clock Output Enable - enables DAC1 digital data interface clock */
#define DAC1_CTL_DAC1_CLKOUT_ENABLE_MASK 0x40
#define DAC1_CTL_DAC1_CLKOUT_ENABLE_AFE_GET ((VR9_AfeRead(DAC1_CTL) & DAC1_CTL_DAC1_CLKOUT_ENABLE_MASK) >> 6)
#define DAC1_CTL_DAC1_CLKOUT_ENABLE_AFE_SET(val) VR9_AfeWrite(DAC1_CTL, (val) << 6, DAC1_CTL_DAC1_CLKOUT_ENABLE_MASK)
/** DAC1 digital data interface clock is disabled (default) */
#define DAC1_CLKOUT_ENABLE_DIS 0x0
/** DAC1 digital data interface clock is enabled */
#define DAC1_CLKOUT_ENABLE_EN 0x1

/** DAC1 Clock Output Inversion - inverts DAC1 digital data interface clock */
#define DAC1_CTL_DAC1_INV_CLKOUT_MASK 0x80
#define DAC1_CTL_DAC1_INV_CLKOUT_AFE_GET ((VR9_AfeRead(DAC1_CTL) & DAC1_CTL_DAC1_INV_CLKOUT_MASK) >> 7)
#define DAC1_CTL_DAC1_INV_CLKOUT_AFE_SET(val) VR9_AfeWrite(DAC1_CTL, (val) << 7, DAC1_CTL_DAC1_INV_CLKOUT_MASK)
/** DAC1 digital data interface clock inversion is disabled (default) */
#define DAC1_INV_CLKOUT_DIS 0x0
/** DAC1 digital data interface clock inversion is enabled */
#define DAC1_INV_CLKOUT_EN 0x1


/** DAC2 Clocking Control Register - DAC2 Clocking Control Register */
#define DAC2_CTL (VINAX_AFE_DIG_CH0_BASE + 0x2)
#define DAC2_CTL_AFE_GET VR9_AfeRead(DAC2_CTL)
#define DAC2_CTL_AFE_SET(val) VR9_AfeWrite(DAC2_CTL, (val), 0xFFFF)

/** DAC2 Functional Reset - resets DAC2 digital core (active low) */
#define DAC2_CTL_DAC2_FCTRES_N_MASK 0x1
#define DAC2_CTL_DAC2_FCTRES_N_AFE_GET ((VR9_AfeRead(DAC2_CTL) & DAC2_CTL_DAC2_FCTRES_N_MASK) >> 0)
#define DAC2_CTL_DAC2_FCTRES_N_AFE_SET(val) VR9_AfeWrite(DAC2_CTL, (val) << 0, DAC2_CTL_DAC2_FCTRES_N_MASK)
/** DAC2 digital core is in reset state (default) */
#define DAC2_FCTRES_N_EN 0x0
/** DAC2 digital core is in operating state */
#define DAC2_FCTRES_N_DIS 0x1

/** DAC2 Clock Enable - enables DAC2 digital core clock */
#define DAC2_CTL_DAC2_CLK_ENABLE_MASK 0x2
#define DAC2_CTL_DAC2_CLK_ENABLE_AFE_GET ((VR9_AfeRead(DAC2_CTL) & DAC2_CTL_DAC2_CLK_ENABLE_MASK) >> 1)
#define DAC2_CTL_DAC2_CLK_ENABLE_AFE_SET(val) VR9_AfeWrite(DAC2_CTL, (val) << 1, DAC2_CTL_DAC2_CLK_ENABLE_MASK)
/** DAC2 digital core clock is disabled (default) */
#define DAC2_CLK_ENABLE_DIS 0x0
/** DAC2 digital core clock is enabled */
#define DAC2_CLK_ENABLE_EN 0x1

/** DAC2 Powerdown Clock Buffer - powerdown control for DAC2 clock buffer */
#define DAC2_CTL_DAC2_PD_CLKBUF_MASK 0x4
#define DAC2_CTL_DAC2_PD_CLKBUF_AFE_GET ((VR9_AfeRead(DAC2_CTL) & DAC2_CTL_DAC2_PD_CLKBUF_MASK) >> 2)
#define DAC2_CTL_DAC2_PD_CLKBUF_AFE_SET(val) VR9_AfeWrite(DAC2_CTL, (val) << 2, DAC2_CTL_DAC2_PD_CLKBUF_MASK)
/** DAC2 clock buffer is powerup */
#define DAC2_PD_CLKBUF_DIS 0x0
/** DAC2 clock buffer is powerdown (default) */
#define DAC2_PD_CLKBUF_EN 0x1

/** DAC2 Clock Output Enable - enables DAC2 digital data interface clock */
#define DAC2_CTL_DAC2_CLKOUT_ENABLE_MASK 0x40
#define DAC2_CTL_DAC2_CLKOUT_ENABLE_AFE_GET ((VR9_AfeRead(DAC2_CTL) & DAC2_CTL_DAC2_CLKOUT_ENABLE_MASK) >> 6)
#define DAC2_CTL_DAC2_CLKOUT_ENABLE_AFE_SET(val) VR9_AfeWrite(DAC2_CTL, (val) << 6, DAC2_CTL_DAC2_CLKOUT_ENABLE_MASK)
/** DAC2 digital data interface clock is disabled (default) */
#define DAC2_CLKOUT_ENABLE_DIS 0x0
/** DAC2 digital data interface clock is enabled */
#define DAC2_CLKOUT_ENABLE_EN 0x1

/** DAC2 Clock Output Inversion - inverts DAC2 interface clock */
#define DAC2_CTL_DAC2_INV_CLKOUT_MASK 0x80
#define DAC2_CTL_DAC2_INV_CLKOUT_AFE_GET ((VR9_AfeRead(DAC2_CTL) & DAC2_CTL_DAC2_INV_CLKOUT_MASK) >> 7)
#define DAC2_CTL_DAC2_INV_CLKOUT_AFE_SET(val) VR9_AfeWrite(DAC2_CTL, (val) << 7, DAC2_CTL_DAC2_INV_CLKOUT_MASK)
/** DAC2 digital data interface clock inversion is disabled (default) */
#define DAC2_INV_CLKOUT_DIS 0x0
/** DAC2 digital data interface clock inversion is enabled */
#define DAC2_INV_CLKOUT_EN 0x1


/** Global GPIO line driver output Register - Global GPIO line driver output Register */
#define GPIO_LD_DOUT (VINAX_AFE_DIG_CH0_BASE + 0x3)
#define GPIO_LD_DOUT_AFE_GET VR9_AfeRead(GPIO_LD_DOUT)
#define GPIO_LD_DOUT_AFE_SET(val) VR9_AfeWrite(GPIO_LD_DOUT, (val), 0xFFFF)

/** GPIO_LD Output Data - sets the value of each GPIO line driver output pin */
#define GPIO_LD_DOUT_GPIO_LD_DOUT_MASK 0xf
#define GPIO_LD_DOUT_GPIO_LD_DOUT_AFE_GET ((VR9_AfeRead(GPIO_LD_DOUT) & GPIO_LD_DOUT_GPIO_LD_DOUT_MASK) >> 0)
#define GPIO_LD_DOUT_GPIO_LD_DOUT_AFE_SET(val) VR9_AfeWrite(GPIO_LD_DOUT, (val) << 0, GPIO_LD_DOUT_GPIO_LD_DOUT_MASK)
/** All line driver output pins are set to low (default) */
#define GPIO_LD_DOUT_LOW 0x0
/** All line driver output pins are set to high */
#define GPIO_LD_DOUT_HIGH 0xf


/** Global GPIO line driver input Register - Global GPIO line driver input Register */
#define GPIO_LD_DIN (VINAX_AFE_DIG_CH0_BASE + 0x4)
#define GPIO_LD_DIN_AFE_GET VR9_AfeRead(GPIO_LD_DIN)
#define GPIO_LD_DIN_AFE_SET(val) VR9_AfeWrite(GPIO_LD_DIN, (val), 0xFFFF)

/** GPIO_LD Input Data - reports the value of each GPIO line driver input pin */
#define GPIO_LD_DIN_GPIO_LD_DIN_MASK 0xf
#define GPIO_LD_DIN_GPIO_LD_DIN_AFE_GET ((VR9_AfeRead(GPIO_LD_DIN) & GPIO_LD_DIN_GPIO_LD_DIN_MASK) >> 0)
#define GPIO_LD_DIN_GPIO_LD_DIN_AFE_SET(val) VR9_AfeWrite(GPIO_LD_DIN, (val) << 0, GPIO_LD_DIN_GPIO_LD_DIN_MASK)
/** all line driver input bits low */
#define GPIO_LD_DIN_LOW 0x0
/** all line driver input bits high */
#define GPIO_LD_DIN_HIGH 0xf


/** Global GPIO line driver control Register - Global GPIO line driver control Register */
#define GPIO_LD_CTL (VINAX_AFE_DIG_CH0_BASE + 0x5)
#define GPIO_LD_CTL_AFE_GET VR9_AfeRead(GPIO_LD_CTL)
#define GPIO_LD_CTL_AFE_SET(val) VR9_AfeWrite(GPIO_LD_CTL, (val), 0xFFFF)

/** GPIO_LD Output Enable - controls each GPIO line driver output pin */
#define GPIO_LD_CTL_GPIO_LD_OEN_N_MASK 0xf
#define GPIO_LD_CTL_GPIO_LD_OEN_N_AFE_GET ((VR9_AfeRead(GPIO_LD_CTL) & GPIO_LD_CTL_GPIO_LD_OEN_N_MASK) >> 0)
#define GPIO_LD_CTL_GPIO_LD_OEN_N_AFE_SET(val) VR9_AfeWrite(GPIO_LD_CTL, (val) << 0, GPIO_LD_CTL_GPIO_LD_OEN_N_MASK)
/** All line driver output pins are enabled */
#define GPIO_LD_OEN_N_EN 0x0
/** All line driver output pins are disabled (default) */
#define GPIO_LD_OEN_N_DIS 0xf

/** GPIO_LD Push-pull Enable - enables GPIO line driver outputs push-pull */
#define GPIO_LD_CTL_GPIO_LD_PPEN_MASK 0xf00
#define GPIO_LD_CTL_GPIO_LD_PPEN_AFE_GET ((VR9_AfeRead(GPIO_LD_CTL) & GPIO_LD_CTL_GPIO_LD_PPEN_MASK) >> 8)
#define GPIO_LD_CTL_GPIO_LD_PPEN_AFE_SET(val) VR9_AfeWrite(GPIO_LD_CTL, (val) << 8, GPIO_LD_CTL_GPIO_LD_PPEN_MASK)
/** All line driver output pins are opendrain (default) */
#define GPIO_LD_PPEN_OD 0x0
/** All line driver output pins are push-pull */
#define GPIO_LD_PPEN_PP 0xf


/** Global GLP control Register 0 - Global GLP control Register 0 */
#define GLP_CTL0 (VINAX_AFE_DIG_CH0_BASE + 0x6)
#define GLP_CTL0_AFE_GET VR9_AfeRead(GLP_CTL0)
#define GLP_CTL0_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val), 0xFFFF)

/** GLP Functional Reset - resets GLP data registers (active low) */
#define GLP_CTL0_GLP_FCTRES_N_MASK 0x1
#define GLP_CTL0_GLP_FCTRES_N_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_FCTRES_N_MASK) >> 0)
#define GLP_CTL0_GLP_FCTRES_N_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 0, GLP_CTL0_GLP_FCTRES_N_MASK)
/** GLP data registers are in reset state */
#define GLP_FCTRES_N_GLP_RESET 0x0
/** GLP data registers are in operating state (default) */
#define GLP_FCTRES_N_GLP_NORMAL 0x1

/** GLP TX1 Data Clock Output Enable - enables GLP TX1 data clock */
#define GLP_CTL0_GLP_TX1_DATA_CLKOUT_EN_MASK 0x2
#define GLP_CTL0_GLP_TX1_DATA_CLKOUT_EN_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_TX1_DATA_CLKOUT_EN_MASK) >> 1)
#define GLP_CTL0_GLP_TX1_DATA_CLKOUT_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 1, GLP_CTL0_GLP_TX1_DATA_CLKOUT_EN_MASK)
/** TX1 data interface clock is disabled (default) */
#define GLP_TX1_DATA_CLKOUT_EN_GLP_TX1_DIS 0x0
/** TX1 data interface clock is enabled */
#define GLP_TX1_DATA_CLKOUT_EN_GLP_TX1_EN 0x1

/** GLP TX2 Data Clock Output Enable - enables GLP TX2 data interface clock */
#define GLP_CTL0_GLP_TX2_DATA_CLKOUT_EN_MASK 0x4
#define GLP_CTL0_GLP_TX2_DATA_CLKOUT_EN_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_TX2_DATA_CLKOUT_EN_MASK) >> 2)
#define GLP_CTL0_GLP_TX2_DATA_CLKOUT_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 2, GLP_CTL0_GLP_TX2_DATA_CLKOUT_EN_MASK)
/** TX2 data interface clock is disabled (default) */
#define GLP_TX2_DATA_CLKOUT_EN_GLP_TX2_DIS 0x0
/** TX2 data interface clock is enabled */
#define GLP_TX2_DATA_CLKOUT_EN_GLP_TX2_EN 0x1

/** GLP RX Data Clock Output Enable - enables GLP RX data interface clock */
#define GLP_CTL0_GLP_RX_DATA_CLKOUT_EN_MASK 0x8
#define GLP_CTL0_GLP_RX_DATA_CLKOUT_EN_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_RX_DATA_CLKOUT_EN_MASK) >> 3)
#define GLP_CTL0_GLP_RX_DATA_CLKOUT_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 3, GLP_CTL0_GLP_RX_DATA_CLKOUT_EN_MASK)
/** RX data interface clock is disabled (default) */
#define GLP_RX_DATA_CLKOUT_EN_GLP_RX_DIS 0x0
/** RX data interface clock is enabled */
#define GLP_RX_DATA_CLKOUT_EN_GLP_RX_EN 0x1

/** GLP Module Enable - enables GLP module */
#define GLP_CTL0_GLP_EN_MASK 0x10
#define GLP_CTL0_GLP_EN_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_EN_MASK) >> 4)
#define GLP_CTL0_GLP_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 4, GLP_CTL0_GLP_EN_MASK)
/** GLP module is disabled (default) */
#define GLP_EN_GLP_DIS 0x0
/** GLP module is enabled */
#define GLP_EN_GLP_EN 0x1

/** GLP PDI Enable - enables GLP PDI-register interface */
#define GLP_CTL0_GLP_PDI_EN_MASK 0x20
#define GLP_CTL0_GLP_PDI_EN_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_PDI_EN_MASK) >> 5)
#define GLP_CTL0_GLP_PDI_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 5, GLP_CTL0_GLP_PDI_EN_MASK)
/** GLP PDI-register interface is disabled (default) */
#define GLP_PDI_EN_GLP_PDI_DIS 0x0
/** GLP PDI-register interface is enabled */
#define GLP_PDI_EN_GLP_PDI_EN 0x1

/** GLP Bist Enable - enables GLP bist mode */
#define GLP_CTL0_GLP_BIST_EN_MASK 0x100
#define GLP_CTL0_GLP_BIST_EN_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_BIST_EN_MASK) >> 8)
#define GLP_CTL0_GLP_BIST_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 8, GLP_CTL0_GLP_BIST_EN_MASK)
/** GLP BIST mode is disabled (default) */
#define GLP_BIST_EN_GLP_BIST_DIS 0x0
/** GLP BIST mode is enabled */
#define GLP_BIST_EN_GLP_BIST_EN 0x1

/** GLP Ready Control Enable - enables overwriting of the GLP READY signal */
#define GLP_CTL0_GLP_RDY_CTL_EN_MASK 0x200
#define GLP_CTL0_GLP_RDY_CTL_EN_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_RDY_CTL_EN_MASK) >> 9)
#define GLP_CTL0_GLP_RDY_CTL_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 9, GLP_CTL0_GLP_RDY_CTL_EN_MASK)
/** Overwrite of the GLP READY signal is disabled (default) */
#define GLP_RDY_CTL_EN_GLP_RDY_DIS 0x0
/** Overwrite of the GLP READY signal is enabled */
#define GLP_RDY_CTL_EN_GLP_RDY_EN 0x1

/** GLP Ready Value - controls the GLP READY signal directly */
#define GLP_CTL0_GLP_RDY_VALUE_MASK 0x400
#define GLP_CTL0_GLP_RDY_VALUE_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_RDY_VALUE_MASK) >> 10)
#define GLP_CTL0_GLP_RDY_VALUE_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 10, GLP_CTL0_GLP_RDY_VALUE_MASK)
/** Switch GLP READY off when enable active (default) */
#define GLP_RDY_VALUE_GLP_RDY_OFF 0x0
/** Switch GLP READY on when enable active */
#define GLP_RDY_VALUE_GLP_RDY_ON 0x1

/** GLP Bypass Clock Selection - selects GLP Bypass Clock */
#define GLP_CTL0_GLP_BYPCLK_SEL_MASK 0x800
#define GLP_CTL0_GLP_BYPCLK_SEL_AFE_GET ((VR9_AfeRead(GLP_CTL0) & GLP_CTL0_GLP_BYPCLK_SEL_MASK) >> 11)
#define GLP_CTL0_GLP_BYPCLK_SEL_AFE_SET(val) VR9_AfeWrite(GLP_CTL0, (val) << 11, GLP_CTL0_GLP_BYPCLK_SEL_MASK)
/** GLP bypass clock is disabled (default) */
#define GLP_BYPCLK_SEL_GLP_BYP_DIS 0x0
/** GLP bypass clock is enabled */
#define GLP_BYPCLK_SEL_GLP_BYP_EN 0x1


/** Global GLP control Register 1 - Global GLP control Register 1 */
#define GLP_CTL1 (VINAX_AFE_DIG_CH0_BASE + 0x7)
#define GLP_CTL1_AFE_GET VR9_AfeRead(GLP_CTL1)
#define GLP_CTL1_AFE_SET(val) VR9_AfeWrite(GLP_CTL1, (val), 0xFFFF)

/** GLP TX1 Data Control - controls GLP TX1 Data */
#define GLP_CTL1_GLP_TX1_DATA_CTL_MASK 0x7
#define GLP_CTL1_GLP_TX1_DATA_CTL_AFE_GET ((VR9_AfeRead(GLP_CTL1) & GLP_CTL1_GLP_TX1_DATA_CTL_MASK) >> 0)
#define GLP_CTL1_GLP_TX1_DATA_CTL_AFE_SET(val) VR9_AfeWrite(GLP_CTL1, (val) << 0, GLP_CTL1_GLP_TX1_DATA_CTL_MASK)
/** minimum value (default) */
#define GLP_TX1_DATA_CTL_TX1_DATA_MIN 0x0
/** maximum value */
#define GLP_TX1_DATA_CTL_TX1_DATA_MAX 0x7

/** GLP TX2 Data Control - controls GLP TX2 Data */
#define GLP_CTL1_GLP_TX2_DATA_CTL_MASK 0x70
#define GLP_CTL1_GLP_TX2_DATA_CTL_AFE_GET ((VR9_AfeRead(GLP_CTL1) & GLP_CTL1_GLP_TX2_DATA_CTL_MASK) >> 4)
#define GLP_CTL1_GLP_TX2_DATA_CTL_AFE_SET(val) VR9_AfeWrite(GLP_CTL1, (val) << 4, GLP_CTL1_GLP_TX2_DATA_CTL_MASK)
/** minimum value (default) */
#define GLP_TX2_DATA_CTL_TX2_DATA_MIN 0x0
/** maximum value */
#define GLP_TX2_DATA_CTL_TX2_DATA_MAX 0x7

/** GLP RX Data Control - controls GLP RX Data */
#define GLP_CTL1_GLP_RX_DATA_CTL_MASK 0x700
#define GLP_CTL1_GLP_RX_DATA_CTL_AFE_GET ((VR9_AfeRead(GLP_CTL1) & GLP_CTL1_GLP_RX_DATA_CTL_MASK) >> 8)
#define GLP_CTL1_GLP_RX_DATA_CTL_AFE_SET(val) VR9_AfeWrite(GLP_CTL1, (val) << 8, GLP_CTL1_GLP_RX_DATA_CTL_MASK)
/** minimum value (default) */
#define GLP_RX_DATA_CTL_RX_DATA_MIN 0x0
/** maximum value */
#define GLP_RX_DATA_CTL_RX_DATA_MAX 0x7


/** Global GLP control Register 2 - Global GLP control Register 2 */
#define GLP_CTL2 (VINAX_AFE_DIG_CH0_BASE + 0x8)
#define GLP_CTL2_AFE_GET VR9_AfeRead(GLP_CTL2)
#define GLP_CTL2_AFE_SET(val) VR9_AfeWrite(GLP_CTL2, (val), 0xFFFF)

/** GLP TX1 IBC Control - controls GLP TX1 IBC */
#define GLP_CTL2_GLP_TX1_IBC_CTL_MASK 0x7
#define GLP_CTL2_GLP_TX1_IBC_CTL_AFE_GET ((VR9_AfeRead(GLP_CTL2) & GLP_CTL2_GLP_TX1_IBC_CTL_MASK) >> 0)
#define GLP_CTL2_GLP_TX1_IBC_CTL_AFE_SET(val) VR9_AfeWrite(GLP_CTL2, (val) << 0, GLP_CTL2_GLP_TX1_IBC_CTL_MASK)
/** Low level (default) */
#define GLP_TX1_IBC_CTL_TX1_IBC_LO 0x0
/** Parity of tx1 data(15:13) */
#define GLP_TX1_IBC_CTL_TX1_PAR15_13 0x1
/** Inverted parity of tx1 data(15:13) */
#define GLP_TX1_IBC_CTL_TX1_PAR15_13_INV 0x2
/** Low level (reserved) */
#define GLP_TX1_IBC_CTL_TX1_RES3 0x3
/** Low level (reserved) */
#define GLP_TX1_IBC_CTL_TX1_RES4 0x4
/** Low level (reserved) */
#define GLP_TX1_IBC_CTL_TX1_RES5 0x5
/** Low level (reserved) */
#define GLP_TX1_IBC_CTL_TX1_RES6 0x6
/** Low level (reserved) */
#define GLP_TX1_IBC_CTL_TX1_RES7 0x7

/** GLP TX2 IBC Control - controls GLP TX2 IBC */
#define GLP_CTL2_GLP_TX2_IBC_CTL_MASK 0x70
#define GLP_CTL2_GLP_TX2_IBC_CTL_AFE_GET ((VR9_AfeRead(GLP_CTL2) & GLP_CTL2_GLP_TX2_IBC_CTL_MASK) >> 4)
#define GLP_CTL2_GLP_TX2_IBC_CTL_AFE_SET(val) VR9_AfeWrite(GLP_CTL2, (val) << 4, GLP_CTL2_GLP_TX2_IBC_CTL_MASK)
/** Low level (default) */
#define GLP_TX2_IBC_CTL_TX2_IBC_LO 0x0
/** Parity of tx2 data(15:13) */
#define GLP_TX2_IBC_CTL_TX2_PAR15_13 0x1
/** Inverted parity of tx2 data(15:13) */
#define GLP_TX2_IBC_CTL_TX2_PAR15_13_INV 0x2
/** Low level (reserved) */
#define GLP_TX2_IBC_CTL_TX2_RES3 0x3
/** Low level (reserved) */
#define GLP_TX2_IBC_CTL_TX2_RES4 0x4
/** Low level (reserved) */
#define GLP_TX2_IBC_CTL_TX2_RES5 0x5
/** Low level (reserved) */
#define GLP_TX2_IBC_CTL_TX2_RES6 0x6
/** Low level (reserved) */
#define GLP_TX2_IBC_CTL_TX2_RES7 0x7

/** GLP RX IBC Control - controls GLP RX IBC */
#define GLP_CTL2_GLP_RX_IBC_CTL_MASK 0x700
#define GLP_CTL2_GLP_RX_IBC_CTL_AFE_GET ((VR9_AfeRead(GLP_CTL2) & GLP_CTL2_GLP_RX_IBC_CTL_MASK) >> 8)
#define GLP_CTL2_GLP_RX_IBC_CTL_AFE_SET(val) VR9_AfeWrite(GLP_CTL2, (val) << 8, GLP_CTL2_GLP_RX_IBC_CTL_MASK)
/** Data selected via GLP_RX_IBC_SSEL(3:0) (default) */
#define GLP_RX_IBC_CTL_INTR_LOOP 0x0
/** Low level (reserved) */
#define GLP_RX_IBC_CTL_RX_IBC_LO 0x1
/** Parity of rx data(15:13) */
#define GLP_RX_IBC_CTL_RX_PAR15_13 0x2
/** Inverted parity of rx data(15:13) */
#define GLP_RX_IBC_CTL_RX_PAR15_13_INV 0x3
/** Low level (reserved) */
#define GLP_RX_IBC_CTL_RX_RES4 0x4
/** Low level (reserved) */
#define GLP_RX_IBC_CTL_RX_RES5 0x5
/** Low level (reserved) */
#define GLP_RX_IBC_CTL_RX_RES6 0x6
/** Low level (reserved) */
#define GLP_RX_IBC_CTL_RX_RES7 0x7

/** GLP RX IBC Source Selection - selects GLP RX IBC source */
#define GLP_CTL2_GLP_RX_IBC_SSEL_MASK 0xf000
#define GLP_CTL2_GLP_RX_IBC_SSEL_AFE_GET ((VR9_AfeRead(GLP_CTL2) & GLP_CTL2_GLP_RX_IBC_SSEL_MASK) >> 12)
#define GLP_CTL2_GLP_RX_IBC_SSEL_AFE_SET(val) VR9_AfeWrite(GLP_CTL2, (val) << 12, GLP_CTL2_GLP_RX_IBC_SSEL_MASK)
/** Low level (default) */
#define GLP_RX_IBC_SSEL_NO_INTR 0x0
/** Interrupt : ADC overload */
#define GLP_RX_IBC_SSEL_INTR_ADC_OVL 0x1
/** Interrupt : RX path overload */
#define GLP_RX_IBC_SSEL_INTR_RX_PATH_OVL 0x2
/** Interrupt : TX path overload */
#define GLP_RX_IBC_SSEL_INTR_TX_PATH_OVL 0x3
/** Interrupt : EC path overload */
#define GLP_RX_IBC_SSEL_INTR_EC_PATH_OVL 0x4
/** Interrupt : RX event counter overload */
#define GLP_RX_IBC_SSEL_INTR_RX_EVCNT_OVL 0x5
/** Interrupt : TX event counter overload */
#define GLP_RX_IBC_SSEL_INTR_TX_EVCNT_OVL 0x6
/** Interrupt : EC event counter overload */
#define GLP_RX_IBC_SSEL_INTR_EC_EVCNT_OVL 0x7
/** Interrupt : RX||TX||EC overload */
#define GLP_RX_IBC_SSEL_INTR_ALL_PATH_OVL 0x8
/** Interrupt : RX||TX||EC event counter overload */
#define GLP_RX_IBC_SSEL_INTR_ALL_EVCNT_OVL 0x9
/** Interrupt : (RX||TX||EC overloadr)||( RX||TX||EC event counter overload) */
#define GLP_RX_IBC_SSEL_INTR_ALL_OVL 0xa
/** GLP READY status */
#define GLP_RX_IBC_SSEL_GLP_READY 0xb
/** High level (reserved) */
#define GLP_RX_IBC_SSEL_RES_FIX_HI 0xc
/** TX1 inband channel loop back */
#define GLP_RX_IBC_SSEL_TX1_IBC_LOOPBACK 0xd
/** TX2 inband channel loop back */
#define GLP_RX_IBC_SSEL_TX2_IBC_LOOPBACK 0xe
/** RX data clock/4 (reserved) */
#define GLP_RX_IBC_SSEL_RES_CLK 0xf


/** GLP Status Register - Global GLP Status Register */
#define GLP_STAT (VINAX_AFE_DIG_CH0_BASE + 0x9)
#define GLP_STAT_AFE_GET VR9_AfeRead(GLP_STAT)
#define GLP_STAT_AFE_SET(val) VR9_AfeWrite(GLP_STAT, (val), 0xFFFF)

/** GLP Ready Sticky for Low-Phase - captures the falling edge on the GLP ready signal */
#define GLP_STAT_GLP_READY_STICKY_0_MASK 0x1
#define GLP_STAT_GLP_READY_STICKY_0_AFE_GET ((VR9_AfeRead(GLP_STAT) & GLP_STAT_GLP_READY_STICKY_0_MASK) >> 0)
#define GLP_STAT_GLP_READY_STICKY_0_AFE_SET(val) VR9_AfeWrite(GLP_STAT, (val) << 0, GLP_STAT_GLP_READY_STICKY_0_MASK)
/** No falling edge detected since last read access (default) */
#define GLP_READY_STICKY_0_GLP_STAT_NO_SYNC_LOSS 0x0
/** Falling edge detected and stored since last read access */
#define GLP_READY_STICKY_0_GLP_STAT_SYNC_LOSS 0x1

/** GLP Ready Sticky for High-Phase - captures the rising edge on the GLP ready signal */
#define GLP_STAT_GLP_READY_STICKY_1_MASK 0x2
#define GLP_STAT_GLP_READY_STICKY_1_AFE_GET ((VR9_AfeRead(GLP_STAT) & GLP_STAT_GLP_READY_STICKY_1_MASK) >> 1)
#define GLP_STAT_GLP_READY_STICKY_1_AFE_SET(val) VR9_AfeWrite(GLP_STAT, (val) << 1, GLP_STAT_GLP_READY_STICKY_1_MASK)
/** No rising edge detected since last read access (default) */
#define GLP_READY_STICKY_1_GLP_STAT_NO_SYNC 0x0
/** Rising edge detected and stored since last read access */
#define GLP_READY_STICKY_1_GLP_STAT_SYNC 0x1

/** GLP Ready - monitors the generic GLP ready signal during read access */
#define GLP_STAT_GLP_READY_MASK 0x4
#define GLP_STAT_GLP_READY_AFE_GET ((VR9_AfeRead(GLP_STAT) & GLP_STAT_GLP_READY_MASK) >> 2)
#define GLP_STAT_GLP_READY_AFE_SET(val) VR9_AfeWrite(GLP_STAT, (val) << 2, GLP_STAT_GLP_READY_MASK)
/** GLP module is in non-synchronized state during read access (default) */
#define GLP_READY_GLP_STAT_NOT_READY 0x0
/** GLP module is in synchronized state during read access */
#define GLP_READY_GLP_STAT_READY 0x1

/** GLP bist failure - reports GLP bist failure */
#define GLP_STAT_GLP_BIST_FAIL_MASK 0x40
#define GLP_STAT_GLP_BIST_FAIL_AFE_GET ((VR9_AfeRead(GLP_STAT) & GLP_STAT_GLP_BIST_FAIL_MASK) >> 6)
#define GLP_STAT_GLP_BIST_FAIL_AFE_SET(val) VR9_AfeWrite(GLP_STAT, (val) << 6, GLP_STAT_GLP_BIST_FAIL_MASK)
/** GLP bist has finished with no error (default) */
#define GLP_BIST_FAIL_GLP_STAT_BIST_PASS 0x0
/** GLP bist has finished with error */
#define GLP_BIST_FAIL_GLP_STAT_BIST_FAIL 0x1

/** GLP bist done - reports GLP bist done */
#define GLP_STAT_GLP_BIST_DONE_MASK 0x80
#define GLP_STAT_GLP_BIST_DONE_AFE_GET ((VR9_AfeRead(GLP_STAT) & GLP_STAT_GLP_BIST_DONE_MASK) >> 7)
#define GLP_STAT_GLP_BIST_DONE_AFE_SET(val) VR9_AfeWrite(GLP_STAT, (val) << 7, GLP_STAT_GLP_BIST_DONE_MASK)
/** GLP bist has not finished (default) */
#define GLP_BIST_DONE_GLP_STAT_BIST_NOT_DONE 0x0
/** GLP bist has finished */
#define GLP_BIST_DONE_GLP_STAT_BIST_DONE 0x1


/** Test Pattern Generation Control Register - Test Pattern Generation Control Register */
#define TPG_CTL_0 (VINAX_AFE_DIG_CH0_BASE + 0x10)
#define TPG_CTL_0_AFE_GET VR9_AfeRead(TPG_CTL_0)
#define TPG_CTL_0_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val), 0xFFFF)

/** Test Pattern Generation Enable - enables test pattern generation */
#define TPG_CTL_0_TPG_EN_MASK 0x1
#define TPG_CTL_0_TPG_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_0) & TPG_CTL_0_TPG_EN_MASK) >> 0)
#define TPG_CTL_0_TPG_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val) << 0, TPG_CTL_0_TPG_EN_MASK)
/** TPG is disabled (default) */
#define TPG_EN_TPG_OFF 0x0
/** TPG is enabled */
#define TPG_EN_TPG_ON 0x1

/** Test Pattern Generation Init - initializes test pattern generation */
#define TPG_CTL_0_TPG_INIT_MASK 0x2
#define TPG_CTL_0_TPG_INIT_AFE_GET ((VR9_AfeRead(TPG_CTL_0) & TPG_CTL_0_TPG_INIT_MASK) >> 1)
#define TPG_CTL_0_TPG_INIT_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val) << 1, TPG_CTL_0_TPG_INIT_MASK)
/** TPG initialization is disabled (default) */
#define TPG_INIT_TPG_INIT_OFF 0x0
/** TPG initialization is enabled */
#define TPG_INIT_TPG_INIT_ON 0x1

/** Test Pattern Generation Auto Clear Enable - enables auto clear for test pattern generation */
#define TPG_CTL_0_TPG_AUTOCLR_EN_MASK 0x4
#define TPG_CTL_0_TPG_AUTOCLR_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_0) & TPG_CTL_0_TPG_AUTOCLR_EN_MASK) >> 2)
#define TPG_CTL_0_TPG_AUTOCLR_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val) << 2, TPG_CTL_0_TPG_AUTOCLR_EN_MASK)
/** TPG auto clear function is disabled */
#define TPG_AUTOCLR_EN_TPG_ACLR_OFF 0x0
/** TPG auto clear function is enabled (default) */
#define TPG_AUTOCLR_EN_TPG_ACLR_ON 0x1

/** Test Pattern Generation clock selection - selects test pattern generation clock */
#define TPG_CTL_0_TPG_CLK_SEL_MASK 0x70
#define TPG_CTL_0_TPG_CLK_SEL_AFE_GET ((VR9_AfeRead(TPG_CTL_0) & TPG_CTL_0_TPG_CLK_SEL_MASK) >> 4)
#define TPG_CTL_0_TPG_CLK_SEL_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val) << 4, TPG_CTL_0_TPG_CLK_SEL_MASK)
/** Data clock selected (144MHz) (default) */
#define TPG_CLK_SEL_TPG_CLK_D0 0x0
/** Data clock selected (144MHz) */
#define TPG_CLK_SEL_TPG_CLK_D1 0x1
/** Data clock/2 selected (72MHz) */
#define TPG_CLK_SEL_TPG_CLK_D2 0x2
/** Data clock/4 selected (36MHz) */
#define TPG_CLK_SEL_TPG_CLK_D4 0x3
/** Data clock/8 selected (18MHz) */
#define TPG_CLK_SEL_TPG_CLK_D8 0x4
/** Data clock/16 selected (9MHz) */
#define TPG_CLK_SEL_TPG_CLK_D16 0x5
/** Data clock/32 selected (4.5MHz) */
#define TPG_CLK_SEL_TPG_CLK_D32 0x6
/** Data clock/64 selected (2.25MHz) */
#define TPG_CLK_SEL_TPG_CLK_D64 0x7

/** Test Pattern Generation counter enable - enables test pattern generation counter */
#define TPG_CTL_0_TPG_CNT_EN_MASK 0x100
#define TPG_CTL_0_TPG_CNT_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_0) & TPG_CTL_0_TPG_CNT_EN_MASK) >> 8)
#define TPG_CTL_0_TPG_CNT_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val) << 8, TPG_CTL_0_TPG_CNT_EN_MASK)
/** disabled (default) */
#define TPG_CNT_EN_TPG_CNT_DIS 0x0
/** enabled */
#define TPG_CNT_EN_TPG_CNT_EN 0x1

/** Test Pattern Generation Selection - connects test pattern generation to data path */
#define TPG_CTL_0_TPG_SEL_MASK 0x200
#define TPG_CTL_0_TPG_SEL_AFE_GET ((VR9_AfeRead(TPG_CTL_0) & TPG_CTL_0_TPG_SEL_MASK) >> 9)
#define TPG_CTL_0_TPG_SEL_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val) << 9, TPG_CTL_0_TPG_SEL_MASK)
/** TPG is disconnected from the data path (default) */
#define TPG_SEL_TPG_DISCON 0x0
/** TPG is connected to the data path */
#define TPG_SEL_TPG_CON 0x1

/** Test Pattern Generation Mode - selects the test pattern generation mode */
#define TPG_CTL_0_TPG_MODE_MASK 0x7000
#define TPG_CTL_0_TPG_MODE_AFE_GET ((VR9_AfeRead(TPG_CTL_0) & TPG_CTL_0_TPG_MODE_MASK) >> 12)
#define TPG_CTL_0_TPG_MODE_AFE_SET(val) VR9_AfeWrite(TPG_CTL_0, (val) << 12, TPG_CTL_0_TPG_MODE_MASK)
/** All zeros (default) */
#define TPG_MODE_TPG_FIX_LO 0x0
/** Step function */
#define TPG_MODE_TPG_STEP 0x1
/** Single pulse function */
#define TPG_MODE_TPG_SINGLE_PULSE 0x2
/** 16-bit LFSR */
#define TPG_MODE_TPG_LFSR 0x3
/** Single bit cyclic shift */
#define TPG_MODE_TPG_SHIFT_ONE 0x4
/** Toggeling data */
#define TPG_MODE_TPG_TOGGLE 0x5
/** All zeros (reserved) */
#define TPG_MODE_TPG_RES6 0x6
/** All zeros (reserved) */
#define TPG_MODE_TPG_RES7 0x7


/** Test Pattern Generation Control Register - Test Pattern Generation Control Register */
#define TPG_CTL_1 (VINAX_AFE_DIG_CH0_BASE + 0x11)
#define TPG_CTL_1_AFE_GET VR9_AfeRead(TPG_CTL_1)
#define TPG_CTL_1_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val), 0xFFFF)

/** Test Pattern Generation Enable - enables test pattern generation */
#define TPG_CTL_1_TPG_EN_MASK 0x1
#define TPG_CTL_1_TPG_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_1) & TPG_CTL_1_TPG_EN_MASK) >> 0)
#define TPG_CTL_1_TPG_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val) << 0, TPG_CTL_1_TPG_EN_MASK)
/** TPG is disabled (default) */
#define TPG_EN_TPG_OFF 0x0
/** TPG is enabled */
#define TPG_EN_TPG_ON 0x1

/** Test Pattern Generation Init - initializes test pattern generation */
#define TPG_CTL_1_TPG_INIT_MASK 0x2
#define TPG_CTL_1_TPG_INIT_AFE_GET ((VR9_AfeRead(TPG_CTL_1) & TPG_CTL_1_TPG_INIT_MASK) >> 1)
#define TPG_CTL_1_TPG_INIT_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val) << 1, TPG_CTL_1_TPG_INIT_MASK)
/** TPG initialization is disabled (default) */
#define TPG_INIT_TPG_INIT_OFF 0x0
/** TPG initialization is enabled */
#define TPG_INIT_TPG_INIT_ON 0x1

/** Test Pattern Generation Auto Clear Enable - enables auto clear for test pattern generation */
#define TPG_CTL_1_TPG_AUTOCLR_EN_MASK 0x4
#define TPG_CTL_1_TPG_AUTOCLR_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_1) & TPG_CTL_1_TPG_AUTOCLR_EN_MASK) >> 2)
#define TPG_CTL_1_TPG_AUTOCLR_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val) << 2, TPG_CTL_1_TPG_AUTOCLR_EN_MASK)
/** TPG auto clear function is disabled */
#define TPG_AUTOCLR_EN_TPG_ACLR_OFF 0x0
/** TPG auto clear function is enabled (default) */
#define TPG_AUTOCLR_EN_TPG_ACLR_ON 0x1

/** Test Pattern Generation clock selection - selects test pattern generation clock */
#define TPG_CTL_1_TPG_CLK_SEL_MASK 0x70
#define TPG_CTL_1_TPG_CLK_SEL_AFE_GET ((VR9_AfeRead(TPG_CTL_1) & TPG_CTL_1_TPG_CLK_SEL_MASK) >> 4)
#define TPG_CTL_1_TPG_CLK_SEL_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val) << 4, TPG_CTL_1_TPG_CLK_SEL_MASK)
/** Data clock selected (144MHz) (default) */
#define TPG_CLK_SEL_TPG_CLK_D0 0x0
/** Data clock selected (144MHz) */
#define TPG_CLK_SEL_TPG_CLK_D1 0x1
/** Data clock/2 selected (72MHz) */
#define TPG_CLK_SEL_TPG_CLK_D2 0x2
/** Data clock/4 selected (36MHz) */
#define TPG_CLK_SEL_TPG_CLK_D4 0x3
/** Data clock/8 selected (18MHz) */
#define TPG_CLK_SEL_TPG_CLK_D8 0x4
/** Data clock/16 selected (9MHz) */
#define TPG_CLK_SEL_TPG_CLK_D16 0x5
/** Data clock/32 selected (4.5MHz) */
#define TPG_CLK_SEL_TPG_CLK_D32 0x6
/** Data clock/64 selected (2.25MHz) */
#define TPG_CLK_SEL_TPG_CLK_D64 0x7

/** Test Pattern Generation counter enable - enables test pattern generation counter */
#define TPG_CTL_1_TPG_CNT_EN_MASK 0x100
#define TPG_CTL_1_TPG_CNT_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_1) & TPG_CTL_1_TPG_CNT_EN_MASK) >> 8)
#define TPG_CTL_1_TPG_CNT_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val) << 8, TPG_CTL_1_TPG_CNT_EN_MASK)
/** disabled (default) */
#define TPG_CNT_EN_TPG_CNT_DIS 0x0
/** enabled */
#define TPG_CNT_EN_TPG_CNT_EN 0x1

/** Test Pattern Generation Selection - connects test pattern generation to data path */
#define TPG_CTL_1_TPG_SEL_MASK 0x200
#define TPG_CTL_1_TPG_SEL_AFE_GET ((VR9_AfeRead(TPG_CTL_1) & TPG_CTL_1_TPG_SEL_MASK) >> 9)
#define TPG_CTL_1_TPG_SEL_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val) << 9, TPG_CTL_1_TPG_SEL_MASK)
/** TPG is disconnected from the data path (default) */
#define TPG_SEL_TPG_DISCON 0x0
/** TPG is connected to the data path */
#define TPG_SEL_TPG_CON 0x1

/** Test Pattern Generation Mode - selects the test pattern generation mode */
#define TPG_CTL_1_TPG_MODE_MASK 0x7000
#define TPG_CTL_1_TPG_MODE_AFE_GET ((VR9_AfeRead(TPG_CTL_1) & TPG_CTL_1_TPG_MODE_MASK) >> 12)
#define TPG_CTL_1_TPG_MODE_AFE_SET(val) VR9_AfeWrite(TPG_CTL_1, (val) << 12, TPG_CTL_1_TPG_MODE_MASK)
/** All zeros (default) */
#define TPG_MODE_TPG_FIX_LO 0x0
/** Step function */
#define TPG_MODE_TPG_STEP 0x1
/** Single pulse function */
#define TPG_MODE_TPG_SINGLE_PULSE 0x2
/** 16-bit LFSR */
#define TPG_MODE_TPG_LFSR 0x3
/** Single bit cyclic shift */
#define TPG_MODE_TPG_SHIFT_ONE 0x4
/** Toggeling data */
#define TPG_MODE_TPG_TOGGLE 0x5
/** All zeros (reserved) */
#define TPG_MODE_TPG_RES6 0x6
/** All zeros (reserved) */
#define TPG_MODE_TPG_RES7 0x7


/** Test Pattern Generation Control Register - Test Pattern Generation Control Register */
#define TPG_CTL_2 (VINAX_AFE_DIG_CH0_BASE + 0x12)
#define TPG_CTL_2_AFE_GET VR9_AfeRead(TPG_CTL_2)
#define TPG_CTL_2_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val), 0xFFFF)

/** Test Pattern Generation Enable - enables test pattern generation */
#define TPG_CTL_2_TPG_EN_MASK 0x1
#define TPG_CTL_2_TPG_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_2) & TPG_CTL_2_TPG_EN_MASK) >> 0)
#define TPG_CTL_2_TPG_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val) << 0, TPG_CTL_2_TPG_EN_MASK)
/** TPG is disabled (default) */
#define TPG_EN_TPG_OFF 0x0
/** TPG is enabled */
#define TPG_EN_TPG_ON 0x1

/** Test Pattern Generation Init - initializes test pattern generation */
#define TPG_CTL_2_TPG_INIT_MASK 0x2
#define TPG_CTL_2_TPG_INIT_AFE_GET ((VR9_AfeRead(TPG_CTL_2) & TPG_CTL_2_TPG_INIT_MASK) >> 1)
#define TPG_CTL_2_TPG_INIT_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val) << 1, TPG_CTL_2_TPG_INIT_MASK)
/** TPG initialization is disabled (default) */
#define TPG_INIT_TPG_INIT_OFF 0x0
/** TPG initialization is enabled */
#define TPG_INIT_TPG_INIT_ON 0x1

/** Test Pattern Generation Auto Clear Enable - enables auto clear for test pattern generation */
#define TPG_CTL_2_TPG_AUTOCLR_EN_MASK 0x4
#define TPG_CTL_2_TPG_AUTOCLR_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_2) & TPG_CTL_2_TPG_AUTOCLR_EN_MASK) >> 2)
#define TPG_CTL_2_TPG_AUTOCLR_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val) << 2, TPG_CTL_2_TPG_AUTOCLR_EN_MASK)
/** TPG auto clear function is disabled */
#define TPG_AUTOCLR_EN_TPG_ACLR_OFF 0x0
/** TPG auto clear function is enabled (default) */
#define TPG_AUTOCLR_EN_TPG_ACLR_ON 0x1

/** Test Pattern Generation clock selection - selects test pattern generation clock */
#define TPG_CTL_2_TPG_CLK_SEL_MASK 0x70
#define TPG_CTL_2_TPG_CLK_SEL_AFE_GET ((VR9_AfeRead(TPG_CTL_2) & TPG_CTL_2_TPG_CLK_SEL_MASK) >> 4)
#define TPG_CTL_2_TPG_CLK_SEL_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val) << 4, TPG_CTL_2_TPG_CLK_SEL_MASK)
/** Data clock selected (144MHz) (default) */
#define TPG_CLK_SEL_TPG_CLK_D0 0x0
/** Data clock selected (144MHz) */
#define TPG_CLK_SEL_TPG_CLK_D1 0x1
/** Data clock/2 selected (72MHz) */
#define TPG_CLK_SEL_TPG_CLK_D2 0x2
/** Data clock/4 selected (36MHz) */
#define TPG_CLK_SEL_TPG_CLK_D4 0x3
/** Data clock/8 selected (18MHz) */
#define TPG_CLK_SEL_TPG_CLK_D8 0x4
/** Data clock/16 selected (9MHz) */
#define TPG_CLK_SEL_TPG_CLK_D16 0x5
/** Data clock/32 selected (4.5MHz) */
#define TPG_CLK_SEL_TPG_CLK_D32 0x6
/** Data clock/64 selected (2.25MHz) */
#define TPG_CLK_SEL_TPG_CLK_D64 0x7

/** Test Pattern Generation counter enable - enables test pattern generation counter */
#define TPG_CTL_2_TPG_CNT_EN_MASK 0x100
#define TPG_CTL_2_TPG_CNT_EN_AFE_GET ((VR9_AfeRead(TPG_CTL_2) & TPG_CTL_2_TPG_CNT_EN_MASK) >> 8)
#define TPG_CTL_2_TPG_CNT_EN_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val) << 8, TPG_CTL_2_TPG_CNT_EN_MASK)
/** disabled (default) */
#define TPG_CNT_EN_TPG_CNT_DIS 0x0
/** enabled */
#define TPG_CNT_EN_TPG_CNT_EN 0x1

/** Test Pattern Generation Selection - connects test pattern generation to data path */
#define TPG_CTL_2_TPG_SEL_MASK 0x200
#define TPG_CTL_2_TPG_SEL_AFE_GET ((VR9_AfeRead(TPG_CTL_2) & TPG_CTL_2_TPG_SEL_MASK) >> 9)
#define TPG_CTL_2_TPG_SEL_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val) << 9, TPG_CTL_2_TPG_SEL_MASK)
/** TPG is disconnected from the data path (default) */
#define TPG_SEL_TPG_DISCON 0x0
/** TPG is connected to the data path */
#define TPG_SEL_TPG_CON 0x1

/** Test Pattern Generation Mode - selects the test pattern generation mode */
#define TPG_CTL_2_TPG_MODE_MASK 0x7000
#define TPG_CTL_2_TPG_MODE_AFE_GET ((VR9_AfeRead(TPG_CTL_2) & TPG_CTL_2_TPG_MODE_MASK) >> 12)
#define TPG_CTL_2_TPG_MODE_AFE_SET(val) VR9_AfeWrite(TPG_CTL_2, (val) << 12, TPG_CTL_2_TPG_MODE_MASK)
/** All zeros (default) */
#define TPG_MODE_TPG_FIX_LO 0x0
/** Step function */
#define TPG_MODE_TPG_STEP 0x1
/** Single pulse function */
#define TPG_MODE_TPG_SINGLE_PULSE 0x2
/** 16-bit LFSR */
#define TPG_MODE_TPG_LFSR 0x3
/** Single bit cyclic shift */
#define TPG_MODE_TPG_SHIFT_ONE 0x4
/** Toggeling data */
#define TPG_MODE_TPG_TOGGLE 0x5
/** All zeros (reserved) */
#define TPG_MODE_TPG_RES6 0x6
/** All zeros (reserved) */
#define TPG_MODE_TPG_RES7 0x7


/** Test Pattern Generation Data Register - Test Pattern Generation Data Register */
#define TPG_DAT_0 (VINAX_AFE_DIG_CH0_BASE + 0x14)
#define TPG_DAT_0_AFE_GET VR9_AfeRead(TPG_DAT_0)
#define TPG_DAT_0_AFE_SET(val) VR9_AfeWrite(TPG_DAT_0, (val), 0xFFFF)

/** Test Pattern Generation Data - Test Pattern Generation Data */
#define TPG_DAT_0_TPG_DAT_MASK 0xffff
#define TPG_DAT_0_TPG_DAT_AFE_GET ((VR9_AfeRead(TPG_DAT_0) & TPG_DAT_0_TPG_DAT_MASK) >> 0)
#define TPG_DAT_0_TPG_DAT_AFE_SET(val) VR9_AfeWrite(TPG_DAT_0, (val) << 0, TPG_DAT_0_TPG_DAT_MASK)
/** minimum start value for test pattern generator (default) */
#define TPG_DAT_TPG_DATA_MIN 0x0
/** maximum start value for test pattern generator */
#define TPG_DAT_TPG_DATA_MAX 0xffff


/** Test Pattern Generation Data Register - Test Pattern Generation Data Register */
#define TPG_DAT_1 (VINAX_AFE_DIG_CH0_BASE + 0x15)
#define TPG_DAT_1_AFE_GET VR9_AfeRead(TPG_DAT_1)
#define TPG_DAT_1_AFE_SET(val) VR9_AfeWrite(TPG_DAT_1, (val), 0xFFFF)

/** Test Pattern Generation Data - Test Pattern Generation Data */
#define TPG_DAT_1_TPG_DAT_MASK 0xffff
#define TPG_DAT_1_TPG_DAT_AFE_GET ((VR9_AfeRead(TPG_DAT_1) & TPG_DAT_1_TPG_DAT_MASK) >> 0)
#define TPG_DAT_1_TPG_DAT_AFE_SET(val) VR9_AfeWrite(TPG_DAT_1, (val) << 0, TPG_DAT_1_TPG_DAT_MASK)
/** minimum start value for test pattern generator (default) */
#define TPG_DAT_TPG_DATA_MIN 0x0
/** maximum start value for test pattern generator */
#define TPG_DAT_TPG_DATA_MAX 0xffff


/** Test Pattern Generation Data Register - Test Pattern Generation Data Register */
#define TPG_DAT_2 (VINAX_AFE_DIG_CH0_BASE + 0x16)
#define TPG_DAT_2_AFE_GET VR9_AfeRead(TPG_DAT_2)
#define TPG_DAT_2_AFE_SET(val) VR9_AfeWrite(TPG_DAT_2, (val), 0xFFFF)

/** Test Pattern Generation Data - Test Pattern Generation Data */
#define TPG_DAT_2_TPG_DAT_MASK 0xffff
#define TPG_DAT_2_TPG_DAT_AFE_GET ((VR9_AfeRead(TPG_DAT_2) & TPG_DAT_2_TPG_DAT_MASK) >> 0)
#define TPG_DAT_2_TPG_DAT_AFE_SET(val) VR9_AfeWrite(TPG_DAT_2, (val) << 0, TPG_DAT_2_TPG_DAT_MASK)
/** minimum start value for test pattern generator (default) */
#define TPG_DAT_TPG_DATA_MIN 0x0
/** maximum start value for test pattern generator */
#define TPG_DAT_TPG_DATA_MAX 0xffff


/** Test Pattern Generation Status Register - Test Pattern Generation Status Register */
#define TPG_STAT_0 (VINAX_AFE_DIG_CH0_BASE + 0x18)
#define TPG_STAT_0_AFE_GET VR9_AfeRead(TPG_STAT_0)
#define TPG_STAT_0_AFE_SET(val) VR9_AfeWrite(TPG_STAT_0, (val), 0xFFFF)

/** Test Pattern Generation Status - Test Pattern Generation Status */
#define TPG_STAT_0_TPG_STAT_MASK 0xffff
#define TPG_STAT_0_TPG_STAT_AFE_GET ((VR9_AfeRead(TPG_STAT_0) & TPG_STAT_0_TPG_STAT_MASK) >> 0)
#define TPG_STAT_0_TPG_STAT_AFE_SET(val) VR9_AfeWrite(TPG_STAT_0, (val) << 0, TPG_STAT_0_TPG_STAT_MASK)
/** minimum value of test pattern generator */
#define TPG_STAT_TPG_STAT_MIN 0x0
/** maximum value of test pattern generator */
#define TPG_STAT_TPG_STAT_MAX 0xffff


/** Test Pattern Generation Status Register - Test Pattern Generation Status Register */
#define TPG_STAT_1 (VINAX_AFE_DIG_CH0_BASE + 0x19)
#define TPG_STAT_1_AFE_GET VR9_AfeRead(TPG_STAT_1)
#define TPG_STAT_1_AFE_SET(val) VR9_AfeWrite(TPG_STAT_1, (val), 0xFFFF)

/** Test Pattern Generation Status - Test Pattern Generation Status */
#define TPG_STAT_1_TPG_STAT_MASK 0xffff
#define TPG_STAT_1_TPG_STAT_AFE_GET ((VR9_AfeRead(TPG_STAT_1) & TPG_STAT_1_TPG_STAT_MASK) >> 0)
#define TPG_STAT_1_TPG_STAT_AFE_SET(val) VR9_AfeWrite(TPG_STAT_1, (val) << 0, TPG_STAT_1_TPG_STAT_MASK)
/** minimum value of test pattern generator */
#define TPG_STAT_TPG_STAT_MIN 0x0
/** maximum value of test pattern generator */
#define TPG_STAT_TPG_STAT_MAX 0xffff


/** Test Pattern Generation Status Register - Test Pattern Generation Status Register */
#define TPG_STAT_2 (VINAX_AFE_DIG_CH0_BASE + 0x1a)
#define TPG_STAT_2_AFE_GET VR9_AfeRead(TPG_STAT_2)
#define TPG_STAT_2_AFE_SET(val) VR9_AfeWrite(TPG_STAT_2, (val), 0xFFFF)

/** Test Pattern Generation Status - Test Pattern Generation Status */
#define TPG_STAT_2_TPG_STAT_MASK 0xffff
#define TPG_STAT_2_TPG_STAT_AFE_GET ((VR9_AfeRead(TPG_STAT_2) & TPG_STAT_2_TPG_STAT_MASK) >> 0)
#define TPG_STAT_2_TPG_STAT_AFE_SET(val) VR9_AfeWrite(TPG_STAT_2, (val) << 0, TPG_STAT_2_TPG_STAT_MASK)
/** minimum value of test pattern generator */
#define TPG_STAT_TPG_STAT_MIN 0x0
/** maximum value of test pattern generator */
#define TPG_STAT_TPG_STAT_MAX 0xffff


/** Test Data Aquisition Control Register - Test Data Aquisition Control Register */
#define TDA_CTL_0 (VINAX_AFE_DIG_CH0_BASE + 0x20)
#define TDA_CTL_0_AFE_GET VR9_AfeRead(TDA_CTL_0)
#define TDA_CTL_0_AFE_SET(val) VR9_AfeWrite(TDA_CTL_0, (val), 0xFFFF)

/** Test Data Aquisition enable - enables test data aquisition */
#define TDA_CTL_0_TDA_EN_MASK 0x1
#define TDA_CTL_0_TDA_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_0) & TDA_CTL_0_TDA_EN_MASK) >> 0)
#define TDA_CTL_0_TDA_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_0, (val) << 0, TDA_CTL_0_TDA_EN_MASK)
/** TDA is disabled (default) */
#define TDA_EN_TDA_OFF 0x0
/** TDA is enabled */
#define TDA_EN_TDA_ON 0x1

/** Test Data Aquisition init - initializes test data aquisition */
#define TDA_CTL_0_TDA_INIT_MASK 0x2
#define TDA_CTL_0_TDA_INIT_AFE_GET ((VR9_AfeRead(TDA_CTL_0) & TDA_CTL_0_TDA_INIT_MASK) >> 1)
#define TDA_CTL_0_TDA_INIT_AFE_SET(val) VR9_AfeWrite(TDA_CTL_0, (val) << 1, TDA_CTL_0_TDA_INIT_MASK)
/** TDA initialization is disabled (default) */
#define TDA_INIT_TDA_INIT_OFF 0x0
/** TDA initialization is enabled */
#define TDA_INIT_TDA_INIT_ON 0x1

/** Test Data Aquisition auto clear enable - enables auto clear for test data aquisition */
#define TDA_CTL_0_TDA_AUTOCLR_EN_MASK 0x4
#define TDA_CTL_0_TDA_AUTOCLR_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_0) & TDA_CTL_0_TDA_AUTOCLR_EN_MASK) >> 2)
#define TDA_CTL_0_TDA_AUTOCLR_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_0, (val) << 2, TDA_CTL_0_TDA_AUTOCLR_EN_MASK)
/** TDA auto clear function is disabled */
#define TDA_AUTOCLR_EN_TDA_ACLR_OFF 0x0
/** TDA auto clear function is enabled (default) */
#define TDA_AUTOCLR_EN_TDA_ACLR_ON 0x1

/** Test Data Aquisition clock selection - selects test data aquisition clock */
#define TDA_CTL_0_TDA_CLK_SEL_MASK 0x70
#define TDA_CTL_0_TDA_CLK_SEL_AFE_GET ((VR9_AfeRead(TDA_CTL_0) & TDA_CTL_0_TDA_CLK_SEL_MASK) >> 4)
#define TDA_CTL_0_TDA_CLK_SEL_AFE_SET(val) VR9_AfeWrite(TDA_CTL_0, (val) << 4, TDA_CTL_0_TDA_CLK_SEL_MASK)
/** Data clock selected (144MHz) (default) */
#define TDA_CLK_SEL_TDA_CLK_D0 0x0
/** Data clock selected (144MHz) */
#define TDA_CLK_SEL_TDA_CLK_D1 0x1
/** Data clock/2 selected (72MHz) */
#define TDA_CLK_SEL_TDA_CLK_D2 0x2
/** Data clock/4 selected (36MHz) */
#define TDA_CLK_SEL_TDA_CLK_D4 0x3
/** Data clock/8 selected (18MHz) */
#define TDA_CLK_SEL_TDA_CLK_D8 0x4
/** Data clock/16 selected (9MHz) */
#define TDA_CLK_SEL_TDA_CLK_D16 0x5
/** Data clock/32 selected (4.5MHz) */
#define TDA_CLK_SEL_TDA_CLK_D32 0x6
/** Data clock/64 selected (2.25MHz) */
#define TDA_CLK_SEL_TDA_CLK_D64 0x7

/** Test Data Aquisition counter enable - enables test data aquisition counter */
#define TDA_CTL_0_TDA_CNT_EN_MASK 0x100
#define TDA_CTL_0_TDA_CNT_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_0) & TDA_CTL_0_TDA_CNT_EN_MASK) >> 8)
#define TDA_CTL_0_TDA_CNT_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_0, (val) << 8, TDA_CTL_0_TDA_CNT_EN_MASK)
/** disabled (default) */
#define TDA_CNT_EN_TDA_CNT_DIS 0x0
/** enabled */
#define TDA_CNT_EN_TDA_CNT_EN 0x1


/** Test Data Aquisition Control Register - Test Data Aquisition Control Register */
#define TDA_CTL_1 (VINAX_AFE_DIG_CH0_BASE + 0x21)
#define TDA_CTL_1_AFE_GET VR9_AfeRead(TDA_CTL_1)
#define TDA_CTL_1_AFE_SET(val) VR9_AfeWrite(TDA_CTL_1, (val), 0xFFFF)

/** Test Data Aquisition enable - enables test data aquisition */
#define TDA_CTL_1_TDA_EN_MASK 0x1
#define TDA_CTL_1_TDA_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_1) & TDA_CTL_1_TDA_EN_MASK) >> 0)
#define TDA_CTL_1_TDA_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_1, (val) << 0, TDA_CTL_1_TDA_EN_MASK)
/** TDA is disabled (default) */
#define TDA_EN_TDA_OFF 0x0
/** TDA is enabled */
#define TDA_EN_TDA_ON 0x1

/** Test Data Aquisition init - initializes test data aquisition */
#define TDA_CTL_1_TDA_INIT_MASK 0x2
#define TDA_CTL_1_TDA_INIT_AFE_GET ((VR9_AfeRead(TDA_CTL_1) & TDA_CTL_1_TDA_INIT_MASK) >> 1)
#define TDA_CTL_1_TDA_INIT_AFE_SET(val) VR9_AfeWrite(TDA_CTL_1, (val) << 1, TDA_CTL_1_TDA_INIT_MASK)
/** TDA initialization is disabled (default) */
#define TDA_INIT_TDA_INIT_OFF 0x0
/** TDA initialization is enabled */
#define TDA_INIT_TDA_INIT_ON 0x1

/** Test Data Aquisition auto clear enable - enables auto clear for test data aquisition */
#define TDA_CTL_1_TDA_AUTOCLR_EN_MASK 0x4
#define TDA_CTL_1_TDA_AUTOCLR_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_1) & TDA_CTL_1_TDA_AUTOCLR_EN_MASK) >> 2)
#define TDA_CTL_1_TDA_AUTOCLR_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_1, (val) << 2, TDA_CTL_1_TDA_AUTOCLR_EN_MASK)
/** TDA auto clear function is disabled */
#define TDA_AUTOCLR_EN_TDA_ACLR_OFF 0x0
/** TDA auto clear function is enabled (default) */
#define TDA_AUTOCLR_EN_TDA_ACLR_ON 0x1

/** Test Data Aquisition clock selection - selects test data aquisition clock */
#define TDA_CTL_1_TDA_CLK_SEL_MASK 0x70
#define TDA_CTL_1_TDA_CLK_SEL_AFE_GET ((VR9_AfeRead(TDA_CTL_1) & TDA_CTL_1_TDA_CLK_SEL_MASK) >> 4)
#define TDA_CTL_1_TDA_CLK_SEL_AFE_SET(val) VR9_AfeWrite(TDA_CTL_1, (val) << 4, TDA_CTL_1_TDA_CLK_SEL_MASK)
/** Data clock selected (144MHz) (default) */
#define TDA_CLK_SEL_TDA_CLK_D0 0x0
/** Data clock selected (144MHz) */
#define TDA_CLK_SEL_TDA_CLK_D1 0x1
/** Data clock/2 selected (72MHz) */
#define TDA_CLK_SEL_TDA_CLK_D2 0x2
/** Data clock/4 selected (36MHz) */
#define TDA_CLK_SEL_TDA_CLK_D4 0x3
/** Data clock/8 selected (18MHz) */
#define TDA_CLK_SEL_TDA_CLK_D8 0x4
/** Data clock/16 selected (9MHz) */
#define TDA_CLK_SEL_TDA_CLK_D16 0x5
/** Data clock/32 selected (4.5MHz) */
#define TDA_CLK_SEL_TDA_CLK_D32 0x6
/** Data clock/64 selected (2.25MHz) */
#define TDA_CLK_SEL_TDA_CLK_D64 0x7

/** Test Data Aquisition counter enable - enables test data aquisition counter */
#define TDA_CTL_1_TDA_CNT_EN_MASK 0x100
#define TDA_CTL_1_TDA_CNT_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_1) & TDA_CTL_1_TDA_CNT_EN_MASK) >> 8)
#define TDA_CTL_1_TDA_CNT_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_1, (val) << 8, TDA_CTL_1_TDA_CNT_EN_MASK)
/** disabled (default) */
#define TDA_CNT_EN_TDA_CNT_DIS 0x0
/** enabled */
#define TDA_CNT_EN_TDA_CNT_EN 0x1


/** Test Data Aquisition Control Register - Test Data Aquisition Control Register */
#define TDA_CTL_2 (VINAX_AFE_DIG_CH0_BASE + 0x22)
#define TDA_CTL_2_AFE_GET VR9_AfeRead(TDA_CTL_2)
#define TDA_CTL_2_AFE_SET(val) VR9_AfeWrite(TDA_CTL_2, (val), 0xFFFF)

/** Test Data Aquisition enable - enables test data aquisition */
#define TDA_CTL_2_TDA_EN_MASK 0x1
#define TDA_CTL_2_TDA_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_2) & TDA_CTL_2_TDA_EN_MASK) >> 0)
#define TDA_CTL_2_TDA_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_2, (val) << 0, TDA_CTL_2_TDA_EN_MASK)
/** TDA is disabled (default) */
#define TDA_EN_TDA_OFF 0x0
/** TDA is enabled */
#define TDA_EN_TDA_ON 0x1

/** Test Data Aquisition init - initializes test data aquisition */
#define TDA_CTL_2_TDA_INIT_MASK 0x2
#define TDA_CTL_2_TDA_INIT_AFE_GET ((VR9_AfeRead(TDA_CTL_2) & TDA_CTL_2_TDA_INIT_MASK) >> 1)
#define TDA_CTL_2_TDA_INIT_AFE_SET(val) VR9_AfeWrite(TDA_CTL_2, (val) << 1, TDA_CTL_2_TDA_INIT_MASK)
/** TDA initialization is disabled (default) */
#define TDA_INIT_TDA_INIT_OFF 0x0
/** TDA initialization is enabled */
#define TDA_INIT_TDA_INIT_ON 0x1

/** Test Data Aquisition auto clear enable - enables auto clear for test data aquisition */
#define TDA_CTL_2_TDA_AUTOCLR_EN_MASK 0x4
#define TDA_CTL_2_TDA_AUTOCLR_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_2) & TDA_CTL_2_TDA_AUTOCLR_EN_MASK) >> 2)
#define TDA_CTL_2_TDA_AUTOCLR_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_2, (val) << 2, TDA_CTL_2_TDA_AUTOCLR_EN_MASK)
/** TDA auto clear function is disabled */
#define TDA_AUTOCLR_EN_TDA_ACLR_OFF 0x0
/** TDA auto clear function is enabled (default) */
#define TDA_AUTOCLR_EN_TDA_ACLR_ON 0x1

/** Test Data Aquisition clock selection - selects test data aquisition clock */
#define TDA_CTL_2_TDA_CLK_SEL_MASK 0x70
#define TDA_CTL_2_TDA_CLK_SEL_AFE_GET ((VR9_AfeRead(TDA_CTL_2) & TDA_CTL_2_TDA_CLK_SEL_MASK) >> 4)
#define TDA_CTL_2_TDA_CLK_SEL_AFE_SET(val) VR9_AfeWrite(TDA_CTL_2, (val) << 4, TDA_CTL_2_TDA_CLK_SEL_MASK)
/** Data clock selected (144MHz) (default) */
#define TDA_CLK_SEL_TDA_CLK_D0 0x0
/** Data clock selected (144MHz) */
#define TDA_CLK_SEL_TDA_CLK_D1 0x1
/** Data clock/2 selected (72MHz) */
#define TDA_CLK_SEL_TDA_CLK_D2 0x2
/** Data clock/4 selected (36MHz) */
#define TDA_CLK_SEL_TDA_CLK_D4 0x3
/** Data clock/8 selected (18MHz) */
#define TDA_CLK_SEL_TDA_CLK_D8 0x4
/** Data clock/16 selected (9MHz) */
#define TDA_CLK_SEL_TDA_CLK_D16 0x5
/** Data clock/32 selected (4.5MHz) */
#define TDA_CLK_SEL_TDA_CLK_D32 0x6
/** Data clock/64 selected (2.25MHz) */
#define TDA_CLK_SEL_TDA_CLK_D64 0x7

/** Test Data Aquisition counter enable - enables test data aquisition counter */
#define TDA_CTL_2_TDA_CNT_EN_MASK 0x100
#define TDA_CTL_2_TDA_CNT_EN_AFE_GET ((VR9_AfeRead(TDA_CTL_2) & TDA_CTL_2_TDA_CNT_EN_MASK) >> 8)
#define TDA_CTL_2_TDA_CNT_EN_AFE_SET(val) VR9_AfeWrite(TDA_CTL_2, (val) << 8, TDA_CTL_2_TDA_CNT_EN_MASK)
/** disabled (default) */
#define TDA_CNT_EN_TDA_CNT_DIS 0x0
/** enabled */
#define TDA_CNT_EN_TDA_CNT_EN 0x1


/** Test Data Aquisition Data Register - Test Data Aquisition Data Register */
#define TDA_DAT_0 (VINAX_AFE_DIG_CH0_BASE + 0x24)
#define TDA_DAT_0_AFE_GET VR9_AfeRead(TDA_DAT_0)
#define TDA_DAT_0_AFE_SET(val) VR9_AfeWrite(TDA_DAT_0, (val), 0xFFFF)

/** Test Data Aquisition Data - Test Data Aquisition Data */
#define TDA_DAT_0_TDA_DAT_MASK 0xffff
#define TDA_DAT_0_TDA_DAT_AFE_GET ((VR9_AfeRead(TDA_DAT_0) & TDA_DAT_0_TDA_DAT_MASK) >> 0)
#define TDA_DAT_0_TDA_DAT_AFE_SET(val) VR9_AfeWrite(TDA_DAT_0, (val) << 0, TDA_DAT_0_TDA_DAT_MASK)
/** minimum value of test data aquisition */
#define TDA_DAT_TDA_DATA_MIN 0x0
/** maximum value of test data aquisition */
#define TDA_DAT_TDA_DATA_MAX 0xffff


/** Test Data Aquisition Data Register - Test Data Aquisition Data Register */
#define TDA_DAT_1 (VINAX_AFE_DIG_CH0_BASE + 0x25)
#define TDA_DAT_1_AFE_GET VR9_AfeRead(TDA_DAT_1)
#define TDA_DAT_1_AFE_SET(val) VR9_AfeWrite(TDA_DAT_1, (val), 0xFFFF)

/** Test Data Aquisition Data - Test Data Aquisition Data */
#define TDA_DAT_1_TDA_DAT_MASK 0xffff
#define TDA_DAT_1_TDA_DAT_AFE_GET ((VR9_AfeRead(TDA_DAT_1) & TDA_DAT_1_TDA_DAT_MASK) >> 0)
#define TDA_DAT_1_TDA_DAT_AFE_SET(val) VR9_AfeWrite(TDA_DAT_1, (val) << 0, TDA_DAT_1_TDA_DAT_MASK)
/** minimum value of test data aquisition */
#define TDA_DAT_TDA_DATA_MIN 0x0
/** maximum value of test data aquisition */
#define TDA_DAT_TDA_DATA_MAX 0xffff


/** Test Data Aquisition Data Register - Test Data Aquisition Data Register */
#define TDA_DAT_2 (VINAX_AFE_DIG_CH0_BASE + 0x26)
#define TDA_DAT_2_AFE_GET VR9_AfeRead(TDA_DAT_2)
#define TDA_DAT_2_AFE_SET(val) VR9_AfeWrite(TDA_DAT_2, (val), 0xFFFF)

/** Test Data Aquisition Data - Test Data Aquisition Data */
#define TDA_DAT_2_TDA_DAT_MASK 0xffff
#define TDA_DAT_2_TDA_DAT_AFE_GET ((VR9_AfeRead(TDA_DAT_2) & TDA_DAT_2_TDA_DAT_MASK) >> 0)
#define TDA_DAT_2_TDA_DAT_AFE_SET(val) VR9_AfeWrite(TDA_DAT_2, (val) << 0, TDA_DAT_2_TDA_DAT_MASK)
/** minimum value of test data aquisition */
#define TDA_DAT_TDA_DATA_MIN 0x0
/** maximum value of test data aquisition */
#define TDA_DAT_TDA_DATA_MAX 0xffff


/** Test Data Aquisition Status Register - Test Data Aquisition Status Register */
#define TDA_STAT_0 (VINAX_AFE_DIG_CH0_BASE + 0x28)
#define TDA_STAT_0_AFE_GET VR9_AfeRead(TDA_STAT_0)
#define TDA_STAT_0_AFE_SET(val) VR9_AfeWrite(TDA_STAT_0, (val), 0xFFFF)

/** Test Data Aquisition Status - Test Data Aquisition Status */
#define TDA_STAT_0_TDA_STAT_MASK 0xffff
#define TDA_STAT_0_TDA_STAT_AFE_GET ((VR9_AfeRead(TDA_STAT_0) & TDA_STAT_0_TDA_STAT_MASK) >> 0)
#define TDA_STAT_0_TDA_STAT_AFE_SET(val) VR9_AfeWrite(TDA_STAT_0, (val) << 0, TDA_STAT_0_TDA_STAT_MASK)
/** minimum value of test data aquisition */
#define TDA_STAT_TDA_STAT_MIN 0x0
/** maximum value of test data aquisition */
#define TDA_STAT_TDA_STAT_MAX 0xffff


/** Test Data Aquisition Status Register - Test Data Aquisition Status Register */
#define TDA_STAT_1 (VINAX_AFE_DIG_CH0_BASE + 0x29)
#define TDA_STAT_1_AFE_GET VR9_AfeRead(TDA_STAT_1)
#define TDA_STAT_1_AFE_SET(val) VR9_AfeWrite(TDA_STAT_1, (val), 0xFFFF)

/** Test Data Aquisition Status - Test Data Aquisition Status */
#define TDA_STAT_1_TDA_STAT_MASK 0xffff
#define TDA_STAT_1_TDA_STAT_AFE_GET ((VR9_AfeRead(TDA_STAT_1) & TDA_STAT_1_TDA_STAT_MASK) >> 0)
#define TDA_STAT_1_TDA_STAT_AFE_SET(val) VR9_AfeWrite(TDA_STAT_1, (val) << 0, TDA_STAT_1_TDA_STAT_MASK)
/** minimum value of test data aquisition */
#define TDA_STAT_TDA_STAT_MIN 0x0
/** maximum value of test data aquisition */
#define TDA_STAT_TDA_STAT_MAX 0xffff


/** Test Data Aquisition Status Register - Test Data Aquisition Status Register */
#define TDA_STAT_2 (VINAX_AFE_DIG_CH0_BASE + 0x2a)
#define TDA_STAT_2_AFE_GET VR9_AfeRead(TDA_STAT_2)
#define TDA_STAT_2_AFE_SET(val) VR9_AfeWrite(TDA_STAT_2, (val), 0xFFFF)

/** Test Data Aquisition Status - Test Data Aquisition Status */
#define TDA_STAT_2_TDA_STAT_MASK 0xffff
#define TDA_STAT_2_TDA_STAT_AFE_GET ((VR9_AfeRead(TDA_STAT_2) & TDA_STAT_2_TDA_STAT_MASK) >> 0)
#define TDA_STAT_2_TDA_STAT_AFE_SET(val) VR9_AfeWrite(TDA_STAT_2, (val) << 0, TDA_STAT_2_TDA_STAT_MASK)
/** minimum value of test data aquisition */
#define TDA_STAT_TDA_STAT_MIN 0x0
/** maximum value of test data aquisition */
#define TDA_STAT_TDA_STAT_MAX 0xffff


/** Miscellanous Control Register - Miscellanous Control Register */
#define MISC_CTL (VINAX_AFE_DIG_CH0_BASE + 0x30)
#define MISC_CTL_AFE_GET VR9_AfeRead(MISC_CTL)
#define MISC_CTL_AFE_SET(val) VR9_AfeWrite(MISC_CTL, (val), 0xFFFF)

/** Miscellanous control - Miscellanous control (RESERVED) */
#define MISC_CTL_MISC_CTL_MASK 0xff
#define MISC_CTL_MISC_CTL_AFE_GET ((VR9_AfeRead(MISC_CTL) & MISC_CTL_MISC_CTL_MASK) >> 0)
#define MISC_CTL_MISC_CTL_AFE_SET(val) VR9_AfeWrite(MISC_CTL, (val) << 0, MISC_CTL_MISC_CTL_MASK)
/** minimum value */
#define MISC_CTL_MIN 0x0
/** startup value */
#define MISC_CTL_START 0xc0
/** maximum value */
#define MISC_CTL_MAX 0xff


/** Miscellanous Status Register - Miscellanous Status Register */
#define MISC_STAT (VINAX_AFE_DIG_CH0_BASE + 0x31)
#define MISC_STAT_AFE_GET VR9_AfeRead(MISC_STAT)
#define MISC_STAT_AFE_SET(val) VR9_AfeWrite(MISC_STAT, (val), 0xFFFF)

/** Miscellanous status A - Miscellanous status A (RESERVED) */
#define MISC_STAT_MISC_STAT_A_MASK 0xf
#define MISC_STAT_MISC_STAT_A_AFE_GET ((VR9_AfeRead(MISC_STAT) & MISC_STAT_MISC_STAT_A_MASK) >> 0)
#define MISC_STAT_MISC_STAT_A_AFE_SET(val) VR9_AfeWrite(MISC_STAT, (val) << 0, MISC_STAT_MISC_STAT_A_MASK)
/** minimum value (default) */
#define MISC_STAT_A_MIN 0x0
/** maximum value */
#define MISC_STAT_A_MAX 0xf

/** Miscellanous status B - Miscellanous status B (RESERVED) */
#define MISC_STAT_MISC_STAT_B_MASK 0xf0
#define MISC_STAT_MISC_STAT_B_AFE_GET ((VR9_AfeRead(MISC_STAT) & MISC_STAT_MISC_STAT_B_MASK) >> 4)
#define MISC_STAT_MISC_STAT_B_AFE_SET(val) VR9_AfeWrite(MISC_STAT, (val) << 4, MISC_STAT_MISC_STAT_B_MASK)
/** minimum value (default) */
#define MISC_STAT_B_MIN 0x0
/** maximum value */
#define MISC_STAT_B_MAX 0xf

//XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (Start)
#define GLP_RXFIFO_CTL   (VINAX_AFE_DIG_CH0_BASE + 0x32)
#define GLP_RXFIFO_STAT  (VINAX_AFE_DIG_CH0_BASE + 0x33)
#define GLP_TX0FIFO_CTL  (VINAX_AFE_DIG_CH0_BASE + 0x34)
#define GLP_TX0FIFO_STAT (VINAX_AFE_DIG_CH0_BASE + 0x35)
#define GLP_TX1FIFO_CTL  (VINAX_AFE_DIG_CH0_BASE + 0x36)
#define GLP_TX1FIFO_STAT (VINAX_AFE_DIG_CH0_BASE + 0x37)
#define ADC_FIFO_CTL     (VINAX_AFE_DIG_CH0_BASE + 0x38)
#define ADC_FIFO_STAT    (VINAX_AFE_DIG_CH0_BASE + 0x39)
#define DAC1_FIFO_CTL    (VINAX_AFE_DIG_CH0_BASE + 0x3A)
#define DAC1_FIFO_STAT   (VINAX_AFE_DIG_CH0_BASE + 0x3B)
#define DAC2_FIFO_CTL    (VINAX_AFE_DIG_CH0_BASE + 0x3C)
#define DAC2_FIFO_STAT   (VINAX_AFE_DIG_CH0_BASE + 0x3D)
//XDSLRTFW-271: Fix_AB_ALL_ALL_Init_FIFO (End)

#endif /* _VINAX_AFE_DIG_CH0_H */
