/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VINAX_AFE_DIG_FILT_CH0_H
#define _VINAX_AFE_DIG_FILT_CH0_H


#define VINAX_AFE_DIG_FILT_CH0_BASE 0x200

/** Digital Filters Test Loops - This register controls globally the different test loops in digital filters path */
#define FGLB_DIFI_TLOOP (VINAX_AFE_DIG_FILT_CH0_BASE + 0x0)
#define FGLB_DIFI_TLOOP_AFE_GET VR9_AfeRead(FGLB_DIFI_TLOOP)
#define FGLB_DIFI_TLOOP_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val), 0xFFFF)

/** Loop data from TX1/2 Error correction data to 3GLP - Test loop */
#define FGLB_DIFI_TLOOP_TXEC_RXLOOP1_MASK 0x1
#define FGLB_DIFI_TLOOP_TXEC_RXLOOP1_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_TXEC_RXLOOP1_MASK) >> 0)
#define FGLB_DIFI_TLOOP_TXEC_RXLOOP1_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 0, FGLB_DIFI_TLOOP_TXEC_RXLOOP1_MASK)
/** disabled (default) */
#define TXEC_RXLOOP1_DIS 0x0
/** enabled */
#define TXEC_RXLOOP1_EN 0x1

/** Loop data from TX1/2 Noise shaper data to RX BRWDF1 - Test loop */
#define FGLB_DIFI_TLOOP_TXEC_RXLOOP2_MASK 0x2
#define FGLB_DIFI_TLOOP_TXEC_RXLOOP2_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_TXEC_RXLOOP2_MASK) >> 1)
#define FGLB_DIFI_TLOOP_TXEC_RXLOOP2_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 1, FGLB_DIFI_TLOOP_TXEC_RXLOOP2_MASK)
/** disabled (default) */
#define TXEC_RXLOOP2_DIS 0x0
/** enabled */
#define TXEC_RXLOOP2_EN 0x1

/** Loop data from RX Filtered data to TX BRWDF1 - Test loop */
#define FGLB_DIFI_TLOOP_RX_TXLOOP_MASK 0x4
#define FGLB_DIFI_TLOOP_RX_TXLOOP_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_RX_TXLOOP_MASK) >> 2)
#define FGLB_DIFI_TLOOP_RX_TXLOOP_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 2, FGLB_DIFI_TLOOP_RX_TXLOOP_MASK)
/** disabled (default) */
#define RX_TXLOOP_DIS 0x0
/** enabled */
#define RX_TXLOOP_EN 0x1

/** Loop data from TX Noise shaper data to EC DAC - Test loop */
#define FGLB_DIFI_TLOOP_TX_ECDACLOOP_MASK 0x8
#define FGLB_DIFI_TLOOP_TX_ECDACLOOP_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_TX_ECDACLOOP_MASK) >> 3)
#define FGLB_DIFI_TLOOP_TX_ECDACLOOP_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 3, FGLB_DIFI_TLOOP_TX_ECDACLOOP_MASK)
/** disabled (default) */
#define TX_ECDACLOOP_DIS 0x0
/** enabled */
#define TX_ECDACLOOP_EN 0x1

/** Loop data from RX Filtered data to ECHO BRWDF1 - Test loop */
#define FGLB_DIFI_TLOOP_RX_ECLOOP_MASK 0x10
#define FGLB_DIFI_TLOOP_RX_ECLOOP_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_RX_ECLOOP_MASK) >> 4)
#define FGLB_DIFI_TLOOP_RX_ECLOOP_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 4, FGLB_DIFI_TLOOP_RX_ECLOOP_MASK)
/** disabled (default) */
#define RX_ECLOOP_DIS 0x0
/** enabled */
#define RX_ECLOOP_EN 0x1

/** Loop data from ECHO Noise shaper data to TX DAC(eternal port) - Test loop */
#define FGLB_DIFI_TLOOP_EC_TXDACLOOP_MASK 0x20
#define FGLB_DIFI_TLOOP_EC_TXDACLOOP_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_EC_TXDACLOOP_MASK) >> 5)
#define FGLB_DIFI_TLOOP_EC_TXDACLOOP_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 5, FGLB_DIFI_TLOOP_EC_TXDACLOOP_MASK)
/** disabled (default) */
#define EC_TXDACLOOP_DIS 0x0
/** enabled */
#define EC_TXDACLOOP_EN 0x1

/** Selection of error correction data between TX and ECHO to RX 3GLP Interface - Selection */
#define FGLB_DIFI_TLOOP_TXEC_RX_SEL1_MASK 0x40
#define FGLB_DIFI_TLOOP_TXEC_RX_SEL1_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_TXEC_RX_SEL1_MASK) >> 6)
#define FGLB_DIFI_TLOOP_TXEC_RX_SEL1_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 6, FGLB_DIFI_TLOOP_TXEC_RX_SEL1_MASK)
/** TX Error correction data (default) */
#define TXEC_RX_SEL1_TX 0x0
/** Echo Error correction data */
#define TXEC_RX_SEL1_EC 0x1

/** Selection of Noise Shaper data between TX and ECHO to RX BRWDF1 - Selection */
#define FGLB_DIFI_TLOOP_TXEC_RX_SEL2_MASK 0x80
#define FGLB_DIFI_TLOOP_TXEC_RX_SEL2_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_TXEC_RX_SEL2_MASK) >> 7)
#define FGLB_DIFI_TLOOP_TXEC_RX_SEL2_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 7, FGLB_DIFI_TLOOP_TXEC_RX_SEL2_MASK)
/** TX Noise Shaper data (default) */
#define TXEC_RX_SEL2_TX 0x0
/** Echo Noise Shaper data */
#define TXEC_RX_SEL2_EC 0x1

/** Selection of TX GLP data between TX and ECHO path Filters - Selection */
#define FGLB_DIFI_TLOOP_TXGLP_SEL_MASK 0x100
#define FGLB_DIFI_TLOOP_TXGLP_SEL_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_TXGLP_SEL_MASK) >> 8)
#define FGLB_DIFI_TLOOP_TXGLP_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 8, FGLB_DIFI_TLOOP_TXGLP_SEL_MASK)
/** TX GLP data to TX path filters (default) */
#define TXGLP_SEL_TX 0x0
/** TX GLP data to Echo path filters */
#define TXGLP_SEL_EC 0x1

/** Selection of ECHO GLP data between ECHO and TX path Filters - Selection */
#define FGLB_DIFI_TLOOP_ECGLP_SEL_MASK 0x200
#define FGLB_DIFI_TLOOP_ECGLP_SEL_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_ECGLP_SEL_MASK) >> 9)
#define FGLB_DIFI_TLOOP_ECGLP_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 9, FGLB_DIFI_TLOOP_ECGLP_SEL_MASK)
/** Echo GLP data to Echo path filters (default) */
#define ECGLP_SEL_TX 0x0
/** Echo GLP data to TX path filters */
#define ECGLP_SEL_EC 0x1

/** Enables the monitor bus for debugging purposes - enables Monitor bus */
#define FGLB_DIFI_TLOOP_MONITOR_EN_MASK 0x8000
#define FGLB_DIFI_TLOOP_MONITOR_EN_AFE_GET ((VR9_AfeRead(FGLB_DIFI_TLOOP) & FGLB_DIFI_TLOOP_MONITOR_EN_MASK) >> 15)
#define FGLB_DIFI_TLOOP_MONITOR_EN_AFE_SET(val) VR9_AfeWrite(FGLB_DIFI_TLOOP, (val) << 15, FGLB_DIFI_TLOOP_MONITOR_EN_MASK)
/** disabled (default) */
#define MONITOR_EN_DIS 0x0
/** enabled */
#define MONITOR_EN_EN 0x1


/** Global Control Register 1 - This register controls globally the mode of operation for Transmit and Receive path */
#define FGLB_CTRL1 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x1)
#define FGLB_CTRL1_AFE_GET VR9_AfeRead(FGLB_CTRL1)
#define FGLB_CTRL1_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL1, (val), 0xFFFF)

/** Sampling Frequency Selection for DAC1 - Sampling Frequency selection for DAC1 */
#define FGLB_CTRL1_DAC1_FREQ_SEL_MASK 0x3
#define FGLB_CTRL1_DAC1_FREQ_SEL_AFE_GET ((VR9_AfeRead(FGLB_CTRL1) & FGLB_CTRL1_DAC1_FREQ_SEL_MASK) >> 0)
#define FGLB_CTRL1_DAC1_FREQ_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL1, (val) << 0, FGLB_CTRL1_DAC1_FREQ_SEL_MASK)
/** 288 MHz */
#define DAC1_FREQ_SEL_FREQ0 0x0
/** 216 MHz (default) */
#define DAC1_FREQ_SEL_FREQ1 0x1
/** 144 MHz */
#define DAC1_FREQ_SEL_FREQ2 0x2
/** 144 MHz */
#define DAC1_FREQ_SEL_FREQ3 0x3

/** Sampling Frequency Selection for DAC2 - Sampling Frequency selection for DAC2 */
#define FGLB_CTRL1_DAC2_FREQ_SEL_MASK 0xc
#define FGLB_CTRL1_DAC2_FREQ_SEL_AFE_GET ((VR9_AfeRead(FGLB_CTRL1) & FGLB_CTRL1_DAC2_FREQ_SEL_MASK) >> 2)
#define FGLB_CTRL1_DAC2_FREQ_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL1, (val) << 2, FGLB_CTRL1_DAC2_FREQ_SEL_MASK)
/** 288 MHz */
#define DAC2_FREQ_SEL_FREQ0 0x0
/** 216 MHz (default) */
#define DAC2_FREQ_SEL_FREQ1 0x1
/** 144 MHz */
#define DAC2_FREQ_SEL_FREQ2 0x2
/** 144 MHz */
#define DAC2_FREQ_SEL_FREQ3 0x3

/** Sampling Frequency Selection for ADC - Sampling Frequency selection for ADC */
#define FGLB_CTRL1_ADC_FREQ_SEL_MASK 0x10
#define FGLB_CTRL1_ADC_FREQ_SEL_AFE_GET ((VR9_AfeRead(FGLB_CTRL1) & FGLB_CTRL1_ADC_FREQ_SEL_MASK) >> 4)
#define FGLB_CTRL1_ADC_FREQ_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL1, (val) << 4, FGLB_CTRL1_ADC_FREQ_SEL_MASK)
/** 144 MHz */
#define ADC_FREQ_SEL_FREQ0 0x0
/** 288 MHz (default) */
#define ADC_FREQ_SEL_FREQ1 0x1

/** Transmit Path Trigger initialization - Transmit (TX) path Trigger initialization  */
#define FGLB_CTRL1_TX_TRIG_INIT_MASK 0x20
#define FGLB_CTRL1_TX_TRIG_INIT_AFE_GET ((VR9_AfeRead(FGLB_CTRL1) & FGLB_CTRL1_TX_TRIG_INIT_MASK) >> 5)
#define FGLB_CTRL1_TX_TRIG_INIT_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL1, (val) << 5, FGLB_CTRL1_TX_TRIG_INIT_MASK)
/** disabled */
#define TX_TRIG_INIT_DIS 0x0
/** enabled (default) */
#define TX_TRIG_INIT_EN 0x1

/** Echo Path Trigger initialization - Echo (EC) path Trigger initialization  */
#define FGLB_CTRL1_EC_TRIG_INIT_MASK 0x40
#define FGLB_CTRL1_EC_TRIG_INIT_AFE_GET ((VR9_AfeRead(FGLB_CTRL1) & FGLB_CTRL1_EC_TRIG_INIT_MASK) >> 6)
#define FGLB_CTRL1_EC_TRIG_INIT_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL1, (val) << 6, FGLB_CTRL1_EC_TRIG_INIT_MASK)
/** disabled */
#define EC_TRIG_INIT_DIS 0x0
/** enabled (default) */
#define EC_TRIG_INIT_EN 0x1

/** RX Path Trigger initialization - RX path Trigger initialization  */
#define FGLB_CTRL1_RX_TRIG_INIT_MASK 0x80
#define FGLB_CTRL1_RX_TRIG_INIT_AFE_GET ((VR9_AfeRead(FGLB_CTRL1) & FGLB_CTRL1_RX_TRIG_INIT_MASK) >> 7)
#define FGLB_CTRL1_RX_TRIG_INIT_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL1, (val) << 7, FGLB_CTRL1_RX_TRIG_INIT_MASK)
/** disabled */
#define RX_TRIG_INIT_DIS 0x0
/** enabled (default) */
#define RX_TRIG_INIT_EN 0x1

// Tx1 & Tx2 mask  (SMS00974862 USER DEFINES Start )
#define FGLB_CTRL1_TX1_TX2_MASK 0x006F
// RxMask
#define FGLB_CTRL1_RX_MASK 0x0090
// SMS00974862 USER DEFINES End

/** Global Control Register 2 - This register controls the enabling of the TX, RX and Echo path filters */
#define FGLB_CTRL2 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x2)
#define FGLB_CTRL2_AFE_GET VR9_AfeRead(FGLB_CTRL2)
#define FGLB_CTRL2_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL2, (val), 0xFFFF)

/** Transmit Path Enable - Transmit (TX) path Enable */
#define FGLB_CTRL2_TX_EN_MASK 0x1
#define FGLB_CTRL2_TX_EN_AFE_GET ((VR9_AfeRead(FGLB_CTRL2) & FGLB_CTRL2_TX_EN_MASK) >> 0)
#define FGLB_CTRL2_TX_EN_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL2, (val) << 0, FGLB_CTRL2_TX_EN_MASK)
/** disabled (default) */
#define TX_EN_DIS 0x0
/** enabled */
#define TX_EN_EN 0x1

/** Echo Path Enable - Echo (EC) path Enable */
#define FGLB_CTRL2_EC_EN_MASK 0x2
#define FGLB_CTRL2_EC_EN_AFE_GET ((VR9_AfeRead(FGLB_CTRL2) & FGLB_CTRL2_EC_EN_MASK) >> 1)
#define FGLB_CTRL2_EC_EN_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL2, (val) << 1, FGLB_CTRL2_EC_EN_MASK)
/** disabled (default) */
#define EC_EN_DIS 0x0
/** enabled */
#define EC_EN_EN 0x1

/** Receive Path Enable - RX path Enable */
#define FGLB_CTRL2_RX_EN_MASK 0x4
#define FGLB_CTRL2_RX_EN_AFE_GET ((VR9_AfeRead(FGLB_CTRL2) & FGLB_CTRL2_RX_EN_MASK) >> 2)
#define FGLB_CTRL2_RX_EN_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL2, (val) << 2, FGLB_CTRL2_RX_EN_MASK)
/** disabled (default) */
#define RX_EN_DIS 0x0
/** enabled */
#define RX_EN_EN 0x1

// Tx1 & Tx2 mask  (SMS00974862 USER DEFINES Start )
#define FGLB_CTRL2_TX1_TX2_MASK 0x0003
// RxMask
#define FGLB_CTRL2_RX_MASK 0x0004
// SMS00974862 USER DEFINES End


/** Global Control Register 3 - This register controls globally the TX, RX and Echo path filters */
#define FGLB_CTRL3 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x3)
#define FGLB_CTRL3_AFE_GET VR9_AfeRead(FGLB_CTRL3)
#define FGLB_CTRL3_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val), 0xFFFF)

/** Transmit Path Event (Overflow) Counter Enable - Transmit (TX) path Enable */
#define FGLB_CTRL3_TX_ECNT_EN_MASK 0x1
#define FGLB_CTRL3_TX_ECNT_EN_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_TX_ECNT_EN_MASK) >> 0)
#define FGLB_CTRL3_TX_ECNT_EN_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 0, FGLB_CTRL3_TX_ECNT_EN_MASK)
/** disabled (default) */
#define TX_ECNT_EN_DIS 0x0
/** enabled */
#define TX_ECNT_EN_EN 0x1

/** Echo Path Event (Overflow) Counter Enable - Echo (EC) path Enable */
#define FGLB_CTRL3_EC_ECNT_EN_MASK 0x2
#define FGLB_CTRL3_EC_ECNT_EN_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_EC_ECNT_EN_MASK) >> 1)
#define FGLB_CTRL3_EC_ECNT_EN_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 1, FGLB_CTRL3_EC_ECNT_EN_MASK)
/** disabled (default) */
#define EC_ECNT_EN_DIS 0x0
/** enabled */
#define EC_ECNT_EN_EN 0x1

/** Receive Path Event (Overflow) Counter Enable - RX path Enable */
#define FGLB_CTRL3_RX_ECNT_EN_MASK 0x4
#define FGLB_CTRL3_RX_ECNT_EN_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_RX_ECNT_EN_MASK) >> 2)
#define FGLB_CTRL3_RX_ECNT_EN_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 2, FGLB_CTRL3_RX_ECNT_EN_MASK)
/** disabled (default) */
#define RX_ECNT_EN_DIS 0x0
/** enabled */
#define RX_ECNT_EN_EN 0x1

/** Event (Overflow) Counter Selection - Transmit Path Filter Selection for Events (Overflow) Counting  */
#define FGLB_CTRL3_TX_ECNT_SEL_MASK 0x70
#define FGLB_CTRL3_TX_ECNT_SEL_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_TX_ECNT_SEL_MASK) >> 4)
#define FGLB_CTRL3_TX_ECNT_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 4, FGLB_CTRL3_TX_ECNT_SEL_MASK)
/** Counts Error correction Filter Overflows */
#define TX_ECNT_SEL_ERRC 0x0
/** Counts Error correction Filter CRC Errors */
#define TX_ECNT_SEL_CRC 0x1
/** Counts POLYWDF1 Filter Overflows */
#define TX_ECNT_SEL_WDF1 0x2
/** Counts Noise Shaper Filter Overflows */
#define TX_ECNT_SEL_NSH 0x3
/** Counts Whole Transmit path Filter Overflows (default) */
#define TX_ECNT_SEL_TX 0x4

/** Event (Overflow) Counter Selection - ECHO Path Filter Selection for Events (Overflow) Counting  */
#define FGLB_CTRL3_EC_ECNT_SEL_MASK 0x380
#define FGLB_CTRL3_EC_ECNT_SEL_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_EC_ECNT_SEL_MASK) >> 7)
#define FGLB_CTRL3_EC_ECNT_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 7, FGLB_CTRL3_EC_ECNT_SEL_MASK)
/** Counts Error correction Filter Overflows */
#define EC_ECNT_SEL_ERRC 0x0
/** Counts Error correction Filter CRC Errors */
#define EC_ECNT_SEL_CRC 0x1
/** Counts POLYWDF1 Filter Overflows */
#define EC_ECNT_SEL_WDF1 0x2
/** Counts Noise Shaper Filter Overflows */
#define EC_ECNT_SEL_NSH 0x3
/** Counts Whole Transmit path Filter Overflows (default) */
#define EC_ECNT_SEL_EC 0x4

/** Overflow Counter Selection among Receive Filters - Receive Path Filter Selection for Events (Overflow) Counting  */
#define FGLB_CTRL3_RX_ECNT_SEL_MASK 0xc00
#define FGLB_CTRL3_RX_ECNT_SEL_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_RX_ECNT_SEL_MASK) >> 10)
#define FGLB_CTRL3_RX_ECNT_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 10, FGLB_CTRL3_RX_ECNT_SEL_MASK)
/** Counts CLCMB1 Filter Overflows */
#define RX_ECNT_SEL_CLCMB1 0x0
/** Counts BRWDF1 Filter Overflows */
#define RX_ECNT_SEL_BRWDF1 0x1
/** Counts ADC Overload Overflows */
#define RX_ECNT_SEL_ADC 0x2
/** Counts Whole Receive path Overflows (default) */
#define RX_ECNT_SEL_RX 0x3

/** Transmit Path Event (Overflow) Counter Mode - controls whether the Overflow counter roll over or saturate  */
#define FGLB_CTRL3_TX_OCM_MASK 0x2000
#define FGLB_CTRL3_TX_OCM_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_TX_OCM_MASK) >> 13)
#define FGLB_CTRL3_TX_OCM_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 13, FGLB_CTRL3_TX_OCM_MASK)
/** counter will wrap around (default) */
#define TX_OCM_WRAP 0x0
/** counter will saturate */
#define TX_OCM_SAT 0x1

/** Echo Path Event (Overflow) Counter Mode - controls whether the Overflow counter roll over or saturate  */
#define FGLB_CTRL3_EC_OCM_MASK 0x4000
#define FGLB_CTRL3_EC_OCM_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_EC_OCM_MASK) >> 14)
#define FGLB_CTRL3_EC_OCM_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 14, FGLB_CTRL3_EC_OCM_MASK)
/** counter will wrap around (default) */
#define EC_OCM_WRAP 0x0
/** counter will saturate */
#define EC_OCM_SAT 0x1

/** Receive Path Event (Overflow) Counter Mode - controls whether the Overflow counter roll over or saturate  */
#define FGLB_CTRL3_RX_OCM_MASK 0x8000
#define FGLB_CTRL3_RX_OCM_AFE_GET ((VR9_AfeRead(FGLB_CTRL3) & FGLB_CTRL3_RX_OCM_MASK) >> 15)
#define FGLB_CTRL3_RX_OCM_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL3, (val) << 15, FGLB_CTRL3_RX_OCM_MASK)
/** counter will wrap around (default) */
#define RX_OCM_WRAP 0x0
/** counter will saturate */
#define RX_OCM_SAT 0x1


/** Global Control Register 4 - This register controls globally Scaling Factors of Event counter of TX, RX and Echo path Filters */
#define FGLB_CTRL4 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x4)
#define FGLB_CTRL4_AFE_GET VR9_AfeRead(FGLB_CTRL4)
#define FGLB_CTRL4_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL4, (val), 0xFFFF)

/** Transmit Filter Event Counter Scaling Factor - Transmit Path Event Counter Scaling Factor */
#define FGLB_CTRL4_TX_ECNT_SCAL_MASK 0x3
#define FGLB_CTRL4_TX_ECNT_SCAL_AFE_GET ((VR9_AfeRead(FGLB_CTRL4) & FGLB_CTRL4_TX_ECNT_SCAL_MASK) >> 0)
#define FGLB_CTRL4_TX_ECNT_SCAL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL4, (val) << 0, FGLB_CTRL4_TX_ECNT_SCAL_MASK)
/** 0 (default) */
#define TX_ECNT_SCAL_SCALE0 0x0
/** 4 */
#define TX_ECNT_SCAL_SCALE4 0x1
/** 8 */
#define TX_ECNT_SCAL_SCALE8 0x2
/** 16 */
#define TX_ECNT_SCAL_SCALE16 0x3

/** ECHO Filter Event Counter Scaling Factor - Echo Path Event Counter Scaling Factor */
#define FGLB_CTRL4_EC_ECNT_SCAL_MASK 0xc
#define FGLB_CTRL4_EC_ECNT_SCAL_AFE_GET ((VR9_AfeRead(FGLB_CTRL4) & FGLB_CTRL4_EC_ECNT_SCAL_MASK) >> 2)
#define FGLB_CTRL4_EC_ECNT_SCAL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL4, (val) << 2, FGLB_CTRL4_EC_ECNT_SCAL_MASK)
/** 0 (default) */
#define EC_ECNT_SCAL_SCALE0 0x0
/** 4 */
#define EC_ECNT_SCAL_SCALE4 0x1
/** 8 */
#define EC_ECNT_SCAL_SCALE8 0x2
/** 16 */
#define EC_ECNT_SCAL_SCALE16 0x3

/** Receive Filter Event Counter Scaling Factor - Receive Path Event Counter Scaling Factor */
#define FGLB_CTRL4_RX_ECNT_SCAL_MASK 0x30
#define FGLB_CTRL4_RX_ECNT_SCAL_AFE_GET ((VR9_AfeRead(FGLB_CTRL4) & FGLB_CTRL4_RX_ECNT_SCAL_MASK) >> 4)
#define FGLB_CTRL4_RX_ECNT_SCAL_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL4, (val) << 4, FGLB_CTRL4_RX_ECNT_SCAL_MASK)
/** 0 (default) */
#define RX_ECNT_SCAL_SCALE0 0x0
/** 4 */
#define RX_ECNT_SCAL_SCALE4 0x1
/** 8 */
#define RX_ECNT_SCAL_SCALE8 0x2
/** 16 */
#define RX_ECNT_SCAL_SCALE16 0x3


/** Global Control Register 5 - This register controls globally the Bypass of the TX, RX and Echo path filters */
#define FGLB_CTRL5 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x5)
#define FGLB_CTRL5_AFE_GET VR9_AfeRead(FGLB_CTRL5)
#define FGLB_CTRL5_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL5, (val), 0xFFFF)

/** Transmit Path Enable - Transmit (TX) path Bypass */
#define FGLB_CTRL5_TX_BYP_MASK 0x1
#define FGLB_CTRL5_TX_BYP_AFE_GET ((VR9_AfeRead(FGLB_CTRL5) & FGLB_CTRL5_TX_BYP_MASK) >> 0)
#define FGLB_CTRL5_TX_BYP_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL5, (val) << 0, FGLB_CTRL5_TX_BYP_MASK)
/** disabled (default) */
#define TX_BYP_DIS 0x0
/** enabled */
#define TX_BYP_EN 0x1

/** Echo Path Enable - Echo (EC) path Bypass */
#define FGLB_CTRL5_EC_BYP_MASK 0x2
#define FGLB_CTRL5_EC_BYP_AFE_GET ((VR9_AfeRead(FGLB_CTRL5) & FGLB_CTRL5_EC_BYP_MASK) >> 1)
#define FGLB_CTRL5_EC_BYP_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL5, (val) << 1, FGLB_CTRL5_EC_BYP_MASK)
/** disabled (default) */
#define EC_BYP_DIS 0x0
/** enabled */
#define EC_BYP_EN 0x1

/** Receive Path Enable - RX path Bypass */
#define FGLB_CTRL5_RX_BYP_MASK 0x4
#define FGLB_CTRL5_RX_BYP_AFE_GET ((VR9_AfeRead(FGLB_CTRL5) & FGLB_CTRL5_RX_BYP_MASK) >> 2)
#define FGLB_CTRL5_RX_BYP_AFE_SET(val) VR9_AfeWrite(FGLB_CTRL5, (val) << 2, FGLB_CTRL5_RX_BYP_MASK)
/** disabled (default) */
#define RX_BYP_DIS 0x0
/** enabled */
#define RX_BYP_EN 0x1


/** ADC Interrupt Control Register - This register controls globally the interrupt handling of the ADC */
#define FGLB_ADC_INTCTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x6)
#define FGLB_ADC_INTCTRL_AFE_GET VR9_AfeRead(FGLB_ADC_INTCTRL)
#define FGLB_ADC_INTCTRL_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_INTCTRL, (val), 0xFFFF)

/** Penality for ADC Interrupt Counter - Specifies the penality for the ADC Interrupt Counter. */
#define FGLB_ADC_INTCTRL_PENALITY_MASK 0xff
#define FGLB_ADC_INTCTRL_PENALITY_AFE_GET ((VR9_AfeRead(FGLB_ADC_INTCTRL) & FGLB_ADC_INTCTRL_PENALITY_MASK) >> 0)
#define FGLB_ADC_INTCTRL_PENALITY_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_INTCTRL, (val) << 0, FGLB_ADC_INTCTRL_PENALITY_MASK)
/** 8 (default) */
#define PENALITY_PW 0x8

/** Programmable interrupt pulse width - Specifies the pulse width for interrupt. The pulse width is according to the number of clock cycles of ADC. */
#define FGLB_ADC_INTCTRL_PWIDTH_MASK 0x3e00
#define FGLB_ADC_INTCTRL_PWIDTH_AFE_GET ((VR9_AfeRead(FGLB_ADC_INTCTRL) & FGLB_ADC_INTCTRL_PWIDTH_MASK) >> 9)
#define FGLB_ADC_INTCTRL_PWIDTH_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_INTCTRL, (val) << 9, FGLB_ADC_INTCTRL_PWIDTH_MASK)
/** 4 (default) */
#define PWIDTH_PW 0x4

/** ADC Overflow Interrupt Counter Mode - Controls whether the Overflow counter roll over or saturate  */
#define FGLB_ADC_INTCTRL_OCM_MASK 0x4000
#define FGLB_ADC_INTCTRL_OCM_AFE_GET ((VR9_AfeRead(FGLB_ADC_INTCTRL) & FGLB_ADC_INTCTRL_OCM_MASK) >> 14)
#define FGLB_ADC_INTCTRL_OCM_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_INTCTRL, (val) << 14, FGLB_ADC_INTCTRL_OCM_MASK)
/** counter will wrap around (default) */
#define OCM_WRAP 0x0
/** counter will saturate */
#define OCM_SAT 0x1

/** Selection between type of ADC interrupt - Type of ADC interrupt Selection */
#define FGLB_ADC_INTCTRL_SEL_MASK 0x8000
#define FGLB_ADC_INTCTRL_SEL_AFE_GET ((VR9_AfeRead(FGLB_ADC_INTCTRL) & FGLB_ADC_INTCTRL_SEL_MASK) >> 15)
#define FGLB_ADC_INTCTRL_SEL_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_INTCTRL, (val) << 15, FGLB_ADC_INTCTRL_SEL_MASK)
/** constantly HIGH until FILT_STAT register is read (default) */
#define SEL_CONST 0x0
/** pulse type (width is configurable according to PWIDTH setting) */
#define SEL_PULSE 0x1


/** Transmitter Path Event Counter Threshold Value - This register controls the threshold value of event counter of Transmitter Path. */
#define FGLB_TX_ECNT_THRES (VINAX_AFE_DIG_FILT_CH0_BASE + 0x7)
#define FGLB_TX_ECNT_THRES_AFE_GET VR9_AfeRead(FGLB_TX_ECNT_THRES)
#define FGLB_TX_ECNT_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_TX_ECNT_THRES, (val), 0xFFFF)

/** Threshold Value - Threshold value of the Transmit path Event (overflows/error) counter. */
#define FGLB_TX_ECNT_THRES_TX_ECNT_THRES_MASK 0xffff
#define FGLB_TX_ECNT_THRES_TX_ECNT_THRES_AFE_GET ((VR9_AfeRead(FGLB_TX_ECNT_THRES) & FGLB_TX_ECNT_THRES_TX_ECNT_THRES_MASK) >> 0)
#define FGLB_TX_ECNT_THRES_TX_ECNT_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_TX_ECNT_THRES, (val) << 0, FGLB_TX_ECNT_THRES_TX_ECNT_THRES_MASK)
/** minimum value */
#define TX_ECNT_THRES_MIN 0x0
/** maximum value (default) */
#define TX_ECNT_THRES_MAX 0xffff


/** Echo Path Event Counter Threshold Value - This register controls the threshold value of event counter of Echo Path. */
#define FGLB_EC_ECNT_THRES (VINAX_AFE_DIG_FILT_CH0_BASE + 0x8)
#define FGLB_EC_ECNT_THRES_AFE_GET VR9_AfeRead(FGLB_EC_ECNT_THRES)
#define FGLB_EC_ECNT_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_EC_ECNT_THRES, (val), 0xFFFF)

/** Threshold Value - Threshold value of the Echo path Event (overflows/error) counter. */
#define FGLB_EC_ECNT_THRES_EC_ECNT_THRES_MASK 0xffff
#define FGLB_EC_ECNT_THRES_EC_ECNT_THRES_AFE_GET ((VR9_AfeRead(FGLB_EC_ECNT_THRES) & FGLB_EC_ECNT_THRES_EC_ECNT_THRES_MASK) >> 0)
#define FGLB_EC_ECNT_THRES_EC_ECNT_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_EC_ECNT_THRES, (val) << 0, FGLB_EC_ECNT_THRES_EC_ECNT_THRES_MASK)
/** minimum value */
#define EC_ECNT_THRES_MIN 0x0
/** maximum value (default) */
#define EC_ECNT_THRES_MAX 0xffff


/** Receiver Path Event Counter Threshold Value - This register controls the threshold value of event counter of Receiver Path. */
#define FGLB_RX_ECNT_THRES (VINAX_AFE_DIG_FILT_CH0_BASE + 0x9)
#define FGLB_RX_ECNT_THRES_AFE_GET VR9_AfeRead(FGLB_RX_ECNT_THRES)
#define FGLB_RX_ECNT_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_RX_ECNT_THRES, (val), 0xFFFF)

/** Threshold Value - Threshold value of the RX Event (overflows/error) counter. */
#define FGLB_RX_ECNT_THRES_RX_ECNT_THRES_MASK 0xffff
#define FGLB_RX_ECNT_THRES_RX_ECNT_THRES_AFE_GET ((VR9_AfeRead(FGLB_RX_ECNT_THRES) & FGLB_RX_ECNT_THRES_RX_ECNT_THRES_MASK) >> 0)
#define FGLB_RX_ECNT_THRES_RX_ECNT_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_RX_ECNT_THRES, (val) << 0, FGLB_RX_ECNT_THRES_RX_ECNT_THRES_MASK)
/** minimum value */
#define RX_ECNT_THRES_MIN 0x0
/** maximum value (default) */
#define RX_ECNT_THRES_MAX 0xffff


/** Threshold for ADC Overflow Interrupt counter - This register controls the threshold value of ADC Overflow counter. */
#define FGLB_ADC_INTCTRL_THRES (VINAX_AFE_DIG_FILT_CH0_BASE + 0xa)
#define FGLB_ADC_INTCTRL_THRES_AFE_GET VR9_AfeRead(FGLB_ADC_INTCTRL_THRES)
#define FGLB_ADC_INTCTRL_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_INTCTRL_THRES, (val), 0xFFFF)

/** Threshold Value - Specifies the Threshold value for the ADC interrupt counter (ADC_OCNT). */
#define FGLB_ADC_INTCTRL_THRES_ADC_OVLDINTR_THRES_MASK 0xffff
#define FGLB_ADC_INTCTRL_THRES_ADC_OVLDINTR_THRES_AFE_GET ((VR9_AfeRead(FGLB_ADC_INTCTRL_THRES) & FGLB_ADC_INTCTRL_THRES_ADC_OVLDINTR_THRES_MASK) >> 0)
#define FGLB_ADC_INTCTRL_THRES_ADC_OVLDINTR_THRES_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_INTCTRL_THRES, (val) << 0, FGLB_ADC_INTCTRL_THRES_ADC_OVLDINTR_THRES_MASK)
/** minimum value */
#define ADC_OVLDINTR_THRES_MIN 0x0
/** startup value (default) */
#define ADC_OVLDINTR_THRES_START 0x100
/** maximum value */
#define ADC_OVLDINTR_THRES_MAX 0xffff


/** Global Status/Interrupt Register of all filters in VR9 AFE - This register shows the Saturation and Event Counter Overflow status of all filters. */
#define FGLB_FILT_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0xb)
#define FGLB_FILT_STAT_AFE_GET VR9_AfeRead(FGLB_FILT_STAT)
#define FGLB_FILT_STAT_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val), 0xFFFF)

/** TX path Error Correction Overflow Flag */
#define FGLB_FILT_STAT_TX_ERRC_OVL_MASK 0x1
#define FGLB_FILT_STAT_TX_ERRC_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_TX_ERRC_OVL_MASK) >> 0)
#define FGLB_FILT_STAT_TX_ERRC_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 0, FGLB_FILT_STAT_TX_ERRC_OVL_MASK)
/** No Overflow */
#define TX_ERRC_OVL_NO_OVFL 0x0
/** Overflow */
#define TX_ERRC_OVL_OVFL 0x1

/** TX path BRWDF1 Filter Saturation Overflow Flag */
#define FGLB_FILT_STAT_TX_BRWDF1_OVL_MASK 0x2
#define FGLB_FILT_STAT_TX_BRWDF1_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_TX_BRWDF1_OVL_MASK) >> 1)
#define FGLB_FILT_STAT_TX_BRWDF1_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 1, FGLB_FILT_STAT_TX_BRWDF1_OVL_MASK)
/** No Overflow */
#define TX_BRWDF1_OVL_NO_OVFL 0x0
/** Overflow */
#define TX_BRWDF1_OVL_OVFL 0x1

/** TX path Noise Shaper Saturation Overflow Flag */
#define FGLB_FILT_STAT_TX_NSH_OVL_MASK 0x4
#define FGLB_FILT_STAT_TX_NSH_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_TX_NSH_OVL_MASK) >> 2)
#define FGLB_FILT_STAT_TX_NSH_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 2, FGLB_FILT_STAT_TX_NSH_OVL_MASK)
/** No Overflow */
#define TX_NSH_OVL_NO_OVFL 0x0
/** Overflow */
#define TX_NSH_OVL_OVFL 0x1

/** ECHO path Error Correction Overflow Flag */
#define FGLB_FILT_STAT_EC_ERRC_OVL_MASK 0x10
#define FGLB_FILT_STAT_EC_ERRC_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_EC_ERRC_OVL_MASK) >> 4)
#define FGLB_FILT_STAT_EC_ERRC_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 4, FGLB_FILT_STAT_EC_ERRC_OVL_MASK)
/** No Overflow */
#define EC_ERRC_OVL_NO_OVFL 0x0
/** Overflow */
#define EC_ERRC_OVL_OVFL 0x1

/** ECHO path BRWDF1 Filter Saturation Overflow Flag */
#define FGLB_FILT_STAT_EC_BRWDF1_OVL_MASK 0x20
#define FGLB_FILT_STAT_EC_BRWDF1_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_EC_BRWDF1_OVL_MASK) >> 5)
#define FGLB_FILT_STAT_EC_BRWDF1_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 5, FGLB_FILT_STAT_EC_BRWDF1_OVL_MASK)
/** No Overflow */
#define EC_BRWDF1_OVL_NO_OVFL 0x0
/** Overflow */
#define EC_BRWDF1_OVL_OVFL 0x1

/** ECHO path Noise Shaper Saturation Overflow Flag */
#define FGLB_FILT_STAT_EC_NSH_OVL_MASK 0x40
#define FGLB_FILT_STAT_EC_NSH_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_EC_NSH_OVL_MASK) >> 6)
#define FGLB_FILT_STAT_EC_NSH_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 6, FGLB_FILT_STAT_EC_NSH_OVL_MASK)
/** No Overflow */
#define EC_NSH_OVL_NO_OVFL 0x0
/** Overflow */
#define EC_NSH_OVL_OVFL 0x1

/** RX CLCMB1(Cancel logic + COMB1) Filter Saturation Overflow Flag */
#define FGLB_FILT_STAT_RX_CMB1_OVL_MASK 0x100
#define FGLB_FILT_STAT_RX_CMB1_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_RX_CMB1_OVL_MASK) >> 8)
#define FGLB_FILT_STAT_RX_CMB1_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 8, FGLB_FILT_STAT_RX_CMB1_OVL_MASK)
/** No Overflow */
#define RX_CMB1_OVL_NO_OVFL 0x0
/** Overflow */
#define RX_CMB1_OVL_OVFL 0x1

/** RX BRWDF1 Filter Saturation Overflow Flag */
#define FGLB_FILT_STAT_RX_BRWDF1_OVL_MASK 0x200
#define FGLB_FILT_STAT_RX_BRWDF1_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_RX_BRWDF1_OVL_MASK) >> 9)
#define FGLB_FILT_STAT_RX_BRWDF1_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 9, FGLB_FILT_STAT_RX_BRWDF1_OVL_MASK)
/** No Overflow */
#define RX_BRWDF1_OVL_NO_OVFL 0x0
/** Overflow */
#define RX_BRWDF1_OVL_OVFL 0x1

/** ADC Overload Flag */
#define FGLB_FILT_STAT_ADC_OVL_MASK 0x800
#define FGLB_FILT_STAT_ADC_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_ADC_OVL_MASK) >> 11)
#define FGLB_FILT_STAT_ADC_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 11, FGLB_FILT_STAT_ADC_OVL_MASK)
/** No Overflow */
#define ADC_OVL_NO_OVFL 0x0
/** Overflow */
#define ADC_OVL_OVFL 0x1

/** TX Event Counter Saturation Overflow Flag */
#define FGLB_FILT_STAT_TX_ECNT_OVL_MASK 0x2000
#define FGLB_FILT_STAT_TX_ECNT_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_TX_ECNT_OVL_MASK) >> 13)
#define FGLB_FILT_STAT_TX_ECNT_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 13, FGLB_FILT_STAT_TX_ECNT_OVL_MASK)
/** No Overflow */
#define TX_ECNT_OVL_NO_OVFL 0x0
/** Overflow */
#define TX_ECNT_OVL_OVFL 0x1

/** ECHO path Event Counter Saturation Overflow Flag */
#define FGLB_FILT_STAT_EC_ECNT_OVL_MASK 0x4000
#define FGLB_FILT_STAT_EC_ECNT_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_EC_ECNT_OVL_MASK) >> 14)
#define FGLB_FILT_STAT_EC_ECNT_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 14, FGLB_FILT_STAT_EC_ECNT_OVL_MASK)
/** No Overflow */
#define EC_ECNT_OVL_NO_OVFL 0x0
/** Overflow */
#define EC_ECNT_OVL_OVFL 0x1

/** RX Event Counter Saturation Overflow Flag */
#define FGLB_FILT_STAT_RX_ECNT_OVL_MASK 0x8000
#define FGLB_FILT_STAT_RX_ECNT_OVL_AFE_GET ((VR9_AfeRead(FGLB_FILT_STAT) & FGLB_FILT_STAT_RX_ECNT_OVL_MASK) >> 15)
#define FGLB_FILT_STAT_RX_ECNT_OVL_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_STAT, (val) << 15, FGLB_FILT_STAT_RX_ECNT_OVL_MASK)
/** No Overflow */
#define RX_ECNT_OVL_NO_OVFL 0x0
/** Overflow */
#define RX_ECNT_OVL_OVFL 0x1


/** Status/Interrupt Mask register of all filters in Transmit path - The interrupt mask register FILT_IMASK defines which of the interrupts are signalled to the controlling MCU. */
#define FGLB_FILT_IMASK (VINAX_AFE_DIG_FILT_CH0_BASE + 0xc)
#define FGLB_FILT_IMASK_AFE_GET VR9_AfeRead(FGLB_FILT_IMASK)
#define FGLB_FILT_IMASK_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val), 0xFFFF)

/** TX path Error Correction Overflow Flag */
#define FGLB_FILT_IMASK_TX_ERRC_OVLM_MASK 0x1
#define FGLB_FILT_IMASK_TX_ERRC_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_TX_ERRC_OVLM_MASK) >> 0)
#define FGLB_FILT_IMASK_TX_ERRC_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 0, FGLB_FILT_IMASK_TX_ERRC_OVLM_MASK)
/** enabled (default) */
#define TX_ERRC_OVLM_EN 0x0
/** disabled */
#define TX_ERRC_OVLM_DIS 0x1

/** TX BRWDF1 Filter Saturation Overflow Flag */
#define FGLB_FILT_IMASK_TX_BRWDF1_OVLM_MASK 0x2
#define FGLB_FILT_IMASK_TX_BRWDF1_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_TX_BRWDF1_OVLM_MASK) >> 1)
#define FGLB_FILT_IMASK_TX_BRWDF1_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 1, FGLB_FILT_IMASK_TX_BRWDF1_OVLM_MASK)
/** enabled (default) */
#define TX_BRWDF1_OVLM_EN 0x0
/** disabled */
#define TX_BRWDF1_OVLM_DIS 0x1

/** TX path Noise Shaper Saturation Overflow Flag */
#define FGLB_FILT_IMASK_TX_NSH_OVLM_MASK 0x4
#define FGLB_FILT_IMASK_TX_NSH_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_TX_NSH_OVLM_MASK) >> 2)
#define FGLB_FILT_IMASK_TX_NSH_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 2, FGLB_FILT_IMASK_TX_NSH_OVLM_MASK)
/** enabled (default) */
#define TX_NSH_OVLM_EN 0x0
/** disabled */
#define TX_NSH_OVLM_DIS 0x1

/** EC path Error Correction Overflow Flag */
#define FGLB_FILT_IMASK_EC_ERRC_OVLM_MASK 0x10
#define FGLB_FILT_IMASK_EC_ERRC_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_EC_ERRC_OVLM_MASK) >> 4)
#define FGLB_FILT_IMASK_EC_ERRC_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 4, FGLB_FILT_IMASK_EC_ERRC_OVLM_MASK)
/** enabled (default) */
#define EC_ERRC_OVLM_EN 0x0
/** disabled */
#define EC_ERRC_OVLM_DIS 0x1

/** EC BRWDF1 Filter Saturation Overflow Flag */
#define FGLB_FILT_IMASK_EC_BRWDF1_OVLM_MASK 0x20
#define FGLB_FILT_IMASK_EC_BRWDF1_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_EC_BRWDF1_OVLM_MASK) >> 5)
#define FGLB_FILT_IMASK_EC_BRWDF1_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 5, FGLB_FILT_IMASK_EC_BRWDF1_OVLM_MASK)
/** enabled (default) */
#define EC_BRWDF1_OVLM_EN 0x0
/** disabled */
#define EC_BRWDF1_OVLM_DIS 0x1

/** EC path Noise Shaper Saturation Overflow Flag */
#define FGLB_FILT_IMASK_EC_NSH_OVLM_MASK 0x40
#define FGLB_FILT_IMASK_EC_NSH_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_EC_NSH_OVLM_MASK) >> 6)
#define FGLB_FILT_IMASK_EC_NSH_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 6, FGLB_FILT_IMASK_EC_NSH_OVLM_MASK)
/** enabled (default) */
#define EC_NSH_OVLM_EN 0x0
/** disabled */
#define EC_NSH_OVLM_DIS 0x1

/** RX CLCMB1 Filter Saturation Overflow Flag */
#define FGLB_FILT_IMASK_RX_CMB1_OVLM_MASK 0x100
#define FGLB_FILT_IMASK_RX_CMB1_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_RX_CMB1_OVLM_MASK) >> 8)
#define FGLB_FILT_IMASK_RX_CMB1_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 8, FGLB_FILT_IMASK_RX_CMB1_OVLM_MASK)
/** enabled (default) */
#define RX_CMB1_OVLM_EN 0x0
/** disabled */
#define RX_CMB1_OVLM_DIS 0x1

/** RX BRWDF1 Filter Saturation Overflow Flag */
#define FGLB_FILT_IMASK_RX_BRWDF1_OVLM_MASK 0x200
#define FGLB_FILT_IMASK_RX_BRWDF1_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_RX_BRWDF1_OVLM_MASK) >> 9)
#define FGLB_FILT_IMASK_RX_BRWDF1_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 9, FGLB_FILT_IMASK_RX_BRWDF1_OVLM_MASK)
/** enabled (default) */
#define RX_BRWDF1_OVLM_EN 0x0
/** disabled */
#define RX_BRWDF1_OVLM_DIS 0x1

/** ADC Overload Flag */
#define FGLB_FILT_IMASK_ADC_OVLM_MASK 0x800
#define FGLB_FILT_IMASK_ADC_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_ADC_OVLM_MASK) >> 11)
#define FGLB_FILT_IMASK_ADC_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 11, FGLB_FILT_IMASK_ADC_OVLM_MASK)
/** enabled (default) */
#define ADC_OVLM_EN 0x0
/** disabled */
#define ADC_OVLM_DIS 0x1

/** TX Event Counter Saturation Overflow Flag */
#define FGLB_FILT_IMASK_TX_ECNT_OVLM_MASK 0x2000
#define FGLB_FILT_IMASK_TX_ECNT_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_TX_ECNT_OVLM_MASK) >> 13)
#define FGLB_FILT_IMASK_TX_ECNT_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 13, FGLB_FILT_IMASK_TX_ECNT_OVLM_MASK)
/** enabled (default) */
#define TX_ECNT_OVLM_EN 0x0
/** disabled */
#define TX_ECNT_OVLM_DIS 0x1

/** EC Event Counter Saturation Overflow Flag */
#define FGLB_FILT_IMASK_EC_ECNT_OVLM_MASK 0x4000
#define FGLB_FILT_IMASK_EC_ECNT_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_EC_ECNT_OVLM_MASK) >> 14)
#define FGLB_FILT_IMASK_EC_ECNT_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 14, FGLB_FILT_IMASK_EC_ECNT_OVLM_MASK)
/** enabled (default) */
#define EC_ECNT_OVLM_EN 0x0
/** disabled */
#define EC_ECNT_OVLM_DIS 0x1

/** RX Event Counter Saturation Overflow Flag */
#define FGLB_FILT_IMASK_RX_ECNT_OVLM_MASK 0x8000
#define FGLB_FILT_IMASK_RX_ECNT_OVLM_AFE_GET ((VR9_AfeRead(FGLB_FILT_IMASK) & FGLB_FILT_IMASK_RX_ECNT_OVLM_MASK) >> 15)
#define FGLB_FILT_IMASK_RX_ECNT_OVLM_AFE_SET(val) VR9_AfeWrite(FGLB_FILT_IMASK, (val) << 15, FGLB_FILT_IMASK_RX_ECNT_OVLM_MASK)
/** enabled (default) */
#define RX_ECNT_OVLM_EN 0x0
/** disabled */
#define RX_ECNT_OVLM_DIS 0x1


/** Event Counter of Transmit path - This registers gives the count of events(overflows) of the particular selected filter or filters in Transmit(TX) Path according to the control bit TX_OCNTRSEL bits in CTRL3 Register. The counter can be operated in wrap-around or saturation mode. In saturation mode, the register is reset to zero by a read access to this register. */
#define FGLB_TX_ECNT (VINAX_AFE_DIG_FILT_CH0_BASE + 0xd)
#define FGLB_TX_ECNT_AFE_GET VR9_AfeRead(FGLB_TX_ECNT)
#define FGLB_TX_ECNT_AFE_SET(val) VR9_AfeWrite(FGLB_TX_ECNT, (val), 0xFFFF)

/** Transmit Filters Overflow Counter - Number of Overflows */
#define FGLB_TX_ECNT_TX_ECNT_MASK 0xffff
#define FGLB_TX_ECNT_TX_ECNT_AFE_GET ((VR9_AfeRead(FGLB_TX_ECNT) & FGLB_TX_ECNT_TX_ECNT_MASK) >> 0)
#define FGLB_TX_ECNT_TX_ECNT_AFE_SET(val) VR9_AfeWrite(FGLB_TX_ECNT, (val) << 0, FGLB_TX_ECNT_TX_ECNT_MASK)


/** Event Counter of ECHO path - This registers gives the count of events(overflows) of the particular selected filter or all filters in ECHO(EC or TX2) Path according to the control bit EC_OCNTRSEL bits in CTRL3 Register. The counter can be operated in wrap-around or saturation mode. In saturation mode, the register is reset to zero by a read access to this register.  */
#define FGLB_EC_ECNT (VINAX_AFE_DIG_FILT_CH0_BASE + 0xe)
#define FGLB_EC_ECNT_AFE_GET VR9_AfeRead(FGLB_EC_ECNT)
#define FGLB_EC_ECNT_AFE_SET(val) VR9_AfeWrite(FGLB_EC_ECNT, (val), 0xFFFF)

/** Echo Filters Overflow Counter - Number of Overflows */
#define FGLB_EC_ECNT_EC_ECNT_MASK 0xffff
#define FGLB_EC_ECNT_EC_ECNT_AFE_GET ((VR9_AfeRead(FGLB_EC_ECNT) & FGLB_EC_ECNT_EC_ECNT_MASK) >> 0)
#define FGLB_EC_ECNT_EC_ECNT_AFE_SET(val) VR9_AfeWrite(FGLB_EC_ECNT, (val) << 0, FGLB_EC_ECNT_EC_ECNT_MASK)


/** Event Counter of Receive path - This registers gives the count of events(overflows) of the particular selected filter or filters in Receive(RX) Path according to the control bit RX_ECNTRSEL bits in CTRL3 Register. The counter can be operated in wrap-around or saturation mode. In saturation mode, the register is reset to zero by a read access to this register. */
#define FGLB_RX_ECNT (VINAX_AFE_DIG_FILT_CH0_BASE + 0xf)
#define FGLB_RX_ECNT_AFE_GET VR9_AfeRead(FGLB_RX_ECNT)
#define FGLB_RX_ECNT_AFE_SET(val) VR9_AfeWrite(FGLB_RX_ECNT, (val), 0xFFFF)

/** Receive Filters Overflow Counter - Number of Overflows */
#define FGLB_RX_ECNT_RX_ECNT_MASK 0xffff
#define FGLB_RX_ECNT_RX_ECNT_AFE_GET ((VR9_AfeRead(FGLB_RX_ECNT) & FGLB_RX_ECNT_RX_ECNT_MASK) >> 0)
#define FGLB_RX_ECNT_RX_ECNT_AFE_SET(val) VR9_AfeWrite(FGLB_RX_ECNT, (val) << 0, FGLB_RX_ECNT_RX_ECNT_MASK)


/** ADC Overflow Interrupt Counter - This registers gives the count of ADC overflows of the ADC.The counter can be operated in wrap-around or saturation mode.In saturation mode,the register is reset to zero by a read access to this register. */
#define FGLB_ADC_OCNT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x10)
#define FGLB_ADC_OCNT_AFE_GET VR9_AfeRead(FGLB_ADC_OCNT)
#define FGLB_ADC_OCNT_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_OCNT, (val), 0xFFFF)

/** ADC Overflow Counter - Counts Number of ADC Overflows */
#define FGLB_ADC_OCNT_ADC_OCNT_MASK 0xffff
#define FGLB_ADC_OCNT_ADC_OCNT_AFE_GET ((VR9_AfeRead(FGLB_ADC_OCNT) & FGLB_ADC_OCNT_ADC_OCNT_MASK) >> 0)
#define FGLB_ADC_OCNT_ADC_OCNT_AFE_SET(val) VR9_AfeWrite(FGLB_ADC_OCNT, (val) << 0, FGLB_ADC_OCNT_ADC_OCNT_MASK)


/** Control Register - This register controls the number of predecimal/fractional bits */
#define RXCMB1_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x11)
#define RXCMB1_CTRL_AFE_GET VR9_AfeRead(RXCMB1_CTRL)
#define RXCMB1_CTRL_AFE_SET(val) VR9_AfeWrite(RXCMB1_CTRL, (val), 0xFFFF)

/** Filter Enable - enables RXCMB1 Filter */
#define RXCMB1_CTRL_EN_MASK 0x1
#define RXCMB1_CTRL_EN_AFE_GET ((VR9_AfeRead(RXCMB1_CTRL) & RXCMB1_CTRL_EN_MASK) >> 0)
#define RXCMB1_CTRL_EN_AFE_SET(val) VR9_AfeWrite(RXCMB1_CTRL, (val) << 0, RXCMB1_CTRL_EN_MASK)
/** disabled (default) */
#define RXCMB1_CTRL_EN_DIS 0x0
/** enabled */
#define RXCMB1_CTRL_EN_EN 0x1

/** Filter Datapath Initialization - enables initialization of RXCMB1 Filter */
#define RXCMB1_CTRL_INIT_MASK 0x2
#define RXCMB1_CTRL_INIT_AFE_GET ((VR9_AfeRead(RXCMB1_CTRL) & RXCMB1_CTRL_INIT_MASK) >> 1)
#define RXCMB1_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(RXCMB1_CTRL, (val) << 1, RXCMB1_CTRL_INIT_MASK)
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Second Branch Cancellation logic - disables CL2 (2nd Branch) Cancellation Logic */
#define RXCMB1_CTRL_CL2_OFF_MASK 0x100
#define RXCMB1_CTRL_CL2_OFF_AFE_GET ((VR9_AfeRead(RXCMB1_CTRL) & RXCMB1_CTRL_CL2_OFF_MASK) >> 8)
#define RXCMB1_CTRL_CL2_OFF_AFE_SET(val) VR9_AfeWrite(RXCMB1_CTRL, (val) << 8, RXCMB1_CTRL_CL2_OFF_MASK)
/** enabled (default) */
#define CL2_OFF_EN 0x0
/** disabled */
#define CL2_OFF_DIS 0x1


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_0 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x12)
#define RXCMB1_COEFF_0_AFE_GET VR9_AfeRead(RXCMB1_COEFF_0)
#define RXCMB1_COEFF_0_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_0, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_0_COF_MASK 0x3ff
#define RXCMB1_COEFF_0_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_0) & RXCMB1_COEFF_0_COF_MASK) >> 0)
#define RXCMB1_COEFF_0_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_0, (val) << 0, RXCMB1_COEFF_0_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_0_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_0_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_1 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x13)
#define RXCMB1_COEFF_1_AFE_GET VR9_AfeRead(RXCMB1_COEFF_1)
#define RXCMB1_COEFF_1_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_1, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_1_COF_MASK 0x3ff
#define RXCMB1_COEFF_1_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_1) & RXCMB1_COEFF_1_COF_MASK) >> 0)
#define RXCMB1_COEFF_1_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_1, (val) << 0, RXCMB1_COEFF_1_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_1_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_1_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_2 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x14)
#define RXCMB1_COEFF_2_AFE_GET VR9_AfeRead(RXCMB1_COEFF_2)
#define RXCMB1_COEFF_2_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_2, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_2_COF_MASK 0x3ff
#define RXCMB1_COEFF_2_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_2) & RXCMB1_COEFF_2_COF_MASK) >> 0)
#define RXCMB1_COEFF_2_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_2, (val) << 0, RXCMB1_COEFF_2_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_2_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_2_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_3 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x15)
#define RXCMB1_COEFF_3_AFE_GET VR9_AfeRead(RXCMB1_COEFF_3)
#define RXCMB1_COEFF_3_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_3, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_3_COF_MASK 0x3ff
#define RXCMB1_COEFF_3_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_3) & RXCMB1_COEFF_3_COF_MASK) >> 0)
#define RXCMB1_COEFF_3_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_3, (val) << 0, RXCMB1_COEFF_3_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_3_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_3_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_4 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x16)
#define RXCMB1_COEFF_4_AFE_GET VR9_AfeRead(RXCMB1_COEFF_4)
#define RXCMB1_COEFF_4_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_4, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_4_COF_MASK 0x3ff
#define RXCMB1_COEFF_4_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_4) & RXCMB1_COEFF_4_COF_MASK) >> 0)
#define RXCMB1_COEFF_4_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_4, (val) << 0, RXCMB1_COEFF_4_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_4_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_4_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_5 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x17)
#define RXCMB1_COEFF_5_AFE_GET VR9_AfeRead(RXCMB1_COEFF_5)
#define RXCMB1_COEFF_5_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_5, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_5_COF_MASK 0x3ff
#define RXCMB1_COEFF_5_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_5) & RXCMB1_COEFF_5_COF_MASK) >> 0)
#define RXCMB1_COEFF_5_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_5, (val) << 0, RXCMB1_COEFF_5_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_5_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_5_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_6 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x18)
#define RXCMB1_COEFF_6_AFE_GET VR9_AfeRead(RXCMB1_COEFF_6)
#define RXCMB1_COEFF_6_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_6, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_6_COF_MASK 0x3ff
#define RXCMB1_COEFF_6_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_6) & RXCMB1_COEFF_6_COF_MASK) >> 0)
#define RXCMB1_COEFF_6_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_6, (val) << 0, RXCMB1_COEFF_6_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_6_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_6_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_7 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x19)
#define RXCMB1_COEFF_7_AFE_GET VR9_AfeRead(RXCMB1_COEFF_7)
#define RXCMB1_COEFF_7_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_7, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_7_COF_MASK 0x3ff
#define RXCMB1_COEFF_7_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_7) & RXCMB1_COEFF_7_COF_MASK) >> 0)
#define RXCMB1_COEFF_7_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_7, (val) << 0, RXCMB1_COEFF_7_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_7_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_7_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_8 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x1a)
#define RXCMB1_COEFF_8_AFE_GET VR9_AfeRead(RXCMB1_COEFF_8)
#define RXCMB1_COEFF_8_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_8, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_8_COF_MASK 0x3ff
#define RXCMB1_COEFF_8_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_8) & RXCMB1_COEFF_8_COF_MASK) >> 0)
#define RXCMB1_COEFF_8_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_8, (val) << 0, RXCMB1_COEFF_8_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_8_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_8_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_9 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x1b)
#define RXCMB1_COEFF_9_AFE_GET VR9_AfeRead(RXCMB1_COEFF_9)
#define RXCMB1_COEFF_9_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_9, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_9_COF_MASK 0x3ff
#define RXCMB1_COEFF_9_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_9) & RXCMB1_COEFF_9_COF_MASK) >> 0)
#define RXCMB1_COEFF_9_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_9, (val) << 0, RXCMB1_COEFF_9_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_9_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_9_COF_MAX 0x3ff


/** Coefficient Register - RX CLCMB1 H20,H21 programmable subfilter coefficients */
#define RXCMB1_COEFF_10 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x1c)
#define RXCMB1_COEFF_10_AFE_GET VR9_AfeRead(RXCMB1_COEFF_10)
#define RXCMB1_COEFF_10_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_10, (val), 0xFFFF)

/** coefficient value - RX CLCMB1 programmable subfilter coefficients */
#define RXCMB1_COEFF_10_COF_MASK 0x3ff
#define RXCMB1_COEFF_10_COF_AFE_GET ((VR9_AfeRead(RXCMB1_COEFF_10) & RXCMB1_COEFF_10_COF_MASK) >> 0)
#define RXCMB1_COEFF_10_COF_AFE_SET(val) VR9_AfeWrite(RXCMB1_COEFF_10, (val) << 0, RXCMB1_COEFF_10_COF_MASK)
/** minimum value (default) */
#define RXCMB1_COEFF_10_COF_MIN 0x0
/** maximum value */
#define RXCMB1_COEFF_10_COF_MAX 0x3ff


/** Status Register - This register shows the status of the WLSat Overflow */
#define RXCMB1_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x1d)
#define RXCMB1_STAT_AFE_GET VR9_AfeRead(RXCMB1_STAT)
#define RXCMB1_STAT_AFE_SET(val) VR9_AfeWrite(RXCMB1_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define RXCMB1_STAT_OVL_MASK 0x1
#define RXCMB1_STAT_OVL_AFE_GET ((VR9_AfeRead(RXCMB1_STAT) & RXCMB1_STAT_OVL_MASK) >> 0)
#define RXCMB1_STAT_OVL_AFE_SET(val) VR9_AfeWrite(RXCMB1_STAT, (val) << 0, RXCMB1_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Control Register - This register controls the filter Enable, initialization and bypass */
#define RXBRWDF1_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x1e)
#define RXBRWDF1_CTRL_AFE_GET VR9_AfeRead(RXBRWDF1_CTRL)
#define RXBRWDF1_CTRL_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_CTRL, (val), 0xFFFF)

/** Filter Enable - enables RX BRWDF1 Filter */
#define RXBRWDF1_CTRL_EN_MASK 0x1
#define RXBRWDF1_CTRL_EN_AFE_GET ((VR9_AfeRead(RXBRWDF1_CTRL) & RXBRWDF1_CTRL_EN_MASK) >> 0)
#define RXBRWDF1_CTRL_EN_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_CTRL, (val) << 0, RXBRWDF1_CTRL_EN_MASK)
/** disabled (default) */
#define RXBRWDF1_CTRL_EN_DIS 0x0
/** enabled */
#define RXBRWDF1_CTRL_EN_EN 0x1

/** Filter Datapath Initialization - enables initialization of RX BRWDF1 Filter */
#define RXBRWDF1_CTRL_INIT_MASK 0x2
#define RXBRWDF1_CTRL_INIT_AFE_GET ((VR9_AfeRead(RXBRWDF1_CTRL) & RXBRWDF1_CTRL_INIT_MASK) >> 1)
#define RXBRWDF1_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_CTRL, (val) << 1, RXBRWDF1_CTRL_INIT_MASK)
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Filter Bypass - RX BRWDF1 Filter Bypass Mode */
#define RXBRWDF1_CTRL_BYP_MASK 0x30
#define RXBRWDF1_CTRL_BYP_AFE_GET ((VR9_AfeRead(RXBRWDF1_CTRL) & RXBRWDF1_CTRL_BYP_MASK) >> 4)
#define RXBRWDF1_CTRL_BYP_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_CTRL, (val) << 4, RXBRWDF1_CTRL_BYP_MASK)
/** decimators and filters are not bypassed (default) */
#define BYP_NO_BYP 0x0
/** Polyphase 0 is selected */
#define BYP_POLY0 0x1
/** Polyphase 1 is selected */
#define BYP_POLY1 0x2
/** decimators and filters are bypassed */
#define BYP_BYP 0x3

/** Filter Autoreset Enable - Resets the filter upon internal detection of an overflow */
#define RXBRWDF1_CTRL_AREN_MASK 0x100
#define RXBRWDF1_CTRL_AREN_AFE_GET ((VR9_AfeRead(RXBRWDF1_CTRL) & RXBRWDF1_CTRL_AREN_MASK) >> 8)
#define RXBRWDF1_CTRL_AREN_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_CTRL, (val) << 8, RXBRWDF1_CTRL_AREN_MASK)
/** disabled */
#define AREN_DIS 0x0
/** enabled (default) */
#define AREN_EN 0x1


/** Coefficient G1 Register - RX WDF1 programmable adaptor G1 coefficient */
#define RXBRWDF1_COEFF_G1 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x1f)
#define RXBRWDF1_COEFF_G1_AFE_GET VR9_AfeRead(RXBRWDF1_COEFF_G1)
#define RXBRWDF1_COEFF_G1_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_COEFF_G1, (val), 0xFFFF)

/** coefficient value - RX WDF1 programmable adaptor G1 coefficient */
#define RXBRWDF1_COEFF_G1_COF_MASK 0x1ff
#define RXBRWDF1_COEFF_G1_COF_AFE_GET ((VR9_AfeRead(RXBRWDF1_COEFF_G1) & RXBRWDF1_COEFF_G1_COF_MASK) >> 0)
#define RXBRWDF1_COEFF_G1_COF_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_COEFF_G1, (val) << 0, RXBRWDF1_COEFF_G1_COF_MASK)
/** minimum value */
#define RXBRWDF1_G1_COF_MIN 0x0
/** startup value (default) */
#define RXBRWDF1_G1_COF_START 0x47
/** maximum value */
#define RXBRWDF1_G1_COF_MAX 0x1ff


/** Coefficient G3 Register - RX WDF1 programmable adaptor G3 coefficient */
#define RXBRWDF1_COEFF_G3 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x20)
#define RXBRWDF1_COEFF_G3_AFE_GET VR9_AfeRead(RXBRWDF1_COEFF_G3)
#define RXBRWDF1_COEFF_G3_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_COEFF_G3, (val), 0xFFFF)

/** coefficient value - RX WDF1 programmable adaptor G3 coefficient */
#define RXBRWDF1_COEFF_G3_COF_MASK 0x1ff
#define RXBRWDF1_COEFF_G3_COF_AFE_GET ((VR9_AfeRead(RXBRWDF1_COEFF_G3) & RXBRWDF1_COEFF_G3_COF_MASK) >> 0)
#define RXBRWDF1_COEFF_G3_COF_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_COEFF_G3, (val) << 0, RXBRWDF1_COEFF_G3_COF_MASK)
/** minimum value (default) */
#define RXBRWDF1_G3_COF_MIN 0x0
/** startup value (default) */
#define RXBRWDF1_G3_COF_START 0x12c
/** maximum value */
#define RXBRWDF1_G3_COF_MAX 0x1ff


/** Status Register - This register shows the status of the WLSat Overflow */
#define RXBRWDF1_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x21)
#define RXBRWDF1_STAT_AFE_GET VR9_AfeRead(RXBRWDF1_STAT)
#define RXBRWDF1_STAT_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define RXBRWDF1_STAT_OVL_MASK 0x1
#define RXBRWDF1_STAT_OVL_AFE_GET ((VR9_AfeRead(RXBRWDF1_STAT) & RXBRWDF1_STAT_OVL_MASK) >> 0)
#define RXBRWDF1_STAT_OVL_AFE_SET(val) VR9_AfeWrite(RXBRWDF1_STAT, (val) << 0, RXBRWDF1_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Control Register - This register controls the ADC Testing initialization  */
#define RXADCT_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x22)
#define RXADCT_CTRL_AFE_GET VR9_AfeRead(RXADCT_CTRL)
#define RXADCT_CTRL_AFE_SET(val) VR9_AfeWrite(RXADCT_CTRL, (val), 0xFFFF)

/** Filter Enable - enables RX ADC Testing */
#define RXADCT_CTRL_EN_MASK 0x1
#define RXADCT_CTRL_EN_AFE_GET ((VR9_AfeRead(RXADCT_CTRL) & RXADCT_CTRL_EN_MASK) >> 0)
#define RXADCT_CTRL_EN_AFE_SET(val) VR9_AfeWrite(RXADCT_CTRL, (val) << 0, RXADCT_CTRL_EN_MASK)
/** disabled (default) */
#define RXADCT_CTRL_EN_DIS 0x0
/** enabled */
#define RXADCT_CTRL_EN_EN 0x1

/** Datapath Initialization - enables initialization of RX ADC Testing */
#define RXADCT_CTRL_INIT_MASK 0x2
#define RXADCT_CTRL_INIT_AFE_GET ((VR9_AfeRead(RXADCT_CTRL) & RXADCT_CTRL_INIT_MASK) >> 1)
#define RXADCT_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(RXADCT_CTRL, (val) << 1, RXADCT_CTRL_INIT_MASK)
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Filter Enable - stage selection for RX ADC Testing */
#define RXADCT_CTRL_STAGE_SEL_MASK 0x300
#define RXADCT_CTRL_STAGE_SEL_AFE_GET ((VR9_AfeRead(RXADCT_CTRL) & RXADCT_CTRL_STAGE_SEL_MASK) >> 8)
#define RXADCT_CTRL_STAGE_SEL_AFE_SET(val) VR9_AfeWrite(RXADCT_CTRL, (val) << 8, RXADCT_CTRL_STAGE_SEL_MASK)
/** 8 bits from stage 1 selected (default) */
#define STAGE_SEL_STG1 0x0
/** 8 bits from stage 2 selected */
#define STAGE_SEL_STG2 0x1
/** 16 bits from stage 1 and 2 are selected (only for ADC Clock 288Mhz) */
#define STAGE_SEL_STG12 0x2

/** Testing Data Selection Flag - Testing data selection to 3GLP Interface */
#define RXADCT_CTRL_TEST_DSEL_MASK 0x400
#define RXADCT_CTRL_TEST_DSEL_AFE_GET ((VR9_AfeRead(RXADCT_CTRL) & RXADCT_CTRL_TEST_DSEL_MASK) >> 10)
#define RXADCT_CTRL_TEST_DSEL_AFE_SET(val) VR9_AfeWrite(RXADCT_CTRL, (val) << 10, RXADCT_CTRL_TEST_DSEL_MASK)
/** RX BRWDF filter data to 3GLP Interface (default) */
#define TEST_DSEL_BRWDF 0x0
/** RX ADC Test data to 3GLP Interface */
#define TEST_DSEL_ADC 0x0


/** Control Register - This register controls the TX 3GLP Error correction Filter */
#define TX1ERRC_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x23)
#define TX1ERRC_CTRL_AFE_GET VR9_AfeRead(TX1ERRC_CTRL)
#define TX1ERRC_CTRL_AFE_SET(val) VR9_AfeWrite(TX1ERRC_CTRL, (val), 0xFFFF)

/** Error correction Enable - enables TX Error Correction */
#define TX1ERRC_CTRL_EN_MASK 0x1
#define TX1ERRC_CTRL_EN_AFE_GET ((VR9_AfeRead(TX1ERRC_CTRL) & TX1ERRC_CTRL_EN_MASK) >> 0)
#define TX1ERRC_CTRL_EN_AFE_SET(val) VR9_AfeWrite(TX1ERRC_CTRL, (val) << 0, TX1ERRC_CTRL_EN_MASK)
/** disabled (default) */
#define TX1ERRC_CTRL_EN_DIS 0x0
/** enabled */
#define TX1ERRC_CTRL_EN_EN 0x1

/** Initialization of Error Correction - enables initialization of TX Error Correction */
#define TX1ERRC_CTRL_INIT_MASK 0x2
#define TX1ERRC_CTRL_INIT_AFE_GET ((VR9_AfeRead(TX1ERRC_CTRL) & TX1ERRC_CTRL_INIT_MASK) >> 1)
#define TX1ERRC_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(TX1ERRC_CTRL, (val) << 1, TX1ERRC_CTRL_INIT_MASK)
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Filter Bypass - enables TX 3GLP Error Correction Bypass */
#define TX1ERRC_CTRL_BYP_MASK 0x10
#define TX1ERRC_CTRL_BYP_AFE_GET ((VR9_AfeRead(TX1ERRC_CTRL) & TX1ERRC_CTRL_BYP_MASK) >> 4)
#define TX1ERRC_CTRL_BYP_AFE_SET(val) VR9_AfeWrite(TX1ERRC_CTRL, (val) << 4, TX1ERRC_CTRL_BYP_MASK)
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1


/** Error Detection Control Register - This register controls the TX 3GLP Parity Error detections in Error Correction Filter */
#define TX1ERRC_ERRD_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x24)
#define TX1ERRC_ERRD_CTRL_AFE_GET VR9_AfeRead(TX1ERRC_ERRD_CTRL)
#define TX1ERRC_ERRD_CTRL_AFE_SET(val) VR9_AfeWrite(TX1ERRC_ERRD_CTRL, (val), 0xFFFF)

/** MSB Parity Error Detection Enable - enables MSB (3 bits) parity Error Detection */
#define TX1ERRC_ERRD_CTRL_MSB_ERRD_EN_MASK 0x1
#define TX1ERRC_ERRD_CTRL_MSB_ERRD_EN_AFE_GET ((VR9_AfeRead(TX1ERRC_ERRD_CTRL) & TX1ERRC_ERRD_CTRL_MSB_ERRD_EN_MASK) >> 0)
#define TX1ERRC_ERRD_CTRL_MSB_ERRD_EN_AFE_SET(val) VR9_AfeWrite(TX1ERRC_ERRD_CTRL, (val) << 0, TX1ERRC_ERRD_CTRL_MSB_ERRD_EN_MASK)
/** disabled */
#define MSB_ERRD_EN_DIS 0x0
/** enabled (default) */
#define MSB_ERRD_EN_EN 0x1

/** Selecting the source for Parity Error Detection - selects source of the Parity Error Detection  */
#define TX1ERRC_ERRD_CTRL_PERR_SEL_MASK 0x10
#define TX1ERRC_ERRD_CTRL_PERR_SEL_AFE_GET ((VR9_AfeRead(TX1ERRC_ERRD_CTRL) & TX1ERRC_ERRD_CTRL_PERR_SEL_MASK) >> 4)
#define TX1ERRC_ERRD_CTRL_PERR_SEL_AFE_SET(val) VR9_AfeWrite(TX1ERRC_ERRD_CTRL, (val) << 4, TX1ERRC_ERRD_CTRL_PERR_SEL_MASK)
/** MSB parity error and normal parity error (default) */
#define PERR_SEL_MSB_NOR 0x0
/** Only MSB parity error */
#define PERR_SEL_MSB_ONLY 0x1

/** Selecting Type of Parity Errors Detected for Event Counter - selects source for Parity Error Event Counter */
#define TX1ERRC_ERRD_CTRL_ERRD_SEL_MASK 0x300
#define TX1ERRC_ERRD_CTRL_ERRD_SEL_AFE_GET ((VR9_AfeRead(TX1ERRC_ERRD_CTRL) & TX1ERRC_ERRD_CTRL_ERRD_SEL_MASK) >> 8)
#define TX1ERRC_ERRD_CTRL_ERRD_SEL_AFE_SET(val) VR9_AfeWrite(TX1ERRC_ERRD_CTRL, (val) << 8, TX1ERRC_ERRD_CTRL_ERRD_SEL_MASK)
/** Single (default) */
#define ERRD_SEL_SING 0x0
/** Double */
#define ERRD_SEL_DOUB 0x1
/** Triple */
#define ERRD_SEL_TRIP 0x2
/** Quadruple */
#define ERRD_SEL_QUAD 0x3


/** Status Register - This register shows the status of the WLSat Overflow */
#define TX1ERRC_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x25)
#define TX1ERRC_STAT_AFE_GET VR9_AfeRead(TX1ERRC_STAT)
#define TX1ERRC_STAT_AFE_SET(val) VR9_AfeWrite(TX1ERRC_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define TX1ERRC_STAT_OVL_MASK 0x1
#define TX1ERRC_STAT_OVL_AFE_GET ((VR9_AfeRead(TX1ERRC_STAT) & TX1ERRC_STAT_OVL_MASK) >> 0)
#define TX1ERRC_STAT_OVL_AFE_SET(val) VR9_AfeWrite(TX1ERRC_STAT, (val) << 0, TX1ERRC_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Control Register - This register controls the TX BRWDF1 filter */
#define TX1BRWDF1_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x26)
#define TX1BRWDF1_CTRL_AFE_GET VR9_AfeRead(TX1BRWDF1_CTRL)
#define TX1BRWDF1_CTRL_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_CTRL, (val), 0xFFFF)

/** Filter Enable - enables TX BRWDF1 Filter */
#define TX1BRWDF1_CTRL_EN_MASK 0x1
#define TX1BRWDF1_CTRL_EN_AFE_GET ((VR9_AfeRead(TX1BRWDF1_CTRL) & TX1BRWDF1_CTRL_EN_MASK) >> 0)
#define TX1BRWDF1_CTRL_EN_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_CTRL, (val) << 0, TX1BRWDF1_CTRL_EN_MASK)
/** disabled (default) */
#define TX1BRWDF1_CTRL_EN_DIS 0x0
/** enabled */
#define TX1BRWDF1_CTRL_EN_EN 0x1

/** Filter Initialization of BRWDF Filter - enables initialization of TX BRWDF1 Filter */
#define TX1BRWDF1_CTRL_INIT_MASK 0x2
#define TX1BRWDF1_CTRL_INIT_AFE_GET ((VR9_AfeRead(TX1BRWDF1_CTRL) & TX1BRWDF1_CTRL_INIT_MASK) >> 1)
#define TX1BRWDF1_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_CTRL, (val) << 1, TX1BRWDF1_CTRL_INIT_MASK)
/** disabled */
#define INIT_OFF 0x0
/** enabled (default) */
#define INIT_ON 0x1

/** Filter Bypass - enables TX BRWDF1 Filter Bypass */
#define TX1BRWDF1_CTRL_BYP_MASK 0x10
#define TX1BRWDF1_CTRL_BYP_AFE_GET ((VR9_AfeRead(TX1BRWDF1_CTRL) & TX1BRWDF1_CTRL_BYP_MASK) >> 4)
#define TX1BRWDF1_CTRL_BYP_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_CTRL, (val) << 4, TX1BRWDF1_CTRL_BYP_MASK)
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1

/** Filter Autoreset Enable - resets the filter upon internal detection of an overflow of the adaptors */
#define TX1BRWDF1_CTRL_AREN_MASK 0x100
#define TX1BRWDF1_CTRL_AREN_AFE_GET ((VR9_AfeRead(TX1BRWDF1_CTRL) & TX1BRWDF1_CTRL_AREN_MASK) >> 8)
#define TX1BRWDF1_CTRL_AREN_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_CTRL, (val) << 8, TX1BRWDF1_CTRL_AREN_MASK)
/** disabled */
#define AREN_DIS 0x0
/** enabled (default) */
#define AREN_EN 0x1

/** Interpolation Factor - controls Interpolation Factor */
#define TX1BRWDF1_CTRL_INTP_FACT_MASK 0x1000
#define TX1BRWDF1_CTRL_INTP_FACT_AFE_GET ((VR9_AfeRead(TX1BRWDF1_CTRL) & TX1BRWDF1_CTRL_INTP_FACT_MASK) >> 12)
#define TX1BRWDF1_CTRL_INTP_FACT_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_CTRL, (val) << 12, TX1BRWDF1_CTRL_INTP_FACT_MASK)
/** factor 1.5 (default) */
#define INTP_FACT_F15 0x0
/** factor 2.0 */
#define INTP_FACT_F20 0x1


/** Coefficient G01 Register - TX WDF1 programmable coefficient 1 in polyphase 0 */
#define TX1BRWDF1_COEFF_G01 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x27)
#define TX1BRWDF1_COEFF_G01_AFE_GET VR9_AfeRead(TX1BRWDF1_COEFF_G01)
#define TX1BRWDF1_COEFF_G01_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G01, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G01 coefficient */
#define TX1BRWDF1_COEFF_G01_COF_MASK 0x1ff
#define TX1BRWDF1_COEFF_G01_COF_AFE_GET ((VR9_AfeRead(TX1BRWDF1_COEFF_G01) & TX1BRWDF1_COEFF_G01_COF_MASK) >> 0)
#define TX1BRWDF1_COEFF_G01_COF_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G01, (val) << 0, TX1BRWDF1_COEFF_G01_COF_MASK)
/** minimum value */
#define TX1BRWDF1_G01_COF_MIN 0x0
/** startup value (default) */
#define TX1BRWDF1_G01_COF_START 0x20
/** maximum value */
#define TX1BRWDF1_G01_COF_MAX 0x1ff


/** Coefficient G02 Register - TX WDF1 programmable coefficient 2 in polyphase 0 */
#define TX1BRWDF1_COEFF_G02 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x28)
#define TX1BRWDF1_COEFF_G02_AFE_GET VR9_AfeRead(TX1BRWDF1_COEFF_G02)
#define TX1BRWDF1_COEFF_G02_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G02, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G02 coefficient */
#define TX1BRWDF1_COEFF_G02_COF_MASK 0x1ff
#define TX1BRWDF1_COEFF_G02_COF_AFE_GET ((VR9_AfeRead(TX1BRWDF1_COEFF_G02) & TX1BRWDF1_COEFF_G02_COF_MASK) >> 0)
#define TX1BRWDF1_COEFF_G02_COF_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G02, (val) << 0, TX1BRWDF1_COEFF_G02_COF_MASK)
/** minimum value */
#define TX1BRWDF1_G02_COF_MIN 0x0
/** startup value (default) */
#define TX1BRWDF1_G02_COF_START 0x17c
/** maximum value */
#define TX1BRWDF1_G02_COF_MAX 0x1ff


/** Coefficient G11 Register - TX WDF1 programmable coefficient 1 in polyphase 1 */
#define TX1BRWDF1_COEFF_G11 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x29)
#define TX1BRWDF1_COEFF_G11_AFE_GET VR9_AfeRead(TX1BRWDF1_COEFF_G11)
#define TX1BRWDF1_COEFF_G11_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G11, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G11 coefficient */
#define TX1BRWDF1_COEFF_G11_COF_MASK 0x1ff
#define TX1BRWDF1_COEFF_G11_COF_AFE_GET ((VR9_AfeRead(TX1BRWDF1_COEFF_G11) & TX1BRWDF1_COEFF_G11_COF_MASK) >> 0)
#define TX1BRWDF1_COEFF_G11_COF_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G11, (val) << 0, TX1BRWDF1_COEFF_G11_COF_MASK)
/** minimum value */
#define TX1BRWDF1_G11_COF_MIN 0x0
/** startup value (default) */
#define TX1BRWDF1_G11_COF_START 0x5c
/** maximum value */
#define TX1BRWDF1_G11_COF_MAX 0x1ff


/** Coefficient G21 Register - TX WDF1 programmable coefficient 1 in polyphase 2 */
#define TX1BRWDF1_COEFF_G21 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x2a)
#define TX1BRWDF1_COEFF_G21_AFE_GET VR9_AfeRead(TX1BRWDF1_COEFF_G21)
#define TX1BRWDF1_COEFF_G21_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G21, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G21 coefficient */
#define TX1BRWDF1_COEFF_G21_COF_MASK 0x1ff
#define TX1BRWDF1_COEFF_G21_COF_AFE_GET ((VR9_AfeRead(TX1BRWDF1_COEFF_G21) & TX1BRWDF1_COEFF_G21_COF_MASK) >> 0)
#define TX1BRWDF1_COEFF_G21_COF_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_COEFF_G21, (val) << 0, TX1BRWDF1_COEFF_G21_COF_MASK)
/** minimum value */
#define TX1BRWDF1_G21_COF_MIN 0x0
/** startup value (default) */
#define TX1BRWDF1_G21_COF_START 0xf0
/** maximum value */
#define TX1BRWDF1_G21_COF_MAX 0x1ff


/** Status Register - This register shows the status of the WLSat Overflow */
#define TX1BRWDF1_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x2b)
#define TX1BRWDF1_STAT_AFE_GET VR9_AfeRead(TX1BRWDF1_STAT)
#define TX1BRWDF1_STAT_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define TX1BRWDF1_STAT_OVL_MASK 0x1
#define TX1BRWDF1_STAT_OVL_AFE_GET ((VR9_AfeRead(TX1BRWDF1_STAT) & TX1BRWDF1_STAT_OVL_MASK) >> 0)
#define TX1BRWDF1_STAT_OVL_AFE_SET(val) VR9_AfeWrite(TX1BRWDF1_STAT, (val) << 0, TX1BRWDF1_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Control Register - This register controls the TX Noise Shaper Filter */
#define TX1NSH_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x2c)
#define TX1NSH_CTRL_AFE_GET VR9_AfeRead(TX1NSH_CTRL)
#define TX1NSH_CTRL_AFE_SET(val) VR9_AfeWrite(TX1NSH_CTRL, (val), 0xFFFF)

/** Filter Enable - enables TX Noise Shaper */
#define TX1NSH_CTRL_EN_MASK 0x1
#define TX1NSH_CTRL_EN_AFE_GET ((VR9_AfeRead(TX1NSH_CTRL) & TX1NSH_CTRL_EN_MASK) >> 0)
#define TX1NSH_CTRL_EN_AFE_SET(val) VR9_AfeWrite(TX1NSH_CTRL, (val) << 0, TX1NSH_CTRL_EN_MASK)
/** disabled (default) */
#define TX1NSH_CTRL_EN_DIS 0x0
/** enabled */
#define TX1NSH_CTRL_EN_EN 0x1

/** Filter Datapath Initialization - enables initialization of TX Noise Shaper */
#define TX1NSH_CTRL_INIT_MASK 0x2
#define TX1NSH_CTRL_INIT_AFE_GET ((VR9_AfeRead(TX1NSH_CTRL) & TX1NSH_CTRL_INIT_MASK) >> 1)
#define TX1NSH_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(TX1NSH_CTRL, (val) << 1, TX1NSH_CTRL_INIT_MASK)
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Filter Bypass - enables TX Noise Shaper Filter Bypass */
#define TX1NSH_CTRL_BYP_MASK 0x10
#define TX1NSH_CTRL_BYP_AFE_GET ((VR9_AfeRead(TX1NSH_CTRL) & TX1NSH_CTRL_BYP_MASK) >> 4)
#define TX1NSH_CTRL_BYP_AFE_SET(val) VR9_AfeWrite(TX1NSH_CTRL, (val) << 4, TX1NSH_CTRL_BYP_MASK)
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1

/** Order Selection - selects TX Noiseshaper Order */
#define TX1NSH_CTRL_ORD_MASK 0x100
#define TX1NSH_CTRL_ORD_AFE_GET ((VR9_AfeRead(TX1NSH_CTRL) & TX1NSH_CTRL_ORD_MASK) >> 8)
#define TX1NSH_CTRL_ORD_AFE_SET(val) VR9_AfeWrite(TX1NSH_CTRL, (val) << 8, TX1NSH_CTRL_ORD_MASK)
/** First order (default) */
#define ORD_1ST 0x0
/** Second Order */
#define ORD_2ND 0x1

/** Output Bitwidth - selects TX Noise Shaper Output Bitwidth */
#define TX1NSH_CTRL_OBWIDTH_MASK 0x200
#define TX1NSH_CTRL_OBWIDTH_AFE_GET ((VR9_AfeRead(TX1NSH_CTRL) & TX1NSH_CTRL_OBWIDTH_MASK) >> 9)
#define TX1NSH_CTRL_OBWIDTH_AFE_SET(val) VR9_AfeWrite(TX1NSH_CTRL, (val) << 9, TX1NSH_CTRL_OBWIDTH_MASK)
/** 13 bits (default) */
#define OBWIDTH_13B 0x0
/** 8 bits */
#define OBWIDTH_8B 0x1


/** Status Register - This register shows the status of the WLSat Overflow */
#define TX1NSH_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x2d)
#define TX1NSH_STAT_AFE_GET VR9_AfeRead(TX1NSH_STAT)
#define TX1NSH_STAT_AFE_SET(val) VR9_AfeWrite(TX1NSH_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define TX1NSH_STAT_OVL_MASK 0x1
#define TX1NSH_STAT_OVL_AFE_GET ((VR9_AfeRead(TX1NSH_STAT) & TX1NSH_STAT_OVL_MASK) >> 0)
#define TX1NSH_STAT_OVL_AFE_SET(val) VR9_AfeWrite(TX1NSH_STAT, (val) << 0, TX1NSH_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Control Register - This register controls the EC 3GLP Error correction Filter */
#define TX2ERRXC_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x2e)
#define TX2ERRXC_CTRL_AFE_GET VR9_AfeRead(TX2ERRXC_CTRL)
#define TX2ERRXC_CTRL_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_CTRL, (val), 0xFFFF)

/** Error correction Enable - enables EC Error Correction */
#define TX2ERRXC_CTRL_EN_MASK 0x1
#define TX2ERRXC_CTRL_EN_AFE_GET ((VR9_AfeRead(TX2ERRXC_CTRL) & TX2ERRXC_CTRL_EN_MASK) >> 0)
#define TX2ERRXC_CTRL_EN_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_CTRL, (val) << 0, TX2ERRXC_CTRL_EN_MASK)
/** disabled (default) */
#define TX2ERRXC_CTRL_EN_DIS 0x0
/** enabled */
#define TX2ERRXC_CTRL_EN_EN 0x1

/** Initialization of Error Correction - enables initialization of EC Error Correction */
#define TX2ERRXC_CTRL_INIT_MASK 0x2
#define TX2ERRXC_CTRL_INIT_AFE_GET ((VR9_AfeRead(TX2ERRXC_CTRL) & TX2ERRXC_CTRL_INIT_MASK) >> 1)
#define TX2ERRXC_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_CTRL, (val) << 1, TX2ERRXC_CTRL_INIT_MASK)
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Filter Bypass - enables EC 3GLP Error Correction Bypass */
#define TX2ERRXC_CTRL_BYP_MASK 0x10
#define TX2ERRXC_CTRL_BYP_AFE_GET ((VR9_AfeRead(TX2ERRXC_CTRL) & TX2ERRXC_CTRL_BYP_MASK) >> 4)
#define TX2ERRXC_CTRL_BYP_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_CTRL, (val) << 4, TX2ERRXC_CTRL_BYP_MASK)
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1


/** Error Detection Control Register - This register controls the EC 3GLP Parity Error detections in Error Correction Filter */
#define TX2ERRXC_ERRD_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x2f)
#define TX2ERRXC_ERRD_CTRL_AFE_GET VR9_AfeRead(TX2ERRXC_ERRD_CTRL)
#define TX2ERRXC_ERRD_CTRL_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_ERRD_CTRL, (val), 0xFFFF)

/** MSB Parity Error Detection Enable - enables MSB (3 bits) parity Error Detection */
#define TX2ERRXC_ERRD_CTRL_MSB_ERRD_EN_MASK 0x1
#define TX2ERRXC_ERRD_CTRL_MSB_ERRD_EN_AFE_GET ((VR9_AfeRead(TX2ERRXC_ERRD_CTRL) & TX2ERRXC_ERRD_CTRL_MSB_ERRD_EN_MASK) >> 0)
#define TX2ERRXC_ERRD_CTRL_MSB_ERRD_EN_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_ERRD_CTRL, (val) << 0, TX2ERRXC_ERRD_CTRL_MSB_ERRD_EN_MASK)
/** disabled */
#define MSB_ERRD_EN_DIS 0x0
/** enabled (default) */
#define MSB_ERRD_EN_EN 0x1

/** Selecting the source for Parity Error Detection - selects source of the Parity Error Detection  */
#define TX2ERRXC_ERRD_CTRL_PERR_SEL_MASK 0x10
#define TX2ERRXC_ERRD_CTRL_PERR_SEL_AFE_GET ((VR9_AfeRead(TX2ERRXC_ERRD_CTRL) & TX2ERRXC_ERRD_CTRL_PERR_SEL_MASK) >> 4)
#define TX2ERRXC_ERRD_CTRL_PERR_SEL_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_ERRD_CTRL, (val) << 4, TX2ERRXC_ERRD_CTRL_PERR_SEL_MASK)
/** MSB parity error and normal parity error (default) */
#define PERR_SEL_MSB_NOR 0x0
/** Only MSB parity error */
#define PERR_SEL_MSB_ONLY 0x1

/** Selecting Type of Parity Errors Detected for Event Counter - selects source for Parity Error Event Counter */
#define TX2ERRXC_ERRD_CTRL_ERRD_SEL_MASK 0x300
#define TX2ERRXC_ERRD_CTRL_ERRD_SEL_AFE_GET ((VR9_AfeRead(TX2ERRXC_ERRD_CTRL) & TX2ERRXC_ERRD_CTRL_ERRD_SEL_MASK) >> 8)
#define TX2ERRXC_ERRD_CTRL_ERRD_SEL_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_ERRD_CTRL, (val) << 8, TX2ERRXC_ERRD_CTRL_ERRD_SEL_MASK)
/** Single (default) */
#define ERRD_SEL_SING 0x0
/** Double */
#define ERRD_SEL_DOUB 0x1
/** Triple */
#define ERRD_SEL_TRIP 0x2
/** Quadruple */
#define ERRD_SEL_QUAD 0x3


/** Status Register - This register shows the status of the WLSat Overflow */
#define TX2ERRXC_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x30)
#define TX2ERRXC_STAT_AFE_GET VR9_AfeRead(TX2ERRXC_STAT)
#define TX2ERRXC_STAT_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define TX2ERRXC_STAT_OVL_MASK 0x1
#define TX2ERRXC_STAT_OVL_AFE_GET ((VR9_AfeRead(TX2ERRXC_STAT) & TX2ERRXC_STAT_OVL_MASK) >> 0)
#define TX2ERRXC_STAT_OVL_AFE_SET(val) VR9_AfeWrite(TX2ERRXC_STAT, (val) << 0, TX2ERRXC_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Control Register - This register controls the EC BRWDF1 filter */
#define TX2BRWDF1_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x31)
#define TX2BRWDF1_CTRL_AFE_GET VR9_AfeRead(TX2BRWDF1_CTRL)
#define TX2BRWDF1_CTRL_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_CTRL, (val), 0xFFFF)

/** Filter Enable - enables EC BRWDF1 Filter */
#define TX2BRWDF1_CTRL_EN_MASK 0x1
#define TX2BRWDF1_CTRL_EN_AFE_GET ((VR9_AfeRead(TX2BRWDF1_CTRL) & TX2BRWDF1_CTRL_EN_MASK) >> 0)
#define TX2BRWDF1_CTRL_EN_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_CTRL, (val) << 0, TX2BRWDF1_CTRL_EN_MASK)
/** disabled (default) */
#define TX2BRWDF1_CTRL_EN_DIS 0x0
/** enabled */
#define TX2BRWDF1_CTRL_EN_EN 0x1

/** Filter Initialization of BRWDF Filter - enables initialization of EC BRWDF1 Filter */
#define TX2BRWDF1_CTRL_INIT_MASK 0x2
#define TX2BRWDF1_CTRL_INIT_AFE_GET ((VR9_AfeRead(TX2BRWDF1_CTRL) & TX2BRWDF1_CTRL_INIT_MASK) >> 1)
#define TX2BRWDF1_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_CTRL, (val) << 1, TX2BRWDF1_CTRL_INIT_MASK)
/** disabled */
#define INIT_OFF 0x0
/** enabled (default) */
#define INIT_ON 0x1

/** Filter Bypass - enables EC BRWDF1 Filter Bypass */
#define TX2BRWDF1_CTRL_BYP_MASK 0x10
#define TX2BRWDF1_CTRL_BYP_AFE_GET ((VR9_AfeRead(TX2BRWDF1_CTRL) & TX2BRWDF1_CTRL_BYP_MASK) >> 4)
#define TX2BRWDF1_CTRL_BYP_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_CTRL, (val) << 4, TX2BRWDF1_CTRL_BYP_MASK)
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1

/** Filter Autoreset Enable - resets the filter upon internal detection of an overflow of the adaptors */
#define TX2BRWDF1_CTRL_AREN_MASK 0x100
#define TX2BRWDF1_CTRL_AREN_AFE_GET ((VR9_AfeRead(TX2BRWDF1_CTRL) & TX2BRWDF1_CTRL_AREN_MASK) >> 8)
#define TX2BRWDF1_CTRL_AREN_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_CTRL, (val) << 8, TX2BRWDF1_CTRL_AREN_MASK)
/** disabled */
#define AREN_DIS 0x0
/** enabled (default) */
#define AREN_EN 0x1

/** Interpolation Factor - controls Interpolation Factor */
#define TX2BRWDF1_CTRL_INTP_FACT_MASK 0x1000
#define TX2BRWDF1_CTRL_INTP_FACT_AFE_GET ((VR9_AfeRead(TX2BRWDF1_CTRL) & TX2BRWDF1_CTRL_INTP_FACT_MASK) >> 12)
#define TX2BRWDF1_CTRL_INTP_FACT_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_CTRL, (val) << 12, TX2BRWDF1_CTRL_INTP_FACT_MASK)
/** factor 1.5 (default) */
#define INTP_FACT_F15 0x0
/** factor 2.0 */
#define INTP_FACT_F20 0x1


/** Coefficient G01 Register - TX WDF1 programmable coefficient 1 in polyphase 0 */
#define TX2BRWDF1_COEFF_G01 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x32)
#define TX2BRWDF1_COEFF_G01_AFE_GET VR9_AfeRead(TX2BRWDF1_COEFF_G01)
#define TX2BRWDF1_COEFF_G01_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G01, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G01 coefficient */
#define TX2BRWDF1_COEFF_G01_COF_MASK 0x1ff
#define TX2BRWDF1_COEFF_G01_COF_AFE_GET ((VR9_AfeRead(TX2BRWDF1_COEFF_G01) & TX2BRWDF1_COEFF_G01_COF_MASK) >> 0)
#define TX2BRWDF1_COEFF_G01_COF_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G01, (val) << 0, TX2BRWDF1_COEFF_G01_COF_MASK)
/** minimum value */
#define TX2BRWDF1_G01_COF_MIN 0x0
/** startup value (default) */
#define TX2BRWDF1_G01_COF_START 0x20
/** maximum value */
#define TX2BRWDF1_G01_COF_MAX 0x1ff


/** Coefficient G02 Register - TX WDF1 programmable coefficient 2 in polyphase 0 */
#define TX2BRWDF1_COEFF_G02 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x33)
#define TX2BRWDF1_COEFF_G02_AFE_GET VR9_AfeRead(TX2BRWDF1_COEFF_G02)
#define TX2BRWDF1_COEFF_G02_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G02, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G02 coefficient */
#define TX2BRWDF1_COEFF_G02_COF_MASK 0x1ff
#define TX2BRWDF1_COEFF_G02_COF_AFE_GET ((VR9_AfeRead(TX2BRWDF1_COEFF_G02) & TX2BRWDF1_COEFF_G02_COF_MASK) >> 0)
#define TX2BRWDF1_COEFF_G02_COF_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G02, (val) << 0, TX2BRWDF1_COEFF_G02_COF_MASK)
/** minimum value */
#define TX2BRWDF1_G02_COF_MIN 0x0
/** startup value (default) */
#define TX2BRWDF1_G02_COF_START 0x17c
/** maximum value */
#define TX2BRWDF1_G02_COF_MAX 0x1ff


/** Coefficient G11 Register - TX WDF1 programmable coefficient 1 in polyphase 1 */
#define TX2BRWDF1_COEFF_G11 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x34)
#define TX2BRWDF1_COEFF_G11_AFE_GET VR9_AfeRead(TX2BRWDF1_COEFF_G11)
#define TX2BRWDF1_COEFF_G11_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G11, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G11 coefficient */
#define TX2BRWDF1_COEFF_G11_COF_MASK 0x1ff
#define TX2BRWDF1_COEFF_G11_COF_AFE_GET ((VR9_AfeRead(TX2BRWDF1_COEFF_G11) & TX2BRWDF1_COEFF_G11_COF_MASK) >> 0)
#define TX2BRWDF1_COEFF_G11_COF_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G11, (val) << 0, TX2BRWDF1_COEFF_G11_COF_MASK)
/** minimum value */
#define TX2BRWDF1_G11_COF_MIN 0x0
/** startup value (default) */
#define TX2BRWDF1_G11_COF_START 0x5c
/** maximum value */
#define TX2BRWDF1_G11_COF_MAX 0x1ff


/** Coefficient G21 Register - TX WDF1 programmable coefficient 1 in polyphase 2 */
#define TX2BRWDF1_COEFF_G21 (VINAX_AFE_DIG_FILT_CH0_BASE + 0x35)
#define TX2BRWDF1_COEFF_G21_AFE_GET VR9_AfeRead(TX2BRWDF1_COEFF_G21)
#define TX2BRWDF1_COEFF_G21_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G21, (val), 0xFFFF)

/** coefficient value - TX WDF1 programmable adaptor G21 coefficient */
#define TX2BRWDF1_COEFF_G21_COF_MASK 0x1ff
#define TX2BRWDF1_COEFF_G21_COF_AFE_GET ((VR9_AfeRead(TX2BRWDF1_COEFF_G21) & TX2BRWDF1_COEFF_G21_COF_MASK) >> 0)
#define TX2BRWDF1_COEFF_G21_COF_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_COEFF_G21, (val) << 0, TX2BRWDF1_COEFF_G21_COF_MASK)
/** minimum value */
#define TX2BRWDF1_G21_COF_MIN 0x0
/** startup value (default) */
#define TX2BRWDF1_G21_COF_START 0xf0
/** maximum value */
#define TX2BRWDF1_G21_COF_MAX 0x1ff


/** Status Register - This register shows the status of the WLSat Overflow */
#define TX2BRWDF1_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x36)
#define TX2BRWDF1_STAT_AFE_GET VR9_AfeRead(TX2BRWDF1_STAT)
#define TX2BRWDF1_STAT_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define TX2BRWDF1_STAT_OVL_MASK 0x1
#define TX2BRWDF1_STAT_OVL_AFE_GET ((VR9_AfeRead(TX2BRWDF1_STAT) & TX2BRWDF1_STAT_OVL_MASK) >> 0)
#define TX2BRWDF1_STAT_OVL_AFE_SET(val) VR9_AfeWrite(TX2BRWDF1_STAT, (val) << 0, TX2BRWDF1_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** Control Register - This register controls the EC Noise Shaper Filter */
#define TX2NSH_CTRL (VINAX_AFE_DIG_FILT_CH0_BASE + 0x37)
#define TX2NSH_CTRL_AFE_GET VR9_AfeRead(TX2NSH_CTRL)
#define TX2NSH_CTRL_AFE_SET(val) VR9_AfeWrite(TX2NSH_CTRL, (val), 0xFFFF)

/** Filter Enable - enables EC Noise Shaper */
#define TX2NSH_CTRL_EN_MASK 0x1
#define TX2NSH_CTRL_EN_AFE_GET ((VR9_AfeRead(TX2NSH_CTRL) & TX2NSH_CTRL_EN_MASK) >> 0)
#define TX2NSH_CTRL_EN_AFE_SET(val) VR9_AfeWrite(TX2NSH_CTRL, (val) << 0, TX2NSH_CTRL_EN_MASK)
/** disabled (default) */
#define TX2NSH_CTRL_EN_DIS 0x0
/** enabled */
#define TX2NSH_CTRL_EN_EN 0x1

/** Filter Datapath Initialization - enables initialization of EC Noise Shaper */
#define TX2NSH_CTRL_INIT_MASK 0x2
#define TX2NSH_CTRL_INIT_AFE_GET ((VR9_AfeRead(TX2NSH_CTRL) & TX2NSH_CTRL_INIT_MASK) >> 1)
#define TX2NSH_CTRL_INIT_AFE_SET(val) VR9_AfeWrite(TX2NSH_CTRL, (val) << 1, TX2NSH_CTRL_INIT_MASK)
/** disabled */
#define INIT_DIS 0x0
/** enabled (default) */
#define INIT_EN 0x1

/** Filter Bypass - enables EC Noise Shaper Filter Bypass */
#define TX2NSH_CTRL_BYP_MASK 0x10
#define TX2NSH_CTRL_BYP_AFE_GET ((VR9_AfeRead(TX2NSH_CTRL) & TX2NSH_CTRL_BYP_MASK) >> 4)
#define TX2NSH_CTRL_BYP_AFE_SET(val) VR9_AfeWrite(TX2NSH_CTRL, (val) << 4, TX2NSH_CTRL_BYP_MASK)
/** disabled (default) */
#define BYP_DIS 0x0
/** enabled */
#define BYP_EN 0x1

/** Order Selection - selects EC Noiseshaper Order */
#define TX2NSH_CTRL_ORD_MASK 0x100
#define TX2NSH_CTRL_ORD_AFE_GET ((VR9_AfeRead(TX2NSH_CTRL) & TX2NSH_CTRL_ORD_MASK) >> 8)
#define TX2NSH_CTRL_ORD_AFE_SET(val) VR9_AfeWrite(TX2NSH_CTRL, (val) << 8, TX2NSH_CTRL_ORD_MASK)
/** First order (default) */
#define ORD_1ST 0x0
/** Second Order */
#define ORD_2ND 0x1

/** Output Bitwidth - selects EC Noise Shaper Output Bitwidth */
#define TX2NSH_CTRL_OBWIDTH_MASK 0x200
#define TX2NSH_CTRL_OBWIDTH_AFE_GET ((VR9_AfeRead(TX2NSH_CTRL) & TX2NSH_CTRL_OBWIDTH_MASK) >> 9)
#define TX2NSH_CTRL_OBWIDTH_AFE_SET(val) VR9_AfeWrite(TX2NSH_CTRL, (val) << 9, TX2NSH_CTRL_OBWIDTH_MASK)
/** 13 bits (default) */
#define OBWIDTH_13B 0x0
/** 8 bits */
#define OBWIDTH_8B 0x1


/** Status Register - This register shows the status of the WLSat Overflow */
#define TX2NSH_STAT (VINAX_AFE_DIG_FILT_CH0_BASE + 0x38)
#define TX2NSH_STAT_AFE_GET VR9_AfeRead(TX2NSH_STAT)
#define TX2NSH_STAT_AFE_SET(val) VR9_AfeWrite(TX2NSH_STAT, (val), 0xFFFF)

/** Saturation Overflow Flag - WL Saturation Overflow flag */
#define TX2NSH_STAT_OVL_MASK 0x1
#define TX2NSH_STAT_OVL_AFE_GET ((VR9_AfeRead(TX2NSH_STAT) & TX2NSH_STAT_OVL_MASK) >> 0)
#define TX2NSH_STAT_OVL_AFE_SET(val) VR9_AfeWrite(TX2NSH_STAT, (val) << 0, TX2NSH_STAT_OVL_MASK)
/** no overflow (default) */
#define OVL_NO_OVFL 0x0
/** overflow */
#define OVL_OVFL 0x1


/** AEC Programmable Gain Register - This register configures the AEC */
#define TX2NSH_AEC (VINAX_AFE_DIG_FILT_CH0_BASE + 0x39)
#define TX2NSH_AEC_AFE_GET VR9_AfeRead(TX2NSH_AEC)
#define TX2NSH_AEC_AFE_SET(val) VR9_AfeWrite(TX2NSH_AEC, (val), 0xFFFF)

/** AEC Programable Gain Bypass - enables AEC Programmable Bypass */
#define TX2NSH_AEC_BYP_MASK 0x10
#define TX2NSH_AEC_BYP_AFE_GET ((VR9_AfeRead(TX2NSH_AEC) & TX2NSH_AEC_BYP_MASK) >> 4)
#define TX2NSH_AEC_BYP_AFE_SET(val) VR9_AfeWrite(TX2NSH_AEC, (val) << 4, TX2NSH_AEC_BYP_MASK)
/** disabled */
#define BYP_DIS 0x0
/** enabled (default) */
#define BYP_EN 0x1

/** Gain Factor for AEC - Gain Factor (unsigned 5 bit value) */
#define TX2NSH_AEC_GAIN_FACT_MASK 0x1f00
#define TX2NSH_AEC_GAIN_FACT_AFE_GET ((VR9_AfeRead(TX2NSH_AEC) & TX2NSH_AEC_GAIN_FACT_MASK) >> 8)
#define TX2NSH_AEC_GAIN_FACT_AFE_SET(val) VR9_AfeWrite(TX2NSH_AEC, (val) << 8, TX2NSH_AEC_GAIN_FACT_MASK)
/** minimum value (default) */
#define GAIN_FACT_MIN 0x0
/** maximum value */
#define GAIN_FACT_MAX 0x1f

#endif /* _VINAX_AFE_DIG_FILT_CH0_H */
