/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _VINAX_AFE_DIG_GLOBAL_H
#define _VINAX_AFE_DIG_GLOBAL_H


#define VINAX_AFE_DIG_GLOBAL_BASE 0x0

/** PLL Control Register 0 - PLL Control Register 0 */
#define PLL_CTL0 (VINAX_AFE_DIG_GLOBAL_BASE + 0x0)
#define PLL_CTL0_AFE_GET VR9_AfeRead(PLL_CTL0)
#define PLL_CTL0_AFE_SET(val) VR9_AfeWrite(PLL_CTL0, (val), 0xFFFF)

/** BIAS source trimming - selects BIAS source trimming */
#define PLL_CTL0_PLL_BIAS_TRIM_MASK 0x3
#define PLL_CTL0_PLL_BIAS_TRIM_AFE_GET ((VR9_AfeRead(PLL_CTL0) & PLL_CTL0_PLL_BIAS_TRIM_MASK) >> 0)
#define PLL_CTL0_PLL_BIAS_TRIM_AFE_SET(val) VR9_AfeWrite(PLL_CTL0, (val) << 0, PLL_CTL0_PLL_BIAS_TRIM_MASK)
/** 22 uA */
#define PLL_BIAS_TRIM_PLL_BIAS0 0x0
/** 17 uA */
#define PLL_BIAS_TRIM_PLL_BIAS1 0x1
/** 32 uA (default) */
#define PLL_BIAS_TRIM_PLL_BIAS2 0x2
/** 27 uA */
#define PLL_BIAS_TRIM_PLL_BIAS3 0x3

/** DCO current regulation - selects DCO current regulation */
#define PLL_CTL0_PLL_SEL_CURCAL_MASK 0xc
#define PLL_CTL0_PLL_SEL_CURCAL_AFE_GET ((VR9_AfeRead(PLL_CTL0) & PLL_CTL0_PLL_SEL_CURCAL_MASK) >> 2)
#define PLL_CTL0_PLL_SEL_CURCAL_AFE_SET(val) VR9_AfeWrite(PLL_CTL0, (val) << 2, PLL_CTL0_PLL_SEL_CURCAL_MASK)
/** no DCO */
#define PLL_SEL_CURCAL_PLL_NO_DCO 0x0
/** 1st DCO */
#define PLL_SEL_CURCAL_PLL_DCO1 0x1
/** 2nd DCO */
#define PLL_SEL_CURCAL_PLL_DCO2 0x2
/** both DCO (default) */
#define PLL_SEL_CURCAL_PLL_ALL_DCO 0x3

/** PLL reference voltage - selects PLL reference voltage */
#define PLL_CTL0_PLL_SEL_VREG_MASK 0x30
#define PLL_CTL0_PLL_SEL_VREG_AFE_GET ((VR9_AfeRead(PLL_CTL0) & PLL_CTL0_PLL_SEL_VREG_MASK) >> 4)
#define PLL_CTL0_PLL_SEL_VREG_AFE_SET(val) VR9_AfeWrite(PLL_CTL0, (val) << 4, PLL_CTL0_PLL_SEL_VREG_MASK)
/** 1.05 V */
#define PLL_SEL_VREG_PLL_VREF0 0x0
/** 1.10 V (default) */
#define PLL_SEL_VREG_PLL_VREF1 0x1
/** 1.15 V */
#define PLL_SEL_VREG_PLL_VREF2 0x2
/** 1.20 V */
#define PLL_SEL_VREG_PLL_VREF3 0x3

/** PLL Testmux selection ANALOG - selects signals to be monitored via analog pin PLL_TEST_A  */
#define PLL_CTL0_PLL_SEL_TESTMUX_ANA_MASK 0xc0
#define PLL_CTL0_PLL_SEL_TESTMUX_ANA_AFE_GET ((VR9_AfeRead(PLL_CTL0) & PLL_CTL0_PLL_SEL_TESTMUX_ANA_MASK) >> 6)
#define PLL_CTL0_PLL_SEL_TESTMUX_ANA_AFE_SET(val) VR9_AfeWrite(PLL_CTL0, (val) << 6, PLL_CTL0_PLL_SEL_TESTMUX_ANA_MASK)
/** tristate (default) */
#define PLL_SEL_TESTMUX_ANA_PLL_TMA_TRI 0x0
/** buffered 360 mV reference voltage */
#define PLL_SEL_TESTMUX_ANA_PLL_TMA_VREFBUF 0x1
/** 25 uA test current */
#define PLL_SEL_TESTMUX_ANA_PLL_TMA_TESTCUR1 0x2
/** 25 uA test current */
#define PLL_SEL_TESTMUX_ANA_PLL_TMA_TESTCUR2 0x3

/** DCO frequency selection - selects DCO frequency */
#define PLL_CTL0_PLL_SEL_FDCO_MASK 0x300
#define PLL_CTL0_PLL_SEL_FDCO_AFE_GET ((VR9_AfeRead(PLL_CTL0) & PLL_CTL0_PLL_SEL_FDCO_MASK) >> 8)
#define PLL_CTL0_PLL_SEL_FDCO_AFE_SET(val) VR9_AfeWrite(PLL_CTL0, (val) << 8, PLL_CTL0_PLL_SEL_FDCO_MASK)
/** fmin (default) */
#define PLL_SEL_FDCO_PLL_DCO_FMIN 0x0
/** fcenter */
#define PLL_SEL_FDCO_PLL_DCO_FCEN 0x1
/** fmax */
#define PLL_SEL_FDCO_PLL_DCO_FMAX 0x2
/** fmax and pll_lock high */
#define PLL_SEL_FDCO_PLL_DCO_FMAX_LOCKH 0x3

/** DCO current selection - selects DCO current */
#define PLL_CTL0_PLL_SEL_DCOCURR_MASK 0x7000
#define PLL_CTL0_PLL_SEL_DCOCURR_AFE_GET ((VR9_AfeRead(PLL_CTL0) & PLL_CTL0_PLL_SEL_DCOCURR_MASK) >> 12)
#define PLL_CTL0_PLL_SEL_DCOCURR_AFE_SET(val) VR9_AfeWrite(PLL_CTL0, (val) << 12, PLL_CTL0_PLL_SEL_DCOCURR_MASK)
/** 75 uA */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR0 0x0
/** 150 uA */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR1 0x1
/** 225 uA */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR2 0x2
/** 300 uA (default) */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR3 0x3
/** 375 uA */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR4 0x4
/** 450 uA */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR5 0x5
/** 525 uA */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR6 0x6
/** 600 uA */
#define PLL_SEL_DCOCURR_PLL_DCO_CUR7 0x7


/** PLL Control Register 1 - PLL Control Register 1 */
#define PLL_CTL1 (VINAX_AFE_DIG_GLOBAL_BASE + 0x1)
#define PLL_CTL1_AFE_GET VR9_AfeRead(PLL_CTL1)
#define PLL_CTL1_AFE_SET(val) VR9_AfeWrite(PLL_CTL1, (val), 0xFFFF)

/** PLL coarse selection - selects PLL coarse tuning */
#define PLL_CTL1_PLL_DINSAR_MASK 0xf
#define PLL_CTL1_PLL_DINSAR_AFE_GET ((VR9_AfeRead(PLL_CTL1) & PLL_CTL1_PLL_DINSAR_MASK) >> 0)
#define PLL_CTL1_PLL_DINSAR_AFE_SET(val) VR9_AfeWrite(PLL_CTL1, (val) << 0, PLL_CTL1_PLL_DINSAR_MASK)
/** minimum coarse tuning */
#define PLL_DINSAR_PLL_DINSAR_MIN 0x0
/** startup coarse tuning */
#define PLL_DINSAR_PLL_DINSAR_START 0x7
/** maximum coarse tuning */
#define PLL_DINSAR_PLL_DINSAR_MAX 0xf

/** PLL direct FM enable - disables PLL direct FM */
#define PLL_CTL1_PLL_FM_MODE_N_MASK 0x10
#define PLL_CTL1_PLL_FM_MODE_N_AFE_GET ((VR9_AfeRead(PLL_CTL1) & PLL_CTL1_PLL_FM_MODE_N_MASK) >> 4)
#define PLL_CTL1_PLL_FM_MODE_N_AFE_SET(val) VR9_AfeWrite(PLL_CTL1, (val) << 4, PLL_CTL1_PLL_FM_MODE_N_MASK)
/** PLL direct FM is enabled */
#define PLL_FM_MODE_N_EN_PLL_DIRFM 0x0
/** PLL direct FM is disabled (default) */
#define PLL_FM_MODE_N_DIS_PLL_DIRFM 0x1

/** PLL testcounter enable - enables PLL Testcounter */
#define PLL_CTL1_PLL_SLIN_EN_MASK 0x20
#define PLL_CTL1_PLL_SLIN_EN_AFE_GET ((VR9_AfeRead(PLL_CTL1) & PLL_CTL1_PLL_SLIN_EN_MASK) >> 5)
#define PLL_CTL1_PLL_SLIN_EN_AFE_SET(val) VR9_AfeWrite(PLL_CTL1, (val) << 5, PLL_CTL1_PLL_SLIN_EN_MASK)
/** PLL test counter is disabled */
#define PLL_SLIN_EN_DIS_PLL_TCNT 0x0
/** PLL test counter is enabled (default) */
#define PLL_SLIN_EN_EN_PLL_TCNT 0x1

/** PLL testmux selection digital - selects signals to be monitored via digital pin PLL_TEST_D */
#define PLL_CTL1_PLL_SEL_TESTMUX_DIG_MASK 0x7000
#define PLL_CTL1_PLL_SEL_TESTMUX_DIG_AFE_GET ((VR9_AfeRead(PLL_CTL1) & PLL_CTL1_PLL_SEL_TESTMUX_DIG_MASK) >> 12)
#define PLL_CTL1_PLL_SEL_TESTMUX_DIG_AFE_SET(val) VR9_AfeWrite(PLL_CTL1, (val) << 12, PLL_CTL1_PLL_SEL_TESTMUX_DIG_MASK)
/** pll lock signal monitor (default) */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_LOCKM 0x0
/** fdiv signal */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_FDIV 0x1
/** dinsar_0 */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_DINSAR0 0x2
/** fdiv monitor */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_FDIVM 0x3
/** fref monitor */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_FREFM 0x4
/** dinsar_1 */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_DINSAR1 0x5
/** dinsar_2 */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_DINSAR2 0x6
/** dinsar_3 */
#define PLL_SEL_TESTMUX_DIG_PLL_TMD_DINSAR3 0x7


/** PLL Control Register 2 - PLL Control Register 2 */
#define PLL_CTL2 (VINAX_AFE_DIG_GLOBAL_BASE + 0x2)
#define PLL_CTL2_AFE_GET VR9_AfeRead(PLL_CTL2)
#define PLL_CTL2_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val), 0xFFFF)

/** LF clock selection - selects source of Loop Filter clock */
#define PLL_CTL2_PLL_LF_CLK_SEL_MASK 0x1
#define PLL_CTL2_PLL_LF_CLK_SEL_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_LF_CLK_SEL_MASK) >> 0)
#define PLL_CTL2_PLL_LF_CLK_SEL_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 0, PLL_CTL2_PLL_LF_CLK_SEL_MASK)
/** PLL feedback clock (default) */
#define PLL_LF_CLK_SEL_PLL_FBCLK 0x0
/** reference clock */
#define PLL_LF_CLK_SEL_PLL_REFCLK 0x1

/** LF clock divider - controls Loop Filter clock divider */
#define PLL_CTL2_PLL_LF_CLK2_MASK 0x2
#define PLL_CTL2_PLL_LF_CLK2_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_LF_CLK2_MASK) >> 1)
#define PLL_CTL2_PLL_LF_CLK2_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 1, PLL_CTL2_PLL_LF_CLK2_MASK)
/** full speed clock (default) */
#define PLL_LF_CLK2_PLL_LFCLK_FULL 0x0
/** half speed clock */
#define PLL_LF_CLK2_PLL_LFCLK_HALF 0x1

/** DCO input selection - selects DCO input */
#define PLL_CTL2_PLL_TI_SEL_MOD_MASK 0x4
#define PLL_CTL2_PLL_TI_SEL_MOD_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_TI_SEL_MOD_MASK) >> 2)
#define PLL_CTL2_PLL_TI_SEL_MOD_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 2, PLL_CTL2_PLL_TI_SEL_MOD_MASK)
/** loop filter (default) */
#define PLL_TI_SEL_MOD_PLL_LF 0x0
/** manual control */
#define PLL_TI_SEL_MOD_PLL_MAN 0x1

/** Proportional path polarity (PPP) - selects proportional path polarity */
#define PLL_CTL2_PLL_SEL_PROP_INV_MASK 0x8
#define PLL_CTL2_PLL_SEL_PROP_INV_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_SEL_PROP_INV_MASK) >> 3)
#define PLL_CTL2_PLL_SEL_PROP_INV_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 3, PLL_CTL2_PLL_SEL_PROP_INV_MASK)
/** positive (default) */
#define PLL_SEL_PROP_INV_PLL_PPP_POS 0x0
/** negative */
#define PLL_SEL_PROP_INV_PLL_PPP_NEG 0x1

/** Manual LF selection - selects Manual Loop Filter settings */
#define PLL_CTL2_PLL_SEL_MANLF_MODE_MASK 0x10
#define PLL_CTL2_PLL_SEL_MANLF_MODE_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_SEL_MANLF_MODE_MASK) >> 4)
#define PLL_CTL2_PLL_SEL_MANLF_MODE_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 4, PLL_CTL2_PLL_SEL_MANLF_MODE_MASK)
/** fast startup */
#define PLL_SEL_MANLF_MODE_PLL_LF_MAN_FAST 0x0
/** lowest jitter (default) */
#define PLL_SEL_MANLF_MODE_PLL_LF_MAN_LOWESTJIT 0x1

/** LF clock inversion - inverts Loop Filter clock */
#define PLL_CTL2_PLL_INV_LFCLK_MASK 0x20
#define PLL_CTL2_PLL_INV_LFCLK_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_INV_LFCLK_MASK) >> 5)
#define PLL_CTL2_PLL_INV_LFCLK_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 5, PLL_CTL2_PLL_INV_LFCLK_MASK)
/** LF clock inversion is disabled (default) */
#define PLL_INV_LFCLK_DIS_INV_PLL_LFCLK 0x0
/** LF clock inversion is enabled */
#define PLL_INV_LFCLK_EN_INV_PLL_LFCLK 0x1

/** Integrator saturation enable - enables saturation for the Integrator */
#define PLL_CTL2_PLL_INT_EN_SAT_MASK 0x40
#define PLL_CTL2_PLL_INT_EN_SAT_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_INT_EN_SAT_MASK) >> 6)
#define PLL_CTL2_PLL_INT_EN_SAT_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 6, PLL_CTL2_PLL_INT_EN_SAT_MASK)
/** Integrator saturation is disabled (default) */
#define PLL_INT_EN_SAT_DIS_PLL_INT_SAT 0x0
/** Integrator saturation is enabled */
#define PLL_INT_EN_SAT_EN_PLL_INT_SAT 0x1

/** PLL startup mode - selects the PLL startup mode */
#define PLL_CTL2_PLL_MODE_MASK 0x300
#define PLL_CTL2_PLL_MODE_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_MODE_MASK) >> 8)
#define PLL_CTL2_PLL_MODE_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 8, PLL_CTL2_PLL_MODE_MASK)
/** set LF manually */
#define PLL_MODE_PLL_START_MAN 0x0
/** fast lock */
#define PLL_MODE_PLL_START_FAST 0x1
/** fast lock and low jitter */
#define PLL_MODE_PLL_START_FAST_LOWJIT 0x2
/** fast lock and lowest jitter (default) */
#define PLL_MODE_PLL_START_FAST_LOWESTJIT 0x3

/** PLL startup disable - disables the PLL auto coarse tuning */
#define PLL_CTL2_PLL_TI_STARTUP_DIS_MASK 0x400
#define PLL_CTL2_PLL_TI_STARTUP_DIS_AFE_GET ((VR9_AfeRead(PLL_CTL2) & PLL_CTL2_PLL_TI_STARTUP_DIS_MASK) >> 10)
#define PLL_CTL2_PLL_TI_STARTUP_DIS_AFE_SET(val) VR9_AfeWrite(PLL_CTL2, (val) << 10, PLL_CTL2_PLL_TI_STARTUP_DIS_MASK)
/** PLL startup is enabled (default) */
#define PLL_TI_STARTUP_DIS_EN_PLL_STARTUP 0x0
/** PLL startup is disabled */
#define PLL_TI_STARTUP_DIS_DIS_PLL_STARTUP 0x1


/** PLL Control Register 3 - The PLL Control Register 3 controls (on/off switching) the clock sources for ADC, DAC1 and DAC2. */
#define PLL_CTL3 (VINAX_AFE_DIG_GLOBAL_BASE + 0x3)
#define PLL_CTL3_AFE_GET VR9_AfeRead(PLL_CTL3)
#define PLL_CTL3_AFE_SET(val) VR9_AfeWrite(PLL_CTL3, (val), 0xFFFF)

/** ADC clock disable - disables ADC clock */
#define PLL_CTL3_PLL_DIS_FADC_MASK 0x1
#define PLL_CTL3_PLL_DIS_FADC_AFE_GET ((VR9_AfeRead(PLL_CTL3) & PLL_CTL3_PLL_DIS_FADC_MASK) >> 0)
#define PLL_CTL3_PLL_DIS_FADC_AFE_SET(val) VR9_AfeWrite(PLL_CTL3, (val) << 0, PLL_CTL3_PLL_DIS_FADC_MASK)
/** ADC clock is enabled */
#define PLL_DIS_FADC_PLL_ADC_CLK_ON 0x0
/** ADC clock is disabled (default) */
#define PLL_DIS_FADC_PLL_ADC_CLK_OFF 0x1

/** DAC1 clock disable - disables DAC1 clock */
#define PLL_CTL3_PLL_DIS_FDAC1_MASK 0x2
#define PLL_CTL3_PLL_DIS_FDAC1_AFE_GET ((VR9_AfeRead(PLL_CTL3) & PLL_CTL3_PLL_DIS_FDAC1_MASK) >> 1)
#define PLL_CTL3_PLL_DIS_FDAC1_AFE_SET(val) VR9_AfeWrite(PLL_CTL3, (val) << 1, PLL_CTL3_PLL_DIS_FDAC1_MASK)
/** DAC1 clock is enabled */
#define PLL_DIS_FDAC1_PLL_DAC1_CLK_ON 0x0
/** DAC1 clock is disabled (default) */
#define PLL_DIS_FDAC1_PLL_DAC1_CLK_OFF 0x1

/** DAC2 clock disable - disables DAC2 clock */
#define PLL_CTL3_PLL_DIS_FDAC2_MASK 0x4
#define PLL_CTL3_PLL_DIS_FDAC2_AFE_GET ((VR9_AfeRead(PLL_CTL3) & PLL_CTL3_PLL_DIS_FDAC2_MASK) >> 2)
#define PLL_CTL3_PLL_DIS_FDAC2_AFE_SET(val) VR9_AfeWrite(PLL_CTL3, (val) << 2, PLL_CTL3_PLL_DIS_FDAC2_MASK)
/** DAC2 clock is enabled */
#define PLL_DIS_FDAC2_PLL_DAC2_CLK_ON 0x0
/** DAC2 clock is disabled (default) */
#define PLL_DIS_FDAC2_PLL_DAC2_CLK_OFF 0x1

// Tx1 & Tx2 mask  (SMS00974862 USER DEFINES Start )
#define PLL_CTL3_PLL_DIS_TX1_TX2_MASK 0x0006
// RxMask
#define PLL_CTL3_PLL_DIS_RX_MASK 0x0001
// SMS00974862 USER DEFINES End



/** PLL Status Register - The PLL Status Register allows to track the status of the PLL lock signal. */
#define PLL_STAT (VINAX_AFE_DIG_GLOBAL_BASE + 0x4)
#define PLL_STAT_AFE_GET VR9_AfeRead(PLL_STAT)
#define PLL_STAT_AFE_SET(val) VR9_AfeWrite(PLL_STAT, (val), 0xFFFF)

/** PLL lock sticky for high/low transition - captures a falling edge on the PLL lock signal */
#define PLL_STAT_PLL_LOCK_STICKY_0_MASK 0x1
#define PLL_STAT_PLL_LOCK_STICKY_0_AFE_GET ((VR9_AfeRead(PLL_STAT) & PLL_STAT_PLL_LOCK_STICKY_0_MASK) >> 0)
#define PLL_STAT_PLL_LOCK_STICKY_0_AFE_SET(val) VR9_AfeWrite(PLL_STAT, (val) << 0, PLL_STAT_PLL_LOCK_STICKY_0_MASK)
/** No falling edge detected since last read access (default) */
#define PLL_LOCK_STICKY_0_PLL_STAT_NO_LOCK_LOSS 0x0
/** Falling edge detected and stored since last read access */
#define PLL_LOCK_STICKY_0_PLL_STAT_LOCK_LOSS 0x1

/** PLL lock sticky for low/high transition - captures a rising edge on the PLL lock signal */
#define PLL_STAT_PLL_LOCK_STICKY_1_MASK 0x2
#define PLL_STAT_PLL_LOCK_STICKY_1_AFE_GET ((VR9_AfeRead(PLL_STAT) & PLL_STAT_PLL_LOCK_STICKY_1_MASK) >> 1)
#define PLL_STAT_PLL_LOCK_STICKY_1_AFE_SET(val) VR9_AfeWrite(PLL_STAT, (val) << 1, PLL_STAT_PLL_LOCK_STICKY_1_MASK)
/** No rising edge detected since last read access (default) */
#define PLL_LOCK_STICKY_1_PLL_STAT_NO_LOCK 0x0
/** Rising edge detected and stored since last read access */
#define PLL_LOCK_STICKY_1_PLL_STAT_LOCK 0x1

/** PLL Lock - monitors the generic PLL lock signal during read access  */
#define PLL_STAT_PLL_LOCK_MASK 0x4
#define PLL_STAT_PLL_LOCK_AFE_GET ((VR9_AfeRead(PLL_STAT) & PLL_STAT_PLL_LOCK_MASK) >> 2)
#define PLL_STAT_PLL_LOCK_AFE_SET(val) VR9_AfeWrite(PLL_STAT, (val) << 2, PLL_STAT_PLL_LOCK_MASK)
/** Unlocked state during read access (default) */
#define PLL_LOCK_PLL_STAT_UNLOCKED 0x0
/** Locked state during read access */
#define PLL_LOCK_PLL_STAT_LOCKED 0x1


/** Oscillator Control Register - The Oscillator Control Register controls OSC parameters and operationg modes.  */
#define XO_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x5)
#define XO_CTL_AFE_GET VR9_AfeRead(XO_CTL)
#define XO_CTL_AFE_SET(val) VR9_AfeWrite(XO_CTL, (val), 0xFFFF)

/** OSC divider for capacitance - selects capacitiance value of the OSC divider stage */
#define XO_CTL_OSC_DIV_CAP_MASK 0x7
#define XO_CTL_OSC_DIV_CAP_AFE_GET ((VR9_AfeRead(XO_CTL) & XO_CTL_OSC_DIV_CAP_MASK) >> 0)
#define XO_CTL_OSC_DIV_CAP_AFE_SET(val) VR9_AfeWrite(XO_CTL, (val) << 0, XO_CTL_OSC_DIV_CAP_MASK)
/** 299 fF (default) */
#define OSC_DIV_CAP_OSC_DIV_CAP0 0x0
/** 400 fF */
#define OSC_DIV_CAP_OSC_DIV_CAP1 0x1
/** 636 fF */
#define OSC_DIV_CAP_OSC_DIV_CAP2 0x2
/** 737 fF */
#define OSC_DIV_CAP_OSC_DIV_CAP3 0x3
/** 883 fF */
#define OSC_DIV_CAP_OSC_DIV_CAP4 0x4
/** 984 fF */
#define OSC_DIV_CAP_OSC_DIV_CAP5 0x5
/** 52 fF */
#define OSC_DIV_CAP_OSC_DIV_CAP6 0x6
/** 153 fF */
#define OSC_DIV_CAP_OSC_DIV_CAP7 0x7

/** OSC current resistor - selects resistor value for the OSC current */
#define XO_CTL_OSC_START_CUR_MASK 0x30
#define XO_CTL_OSC_START_CUR_AFE_GET ((VR9_AfeRead(XO_CTL) & XO_CTL_OSC_START_CUR_MASK) >> 4)
#define XO_CTL_OSC_START_CUR_AFE_SET(val) VR9_AfeWrite(XO_CTL, (val) << 4, XO_CTL_OSC_START_CUR_MASK)
/** 2.2 kOhm (default) */
#define OSC_START_CUR_OSC_CUR_RES0 0x0
/** 1.8 kOhm */
#define OSC_START_CUR_OSC_CUR_RES1 0x1
/** 1.4 kOhm */
#define OSC_START_CUR_OSC_CUR_RES2 0x2
/** 2.6 kOhm */
#define OSC_START_CUR_OSC_CUR_RES3 0x3

/** OSC bypass switch - controls the bypass functionality for the OSC */
#define XO_CTL_OSC_BYPASS_MASK 0x100
#define XO_CTL_OSC_BYPASS_AFE_GET ((VR9_AfeRead(XO_CTL) & XO_CTL_OSC_BYPASS_MASK) >> 8)
#define XO_CTL_OSC_BYPASS_AFE_SET(val) VR9_AfeWrite(XO_CTL, (val) << 8, XO_CTL_OSC_BYPASS_MASK)
/** OSC bypass is disabled (default) */
#define OSC_BYPASS_OSC_BYP_OFF 0x0
/** OSC bypass is enabled */
#define OSC_BYPASS_OSC_BYP_ON 0x1

/** OSC IMULT - enables IMULT for the OSC */
#define XO_CTL_OSC_IMULT_MASK 0x200
#define XO_CTL_OSC_IMULT_AFE_GET ((VR9_AfeRead(XO_CTL) & XO_CTL_OSC_IMULT_MASK) >> 9)
#define XO_CTL_OSC_IMULT_AFE_SET(val) VR9_AfeWrite(XO_CTL, (val) << 9, XO_CTL_OSC_IMULT_MASK)
/** OSC IMULT is disabled (default) */
#define OSC_IMULT_OSC_IMULT_OFF 0x0
/** OSC IMULT is enabled */
#define OSC_IMULT_OSC_IMULT_ON 0x1

/** OSC amplitude control - enables amplitude control for the OSC */
#define XO_CTL_OSC_AMP_CTL_DIS_MASK 0x400
#define XO_CTL_OSC_AMP_CTL_DIS_AFE_GET ((VR9_AfeRead(XO_CTL) & XO_CTL_OSC_AMP_CTL_DIS_MASK) >> 10)
#define XO_CTL_OSC_AMP_CTL_DIS_AFE_SET(val) VR9_AfeWrite(XO_CTL, (val) << 10, XO_CTL_OSC_AMP_CTL_DIS_MASK)
/** OSC amplitude control is disabled (default) */
#define OSC_AMP_CTL_DIS_OSC_AMPCTL_OFF 0x0
/** OSC amplitude control is enabled */
#define OSC_AMP_CTL_DIS_OSC_AMPCTL_ON 0x1


/** Global Clocking Control Register - The Global Clocking Control Register controls the clocks of the synch. stages, TPG and TDA. */
#define CLOCKING_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x6)
#define CLOCKING_CTL_AFE_GET VR9_AfeRead(CLOCKING_CTL)
#define CLOCKING_CTL_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val), 0xFFFF)

/** Local clock enable for ADC - controls the clock for the ADC/RxCLCOMB synch. stage */
#define CLOCKING_CTL_ADC_LOCAL_CLK_EN_MASK 0x1
#define CLOCKING_CTL_ADC_LOCAL_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_ADC_LOCAL_CLK_EN_MASK) >> 0)
#define CLOCKING_CTL_ADC_LOCAL_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 0, CLOCKING_CTL_ADC_LOCAL_CLK_EN_MASK)
/** Clock is disabled (default) */
#define ADC_LOCAL_CLK_EN_ADC_FILT_CLK_OFF 0x0
/** Clock is enabled */
#define ADC_LOCAL_CLK_EN_ADC_FILT_CLK_ON 0x1

/** Local clock enable for DAC1 - controls the clock for the DAC1/NSH1 synch. stage */
#define CLOCKING_CTL_DAC1_LOCAL_CLK_EN_MASK 0x2
#define CLOCKING_CTL_DAC1_LOCAL_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_DAC1_LOCAL_CLK_EN_MASK) >> 1)
#define CLOCKING_CTL_DAC1_LOCAL_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 1, CLOCKING_CTL_DAC1_LOCAL_CLK_EN_MASK)
/** Clock is disabled (default) */
#define DAC1_LOCAL_CLK_EN_DAC1_FILT_CLK_OFF 0x0
/** Clock is enabled */
#define DAC1_LOCAL_CLK_EN_DAC1_FILT_CLK_ON 0x1

/** Local clock enable for DAC2 - controls the clock for the DAC2/NSH2 synch. stage */
#define CLOCKING_CTL_DAC2_LOCAL_CLK_EN_MASK 0x4
#define CLOCKING_CTL_DAC2_LOCAL_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_DAC2_LOCAL_CLK_EN_MASK) >> 2)
#define CLOCKING_CTL_DAC2_LOCAL_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 2, CLOCKING_CTL_DAC2_LOCAL_CLK_EN_MASK)
/** Clock is disabled (default) */
#define DAC2_LOCAL_CLK_EN_DAC2_FILT_CLK_OFF 0x0
/** Clock is enabled */
#define DAC2_LOCAL_CLK_EN_DAC2_FILT_CLK_ON 0x1

/** Clock enable for FCSI - controls the clock for the FCSI register bank */
#define CLOCKING_CTL_FCSI_CLK_EN_MASK 0x10
#define CLOCKING_CTL_FCSI_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_FCSI_CLK_EN_MASK) >> 4)
#define CLOCKING_CTL_FCSI_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 4, CLOCKING_CTL_FCSI_CLK_EN_MASK)
/** Clock is disabled */
#define FCSI_CLK_EN_FCSI_CLK_OFF 0x0
/** Clock is enabled (default) */
#define FCSI_CLK_EN_FCSI_CLK_ON 0x1

/** Local clock enable for TX1 of GLP - controls the clock for TX1 of TxPolyWDF/GLP synch. stage */
#define CLOCKING_CTL_GLP_TX1_LOCAL_CLK_EN_MASK 0x20
#define CLOCKING_CTL_GLP_TX1_LOCAL_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_GLP_TX1_LOCAL_CLK_EN_MASK) >> 5)
#define CLOCKING_CTL_GLP_TX1_LOCAL_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 5, CLOCKING_CTL_GLP_TX1_LOCAL_CLK_EN_MASK)
/** Clock is disabled (default) */
#define GLP_TX1_LOCAL_CLK_EN_FILT_GLP_TX1_CLK_OFF 0x0
/** Clock is enabled */
#define GLP_TX1_LOCAL_CLK_EN_FILT_GLP_TX1_CLK_ON 0x1

/** Local clock enable for TX2 of GLP - controls clock for TX2 of EcPolyWDF/GLP synch. stage */
#define CLOCKING_CTL_GLP_TX2_LOCAL_CLK_EN_MASK 0x40
#define CLOCKING_CTL_GLP_TX2_LOCAL_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_GLP_TX2_LOCAL_CLK_EN_MASK) >> 6)
#define CLOCKING_CTL_GLP_TX2_LOCAL_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 6, CLOCKING_CTL_GLP_TX2_LOCAL_CLK_EN_MASK)
/** Clock is disabled (default) */
#define GLP_TX2_LOCAL_CLK_EN_FILT_GLP_TX2_CLK_OFF 0x0
/** Clock is enabled */
#define GLP_TX2_LOCAL_CLK_EN_FILT_GLP_TX2_CLK_ON 0x1

/** Local clock enable for RX of GLP - controls clock for RX of RxBRWDF/GLP synch. stage */
#define CLOCKING_CTL_GLP_RX_LOCAL_CLK_EN_MASK 0x80
#define CLOCKING_CTL_GLP_RX_LOCAL_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_GLP_RX_LOCAL_CLK_EN_MASK) >> 7)
#define CLOCKING_CTL_GLP_RX_LOCAL_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 7, CLOCKING_CTL_GLP_RX_LOCAL_CLK_EN_MASK)
/** Clock is disabled (default) */
#define GLP_RX_LOCAL_CLK_EN_FILT_GLP_RX_CLK_OFF 0x0
/** Clock is enabled */
#define GLP_RX_LOCAL_CLK_EN_FILT_GLP_RX_CLK_ON 0x1

/** Test Pattern Generation clock enable - controls clock for TPG logic (Test pattern generation) */
#define CLOCKING_CTL_TPG_CLK_EN_MASK 0x100
#define CLOCKING_CTL_TPG_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_TPG_CLK_EN_MASK) >> 8)
#define CLOCKING_CTL_TPG_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 8, CLOCKING_CTL_TPG_CLK_EN_MASK)
/** Clock is disabled (default) */
#define TPG_CLK_EN_TPG_CLK_OFF 0x0
/** Clock is enabled */
#define TPG_CLK_EN_TPG_CLK_ON 0x1

/** Test Data Aquisition clock enable - controls clock for TDA logic (Test data aquisition) */
#define CLOCKING_CTL_TDA_CLK_EN_MASK 0x200
#define CLOCKING_CTL_TDA_CLK_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_TDA_CLK_EN_MASK) >> 9)
#define CLOCKING_CTL_TDA_CLK_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 9, CLOCKING_CTL_TDA_CLK_EN_MASK)
/** Clock is disabled (default) */
#define TDA_CLK_EN_TDA_CLK_OFF 0x0
/** Clock is enabled */
#define TDA_CLK_EN_TDA_CLK_ON 0x1

/** Clock phase selection - controls the clock phase of a test clock (288MHz/2) for debug/analysis purposes */
#define CLOCKING_CTL_CLK_PHASE_SEL_MASK 0x400
#define CLOCKING_CTL_CLK_PHASE_SEL_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_CLK_PHASE_SEL_MASK) >> 10)
#define CLOCKING_CTL_CLK_PHASE_SEL_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 10, CLOCKING_CTL_CLK_PHASE_SEL_MASK)
/** Phase 0 is selected (default) */
#define CLK_PHASE_SEL_TCLK_PHASE0 0x0
/** Phase 1 is selected */
#define CLK_PHASE_SEL_TCLK_PHASE1 0x1

/** Clock monitor enable - enables monitoring of ADC, DAC, GLP interface clocks and core clock on GPIO (clk/8) */
#define CLOCKING_CTL_CLK_MONITOR_EN_MASK 0x800
#define CLOCKING_CTL_CLK_MONITOR_EN_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_CLK_MONITOR_EN_MASK) >> 11)
#define CLOCKING_CTL_CLK_MONITOR_EN_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 11, CLOCKING_CTL_CLK_MONITOR_EN_MASK)
/** Clock monitor disabled (default) */
#define CLK_MONITOR_EN_CLK_MON_DIS 0x0
/** Clock monitor enabled */
#define CLK_MONITOR_EN_CLK_MON_EN 0x1

/** DAC2 local clock enable delay - controls the delay of the clock enable of DAC2/NSH2 synch. stage  */
#define CLOCKING_CTL_DAC2_LOCAL_CLK_EN_DLY_MASK 0x7000
#define CLOCKING_CTL_DAC2_LOCAL_CLK_EN_DLY_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_DAC2_LOCAL_CLK_EN_DLY_MASK) >> 12)
#define CLOCKING_CTL_DAC2_LOCAL_CLK_EN_DLY_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 12, CLOCKING_CTL_DAC2_LOCAL_CLK_EN_DLY_MASK)
/** minimum delay (clock cycles) */
#define DAC2_LOCAL_CLK_EN_DLY_DAC2_CLK_DEL0 0x0
/** startup delay (clock cycles) (default) */
#define DAC2_LOCAL_CLK_EN_DLY_DAC2_CLK_DEL3 0x3
/** maximum delay (clock cycles) */
#define DAC2_LOCAL_CLK_EN_DLY_DAC2_CLK_DEL7 0x7

/** Digital Clock Inversion - controls the inversion of the digital core clock (functionality is NOT IMPLEMENTED) */
#define CLOCKING_CTL_DIGCORE_CLK_INV_MASK 0x8000
#define CLOCKING_CTL_DIGCORE_CLK_INV_AFE_GET ((VR9_AfeRead(CLOCKING_CTL) & CLOCKING_CTL_DIGCORE_CLK_INV_MASK) >> 15)
#define CLOCKING_CTL_DIGCORE_CLK_INV_AFE_SET(val) VR9_AfeWrite(CLOCKING_CTL, (val) << 15, CLOCKING_CTL_DIGCORE_CLK_INV_MASK)
/** Core clock inversion is disabled (default) */
#define DIGCORE_CLK_INV_DIS_INV_CORECLK 0x0
/** Core clock inversion is enabled */
#define DIGCORE_CLK_INV_EN_INV_CORECLK 0x1

// Tx1 & Tx2 mask  (SMS00974862 USER DEFINES Start )
#define CLOCKING_CTL_TX1_TX2_MASK 0x7066
// RxMask
#define CLOCKING_CTL_RX_MASK 0x0081
// (SMS00974862 USER DEFINES End)

/** Global Reset Control Register - The Global Reset Control Register controls the sw-reset for the synch. stages (SS) and FCSI. */
#define RESET_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x7)
#define RESET_CTL_AFE_GET VR9_AfeRead(RESET_CTL)
#define RESET_CTL_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val), 0xFFFF)

/** Force reset for ADC - enables sw-reset for ADC/RxCLCOMB synch. stage (active low) */
#define RESET_CTL_ADC_FORCE_RSTQ_MASK 0x1
#define RESET_CTL_ADC_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(RESET_CTL) & RESET_CTL_ADC_FORCE_RSTQ_MASK) >> 0)
#define RESET_CTL_ADC_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val) << 0, RESET_CTL_ADC_FORCE_RSTQ_MASK)
/** Sw-reset is enabled (default) */
#define ADC_FORCE_RSTQ_ADC_FILT_RST_ON 0x0
/** Sw-reset is disabled */
#define ADC_FORCE_RSTQ_ADC_FILT_RST_OFF 0x1

/** Force reset for DAC1 - enables sw-reset for DAC1/NSH1 synch. stage (active low) */
#define RESET_CTL_DAC1_FORCE_RSTQ_MASK 0x2
#define RESET_CTL_DAC1_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(RESET_CTL) & RESET_CTL_DAC1_FORCE_RSTQ_MASK) >> 1)
#define RESET_CTL_DAC1_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val) << 1, RESET_CTL_DAC1_FORCE_RSTQ_MASK)
/** Sw-reset is enabled (default) */
#define DAC1_FORCE_RSTQ_DAC1_FILT_RST_ON 0x0
/** Sw-reset is disabled */
#define DAC1_FORCE_RSTQ_DAC1_FILT_RST_OFF 0x1

/** Force reset for DAC2 - enables sw-reset for DAC2/NSH2 synch. stage (active low) */
#define RESET_CTL_DAC2_FORCE_RSTQ_MASK 0x4
#define RESET_CTL_DAC2_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(RESET_CTL) & RESET_CTL_DAC2_FORCE_RSTQ_MASK) >> 2)
#define RESET_CTL_DAC2_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val) << 2, RESET_CTL_DAC2_FORCE_RSTQ_MASK)
/** Sw-reset is enabled (default) */
#define DAC2_FORCE_RSTQ_DAC2_FILT_RST_ON 0x0
/** Sw-reset is disabled */
#define DAC2_FORCE_RSTQ_DAC2_FILT_RST_OFF 0x1

/** Force reset for FCSI - enables sw-reset for FCSI register bank (active low) */
#define RESET_CTL_FCSI_FORCE_RSTQ_MASK 0x10
#define RESET_CTL_FCSI_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(RESET_CTL) & RESET_CTL_FCSI_FORCE_RSTQ_MASK) >> 4)
#define RESET_CTL_FCSI_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val) << 4, RESET_CTL_FCSI_FORCE_RSTQ_MASK)
/** Sw-reset is enabled (default) */
#define FCSI_FORCE_RSTQ_FCSI_RST_ON 0x0
/** Sw-reset is disabled */
#define FCSI_FORCE_RSTQ_FCSI_RST_OFF 0x1

/** Force reset for TX1 of GLP - enables sw-reset for TX1 of TxPolyWDF/GLP synch. stage (active low) */
#define RESET_CTL_GLP_TX1_FORCE_RSTQ_MASK 0x20
#define RESET_CTL_GLP_TX1_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(RESET_CTL) & RESET_CTL_GLP_TX1_FORCE_RSTQ_MASK) >> 5)
#define RESET_CTL_GLP_TX1_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val) << 5, RESET_CTL_GLP_TX1_FORCE_RSTQ_MASK)
/** Sw-reset is enabled (default) */
#define GLP_TX1_FORCE_RSTQ_FILT_GLP_TX1_RST_ON 0x0
/** Sw-reset is disabled */
#define GLP_TX1_FORCE_RSTQ_FILT_GLP_TX1_RST_OFF 0x1

/** Force reset for TX2 of GLP - enables sw-reset for TX2 of EcPolyWDF/GLP synch. stage (active low) */
#define RESET_CTL_GLP_TX2_FORCE_RSTQ_MASK 0x40
#define RESET_CTL_GLP_TX2_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(RESET_CTL) & RESET_CTL_GLP_TX2_FORCE_RSTQ_MASK) >> 6)
#define RESET_CTL_GLP_TX2_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val) << 6, RESET_CTL_GLP_TX2_FORCE_RSTQ_MASK)
/** Sw-reset is enabled (default) */
#define GLP_TX2_FORCE_RSTQ_FILT_GLP_TX2_RST_ON 0x0
/** Sw-reset is disabled */
#define GLP_TX2_FORCE_RSTQ_FILT_GLP_TX2_RST_OFF 0x1

/** Force reset for RX of GLP - enables sw-reset for RX of RxBRWDF/GLP synch. stage (active low) */
#define RESET_CTL_GLP_RX_FORCE_RSTQ_MASK 0x80
#define RESET_CTL_GLP_RX_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(RESET_CTL) & RESET_CTL_GLP_RX_FORCE_RSTQ_MASK) >> 7)
#define RESET_CTL_GLP_RX_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(RESET_CTL, (val) << 7, RESET_CTL_GLP_RX_FORCE_RSTQ_MASK)
/** Sw-reset is enabled (default) */
#define GLP_RX_FORCE_RSTQ_FILT_GLP_RX_RST_ON 0x0
/** Sw-reset is disabled */
#define GLP_RX_FORCE_RSTQ_FILT_GLP_RX_RST_OFF 0x1

// Tx1 & Tx2 mask  (SMS00974862 USER DEFINES Start )
#define RESET_CTL_TX1_TX2_MASK 0x7066
// RxMask
#define RESET_CTL_RX_MASK 0x0081
// (SMS00974862 USER DEFINES End)

/** PAD Control Register - The PAD Control Register controls tri-state and push-/pull functionality  */
#define PAD_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x8)
#define PAD_CTL_AFE_GET VR9_AfeRead(PAD_CTL)
#define PAD_CTL_AFE_SET(val) VR9_AfeWrite(PAD_CTL, (val), 0xFFFF)

/** CKL_OUT pad output enable - controls output enable of pad CLK_OUT (active low) */
#define PAD_CTL_CLK_OUT_OEN_N_MASK 0x1
#define PAD_CTL_CLK_OUT_OEN_N_AFE_GET ((VR9_AfeRead(PAD_CTL) & PAD_CTL_CLK_OUT_OEN_N_MASK) >> 0)
#define PAD_CTL_CLK_OUT_OEN_N_AFE_SET(val) VR9_AfeWrite(PAD_CTL, (val) << 0, PAD_CTL_CLK_OUT_OEN_N_MASK)
/** Pin CLK_OUT is enabled (default) */
#define CLK_OUT_OEN_N_EN_PIN_CLK_OUT 0x0
/** Pin CLK_OUT is disabled */
#define CLK_OUT_OEN_N_DIS_PIN_CLK_OUT 0x1

/** PLL_TEST_D pad output enable - controls output enable of pad PLL_TEST_D (active low) */
#define PAD_CTL_PLL_TESTD_OEN_N_MASK 0x2
#define PAD_CTL_PLL_TESTD_OEN_N_AFE_GET ((VR9_AfeRead(PAD_CTL) & PAD_CTL_PLL_TESTD_OEN_N_MASK) >> 1)
#define PAD_CTL_PLL_TESTD_OEN_N_AFE_SET(val) VR9_AfeWrite(PAD_CTL, (val) << 1, PAD_CTL_PLL_TESTD_OEN_N_MASK)
/** Pin PLL_TEST_D is enabled (default) */
#define PLL_TESTD_OEN_N_EN_PIN_PLL_TEST_D 0x0
/** Pin PLL_TEST_D is disabled */
#define PLL_TESTD_OEN_N_DIS_PIN_PLL_TEST_D 0x1

/** SCDO pad push-pull enable - controls push-pull functionality of pad SCDO */
#define PAD_CTL_SCDO_PPEN_MASK 0x10
#define PAD_CTL_SCDO_PPEN_AFE_GET ((VR9_AfeRead(PAD_CTL) & PAD_CTL_SCDO_PPEN_MASK) >> 4)
#define PAD_CTL_SCDO_PPEN_AFE_SET(val) VR9_AfeWrite(PAD_CTL, (val) << 4, PAD_CTL_SCDO_PPEN_MASK)
/** SCDO is open-drain (default) */
#define SCDO_PPEN_SCDO_OD 0x0
/** SCDO is push-pull */
#define SCDO_PPEN_SCDO_PP 0x1


/** Global GPIO output multiplexer Register 0 - Global GPIO output multiplexer Register 0 */
#define GPIO_OMUX_CTL_0 (VINAX_AFE_DIG_GLOBAL_BASE + 0x10)
#define GPIO_OMUX_CTL_0_AFE_GET VR9_AfeRead(GPIO_OMUX_CTL_0)
#define GPIO_OMUX_CTL_0_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_0, (val), 0xFFFF)

/** GPIO_0 output selection - selects output for pin GPIO_0 */
#define GPIO_OMUX_CTL_0_GPIO_0_OUT_SEL_MASK 0xf
#define GPIO_OMUX_CTL_0_GPIO_0_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_0) & GPIO_OMUX_CTL_0_GPIO_0_OUT_SEL_MASK) >> 0)
#define GPIO_OMUX_CTL_0_GPIO_0_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_0, (val) << 0, GPIO_OMUX_CTL_0_GPIO_0_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_0_OUT_SEL_GPIO_0_OUT_SEL15 0xf

/** GPIO_1 output selection - selects output for pin GPIO_1 */
#define GPIO_OMUX_CTL_0_GPIO_1_OUT_SEL_MASK 0xf0
#define GPIO_OMUX_CTL_0_GPIO_1_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_0) & GPIO_OMUX_CTL_0_GPIO_1_OUT_SEL_MASK) >> 4)
#define GPIO_OMUX_CTL_0_GPIO_1_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_0, (val) << 4, GPIO_OMUX_CTL_0_GPIO_1_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_1_OUT_SEL_GPIO_1_OUT_SEL15 0xf

/** GPIO_2 output selection - selects output for pin GPIO_2 */
#define GPIO_OMUX_CTL_0_GPIO_2_OUT_SEL_MASK 0xf00
#define GPIO_OMUX_CTL_0_GPIO_2_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_0) & GPIO_OMUX_CTL_0_GPIO_2_OUT_SEL_MASK) >> 8)
#define GPIO_OMUX_CTL_0_GPIO_2_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_0, (val) << 8, GPIO_OMUX_CTL_0_GPIO_2_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_2_OUT_SEL_GPIO_2_OUT_SEL15 0xf

/** GPIO_3 output selection - selects output for pin GPIO_3 */
#define GPIO_OMUX_CTL_0_GPIO_3_OUT_SEL_MASK 0xf000
#define GPIO_OMUX_CTL_0_GPIO_3_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_0) & GPIO_OMUX_CTL_0_GPIO_3_OUT_SEL_MASK) >> 12)
#define GPIO_OMUX_CTL_0_GPIO_3_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_0, (val) << 12, GPIO_OMUX_CTL_0_GPIO_3_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_3_OUT_SEL_GPIO_3_OUT_SEL15 0xf


/** Global GPIO output multiplexer Register 1 - Global GPIO output multiplexer Register 1 */
#define GPIO_OMUX_CTL_1 (VINAX_AFE_DIG_GLOBAL_BASE + 0x11)
#define GPIO_OMUX_CTL_1_AFE_GET VR9_AfeRead(GPIO_OMUX_CTL_1)
#define GPIO_OMUX_CTL_1_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_1, (val), 0xFFFF)

/** GPIO_4 output selection - selects output for pin GPIO_4 */
#define GPIO_OMUX_CTL_1_GPIO_4_OUT_SEL_MASK 0xf
#define GPIO_OMUX_CTL_1_GPIO_4_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_1) & GPIO_OMUX_CTL_1_GPIO_4_OUT_SEL_MASK) >> 0)
#define GPIO_OMUX_CTL_1_GPIO_4_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_1, (val) << 0, GPIO_OMUX_CTL_1_GPIO_4_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_4_OUT_SEL_GPIO_4_OUT_SEL15 0xf

/** GPIO_5 output selection - selects output for pin GPIO_5 */
#define GPIO_OMUX_CTL_1_GPIO_5_OUT_SEL_MASK 0xf0
#define GPIO_OMUX_CTL_1_GPIO_5_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_1) & GPIO_OMUX_CTL_1_GPIO_5_OUT_SEL_MASK) >> 4)
#define GPIO_OMUX_CTL_1_GPIO_5_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_1, (val) << 4, GPIO_OMUX_CTL_1_GPIO_5_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_5_OUT_SEL_GPIO_5_OUT_SEL15 0xf

/** GPIO_6 output selection - selects output for pin GPIO_6 */
#define GPIO_OMUX_CTL_1_GPIO_6_OUT_SEL_MASK 0xf00
#define GPIO_OMUX_CTL_1_GPIO_6_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_1) & GPIO_OMUX_CTL_1_GPIO_6_OUT_SEL_MASK) >> 8)
#define GPIO_OMUX_CTL_1_GPIO_6_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_1, (val) << 8, GPIO_OMUX_CTL_1_GPIO_6_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_6_OUT_SEL_GPIO_6_OUT_SEL15 0xf

/** GPIO_7 output selection - selects output for pin GPIO_7 */
#define GPIO_OMUX_CTL_1_GPIO_7_OUT_SEL_MASK 0xf000
#define GPIO_OMUX_CTL_1_GPIO_7_OUT_SEL_AFE_GET ((VR9_AfeRead(GPIO_OMUX_CTL_1) & GPIO_OMUX_CTL_1_GPIO_7_OUT_SEL_MASK) >> 12)
#define GPIO_OMUX_CTL_1_GPIO_7_OUT_SEL_AFE_SET(val) VR9_AfeWrite(GPIO_OMUX_CTL_1, (val) << 12, GPIO_OMUX_CTL_1_GPIO_7_OUT_SEL_MASK)
/** monitor t.b.d. (default) */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL0 0x0
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL1 0x1
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL2 0x2
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL3 0x3
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL4 0x4
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL5 0x5
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL6 0x6
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL7 0x7
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL8 0x8
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL9 0x9
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL10 0xa
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL11 0xb
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL12 0xc
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL13 0xd
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL14 0xe
/** monitor t.b.d. */
#define GPIO_7_OUT_SEL_GPIO_7_OUT_SEL15 0xf


/** Global GPIO output Register - Global GPIO output Register */
#define GPIO_DOUT (VINAX_AFE_DIG_GLOBAL_BASE + 0x12)
#define GPIO_DOUT_AFE_GET VR9_AfeRead(GPIO_DOUT)
#define GPIO_DOUT_AFE_SET(val) VR9_AfeWrite(GPIO_DOUT, (val), 0xFFFF)

/** GPIO output value - allows write access to GPIO pins via SSC interface */
#define GPIO_DOUT_GPIO_DOUT_MASK 0xff
#define GPIO_DOUT_GPIO_DOUT_AFE_GET ((VR9_AfeRead(GPIO_DOUT) & GPIO_DOUT_GPIO_DOUT_MASK) >> 0)
#define GPIO_DOUT_GPIO_DOUT_AFE_SET(val) VR9_AfeWrite(GPIO_DOUT, (val) << 0, GPIO_DOUT_GPIO_DOUT_MASK)
/** Level at all pins is low (default) */
#define GPIO_DOUT_LOW 0x0
/** Level at all pins is high */
#define GPIO_DOUT_HIGH 0xff


/** Global GPIO input Register - Global GPIO input Register */
#define GPIO_DIN (VINAX_AFE_DIG_GLOBAL_BASE + 0x13)
#define GPIO_DIN_AFE_GET VR9_AfeRead(GPIO_DIN)
#define GPIO_DIN_AFE_SET(val) VR9_AfeWrite(GPIO_DIN, (val), 0xFFFF)

/** GPIO input value - allows read access from GPIO pins via SSC interface */
#define GPIO_DIN_GPIO_DIN_MASK 0xff
#define GPIO_DIN_GPIO_DIN_AFE_GET ((VR9_AfeRead(GPIO_DIN) & GPIO_DIN_GPIO_DIN_MASK) >> 0)
#define GPIO_DIN_GPIO_DIN_AFE_SET(val) VR9_AfeWrite(GPIO_DIN, (val) << 0, GPIO_DIN_GPIO_DIN_MASK)
/** Level at all pins is low */
#define GPIO_DIN_LOW 0x0
/** Level at all pins is high */
#define GPIO_DIN_HIGH 0xff


/** Global GPIO control Register - Global GPIO control Register */
#define GPIO_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x14)
#define GPIO_CTL_AFE_GET VR9_AfeRead(GPIO_CTL)
#define GPIO_CTL_AFE_SET(val) VR9_AfeWrite(GPIO_CTL, (val), 0xFFFF)

/** GPIO pad output enable - controls output enable for each GPIO pin (active low) */
#define GPIO_CTL_GPIO_OEN_N_MASK 0xff
#define GPIO_CTL_GPIO_OEN_N_AFE_GET ((VR9_AfeRead(GPIO_CTL) & GPIO_CTL_GPIO_OEN_N_MASK) >> 0)
#define GPIO_CTL_GPIO_OEN_N_AFE_SET(val) VR9_AfeWrite(GPIO_CTL, (val) << 0, GPIO_CTL_GPIO_OEN_N_MASK)
/** All outputs are enabled */
#define GPIO_OEN_N_EN 0x0
/** All outputs are disabled (default) */
#define GPIO_OEN_N_DIS 0xff


/** RC Measurement Control Register - RC Measurement Control Register */
#define RCMEAS_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x20)
#define RCMEAS_CTL_AFE_GET VR9_AfeRead(RCMEAS_CTL)
#define RCMEAS_CTL_AFE_SET(val) VR9_AfeWrite(RCMEAS_CTL, (val), 0xFFFF)

/** RC Tuning Enable - enables RC tuning */
#define RCMEAS_CTL_RC_TUNING_EN_MASK 0x1
#define RCMEAS_CTL_RC_TUNING_EN_AFE_GET ((VR9_AfeRead(RCMEAS_CTL) & RCMEAS_CTL_RC_TUNING_EN_MASK) >> 0)
#define RCMEAS_CTL_RC_TUNING_EN_AFE_SET(val) VR9_AfeWrite(RCMEAS_CTL, (val) << 0, RCMEAS_CTL_RC_TUNING_EN_MASK)
/** RC tuning is disabled (default) */
#define RC_TUNING_EN_RC_TUN_OFF 0x0
/** RC tuning is enabled */
#define RC_TUNING_EN_RC_TUN_ON 0x1

/** RC Start Measurement - enables RC start measurement (active low) */
#define RCMEAS_CTL_RC_START_MEAS_N_MASK 0x2
#define RCMEAS_CTL_RC_START_MEAS_N_AFE_GET ((VR9_AfeRead(RCMEAS_CTL) & RCMEAS_CTL_RC_START_MEAS_N_MASK) >> 1)
#define RCMEAS_CTL_RC_START_MEAS_N_AFE_SET(val) VR9_AfeWrite(RCMEAS_CTL, (val) << 1, RCMEAS_CTL_RC_START_MEAS_N_MASK)
/** RC start measurement is enabled */
//VR9_bringup : Binu: This is done after reviewing the code with Lusin Thomas
#define RC_START_MEAS_N_RC_START_MEAS_ON 0x1
/** RC start measurement is disabled (default) */
#define RC_START_MEAS_N_RC_START_MEAS_OFF 0x0

/** RC Measurement Status Register - RC Measurement Status Register */
#define RCMEAS_STAT (VINAX_AFE_DIG_GLOBAL_BASE + 0x21)
#define RCMEAS_STAT_AFE_GET VR9_AfeRead(RCMEAS_STAT)
#define RCMEAS_STAT_AFE_SET(val) VR9_AfeWrite(RCMEAS_STAT, (val), 0xFFFF)

/** RC Tuning Counter (TCNT) - reports value of tuning counter */
#define RCMEAS_STAT_RC_TUNE_COUNT_MASK 0xfff
#define RCMEAS_STAT_RC_TUNE_COUNT_AFE_GET ((VR9_AfeRead(RCMEAS_STAT) & RCMEAS_STAT_RC_TUNE_COUNT_MASK) >> 0)
#define RCMEAS_STAT_RC_TUNE_COUNT_AFE_SET(val) VR9_AfeWrite(RCMEAS_STAT, (val) << 0, RCMEAS_STAT_RC_TUNE_COUNT_MASK)
/** counter minimum value (0) (default) */
#define RC_TUNE_COUNT_RC_TCNT_MIN 0x0
/** counter maximum value (4095) */
#define RC_TUNE_COUNT_RC_TCNT_MAX 0xfff

/** RC Error Type - reports type of type of error */
#define RCMEAS_STAT_RC_ERROR_TYPE_MASK 0x3000
#define RCMEAS_STAT_RC_ERROR_TYPE_AFE_GET ((VR9_AfeRead(RCMEAS_STAT) & RCMEAS_STAT_RC_ERROR_TYPE_MASK) >> 12)
#define RCMEAS_STAT_RC_ERROR_TYPE_AFE_SET(val) VR9_AfeWrite(RCMEAS_STAT, (val) << 12, RCMEAS_STAT_RC_ERROR_TYPE_MASK)
/** no error (default) */
#define RC_ERROR_TYPE_RC_NOERR 0x0
/** RC stops too early */
#define RC_ERROR_TYPE_RC_EARLY 0x1
/** RC stops too late */
#define RC_ERROR_TYPE_RC_LATE 0x2
/** not used */
#define RC_ERROR_TYPE_RC_NU 0x3

/** RC error - reports if any error has occured during measurement */
#define RCMEAS_STAT_RC_ERROR_MASK 0x4000
#define RCMEAS_STAT_RC_ERROR_AFE_GET ((VR9_AfeRead(RCMEAS_STAT) & RCMEAS_STAT_RC_ERROR_MASK) >> 14)
#define RCMEAS_STAT_RC_ERROR_AFE_SET(val) VR9_AfeWrite(RCMEAS_STAT, (val) << 14, RCMEAS_STAT_RC_ERROR_MASK)
/** no error(s) occured (default) */
#define RC_ERROR_RC_NOERR 0x0
/** error(s) occured */
#define RC_ERROR_RC_ERR 0x1

/** RC Measurement Done - reports the end of the measurement */
#define RCMEAS_STAT_RC_MEAS_DONE_MASK 0x8000
#define RCMEAS_STAT_RC_MEAS_DONE_AFE_GET ((VR9_AfeRead(RCMEAS_STAT) & RCMEAS_STAT_RC_MEAS_DONE_MASK) >> 15)
#define RCMEAS_STAT_RC_MEAS_DONE_AFE_SET(val) VR9_AfeWrite(RCMEAS_STAT, (val) << 15, RCMEAS_STAT_RC_MEAS_DONE_MASK)
/** RC measurement is steady (default) */
#define RC_MEAS_DONE_RC_STDY 0x0
/** RC measurement is done */
#define RC_MEAS_DONE_RC_DONE 0x1


/** ADC Trimming Control Register - ADC Trimming Control Register */
#define ADCTRIM_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x22)
#define ADCTRIM_CTL_AFE_GET VR9_AfeRead(ADCTRIM_CTL)
#define ADCTRIM_CTL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CTL, (val), 0xFFFF)

/** Test Quantizer Write Disable - disables Test Quantizer Writing */
#define ADCTRIM_CTL_TST_QT_WRITE_DIS_MASK 0x1
#define ADCTRIM_CTL_TST_QT_WRITE_DIS_AFE_GET ((VR9_AfeRead(ADCTRIM_CTL) & ADCTRIM_CTL_TST_QT_WRITE_DIS_MASK) >> 0)
#define ADCTRIM_CTL_TST_QT_WRITE_DIS_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CTL, (val) << 0, ADCTRIM_CTL_TST_QT_WRITE_DIS_MASK)
/** Test quantizer write is enabled (default) */
#define TST_QT_WRITE_DIS_EN_TST_QT_WR 0x0
/** Test quantizer write is disabled */
#define TST_QT_WRITE_DIS_DIS_TST_QT_WR 0x1


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_0 (VINAX_AFE_DIG_GLOBAL_BASE + 0x40)
#define FUSE_DATA_0_AFE_GET VR9_AfeRead(FUSE_DATA_0)
#define FUSE_DATA_0_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_0, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_0_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_0_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_0) & FUSE_DATA_0_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_0_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_0, (val) << 0, FUSE_DATA_0_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_1 (VINAX_AFE_DIG_GLOBAL_BASE + 0x41)
#define FUSE_DATA_1_AFE_GET VR9_AfeRead(FUSE_DATA_1)
#define FUSE_DATA_1_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_1, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_1_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_1_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_1) & FUSE_DATA_1_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_1_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_1, (val) << 0, FUSE_DATA_1_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_2 (VINAX_AFE_DIG_GLOBAL_BASE + 0x42)
#define FUSE_DATA_2_AFE_GET VR9_AfeRead(FUSE_DATA_2)
#define FUSE_DATA_2_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_2, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_2_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_2_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_2) & FUSE_DATA_2_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_2_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_2, (val) << 0, FUSE_DATA_2_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_3 (VINAX_AFE_DIG_GLOBAL_BASE + 0x43)
#define FUSE_DATA_3_AFE_GET VR9_AfeRead(FUSE_DATA_3)
#define FUSE_DATA_3_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_3, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_3_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_3_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_3) & FUSE_DATA_3_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_3_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_3, (val) << 0, FUSE_DATA_3_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_4 (VINAX_AFE_DIG_GLOBAL_BASE + 0x44)
#define FUSE_DATA_4_AFE_GET VR9_AfeRead(FUSE_DATA_4)
#define FUSE_DATA_4_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_4, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_4_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_4_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_4) & FUSE_DATA_4_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_4_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_4, (val) << 0, FUSE_DATA_4_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_5 (VINAX_AFE_DIG_GLOBAL_BASE + 0x45)
#define FUSE_DATA_5_AFE_GET VR9_AfeRead(FUSE_DATA_5)
#define FUSE_DATA_5_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_5, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_5_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_5_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_5) & FUSE_DATA_5_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_5_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_5, (val) << 0, FUSE_DATA_5_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_6 (VINAX_AFE_DIG_GLOBAL_BASE + 0x46)
#define FUSE_DATA_6_AFE_GET VR9_AfeRead(FUSE_DATA_6)
#define FUSE_DATA_6_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_6, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_6_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_6_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_6) & FUSE_DATA_6_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_6_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_6, (val) << 0, FUSE_DATA_6_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Data Register - Fuse Data Register */
#define FUSE_DATA_7 (VINAX_AFE_DIG_GLOBAL_BASE + 0x47)
#define FUSE_DATA_7_AFE_GET VR9_AfeRead(FUSE_DATA_7)
#define FUSE_DATA_7_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_7, (val), 0xFFFF)

/** Fuse Data Target Value - defines the fuse data target value */
#define FUSE_DATA_7_FUSE_DATA_MASK 0xffff
#define FUSE_DATA_7_FUSE_DATA_AFE_GET ((VR9_AfeRead(FUSE_DATA_7) & FUSE_DATA_7_FUSE_DATA_MASK) >> 0)
#define FUSE_DATA_7_FUSE_DATA_AFE_SET(val) VR9_AfeWrite(FUSE_DATA_7, (val) << 0, FUSE_DATA_7_FUSE_DATA_MASK)
/** Fuse data minimum target value (0) (default) */
#define FUSE_DATA_FUS_DATA_TARVAL_MIN 0x0
/** Fuse data maximum target value (65535) */
#define FUSE_DATA_FUS_DATA_TARVAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_0 (VINAX_AFE_DIG_GLOBAL_BASE + 0x48)
#define FUSE_STAT_0_AFE_GET VR9_AfeRead(FUSE_STAT_0)
#define FUSE_STAT_0_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_0, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_0_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_0_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_0) & FUSE_STAT_0_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_0_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_0, (val) << 0, FUSE_STAT_0_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_1 (VINAX_AFE_DIG_GLOBAL_BASE + 0x49)
#define FUSE_STAT_1_AFE_GET VR9_AfeRead(FUSE_STAT_1)
#define FUSE_STAT_1_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_1, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_1_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_1_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_1) & FUSE_STAT_1_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_1_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_1, (val) << 0, FUSE_STAT_1_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_2 (VINAX_AFE_DIG_GLOBAL_BASE + 0x4a)
#define FUSE_STAT_2_AFE_GET VR9_AfeRead(FUSE_STAT_2)
#define FUSE_STAT_2_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_2, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_2_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_2_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_2) & FUSE_STAT_2_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_2_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_2, (val) << 0, FUSE_STAT_2_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_3 (VINAX_AFE_DIG_GLOBAL_BASE + 0x4b)
#define FUSE_STAT_3_AFE_GET VR9_AfeRead(FUSE_STAT_3)
#define FUSE_STAT_3_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_3, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_3_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_3_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_3) & FUSE_STAT_3_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_3_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_3, (val) << 0, FUSE_STAT_3_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_4 (VINAX_AFE_DIG_GLOBAL_BASE + 0x4c)
#define FUSE_STAT_4_AFE_GET VR9_AfeRead(FUSE_STAT_4)
#define FUSE_STAT_4_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_4, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_4_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_4_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_4) & FUSE_STAT_4_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_4_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_4, (val) << 0, FUSE_STAT_4_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_5 (VINAX_AFE_DIG_GLOBAL_BASE + 0x4d)
#define FUSE_STAT_5_AFE_GET VR9_AfeRead(FUSE_STAT_5)
#define FUSE_STAT_5_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_5, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_5_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_5_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_5) & FUSE_STAT_5_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_5_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_5, (val) << 0, FUSE_STAT_5_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_6 (VINAX_AFE_DIG_GLOBAL_BASE + 0x4e)
#define FUSE_STAT_6_AFE_GET VR9_AfeRead(FUSE_STAT_6)
#define FUSE_STAT_6_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_6, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_6_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_6_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_6) & FUSE_STAT_6_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_6_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_6, (val) << 0, FUSE_STAT_6_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Status Register - Fuse Status Register */
#define FUSE_STAT_7 (VINAX_AFE_DIG_GLOBAL_BASE + 0x4f)
#define FUSE_STAT_7_AFE_GET VR9_AfeRead(FUSE_STAT_7)
#define FUSE_STAT_7_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_7, (val), 0xFFFF)

/** Fuse Status Value - reports the value of FUSE_DATA or the value after fuse sensing */
#define FUSE_STAT_7_FUSE_STAT_MASK 0xffff
#define FUSE_STAT_7_FUSE_STAT_AFE_GET ((VR9_AfeRead(FUSE_STAT_7) & FUSE_STAT_7_FUSE_STAT_MASK) >> 0)
#define FUSE_STAT_7_FUSE_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_STAT_7, (val) << 0, FUSE_STAT_7_FUSE_STAT_MASK)
/** Fuse minimum value (0) */
#define FUSE_STAT_FUS_STAT_VAL_MIN 0x0
/** Fuse maximum value (65535) */
#define FUSE_STAT_FUS_STAT_VAL_MAX 0xffff


/** Fuse Control Register - Fuse Control Register */
#define FUSE_CTL (VINAX_AFE_DIG_GLOBAL_BASE + 0x50)
#define FUSE_CTL_AFE_GET VR9_AfeRead(FUSE_CTL)
#define FUSE_CTL_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val), 0xFFFF)

/** Fuse Power Off - enables fuse poweroff (reserved feature; act. no power management) */
#define FUSE_CTL_FUSE_PWR_OFF_MASK 0x1
#define FUSE_CTL_FUSE_PWR_OFF_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_PWR_OFF_MASK) >> 0)
#define FUSE_CTL_FUSE_PWR_OFF_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 0, FUSE_CTL_FUSE_PWR_OFF_MASK)
/** Fusebox is poweron */
#define FUSE_PWR_OFF_FUS_PWR_ON 0x0
/** Fusebox is poweroff (default) */
#define FUSE_PWR_OFF_FUS_PWR_OFF 0x1

/** Fuse Isolation Mode - enables fuse isolation mode (reserved feature; relates to poweroff) */
#define FUSE_CTL_FUSE_ISO_MODE_MASK 0x2
#define FUSE_CTL_FUSE_ISO_MODE_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_ISO_MODE_MASK) >> 1)
#define FUSE_CTL_FUSE_ISO_MODE_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 1, FUSE_CTL_FUSE_ISO_MODE_MASK)
/** Fusebox isolation mode is disabled */
#define FUSE_ISO_MODE_FUS_ISO_OFF 0x0
/** Fusebox isolation mode is enabled (default) */
#define FUSE_ISO_MODE_FUS_ISO_ON 0x1

/** Fuse Clock Enable - enables the fuse clock */
#define FUSE_CTL_FUSE_CLK_EN_MASK 0x4
#define FUSE_CTL_FUSE_CLK_EN_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_CLK_EN_MASK) >> 2)
#define FUSE_CTL_FUSE_CLK_EN_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 2, FUSE_CTL_FUSE_CLK_EN_MASK)
/** Clock for fusebox is disabled (default) */
#define FUSE_CLK_EN_FUS_CLK_OFF 0x0
/** Clock for fusebox is enabled */
#define FUSE_CLK_EN_FUS_CLK_ON 0x1

/** Fuse Force Reset - enables software-reset for the fuse bank (active low) */
#define FUSE_CTL_FUSE_FORCE_RSTQ_MASK 0x10
#define FUSE_CTL_FUSE_FORCE_RSTQ_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_FORCE_RSTQ_MASK) >> 4)
#define FUSE_CTL_FUSE_FORCE_RSTQ_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 4, FUSE_CTL_FUSE_FORCE_RSTQ_MASK)
/** Software-reset for fusebox is enabled */
#define FUSE_FORCE_RSTQ_FUS_RST_ON 0x0
/** Software-reset for fusebox is disabled (default) */
#define FUSE_FORCE_RSTQ_FUS_RST_OFF 0x1

/** Fuse Programming - enables fuse programming if TEST_CFG2.fuse_ctl_enable bit is activated */
#define FUSE_CTL_FUSE_PRGM_MASK 0x100
#define FUSE_CTL_FUSE_PRGM_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_PRGM_MASK) >> 8)
#define FUSE_CTL_FUSE_PRGM_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 8, FUSE_CTL_FUSE_PRGM_MASK)
/** Fuse programming is disabled (default) */
#define FUSE_PRGM_FUS_PRGM_OFF 0x0
/** Fuse programming is enabled */
#define FUSE_PRGM_FUS_PRGM_ON 0x1

/** Fuse Reading/Sensing - enables fuse reading/sensing */
#define FUSE_CTL_FUSE_READ_MASK 0x800
#define FUSE_CTL_FUSE_READ_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_READ_MASK) >> 11)
#define FUSE_CTL_FUSE_READ_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 11, FUSE_CTL_FUSE_READ_MASK)
/** Fusebox reading is disabled (default) */
#define FUSE_READ_FUS_READ_OFF 0x0
/** Fusebox reading is enabled */
#define FUSE_READ_FUS_READ_ON 0x1

/** Fuse Ready Monitor Enable - enables fuse ready to be monitored via pin GPIO_1 */
#define FUSE_CTL_FUSE_READY_MONITOR_EN_MASK 0x1000
#define FUSE_CTL_FUSE_READY_MONITOR_EN_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_READY_MONITOR_EN_MASK) >> 12)
#define FUSE_CTL_FUSE_READY_MONITOR_EN_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 12, FUSE_CTL_FUSE_READY_MONITOR_EN_MASK)
/** Fuse ready signal monitoring is disabled (default) */
#define FUSE_READY_MONITOR_EN_FUS_MON_RDY_OFF 0x0
/** Fuse ready signal monitoring is enabled */
#define FUSE_READY_MONITOR_EN_FUS_MON_RDY_ON 0x1

/** Fuse Test Margin - enables fuse test margin configuration */
#define FUSE_CTL_FUSE_TEST_MARGIN_MASK 0x2000
#define FUSE_CTL_FUSE_TEST_MARGIN_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_TEST_MARGIN_MASK) >> 13)
#define FUSE_CTL_FUSE_TEST_MARGIN_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 13, FUSE_CTL_FUSE_TEST_MARGIN_MASK)
/** Fuse test margin configuration is disabled (default) */
#define FUSE_TEST_MARGIN_FUS_TMARG_OFF 0x0
/** Fuse test margin configuration is enabled */
#define FUSE_TEST_MARGIN_FUS_TMARG_ON 0x1

/** Fuse Pad Enable - enables the fuse pad FSS */
#define FUSE_CTL_FUSE_FSS_PAD_ENAB_MASK 0x4000
#define FUSE_CTL_FUSE_FSS_PAD_ENAB_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_FSS_PAD_ENAB_MASK) >> 14)
#define FUSE_CTL_FUSE_FSS_PAD_ENAB_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 14, FUSE_CTL_FUSE_FSS_PAD_ENAB_MASK)
/** Fuse pad is disabled (default) */
#define FUSE_FSS_PAD_ENAB_FUS_PAD_OFF 0x0
/** Fuse pad is enabled */
#define FUSE_FSS_PAD_ENAB_FUS_PAD_ON 0x1

/** Fuse Serial Mode - enables fuse serial mode/control via GPIO pins */
#define FUSE_CTL_FUSE_SER_MODE_MASK 0x8000
#define FUSE_CTL_FUSE_SER_MODE_AFE_GET ((VR9_AfeRead(FUSE_CTL) & FUSE_CTL_FUSE_SER_MODE_MASK) >> 15)
#define FUSE_CTL_FUSE_SER_MODE_AFE_SET(val) VR9_AfeWrite(FUSE_CTL, (val) << 15, FUSE_CTL_FUSE_SER_MODE_MASK)
/** Fusebox serial mode is disabled (default) */
#define FUSE_SER_MODE_FUS_SERMOD_OFF 0x0
/** Fusebox serial mode is enabled */
#define FUSE_SER_MODE_FUS_SERMOD_ON 0x1


/** Fuse Ready Status Register - Fuse Ready Status Register */
#define FUSE_RDY_STAT (VINAX_AFE_DIG_GLOBAL_BASE + 0x51)
#define FUSE_RDY_STAT_AFE_GET VR9_AfeRead(FUSE_RDY_STAT)
#define FUSE_RDY_STAT_AFE_SET(val) VR9_AfeWrite(FUSE_RDY_STAT, (val), 0xFFFF)

/** Fuse Ready Status Value - reports fuse ready status */
#define FUSE_RDY_STAT_FUSE_READY_MASK 0x1
#define FUSE_RDY_STAT_FUSE_READY_AFE_GET ((VR9_AfeRead(FUSE_RDY_STAT) & FUSE_RDY_STAT_FUSE_READY_MASK) >> 0)
#define FUSE_RDY_STAT_FUSE_READY_AFE_SET(val) VR9_AfeWrite(FUSE_RDY_STAT, (val) << 0, FUSE_RDY_STAT_FUSE_READY_MASK)
/** fusebox status is not ready */
#define FUSE_READY_FUS_STAT_NOT_RDY 0x0
/** fusebox status is ready */
#define FUSE_READY_FUS_STAT_RDY 0x1


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_0 (VINAX_AFE_DIG_GLOBAL_BASE + 0x80)
#define ADCTRIM_CNT_VAL_0_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_0)
#define ADCTRIM_CNT_VAL_0_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_0, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_0_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_0_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_0) & ADCTRIM_CNT_VAL_0_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_0_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_0, (val) << 0, ADCTRIM_CNT_VAL_0_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_1 (VINAX_AFE_DIG_GLOBAL_BASE + 0x81)
#define ADCTRIM_CNT_VAL_1_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_1)
#define ADCTRIM_CNT_VAL_1_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_1, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_1_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_1_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_1) & ADCTRIM_CNT_VAL_1_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_1_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_1, (val) << 0, ADCTRIM_CNT_VAL_1_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_2 (VINAX_AFE_DIG_GLOBAL_BASE + 0x82)
#define ADCTRIM_CNT_VAL_2_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_2)
#define ADCTRIM_CNT_VAL_2_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_2, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_2_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_2_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_2) & ADCTRIM_CNT_VAL_2_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_2_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_2, (val) << 0, ADCTRIM_CNT_VAL_2_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_3 (VINAX_AFE_DIG_GLOBAL_BASE + 0x83)
#define ADCTRIM_CNT_VAL_3_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_3)
#define ADCTRIM_CNT_VAL_3_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_3, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_3_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_3_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_3) & ADCTRIM_CNT_VAL_3_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_3_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_3, (val) << 0, ADCTRIM_CNT_VAL_3_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_4 (VINAX_AFE_DIG_GLOBAL_BASE + 0x84)
#define ADCTRIM_CNT_VAL_4_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_4)
#define ADCTRIM_CNT_VAL_4_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_4, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_4_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_4_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_4) & ADCTRIM_CNT_VAL_4_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_4_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_4, (val) << 0, ADCTRIM_CNT_VAL_4_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_5 (VINAX_AFE_DIG_GLOBAL_BASE + 0x85)
#define ADCTRIM_CNT_VAL_5_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_5)
#define ADCTRIM_CNT_VAL_5_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_5, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_5_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_5_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_5) & ADCTRIM_CNT_VAL_5_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_5_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_5, (val) << 0, ADCTRIM_CNT_VAL_5_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_6 (VINAX_AFE_DIG_GLOBAL_BASE + 0x86)
#define ADCTRIM_CNT_VAL_6_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_6)
#define ADCTRIM_CNT_VAL_6_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_6, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_6_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_6_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_6) & ADCTRIM_CNT_VAL_6_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_6_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_6, (val) << 0, ADCTRIM_CNT_VAL_6_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_7 (VINAX_AFE_DIG_GLOBAL_BASE + 0x87)
#define ADCTRIM_CNT_VAL_7_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_7)
#define ADCTRIM_CNT_VAL_7_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_7, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_7_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_7_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_7) & ADCTRIM_CNT_VAL_7_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_7_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_7, (val) << 0, ADCTRIM_CNT_VAL_7_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_8 (VINAX_AFE_DIG_GLOBAL_BASE + 0x88)
#define ADCTRIM_CNT_VAL_8_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_8)
#define ADCTRIM_CNT_VAL_8_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_8, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_8_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_8_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_8) & ADCTRIM_CNT_VAL_8_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_8_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_8, (val) << 0, ADCTRIM_CNT_VAL_8_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_9 (VINAX_AFE_DIG_GLOBAL_BASE + 0x89)
#define ADCTRIM_CNT_VAL_9_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_9)
#define ADCTRIM_CNT_VAL_9_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_9, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_9_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_9_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_9) & ADCTRIM_CNT_VAL_9_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_9_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_9, (val) << 0, ADCTRIM_CNT_VAL_9_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_10 (VINAX_AFE_DIG_GLOBAL_BASE + 0x8a)
#define ADCTRIM_CNT_VAL_10_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_10)
#define ADCTRIM_CNT_VAL_10_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_10, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_10_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_10_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_10) & ADCTRIM_CNT_VAL_10_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_10_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_10, (val) << 0, ADCTRIM_CNT_VAL_10_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_11 (VINAX_AFE_DIG_GLOBAL_BASE + 0x8b)
#define ADCTRIM_CNT_VAL_11_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_11)
#define ADCTRIM_CNT_VAL_11_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_11, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_11_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_11_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_11) & ADCTRIM_CNT_VAL_11_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_11_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_11, (val) << 0, ADCTRIM_CNT_VAL_11_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_12 (VINAX_AFE_DIG_GLOBAL_BASE + 0x8c)
#define ADCTRIM_CNT_VAL_12_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_12)
#define ADCTRIM_CNT_VAL_12_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_12, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_12_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_12_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_12) & ADCTRIM_CNT_VAL_12_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_12_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_12, (val) << 0, ADCTRIM_CNT_VAL_12_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_13 (VINAX_AFE_DIG_GLOBAL_BASE + 0x8d)
#define ADCTRIM_CNT_VAL_13_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_13)
#define ADCTRIM_CNT_VAL_13_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_13, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_13_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_13_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_13) & ADCTRIM_CNT_VAL_13_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_13_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_13, (val) << 0, ADCTRIM_CNT_VAL_13_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_14 (VINAX_AFE_DIG_GLOBAL_BASE + 0x8e)
#define ADCTRIM_CNT_VAL_14_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_14)
#define ADCTRIM_CNT_VAL_14_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_14, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_14_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_14_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_14) & ADCTRIM_CNT_VAL_14_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_14_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_14, (val) << 0, ADCTRIM_CNT_VAL_14_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_15 (VINAX_AFE_DIG_GLOBAL_BASE + 0x8f)
#define ADCTRIM_CNT_VAL_15_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_15)
#define ADCTRIM_CNT_VAL_15_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_15, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_15_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_15_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_15) & ADCTRIM_CNT_VAL_15_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_15_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_15, (val) << 0, ADCTRIM_CNT_VAL_15_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_16 (VINAX_AFE_DIG_GLOBAL_BASE + 0x90)
#define ADCTRIM_CNT_VAL_16_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_16)
#define ADCTRIM_CNT_VAL_16_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_16, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_16_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_16_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_16) & ADCTRIM_CNT_VAL_16_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_16_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_16, (val) << 0, ADCTRIM_CNT_VAL_16_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_17 (VINAX_AFE_DIG_GLOBAL_BASE + 0x91)
#define ADCTRIM_CNT_VAL_17_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_17)
#define ADCTRIM_CNT_VAL_17_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_17, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_17_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_17_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_17) & ADCTRIM_CNT_VAL_17_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_17_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_17, (val) << 0, ADCTRIM_CNT_VAL_17_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_18 (VINAX_AFE_DIG_GLOBAL_BASE + 0x92)
#define ADCTRIM_CNT_VAL_18_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_18)
#define ADCTRIM_CNT_VAL_18_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_18, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_18_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_18_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_18) & ADCTRIM_CNT_VAL_18_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_18_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_18, (val) << 0, ADCTRIM_CNT_VAL_18_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_19 (VINAX_AFE_DIG_GLOBAL_BASE + 0x93)
#define ADCTRIM_CNT_VAL_19_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_19)
#define ADCTRIM_CNT_VAL_19_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_19, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_19_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_19_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_19) & ADCTRIM_CNT_VAL_19_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_19_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_19, (val) << 0, ADCTRIM_CNT_VAL_19_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_20 (VINAX_AFE_DIG_GLOBAL_BASE + 0x94)
#define ADCTRIM_CNT_VAL_20_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_20)
#define ADCTRIM_CNT_VAL_20_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_20, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_20_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_20_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_20) & ADCTRIM_CNT_VAL_20_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_20_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_20, (val) << 0, ADCTRIM_CNT_VAL_20_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_21 (VINAX_AFE_DIG_GLOBAL_BASE + 0x95)
#define ADCTRIM_CNT_VAL_21_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_21)
#define ADCTRIM_CNT_VAL_21_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_21, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_21_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_21_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_21) & ADCTRIM_CNT_VAL_21_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_21_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_21, (val) << 0, ADCTRIM_CNT_VAL_21_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_22 (VINAX_AFE_DIG_GLOBAL_BASE + 0x96)
#define ADCTRIM_CNT_VAL_22_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_22)
#define ADCTRIM_CNT_VAL_22_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_22, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_22_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_22_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_22) & ADCTRIM_CNT_VAL_22_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_22_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_22, (val) << 0, ADCTRIM_CNT_VAL_22_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_23 (VINAX_AFE_DIG_GLOBAL_BASE + 0x97)
#define ADCTRIM_CNT_VAL_23_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_23)
#define ADCTRIM_CNT_VAL_23_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_23, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_23_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_23_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_23) & ADCTRIM_CNT_VAL_23_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_23_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_23, (val) << 0, ADCTRIM_CNT_VAL_23_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_24 (VINAX_AFE_DIG_GLOBAL_BASE + 0x98)
#define ADCTRIM_CNT_VAL_24_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_24)
#define ADCTRIM_CNT_VAL_24_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_24, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_24_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_24_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_24) & ADCTRIM_CNT_VAL_24_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_24_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_24, (val) << 0, ADCTRIM_CNT_VAL_24_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_25 (VINAX_AFE_DIG_GLOBAL_BASE + 0x99)
#define ADCTRIM_CNT_VAL_25_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_25)
#define ADCTRIM_CNT_VAL_25_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_25, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_25_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_25_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_25) & ADCTRIM_CNT_VAL_25_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_25_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_25, (val) << 0, ADCTRIM_CNT_VAL_25_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_26 (VINAX_AFE_DIG_GLOBAL_BASE + 0x9a)
#define ADCTRIM_CNT_VAL_26_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_26)
#define ADCTRIM_CNT_VAL_26_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_26, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_26_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_26_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_26) & ADCTRIM_CNT_VAL_26_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_26_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_26, (val) << 0, ADCTRIM_CNT_VAL_26_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_27 (VINAX_AFE_DIG_GLOBAL_BASE + 0x9b)
#define ADCTRIM_CNT_VAL_27_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_27)
#define ADCTRIM_CNT_VAL_27_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_27, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_27_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_27_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_27) & ADCTRIM_CNT_VAL_27_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_27_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_27, (val) << 0, ADCTRIM_CNT_VAL_27_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_28 (VINAX_AFE_DIG_GLOBAL_BASE + 0x9c)
#define ADCTRIM_CNT_VAL_28_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_28)
#define ADCTRIM_CNT_VAL_28_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_28, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_28_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_28_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_28) & ADCTRIM_CNT_VAL_28_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_28_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_28, (val) << 0, ADCTRIM_CNT_VAL_28_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_29 (VINAX_AFE_DIG_GLOBAL_BASE + 0x9d)
#define ADCTRIM_CNT_VAL_29_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_29)
#define ADCTRIM_CNT_VAL_29_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_29, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_29_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_29_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_29) & ADCTRIM_CNT_VAL_29_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_29_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_29, (val) << 0, ADCTRIM_CNT_VAL_29_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_30 (VINAX_AFE_DIG_GLOBAL_BASE + 0x9e)
#define ADCTRIM_CNT_VAL_30_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_30)
#define ADCTRIM_CNT_VAL_30_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_30, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_30_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_30_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_30) & ADCTRIM_CNT_VAL_30_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_30_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_30, (val) << 0, ADCTRIM_CNT_VAL_30_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Counter Value Register - ADC Trimming Counter Value Register */
#define ADCTRIM_CNT_VAL_31 (VINAX_AFE_DIG_GLOBAL_BASE + 0x9f)
#define ADCTRIM_CNT_VAL_31_AFE_GET VR9_AfeRead(ADCTRIM_CNT_VAL_31)
#define ADCTRIM_CNT_VAL_31_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_31, (val), 0xFFFF)

/** Quantizer Counter Value - reports the value of the Quantizer counter */
#define ADCTRIM_CNT_VAL_31_COUNTER_VAL_MASK 0xffff
#define ADCTRIM_CNT_VAL_31_COUNTER_VAL_AFE_GET ((VR9_AfeRead(ADCTRIM_CNT_VAL_31) & ADCTRIM_CNT_VAL_31_COUNTER_VAL_MASK) >> 0)
#define ADCTRIM_CNT_VAL_31_COUNTER_VAL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_CNT_VAL_31, (val) << 0, ADCTRIM_CNT_VAL_31_COUNTER_VAL_MASK)
/** minimum value (0) (default) */
#define COUNTER_VAL_ADC_TRCNT_MIN 0x0
/** maximum value (65535) */
#define COUNTER_VAL_ADC_TRCNT_MAX 0xffff


/** ADC Trimming Control Register 0 - ADC Trimming Control Register 0 */
#define ADCTRIM_0 (VINAX_AFE_DIG_GLOBAL_BASE + 0xa0)
#define ADCTRIM_0_AFE_GET VR9_AfeRead(ADCTRIM_0)
#define ADCTRIM_0_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val), 0xFFFF)

/** ADC Trimming Value WRITE - sets the value of ADC trimming WRITE */
#define ADCTRIM_0_ADC_TRIMVALWR_MASK 0x1f
#define ADCTRIM_0_ADC_TRIMVALWR_AFE_GET ((VR9_AfeRead(ADCTRIM_0) & ADCTRIM_0_ADC_TRIMVALWR_MASK) >> 0)
#define ADCTRIM_0_ADC_TRIMVALWR_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val) << 0, ADCTRIM_0_ADC_TRIMVALWR_MASK)
/** minimum value (0) (default) */
#define ADC_TRIMVALWR_ADC_TRVAL_WR_MIN 0x0
/** maximum value (31) */
#define ADC_TRIMVALWR_ADC_TRVAL_WR_MAX 0x1f

/** ADC Trimming WRITE - enables ADC trimming WRITE */
#define ADCTRIM_0_ADC_TRIMWRITE_MASK 0x80
#define ADCTRIM_0_ADC_TRIMWRITE_AFE_GET ((VR9_AfeRead(ADCTRIM_0) & ADCTRIM_0_ADC_TRIMWRITE_MASK) >> 7)
#define ADCTRIM_0_ADC_TRIMWRITE_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val) << 7, ADCTRIM_0_ADC_TRIMWRITE_MASK)
/** ADC trim write is disabled */
#define ADC_TRIMWRITE_DIS_ADC_TR_WR 0x0
/** ADC trim write is enabled (default) */
#define ADC_TRIMWRITE_EN_ADC_TR_WR 0x1

/** ADC comp selection - selects the ADC comparator (normal/top comparator) */
#define ADCTRIM_0_ADC_COMP_SEL_MASK 0x1f00
#define ADCTRIM_0_ADC_COMP_SEL_AFE_GET ((VR9_AfeRead(ADCTRIM_0) & ADCTRIM_0_ADC_COMP_SEL_MASK) >> 8)
#define ADCTRIM_0_ADC_COMP_SEL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val) << 8, ADCTRIM_0_ADC_COMP_SEL_MASK)
/** Normal comparator 0 is selected */
#define ADC_COMP_SEL_ADC_COMP0 0x0
/** Normal comparator 1 is selected */
#define ADC_COMP_SEL_ADC_COMP1 0x1
/** Normal comparator 2 is selected */
#define ADC_COMP_SEL_ADC_COMP2 0x2
/** Normal comparator 3 is selected */
#define ADC_COMP_SEL_ADC_COMP3 0x3
/** Normal comparator 4 is selected */
#define ADC_COMP_SEL_ADC_COMP4 0x4
/** Normal comparator 5 is selected */
#define ADC_COMP_SEL_ADC_COMP5 0x5
/** Normal comparator 6 is selected */
#define ADC_COMP_SEL_ADC_COMP6 0x6
/** Normal comparator 7 is selected */
#define ADC_COMP_SEL_ADC_COMP7 0x7
/** Normal comparator 8 is selected */
#define ADC_COMP_SEL_ADC_COMP8 0x8
/** Normal comparator 9 is selected */
#define ADC_COMP_SEL_ADC_COMP9 0x9
/** Normal comparator 10 is selected */
#define ADC_COMP_SEL_ADC_COMP10 0xa
/** Normal comparator 11 is selected */
#define ADC_COMP_SEL_ADC_COMP11 0xb
/** Normal comparator 12 is selected */
#define ADC_COMP_SEL_ADC_COMP13 0xc
/** Normal comparator 13 is selected */
#define ADC_COMP_SEL_ADC_COMP12 0xd
/** Normal comparator 14 is selected */
#define ADC_COMP_SEL_ADC_COMP14 0xe
/** Top comparator is selected */
#define ADC_COMP_SEL_ADC_TOP_COMP 0xf
/** No comparator is selected (default) */
#define ADC_COMP_SEL_ADC_NO_COMP 0x1f

/** ADC stage selection - selects the ADC stage */
#define ADCTRIM_0_ADC_STAGE_SEL_MASK 0x2000
#define ADCTRIM_0_ADC_STAGE_SEL_AFE_GET ((VR9_AfeRead(ADCTRIM_0) & ADCTRIM_0_ADC_STAGE_SEL_MASK) >> 13)
#define ADCTRIM_0_ADC_STAGE_SEL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val) << 13, ADCTRIM_0_ADC_STAGE_SEL_MASK)
/** ADC stage 0 is selected (default) */
#define ADC_STAGE_SEL_ADC_STAGE0 0x0
/** ADC stage 1 is selected */
#define ADC_STAGE_SEL_ADC_STAGE1 0x1

/* ADC stage selection - selects the ADC stage and select the comparator*/
#  define ADCTRIM_0_ADC_STAGE_COMP_SEL (ADCTRIM_0_ADC_STAGE_SEL_MASK | ADCTRIM_0_ADC_COMP_SEL_MASK)
#  define ADCTRIM_0_ADC_STAGE_COMP_SEL_AFE_GET ((VR9_AfeRead(ADCTRIM_0) & ADCTRIM_0_ADC_STAGE_COMP_SEL) >> 8)
#  define ADCTRIM_0_ADC_STAGE_COMP_SEL_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val) << 8, ADCTRIM_0_ADC_STAGE_COMP_SEL)

/* ADC Trimming READ - enables ADC trimming READ */
#  define ADCTRIM_0_ADC_TRIMREAD 0x80
#  define ADCTRIM_0_ADC_TRIMREAD_AFE_GET ((VR9_AfeRead(ADCTRIM_0) & ADCTRIM_0_ADC_TRIMREAD) >> 7)
#  define ADCTRIM_0_ADC_TRIMREAD_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val) << 7, ADCTRIM_0_ADC_TRIMREAD)

/* ADC Trimming comparator deselect & enables ADC trimming READ */
#  define ADCTRIM_0_ADC_COMP_DESELECT_EN_TRIMREAD  0x3F80
#  define ADCTRIM_0_ADC_COMP_DESELECT_EN_TRIMREAD_AFE_SET(val) VR9_AfeWrite(ADCTRIM_0, (val) << 8, ADCTRIM_0_ADC_COMP_DESELECT_EN_TRIMREAD)
/** ADC Trimming Control Register 1 - ADC Trimming Control Register 1 */
#define ADCTRIM_1 (VINAX_AFE_DIG_GLOBAL_BASE + 0xa1)
#define ADCTRIM_1_AFE_GET VR9_AfeRead(ADCTRIM_1)
#define ADCTRIM_1_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val), 0xFFFF)

/** Start tuning - enables the start of the tuning procedure */
#define ADCTRIM_1_START_TUNING_MASK 0x1
#define ADCTRIM_1_START_TUNING_AFE_GET ((VR9_AfeRead(ADCTRIM_1) & ADCTRIM_1_START_TUNING_MASK) >> 0)
#define ADCTRIM_1_START_TUNING_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val) << 0, ADCTRIM_1_START_TUNING_MASK)
/** Start tuning is disabled (default) */
#define START_TUNING_ADC_START_TUN_OFF 0x0
/** Start tuning is enabled */
#define START_TUNING_ADC_START_TUN_ON 0x1

/** Breakpoint - enables the use of a breakpoint */
#define ADCTRIM_1_BREAKPOINT_MASK 0x2
#define ADCTRIM_1_BREAKPOINT_AFE_GET ((VR9_AfeRead(ADCTRIM_1) & ADCTRIM_1_BREAKPOINT_MASK) >> 1)
#define ADCTRIM_1_BREAKPOINT_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val) << 1, ADCTRIM_1_BREAKPOINT_MASK)
/** Breakpoint is disabled (default) */
#define BREAKPOINT_ADC_BREAKP_OFF 0x0
/** Breakpoint is enabled */
#define BREAKPOINT_ADC_BREAKP_ON 0x1

/** Continue - enables tuning to be continued */
#define ADCTRIM_1_CONTINUE_MASK 0x4
#define ADCTRIM_1_CONTINUE_AFE_GET ((VR9_AfeRead(ADCTRIM_1) & ADCTRIM_1_CONTINUE_MASK) >> 2)
#define ADCTRIM_1_CONTINUE_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val) << 2, ADCTRIM_1_CONTINUE_MASK)
/** Continue tuning is disabled (default) */
#define CONTINUE_ADC_CONTIN_TUN_OFF 0x0
/** Continue tuning is enabled */
#define CONTINUE_ADC_CONTIN_TUN_ON 0x1

/** Software Reset - enables software reset */
#define ADCTRIM_1_QT_SOFT_RESET_MASK 0x10
#define ADCTRIM_1_QT_SOFT_RESET_AFE_GET ((VR9_AfeRead(ADCTRIM_1) & ADCTRIM_1_QT_SOFT_RESET_MASK) >> 4)
#define ADCTRIM_1_QT_SOFT_RESET_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val) << 4, ADCTRIM_1_QT_SOFT_RESET_MASK)
/** Software Reset is disabled (default) */
#define QT_SOFT_RESET_ADC_QT_RST_OFF 0x0
/** Software Reset is enabled */
#define QT_SOFT_RESET_ADC_QT_RST_ON 0x1

#  define ADCTRIM_1_QT_SOFT_RESET_BREAKPOINT 0x12
#  define ADCTRIM_1_QT_SOFT_RESET_BREAKPOINT_AFE_GET ((VR9_AfeRead(ADCTRIM_1) & ADCTRIM_1_QT_SOFT_RESET_BREAKPOINT) >> 0)
#  define ADCTRIM_1_QT_SOFT_RESET_BREAKPOINT_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val) << 0, ADCTRIM_1_QT_SOFT_RESET_BREAKPOINT)

/* start_tuning=1, breakpoint=1 */
#  define ADCTRIM_1_START_TUNING_BREAKPOINT (ADCTRIM_1_START_TUNING_MASK | ADCTRIM_1_BREAKPOINT_MASK)
#  define ADCTRIM_1_START_TUNING_BREAKPOINT_AFE_GET ((VR9_AfeRead(ADCTRIM_1) & ADCTRIM_1_START_TUNING_BREAKPOINT) >> 0)
#  define ADCTRIM_1_START_TUNING_BREAKPOINT_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val) << 0, ADCTRIM_1_START_TUNING_BREAKPOINT)

/* start continue=1, breakpoint=1 */
#  define ADCTRIM_1_START_CONTINUE_BREAKPOINT (ADCTRIM_1_CONTINUE_MASK | ADCTRIM_1_BREAKPOINT_MASK)
#  define ADCTRIM_1_START_CONTINUE_BREAKPOINT_AFE_GET ((VR9_AfeRead(ADCTRIM_1) & ADCTRIM_1_START_CONTINUE_BREAKPOINT) >> 1)
#  define ADCTRIM_1_START_CONTINUE_BREAKPOINT_AFE_SET(val) VR9_AfeWrite(ADCTRIM_1, (val) << 1, ADCTRIM_1_START_CONTINUE_BREAKPOINT)
/* Continue tuning is disabled (default) */
#     define ADC_CONTINUE_BREAKPOINT_OFF 0x0
/* Continue tuning is enabled */
#     define ADC_CONTINUE_BREAKPOINT_ON  0x3
/** ADC Trimming Control Register 2 - ADC Trimming Control Register 2 */
#define ADCTRIM_2 (VINAX_AFE_DIG_GLOBAL_BASE + 0xa2)
#define ADCTRIM_2_AFE_GET VR9_AfeRead(ADCTRIM_2)
#define ADCTRIM_2_AFE_SET(val) VR9_AfeWrite(ADCTRIM_2, (val), 0xFFFF)

/** Quantizer window - defines the value of the Quantizer window */
#define ADCTRIM_2_QT_WINDOW_MASK 0x7fff
#define ADCTRIM_2_QT_WINDOW_AFE_GET ((VR9_AfeRead(ADCTRIM_2) & ADCTRIM_2_QT_WINDOW_MASK) >> 0)
#define ADCTRIM_2_QT_WINDOW_AFE_SET(val) VR9_AfeWrite(ADCTRIM_2, (val) << 0, ADCTRIM_2_QT_WINDOW_MASK)
/** Quantizer window , minimum value (0) */
#define QT_WINDOW_ADC_QT_WDW_MIN 0x0
/** Quantizer window, startup value (8192) (default) */
#define QT_WINDOW_ADC_QT_WDW_START 0x2000
/** Quantizer window, maximum value (32767) */
#define QT_WINDOW_ADC_QT_WDW_MAX 0x7fff


/** ADC Trimming Status Register - The ADC Trimming Status Register reports the quantizer status. */
#define ADCTRIM_STAT (VINAX_AFE_DIG_GLOBAL_BASE + 0xa3)
#define ADCTRIM_STAT_AFE_GET VR9_AfeRead(ADCTRIM_STAT)
#define ADCTRIM_STAT_AFE_SET(val) VR9_AfeWrite(ADCTRIM_STAT, (val), 0xFFFF)

/** Bit(s) Calibrated - reports the values of the calibrated bits */
#define ADCTRIM_STAT_BIT_CALIBRATED_MASK 0xf
#define ADCTRIM_STAT_BIT_CALIBRATED_AFE_GET ((VR9_AfeRead(ADCTRIM_STAT) & ADCTRIM_STAT_BIT_CALIBRATED_MASK) >> 0)
#define ADCTRIM_STAT_BIT_CALIBRATED_AFE_SET(val) VR9_AfeWrite(ADCTRIM_STAT, (val) << 0, ADCTRIM_STAT_BIT_CALIBRATED_MASK)
/** Bit calibrated, minimum value (0) (default) */
#define BIT_CALIBRATED_ADC_TRSTAT_CAL_VAL_MIN 0x0
/** Bit calibrated, maximum value (15) */
#define BIT_CALIBRATED_ADC_TRSTAT_CAL_VAL_MAX 0xf

/** Calibration Ongoing - reports the status of the calibration procedure */
#define ADCTRIM_STAT_CAL_ONGOING_MASK 0x10
#define ADCTRIM_STAT_CAL_ONGOING_AFE_GET ((VR9_AfeRead(ADCTRIM_STAT) & ADCTRIM_STAT_CAL_ONGOING_MASK) >> 4)
#define ADCTRIM_STAT_CAL_ONGOING_AFE_SET(val) VR9_AfeWrite(ADCTRIM_STAT, (val) << 4, ADCTRIM_STAT_CAL_ONGOING_MASK)
/** Calibration is not started or finished (default) */
#define CAL_ONGOING_ADC_TRSTAT_CAL_RDY 0x0
/** Calibration is ongoing */
#define CAL_ONGOING_ADC_TRATAT_CAL_NOT_RDY 0x1

/** Data Ready - reports the status of the calibration data */
#define ADCTRIM_STAT_DATA_READY_MASK 0x20
#define ADCTRIM_STAT_DATA_READY_AFE_GET ((VR9_AfeRead(ADCTRIM_STAT) & ADCTRIM_STAT_DATA_READY_MASK) >> 5)
#define ADCTRIM_STAT_DATA_READY_AFE_SET(val) VR9_AfeWrite(ADCTRIM_STAT, (val) << 5, ADCTRIM_STAT_DATA_READY_MASK)
/** Calibration data is not ready (default) */
#define DATA_READY_ADC_TRSTAT_DATA_NOT_RDY 0x0
/** Calibration data is ready */
#define DATA_READY_ADC_TRSTAT_DATA_RDY 0x1

/** Wait - reports a wait state */
#define ADCTRIM_STAT_WAIT_MASK 0x40
#define ADCTRIM_STAT_WAIT_AFE_GET ((VR9_AfeRead(ADCTRIM_STAT) & ADCTRIM_STAT_WAIT_MASK) >> 6)
#define ADCTRIM_STAT_WAIT_AFE_SET(val) VR9_AfeWrite(ADCTRIM_STAT, (val) << 6, ADCTRIM_STAT_WAIT_MASK)
/** Wait state is off (default) */
#define WAIT_ADC_TRSTAT_NO_WAIT 0x0
/** Wait state is on */
#define WAIT_ADC_TRSTAT_WAIT 0x1

/** ADC Trimming Value READ - reports value of ADC trimming READ */
#define ADCTRIM_STAT_ADC_TRIMVALRD_MASK 0x1f00
#define ADCTRIM_STAT_ADC_TRIMVALRD_AFE_GET ((VR9_AfeRead(ADCTRIM_STAT) & ADCTRIM_STAT_ADC_TRIMVALRD_MASK) >> 8)
#define ADCTRIM_STAT_ADC_TRIMVALRD_AFE_SET(val) VR9_AfeWrite(ADCTRIM_STAT, (val) << 8, ADCTRIM_STAT_ADC_TRIMVALRD_MASK)
/** Trimming value read, minimum value (0) (default) */
#define ADC_TRIMVALRD_ADC_TRSTAT_VAL_RD_MIN 0x0
/** Trimming value read, maximum value (31) */
#define ADC_TRIMVALRD_ADC_TRSTAT_VAL_RD_MAX 0x1f

#endif /* _VINAX_AFE_DIG_GLOBAL_H */
