/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
#ifndef _GLP_SLAVE_H
#define _GLP_SLAVE_H


#define GLP_SLAVE_BASE 0x100

/** Framer Control Register - This Register controls the override of status or behavior of the Framer. */
#define GLP_FR_CTRL (GLP_SLAVE_BASE + 0x0)
#define GLP_FR_CTRL_AFE_GET VR9_AfeRead(GLP_FR_CTRL)
#define GLP_FR_CTRL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val), 0xFFFF)

/** CRC detection status - Overrides CRC detection status of de-framers when OVR_CRC bits are OVR. */
#define GLP_FR_CTRL_CRC_MASK 0x3
#define GLP_FR_CTRL_CRC_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_CRC_MASK) >> 0)
#define GLP_FR_CTRL_CRC_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 0, GLP_FR_CTRL_CRC_MASK)

/** Word Alignment Status - Overrides Framer word alignment status bit when OVR_WD_AL is OVR. */
#define GLP_FR_CTRL_WD_AL_MASK 0x4
#define GLP_FR_CTRL_WD_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_WD_AL_MASK) >> 2)
#define GLP_FR_CTRL_WD_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 2, GLP_FR_CTRL_WD_AL_MASK)
/** Not Align */
#define WD_AL_NOT_AL 0x0
/** Align */
#define WD_AL_AL 0x1

/** Inband Alignment Status - Overrides Framer inband alignment status bit when OVR_IB_AL is OVR. */
#define GLP_FR_CTRL_IB_AL_MASK 0x8
#define GLP_FR_CTRL_IB_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_IB_AL_MASK) >> 3)
#define GLP_FR_CTRL_IB_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 3, GLP_FR_CTRL_IB_AL_MASK)
/** Not Align */
#define IB_AL_NOT_AL 0x0
/** Align */
#define IB_AL_AL 0x1

/** Frame Alignment Status - Overrides Frame alignment status bit when OVR_FM_AL is OVR. */
#define GLP_FR_CTRL_FM_AL_MASK 0x10
#define GLP_FR_CTRL_FM_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_FM_AL_MASK) >> 4)
#define GLP_FR_CTRL_FM_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 4, GLP_FR_CTRL_FM_AL_MASK)
/** Not Align */
#define FM_AL_NOT_AL 0x0
/** Align */
#define FM_AL_AL 0x1

/** Remote Frame Alignment Status - Overrides Remote Framer alignment status bit when OVR_RMT_AL is OVR. */
#define GLP_FR_CTRL_RMT_FM_AL_MASK 0x20
#define GLP_FR_CTRL_RMT_FM_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_RMT_FM_AL_MASK) >> 5)
#define GLP_FR_CTRL_RMT_FM_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 5, GLP_FR_CTRL_RMT_FM_AL_MASK)
/** Not Align */
#define RMT_FM_AL_NOT_AL 0x0
/** Align */
#define RMT_FM_AL_AL 0x1

/** Transmit ready Status - Overrides Framer Transmit Ready status bit when OVR_TX_RDY is OVR. */
#define GLP_FR_CTRL_TX_RDY_MASK 0x40
#define GLP_FR_CTRL_TX_RDY_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_TX_RDY_MASK) >> 6)
#define GLP_FR_CTRL_TX_RDY_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 6, GLP_FR_CTRL_TX_RDY_MASK)
/** Not Ready */
#define TX_RDY_NOT_RDY 0x0
/** Ready */
#define TX_RDY_RDY 0x1

/** Word Check - Overrides Unique word checking enable status when OVR_WD_CHK is OVR. */
#define GLP_FR_CTRL_WD_CHK_MASK 0x80
#define GLP_FR_CTRL_WD_CHK_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_WD_CHK_MASK) >> 7)
#define GLP_FR_CTRL_WD_CHK_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 7, GLP_FR_CTRL_WD_CHK_MASK)
/** Enable */
#define WD_CHK_EN 0x0
/** Disable */
#define WD_CHK_DIS 0x1

/** Override CRC status - Controls override of CRC detection status of de-framers. */
#define GLP_FR_CTRL_OVR_CRC_MASK 0x300
#define GLP_FR_CTRL_OVR_CRC_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_OVR_CRC_MASK) >> 8)
#define GLP_FR_CTRL_OVR_CRC_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 8, GLP_FR_CTRL_OVR_CRC_MASK)

/** Override word alignment - Controls override of word alignment status. */
#define GLP_FR_CTRL_OVR_WD_AL_MASK 0x400
#define GLP_FR_CTRL_OVR_WD_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_OVR_WD_AL_MASK) >> 10)
#define GLP_FR_CTRL_OVR_WD_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 10, GLP_FR_CTRL_OVR_WD_AL_MASK)
/** No override */
#define OVR_WD_AL_NO_OVR 0x0
/** Override */
#define OVR_WD_AL_OVR 0x1

/** Override inband alignment - Controls override of inband alignment status. */
#define GLP_FR_CTRL_OVR_IB_AL_MASK 0x800
#define GLP_FR_CTRL_OVR_IB_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_OVR_IB_AL_MASK) >> 11)
#define GLP_FR_CTRL_OVR_IB_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 11, GLP_FR_CTRL_OVR_IB_AL_MASK)
/** No override */
#define OVR_IB_AL_NO_OVR 0x0
/** Override */
#define OVR_IB_AL_OVR 0x1

/** Override frame alignment - Controls override of frame alignment status. */
#define GLP_FR_CTRL_OVR_FM_AL_MASK 0x1000
#define GLP_FR_CTRL_OVR_FM_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_OVR_FM_AL_MASK) >> 12)
#define GLP_FR_CTRL_OVR_FM_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 12, GLP_FR_CTRL_OVR_FM_AL_MASK)
/** No override */
#define OVR_FM_AL_NO_OVR 0x0
/** Override */
#define OVR_FM_AL_OVR 0x1

/** Override remote alignment - Controls override of remote alignment status. */
#define GLP_FR_CTRL_OVR_RMT_AL_MASK 0x2000
#define GLP_FR_CTRL_OVR_RMT_AL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_OVR_RMT_AL_MASK) >> 13)
#define GLP_FR_CTRL_OVR_RMT_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 13, GLP_FR_CTRL_OVR_RMT_AL_MASK)
/** No override */
#define OVR_RMT_AL_NO_OVR 0x0
/** Override */
#define OVR_RMT_AL_OVR 0x1

/** Override Transmit ready - Controls override of transmit ready status. */
#define GLP_FR_CTRL_OVR_TX_RDY_MASK 0x4000
#define GLP_FR_CTRL_OVR_TX_RDY_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_OVR_TX_RDY_MASK) >> 14)
#define GLP_FR_CTRL_OVR_TX_RDY_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 14, GLP_FR_CTRL_OVR_TX_RDY_MASK)
/** No override */
#define OVR_TX_RDY_NO_OVR 0x0
/** Override */
#define OVR_TX_RDY_OVR 0x1

/** Override Word Check - Controls override of unique word checking. */
#define GLP_FR_CTRL_OVR_WD_CHK_MASK 0x8000
#define GLP_FR_CTRL_OVR_WD_CHK_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL) & GLP_FR_CTRL_OVR_WD_CHK_MASK) >> 15)
#define GLP_FR_CTRL_OVR_WD_CHK_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL, (val) << 15, GLP_FR_CTRL_OVR_WD_CHK_MASK)
/** No override */
#define OVR_WD_CHK_NO_OVR 0x0
/** Override */
#define OVR_WD_CHK_OVR 0x1


/** Framer Status Register - This Register is the Framer's status register. */
#define GLP_FR_STATUS (GLP_SLAVE_BASE + 0x1)
#define GLP_FR_STATUS_AFE_GET VR9_AfeRead(GLP_FR_STATUS)
#define GLP_FR_STATUS_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val), 0xFFFF)

/** CRC detection status - CRC detection status of de-framers. */
#define GLP_FR_STATUS_CRC_MASK 0x3
#define GLP_FR_STATUS_CRC_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_CRC_MASK) >> 0)
#define GLP_FR_STATUS_CRC_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 0, GLP_FR_STATUS_CRC_MASK)

/** Word Alignment Status - Framer word alignment status bit. */
#define GLP_FR_STATUS_WD_AL_MASK 0x4
#define GLP_FR_STATUS_WD_AL_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_WD_AL_MASK) >> 2)
#define GLP_FR_STATUS_WD_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 2, GLP_FR_STATUS_WD_AL_MASK)
/** Not Align */
#define WD_AL_NOT_AL 0x0
/** Align */
#define WD_AL_AL 0x1

/** Inband Alignment Status - Framer inband alignment status bit. */
#define GLP_FR_STATUS_IB_AL_MASK 0x8
#define GLP_FR_STATUS_IB_AL_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_IB_AL_MASK) >> 3)
#define GLP_FR_STATUS_IB_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 3, GLP_FR_STATUS_IB_AL_MASK)
/** Not Align */
#define IB_AL_NOT_AL 0x0
/** Align */
#define IB_AL_AL 0x1

/** Frame Alignment Status - Frame alignment status bit. */
#define GLP_FR_STATUS_FM_AL_MASK 0x10
#define GLP_FR_STATUS_FM_AL_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_FM_AL_MASK) >> 4)
#define GLP_FR_STATUS_FM_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 4, GLP_FR_STATUS_FM_AL_MASK)
/** Not Align */
#define FM_AL_NOT_AL 0x0
/** Align */
#define FM_AL_AL 0x1

/** Remote Frame Alignment Status - Remote Framer alignment status bit. */
#define GLP_FR_STATUS_RMT_FM_AL_MASK 0x20
#define GLP_FR_STATUS_RMT_FM_AL_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_RMT_FM_AL_MASK) >> 5)
#define GLP_FR_STATUS_RMT_FM_AL_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 5, GLP_FR_STATUS_RMT_FM_AL_MASK)
/** Not Align */
#define RMT_FM_AL_NOT_AL 0x0
/** Align */
#define RMT_FM_AL_AL 0x1

/** Transmit ready Status - Framer Transmit Ready status bit. */
#define GLP_FR_STATUS_TX_RDY_MASK 0x40
#define GLP_FR_STATUS_TX_RDY_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_TX_RDY_MASK) >> 6)
#define GLP_FR_STATUS_TX_RDY_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 6, GLP_FR_STATUS_TX_RDY_MASK)
/** Not Ready */
#define TX_RDY_NOT_RDY 0x0
/** Ready */
#define TX_RDY_RDY 0x1

/** Word Check - Unique word checking enable status. */
#define GLP_FR_STATUS_WD_CHK_MASK 0x80
#define GLP_FR_STATUS_WD_CHK_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_WD_CHK_MASK) >> 7)
#define GLP_FR_STATUS_WD_CHK_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 7, GLP_FR_STATUS_WD_CHK_MASK)
/** Enable */
#define WD_CHK_EN 0x0
/** Disable */
#define WD_CHK_DIS 0x1

/** PMD/PHY Enable - Framer to PHY enable status. */
#define GLP_FR_STATUS_PHY_EN_MASK 0x100
#define GLP_FR_STATUS_PHY_EN_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_PHY_EN_MASK) >> 8)
#define GLP_FR_STATUS_PHY_EN_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 8, GLP_FR_STATUS_PHY_EN_MASK)
/** Enable */
#define PHY_EN_EN 0x0
/** Disable */
#define PHY_EN_DIS 0x1

/** Override Inband Control bits - Inband Control to be transmitted. */
#define GLP_FR_STATUS_IBCTRL_MASK 0x1e00
#define GLP_FR_STATUS_IBCTRL_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_IBCTRL_MASK) >> 9)
#define GLP_FR_STATUS_IBCTRL_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 9, GLP_FR_STATUS_IBCTRL_MASK)

/** FSM State - Framer State Machine. */
#define GLP_FR_STATUS_STATE_MASK 0xe000
#define GLP_FR_STATUS_STATE_AFE_GET ((VR9_AfeRead(GLP_FR_STATUS) & GLP_FR_STATUS_STATE_MASK) >> 13)
#define GLP_FR_STATUS_STATE_AFE_SET(val) VR9_AfeWrite(GLP_FR_STATUS, (val) << 13, GLP_FR_STATUS_STATE_MASK)
/** Off */
#define STATE_OFF 0x0
/** Initialise Phy */
#define STATE_INIT_PHY 0x1
/** Word Lock */
#define STATE_WORD_LOCK 0x2
/** Bit Lock */
#define STATE_BIT_LOCK 0x3
/** Bit Lock Wait */
#define STATE_BIT_LOCK_WAIT 0x4
/** Frame Lock */
#define STATE_FRAME_LOCK 0x5
/** Wait for other framer lock */
#define STATE_WAIT_FOR_OTHER 0x6
/** Ready */
#define STATE_READY 0x7


/** Framer Control 2 Register - This Register controls the behavior of the Framer. */
#define GLP_FR_CTRL2 (GLP_SLAVE_BASE + 0x2)
#define GLP_FR_CTRL2_AFE_GET VR9_AfeRead(GLP_FR_CTRL2)
#define GLP_FR_CTRL2_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL2, (val), 0xFFFF)

/** Deframer 1 Word Alignment Index - Overrides or reads Word Alignment Index of the deframer 1. Override value written when OVR_IDX[0] is 1. */
#define GLP_FR_CTRL2_FR_1_IDX_MASK 0x3f
#define GLP_FR_CTRL2_FR_1_IDX_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL2) & GLP_FR_CTRL2_FR_1_IDX_MASK) >> 0)
#define GLP_FR_CTRL2_FR_1_IDX_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL2, (val) << 0, GLP_FR_CTRL2_FR_1_IDX_MASK)

/** Deframer 1 Word Alignment Index - Overrides or reads Word Alignment Index of the deframer 2. Override value written when OVR_IDX[0] is 1. */
#define GLP_FR_CTRL2_FR_2_IDX_MASK 0xfc0
#define GLP_FR_CTRL2_FR_2_IDX_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL2) & GLP_FR_CTRL2_FR_2_IDX_MASK) >> 6)
#define GLP_FR_CTRL2_FR_2_IDX_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL2, (val) << 6, GLP_FR_CTRL2_FR_2_IDX_MASK)

/** Enable override of Word Alignment Index - Controls override of Word Alignment Index for corresponding de-framer. */
#define GLP_FR_CTRL2_OVR_IDX_MASK 0x3000
#define GLP_FR_CTRL2_OVR_IDX_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL2) & GLP_FR_CTRL2_OVR_IDX_MASK) >> 12)
#define GLP_FR_CTRL2_OVR_IDX_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL2, (val) << 12, GLP_FR_CTRL2_OVR_IDX_MASK)
/** Overrides the Frame Index of deframer 1 */
#define OVR_IDX_OVR_FR_1_IDX 0x1
/** Overrides the Frame Index of deframer 2 */
#define OVR_IDX_OVR_FR_2_IDX 0x2


/** Framer Control 3 Register - This Register controls the behavior of the Framer. */
#define GLP_FR_CTRL3 (GLP_SLAVE_BASE + 0x3)
#define GLP_FR_CTRL3_AFE_GET VR9_AfeRead(GLP_FR_CTRL3)
#define GLP_FR_CTRL3_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val), 0xFFFF)

/** TX Enables - Enables for framer module (TX). */
#define GLP_FR_CTRL3_TX_EN_MASK 0x1
#define GLP_FR_CTRL3_TX_EN_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_TX_EN_MASK) >> 0)
#define GLP_FR_CTRL3_TX_EN_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 0, GLP_FR_CTRL3_TX_EN_MASK)
/** Disable */
#define TX_EN_DIS 0x0
/** Enable */
#define TX_EN_EN 0x1

/** RX Enables - Enables for de-framer modules (RX). */
#define GLP_FR_CTRL3_RX_EN_MASK 0x6
#define GLP_FR_CTRL3_RX_EN_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_RX_EN_MASK) >> 1)
#define GLP_FR_CTRL3_RX_EN_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 1, GLP_FR_CTRL3_RX_EN_MASK)
/** Enable RX Lane 1 */
#define RX_EN_EN_RX_1 0x1
/** Enable RX Lane 2 */
#define RX_EN_EN_RX_2 0x2

/** Inband Control Override Enable - Bit used to enable override of Inband Control bits in framer. */
#define GLP_FR_CTRL3_OVR_IB_EN_MASK 0x8
#define GLP_FR_CTRL3_OVR_IB_EN_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_OVR_IB_EN_MASK) >> 3)
#define GLP_FR_CTRL3_OVR_IB_EN_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 3, GLP_FR_CTRL3_OVR_IB_EN_MASK)
/** Disable */
#define OVR_IB_EN_DIS 0x0
/** Enable */
#define OVR_IB_EN_EN 0x1

/** Override Inband Control bits - This overrides the Inband Control to be transmitted when OVR_IB_EN is EN. */
#define GLP_FR_CTRL3_IBCTRL_MASK 0xf0
#define GLP_FR_CTRL3_IBCTRL_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_IBCTRL_MASK) >> 4)
#define GLP_FR_CTRL3_IBCTRL_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 4, GLP_FR_CTRL3_IBCTRL_MASK)

/** Override PMD/PHY Enable - Controls override of PHY enable. */
#define GLP_FR_CTRL3_OVR_PHY_EN_MASK 0x100
#define GLP_FR_CTRL3_OVR_PHY_EN_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_OVR_PHY_EN_MASK) >> 8)
#define GLP_FR_CTRL3_OVR_PHY_EN_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 8, GLP_FR_CTRL3_OVR_PHY_EN_MASK)
/** No override */
#define OVR_PHY_EN_NO_OVR 0x0
/** Override */
#define OVR_PHY_EN_OVR 0x1

/** PMD/PHY Enable - This overrides the Framer to PHY enable bit when OVR_PHY_EN is OVR. */
#define GLP_FR_CTRL3_PHY_EN_MASK 0x200
#define GLP_FR_CTRL3_PHY_EN_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_PHY_EN_MASK) >> 9)
#define GLP_FR_CTRL3_PHY_EN_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 9, GLP_FR_CTRL3_PHY_EN_MASK)
/** Enable */
#define PHY_EN_EN 0x0
/** Disable */
#define PHY_EN_DIS 0x1

/** Watchdog disable bit - Bit used to disable watchdog function. */
#define GLP_FR_CTRL3_WDG_DIS_MASK 0x400
#define GLP_FR_CTRL3_WDG_DIS_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_WDG_DIS_MASK) >> 10)
#define GLP_FR_CTRL3_WDG_DIS_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 10, GLP_FR_CTRL3_WDG_DIS_MASK)
/** Enable */
#define WDG_DIS_EN 0x0
/** Disable */
#define WDG_DIS_DIS 0x1

/** Transmit Corrupt CRC - Bit used to send corrupt CRC in the framer. */
#define GLP_FR_CTRL3_TX_BADCRC_MASK 0x800
#define GLP_FR_CTRL3_TX_BADCRC_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_TX_BADCRC_MASK) >> 11)
#define GLP_FR_CTRL3_TX_BADCRC_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 11, GLP_FR_CTRL3_TX_BADCRC_MASK)
/** Enable */
#define TX_BADCRC_EN 0x0
/** Disable */
#define TX_BADCRC_DIS 0x1

/** Debug Mode Enable - Bit used to enable stepped debug mode in framer state machine. */
#define GLP_FR_CTRL3_DBG_MODE_MASK 0x1000
#define GLP_FR_CTRL3_DBG_MODE_AFE_GET ((VR9_AfeRead(GLP_FR_CTRL3) & GLP_FR_CTRL3_DBG_MODE_MASK) >> 12)
#define GLP_FR_CTRL3_DBG_MODE_AFE_SET(val) VR9_AfeWrite(GLP_FR_CTRL3, (val) << 12, GLP_FR_CTRL3_DBG_MODE_MASK)
/** Enable */
#define DBG_MODE_EN 0x0
/** Disable */
#define DBG_MODE_DIS 0x1


/** Framer Bit Lock Count Register - This register is used to configure the number of consecutive unique words the framer will receive before getting bit alignment. */
#define GLP_FR_BITLOCK (GLP_SLAVE_BASE + 0x4)
#define GLP_FR_BITLOCK_AFE_GET VR9_AfeRead(GLP_FR_BITLOCK)
#define GLP_FR_BITLOCK_AFE_SET(val) VR9_AfeWrite(GLP_FR_BITLOCK, (val), 0xFFFF)

/** Framer Bit Lock Counter Limit - Sets the counter value in framer for bit alignment. */
#define GLP_FR_BITLOCK_CNT_MASK 0xff
#define GLP_FR_BITLOCK_CNT_AFE_GET ((VR9_AfeRead(GLP_FR_BITLOCK) & GLP_FR_BITLOCK_CNT_MASK) >> 0)
#define GLP_FR_BITLOCK_CNT_AFE_SET(val) VR9_AfeWrite(GLP_FR_BITLOCK, (val) << 0, GLP_FR_BITLOCK_CNT_MASK)


/** Framer Watchdog Configuration Register - This register is used to configure the limit for the framer's watchdog. */
#define GLP_FR_WDG_CFG (GLP_SLAVE_BASE + 0x5)
#define GLP_FR_WDG_CFG_AFE_GET VR9_AfeRead(GLP_FR_WDG_CFG)
#define GLP_FR_WDG_CFG_AFE_SET(val) VR9_AfeWrite(GLP_FR_WDG_CFG, (val), 0xFFFF)

/** Framer Watchdog Timer Limit - Sets the watchdog timer limit for the framer to restart word alignment search. */
#define GLP_FR_WDG_CFG_TIMER_LIM_MASK 0xffff
#define GLP_FR_WDG_CFG_TIMER_LIM_AFE_GET ((VR9_AfeRead(GLP_FR_WDG_CFG) & GLP_FR_WDG_CFG_TIMER_LIM_MASK) >> 0)
#define GLP_FR_WDG_CFG_TIMER_LIM_AFE_SET(val) VR9_AfeWrite(GLP_FR_WDG_CFG, (val) << 0, GLP_FR_WDG_CFG_TIMER_LIM_MASK)


/** Framer Error Limit Register - This Register sets limits based on the error events that control state machine. */
#define GLP_FR_ERR_LIM (GLP_SLAVE_BASE + 0x6)
#define GLP_FR_ERR_LIM_AFE_GET VR9_AfeRead(GLP_FR_ERR_LIM)
#define GLP_FR_ERR_LIM_AFE_SET(val) VR9_AfeWrite(GLP_FR_ERR_LIM, (val), 0xFFFF)

/** Maximum CRC errors received - Sets the maximum number of CRC errors received before framer re-starts word alignment search. */
#define GLP_FR_ERR_LIM_MAX_CRC_MASK 0xff
#define GLP_FR_ERR_LIM_MAX_CRC_AFE_GET ((VR9_AfeRead(GLP_FR_ERR_LIM) & GLP_FR_ERR_LIM_MAX_CRC_MASK) >> 0)
#define GLP_FR_ERR_LIM_MAX_CRC_AFE_SET(val) VR9_AfeWrite(GLP_FR_ERR_LIM, (val) << 0, GLP_FR_ERR_LIM_MAX_CRC_MASK)

/** Minimum count of no error received - Sets the minimum count of "no errors" condition received before resetting framer's error counter. */
#define GLP_FR_ERR_LIM_MIN_NO_MASK 0xff00
#define GLP_FR_ERR_LIM_MIN_NO_AFE_GET ((VR9_AfeRead(GLP_FR_ERR_LIM) & GLP_FR_ERR_LIM_MIN_NO_MASK) >> 8)
#define GLP_FR_ERR_LIM_MIN_NO_AFE_SET(val) VR9_AfeWrite(GLP_FR_ERR_LIM, (val) << 8, GLP_FR_ERR_LIM_MIN_NO_MASK)


/** Framer Unique Word Configuration Register - This register is used to configure the unique word used for framing. */
#define GLP_FR_UNIQ_WD (GLP_SLAVE_BASE + 0x7)
#define GLP_FR_UNIQ_WD_AFE_GET VR9_AfeRead(GLP_FR_UNIQ_WD)
#define GLP_FR_UNIQ_WD_AFE_SET(val) VR9_AfeWrite(GLP_FR_UNIQ_WD, (val), 0xFFFF)

/** Framer Unique Word - Sets the unique word in framer for word alignment. */
#define GLP_FR_UNIQ_WD_WORD_MASK 0xffff
#define GLP_FR_UNIQ_WD_WORD_AFE_GET ((VR9_AfeRead(GLP_FR_UNIQ_WD) & GLP_FR_UNIQ_WD_WORD_MASK) >> 0)
#define GLP_FR_UNIQ_WD_WORD_AFE_SET(val) VR9_AfeWrite(GLP_FR_UNIQ_WD, (val) << 0, GLP_FR_UNIQ_WD_WORD_MASK)


/** Framer Received Unique Word 1 Register - This register is used to read the received unique word in deframer 1. */
#define GLP_FR_RX_UNIQ_WD_1 (GLP_SLAVE_BASE + 0x8)
#define GLP_FR_RX_UNIQ_WD_1_AFE_GET VR9_AfeRead(GLP_FR_RX_UNIQ_WD_1)
#define GLP_FR_RX_UNIQ_WD_1_AFE_SET(val) VR9_AfeWrite(GLP_FR_RX_UNIQ_WD_1, (val), 0xFFFF)

/** Framer Unique Word - Reads the received unique word in deframer 1 for word alignment. */
#define GLP_FR_RX_UNIQ_WD_1_WORD_MASK 0xffff
#define GLP_FR_RX_UNIQ_WD_1_WORD_AFE_GET ((VR9_AfeRead(GLP_FR_RX_UNIQ_WD_1) & GLP_FR_RX_UNIQ_WD_1_WORD_MASK) >> 0)
#define GLP_FR_RX_UNIQ_WD_1_WORD_AFE_SET(val) VR9_AfeWrite(GLP_FR_RX_UNIQ_WD_1, (val) << 0, GLP_FR_RX_UNIQ_WD_1_WORD_MASK)


/** Framer Received Unique Word 2 Register - This register is used to read the received unique word in deframer 2. */
#define GLP_FR_RX_UNIQ_WD_2 (GLP_SLAVE_BASE + 0x9)
#define GLP_FR_RX_UNIQ_WD_2_AFE_GET VR9_AfeRead(GLP_FR_RX_UNIQ_WD_2)
#define GLP_FR_RX_UNIQ_WD_2_AFE_SET(val) VR9_AfeWrite(GLP_FR_RX_UNIQ_WD_2, (val), 0xFFFF)

/** Framer Unique Word - Reads the received unique word in deframer 2 for word alignment. */
#define GLP_FR_RX_UNIQ_WD_2_WORD_MASK 0xffff
#define GLP_FR_RX_UNIQ_WD_2_WORD_AFE_GET ((VR9_AfeRead(GLP_FR_RX_UNIQ_WD_2) & GLP_FR_RX_UNIQ_WD_2_WORD_MASK) >> 0)
#define GLP_FR_RX_UNIQ_WD_2_WORD_AFE_SET(val) VR9_AfeWrite(GLP_FR_RX_UNIQ_WD_2, (val) << 0, GLP_FR_RX_UNIQ_WD_2_WORD_MASK)


/** Framer Error Register - This Register is for reading of the total errors received. */
#define GLP_FR_ERR (GLP_SLAVE_BASE + 0xa)
#define GLP_FR_ERR_AFE_GET VR9_AfeRead(GLP_FR_ERR)
#define GLP_FR_ERR_AFE_SET(val) VR9_AfeWrite(GLP_FR_ERR, (val), 0xFFFF)

/** Total Number of errors received - Total number of errors received. */
#define GLP_FR_ERR_TOT_ERR_MASK 0xffff
#define GLP_FR_ERR_TOT_ERR_AFE_GET ((VR9_AfeRead(GLP_FR_ERR) & GLP_FR_ERR_TOT_ERR_MASK) >> 0)
#define GLP_FR_ERR_TOT_ERR_AFE_SET(val) VR9_AfeWrite(GLP_FR_ERR, (val) << 0, GLP_FR_ERR_TOT_ERR_MASK)


/** BIST Control Register - This Register is the BIST's control register. */
#define GLP_BIST_CTRL (GLP_SLAVE_BASE + 0xb)
#define GLP_BIST_CTRL_AFE_GET VR9_AfeRead(GLP_BIST_CTRL)
#define GLP_BIST_CTRL_AFE_SET(val) VR9_AfeWrite(GLP_BIST_CTRL, (val), 0xFFFF)

/** Bypass - TX_EN and RX_EN will select the respective slices for BIST when BYPASS is EN.  */
#define GLP_BIST_CTRL_BYPASS_MASK 0x1
#define GLP_BIST_CTRL_BYPASS_AFE_GET ((VR9_AfeRead(GLP_BIST_CTRL) & GLP_BIST_CTRL_BYPASS_MASK) >> 0)
#define GLP_BIST_CTRL_BYPASS_AFE_SET(val) VR9_AfeWrite(GLP_BIST_CTRL, (val) << 0, GLP_BIST_CTRL_BYPASS_MASK)
/** Disable Bypass */
#define BYPASS_DIS 0x0
/** Enable Bypass */
#define BYPASS_EN 0x1

/** TX Enables - Enables for TX Lanes for BIST loop. */
#define GLP_BIST_CTRL_TX_EN_MASK 0x2
#define GLP_BIST_CTRL_TX_EN_AFE_GET ((VR9_AfeRead(GLP_BIST_CTRL) & GLP_BIST_CTRL_TX_EN_MASK) >> 1)
#define GLP_BIST_CTRL_TX_EN_AFE_SET(val) VR9_AfeWrite(GLP_BIST_CTRL, (val) << 1, GLP_BIST_CTRL_TX_EN_MASK)
/** Disable */
#define TX_EN_DIS 0x0
/** Enable */
#define TX_EN_EN 0x1

/** RX Enables - Enables for RX Lanes for BIST loop. */
#define GLP_BIST_CTRL_RX_EN_MASK 0xc
#define GLP_BIST_CTRL_RX_EN_AFE_GET ((VR9_AfeRead(GLP_BIST_CTRL) & GLP_BIST_CTRL_RX_EN_MASK) >> 2)
#define GLP_BIST_CTRL_RX_EN_AFE_SET(val) VR9_AfeWrite(GLP_BIST_CTRL, (val) << 2, GLP_BIST_CTRL_RX_EN_MASK)
/** Enable RX BIST 1 */
#define RX_EN_RX_BIST_EN_1 0x1
/** Enable RX BIST 2 */
#define RX_EN_RX_BIST_EN_2 0x2

/** Enable Override of Bist Enable - Controls override of BIST enable. */
#define GLP_BIST_CTRL_OVR_EN_MASK 0x10
#define GLP_BIST_CTRL_OVR_EN_AFE_GET ((VR9_AfeRead(GLP_BIST_CTRL) & GLP_BIST_CTRL_OVR_EN_MASK) >> 4)
#define GLP_BIST_CTRL_OVR_EN_AFE_SET(val) VR9_AfeWrite(GLP_BIST_CTRL, (val) << 4, GLP_BIST_CTRL_OVR_EN_MASK)
/** No override */
#define OVR_EN_NO_OVR 0x0
/** Override */
#define OVR_EN_OVR 0x1

/** Enable Bist - Override of BIST enable when OVR_EN is OVR. */
#define GLP_BIST_CTRL_EN_MASK 0x20
#define GLP_BIST_CTRL_EN_AFE_GET ((VR9_AfeRead(GLP_BIST_CTRL) & GLP_BIST_CTRL_EN_MASK) >> 5)
#define GLP_BIST_CTRL_EN_AFE_SET(val) VR9_AfeWrite(GLP_BIST_CTRL, (val) << 5, GLP_BIST_CTRL_EN_MASK)
/** Enable */
#define EN_EN 0x0
/** Disable */
#define EN_DIS 0x1


/** Phase Lock Count Register - This Register is the BIST's phase lock count register. */
#define GLP_BIST_PHLOCK (GLP_SLAVE_BASE + 0xc)
#define GLP_BIST_PHLOCK_AFE_GET VR9_AfeRead(GLP_BIST_PHLOCK)
#define GLP_BIST_PHLOCK_AFE_SET(val) VR9_AfeWrite(GLP_BIST_PHLOCK, (val), 0xFFFF)

/** Phase Lock Count - Programs the counter value for the BIST to achieve phase lock. */
#define GLP_BIST_PHLOCK_COUNT_MASK 0x3ff
#define GLP_BIST_PHLOCK_COUNT_AFE_GET ((VR9_AfeRead(GLP_BIST_PHLOCK) & GLP_BIST_PHLOCK_COUNT_MASK) >> 0)
#define GLP_BIST_PHLOCK_COUNT_AFE_SET(val) VR9_AfeWrite(GLP_BIST_PHLOCK, (val) << 0, GLP_BIST_PHLOCK_COUNT_MASK)


/** Bist Endcount Register - This Register is the BIST's word count register. */
#define GLP_BIST_END (GLP_SLAVE_BASE + 0xd)
#define GLP_BIST_END_AFE_GET VR9_AfeRead(GLP_BIST_END)
#define GLP_BIST_END_AFE_SET(val) VR9_AfeWrite(GLP_BIST_END, (val), 0xFFFF)

/** Word Count - Programs the number of words for the BIST to check for errors. */
#define GLP_BIST_END_COUNT_MASK 0x3ff
#define GLP_BIST_END_COUNT_AFE_GET ((VR9_AfeRead(GLP_BIST_END) & GLP_BIST_END_COUNT_MASK) >> 0)
#define GLP_BIST_END_COUNT_AFE_SET(val) VR9_AfeWrite(GLP_BIST_END, (val) << 0, GLP_BIST_END_COUNT_MASK)


/** BERT Termination Count Register - This Register is the BERT's termination count register. */
#define GLP_BERT_TERM (GLP_SLAVE_BASE + 0xe)
#define GLP_BERT_TERM_AFE_GET VR9_AfeRead(GLP_BERT_TERM)
#define GLP_BERT_TERM_AFE_SET(val) VR9_AfeWrite(GLP_BERT_TERM, (val), 0xFFFF)

/** Word Count - Read the number of words BERT receives at termination. */
#define GLP_BERT_TERM_COUNT_MASK 0x3ff
#define GLP_BERT_TERM_COUNT_AFE_GET ((VR9_AfeRead(GLP_BERT_TERM) & GLP_BERT_TERM_COUNT_MASK) >> 0)
#define GLP_BERT_TERM_COUNT_AFE_SET(val) VR9_AfeWrite(GLP_BERT_TERM, (val) << 0, GLP_BERT_TERM_COUNT_MASK)


/** BERT Error Count Register - This Register is the BERT's Error count register. */
#define GLP_BERT_ERR (GLP_SLAVE_BASE + 0xf)
#define GLP_BERT_ERR_AFE_GET VR9_AfeRead(GLP_BERT_ERR)
#define GLP_BERT_ERR_AFE_SET(val) VR9_AfeWrite(GLP_BERT_ERR, (val), 0xFFFF)

/** Word Count - Read the number of accumulated bit errors. */
#define GLP_BERT_ERR_COUNT_MASK 0x3ff
#define GLP_BERT_ERR_COUNT_AFE_GET ((VR9_AfeRead(GLP_BERT_ERR) & GLP_BERT_ERR_COUNT_MASK) >> 0)
#define GLP_BERT_ERR_COUNT_AFE_SET(val) VR9_AfeWrite(GLP_BERT_ERR, (val) << 0, GLP_BERT_ERR_COUNT_MASK)


/** BERT Control Register - This Register is the BERTs' control register. */
#define GLP_BERT_CTRL (GLP_SLAVE_BASE + 0x10)
#define GLP_BERT_CTRL_AFE_GET VR9_AfeRead(GLP_BERT_CTRL)
#define GLP_BERT_CTRL_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val), 0xFFFF)

/** BERT TX Reset - Reset Bits (Active low) for BERT TX. */
#define GLP_BERT_CTRL_TX_RST_MASK 0x1
#define GLP_BERT_CTRL_TX_RST_AFE_GET ((VR9_AfeRead(GLP_BERT_CTRL) & GLP_BERT_CTRL_TX_RST_MASK) >> 0)
#define GLP_BERT_CTRL_TX_RST_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val) << 0, GLP_BERT_CTRL_TX_RST_MASK)
/** Reset */
#define TX_RST_RST 0x0
/** No Reset */
#define TX_RST_NO_RST 0x1

/** BERT RX Resets - Reset Bits (Active low) for each BERT RX. */
#define GLP_BERT_CTRL_RX_RST_MASK 0x6
#define GLP_BERT_CTRL_RX_RST_AFE_GET ((VR9_AfeRead(GLP_BERT_CTRL) & GLP_BERT_CTRL_RX_RST_MASK) >> 1)
#define GLP_BERT_CTRL_RX_RST_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val) << 1, GLP_BERT_CTRL_RX_RST_MASK)
/** Reset */
#define RX_RST_RST 0x0
/** No Reset */
#define RX_RST_NO_RST 0x1

/** BERT Word Count reset - Resets the BERT Termination Count Register of the enabled BERT.  */
#define GLP_BERT_CTRL_WRD_RST_MASK 0x8
#define GLP_BERT_CTRL_WRD_RST_AFE_GET ((VR9_AfeRead(GLP_BERT_CTRL) & GLP_BERT_CTRL_WRD_RST_MASK) >> 3)
#define GLP_BERT_CTRL_WRD_RST_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val) << 3, GLP_BERT_CTRL_WRD_RST_MASK)
/** No Reset */
#define WRD_RST_NO_RST 0x0
/** Reset */
#define WRD_RST_RST 0x1

/** BERT Error Count reset - Resets the BERT Error Count Register of the enabled BERT.  */
#define GLP_BERT_CTRL_ERR_RST_MASK 0x10
#define GLP_BERT_CTRL_ERR_RST_AFE_GET ((VR9_AfeRead(GLP_BERT_CTRL) & GLP_BERT_CTRL_ERR_RST_MASK) >> 4)
#define GLP_BERT_CTRL_ERR_RST_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val) << 4, GLP_BERT_CTRL_ERR_RST_MASK)
/** No Reset */
#define ERR_RST_NO_RST 0x0
/** Reset */
#define ERR_RST_RST 0x1

/** Scramble Enable - Data from BERTs will be used for scrambling data to PHY if enabled.  */
#define GLP_BERT_CTRL_SCR_EN_MASK 0x20
#define GLP_BERT_CTRL_SCR_EN_AFE_GET ((VR9_AfeRead(GLP_BERT_CTRL) & GLP_BERT_CTRL_SCR_EN_MASK) >> 5)
#define GLP_BERT_CTRL_SCR_EN_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val) << 5, GLP_BERT_CTRL_SCR_EN_MASK)
/** Disable */
#define SCR_EN_DIS 0x0
/** Enable */
#define SCR_EN_EN 0x1

/** LFSR Enable - LSFR Data from BERTs will be used for scrambling data from PHY if enabled.  */
#define GLP_BERT_CTRL_SELFSYNC_EN_MASK 0xc0
#define GLP_BERT_CTRL_SELFSYNC_EN_AFE_GET ((VR9_AfeRead(GLP_BERT_CTRL) & GLP_BERT_CTRL_SELFSYNC_EN_MASK) >> 6)
#define GLP_BERT_CTRL_SELFSYNC_EN_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val) << 6, GLP_BERT_CTRL_SELFSYNC_EN_MASK)
/** Enable Self Sync in BERT 1 */
#define SELFSYNC_EN_BERT1_EN 0x1
/** Enable Self Sync in BERT 2 */
#define SELFSYNC_EN_BERT2_EN 0x2

/** Loopback Enables - Loopback enables for respective BERTs.  */
#define GLP_BERT_CTRL_LOOPEN_MASK 0x300
#define GLP_BERT_CTRL_LOOPEN_AFE_GET ((VR9_AfeRead(GLP_BERT_CTRL) & GLP_BERT_CTRL_LOOPEN_MASK) >> 8)
#define GLP_BERT_CTRL_LOOPEN_AFE_SET(val) VR9_AfeWrite(GLP_BERT_CTRL, (val) << 8, GLP_BERT_CTRL_LOOPEN_MASK)
/** Enable Loopback in BERT 1 */
#define LOOPEN_BERT1_EN 0x1
/** Enable Loopback in BERT 2 */
#define LOOPEN_BERT2_EN 0x2


/** 3GLP Control Register - This register is used for general control in the 3GLP. */
#define GLP_CTRL (GLP_SLAVE_BASE + 0x11)
#define GLP_CTRL_AFE_GET VR9_AfeRead(GLP_CTRL)
#define GLP_CTRL_AFE_SET(val) VR9_AfeWrite(GLP_CTRL, (val), 0xFFFF)

/** Clock switching enable - Enables clock switching at core interface. A 144MHz clock will be transmitted when 3GLP is not ready. */
#define GLP_CTRL_CLK_SW_MASK 0x1
#define GLP_CTRL_CLK_SW_AFE_GET ((VR9_AfeRead(GLP_CTRL) & GLP_CTRL_CLK_SW_MASK) >> 0)
#define GLP_CTRL_CLK_SW_AFE_SET(val) VR9_AfeWrite(GLP_CTRL, (val) << 0, GLP_CTRL_CLK_SW_MASK)
/** Disable */
#define CLK_SW_DIS 0x0
/** Enable */
#define CLK_SW_EN 0x1

/** Data masking enable - Enables data masking at core interface. A all-zeros data word will be transmitted when 3GLP is not ready. */
#define GLP_CTRL_MSK_EN_MASK 0x2
#define GLP_CTRL_MSK_EN_AFE_GET ((VR9_AfeRead(GLP_CTRL) & GLP_CTRL_MSK_EN_MASK) >> 1)
#define GLP_CTRL_MSK_EN_AFE_SET(val) VR9_AfeWrite(GLP_CTRL, (val) << 1, GLP_CTRL_MSK_EN_MASK)
/** Disable */
#define MSK_EN_DIS 0x0
/** Enable */
#define MSK_EN_EN 0x1

/** CRC value sent - This CRC value will be transmitted to core when 3GLP is not ready and MSK_EN is enabled. */
#define GLP_CTRL_CRC_VAL_MASK 0x4
#define GLP_CTRL_CRC_VAL_AFE_GET ((VR9_AfeRead(GLP_CTRL) & GLP_CTRL_CRC_VAL_MASK) >> 2)
#define GLP_CTRL_CRC_VAL_AFE_SET(val) VR9_AfeWrite(GLP_CTRL, (val) << 2, GLP_CTRL_CRC_VAL_MASK)

/** Low Speed Test - Enables Low Speed Testing. */
#define GLP_CTRL_LOSP_TEST_MASK 0x8
#define GLP_CTRL_LOSP_TEST_AFE_GET ((VR9_AfeRead(GLP_CTRL) & GLP_CTRL_LOSP_TEST_MASK) >> 3)
#define GLP_CTRL_LOSP_TEST_AFE_SET(val) VR9_AfeWrite(GLP_CTRL, (val) << 3, GLP_CTRL_LOSP_TEST_MASK)
/** Disable */
#define LOSP_TEST_DIS 0x0
/** Enable */
#define LOSP_TEST_EN 0x1


/** 3GLP Miscellaneous Register - This register is used for miscellaneous control or reading bits. */
#define GLP_MISC (GLP_SLAVE_BASE + 0x12)
#define GLP_MISC_AFE_GET VR9_AfeRead(GLP_MISC)
#define GLP_MISC_AFE_SET(val) VR9_AfeWrite(GLP_MISC, (val), 0xFFFF)

/** Control - Miscellaneous Control bits. */
#define GLP_MISC_CTRL_MASK 0xff
#define GLP_MISC_CTRL_AFE_GET ((VR9_AfeRead(GLP_MISC) & GLP_MISC_CTRL_MASK) >> 0)
#define GLP_MISC_CTRL_AFE_SET(val) VR9_AfeWrite(GLP_MISC, (val) << 0, GLP_MISC_CTRL_MASK)

/** Status - Miscellaneous Status bits. */
#define GLP_MISC_STATUS_1_MASK 0xf00
#define GLP_MISC_STATUS_1_AFE_GET ((VR9_AfeRead(GLP_MISC) & GLP_MISC_STATUS_1_MASK) >> 8)
#define GLP_MISC_STATUS_1_AFE_SET(val) VR9_AfeWrite(GLP_MISC, (val) << 8, GLP_MISC_STATUS_1_MASK)

/** Status - Miscellaneous Status bits. */
#define GLP_MISC_STATUS_2_MASK 0xf000
#define GLP_MISC_STATUS_2_AFE_GET ((VR9_AfeRead(GLP_MISC) & GLP_MISC_STATUS_2_MASK) >> 12)
#define GLP_MISC_STATUS_2_AFE_SET(val) VR9_AfeWrite(GLP_MISC, (val) << 12, GLP_MISC_STATUS_2_MASK)


/** Start Up Control Register - PMA Start Up Register */
#define PMA_STARTUP_CTRL (GLP_SLAVE_BASE + 0x13)
#define PMA_STARTUP_CTRL_AFE_GET VR9_AfeRead(PMA_STARTUP_CTRL)
#define PMA_STARTUP_CTRL_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val), 0xFFFF)

/** Bypass - Register Bypass bit. Start-up state machine control outputs will be overridden by register values when enabled.  */
#define PMA_STARTUP_CTRL_BYPASS_MASK 0x1
#define PMA_STARTUP_CTRL_BYPASS_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_BYPASS_MASK) >> 0)
#define PMA_STARTUP_CTRL_BYPASS_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 0, PMA_STARTUP_CTRL_BYPASS_MASK)
/** Disable */
#define BYPASS_DIS 0x0
/** Enable */
#define BYPASS_EN 0x1

/** PLL reset - PLL reset bit. The PLL reset is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_PLL_RSTN_MASK 0x2
#define PMA_STARTUP_CTRL_PLL_RSTN_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_PLL_RSTN_MASK) >> 1)
#define PMA_STARTUP_CTRL_PLL_RSTN_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 1, PMA_STARTUP_CTRL_PLL_RSTN_MASK)

/** PLL Powerdown - PLL powerdown is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_PLL_PD_MASK 0x4
#define PMA_STARTUP_CTRL_PLL_PD_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_PLL_PD_MASK) >> 2)
#define PMA_STARTUP_CTRL_PLL_PD_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 2, PMA_STARTUP_CTRL_PLL_PD_MASK)

/** Reset Digital - Digital reset to all blocks in PMA slices is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_RSTN_DIG_MASK 0x8
#define PMA_STARTUP_CTRL_RSTN_DIG_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_RSTN_DIG_MASK) >> 3)
#define PMA_STARTUP_CTRL_RSTN_DIG_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 3, PMA_STARTUP_CTRL_RSTN_DIG_MASK)

/** Reset PMD - The PMD reset is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_RSTN_PMD_MASK 0x10
#define PMA_STARTUP_CTRL_RSTN_PMD_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_RSTN_PMD_MASK) >> 4)
#define PMA_STARTUP_CTRL_RSTN_PMD_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 4, PMA_STARTUP_CTRL_RSTN_PMD_MASK)

/** Powerdown - Powerdown bit is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_PD_MASK 0x20
#define PMA_STARTUP_CTRL_PD_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_PD_MASK) >> 5)
#define PMA_STARTUP_CTRL_PD_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 5, PMA_STARTUP_CTRL_PD_MASK)

/** Clock Enable - High Speed Clock Enable is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_CLK_EN_MASK 0x40
#define PMA_STARTUP_CTRL_CLK_EN_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_CLK_EN_MASK) >> 6)
#define PMA_STARTUP_CTRL_CLK_EN_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 6, PMA_STARTUP_CTRL_CLK_EN_MASK)

/** CDR Enable - CDR Enable. The is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_CDR_EN_MASK 0x80
#define PMA_STARTUP_CTRL_CDR_EN_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_CDR_EN_MASK) >> 7)
#define PMA_STARTUP_CTRL_CDR_EN_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 7, PMA_STARTUP_CTRL_CDR_EN_MASK)

/** CAL Enable - The Calibration Enable is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_CAL_EN_MASK 0x100
#define PMA_STARTUP_CTRL_CAL_EN_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_CAL_EN_MASK) >> 8)
#define PMA_STARTUP_CTRL_CAL_EN_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 8, PMA_STARTUP_CTRL_CAL_EN_MASK)

/** Startup Ready - Start up Ready bit. The PHY ready status is overridden by this value when bypass is enabled. */
#define PMA_STARTUP_CTRL_STARTUP_RDY_MASK 0x200
#define PMA_STARTUP_CTRL_STARTUP_RDY_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_STARTUP_RDY_MASK) >> 9)
#define PMA_STARTUP_CTRL_STARTUP_RDY_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 9, PMA_STARTUP_CTRL_STARTUP_RDY_MASK)

/** Skip Calibration - Skip Calibration bit. */
#define PMA_STARTUP_CTRL_SKIP_CAL_MASK 0x400
#define PMA_STARTUP_CTRL_SKIP_CAL_AFE_GET ((VR9_AfeRead(PMA_STARTUP_CTRL) & PMA_STARTUP_CTRL_SKIP_CAL_MASK) >> 10)
#define PMA_STARTUP_CTRL_SKIP_CAL_AFE_SET(val) VR9_AfeWrite(PMA_STARTUP_CTRL, (val) << 10, PMA_STARTUP_CTRL_SKIP_CAL_MASK)


/** State Register - PMA Start Up State Register */
#define PMA_STATE (GLP_SLAVE_BASE + 0x14)
#define PMA_STATE_AFE_GET VR9_AfeRead(PMA_STATE)
#define PMA_STATE_AFE_SET(val) VR9_AfeWrite(PMA_STATE, (val), 0xFFFF)

/** Start Up SM State - PMA Start-Up State Machine. */
#define PMA_STATE_STATE_MASK 0x7
#define PMA_STATE_STATE_AFE_GET ((VR9_AfeRead(PMA_STATE) & PMA_STATE_STATE_MASK) >> 0)
#define PMA_STATE_STATE_AFE_SET(val) VR9_AfeWrite(PMA_STATE, (val) << 0, PMA_STATE_STATE_MASK)
/** Power Up PLL */
#define STATE_ST_POWERUP_PLL 0x0
/** Release High Freqency Reset */
#define STATE_ST_RELEASE_HF_RESET 0x1
/** Release High Freqency Clocks */
#define STATE_ST_RELEASE_HF_CLOCKS 0x2
/** Release Digital Reset */
#define STATE_ST_RELEASE_DIG_RESET 0x3
/** Enable Calibration */
#define STATE_ST_EN_CAL 0x4
/** Finish */
#define STATE_FINISH 0x5


/** Control Register - This Register is for controlling of PLL SLICE behavior. */
#define PLL_CTRL (GLP_SLAVE_BASE + 0x15)
#define PLL_CTRL_AFE_GET VR9_AfeRead(PLL_CTRL)
#define PLL_CTRL_AFE_SET(val) VR9_AfeWrite(PLL_CTRL, (val), 0xFFFF)

/** FSEL */
#define PLL_CTRL_FSEL_MASK 0x7
#define PLL_CTRL_FSEL_AFE_GET ((VR9_AfeRead(PLL_CTRL) & PLL_CTRL_FSEL_MASK) >> 0)
#define PLL_CTRL_FSEL_AFE_SET(val) VR9_AfeWrite(PLL_CTRL, (val) << 0, PLL_CTRL_FSEL_MASK)

/** FBDIV */
#define PLL_CTRL_FBDIV_MASK 0x78
#define PLL_CTRL_FBDIV_AFE_GET ((VR9_AfeRead(PLL_CTRL) & PLL_CTRL_FBDIV_MASK) >> 3)
#define PLL_CTRL_FBDIV_AFE_SET(val) VR9_AfeWrite(PLL_CTRL, (val) << 3, PLL_CTRL_FBDIV_MASK)

/** ICP_SEL */
#define PLL_CTRL_ICP_SEL_MASK 0x780
#define PLL_CTRL_ICP_SEL_AFE_GET ((VR9_AfeRead(PLL_CTRL) & PLL_CTRL_ICP_SEL_MASK) >> 7)
#define PLL_CTRL_ICP_SEL_AFE_SET(val) VR9_AfeWrite(PLL_CTRL, (val) << 7, PLL_CTRL_ICP_SEL_MASK)

/** RES_SEL */
#define PLL_CTRL_RES_SEL_MASK 0x3800
#define PLL_CTRL_RES_SEL_AFE_GET ((VR9_AfeRead(PLL_CTRL) & PLL_CTRL_RES_SEL_MASK) >> 11)
#define PLL_CTRL_RES_SEL_AFE_SET(val) VR9_AfeWrite(PLL_CTRL, (val) << 11, PLL_CTRL_RES_SEL_MASK)


/** Start PLL Register - This Register is for reading PLL status. */
#define PLL_ST_PLLINT (GLP_SLAVE_BASE + 0x16)
#define PLL_ST_PLLINT_AFE_GET VR9_AfeRead(PLL_ST_PLLINT)
#define PLL_ST_PLLINT_AFE_SET(val) VR9_AfeWrite(PLL_ST_PLLINT, (val), 0xFFFF)

/** Ready */
#define PLL_ST_PLLINT_READY_MASK 0x1
#define PLL_ST_PLLINT_READY_AFE_GET ((VR9_AfeRead(PLL_ST_PLLINT) & PLL_ST_PLLINT_READY_MASK) >> 0)
#define PLL_ST_PLLINT_READY_AFE_SET(val) VR9_AfeWrite(PLL_ST_PLLINT, (val) << 0, PLL_ST_PLLINT_READY_MASK)

/** Lock */
#define PLL_ST_PLLINT_LOCK_MASK 0x2
#define PLL_ST_PLLINT_LOCK_AFE_GET ((VR9_AfeRead(PLL_ST_PLLINT) & PLL_ST_PLLINT_LOCK_MASK) >> 1)
#define PLL_ST_PLLINT_LOCK_AFE_SET(val) VR9_AfeWrite(PLL_ST_PLLINT, (val) << 1, PLL_ST_PLLINT_LOCK_MASK)

/** Startup ip */
#define PLL_ST_PLLINT_STARTUP_IP_MASK 0x4
#define PLL_ST_PLLINT_STARTUP_IP_AFE_GET ((VR9_AfeRead(PLL_ST_PLLINT) & PLL_ST_PLLINT_STARTUP_IP_MASK) >> 2)
#define PLL_ST_PLLINT_STARTUP_IP_AFE_SET(val) VR9_AfeWrite(PLL_ST_PLLINT, (val) << 2, PLL_ST_PLLINT_STARTUP_IP_MASK)

/** Startup Ready */
#define PLL_ST_PLLINT_STARTUP_RDY_MASK 0x8
#define PLL_ST_PLLINT_STARTUP_RDY_AFE_GET ((VR9_AfeRead(PLL_ST_PLLINT) & PLL_ST_PLLINT_STARTUP_RDY_MASK) >> 3)
#define PLL_ST_PLLINT_STARTUP_RDY_AFE_SET(val) VR9_AfeWrite(PLL_ST_PLLINT, (val) << 3, PLL_ST_PLLINT_STARTUP_RDY_MASK)

/** Force_lf */
#define PLL_ST_PLLINT_FORCE_LF_MASK 0x10
#define PLL_ST_PLLINT_FORCE_LF_AFE_GET ((VR9_AfeRead(PLL_ST_PLLINT) & PLL_ST_PLLINT_FORCE_LF_MASK) >> 4)
#define PLL_ST_PLLINT_FORCE_LF_AFE_SET(val) VR9_AfeWrite(PLL_ST_PLLINT, (val) << 4, PLL_ST_PLLINT_FORCE_LF_MASK)

/** VCOSEL */
#define PLL_ST_PLLINT_VCOSEL_MASK 0x1e0
#define PLL_ST_PLLINT_VCOSEL_AFE_GET ((VR9_AfeRead(PLL_ST_PLLINT) & PLL_ST_PLLINT_VCOSEL_MASK) >> 5)
#define PLL_ST_PLLINT_VCOSEL_AFE_SET(val) VR9_AfeWrite(PLL_ST_PLLINT, (val) << 5, PLL_ST_PLLINT_VCOSEL_MASK)


/** Startup control Register - This Register is the configuration of Startup. */
#define PLL_STARTUP_CTRL (GLP_SLAVE_BASE + 0x17)
#define PLL_STARTUP_CTRL_AFE_GET VR9_AfeRead(PLL_STARTUP_CTRL)
#define PLL_STARTUP_CTRL_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val), 0xFFFF)

/** Force Lock */
#define PLL_STARTUP_CTRL_FORCE_LOCK_MASK 0x1
#define PLL_STARTUP_CTRL_FORCE_LOCK_AFE_GET ((VR9_AfeRead(PLL_STARTUP_CTRL) & PLL_STARTUP_CTRL_FORCE_LOCK_MASK) >> 0)
#define PLL_STARTUP_CTRL_FORCE_LOCK_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val) << 0, PLL_STARTUP_CTRL_FORCE_LOCK_MASK)

/** Force LF In */
#define PLL_STARTUP_CTRL_FORCE_LF_IN_MASK 0x2
#define PLL_STARTUP_CTRL_FORCE_LF_IN_AFE_GET ((VR9_AfeRead(PLL_STARTUP_CTRL) & PLL_STARTUP_CTRL_FORCE_LF_IN_MASK) >> 1)
#define PLL_STARTUP_CTRL_FORCE_LF_IN_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val) << 1, PLL_STARTUP_CTRL_FORCE_LF_IN_MASK)

/** Force Start */
#define PLL_STARTUP_CTRL_FORCE_START_MASK 0x4
#define PLL_STARTUP_CTRL_FORCE_START_AFE_GET ((VR9_AfeRead(PLL_STARTUP_CTRL) & PLL_STARTUP_CTRL_FORCE_START_MASK) >> 2)
#define PLL_STARTUP_CTRL_FORCE_START_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val) << 2, PLL_STARTUP_CTRL_FORCE_START_MASK)

/** Dis_startup */
#define PLL_STARTUP_CTRL_DIS_STARTUP_MASK 0x8
#define PLL_STARTUP_CTRL_DIS_STARTUP_AFE_GET ((VR9_AfeRead(PLL_STARTUP_CTRL) & PLL_STARTUP_CTRL_DIS_STARTUP_MASK) >> 3)
#define PLL_STARTUP_CTRL_DIS_STARTUP_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val) << 3, PLL_STARTUP_CTRL_DIS_STARTUP_MASK)

/** VCOSEL */
#define PLL_STARTUP_CTRL_VCOSEL_MASK 0xf0
#define PLL_STARTUP_CTRL_VCOSEL_AFE_GET ((VR9_AfeRead(PLL_STARTUP_CTRL) & PLL_STARTUP_CTRL_VCOSEL_MASK) >> 4)
#define PLL_STARTUP_CTRL_VCOSEL_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val) << 4, PLL_STARTUP_CTRL_VCOSEL_MASK)

/** tx_ibias_sel */
#define PLL_STARTUP_CTRL_TX_IBIAS_MASK 0x700
#define PLL_STARTUP_CTRL_TX_IBIAS_AFE_GET ((VR9_AfeRead(PLL_STARTUP_CTRL) & PLL_STARTUP_CTRL_TX_IBIAS_MASK) >> 8)
#define PLL_STARTUP_CTRL_TX_IBIAS_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val) << 8, PLL_STARTUP_CTRL_TX_IBIAS_MASK)

/** rx_ibias_sel */
#define PLL_STARTUP_CTRL_RX_IBIAS_MASK 0x3800
#define PLL_STARTUP_CTRL_RX_IBIAS_AFE_GET ((VR9_AfeRead(PLL_STARTUP_CTRL) & PLL_STARTUP_CTRL_RX_IBIAS_MASK) >> 11)
#define PLL_STARTUP_CTRL_RX_IBIAS_AFE_SET(val) VR9_AfeWrite(PLL_STARTUP_CTRL, (val) << 11, PLL_STARTUP_CTRL_RX_IBIAS_MASK)


/** TX Control Register - This Register is for controlling of TX SLICE behavior. */
#define TX_CTRL (GLP_SLAVE_BASE + 0x20)
#define TX_CTRL_AFE_GET VR9_AfeRead(TX_CTRL)
#define TX_CTRL_AFE_SET(val) VR9_AfeWrite(TX_CTRL, (val), 0xFFFF)

/** Enable - Enable bit. */
#define TX_CTRL_EN_MASK 0x1
#define TX_CTRL_EN_AFE_GET ((VR9_AfeRead(TX_CTRL) & TX_CTRL_EN_MASK) >> 0)
#define TX_CTRL_EN_AFE_SET(val) VR9_AfeWrite(TX_CTRL, (val) << 0, TX_CTRL_EN_MASK)

/** Invert Enable - Enables the inversion of TX data. */
#define TX_CTRL_INV_EN_MASK 0x2
#define TX_CTRL_INV_EN_AFE_GET ((VR9_AfeRead(TX_CTRL) & TX_CTRL_INV_EN_MASK) >> 1)
#define TX_CTRL_INV_EN_AFE_SET(val) VR9_AfeWrite(TX_CTRL, (val) << 1, TX_CTRL_INV_EN_MASK)


/** TX Analog Control Register - This Register is for controlling of TX SLICE analog behavior. */
#define TX_A_CTRL (GLP_SLAVE_BASE + 0x21)
#define TX_A_CTRL_AFE_GET VR9_AfeRead(TX_A_CTRL)
#define TX_A_CTRL_AFE_SET(val) VR9_AfeWrite(TX_A_CTRL, (val), 0xFFFF)

/** iout */
#define TX_A_CTRL_IOUT_MASK 0xf
#define TX_A_CTRL_IOUT_AFE_GET ((VR9_AfeRead(TX_A_CTRL) & TX_A_CTRL_IOUT_MASK) >> 0)
#define TX_A_CTRL_IOUT_AFE_SET(val) VR9_AfeWrite(TX_A_CTRL, (val) << 0, TX_A_CTRL_IOUT_MASK)

/** Clock Enable - Clock mode enable for PHY. */
#define TX_A_CTRL_CLK_EN_MASK 0x10
#define TX_A_CTRL_CLK_EN_AFE_GET ((VR9_AfeRead(TX_A_CTRL) & TX_A_CTRL_CLK_EN_MASK) >> 4)
#define TX_A_CTRL_CLK_EN_AFE_SET(val) VR9_AfeWrite(TX_A_CTRL, (val) << 4, TX_A_CTRL_CLK_EN_MASK)

/** Pre-driver R Select */
#define TX_A_CTRL_PRE_DRIVER_R_SEL_MASK 0xe0
#define TX_A_CTRL_PRE_DRIVER_R_SEL_AFE_GET ((VR9_AfeRead(TX_A_CTRL) & TX_A_CTRL_PRE_DRIVER_R_SEL_MASK) >> 5)
#define TX_A_CTRL_PRE_DRIVER_R_SEL_AFE_SET(val) VR9_AfeWrite(TX_A_CTRL, (val) << 5, TX_A_CTRL_PRE_DRIVER_R_SEL_MASK)

/** Pre-driver Select */
#define TX_A_CTRL_PRE_DRIVER_SEL_MASK 0xf00
#define TX_A_CTRL_PRE_DRIVER_SEL_AFE_GET ((VR9_AfeRead(TX_A_CTRL) & TX_A_CTRL_PRE_DRIVER_SEL_MASK) >> 8)
#define TX_A_CTRL_PRE_DRIVER_SEL_AFE_SET(val) VR9_AfeWrite(TX_A_CTRL, (val) << 8, TX_A_CTRL_PRE_DRIVER_SEL_MASK)

/** Pre Pre-driver Select */
#define TX_A_CTRL_PRE_PRE_DRIVER_SEL_MASK 0x7000
#define TX_A_CTRL_PRE_PRE_DRIVER_SEL_AFE_GET ((VR9_AfeRead(TX_A_CTRL) & TX_A_CTRL_PRE_PRE_DRIVER_SEL_MASK) >> 12)
#define TX_A_CTRL_PRE_PRE_DRIVER_SEL_AFE_SET(val) VR9_AfeWrite(TX_A_CTRL, (val) << 12, TX_A_CTRL_PRE_PRE_DRIVER_SEL_MASK)

/** Pre Pre-driver Select */
#define TX_A_CTRL_TXF_CLK_INV_MASK 0x8000
#define TX_A_CTRL_TXF_CLK_INV_AFE_GET ((VR9_AfeRead(TX_A_CTRL) & TX_A_CTRL_TXF_CLK_INV_MASK) >> 15)
#define TX_A_CTRL_TXF_CLK_INV_AFE_SET(val) VR9_AfeWrite(TX_A_CTRL, (val) << 15, TX_A_CTRL_TXF_CLK_INV_MASK)

/** Programmable Data Register - This Register is for programming data for transmission. */
#define TX_PROG_DATA (GLP_SLAVE_BASE + 0x22)
#define TX_PROG_DATA_AFE_GET VR9_AfeRead(TX_PROG_DATA)
#define TX_PROG_DATA_AFE_SET(val) VR9_AfeWrite(TX_PROG_DATA, (val), 0xFFFF)

/** Programmable TX Data - Programmable Data for TX to PHY. */
#define TX_PROG_DATA_DATA_MASK 0xff
#define TX_PROG_DATA_DATA_AFE_GET ((VR9_AfeRead(TX_PROG_DATA) & TX_PROG_DATA_DATA_MASK) >> 0)
#define TX_PROG_DATA_DATA_AFE_SET(val) VR9_AfeWrite(TX_PROG_DATA, (val) << 0, TX_PROG_DATA_DATA_MASK)

/** Enable Programmable TX Data - Enable Programmable Data for TX. */
#define TX_PROG_DATA_PRG_EN_MASK 0x100
#define TX_PROG_DATA_PRG_EN_AFE_GET ((VR9_AfeRead(TX_PROG_DATA) & TX_PROG_DATA_PRG_EN_MASK) >> 8)
#define TX_PROG_DATA_PRG_EN_AFE_SET(val) VR9_AfeWrite(TX_PROG_DATA, (val) << 8, TX_PROG_DATA_PRG_EN_MASK)
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1


/** Termination Resistor Register - This Register is for configuration of termination resistors. */
#define TX_RTERM (GLP_SLAVE_BASE + 0x23)
#define TX_RTERM_AFE_GET VR9_AfeRead(TX_RTERM)
#define TX_RTERM_AFE_SET(val) VR9_AfeWrite(TX_RTERM, (val), 0xFFFF)

/** rterm - Configures termination resistors in PHY. */
#define TX_RTERM_SEL_MASK 0xffff
#define TX_RTERM_SEL_AFE_GET ((VR9_AfeRead(TX_RTERM) & TX_RTERM_SEL_MASK) >> 0)
#define TX_RTERM_SEL_AFE_SET(val) VR9_AfeWrite(TX_RTERM, (val) << 0, TX_RTERM_SEL_MASK)


/** Modulation Configuration 1 Register - This Register is the configuration of the Modulation. */
#define TX_MOD1 (GLP_SLAVE_BASE + 0x24)
#define TX_MOD1_AFE_GET VR9_AfeRead(TX_MOD1)
#define TX_MOD1_AFE_SET(val) VR9_AfeWrite(TX_MOD1, (val), 0xFFFF)

/** Modulation Period - Total number of errors received. */
#define TX_MOD1_PERIOD_MASK 0x7ff
#define TX_MOD1_PERIOD_AFE_GET ((VR9_AfeRead(TX_MOD1) & TX_MOD1_PERIOD_MASK) >> 0)
#define TX_MOD1_PERIOD_AFE_SET(val) VR9_AfeWrite(TX_MOD1, (val) << 0, TX_MOD1_PERIOD_MASK)

/** Mod_flip - Bit to flip the CDR CTRL to start modulation pulses with up or down */
#define TX_MOD1_FLIP_MASK 0x800
#define TX_MOD1_FLIP_AFE_GET ((VR9_AfeRead(TX_MOD1) & TX_MOD1_FLIP_MASK) >> 11)
#define TX_MOD1_FLIP_AFE_SET(val) VR9_AfeWrite(TX_MOD1, (val) << 11, TX_MOD1_FLIP_MASK)

/** Mod_out_skew_en - Enable skew to CDR CTRL */
#define TX_MOD1_SKEW_EN_MASK 0x1000
#define TX_MOD1_SKEW_EN_AFE_GET ((VR9_AfeRead(TX_MOD1) & TX_MOD1_SKEW_EN_MASK) >> 12)
#define TX_MOD1_SKEW_EN_AFE_SET(val) VR9_AfeWrite(TX_MOD1, (val) << 12, TX_MOD1_SKEW_EN_MASK)

/** skew_period_flip - if mod_out_flip_i = 0, skew_period_flip_i = 0 will add skew to down */
#define TX_MOD1_SKEW_PERIOD_FLIP_MASK 0x2000
#define TX_MOD1_SKEW_PERIOD_FLIP_AFE_GET ((VR9_AfeRead(TX_MOD1) & TX_MOD1_SKEW_PERIOD_FLIP_MASK) >> 13)
#define TX_MOD1_SKEW_PERIOD_FLIP_AFE_SET(val) VR9_AfeWrite(TX_MOD1, (val) << 13, TX_MOD1_SKEW_PERIOD_FLIP_MASK)


/** Modulation Configuration 2 Register - This Register is the configuration of the Modulation. */
#define TX_MOD2 (GLP_SLAVE_BASE + 0x25)
#define TX_MOD2_AFE_GET VR9_AfeRead(TX_MOD2)
#define TX_MOD2_AFE_SET(val) VR9_AfeWrite(TX_MOD2, (val), 0xFFFF)

/** Skew Period - The user defined occurance period for skew. */
#define TX_MOD2_SKEW_PERIOD_MASK 0xffff
#define TX_MOD2_SKEW_PERIOD_AFE_GET ((VR9_AfeRead(TX_MOD2) & TX_MOD2_SKEW_PERIOD_MASK) >> 0)
#define TX_MOD2_SKEW_PERIOD_AFE_SET(val) VR9_AfeWrite(TX_MOD2, (val) << 0, TX_MOD2_SKEW_PERIOD_MASK)


/** Modulation Configuration 3 Register - This Register is the configuration of the Modulation. */
#define TX_MOD3 (GLP_SLAVE_BASE + 0x26)
#define TX_MOD3_AFE_GET VR9_AfeRead(TX_MOD3)
#define TX_MOD3_AFE_SET(val) VR9_AfeWrite(TX_MOD3, (val), 0xFFFF)

/** Modulation pulses - The number of up or down modulation pulses. */
#define TX_MOD3_AMP_MASK 0x3f
#define TX_MOD3_AMP_AFE_GET ((VR9_AfeRead(TX_MOD3) & TX_MOD3_AMP_MASK) >> 0)
#define TX_MOD3_AMP_AFE_SET(val) VR9_AfeWrite(TX_MOD3, (val) << 0, TX_MOD3_AMP_MASK)


/** Test Control Register - This Register is for Test control of TX SLICE. */
#define TX_TEST_CTRL (GLP_SLAVE_BASE + 0x27)
#define TX_TEST_CTRL_AFE_GET VR9_AfeRead(TX_TEST_CTRL)
#define TX_TEST_CTRL_AFE_SET(val) VR9_AfeWrite(TX_TEST_CTRL, (val), 0xFFFF)

/** Testbus Enable - Enables Test bus in PMD. */
#define TX_TEST_CTRL_TESTBUS_EN_MASK 0x1
#define TX_TEST_CTRL_TESTBUS_EN_AFE_GET ((VR9_AfeRead(TX_TEST_CTRL) & TX_TEST_CTRL_TESTBUS_EN_MASK) >> 0)
#define TX_TEST_CTRL_TESTBUS_EN_AFE_SET(val) VR9_AfeWrite(TX_TEST_CTRL, (val) << 0, TX_TEST_CTRL_TESTBUS_EN_MASK)

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define TX_TEST_CTRL_TESTBUS_BIST_EN_MASK 0x2
#define TX_TEST_CTRL_TESTBUS_BIST_EN_AFE_GET ((VR9_AfeRead(TX_TEST_CTRL) & TX_TEST_CTRL_TESTBUS_BIST_EN_MASK) >> 1)
#define TX_TEST_CTRL_TESTBUS_BIST_EN_AFE_SET(val) VR9_AfeWrite(TX_TEST_CTRL, (val) << 1, TX_TEST_CTRL_TESTBUS_BIST_EN_MASK)

/** BIST Modulation Enable - Bist modulation enable for PHY. */
#define TX_TEST_CTRL_BIST_MOD_EN_MASK 0x4
#define TX_TEST_CTRL_BIST_MOD_EN_AFE_GET ((VR9_AfeRead(TX_TEST_CTRL) & TX_TEST_CTRL_BIST_MOD_EN_MASK) >> 2)
#define TX_TEST_CTRL_BIST_MOD_EN_AFE_SET(val) VR9_AfeWrite(TX_TEST_CTRL, (val) << 2, TX_TEST_CTRL_BIST_MOD_EN_MASK)

/** Modulation Override - Modulation override enable for PHY. */
#define TX_TEST_CTRL_MOD_OVR_MASK 0x8
#define TX_TEST_CTRL_MOD_OVR_AFE_GET ((VR9_AfeRead(TX_TEST_CTRL) & TX_TEST_CTRL_MOD_OVR_MASK) >> 3)
#define TX_TEST_CTRL_MOD_OVR_AFE_SET(val) VR9_AfeWrite(TX_TEST_CTRL, (val) << 3, TX_TEST_CTRL_MOD_OVR_MASK)


/** Control Register - This Register is for controlling of RX1 SLICE behavior. */
#define RX1_CTRL (GLP_SLAVE_BASE + 0x30)
#define RX1_CTRL_AFE_GET VR9_AfeRead(RX1_CTRL)
#define RX1_CTRL_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val), 0xFFFF)

/** Enable - Enable bit. */
#define RX1_CTRL_EN_MASK 0x1
#define RX1_CTRL_EN_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_EN_MASK) >> 0)
#define RX1_CTRL_EN_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 0, RX1_CTRL_EN_MASK)

/** CG_BIAS */
#define RX1_CTRL_CG_BIAS_MASK 0xe
#define RX1_CTRL_CG_BIAS_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_CG_BIAS_MASK) >> 1)
#define RX1_CTRL_CG_BIAS_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 1, RX1_CTRL_CG_BIAS_MASK)

/** CML_BIAS_SEL */
#define RX1_CTRL_CML_BIAS_SEL_MASK 0x30
#define RX1_CTRL_CML_BIAS_SEL_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_CML_BIAS_SEL_MASK) >> 4)
#define RX1_CTRL_CML_BIAS_SEL_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 4, RX1_CTRL_CML_BIAS_SEL_MASK)

/** EDGE_DISABLE */
#define RX1_CTRL_EDGE_DISABLE_MASK 0x40
#define RX1_CTRL_EDGE_DISABLE_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_EDGE_DISABLE_MASK) >> 6)
#define RX1_CTRL_EDGE_DISABLE_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 6, RX1_CTRL_EDGE_DISABLE_MASK)

/** IBIAS_SEL */
#define RX1_CTRL_IBIAS_SEL_MASK 0x80
#define RX1_CTRL_IBIAS_SEL_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_IBIAS_SEL_MASK) >> 7)
#define RX1_CTRL_IBIAS_SEL_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 7, RX1_CTRL_IBIAS_SEL_MASK)

/** RES_SEL */
#define RX1_CTRL_RES_SEL_MASK 0x100
#define RX1_CTRL_RES_SEL_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_RES_SEL_MASK) >> 8)
#define RX1_CTRL_RES_SEL_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 8, RX1_CTRL_RES_SEL_MASK)

/** RESBOOST */
#define RX1_CTRL_RESBOOST_MASK 0x600
#define RX1_CTRL_RESBOOST_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_RESBOOST_MASK) >> 9)
#define RX1_CTRL_RESBOOST_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 9, RX1_CTRL_RESBOOST_MASK)

/** Invert Enable - Enables the inversion of RX1 data. */
#define RX1_CTRL_INV_EN_MASK 0x800
#define RX1_CTRL_INV_EN_AFE_GET ((VR9_AfeRead(RX1_CTRL) & RX1_CTRL_INV_EN_MASK) >> 11)
#define RX1_CTRL_INV_EN_AFE_SET(val) VR9_AfeWrite(RX1_CTRL, (val) << 11, RX1_CTRL_INV_EN_MASK)


/** Programmable Data Register - This Register is for programming data for transmission. */
#define RX1_PROG_DATA (GLP_SLAVE_BASE + 0x31)
#define RX1_PROG_DATA_AFE_GET VR9_AfeRead(RX1_PROG_DATA)
#define RX1_PROG_DATA_AFE_SET(val) VR9_AfeWrite(RX1_PROG_DATA, (val), 0xFFFF)

/** Programmable RX1 Data - Programmable Data for RX1. */
#define RX1_PROG_DATA_DATA_MASK 0xff
#define RX1_PROG_DATA_DATA_AFE_GET ((VR9_AfeRead(RX1_PROG_DATA) & RX1_PROG_DATA_DATA_MASK) >> 0)
#define RX1_PROG_DATA_DATA_AFE_SET(val) VR9_AfeWrite(RX1_PROG_DATA, (val) << 0, RX1_PROG_DATA_DATA_MASK)

/** Enable Programmable RX1 Data - Enable Programmable Data for RX1. */
#define RX1_PROG_DATA_PRG_EN_MASK 0x100
#define RX1_PROG_DATA_PRG_EN_AFE_GET ((VR9_AfeRead(RX1_PROG_DATA) & RX1_PROG_DATA_PRG_EN_MASK) >> 8)
#define RX1_PROG_DATA_PRG_EN_AFE_SET(val) VR9_AfeWrite(RX1_PROG_DATA, (val) << 8, RX1_PROG_DATA_PRG_EN_MASK)
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1


/** CDR Configuration Register - This Register is for Configuration of CDR CTRL. */
#define RX1_CDR (GLP_SLAVE_BASE + 0x32)
#define RX1_CDR_AFE_GET VR9_AfeRead(RX1_CDR)
#define RX1_CDR_AFE_SET(val) VR9_AfeWrite(RX1_CDR, (val), 0xFFFF)

/** comp - Comp. */
#define RX1_CDR_COMP_MASK 0x7
#define RX1_CDR_COMP_AFE_GET ((VR9_AfeRead(RX1_CDR) & RX1_CDR_COMP_MASK) >> 0)
#define RX1_CDR_COMP_AFE_SET(val) VR9_AfeWrite(RX1_CDR, (val) << 0, RX1_CDR_COMP_MASK)

/** dumpint - dumpint. */
#define RX1_CDR_DUMPINT_MASK 0x70
#define RX1_CDR_DUMPINT_AFE_GET ((VR9_AfeRead(RX1_CDR) & RX1_CDR_DUMPINT_MASK) >> 4)
#define RX1_CDR_DUMPINT_AFE_SET(val) VR9_AfeWrite(RX1_CDR, (val) << 4, RX1_CDR_DUMPINT_MASK)

/** xor_inv - XOR_INV. */
#define RX1_CDR_XOR_INV_MASK 0x100
#define RX1_CDR_XOR_INV_AFE_GET ((VR9_AfeRead(RX1_CDR) & RX1_CDR_XOR_INV_MASK) >> 8)
#define RX1_CDR_XOR_INV_AFE_SET(val) VR9_AfeWrite(RX1_CDR, (val) << 8, RX1_CDR_XOR_INV_MASK)

/** sum_int - SUM_INT. */
#define RX1_CDR_SUM_INT_MASK 0x200
#define RX1_CDR_SUM_INT_AFE_GET ((VR9_AfeRead(RX1_CDR) & RX1_CDR_SUM_INT_MASK) >> 9)
#define RX1_CDR_SUM_INT_AFE_SET(val) VR9_AfeWrite(RX1_CDR, (val) << 9, RX1_CDR_SUM_INT_MASK)


/** Calibration Control Register - This Register is for configuring and reading the calibration settings. */
#define RX1_CAL_CTRL (GLP_SLAVE_BASE + 0x33)
#define RX1_CAL_CTRL_AFE_GET VR9_AfeRead(RX1_CAL_CTRL)
#define RX1_CAL_CTRL_AFE_SET(val) VR9_AfeWrite(RX1_CAL_CTRL, (val), 0xFFFF)

/** sample count - The number of samples used for calibration. */
#define RX1_CAL_CTRL_SMPL_CNT_MASK 0xf
#define RX1_CAL_CTRL_SMPL_CNT_AFE_GET ((VR9_AfeRead(RX1_CAL_CTRL) & RX1_CAL_CTRL_SMPL_CNT_MASK) >> 0)
#define RX1_CAL_CTRL_SMPL_CNT_AFE_SET(val) VR9_AfeWrite(RX1_CAL_CTRL, (val) << 0, RX1_CAL_CTRL_SMPL_CNT_MASK)

/** comparison count - The limit value for comparison used during calibration for hysteresis. */
#define RX1_CAL_CTRL_COMP_CNT_MASK 0xf0
#define RX1_CAL_CTRL_COMP_CNT_AFE_GET ((VR9_AfeRead(RX1_CAL_CTRL) & RX1_CAL_CTRL_COMP_CNT_MASK) >> 4)
#define RX1_CAL_CTRL_COMP_CNT_AFE_SET(val) VR9_AfeWrite(RX1_CAL_CTRL, (val) << 4, RX1_CAL_CTRL_COMP_CNT_MASK)

/** Invert direction - The data is inverted when set. */
#define RX1_CAL_CTRL_INV_DIR_MASK 0x100
#define RX1_CAL_CTRL_INV_DIR_AFE_GET ((VR9_AfeRead(RX1_CAL_CTRL) & RX1_CAL_CTRL_INV_DIR_MASK) >> 8)
#define RX1_CAL_CTRL_INV_DIR_AFE_SET(val) VR9_AfeWrite(RX1_CAL_CTRL, (val) << 8, RX1_CAL_CTRL_INV_DIR_MASK)

/** Calibration Fail - The calibration fail status. */
#define RX1_CAL_CTRL_CAL_FAIL_MASK 0x200
#define RX1_CAL_CTRL_CAL_FAIL_AFE_GET ((VR9_AfeRead(RX1_CAL_CTRL) & RX1_CAL_CTRL_CAL_FAIL_MASK) >> 9)
#define RX1_CAL_CTRL_CAL_FAIL_AFE_SET(val) VR9_AfeWrite(RX1_CAL_CTRL, (val) << 9, RX1_CAL_CTRL_CAL_FAIL_MASK)


/** Calibration Offsets Register - This Register is for reading the actual calibration offset values. */
#define RX1_CAL_READ (GLP_SLAVE_BASE + 0x34)
#define RX1_CAL_READ_AFE_GET VR9_AfeRead(RX1_CAL_READ)
#define RX1_CAL_READ_AFE_SET(val) VR9_AfeWrite(RX1_CAL_READ, (val), 0xFFFF)

/** offsetp - The OffsetP calibration value. */
#define RX1_CAL_READ_OFFSETP_MASK 0x1f
#define RX1_CAL_READ_OFFSETP_AFE_GET ((VR9_AfeRead(RX1_CAL_READ) & RX1_CAL_READ_OFFSETP_MASK) >> 0)
#define RX1_CAL_READ_OFFSETP_AFE_SET(val) VR9_AfeWrite(RX1_CAL_READ, (val) << 0, RX1_CAL_READ_OFFSETP_MASK)

/** offsetn - The OffsetN calibration value. */
#define RX1_CAL_READ_OFFSETN_MASK 0x3e0
#define RX1_CAL_READ_OFFSETN_AFE_GET ((VR9_AfeRead(RX1_CAL_READ) & RX1_CAL_READ_OFFSETN_MASK) >> 5)
#define RX1_CAL_READ_OFFSETN_AFE_SET(val) VR9_AfeWrite(RX1_CAL_READ, (val) << 5, RX1_CAL_READ_OFFSETN_MASK)


/** Calibration Bypass Register - This Register is used for bypassing calibration offset values. */
#define RX1_CAL_BYP (GLP_SLAVE_BASE + 0x35)
#define RX1_CAL_BYP_AFE_GET VR9_AfeRead(RX1_CAL_BYP)
#define RX1_CAL_BYP_AFE_SET(val) VR9_AfeWrite(RX1_CAL_BYP, (val), 0xFFFF)

/** offsetp - The OffsetP calibration value is overridden by this value when bypass is enabled. */
#define RX1_CAL_BYP_OFFSETP_MASK 0x1f
#define RX1_CAL_BYP_OFFSETP_AFE_GET ((VR9_AfeRead(RX1_CAL_BYP) & RX1_CAL_BYP_OFFSETP_MASK) >> 0)
#define RX1_CAL_BYP_OFFSETP_AFE_SET(val) VR9_AfeWrite(RX1_CAL_BYP, (val) << 0, RX1_CAL_BYP_OFFSETP_MASK)

/** offsetn - The OffsetN calibration value is overridden by this value when bypass is enabled. */
#define RX1_CAL_BYP_OFFSETN_MASK 0x3e0
#define RX1_CAL_BYP_OFFSETN_AFE_GET ((VR9_AfeRead(RX1_CAL_BYP) & RX1_CAL_BYP_OFFSETN_MASK) >> 5)
#define RX1_CAL_BYP_OFFSETN_AFE_SET(val) VR9_AfeWrite(RX1_CAL_BYP, (val) << 5, RX1_CAL_BYP_OFFSETN_MASK)

/** BYPASS - Register Bypass bit. Calibration offsets will be overridden by register values when enabled.  */
#define RX1_CAL_BYP_BYPASS_MASK 0x8000
#define RX1_CAL_BYP_BYPASS_AFE_GET ((VR9_AfeRead(RX1_CAL_BYP) & RX1_CAL_BYP_BYPASS_MASK) >> 15)
#define RX1_CAL_BYP_BYPASS_AFE_SET(val) VR9_AfeWrite(RX1_CAL_BYP, (val) << 15, RX1_CAL_BYP_BYPASS_MASK)
/** Disable */
#define BYPASS_DIS 0x0
/** Enable */
#define BYPASS_EN 0x1


/** Termination Resistor Register - This Register is for configuration of termination resistors. */
#define RX1_RTERM (GLP_SLAVE_BASE + 0x36)
#define RX1_RTERM_AFE_GET VR9_AfeRead(RX1_RTERM)
#define RX1_RTERM_AFE_SET(val) VR9_AfeWrite(RX1_RTERM, (val), 0xFFFF)

/** rterm - Configures termination resistors in PHY. */
#define RX1_RTERM_SEL_MASK 0xffff
#define RX1_RTERM_SEL_AFE_GET ((VR9_AfeRead(RX1_RTERM) & RX1_RTERM_SEL_MASK) >> 0)
#define RX1_RTERM_SEL_AFE_SET(val) VR9_AfeWrite(RX1_RTERM, (val) << 0, RX1_RTERM_SEL_MASK)


/** Test Control Register - This Register is for Test control of RX1 SLICE. */
#define RX1_TEST_CTRL (GLP_SLAVE_BASE + 0x37)
#define RX1_TEST_CTRL_AFE_GET VR9_AfeRead(RX1_TEST_CTRL)
#define RX1_TEST_CTRL_AFE_SET(val) VR9_AfeWrite(RX1_TEST_CTRL, (val), 0xFFFF)

/** Testbus Enable - Enables Test bus in PMD. */
#define RX1_TEST_CTRL_TESTBUS_EN_MASK 0x1
#define RX1_TEST_CTRL_TESTBUS_EN_AFE_GET ((VR9_AfeRead(RX1_TEST_CTRL) & RX1_TEST_CTRL_TESTBUS_EN_MASK) >> 0)
#define RX1_TEST_CTRL_TESTBUS_EN_AFE_SET(val) VR9_AfeWrite(RX1_TEST_CTRL, (val) << 0, RX1_TEST_CTRL_TESTBUS_EN_MASK)

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define RX1_TEST_CTRL_TESTBUS_BIST_EN_MASK 0x2
#define RX1_TEST_CTRL_TESTBUS_BIST_EN_AFE_GET ((VR9_AfeRead(RX1_TEST_CTRL) & RX1_TEST_CTRL_TESTBUS_BIST_EN_MASK) >> 1)
#define RX1_TEST_CTRL_TESTBUS_BIST_EN_AFE_SET(val) VR9_AfeWrite(RX1_TEST_CTRL, (val) << 1, RX1_TEST_CTRL_TESTBUS_BIST_EN_MASK)


/** Control Register - This Register is for controlling of RX2 SLICE behavior. */
#define RX2_CTRL (GLP_SLAVE_BASE + 0x38)
#define RX2_CTRL_AFE_GET VR9_AfeRead(RX2_CTRL)
#define RX2_CTRL_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val), 0xFFFF)

/** Enable - Enable bit. */
#define RX2_CTRL_EN_MASK 0x1
#define RX2_CTRL_EN_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_EN_MASK) >> 0)
#define RX2_CTRL_EN_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 0, RX2_CTRL_EN_MASK)

/** CG_BIAS */
#define RX2_CTRL_CG_BIAS_MASK 0xe
#define RX2_CTRL_CG_BIAS_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_CG_BIAS_MASK) >> 1)
#define RX2_CTRL_CG_BIAS_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 1, RX2_CTRL_CG_BIAS_MASK)

/** CML_BIAS_SEL */
#define RX2_CTRL_CML_BIAS_SEL_MASK 0x30
#define RX2_CTRL_CML_BIAS_SEL_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_CML_BIAS_SEL_MASK) >> 4)
#define RX2_CTRL_CML_BIAS_SEL_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 4, RX2_CTRL_CML_BIAS_SEL_MASK)

/** EDGE_DISABLE */
#define RX2_CTRL_EDGE_DISABLE_MASK 0x40
#define RX2_CTRL_EDGE_DISABLE_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_EDGE_DISABLE_MASK) >> 6)
#define RX2_CTRL_EDGE_DISABLE_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 6, RX2_CTRL_EDGE_DISABLE_MASK)

/** IBIAS_SEL */
#define RX2_CTRL_IBIAS_SEL_MASK 0x80
#define RX2_CTRL_IBIAS_SEL_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_IBIAS_SEL_MASK) >> 7)
#define RX2_CTRL_IBIAS_SEL_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 7, RX2_CTRL_IBIAS_SEL_MASK)

/** RES_SEL */
#define RX2_CTRL_RES_SEL_MASK 0x100
#define RX2_CTRL_RES_SEL_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_RES_SEL_MASK) >> 8)
#define RX2_CTRL_RES_SEL_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 8, RX2_CTRL_RES_SEL_MASK)

/** RESBOOST */
#define RX2_CTRL_RESBOOST_MASK 0x600
#define RX2_CTRL_RESBOOST_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_RESBOOST_MASK) >> 9)
#define RX2_CTRL_RESBOOST_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 9, RX2_CTRL_RESBOOST_MASK)

/** Invert Enable - Enables the inversion of RX2 data. */
#define RX2_CTRL_INV_EN_MASK 0x800
#define RX2_CTRL_INV_EN_AFE_GET ((VR9_AfeRead(RX2_CTRL) & RX2_CTRL_INV_EN_MASK) >> 11)
#define RX2_CTRL_INV_EN_AFE_SET(val) VR9_AfeWrite(RX2_CTRL, (val) << 11, RX2_CTRL_INV_EN_MASK)


/** Programmable Data Register - This Register is for programming data for transmission. */
#define RX2_PROG_DATA (GLP_SLAVE_BASE + 0x39)
#define RX2_PROG_DATA_AFE_GET VR9_AfeRead(RX2_PROG_DATA)
#define RX2_PROG_DATA_AFE_SET(val) VR9_AfeWrite(RX2_PROG_DATA, (val), 0xFFFF)

/** Programmable RX2 Data - Programmable Data for RX2. */
#define RX2_PROG_DATA_DATA_MASK 0xff
#define RX2_PROG_DATA_DATA_AFE_GET ((VR9_AfeRead(RX2_PROG_DATA) & RX2_PROG_DATA_DATA_MASK) >> 0)
#define RX2_PROG_DATA_DATA_AFE_SET(val) VR9_AfeWrite(RX2_PROG_DATA, (val) << 0, RX2_PROG_DATA_DATA_MASK)

/** Enable Programmable RX2 Data - Enable Programmable Data for RX2. */
#define RX2_PROG_DATA_PRG_EN_MASK 0x100
#define RX2_PROG_DATA_PRG_EN_AFE_GET ((VR9_AfeRead(RX2_PROG_DATA) & RX2_PROG_DATA_PRG_EN_MASK) >> 8)
#define RX2_PROG_DATA_PRG_EN_AFE_SET(val) VR9_AfeWrite(RX2_PROG_DATA, (val) << 8, RX2_PROG_DATA_PRG_EN_MASK)
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1


/** CDR Configuration Register - This Register is for Configuration of CDR CTRL. */
#define RX2_CDR (GLP_SLAVE_BASE + 0x3a)
#define RX2_CDR_AFE_GET VR9_AfeRead(RX2_CDR)
#define RX2_CDR_AFE_SET(val) VR9_AfeWrite(RX2_CDR, (val), 0xFFFF)

/** comp - Comp. */
#define RX2_CDR_COMP_MASK 0x7
#define RX2_CDR_COMP_AFE_GET ((VR9_AfeRead(RX2_CDR) & RX2_CDR_COMP_MASK) >> 0)
#define RX2_CDR_COMP_AFE_SET(val) VR9_AfeWrite(RX2_CDR, (val) << 0, RX2_CDR_COMP_MASK)

/** dumpint - dumpint. */
#define RX2_CDR_DUMPINT_MASK 0x70
#define RX2_CDR_DUMPINT_AFE_GET ((VR9_AfeRead(RX2_CDR) & RX2_CDR_DUMPINT_MASK) >> 4)
#define RX2_CDR_DUMPINT_AFE_SET(val) VR9_AfeWrite(RX2_CDR, (val) << 4, RX2_CDR_DUMPINT_MASK)

/** xor_inv - XOR_INV. */
#define RX2_CDR_XOR_INV_MASK 0x100
#define RX2_CDR_XOR_INV_AFE_GET ((VR9_AfeRead(RX2_CDR) & RX2_CDR_XOR_INV_MASK) >> 8)
#define RX2_CDR_XOR_INV_AFE_SET(val) VR9_AfeWrite(RX2_CDR, (val) << 8, RX2_CDR_XOR_INV_MASK)

/** sum_int - SUM_INT. */
#define RX2_CDR_SUM_INT_MASK 0x200
#define RX2_CDR_SUM_INT_AFE_GET ((VR9_AfeRead(RX2_CDR) & RX2_CDR_SUM_INT_MASK) >> 9)
#define RX2_CDR_SUM_INT_AFE_SET(val) VR9_AfeWrite(RX2_CDR, (val) << 9, RX2_CDR_SUM_INT_MASK)


/** Calibration Control Register - This Register is for configuring and reading the calibration settings. */
#define RX2_CAL_CTRL (GLP_SLAVE_BASE + 0x3b)
#define RX2_CAL_CTRL_AFE_GET VR9_AfeRead(RX2_CAL_CTRL)
#define RX2_CAL_CTRL_AFE_SET(val) VR9_AfeWrite(RX2_CAL_CTRL, (val), 0xFFFF)

/** sample count - The number of samples used for calibration. */
#define RX2_CAL_CTRL_SMPL_CNT_MASK 0xf
#define RX2_CAL_CTRL_SMPL_CNT_AFE_GET ((VR9_AfeRead(RX2_CAL_CTRL) & RX2_CAL_CTRL_SMPL_CNT_MASK) >> 0)
#define RX2_CAL_CTRL_SMPL_CNT_AFE_SET(val) VR9_AfeWrite(RX2_CAL_CTRL, (val) << 0, RX2_CAL_CTRL_SMPL_CNT_MASK)

/** comparison count - The limit value for comparison used during calibration for hysteresis. */
#define RX2_CAL_CTRL_COMP_CNT_MASK 0xf0
#define RX2_CAL_CTRL_COMP_CNT_AFE_GET ((VR9_AfeRead(RX2_CAL_CTRL) & RX2_CAL_CTRL_COMP_CNT_MASK) >> 4)
#define RX2_CAL_CTRL_COMP_CNT_AFE_SET(val) VR9_AfeWrite(RX2_CAL_CTRL, (val) << 4, RX2_CAL_CTRL_COMP_CNT_MASK)

/** Invert direction - The data is inverted when set. */
#define RX2_CAL_CTRL_INV_DIR_MASK 0x100
#define RX2_CAL_CTRL_INV_DIR_AFE_GET ((VR9_AfeRead(RX2_CAL_CTRL) & RX2_CAL_CTRL_INV_DIR_MASK) >> 8)
#define RX2_CAL_CTRL_INV_DIR_AFE_SET(val) VR9_AfeWrite(RX2_CAL_CTRL, (val) << 8, RX2_CAL_CTRL_INV_DIR_MASK)

/** Calibration Fail - The calibration fail status. */
#define RX2_CAL_CTRL_CAL_FAIL_MASK 0x200
#define RX2_CAL_CTRL_CAL_FAIL_AFE_GET ((VR9_AfeRead(RX2_CAL_CTRL) & RX2_CAL_CTRL_CAL_FAIL_MASK) >> 9)
#define RX2_CAL_CTRL_CAL_FAIL_AFE_SET(val) VR9_AfeWrite(RX2_CAL_CTRL, (val) << 9, RX2_CAL_CTRL_CAL_FAIL_MASK)


/** Calibration Offsets Register - This Register is for reading the actual calibration offset values. */
#define RX2_CAL_READ (GLP_SLAVE_BASE + 0x3c)
#define RX2_CAL_READ_AFE_GET VR9_AfeRead(RX2_CAL_READ)
#define RX2_CAL_READ_AFE_SET(val) VR9_AfeWrite(RX2_CAL_READ, (val), 0xFFFF)

/** offsetp - The OffsetP calibration value. */
#define RX2_CAL_READ_OFFSETP_MASK 0x1f
#define RX2_CAL_READ_OFFSETP_AFE_GET ((VR9_AfeRead(RX2_CAL_READ) & RX2_CAL_READ_OFFSETP_MASK) >> 0)
#define RX2_CAL_READ_OFFSETP_AFE_SET(val) VR9_AfeWrite(RX2_CAL_READ, (val) << 0, RX2_CAL_READ_OFFSETP_MASK)

/** offsetn - The OffsetN calibration value. */
#define RX2_CAL_READ_OFFSETN_MASK 0x3e0
#define RX2_CAL_READ_OFFSETN_AFE_GET ((VR9_AfeRead(RX2_CAL_READ) & RX2_CAL_READ_OFFSETN_MASK) >> 5)
#define RX2_CAL_READ_OFFSETN_AFE_SET(val) VR9_AfeWrite(RX2_CAL_READ, (val) << 5, RX2_CAL_READ_OFFSETN_MASK)


/** Calibration Bypass Register - This Register is used for bypassing calibration offset values. */
#define RX2_CAL_BYP (GLP_SLAVE_BASE + 0x3d)
#define RX2_CAL_BYP_AFE_GET VR9_AfeRead(RX2_CAL_BYP)
#define RX2_CAL_BYP_AFE_SET(val) VR9_AfeWrite(RX2_CAL_BYP, (val), 0xFFFF)

/** offsetp - The OffsetP calibration value is overridden by this value when bypass is enabled. */
#define RX2_CAL_BYP_OFFSETP_MASK 0x1f
#define RX2_CAL_BYP_OFFSETP_AFE_GET ((VR9_AfeRead(RX2_CAL_BYP) & RX2_CAL_BYP_OFFSETP_MASK) >> 0)
#define RX2_CAL_BYP_OFFSETP_AFE_SET(val) VR9_AfeWrite(RX2_CAL_BYP, (val) << 0, RX2_CAL_BYP_OFFSETP_MASK)

/** offsetn - The OffsetN calibration value is overridden by this value when bypass is enabled. */
#define RX2_CAL_BYP_OFFSETN_MASK 0x3e0
#define RX2_CAL_BYP_OFFSETN_AFE_GET ((VR9_AfeRead(RX2_CAL_BYP) & RX2_CAL_BYP_OFFSETN_MASK) >> 5)
#define RX2_CAL_BYP_OFFSETN_AFE_SET(val) VR9_AfeWrite(RX2_CAL_BYP, (val) << 5, RX2_CAL_BYP_OFFSETN_MASK)

/** BYPASS - Register Bypass bit. Calibration offsets will be overridden by register values when enabled.  */
#define RX2_CAL_BYP_BYPASS_MASK 0x8000
#define RX2_CAL_BYP_BYPASS_AFE_GET ((VR9_AfeRead(RX2_CAL_BYP) & RX2_CAL_BYP_BYPASS_MASK) >> 15)
#define RX2_CAL_BYP_BYPASS_AFE_SET(val) VR9_AfeWrite(RX2_CAL_BYP, (val) << 15, RX2_CAL_BYP_BYPASS_MASK)
/** Disable */
#define BYPASS_DIS 0x0
/** Enable */
#define BYPASS_EN 0x1


/** Termination Resistor Register - This Register is for configuration of termination resistors. */
#define RX2_RTERM (GLP_SLAVE_BASE + 0x3e)
#define RX2_RTERM_AFE_GET VR9_AfeRead(RX2_RTERM)
#define RX2_RTERM_AFE_SET(val) VR9_AfeWrite(RX2_RTERM, (val), 0xFFFF)

/** rterm - Configures termination resistors in PHY. */
#define RX2_RTERM_SEL_MASK 0xffff
#define RX2_RTERM_SEL_AFE_GET ((VR9_AfeRead(RX2_RTERM) & RX2_RTERM_SEL_MASK) >> 0)
#define RX2_RTERM_SEL_AFE_SET(val) VR9_AfeWrite(RX2_RTERM, (val) << 0, RX2_RTERM_SEL_MASK)


/** Test Control Register - This Register is for Test control of RX2 SLICE. */
#define RX2_TEST_CTRL (GLP_SLAVE_BASE + 0x3f)
#define RX2_TEST_CTRL_AFE_GET VR9_AfeRead(RX2_TEST_CTRL)
#define RX2_TEST_CTRL_AFE_SET(val) VR9_AfeWrite(RX2_TEST_CTRL, (val), 0xFFFF)

/** Testbus Enable - Enables Test bus in PMD. */
#define RX2_TEST_CTRL_TESTBUS_EN_MASK 0x1
#define RX2_TEST_CTRL_TESTBUS_EN_AFE_GET ((VR9_AfeRead(RX2_TEST_CTRL) & RX2_TEST_CTRL_TESTBUS_EN_MASK) >> 0)
#define RX2_TEST_CTRL_TESTBUS_EN_AFE_SET(val) VR9_AfeWrite(RX2_TEST_CTRL, (val) << 0, RX2_TEST_CTRL_TESTBUS_EN_MASK)

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define RX2_TEST_CTRL_TESTBUS_BIST_EN_MASK 0x2
#define RX2_TEST_CTRL_TESTBUS_BIST_EN_AFE_GET ((VR9_AfeRead(RX2_TEST_CTRL) & RX2_TEST_CTRL_TESTBUS_BIST_EN_MASK) >> 1)
#define RX2_TEST_CTRL_TESTBUS_BIST_EN_AFE_SET(val) VR9_AfeWrite(RX2_TEST_CTRL, (val) << 1, RX2_TEST_CTRL_TESTBUS_BIST_EN_MASK)


/** Control Register - This Register is for controlling of RX3 SLICE behavior. */
#define RX3_CTRL (GLP_SLAVE_BASE + 0x40)
#define RX3_CTRL_AFE_GET VR9_AfeRead(RX3_CTRL)
#define RX3_CTRL_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val), 0xFFFF)

/** Enable - Enable bit. */
#define RX3_CTRL_EN_MASK 0x1
#define RX3_CTRL_EN_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_EN_MASK) >> 0)
#define RX3_CTRL_EN_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 0, RX3_CTRL_EN_MASK)

/** CG_BIAS */
#define RX3_CTRL_CG_BIAS_MASK 0xe
#define RX3_CTRL_CG_BIAS_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_CG_BIAS_MASK) >> 1)
#define RX3_CTRL_CG_BIAS_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 1, RX3_CTRL_CG_BIAS_MASK)

/** CML_BIAS_SEL */
#define RX3_CTRL_CML_BIAS_SEL_MASK 0x30
#define RX3_CTRL_CML_BIAS_SEL_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_CML_BIAS_SEL_MASK) >> 4)
#define RX3_CTRL_CML_BIAS_SEL_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 4, RX3_CTRL_CML_BIAS_SEL_MASK)

/** EDGE_DISABLE */
#define RX3_CTRL_EDGE_DISABLE_MASK 0x40
#define RX3_CTRL_EDGE_DISABLE_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_EDGE_DISABLE_MASK) >> 6)
#define RX3_CTRL_EDGE_DISABLE_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 6, RX3_CTRL_EDGE_DISABLE_MASK)

/** IBIAS_SEL */
#define RX3_CTRL_IBIAS_SEL_MASK 0x80
#define RX3_CTRL_IBIAS_SEL_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_IBIAS_SEL_MASK) >> 7)
#define RX3_CTRL_IBIAS_SEL_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 7, RX3_CTRL_IBIAS_SEL_MASK)

/** RES_SEL */
#define RX3_CTRL_RES_SEL_MASK 0x100
#define RX3_CTRL_RES_SEL_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_RES_SEL_MASK) >> 8)
#define RX3_CTRL_RES_SEL_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 8, RX3_CTRL_RES_SEL_MASK)

/** RESBOOST */
#define RX3_CTRL_RESBOOST_MASK 0x600
#define RX3_CTRL_RESBOOST_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_RESBOOST_MASK) >> 9)
#define RX3_CTRL_RESBOOST_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 9, RX3_CTRL_RESBOOST_MASK)

/** Invert Enable - Enables the inversion of RX3 data. */
#define RX3_CTRL_INV_EN_MASK 0x800
#define RX3_CTRL_INV_EN_AFE_GET ((VR9_AfeRead(RX3_CTRL) & RX3_CTRL_INV_EN_MASK) >> 11)
#define RX3_CTRL_INV_EN_AFE_SET(val) VR9_AfeWrite(RX3_CTRL, (val) << 11, RX3_CTRL_INV_EN_MASK)


/** Programmable Data Register - This Register is for programming data for transmission. */
#define RX3_PROG_DATA (GLP_SLAVE_BASE + 0x41)
#define RX3_PROG_DATA_AFE_GET VR9_AfeRead(RX3_PROG_DATA)
#define RX3_PROG_DATA_AFE_SET(val) VR9_AfeWrite(RX3_PROG_DATA, (val), 0xFFFF)

/** Programmable RX3 Data - Programmable Data for RX3. */
#define RX3_PROG_DATA_DATA_MASK 0xff
#define RX3_PROG_DATA_DATA_AFE_GET ((VR9_AfeRead(RX3_PROG_DATA) & RX3_PROG_DATA_DATA_MASK) >> 0)
#define RX3_PROG_DATA_DATA_AFE_SET(val) VR9_AfeWrite(RX3_PROG_DATA, (val) << 0, RX3_PROG_DATA_DATA_MASK)

/** Enable Programmable RX3 Data - Enable Programmable Data for RX3. */
#define RX3_PROG_DATA_PRG_EN_MASK 0x100
#define RX3_PROG_DATA_PRG_EN_AFE_GET ((VR9_AfeRead(RX3_PROG_DATA) & RX3_PROG_DATA_PRG_EN_MASK) >> 8)
#define RX3_PROG_DATA_PRG_EN_AFE_SET(val) VR9_AfeWrite(RX3_PROG_DATA, (val) << 8, RX3_PROG_DATA_PRG_EN_MASK)
/** Disable */
#define PRG_EN_DIS 0x0
/** Enable */
#define PRG_EN_EN 0x1


/** CDR Configuration Register - This Register is for Configuration of CDR CTRL. */
#define RX3_CDR (GLP_SLAVE_BASE + 0x42)
#define RX3_CDR_AFE_GET VR9_AfeRead(RX3_CDR)
#define RX3_CDR_AFE_SET(val) VR9_AfeWrite(RX3_CDR, (val), 0xFFFF)

/** comp - Comp. */
#define RX3_CDR_COMP_MASK 0x7
#define RX3_CDR_COMP_AFE_GET ((VR9_AfeRead(RX3_CDR) & RX3_CDR_COMP_MASK) >> 0)
#define RX3_CDR_COMP_AFE_SET(val) VR9_AfeWrite(RX3_CDR, (val) << 0, RX3_CDR_COMP_MASK)

/** dumpint - dumpint. */
#define RX3_CDR_DUMPINT_MASK 0x70
#define RX3_CDR_DUMPINT_AFE_GET ((VR9_AfeRead(RX3_CDR) & RX3_CDR_DUMPINT_MASK) >> 4)
#define RX3_CDR_DUMPINT_AFE_SET(val) VR9_AfeWrite(RX3_CDR, (val) << 4, RX3_CDR_DUMPINT_MASK)

/** xor_inv - XOR_INV. */
#define RX3_CDR_XOR_INV_MASK 0x100
#define RX3_CDR_XOR_INV_AFE_GET ((VR9_AfeRead(RX3_CDR) & RX3_CDR_XOR_INV_MASK) >> 8)
#define RX3_CDR_XOR_INV_AFE_SET(val) VR9_AfeWrite(RX3_CDR, (val) << 8, RX3_CDR_XOR_INV_MASK)

/** sum_int - SUM_INT. */
#define RX3_CDR_SUM_INT_MASK 0x200
#define RX3_CDR_SUM_INT_AFE_GET ((VR9_AfeRead(RX3_CDR) & RX3_CDR_SUM_INT_MASK) >> 9)
#define RX3_CDR_SUM_INT_AFE_SET(val) VR9_AfeWrite(RX3_CDR, (val) << 9, RX3_CDR_SUM_INT_MASK)


/** Calibration Control Register - This Register is for configuring and reading the calibration settings. */
#define RX3_CAL_CTRL (GLP_SLAVE_BASE + 0x43)
#define RX3_CAL_CTRL_AFE_GET VR9_AfeRead(RX3_CAL_CTRL)
#define RX3_CAL_CTRL_AFE_SET(val) VR9_AfeWrite(RX3_CAL_CTRL, (val), 0xFFFF)

/** sample count - The number of samples used for calibration. */
#define RX3_CAL_CTRL_SMPL_CNT_MASK 0xf
#define RX3_CAL_CTRL_SMPL_CNT_AFE_GET ((VR9_AfeRead(RX3_CAL_CTRL) & RX3_CAL_CTRL_SMPL_CNT_MASK) >> 0)
#define RX3_CAL_CTRL_SMPL_CNT_AFE_SET(val) VR9_AfeWrite(RX3_CAL_CTRL, (val) << 0, RX3_CAL_CTRL_SMPL_CNT_MASK)

/** comparison count - The limit value for comparison used during calibration for hysteresis. */
#define RX3_CAL_CTRL_COMP_CNT_MASK 0xf0
#define RX3_CAL_CTRL_COMP_CNT_AFE_GET ((VR9_AfeRead(RX3_CAL_CTRL) & RX3_CAL_CTRL_COMP_CNT_MASK) >> 4)
#define RX3_CAL_CTRL_COMP_CNT_AFE_SET(val) VR9_AfeWrite(RX3_CAL_CTRL, (val) << 4, RX3_CAL_CTRL_COMP_CNT_MASK)

/** Invert direction - The data is inverted when set. */
#define RX3_CAL_CTRL_INV_DIR_MASK 0x100
#define RX3_CAL_CTRL_INV_DIR_AFE_GET ((VR9_AfeRead(RX3_CAL_CTRL) & RX3_CAL_CTRL_INV_DIR_MASK) >> 8)
#define RX3_CAL_CTRL_INV_DIR_AFE_SET(val) VR9_AfeWrite(RX3_CAL_CTRL, (val) << 8, RX3_CAL_CTRL_INV_DIR_MASK)

/** Calibration Fail - The calibration fail status. */
#define RX3_CAL_CTRL_CAL_FAIL_MASK 0x200
#define RX3_CAL_CTRL_CAL_FAIL_AFE_GET ((VR9_AfeRead(RX3_CAL_CTRL) & RX3_CAL_CTRL_CAL_FAIL_MASK) >> 9)
#define RX3_CAL_CTRL_CAL_FAIL_AFE_SET(val) VR9_AfeWrite(RX3_CAL_CTRL, (val) << 9, RX3_CAL_CTRL_CAL_FAIL_MASK)


/** Calibration Offsets Register - This Register is for reading the actual calibration offset values. */
#define RX3_CAL_READ (GLP_SLAVE_BASE + 0x44)
#define RX3_CAL_READ_AFE_GET VR9_AfeRead(RX3_CAL_READ)
#define RX3_CAL_READ_AFE_SET(val) VR9_AfeWrite(RX3_CAL_READ, (val), 0xFFFF)

/** offsetp - The OffsetP calibration value. */
#define RX3_CAL_READ_OFFSETP_MASK 0x1f
#define RX3_CAL_READ_OFFSETP_AFE_GET ((VR9_AfeRead(RX3_CAL_READ) & RX3_CAL_READ_OFFSETP_MASK) >> 0)
#define RX3_CAL_READ_OFFSETP_AFE_SET(val) VR9_AfeWrite(RX3_CAL_READ, (val) << 0, RX3_CAL_READ_OFFSETP_MASK)

/** offsetn - The OffsetN calibration value. */
#define RX3_CAL_READ_OFFSETN_MASK 0x3e0
#define RX3_CAL_READ_OFFSETN_AFE_GET ((VR9_AfeRead(RX3_CAL_READ) & RX3_CAL_READ_OFFSETN_MASK) >> 5)
#define RX3_CAL_READ_OFFSETN_AFE_SET(val) VR9_AfeWrite(RX3_CAL_READ, (val) << 5, RX3_CAL_READ_OFFSETN_MASK)


/** Calibration Bypass Register - This Register is used for bypassing calibration offset values. */
#define RX3_CAL_BYP (GLP_SLAVE_BASE + 0x45)
#define RX3_CAL_BYP_AFE_GET VR9_AfeRead(RX3_CAL_BYP)
#define RX3_CAL_BYP_AFE_SET(val) VR9_AfeWrite(RX3_CAL_BYP, (val), 0xFFFF)

/** offsetp - The OffsetP calibration value is overridden by this value when bypass is enabled. */
#define RX3_CAL_BYP_OFFSETP_MASK 0x1f
#define RX3_CAL_BYP_OFFSETP_AFE_GET ((VR9_AfeRead(RX3_CAL_BYP) & RX3_CAL_BYP_OFFSETP_MASK) >> 0)
#define RX3_CAL_BYP_OFFSETP_AFE_SET(val) VR9_AfeWrite(RX3_CAL_BYP, (val) << 0, RX3_CAL_BYP_OFFSETP_MASK)

/** offsetn - The OffsetN calibration value is overridden by this value when bypass is enabled. */
#define RX3_CAL_BYP_OFFSETN_MASK 0x3e0
#define RX3_CAL_BYP_OFFSETN_AFE_GET ((VR9_AfeRead(RX3_CAL_BYP) & RX3_CAL_BYP_OFFSETN_MASK) >> 5)
#define RX3_CAL_BYP_OFFSETN_AFE_SET(val) VR9_AfeWrite(RX3_CAL_BYP, (val) << 5, RX3_CAL_BYP_OFFSETN_MASK)

/** BYPASS - Register Bypass bit. Calibration offsets will be overridden by register values when enabled.  */
#define RX3_CAL_BYP_BYPASS_MASK 0x8000
#define RX3_CAL_BYP_BYPASS_AFE_GET ((VR9_AfeRead(RX3_CAL_BYP) & RX3_CAL_BYP_BYPASS_MASK) >> 15)
#define RX3_CAL_BYP_BYPASS_AFE_SET(val) VR9_AfeWrite(RX3_CAL_BYP, (val) << 15, RX3_CAL_BYP_BYPASS_MASK)
/** Disable */
#define BYPASS_DIS 0x0
/** Enable */
#define BYPASS_EN 0x1


/** Termination Resistor Register - This Register is for configuration of termination resistors. */
#define RX3_RTERM (GLP_SLAVE_BASE + 0x46)
#define RX3_RTERM_AFE_GET VR9_AfeRead(RX3_RTERM)
#define RX3_RTERM_AFE_SET(val) VR9_AfeWrite(RX3_RTERM, (val), 0xFFFF)

/** rterm - Configures termination resistors in PHY. */
#define RX3_RTERM_SEL_MASK 0xffff
#define RX3_RTERM_SEL_AFE_GET ((VR9_AfeRead(RX3_RTERM) & RX3_RTERM_SEL_MASK) >> 0)
#define RX3_RTERM_SEL_AFE_SET(val) VR9_AfeWrite(RX3_RTERM, (val) << 0, RX3_RTERM_SEL_MASK)


/** Test Control Register - This Register is for Test control of RX3 SLICE. */
#define RX3_TEST_CTRL (GLP_SLAVE_BASE + 0x47)
#define RX3_TEST_CTRL_AFE_GET VR9_AfeRead(RX3_TEST_CTRL)
#define RX3_TEST_CTRL_AFE_SET(val) VR9_AfeWrite(RX3_TEST_CTRL, (val), 0xFFFF)

/** Testbus Enable - Enables Test bus in PMD. */
#define RX3_TEST_CTRL_TESTBUS_EN_MASK 0x1
#define RX3_TEST_CTRL_TESTBUS_EN_AFE_GET ((VR9_AfeRead(RX3_TEST_CTRL) & RX3_TEST_CTRL_TESTBUS_EN_MASK) >> 0)
#define RX3_TEST_CTRL_TESTBUS_EN_AFE_SET(val) VR9_AfeWrite(RX3_TEST_CTRL, (val) << 0, RX3_TEST_CTRL_TESTBUS_EN_MASK)

/** Testbus Bist Enable - Enables the BIST loop in PMD. */
#define RX3_TEST_CTRL_TESTBUS_BIST_EN_MASK 0x2
#define RX3_TEST_CTRL_TESTBUS_BIST_EN_AFE_GET ((VR9_AfeRead(RX3_TEST_CTRL) & RX3_TEST_CTRL_TESTBUS_BIST_EN_MASK) >> 1)
#define RX3_TEST_CTRL_TESTBUS_BIST_EN_AFE_SET(val) VR9_AfeWrite(RX3_TEST_CTRL, (val) << 1, RX3_TEST_CTRL_TESTBUS_BIST_EN_MASK)

#endif /* _GLP_SLAVE_H */
