/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_AnalogRegInit.c
*
*   This file contains VRX518 AFE init routines
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 Init routines
//
// **********************************************************************************************//

/*
** =============================================================================
**                           INCLUDE FILES
** =============================================================================
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "typedef.h"
#include "common.h"
#include "cmv.h"
#include "cmv_data.h"
#include "gdata.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#include "delay.h"


#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

extern int16 gs_FirstLink;
extern FlagT gft_ByPassAfe;

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  AFED_AnalogRegistersInit
**
** DESCRIPTION:    This function writes the reset values into AFE analog global registers.
**
** PARAMETERS:     None.
**
** RETURN VALUE:   none
**
** NOTES:Reference:
**
**
** =============================================================================
*/
void AFED_AnalogRegistersInit(void)
{
   uint16 dg_set = 1;
   // this check is for VRx518 bring-up only
   if (gft_ByPassAfe)
   {
      return;
   }

   // Reset CENTRAL Part of AFE block registers to default values
   //010B   RST   Reset the FCSI Controller and the FCSI-Bus registers. The Command is executed immediately.
   //011B   RSTFCSI  Reset FCSI-Bus registers. The Command is queued into the Transmit-FIFO.
   //Thomas Lusin mail dated May 12, 2016: I would use 011b, since this activates only the reset pin and does not reset the FCSI controller.
   //This will force the FCSI tree to load reset values of all registers at once.

   // Write to FCSI_CMD register to Write to AFE addr //_out(V_FCSI_CMD_C, ((addr&0x00FF)|0x6000));
   WriteCoreReg((uint32)(V_FCSI_CMD_C_35B_ADDR), FCSI_CMD_RST_BUSREGS);  //V_FCSI_CMD_C_35B_ADDR = 0x6000 means 011B RSTFCSI

   if(gft_PowerUpLink)
   {
      //Initialize these registers only during power on reset.
      //Note: Do not touch these registers on subsequent retrains after PowerOn
      VRX518_PowerOnOnlyAfeRegisterInit();
   }

   // Reset DSL Part of AFE block registers to default values
   //010B   RST   Reset the FCSI Controller and the FCSI-Bus registers. The Command is executed immediately.
   //011B   RSTFCSI  Reset FCSI-Bus registers. The Command is queued into the Transmit-FIFO.
   //Thomas Lusin mail dated May 12, 2016: I would use 011b, since this activates only the reset pin and does not reset the FCSI controller.
   //This will force the FCSI tree to load reset values of all registers at once.
   // Write to DSL FCSI_CMD register to Write to AFE addr //_out(V_FCSI_CMD_D, 0x6000);
   WriteCoreReg((uint32)(V_FCSI_CMD_D_35B_ADDR), FCSI_CMD_RST_BUSREGS);  //V_FCSI_CMD_D_35B_ADDR = 0x6000 means 011B RSTFCSI
    gul_Afe_flowtest |=2;
   delay(50);//50*10 = 50 cycles; Note: delay() internally provides 10 cycles delay
   vrx5afe_init();
   // XDSLRTFW-3232 (Start_End)
   vrx5afe_dg_init(dg_set);
    gul_Afe_flowtest |=4;
}

//----------------
// Initialization
//----------------
void vrx5afe_init()
{
   //int16_t d_tau_9bit;
   uint16 ReadDataDummy;

   gul_Afe_flowtest |=8;

   vrx5afe_central_init();
   gusa_AfeChipId[0] = VRX5AFE_FCSI_READ(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_VERSION), &ReadDataDummy);
   gusa_AfeChipId[1] = VRX5AFE_FCSI_READ(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_VERSIONDSL), &ReadDataDummy);

    //gusa_AfeChipId[1] = 1;
   vrx5afe_dsl_init();
    //Get AFE chip version and initialize globals based on chipId by passing the initFlag =1
   ReadDataDummy = vrx5afe_get_dsl_version_init(1);

   // tbd -> input parameter for 'fuse_table'
   // e-fusing: 1x only!
   // Bias, all LDOs, ADC, DAC, Pofi, PGA, Prefi, ... see e-fuse-table!
   // XDSLRTFW-3286 (Start)
   vrx518_ReadEFuseArray();
   // XDSLRTFW-3286 (End)

   vrx5afe_softfuse(&gula_VRX518_EfuseTable[0]);

    // RC-meas: 1x only!
   //d_tau_9bit = vrx5afe_rc_meas();
   //vrx5afe_rc_tune(d_tau_9bit);

   vrx5afe_rc_meas();
   vrx5afe_rc_tune();
    gul_Afe_flowtest |=0x10;
}


void vrx5afe_central_init()
{
    VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_LDOBIAS), \
    VRX5AFE_CENTRAL_FCSI_LDOBIAS_PDIREFTXDAC__ISMSK, VRX5AFE_CENTRAL_FCSI_LDOBIAS_PDIREFTXDAC_0__SVAL);

    // not used for vrx518
    //VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_CMLD36M), \
    //VRX5AFE_CENTRAL_FCSI_CMLD36M_ENCLKCMLREF__ISMSK & VRX5AFE_CENTRAL_FCSI_CMLD36M_ENCLKCMLREF__ISMSK, \
    //VRX5AFE_CENTRAL_FCSI_CMLD36M_ENCLKCMLREF_1__SVAL | VRX5AFE_CENTRAL_FCSI_CMLD36M_ENCLKCMLREF_1__SVAL);

    VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_LDOCLKD), \
    VRX5AFE_CENTRAL_FCSI_LDOCLKD_ENLDOCLKD__ISMSK & VRX5AFE_CENTRAL_FCSI_LDOCLKD_ENLOOPCOMPLDOCLKD__ISMSK, \
    VRX5AFE_CENTRAL_FCSI_LDOCLKD_ENLDOCLKD_1__SVAL | VRX5AFE_CENTRAL_FCSI_LDOCLKD_ENLOOPCOMPLDOCLKD_1__SVAL);

    VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_CLKDDSL), \
    VRX5AFE_CENTRAL_FCSI_CLKDDSL_ENTXCLK__ISMSK & VRX5AFE_CENTRAL_FCSI_CLKDDSL_ENRXCLK__ISMSK, \
    VRX5AFE_CENTRAL_FCSI_CLKDDSL_ENTXCLK_1__SVAL | VRX5AFE_CENTRAL_FCSI_CLKDDSL_ENRXCLK_1__SVAL);
}


void vrx5afe_dsl_init()
{
    uint16_t DSL_version;
    DSL_version = vrx5afe_get_dsl_version_init(0); //copy information from static area
    // DSL RX LDO 2V6 -> set pd to 0 (bit 0)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO2V6RX), \
    VRX5AFE_DSL_FCSI_DSLLDO2V6RX_ENLDO2V6RX__ISMSK, \
    VRX5AFE_DSL_FCSI_DSLLDO2V6RX_ENLDO2V6RX_ENABLE__SVAL);

    // DSL TX LDO 2V6 -> set pd to 0 (bit 0)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO2V6TX), \
    VRX5AFE_DSL_FCSI_DSLLDO2V6TX_ENLDO2V6TX__ISMSK, \
    VRX5AFE_DSL_FCSI_DSLLDO2V6TX_ENLDO2V6TX_ENABLE__SVAL);

    // DSL RX LDO 1V1 -> set pup to 1 (bit 0)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1RX), \
    VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PUPLDO1V1RX__ISMSK, \
    VRX5AFE_DSL_FCSI_DSLLDO1V1RX_PUPLDO1V1RX_1__SVAL);

    // DSL TX LDO 1V1 -> set pup to 1 (bit 0)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1TX), \
    VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PUPLDO1V1TX__ISMSK, \
    VRX5AFE_DSL_FCSI_DSLLDO1V1TX_PUPLDO1V1TX_1__SVAL);

    // DSL PREFI LDO 1V1 -> set pup to 1 (bit 0)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI), \
    VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PUPLDO1V1PREFI__ISMSK, \
    VRX5AFE_DSL_FCSI_DSLLDO1V1PREFI_PUPLDO1V1PREFI_1__SVAL);

    // SDADC 1V8 LDO -> set pd to 0 (bit 0)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC5), \
    VRX5AFE_DSL_FCSI_SDADC5_PDLDO__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC5_PDLDO_0__SVAL);

    // DSL local bias -> set pup local bias (bit 12 TX, bit 0 RX)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_BIASDSL), \
    VRX5AFE_DSL_FCSI_BIASDSL_PUPLBRX__ISMSK & VRX5AFE_DSL_FCSI_BIASDSL_PUPLBTX__ISMSK, \
    VRX5AFE_DSL_FCSI_BIASDSL_PUPLBRX_1__SVAL | VRX5AFE_DSL_FCSI_BIASDSL_PUPLBTX_1__SVAL);

    // SDADC enable sleep
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
    VRX5AFE_DSL_FCSI_SDADC4_ENSLEEP__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC4_ENSLEEP_ON__SVAL);

    // DSL local bias -> set pup local bias (bit 12 TX, bit 0 RX)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_BIASDSL), \
    VRX5AFE_DSL_FCSI_BIASDSL_PUPLBRX__ISMSK & VRX5AFE_DSL_FCSI_BIASDSL_PUPLBTX__ISMSK, \
    VRX5AFE_DSL_FCSI_BIASDSL_PUPLBRX_1__SVAL | VRX5AFE_DSL_FCSI_BIASDSL_PUPLBTX_1__SVAL);


    // DSL cml2cmos TX
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC0), \
    VRX5AFE_DSL_FCSI_CSDAC0_ENCML2CMOSTX__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC0_ENCML2CMOSTX_1__SVAL); // set pup cml2cmos (bit 14)

    // DSL cml2cmos RX
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
    VRX5AFE_DSL_FCSI_SDADC4_ENCML2CMOSRX__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC4_ENCML2CMOSRX_ON__SVAL); // set pup cml2cmos (bit 8)



    // TX path
    //
    // set reset cal of dac analog
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
    VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL_1__SVAL);

    // set resetn-s of dac digital
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC3), \
    VRX5AFE_DSL_FCSI_CSDAC3_FCTRESN__ISMSK & VRX5AFE_DSL_FCSI_CSDAC3_RESN__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC3_FCTRESN_0__SVAL | VRX5AFE_DSL_FCSI_CSDAC3_RESN_0__SVAL);

    // SYNC disable (reset)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC0), \
    VRX5AFE_DSL_FCSI_CSDAC0_ENSYNCTX__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC0_ENSYNCTX_0__SVAL); // set pup cml2cmos (bit 14)




    // set vcm1v5
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC0), \
    VRX5AFE_DSL_FCSI_CSDAC0_PROGVCM1V5__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC0_PROGVCM1V5_1V50__SVAL);

    // nocallsbaq set to 0, all other nocals are at 0 by default
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
    VRX5AFE_DSL_FCSI_CSDAC1_NOCALLSBAQ__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC1_NOCALLSBAQ_0__SVAL);

    // dataformat (is correct by default, just program it to be sure and have it in list)
    // 1 = invert msb: 2scomplement dig -> nice sinus on rx
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC2), \
    VRX5AFE_DSL_FCSI_CSDAC2_DATAFORMAT__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC2_DATAFORMAT_1__SVAL);

    // set DEM MODE, set random cal
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC3), \
    VRX5AFE_DSL_FCSI_CSDAC3_DEMMODELSB__ISMSK & VRX5AFE_DSL_FCSI_CSDAC3_DEMMODEMSB__ISMSK & \
    VRX5AFE_DSL_FCSI_CSDAC3_SETCALALL__ISMSK & VRX5AFE_DSL_FCSI_CSDAC3_RANDOMOFF__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC3_DEMMODELSB_CLA4__SVAL |VRX5AFE_DSL_FCSI_CSDAC3_DEMMODEMSB_CLA4__SVAL);

    // clkenable = 1
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC6), \
    VRX5AFE_DSL_FCSI_CSDAC6_CLKENABLE__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC6_CLKENABLE_1__SVAL);

    // SYNC enable
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC0), \
    VRX5AFE_DSL_FCSI_CSDAC0_ENSYNCTX__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC0_ENSYNCTX_1__SVAL); // set pup cml2cmos (bit 14)


    // Enable DAC
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
    VRX5AFE_DSL_FCSI_CSDAC1_ENDAC__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC1_ENDAC_1__SVAL);

    // release reset cal of dac analog
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC1), \
    VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC1_RESETCAL_0__SVAL);


    // release resetn-s of dac digital
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_CSDAC3), \
    VRX5AFE_DSL_FCSI_CSDAC3_FCTRESN__ISMSK & VRX5AFE_DSL_FCSI_CSDAC3_RESN__ISMSK, \
    VRX5AFE_DSL_FCSI_CSDAC3_FCTRESN_1__SVAL | VRX5AFE_DSL_FCSI_CSDAC3_RESN_1__SVAL);

    // set poco-gain to 6dB
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO1), \
    VRX5AFE_DSL_FCSI_POCO1_PRGGAIN__ISMSK, \
    VRX5AFE_DSL_FCSI_POCO1_PRGGAIN_6DB__SVAL);


    // POCO -> set fc of vdsl, set vdsl, pup POCO
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_POCO0), \
    VRX5AFE_DSL_FCSI_POCO0_PUPPOCO__ISMSK & VRX5AFE_DSL_FCSI_POCO0_FC2VDSL__ISMSK & VRX5AFE_DSL_FCSI_POCO0_FC1VDSL__ISMSK & \
    VRX5AFE_DSL_FCSI_POCO0_ADSLVDSLSEL__ISMSK, \
    VRX5AFE_DSL_FCSI_POCO0_PUPPOCO_ON__SVAL | VRX5AFE_DSL_FCSI_POCO0_FC2VDSL_1P55__SVAL | VRX5AFE_DSL_FCSI_POCO0_FC1VDSL_NOCAP1__SVAL| \
    VRX5AFE_DSL_FCSI_POCO0_ADSLVDSLSEL_VDSL__SVAL);


    // RX programmings
    // SDADC programmings (pd and set reset)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
    VRX5AFE_DSL_FCSI_SDADC4_PDADC__ISMSK & VRX5AFE_DSL_FCSI_SDADC4_RESETADC__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC4_PDADC_PD__SVAL | VRX5AFE_DSL_FCSI_SDADC4_RESETADC_1__SVAL);

    // sync programmings
    // disable rx-sync
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
    VRX5AFE_DSL_FCSI_SDADC4_ENSYNCRX__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC4_ENSYNCRX_OFF__SVAL);




    // PGA0 - set RSA to 400 Ohm
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA0), \
    VRX5AFE_DSL_FCSI_PGA0_PGA35RSA__ISMSK, \
    VRX5AFE_DSL_FCSI_PGA0_PGA35RSA_RSA400__SVAL);

    // no programming of B and C path needed (off by default)


    // PGA3 - feedback programming
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA3), \
    VRX5AFE_DSL_FCSI_PGA3_PGA35GAIN__ISMSK & VRX5AFE_DSL_FCSI_PGA3_PGA35LP__ISMSK, \
    VRX5AFE_DSL_FCSI_PGA3_PGA35GAIN_M9DB__SVAL | VRX5AFE_DSL_FCSI_PGA3_PGA35LP_CFB16__SVAL);


    // PGA4 - pup
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA4), \
    VRX5AFE_DSL_FCSI_PGA4_PGA35ENPGA__ISMSK & VRX5AFE_DSL_FCSI_PGA4_PGA35COMPSEL__ISMSK, \
    VRX5AFE_DSL_FCSI_PGA4_PGA35ENPGA_ENABLE__SVAL | VRX5AFE_DSL_FCSI_PGA4_PGA35COMPSEL_2__SVAL);


    // PREFI programmings

    // set bypass
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA5), \
    VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS__ISMSK, \
    VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS_1__SVAL);


    // prefi feedback
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA7), \
    VRX5AFE_DSL_FCSI_PGA7_PREFI35FBRES__ISMSK & VRX5AFE_DSL_FCSI_PGA7_PREFI35FBCAP__ISMSK, \
    VRX5AFE_DSL_FCSI_PGA7_PREFI35FBRES_M8DBVDSL__SVAL | VRX5AFE_DSL_FCSI_PGA7_PREFI35FBCAP_3P3__SVAL);

    if (DSL_version == 0)
    {   //A11
    // ACE off by default
        VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA5), \
        VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT__ISMSK & VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP__ISMSK & VRX5AFE_DSL_FCSI_PGA5_PREFI35PUP__ISMSK, \
        VRX5AFE_DSLA11_FCSI_PGA5_PREFI35IOUT_2__SVAL | VRX5AFE_DSLA11_FCSI_PGA5_PREFI35ENCAP_1__SVAL | VRX5AFE_DSL_FCSI_PGA5_PREFI35PUP_PUP__SVAL);
    }
    else
    {   //A21
    // R1 by default at 1.9k,iout, encap, pup
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA5), \
    VRX5AFE_DSL_FCSI_PGA5_PREFI35IOUT__ISMSK & VRX5AFE_DSL_FCSI_PGA5_PREFI35ENCAP__ISMSK & VRX5AFE_DSL_FCSI_PGA5_PREFI35PUP__ISMSK, \
    VRX5AFE_DSL_FCSI_PGA5_PREFI35IOUT_2__SVAL | VRX5AFE_DSL_FCSI_PGA5_PREFI35ENCAP_1__SVAL | VRX5AFE_DSL_FCSI_PGA5_PREFI35PUP_PUP__SVAL);
    }

    // invert msb (correct by reset, but program it to have it in list, important bit)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC1), \
    VRX5AFE_DSL_FCSI_SDADC1_INVMSB__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC1_INVMSB_ON__SVAL);


    // SDADC programmings (pup and release reset)
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
    VRX5AFE_DSL_FCSI_SDADC4_PDADC__ISMSK & VRX5AFE_DSL_FCSI_SDADC4_RESETADC__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC4_PDADC_PUP__SVAL | VRX5AFE_DSL_FCSI_SDADC4_RESETADC_0__SVAL);

    // release PREFI bypass
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA5), \
    VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS__ISMSK, \
    VRX5AFE_DSL_FCSI_PGA5_PREFI35BYPASS_0__SVAL);


    // sync programmings
    // enable rx-sync
    VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC4), \
    VRX5AFE_DSL_FCSI_SDADC4_ENSYNCRX__ISMSK, \
    VRX5AFE_DSL_FCSI_SDADC4_ENSYNCRX_ON__SVAL);
#if 1
    //-----------------------------------------------------------------------------------------
   // Is this change required to A11. Since A11 already tested and giving good results,
    //not taking the following code for A11.
    if (DSL_version != 0)
   {
      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC0), \
      VRX5AFE_DSL_FCSI_SDADC0_PROGDELLTC2__ISMSK, \
      VRX5AFE_DSL_FCSI_SDADC0_PROGDELLTC2_ON__SVAL);

      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_SDADC1), \
      VRX5AFE_DSL_FCSI_SDADC1_PROGCOMPCUR__ISMSK, \
      VRX5AFE_DSL_FCSI_SDADC1_PROGCOMPCUR_ON__SVAL);

      VRX5AFE_FCSI_RMW(VRX5AFE_DSL, DSL_FCSI(VRX5AFE_DSL_FCSI_PGA5), \
      VRX5AFE_DSL_FCSI_PGA5_PREFI35VCM__ISMSK, \
      VRX5AFE_DSL_FCSI_PGA5_PREFI35VCM_0__SVAL);
   }
#endif
}

/*
** =============================================================================
** LOCAL-FUNCTION-DESCRIPTION
**
** FUNCTION-NAME:  vrx5afe_get_dsl_version_init
**
** DESCRIPTION:    This function returns AFE Chip version
**
** PARAMETERS:     usInitFlag: 0/1
**
** RETURN VALUE:   Chip version
**
** NOTES:Reference:
**
**
** =============================================================================
*/
uint16_t vrx5afe_get_dsl_version_init(uint16 usInitFlag)
{
   uint16 usversion = 0;

   usversion = gusa_AfeChipId[1];

   if (usInitFlag)
   {
#ifdef ISDN
      if (usversion == 0) //A11 chip
      {
           gusa_InitHybridSettings= &gusa_HybridSetting_ADSL_B[0][0];
      }
       else
       {
           gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_B[0][0];

         //Configure A21 old LIF related settings
         if (TESTArray[TEST_Control3] & TEST_Control3_A21OldLifHyb)
         {
               //Assign A21_old hybrid table
            gusa_InitHybridSettings = &gusa_HybridSetting_ADSL_B[0][0];

            //QLN/Hlog for old A21 hybrid
               memcpy(gsa_VR9_PlusRxAFEFilt_dB, gsa_VR9_PlusRxAFEFilt_A21_old_dB, 258);
            memcpy(gsa_VR9_BisRxAFEFilt_dB, gsa_VR9_BisRxAFEFilt_A21_old_dB, 258);
            memcpy(gsa_VR9_DMTRxAFEFilt_dB, gsa_VR9_DMTRxAFEFilt_A21_old_dB, 258);
         }
       }
#else
      if (usversion == 0) //A11 chip
      {
         gusa_InitHybridSettings= &gusa_HybridSetting_ADSL_A[0][0];
      }
      else
      {
            //Assign A21_old hybrid table
         gusa_InitHybridSettings= &gusa_A21_HybridSetting_ADSL_A[0][0];
         guc_HybTable = 1;   //XDSLRTFW-3674 New_HybridSettings_changes

         //Configure A21 old LIF related settings
         if (TESTArray[TEST_Control3] & TEST_Control3_A21OldLifHyb)
         {
            gusa_InitHybridSettings= &gusa_HybridSetting_ADSL_A[0][0];
              guc_HybTable = 0;  //XDSLRTFW-3674 New_HybridSettings_changes

            //QLN/Hlog for old A21 hybrid
            memcpy(gsa_VR9_AnxA_PlusRxAFEFilt_dB, gsa_VR9_AnxA_PlusRxAFEFilt_A21_old_dB, 258);
            memcpy(gsa_VR9_AnxA_BisRxAFEFilt_dB, gsa_VR9_AnxA_BisRxAFEFilt_A21_old_dB, 258);
            memcpy(gsa_VR9_AnxA_DmtRxAFEFilt_dB, gsa_VR9_AnxA_DmtRxAFEFilt_A21_old_dB, 258);
         }
      }
#endif
       //Configure A21 old LIF related settings common variables for both Annex B/A
      if (TESTArray[TEST_Control3] & TEST_Control3_A21OldLifHyb)
      {
         memcpy(gusa_HybridSettingV2_Handshake_VRX518, gusa_HybridSettingV2_Handshake_A21_old_VRX518, 8);
      }
   }

   return usversion;
}

void VRX518_PowerOnOnlyAfeRegisterInit(void)
{

      //Initialize these registers only during power on reset.
      //Note: Do not touch these registers on subsequent retrains after PowerOn

}

//------------
// Dying gasp
//------------
// XDSLRTFW-3232 (Start)
void vrx5afe_dg_init(uint16_t dg_set)
{
   if (dg_set == 0)
   {
               VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_DG0), \
                                             VRX5AFE_CENTRAL_FCSI_DG0_PDDG__ISMSK, \
                                                            VRX5AFE_CENTRAL_FCSI_DG0_PDDG_1__SVAL);

               VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_DG0), \
                                             VRX5AFE_CENTRAL_FCSI_DG0_ENDGOUT__ISMSK, \
                                                            VRX5AFE_CENTRAL_FCSI_DG0_ENDGOUT_0__SVAL);
   }
   else if (dg_set == 1)
   {
               VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_DG0), \
                                             VRX5AFE_CENTRAL_FCSI_DG0_PDDG__ISMSK, \
                                                            VRX5AFE_CENTRAL_FCSI_DG0_PDDG_0__SVAL);

               VRX5AFE_FCSI_RMW(VRX5AFE_CENTRAL, CENTRAL_FCSI(VRX5AFE_CENTRAL_FCSI_DG0), \
                                             VRX5AFE_CENTRAL_FCSI_DG0_ENDGOUT__ISMSK, \
                                                            VRX5AFE_CENTRAL_FCSI_DG0_ENDGOUT_1__SVAL);
   }
}
// XDSLRTFW-3232 (End)
