/* **COPYRIGHT******************************************************************
    INTEL CONFIDENTIAL
    Copyright (C) 2017 Intel Corporation
    Copyright C 2016 Intel Corporation
******************************************************************COPYRIGHT** */
/* **DISCLAIMER*****************************************************************
    The source code contained or described herein and all documents related
    to the source code ("Material") are owned by Intel Corporation or its
    suppliers or licensors. Title to the Material remains with Intel
    Corporation or its suppliers and licensors. The Material may contain
    trade secrets and proprietary and confidential information of Intel
    Corporation and its suppliers and licensors, and is protected by
    worldwide copyright and trade secret laws and treaty provisions. No part
    of the Material may be used, copied, reproduced, modified, published,
    uploaded, posted, transmitted, distributed, or disclosed in any way
    without Intel's prior express written permission.

    No license under any patent, copyright, trade secret or other
    intellectual property right is granted to or conferred upon you by
    disclosure or delivery of the Materials, either expressly, by
    implication, inducement, estoppel or otherwise. Any license under
    such intellectual property rights must be express and approved by
    Intel in writing.
*****************************************************************DISCLAIMER** */
/*
*-------------------------------------------------------------------------------
*
*
*   file name: AFED_Data.c
*
*   This file contains VRX518 AFE Data
*
*-------------------------------------------------------------------------------
*/

// **********************************************************************************************//
// History
// 10/05/2016 Palaksha: Added VRX518 AFE related Data variables,Hybrid coefficients
//
// **********************************************************************************************//
#include "common.h"
#include "typedef.h"
#include "str_memmap.h"
#include "LL_IOf.h"
#include "delay.h"
#include "const.h"

#include "VRX_AfeCommonConst.h"
#include "VRX_AfeCommonData.h"
#include "AFED_Constants.h"
#include "AFED_Data.h"
#include "AFED_Functions.h"
#include "AFED_ReadWriteModify.h"

#include "vrx5afe_mode_defines.h"
#include "vrx5afe_central_addrmap.h"
#include "vrx5afe_central_fcsi_regpkg.h"     // register for CENTRAL
#include "vrx5afe_dsl_addrmap.h"
#include "vrx5afe_dsl_fcsi_regpkg.h"         // register for DSL

// global variable for RC-measurement
uint16_t RC_meas_done;
uint16_t RC_counter = 319;
int16 gs_Hyb_Hsk_QlnHlog;//gs_Hyb_Hsk_QlnHlog = 1 means HSK hybrid, 2 = QLNHLOG else Special setting

uint32  gul_Afe_flowtest = 0;
uint16  gus_SkipAfeFlow =0;
uint16 gus_ctune_poco_bin;
int16 gs_ctune_poco_bin_force;

//uint16  gus_SkipAfeFlow =0x400;

uint16  gus_AfeImproveFixes =1;
int16_t gs_ForceGainPofi_dB = -1;
int16 gs_PgaTrainingDbg =0;
int8 gc_AGC1_Gain_Start;


DATA_XILVB_B4_SHOW_INIT_BEGIN

//DSL Mode                       30M,     17MH    12M      8        ADSLA    ADSLB  VUS0  35b       BYP
//Index                                0        1           2     3        4           5        6     7        8
int32_t gla_fc_pga_lp_kHz[] = { 0,     60000, 00000, 12500, 10000, 00000, 00000, 60000,   60000};
int32_t gla_fc_prefi_lp_kHz[]={ 0,     30000, 00000, 15000, 10000, 00000, 00000, 60000,   60000};

//int32_t gla_fc_pofi_lp_kHz[] ={ 0,      30000, 00000, 15000,   320, 00000, 00000,  80000,  80000};
#ifdef ISDN
int32_t gla_fc_pofi_lp_kHz[] ={ 0,      30000, 00000, 15000,   320, 00000, 00000,  80000,    80000};
#else
int32_t gla_fc_pofi_lp_kHz[] ={ 0,      30000, 00000, 15000,   80, 00000, 00000,  80000,  80000};
#endif
//int16_t gsa_gain_pofi_dB[]  ={ 0,          4, 00000,     4,  -3, 00000, 00000,     4,      0 };//
int16_t gsa_gain_pofi_dB[]    ={ 0,               -3, 00000,     -3,       8, 00000, 00000,     -3,         0 };
//int16_t gsa_gain_pofi_dB[]  ={ 0,               -3, 00000,     -3,       -3, 00000, 00000,     -3,         0 };



//  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description

#ifdef ISDN
uint16 gusa_HybridSettingV2_Handshake_VRX518[VRX518_HYB_NUM_SETTINGS] = {0x0396, 0x3C12, 0x3C18, 0xFD03}; //   4  -2.9914 160 8633  114 off 15p 200 off 15p ETSI #1 (5000m)
uint16 gusa_HybridSettingV2_Handshake_A21_old_VRX518[VRX518_HYB_NUM_SETTINGS] = { 0x029D, 0x029F, 0x3FFE, 0xF2A3};  //   1   -19.5320   533   145   320  8633   6p   100  1953  11p  Null Loop
#else
uint16 gusa_HybridSettingV2_Handshake_VRX518[VRX518_HYB_NUM_SETTINGS] = {0x0375, 0x0013, 0x0410, 0xFD0A};
uint16 gusa_HybridSettingV2_Handshake_A21_old_VRX518[VRX518_HYB_NUM_SETTINGS] = {0x03BE, 0x1AFB, 0x3FFE, 0xF62D};//  5  -9.8262  800   12518 320   1347  6p 800   26319 15p   26AWGh (18000ft)
#endif

//Simulations showed that mostly the line noise at -145 dBm/Hz is the dominating noise source. Only at the low and high end of the used frequency range
//some transmitter generated noise from the POFI is approximately at the same level as the line noise. Maybe this can be improved a bit
//but not completely avoided. The highest receiver noise - the PGA - is ~6-7 dB below the line noise.

  //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
uint16 gusa_HybridSettingV2_QlnHlog_VRX518[VRX518_HYB_NUM_SETTINGS]   = { 0x001C,        0x001C,            0x001C,        0xFA17}; //-5.9113   400   off   400   off   0p   400   off   0p  QLN/HLOG

// VRX518 Hybrid settings for different profiles with AnxABJ LIF module
#ifdef ISDN
   //A21 Old Hybrid settings for different profiles for customer support
   uint16 gusa_HybridSetting_ADSL_B[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS]=
   {
      //PGA0   PGA1  PGA2  HybGain  Index HybGain  Rsa  Rpa  Rsb  Rpb  Cpb  Rsc  Rpc   Cpc  Description

      //Null loop Note:
      //AFE team Frank/Kai suggested to force Null loop Hybrid in the null loop case.
      //This one is taken care in RCReverb1RxF_BIS->case R_C_REVERB1_RX_BIS_LOAD_BEST_HYBRID
      {0x023C,  0x2A1B,  0x2AD2, 0xEEAC}, // 0  -17.3308  400  145   320  100  10p  114   929  10p  Null Loop
      {0x0210,  0x0ADF,  0x33BD, 0xF5F8}, // 1  -10.0349  100  100  1600  929  2p  533  12518  12p  ETSI #1 (500m)
#if 0 //This hybrid giving lesser rates for exmple at 3500m: DS rate: 3737 instead of 4393 kbps
      {0x029D,  0x029F,  0x3C1E, 0xF2A3}, // 2  -13.3658  533  442  1600  442  0p  800  off  15p  ETSI #1 (3000m)
#else //Modified Pga2->Rpc to 26319. helped 10% to 20% rates improvement
      {0x029D,  0x029F,  0x3FFE, 0xF2A3}, // 2  -13.3658  533  442  1600  442  0p  800  26319 15p  ETSI #1 (3000m)
#endif
      {0x02BE,  0x3E9F,  0x3FFE, 0xF157}, // 3  -14.6619  800  641  1600  442  15p  800   26319  15p  ETSI #1 (4000m)
      {0x0210,  0x32BF,  0x2C1B, 0xF5F8}, // 4  -10.0349  100  100  1600  641  12p  320   off  11p  ETSI #2 (500m)
      {0x025B,  0x1E7F,  0x281E, 0xF3B3}, // 5  -12.3017  267  210  1600  305  7p  800  off  10p  ETSI #2 (1500m)
      {0x029E,  0x221F,  0x041F, 0xEFBD}, // 6  -16.2642  800  442  1600  100  8p  1600   off  1p  ETSI #2 (3500m)
#if 0
      //These tables may not be required for Annex-B. No bridge taps in case of Annex B. If we enable these
      //some of the staright loops some loops are selecting one of these hybrids. It may cause CRCs.
      {0x0210,  0x02BF,  0x3C1C, 0xF5F8}, // 7  -10.0349  100  100  1600  641  0p  400  off  15p  26AWG (2000ft)
      {0x029E,  0x1E3F,  0x081F, 0xEFBD}, //  8 -16.2642  800  442  1600  145 7p 1600  off  2p  26AWG (10000ft)
      {0x02BE,  0x169F,  0x341D, 0xF157}, // 9  -14.6619  800  641  1600  442  5p  533  off  13p  26AWG (18000ft)
      {0x0211,  0x1639,  0x0A3F, 0xF58E}, // 10 -10.4463  107  100   229  145  5p  1600   145  2p  TR-100 Bridge Tap 0.5kft (100ft)
      {0x0270,  0x06BD,  0x0B7B, 0xFA97}, // 11 -5.4105  100  305  533  641  1p  320  4106   2p TR-100 Bridge Tap 3kft (100ft)
      {0x02D1,  0x0271,  0x001E, 0xFCAC}, // 12 -3.3292  107  929  107  305  0p  800  off  0p  TR-100 Bridge Tap 5kft (100ft)
      {0x0312,  0x02D3,  0x3C10, 0xFD3E}, // 13 -2.7586  114  1953   123  929  0p  100  off  15p  TR-100 Bridge Tap 5kft (200ft)
      {0x027C,  0x3E9F,  0x3C1F, 0xF2E0}, // 14 -13.1265  400  305   1600  442  15p 1600  off  15p TR-100 Bridge Tap 7kft (100ft)
      {0x03FB,  0x3AD0,  0x0018, 0xFB96}, // 15 -4.4141  267  26319  100  929  14p  200  off  0p  TR-100 Bridge Tap 7kft (200ft)
      {0x001B,  0x02F1,  0x0411, 0xFBB1}, //  16  -4.3101   267  off  107  1347  0p  107  off  1p  TR-100 Bridge Tap 9kft (200ft)
      {0x02BE,  0x3E9F,  0x3C1F, 0xF157}, // 17 -14.6619  800  641   1600  442  15p 1600  off  15p TR-100 Bridge Tap 11kft (100ft)
      {0x039B,  0x32B0,  0x3C1F, 0xFAAC}, // 18 -5.3307  320  8633   100  641  12p  1600  off  15p  TR-100 Bridge Tap 11kft (200ft)
      {0x02B9,  0x22DF,  0x241D, 0xF8FB}, // 19 -7.021   229  641  1600 929  8p  533  off  9p  TR-100 Bridge Tap 12kft (750ft)
      {0x001B,  0x1A93,  0x381D, 0xFB05}, // 20 -4.984   320  off  123  442   6p 533  off  14p  TR-100 Bridge Tap 12kft (1500ft)
      {0x0372,  0x3735,  0x3A1B, 0xFDBE}, // 21 -2.2611  114  5954   145  2832  13p 320  100  14p  TR-100 Bridge Tap 15kft (400ft)
      {0x029D,  0x123F,  0x0FFF, 0xF2A3}, // 22 -13.3658  533  442   1600  145  4p  1600  26319 3p TR-100 Bridge Tap 15kft (1000ft)
      {0x03DC,  0x1296,  0x141F, 0xF9E7}, // 23 -6.0983  400  18151  160  442  4p  1600  off  5p  TR-100 Bridge Tap 15kft (1500ft)
      {0x031D,  0x0676,  0x341E, 0xF6F0}, // 24 -9.0654  533  1953   160  305  1p  800  off  13p  TR-100 Bridge Tap 17.5kft (150ft)
#else
      {0x0210,  0x0ADF,  0x33BD, 0xF5F8}, // 7  -10.0349  100  100  1600  929  2p  533  12518  12p  ETSI #1 (500m)
      {0x029D,  0x029F,  0x3FFE, 0xF2A3}, // 8  -13.3658  533  442  1600  442  0p  800  26319 15p  ETSI #1 (3000m)
      {0x02BE,  0x3E9F,  0x3FFE, 0xF157}, // 9  -14.6619  800  641  1600  442  15p  800   26319  15p  ETSI #1 (4000m)
      {0x0210,  0x32BF,  0x2C1B, 0xF5F8}, // 10  -10.0349  100  100  1600  641  12p  320  off  11p  ETSI #2 (500m)
      {0x025B,  0x1E7F,  0x281E, 0xF3B3}, // 11  -12.3017  267  210  1600  305  7p  800  off 10p  ETSI #2 (1500m)
      {0x029E,  0x221F,  0x041F, 0xEFBD}, // 12  -16.2642  800  442  1600  100  8p  1600  off  1p  ETSI #2 (3500m)
      {0x0210,  0x0ADF,  0x33BD, 0xF5F8}, // 13  -10.0349  100  100  1600  929  2p  533  12518  12p  ETSI #1 (500m)
      {0x029D,  0x029F,  0x3FFE, 0xF2A3}, // 14 -13.3658  533  442  1600  442  0p  800  26319 15p  ETSI #1 (3000m)
      {0x02BE,  0x3E9F,  0x3FFE, 0xF157}, // 15  -14.6619  800  641  1600  442  15p  800  26319  15p  ETSI #1 (4000m)
      {0x0210,  0x32BF,  0x2C1B, 0xF5F8}, // 16  -10.0349  100  100  1600  641  12p  320  off  11p  ETSI #2 (500m)
      {0x025B,  0x1E7F,  0x281E, 0xF3B3}, // 17  -12.3017  267  210  1600  305  7p  800  off 10p  ETSI #2 (1500m)
      {0x029E,  0x221F,  0x041F, 0xEFBD}, // 18  -16.2642  800  442  1600  100  8p  1600  off  1p  ETSI #2 (3500m)
      {0x0210,  0x0ADF,  0x33BD, 0xF5F8}, // 19  -10.0349  100  100  1600  929  2p  533  12518  12p  ETSI #1 (500m)
      {0x029D,  0x029F,  0x3FFE, 0xF2A3}, // 20  -13.3658  533  442  1600  442  0p  800  26319 15p  ETSI #1 (3000m)
      {0x02BE,  0x3E9F,  0x3FFE, 0xF157}, // 21  -14.6619  800  641  1600  442  15p  800  26319  15p  ETSI #1 (4000m)
      {0x0210,  0x32BF,  0x2C1B, 0xF5F8}, // 22  -10.0349  100  100  1600  641  12p  320  off  11p  ETSI #2 (500m)
      {0x025B,  0x1E7F,  0x281E, 0xF3B3}, // 23  -12.3017  267  210  1600  305  7p  800  off 10p  ETSI #2 (1500m)
      {0x029E,  0x221F,  0x041F, 0xEFBD}, // 24  -16.2642  800  442  1600  100  8p  1600  off  1p  ETSI #2 (3500m)
#endif
      { 0x001C, 0x001C,  0x001C, 0xFA17}, //25 -5.9113   400   off   400   off   0p   400   off   0p  QLN/HLOG XDSLRTFW_3753

   };

//A21 new hybrid AnxB hybrid table:
//3rd May 2017: Comments from Frank
//          In particular, settings with an open series resistor in the B- or C-path were
//          changed to also have an open parallel resistor in the same path.
//          This ensures correct termination of the path and hence No CRCs
uint16 gusa_A21_HybridSetting_ADSL_B[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS]=
{
   //Null loop Note:
   //AFE team Frank/Kai suggested to force Null loop Hybrid in the null loop case.
   //This one is taken care in RCReverb1RxF_BIS->case R_C_REVERB1_RX_BIS_LOAD_BEST_HYBRID

   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
   {0x021B, 0x0E1F, 0x0B1C, 0xEF4A},// 0 -16.7125 267 100 1600 100 3p 400 1953 2p Null Loop
   {0x0250, 0x0EBE, 0x23D4, 0xF957},//  1 -6.6632 100 210 800 641 3p 133 18151 8p ETSI #1 (1000m)
   {0x0373, 0x3010, 0x1010, 0xFD92},//  2 -2.4298 123 5954 100 off 12p 100 off 4p ETSI #1 (2000m)
   {0x0395, 0x3C10, 0x3C16, 0xFD44},//  3 -2.736 145 8633 100 off 15p 160 off 15p ETSI #1 (3500m)
   {0x0396, 0x3C12, 0x3C18, 0xFD03},//  4 -2.9914 160 8633 114 off 15p 200 off 15p ETSI #1 (5000m)
   {0x03F6, 0x3C10, 0x3C11, 0xFD29},//  5 -2.8406 160 26319 100 off 15p 107 off 15p ETSI #2 (3500m)
   {0x03D6, 0x3010, 0x3810, 0xFD21},//  6 -2.874 160 18151 100 off 12p 100 off 14p ETSI #2 (5000m)
   {0x0016, 0x3410, 0x1412, 0xFD3C},//  7 -2.7661 160 off 100 off 13p 114 off 5p ETSI #6 (750m)
   {0x0396, 0x0BF0, 0x0010, 0xFD03},//  8 -2.9914 160 8633 100 26319 2p 100 off 0p ETSI #7 (200m)
   {0x0376, 0x3413, 0x3813, 0xFCE9},//  9 -3.0909 160 5954 123 off 13p 123 off 14p 26AWG (16000ft)
   {0x0250, 0x1733, 0x0000, 0xF957},//  10 -6.6632 100 210 123 2832 5p off off 0p TR-100 Bridge Tap 3kft (100ft)
   {0x0298, 0x1C12, 0x0000, 0xF88E},//  11 -7.4485 200 442 114 off 7p off off 0p TR-100 Bridge Tap 7kft (200ft)
   {0x0275, 0x1410, 0x0000, 0xF8E7},//  12 -7.0996 145 305 100 off 5p off off 0p TR-100 Bridge Tap 9kft (200ft)
   {0x02D0, 0x3F70, 0x3C1C, 0xFCDE},//  13 -3.1365 100 929 100 5954 15p 400 off 15p TR-100 Bridge Tap 11kft (100ft)
   {0x02D0, 0x17F4, 0x3EFE, 0xFCDE},//  14 -3.1365 100 929 133 26319 5p 800 1347 15p TR-100 Bridge Tap 15kft (1500ft)
   {0x0290, 0x2F77, 0x3F3D, 0xFB91},//  15 -4.4344 100 442 178 5954 11p 533 2832 15p TR-100 Bridge Tap 17.5kft (150ft)
   {0x0316, 0x0B30, 0x0810, 0xFC48},//  16 -3.7208 160 1953 100 2832 2p 100 off 2p DTAG_04mm (2500m)
   {0x02D8, 0x06FB, 0x0810, 0xFA73},//  17 -5.5513 200 929 320 1347 1p 100 off 2p DTAG_04mm (3500m)
   {0x0231, 0x3314, 0x027F, 0xF76F},//  18 -8.5674 107 145 133 1953 12p 1600 305 0p ETSI #1 (500m) w Splitter
   {0x02B0, 0x17D0, 0x33DC, 0xFC50},//  19 -3.6894 100 641 100 18151 5p 400 18151 12p ETSI #1 (1000m) w Splitter
   {0x02B0, 0x1C10, 0x3C1C, 0xFC50},//  20 -3.6894 100 641 100 off 7p 400 off 15p ETSI #1 (4000m) w Splitter
   {0x0250, 0x3E5B, 0x1415, 0xF957},//  21 -6.6632 100 210 267 210 15p 145 off 5p ETSI #1 (500m) w Splitter+ISDN
   {0x02B0, 0x1BFB, 0x3FDB, 0xFC50},//  22 -3.6894 100 641 267 26319 6p 267 18151 15p ETSI #1 (1000m) w Splitter+ISDN
   {0x02D0, 0x3411, 0x3819, 0xFCDE},//  23 -3.1365 100 929 107 off 13p 229 off 14p ETSI #1 (4000m) w Splitter+ISDN
   {0x03D9, 0x2016, 0x381D, 0xFC13}, // 24 Kai given coefficient
   {0x001C, 0x001C,  0x001C, 0xFA17}, //25 5.9113   400   off   400   off   0p   400   off   0p  QLN/HLOG XDSLRTFW_3753
};
#else
   //AnxA: A21 old hybrid table
   // A11 tables are replaced with A21 old hybrid tables since there is requirement of A11 support
   uint16 gusa_HybridSetting_ADSL_A[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS]=
   {
   {0x023C, 0x061C,  0x065D,  0xEEAC},//  1  -17.3308 400 145 400 100 1p   533 210 1p  Null Loop
   {0x0270, 0x02BB,  0x2C13,  0xFA97},//  1  -5.4105  100   305   320   641   0p 123   off   11p   26AWG (2000ft)
   {0x02F0, 0x1410,  0x2011,  0xFD45},//  2  -2.7329  100   1347  100   off   5p 107   off   8p 26AWG (4000ft)
   {0x03D9, 0x2010,  0x381B,  0xFC13},//  3  -3.9296  229   18151 100   off   8p 267   off   14p   26AWG (6000ft)
   {0x001D, 0x02D5,  0x281D,  0xF8BD},//  4  -7.2628  533   off   145   929   0p 533   off   10p   26AWG (14000ft)
   {0x03BE, 0x1AFB,  0x3FFE,  0xF62D},//  5  -9.8262  800   12518 320   1347  6p 800   26319 15p   26AWGh (18000ft)
   {0x0215, 0x369F,  0x2F60,  0xF39C},//  6  -12.3923 145   100   1600  442   13p   off   4106  11p   TR-100 Bridge Tap 0.5kft (100ft)
   {0x02D0, 0x039E,  0x3ABF,  0xFCDE},//  7  -3.1365  100   929   800   8633  0p 1600  641   14p   TR-100 Bridge Tap 3kft (100ft)
   {0x02D0, 0x2418,  0x341E,  0xFCDE},//  8  -3.1365  100   929   200   off   9p 800   off   13p   TR-100 Bridge Tap 3kft (200ft)
   {0x0010, 0x0B99,  0x3260,  0xFE3D},//  9  -1.7627  100   off   229   8633  2p off   305   12p   TR-100 Bridge Tap 5kft (100ft)
   {0x0010, 0x3FD5,  0x3C16,  0xFE3D},//  10 -1.7627  100   off   145   18151 15p   160   off   15p   TR-100 Bridge Tap 5kft (200ft)
   {0x0010, 0x3F90,  0x3C1F,  0xFE3D},//  11 -1.7627  100   off   100   8633  15p   1600  off   15p   TR-100 Bridge Tap 7kft (100ft)
   {0x0019, 0x3F7B,  0x3C11,  0xFC36},//  12 -3.7926  229   off   320   5954  15p   107   off   15p   TR-100 Bridge Tap 7kft (200ft)
   {0x001D, 0x3F94,  0x0EA0,  0xF8BD},//  13 -7.2628  533   off   133   8633  15p   off   641   3p TR-100 Bridge Tap 9kft (100ft)
   {0x0019, 0x033B,  0x0010,  0xFC36},//  14 -3.7926  229   off   267   2832  0p 100   off   0p TR-100 Bridge Tap 9kft (200ft)
   {0x001D, 0x3EF7,  0x3C1F,  0xF8BD},//  15 -7.2628  533   off   178   1347  15p   1600  off   15p   TR-100 Bridge Tap 11kft (100ft)
   {0x001C, 0x3F71,  0x2620,  0xFA17},//  16 -5.9113  400   off   107   4106  15p   off   145   9p TR-100 Bridge Tap 11kft (200ft)
   {0x0010, 0x0AF4,  0x0010,  0xFE3D},//  17 -1.7627  100   off   133   1347  2p 100   off   0p TR-100 Bridge Tap 12kft (250ft)
   {0x001B, 0x07FE,  0x281C,  0xFB05},//  18 -4.984   320   off   800   26319 1p 400   off   10p   TR-100 Bridge Tap 12kft (750ft)
   {0x03DB, 0x373E,  0x381C,  0xFADA},//  19 -5.1506  320   18151 800   2832  13p   400   off   14p   TR-100 Bridge Tap 12kft (1500ft)
   {0x0017, 0x2771,  0x2600,  0xFCF5},//  20 -3.0458  178   off   107   4106  9p off   100   9p TR-100 Bridge Tap 15kft (400ft)
   {0x0018, 0x2BBE,  0x2814,  0xFCA0},//  21 -3.3758  200   off   800   12518 10p   133   off   10p   TR-100 Bridge Tap 15kft (1000ft)
   {0x033D, 0x3B3F,  0x341E,  0xF775},//  22 -8.5449  533   2832  1600  2832  14p   800   off   13p   TR-100 Bridge Tap 15kft (1500ft)
   {0x001C, 0x02D3,  0x301F,  0xFA17},//  23 -5.9113  400   off   123   929   0p 1600  off   12p   TR-100 Bridge Tap 17.5kft (150ft)
   {0x0012, 0x33DE,  0x0F72,  0xFDFF},//  24 -2.0074  114   off   800   18151 12p   114   5954  3p TR-100 Bridge Tap 17.5kft (800ft)
   {0x0275, 0x141D,  0x0000,  0xF8E7},// 25  -7.0996   145   305   533   off   5p   off   off   0p  TR-67 Bridge Tap 15kft (1000ft)
   {0x0296, 0x041D,  0x0000,  0xF9A3},// 26  -6.3650   160   442   533   off   1p   off   off   0p  TR-67 Bridge Tap 15kft (1250ft)
   {0x02B2, 0x301D,  0x2ABE,  0xFBE2},// 27    -4.1192   114   641   533   off  12p   800   641  10p  TR-67 Bridge Tap 15kft (1500ft)
   {0x001C, 0x001C,  0x001C,  0xFA17}, // 28 5.9113   400   off   400   off   0p   400   off   0p  QLN/HLOG XDSLRTFW_3753
   };

//A21 new hybrid AnxA hybrid table:
//3rd May 2017: Comments from Frank
//              In particular, settings with an open series resistor in the B- or C-path were
//              changed to also have an open parallel resistor in the same path.
//              This ensures correct termination of the path and hence No CRCs
uint16 gusa_A21_HybridSetting_ADSL_A[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS]=
{
   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
   {0x021C, 0x0000, 0x2651, 0xEC33}, // 0  -19.8023 400 100 off off 0p 107 210 9p Null Loop
   {0x02F0, 0x1BF3, 0x0410, 0xFD45}, // 1  -2.7329 100 1347 123 26319 6p 100 off 1p 26AWG (6000ft)
   {0x0375, 0x0013, 0x0410, 0xFD0A}, // 2  -2.9619 145 4106 123 off 0p 100 off 1p 26AWG (16000ft)
   {0x0270, 0x13D0, 0x0000, 0xFA97}, // 3  -5.4105 100 305 100 18151 4p off off 0p TR-100 Bridge Tap 3kft (200ft)
   {0x02F0, 0x3FD9, 0x3C1E, 0xFD45}, // 4  -2.7329 100 1347 229 18151 15p 800 off 15p TR-100 Bridge Tap 7kft (100ft)
   {0x0310, 0x0412, 0x001E, 0xFD8F}, // 5  -2.4433 100 1953 114 off 1p 800 off 0p TR-100 Bridge Tap 9kft (200ft)
   {0x0312, 0x3C10, 0x381C, 0xFD3E}, // 6  -2.7586 114 1953 100 off 15p 400 off 14p TR-100 Bridge Tap 11kft (100ft)
   {0x02F2, 0x1C10, 0x301E, 0xFCED}, // 7  -3.0765 114 1347 100 off 7p 800 off 12p TR-100 Bridge Tap 12kft (100ft)
   {0x0293, 0x201D, 0x3F7F, 0xFAC7}, // 8  -5.226 123 442 533 off 8p 1600 4106 15p TR-100 Bridge Tap 12kft (750ft)
   {0x0290, 0x37F6, 0x3F7F, 0xFB91}, // 9  -4.4344 100 442 160 26319 13p 1600 4106 15p TR-100 Bridge Tap 15kft (400ft)
   {0x0275, 0x101D, 0x0000, 0xF8E7}, // 10 -7.0996 145 305 533 off 4p off off 0p TR-100 Bridge Tap 15kft (1000ft)
   {0x02B2, 0x2C1D, 0x02BE, 0xFBE2}, // 11 -4.1192 114 641 533 off 11p 800 641 0p TR-100 Bridge Tap 15kft (1500ft)
   {0x0299, 0x001D, 0x0000, 0xF7D8}, // 12 -8.1573 229 442 533 off 0p off off 0p TR-100 Bridge Tap 17.5kft (800ft)
   {0x0330, 0x1410, 0x2410, 0xFDC4}, // 13 -2.2377 100 2832 100 off 5p 100 off 9p ETSI #1 (2500m)
   {0x03B5, 0x0810, 0x2410, 0xFD55}, // 14 -2.6713 145 12518 100 off 2p 100 off 9p ETSI #2 (5000m)
   {0x02D0, 0x0F92, 0x0410, 0xFCDE}, // 15 -3.1365 100 929 114 8633 3p 100 off 1p DTAG_04mm (1500m)
   {0x0399, 0x0C10, 0x3817, 0xFBEC}, // 16 -4.0782 229 8633 100 off 3p 178 off 14p DTAG_04mm (5000m)
   {0x0377, 0x201B, 0x0810, 0xFC9B}, // 17 -3.3952 178 5954 267 off 8p 100 off 2p ANSI #1
   {0x02D0, 0x081D, 0x0EFD, 0xFCDE}, // 18 -3.1365 100 929 533 off 2p 533 1347 3p ANSI #2
   {0x0275, 0x001D, 0x0000, 0xF8E7}, // 19 -7.0996 145 305 533 off 0p off off 0p ANSI #8
   {0x0391, 0x001D, 0x141E, 0xFDF3}, // 20 -2.0533 107 8633 533 off 0p 800 off 5p ANSI #11
   {0x0374, 0x1810, 0x1410, 0xFD43}, // 21 -2.7386 133 4106 100 off 6p 100 off 5p ANSI #15
   {0x02D0, 0x081C, 0x141E, 0xFCDE}, // 22 -3.1365 100 929 400 off 2p 800 off 5p CSA #2
   {0x0019, 0x1778, 0x0410, 0xFC36}, // 23 -3.7926 229 off 200 4106 5p 100 off 1p CSA #4
   {0x0310, 0x3011, 0x0810, 0xFD8F}, // 24 -2.4433 100 1953 107 off 12p 100 off 2p CSA #5
   { 0x0275,   0x141D,   0x0000,    0xF8E7},  //  25    -7.0996   145   305   533   off   5p   off   off   0p  TR-67 Bridge Tap 15kft (1000ft)
   { 0x0296,   0x041D,   0x0000,    0xF9A3},  //  26    -6.3650   160   442   533   off   1p   off   off   0p  TR-67 Bridge Tap 15kft (1250ft)
   { 0x02B2,   0x301D,   0x2ABE,    0xFBE2},  //  27    -4.1192   114   641   533   off  12p   800   641  10p  TR-67 Bridge Tap 15kft (1500ft)
   {0x001C, 0x001C,  0x001C,  0xFA17}, // 28 5.9113   400   off   400   off   0p   400   off   0p  QLN/HLOG XDSLRTFW_3753
};
uint16 gusa_A21_HybridSetting_ADSL_A_17kft[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS]=
{
   //  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
   //{0x021C, 0x0000, 0x2651, 0xEC33}, // 0  -19.8023 400 100 off off 0p 107 210 9p Null Loop
   //{0x02F0, 0x1BF3, 0x0410, 0xFD45}, // 1  -2.7329 100 1347 123 26319 6p 100 off 1p 26AWG (6000ft)
   //{0x0375, 0x0013, 0x0410, 0xFD0A}, // 2  -2.9619 145 4106 123 off 0p 100 off 1p 26AWG (16000ft)
   {0x0270, 0x13D0, 0x0000, 0xFA97}, // 3  -5.4105 100 305 100 18151 4p off off 0p TR-100 Bridge Tap 3kft (200ft)
   {0x02F0, 0x3FD9, 0x3C1E, 0xFD45}, // 4  -2.7329 100 1347 229 18151 15p 800 off 15p TR-100 Bridge Tap 7kft (100ft)
   {0x0399, 0x0C10, 0x3817, 0xFBEC}, // 16 -4.0782 229 8633 100 off 3p 178 off 14p DTAG_04mm (5000m)
   //{0x0377, 0x201B, 0x0810, 0xFC9B}, // 17 -3.3952 178 5954 267 off 8p 100 off 2p ANSI #1
   {0x02D0, 0x081D, 0x0EFD, 0xFCDE}, // 18 -3.1365 100 929 533 off 2p 533 1347 3p ANSI #2
   {0x0275, 0x001D, 0x0000, 0xF8E7}, // 19 -7.0996 145 305 533 off 0p off off 0p ANSI #8
   {0x0310, 0x0412, 0x001E, 0xFD8F}, // 5  -2.4433 100 1953 114 off 1p 800 off 0p TR-100 Bridge Tap 9kft (200ft)
   {0x0312, 0x3C10, 0x381C, 0xFD3E}, // 6  -2.7586 114 1953 100 off 15p 400 off 14p TR-100 Bridge Tap 11kft (100ft)
   {0x02F2, 0x1C10, 0x301E, 0xFCED}, // 7  -3.0765 114 1347 100 off 7p 800 off 12p TR-100 Bridge Tap 12kft (100ft)
   {0x0293, 0x201D, 0x3F7F, 0xFAC7}, // 8  -5.226 123 442 533 off 8p 1600 4106 15p TR-100 Bridge Tap 12kft (750ft)
   {0x0290, 0x37F6, 0x3F7F, 0xFB91}, // 9  -4.4344 100 442 160 26319 13p 1600 4106 15p TR-100 Bridge Tap 15kft (400ft)
   {0x0275, 0x101D, 0x0000, 0xF8E7}, // 10 -7.0996 145 305 533 off 4p off off 0p TR-100 Bridge Tap 15kft (1000ft)
   {0x02B2, 0x2C1D, 0x02BE, 0xFBE2}, // 11 -4.1192 114 641 533 off 11p 800 641 0p TR-100 Bridge Tap 15kft (1500ft)
   {0x0299, 0x001D, 0x0000, 0xF7D8}, // 12 -8.1573 229 442 533 off 0p off off 0p TR-100 Bridge Tap 17.5kft (800ft)
   {0x0330, 0x1410, 0x2410, 0xFDC4}, // 13 -2.2377 100 2832 100 off 5p 100 off 9p ETSI #1 (2500m)
   {0x03B5, 0x0810, 0x2410, 0xFD55}, // 14 -2.6713 145 12518 100 off 2p 100 off 9p ETSI #2 (5000m)
   {0x02D0, 0x0F92, 0x0410, 0xFCDE}, // 15 -3.1365 100 929 114 8633 3p 100 off 1p DTAG_04mm (1500m)
   //{0x0399, 0x0C10, 0x3817, 0xFBEC}, // 16 -4.0782 229 8633 100 off 3p 178 off 14p DTAG_04mm (5000m)
   //{0x0377, 0x201B, 0x0810, 0xFC9B}, // 17 -3.3952 178 5954 267 off 8p 100 off 2p ANSI #1
   //{0x02D0, 0x081D, 0x0EFD, 0xFCDE}, // 18 -3.1365 100 929 533 off 2p 533 1347 3p ANSI #2
   //{0x0275, 0x001D, 0x0000, 0xF8E7}, // 19 -7.0996 145 305 533 off 0p off off 0p ANSI #8
   {0x0272, 0x2FD0, 0x0000, 0xFB91}, //16 %17.5+BT400
   {0x02B0, 0x1374, 0x257F, 0xF952}, //17 %17.5+BT500
   {0x02B0, 0x3378, 0x0D7F, 0xF868}, //18 %17.5+BT600
   {0x0299, 0x3FDC, 0x0000, 0xF7D8}, //19 %17.5+BT700
   {0x0299, 0x141D, 0x0000, 0xF7D8}, //20 %17.5+BT800
   {0x0275, 0x141D, 0x0000, 0xF868}, //21 %17.5+BT900
   {0x0250, 0x1F7C, 0x05C0, 0xF868}, //22 %17.5+BT1000
   {0x0296, 0x041D, 0x0000, 0xF9A3}, //23 %17.5+BT1250
   {0x02B2, 0x301D, 0x2ABE, 0xFBE2}, //24 %17.5+BT1500
   { 0x0275,   0x141D,   0x0000,    0xF8E7},  //  25    -7.0996   145   305   533   off   5p   off   off   0p  TR-67 Bridge Tap 15kft (1000ft)
   { 0x0296,   0x041D,   0x0000,    0xF9A3},  //  26    -6.3650   160   442   533   off   1p   off   off   0p  TR-67 Bridge Tap 15kft (1250ft)
   { 0x02B2,   0x301D,   0x2ABE,    0xFBE2},  //  27    -4.1192   114   641   533   off  12p   800   641  10p  TR-67 Bridge Tap 15kft (1500ft)
   {0x001C, 0x001C,  0x001C,  0xFA17}, // 28 5.9113   400   off   400   off   0p   400   off   0p  QLN/HLOG XDSLRTFW_3753

};
//XDSLRTFW-3674 New_HybridSettings_changes (start)
#if 0 // complete settings received from frank on 12/18/2017
//  PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain   // Index  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc  Cpc  Description
//     { 0x0312,        0x1810,            0x3C1D,        0xFD3E},  //   1    -2.7586   114  1953   100   off   6p   533   off  15p  TR-067 Bridge Tap 9kft (150ft)
//     { 0x02F1,        0x0410,            0x001E,        0xFD18},  //   2    -2.9064   107  1347   100   off   1p   800   off   0p  TR-067 Bridge Tap 9kft (250ft)
//     { 0x02F1,        0x3411,            0x381E,        0xFD18},  //   3    -2.9064   107  1347   107   off  13p   800   off  14p  TR-067 Bridge Tap 9kft (350ft)
//     { 0x02B0,        0x001C,            0x141E,        0xFC50},  //   4    -3.6894   100   641   400   off   0p   800   off   5p  TR-067 Bridge Tap 9kft (500ft)
//     { 0x0376,        0x3C10,            0x3C1B,        0xFCC5},  //   5    -3.2333   160  4106   100   off  15p   320   off  15p  TR-067 Bridge Tap 12kft (50ft)
//     { 0x02F0,        0x3BB0,            0x3C1C,        0xFD45},  //   6    -2.7329   100  1347   100 12518  14p   400   off  15p  TR-067 Bridge Tap 12kft (150ft)
//     { 0x02F0,        0x0810,            0x001E,        0xFD45},  //   7    -2.7329   100  1347   100   off   2p   800   off   0p  TR-067 Bridge Tap 12kft (250ft)
//     { 0x02D0,        0x03D6,            0x001E,        0xFCDE},  //   8    -3.1365   100   929   160 18151   0p   800   off   0p  TR-067 Bridge Tap 12kft (350ft)
//     { 0x02B0,        0x041B,            0x3FDE,        0xFC50},  //   9    -3.6894   100   641   320   off   1p   800 18151  15p  TR-067 Bridge Tap 12kft (500ft)
//     { 0x0276,        0x17FC,            0x0000,        0xF868},  //  10    -7.5968   160   305   400 26319   5p   off   off   0p  TR-067 Bridge Tap 12kft (750ft)
//     { 0x0275,        0x381D,            0x0000,        0xF8E7},  //  11    -7.0996   145   305   533   off  14p   off   off   0p  TR-067 Bridge Tap 12kft (1000ft)
//     { 0x0272,        0x0C1D,            0x0000,        0xFA08},  //  12    -5.9721   114   305   533   off   3p   off   off   0p  TR-067 Bridge Tap 12kft (1250ft)
//     { 0x02B0,        0x101D,            0x1ABE,        0xFC50},  //  13    -3.6894   100   641   533   off   4p   800   641   6p  TR-067 Bridge Tap 12kft (1500ft)
//     { 0x0333,        0x3C10,            0x3C16,        0xFD49},  //  14    -2.7166   123  2832   100   off  15p   160   off  15p  TR-067 Bridge Tap 15kft (50ft)
//     { 0x0313,        0x3C12,            0x381C,        0xFD0C},  //  15    -2.9554   123  1953   114   off  15p   400   off  14p  TR-067 Bridge Tap 15kft (150ft)
//     { 0x02F1,        0x0010,            0x3BFD,        0xFD18},  //  16    -2.9064   107  1347   100   off   0p   533 26319  14p  TR-067 Bridge Tap 15kft (200ft)
//     { 0x02D0,        0x3FF2,            0x3FFE,        0xFCDE},  //  17    -3.1365   100   929   114 26319  15p   800 26319  15p  TR-067 Bridge Tap 15kft (300ft)
//     { 0x0291,        0x0B31,            0x377F,        0xFB52},  //  18    -4.6830   107   442   107  2832   2p  1600  4106  13p  TR-067 Bridge Tap 15kft (400ft)
//     { 0x02B0,        0x001C,            0x001E,        0xFC50},  //  19    -3.6894   100   641   400   off   0p   800   off   0p  TR-067 Bridge Tap 15kft (500ft)
//     { 0x0298,        0x081B,            0x0000,        0xF88E},  //  20    -7.4485   200   442   267   off   2p   off   off   0p  TR-067 Bridge Tap 15kft (600ft)
//     { 0x0275,        0x381B,            0x0000,        0xF8E7},  //  21    -7.0996   145   305   320   off  14p   off   off   0p  TR-067 Bridge Tap 15kft (700ft)
//     { 0x0251,        0x381C,            0x0000,        0xF903},  //  22    -6.9897   107   210   400   off  14p   off   off   0p  TR-067 Bridge Tap 15kft (800ft)
//     { 0x0276,        0x101D,            0x0000,        0xF868},  //  23    -7.5968   160   305   533   off   4p   off   off   0p  TR-067 Bridge Tap 15kft (900ft)
//     { 0x0250,        0x141D,            0x0000,        0xF957},  //  24    -6.6632   100   210   533   off   5p   off   off   0p  TR-067 Bridge Tap 15kft (1000ft)
//     { 0x0271,        0x001D,            0x0000,        0xFA4E},  //  25    -5.6958   107   305   533   off   0p   off   off   0p  TR-067 Bridge Tap 15kft (1250ft)
//     { 0x02B0,        0x381D,            0x065B,        0xFC50},  //  26    -3.6894   100   641   533   off  14p   267   210   1p  TR-067 Bridge Tap 15kft (1500ft)
//     { 0x0333,        0x0C11,            0x2C14,        0xFD49},  //  27    -2.7166   123  2832   107   off   3p   133   off  11p  TR-067 Bridge Tap 17.5kft (50ft)
//     { 0x0313,        0x37F0,            0x141C,        0xFD0C},  //  28    -2.9554   123  1953   100 26319  13p   400   off   5p  TR-067 Bridge Tap 17.5kft (150ft)
//     { 0x02F2,        0x3BB3,            0x341D,        0xFCED},  //  29    -3.0765   114  1347   123 12518  14p   533   off  13p  TR-067 Bridge Tap 17.5kft (200ft)
//     { 0x02D0,        0x23D1,            0x3FFE,        0xFCDE},  //  30    -3.1365   100   929   107 18151   8p   800 26319  15p  TR-067 Bridge Tap 17.5kft (300ft)
//     { 0x0290,        0x0010,            0x1B3F,        0xFB91},  //  31    -4.4344   100   442   100   off   0p  1600  2832   6p  TR-067 Bridge Tap 17.5kft (400ft)
//     { 0x0250,        0x0331,            0x0000,        0xF957},  //  32    -6.6632   100   210   107  2832   0p   off   off   0p  TR-067 Bridge Tap 17.5kft (500ft)
//     { 0x0250,        0x0B97,            0x0000,        0xF957},  //  33    -6.6632   100   210   178  8633   2p   off   off   0p  TR-067 Bridge Tap 17.5kft (600ft)
//     { 0x0250,        0x301B,            0x0000,        0xF957},  //  34    -6.6632   100   210   320   off  12p   off   off   0p  TR-067 Bridge Tap 17.5kft (700ft)
//     { 0x0251,        0x081C,            0x0000,        0xF903},  //  35    -6.9897   107   210   400   off   2p   off   off   0p  TR-067 Bridge Tap 17.5kft (800ft)
//     { 0x0276,        0x041D,            0x0000,        0xF868},  //  36    -7.5968   160   305   533   off   1p   off   off   0p  TR-067 Bridge Tap 17.5kft (900ft)
//     { 0x0250,        0x341D,            0x0000,        0xF957},  //  37    -6.6632   100   210   533   off  13p   off   off   0p  TR-067 Bridge Tap 17.5kft (1000ft)
//     { 0x0271,        0x3C1D,            0x0000,        0xFA4E},  //  38    -5.6958   107   305   533   off  15p   off   off   0p  TR-067 Bridge Tap 17.5kft (1250ft)
//     { 0x0291,        0x141D,            0x127F,        0xFB52},  //  39    -4.6830   107   442   533   off   5p  1600   305   4p  TR-067 Bridge Tap 17.5kft (1500ft)
#endif

uint16 gusa_A21_HybridSetting_ADSL_A_BTLOOPS[VRX_MAX_NUM_ADAP_HYB_SETTINGS][VRX_HYB_NUM_SETTINGS]=
{
#if 0
   // Hybrid coeeficents received from Frank on 18/12/2017
   //PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain // Idx  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc   Cpc  Description
   {0x0375,       0x0013,           0x0410,        0xFD0A},    //0     -2.9619   145  4106   123  off    0p  100    off    1p  26AWG (16000ft)//
   { 0x0333,        0x0C11,            0x2C14,        0xFD49},    //1/     -2.7166   123  2832   107  off    3p   133   off  11p  TR-067 Bridge Tap 17.5kft(50ft)
   { 0x0313,        0x37F0,            0x141C,        0xFD0C},    //2/     -2.9554   123  1953   100 26319  13p   400   off   5p  TR-067 Bridge Tap 17.5kft (150ft)
   { 0x02F2,        0x3BB3,            0x341D,        0xFCED},    //3/     -3.0765   114  1347   123 12518  14p   533   off  13p  TR-067 Bridge Tap 17.5kft (200ft)
   { 0x02F0,        0x0810,            0x001E,        0xFD45},    //4/     -2.7329   100  1347   100   off   2p   800   off   0p  TR-067 Bridge Tap 12kft (250ft)
   { 0x02D0,        0x23D1,            0x3FFE,        0xFCDE},    //5     -3.1365   100   929   107 18151   8p   800 26319  15p  TR-067 Bridge Tap 17.5kft (300ft)
   { 0x02D0,        0x03D6,            0x001E,        0xFCDE},    //6     -3.1365   100   929   160 18151   0p   800   off   0p  TR-067 Bridge Tap 12kft (350ft)
   { 0x0290,        0x0010,            0x1B3F,        0xFB91},    //7     -4.4344   100   442   100   off   0p  1600  2832   6p  TR-067 Bridge Tap 17.5kft (400ft)
   { 0x02B0,        0x041B,            0x3FDE,        0xFC50},    //8     -3.6894   100   641   320   off   1p   800 18151  15p  TR-067 Bridge Tap 12kft (500ft)
   { 0x0250,        0x0331,            0x0000,        0xF957},    //9     -6.6632   100   210   107  2832   0p   off   off   0p  TR-067 Bridge Tap 17.5kft (500ft)
   { 0x0298,        0x081B,            0x0000,        0xF88E},    //10    -7.4485   200   442   267   off   2p   off   off   0p  TR-067 Bridge Tap 15kft (600ft)
   { 0x0250,        0x0B97,            0x0000,        0xF957},    //11    -6.6632   100   210   178  8633   2p   off   off   0p  TR-067 Bridge Tap 17.5kft (600ft)
   { 0x0275,        0x381B,            0x0000,        0xF8E7},    //12    -7.0996   145   305   320   off  14p   off   off   0p  TR-067 Bridge Tap 15kft (700ft)
   { 0x0250,        0x301B,            0x0000,        0xF957},    //13    -6.6632   100   210   320   off  12p   off   off   0p  TR-067 Bridge Tap 17.5kft (700ft)
   { 0x0276,        0x17FC,            0x0000,        0xF868},    //14    -7.5968   160   305   400 26319   5p   off   off   0p  TR-067 Bridge Tap 12kft (750ft)
   { 0x0251,        0x381C,            0x0000,        0xF903},    //15    -6.9897   107   210   400   off  14p   off   off   0p  TR-067 Bridge Tap 15kft (800ft)
   { 0x0251,        0x081C,            0x0000,        0xF903},    //16    -6.9897   107   210   400   off   2p   off   off   0p  TR-067 Bridge Tap 17.5kft (800ft)
   { 0x0276,        0x101D,            0x0000,        0xF868},    //17    -7.5968   160   305   533   off   4p   off   off   0p  TR-067 Bridge Tap 15kft (900ft)
   { 0x0276,        0x041D,            0x0000,        0xF868},    //18    -7.5968   160   305   533   off   1p   off   off   0p  TR-067 Bridge Tap 17.5kft (900ft)
   { 0x0275,        0x381D,            0x0000,        0xF8E7},    //19    -7.0996   145   305   533   off  14p   off   off   0p  TR-067 Bridge Tap 12kft (1000ft)
   { 0x0250,        0x141D,            0x0000,        0xF957},    //20    -6.6632   100   210   533   off   5p   off   off   0p  TR-067 Bridge Tap 15kft (1000ft)      // x
   { 0x0250,        0x341D,            0x0000,        0xF957},    //21    -6.6632   100   210   533   off  13p   off   off   0p  TR-067 Bridge Tap 17.5kft (1000ft)  //x
   { 0x0272,        0x0C1D,            0x0000,        0xFA08},    //22    -5.9721   114   305   533   off   3p   off   off   0p  TR-067 Bridge Tap 12kft (1250ft)
   { 0x0271,        0x001D,            0x0000,        0xFA4E},    //23    -5.6958   107   305   533   off   0p   off   off   0p  TR-067 Bridge Tap 15kft (1250ft)
   { 0x0271,        0x3C1D,            0x0000,        0xFA4E},    //24    -5.6958   107   305   533   off  15p   off   off   0p  TR-067 Bridge Tap 17.5kft (1250ft)
   { 0x02B0,        0x101D,            0x1ABE,        0xFC50},    //25    -3.6894   100   641   533   off   4p   800   641   6p  TR-067 Bridge Tap 12kft (1500ft)
   { 0x02B0,        0x381D,            0x065B,        0xFC50},    //26    -3.6894   100   641   533   off  14p   267   210   1p  TR-067 Bridge Tap 15kft (1500ft)
   { 0x0291,        0x141D,            0x127F,        0xFB52},    //27    -4.6830   107   442   533   off   5p  1600   305   4p  TR-067 Bridge Tap 17.5kft (1500ft)

 // Hybrid coeeficents received from Lorenzo 22/01/18
 //PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain // Idx  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc   Cpc  Description
 {0x0375,       0x0013,        0x0410,        0xFD0A},    //0     -2.9619   145  4106   123  off    0p  100    off     1p  26AWG (16000ft)//
 { 0x0333,        0x0C11,            0x2C14,        0xFD49},    //1/     -2.7166   123  2832   107  off    3p   133   off  11p  TR-067 Bridge Tap 17.5kft(50ft)
 { 0x02F1,        0x3015,            0x279C,        0xFD0C},    //2/     12000m using a BT of length 150m
 { 0x02F2,        0x3BB3,            0x341D,        0xFCED},    //3/     -3.0765   114  1347   123 12518  14p   533   off  13p  TR-067 Bridge Tap 17.5kft (200ft)
 { 0x02F0,        0x2C11,            0x281E,        0xFD45},    //4/    12000m using a BT of length 250m
 { 0x02D0,        0x3B12,            0x3D9E,        0xFCDE},    //5     15000m using a BT of length 300m
 { 0x02D3,        0x3BDA,            0x3FBE,        0xFCDE},    //6     12000m using a BT of length 350m
 { 0x0274,        0x0F99,            0x427F,        0xFB91},    //7    15000m using a BT of length 400m
 { 0x0272,        0x3C14,            0x0E20,        0xFC50},    //8     12000m using a BT of length 500m
 { 0x0273,        0x0816,            0x1A00,        0xF957},    //9     15000m using a BT of length 500m
 { 0x02B0,        0x1310,            0x39DF,        0xF88E},    //10   17500m using a BT of length 400m
 { 0x0250,        0x0B97,            0x0000,        0xF957},    //11    -6.6632   100   210   178  8633   2p   off   off   0p  TR-067 Bridge Tap 17.5kft (600ft)
 { 0x0275,        0x381B,            0x0000,        0xF8E7},    //12    -7.0996   145   305   320   off  14p   off   off   0p  TR-067 Bridge Tap 15kft (700ft)
 { 0x0250,        0x301B,            0x0000,        0xF957},    //13    -6.6632   100   210   320   off  12p   off   off   0p  TR-067 Bridge Tap 17.5kft (700ft)
 { 0x0276,        0x17FC,            0x0000,        0xF868},    //14    -7.5968   160   305   400 26319   5p   off   off   0p  TR-067 Bridge Tap 12kft (750ft)
 { 0x0275,        0x241C,            0x0E00,        0xF903},    //15   15000m using a BT of length 800m
 { 0x0251,        0x081C,            0x0000,        0xF903},    //16    -6.9897   107   210   400   off   2p   off   off   0p  TR-067 Bridge Tap 17.5kft (800ft)
 { 0x0276,        0x101D,            0x0000,        0xF868},    //17    -7.5968   160   305   533   off   4p   off   off   0p  TR-067 Bridge Tap 15kft (900ft)
 { 0x0276,        0x041D,            0x0000,        0xF868},    //18    -7.5968   160   305   533   off   1p   off   off   0p  TR-067 Bridge Tap 17.5kft (900ft)
 { 0x0274,        0x07FD,            0x061F,        0xF8E7},    //19    12000m using a BT of length 1000m
 { 0x0271,        0x041D,            0x3A3E,        0xF957},    //20    15000m using a BT of length 1000m
 { 0x02D3,        0x2356,            0x39BF,        0xF957},    //21  17500m using a BT of length 500m
 { 0x03D1,        0x27FC,            0x05FF,        0xFA08},    //22  12000m using a BT of length 1250m
 { 0x0274,        0x1C1B,            0x0220,        0xFA4E},    //23  15000m using a BT of length 1250m
 { 0x0290,        0x341B,            0x223F,        0xFA4E},    //24    17500m using a BT of length 1250m
 { 0x02D2,        0x0C1D,            0x2A5A,        0xFC50},    //25    12000m using a BT of length 1500m
 { 0x02B0,        0x27DC,            0x425A,        0xFC50},    //26   15000m using a BT of length 1500m
 { 0x02B3,        0x2FFC,            0x327E,        0xFB52},    //27   17500m using a BT of length 1500m

 // hybrid coefs received on 29/01/2018 for 12kft BT
 // hybrid coefs received on 29/01/2018 for 12kft BT
//{ 0x02D0,        0x1FB9,            0x31BF,        0xFD45},    //16  12000 +BT 500
//{ 0x0310,        0x2BF1,            0x19FF,        0xFCDE},    //17  12000 +BT 500:
//{ 0x02D0,        0x0B9B,            0x09DF,        0xFCDE},    //18  12000 +BT 750
//{ 0x02F1,        0x3399,            0x059F,        0xFC50},    //19  12000 +BT 750
//{ 0x02F1,        0x2BDC,            0x2DDF,        0xFC50},   //20 12000 +BT 1000
//{ 0x0372,        0x1FD9,            0x15FF,        0xF957},    //21  12000 +BT 1250
//{ 0x02B0,        0x275D,            0x419F,        0xF8E7},    //22  12000 +BT 1250
//{ 0x0371,        0x241D,            0x379D,        0xF957},    //23  12000 +BT 1500
//{ 0x03D0,        0x0C1D,            0x97FE,        0xFA08},    //24  12000 +BT 1500
//{ 0x0274,        0x07FD,            0x061F,        0xF8E7},   //25  (10)  12000m using a BT of length 1000m
//{ 0x02D3,        0x2356,            0x39BF,        0xF957},    //26  (10)17500m using a BT of length 500m
//{ 0x02F0,        0x2C11,            0x281E,        0xFD45},    //27  (6) 12000m using a BT of length 250m
#else

    // Hybrid coeeficents received from Lorenzo on 25/12/2017  + original table, table experimentally derived by
    // chosing the coefs selected for each BT cases
    //PGA0(RPA,RSA)  PGA1(CPB,RPB,RSB)  PGA2(CPC,RPC,RSC)  HybGain // Idx  HybGain   Rsa   Rpa   Rsb   Rpb  Cpb   Rsc   Rpc   Cpc  Description
    // The below are hybrid coefs from Frank's table (see above)
    {0x0375,     0x0013,       0x0410,        0xFD0A},             //0     -2.9619   145  4106   123  off    0p  100    off   1p  26AWG (16000ft)//
    { 0x0333,        0x0C11,            0x2C14,        0xFD49},    //1/ (9)    -2.7166   123  2832   107  off    3p   133   off  11p  TR-067 Bridge Tap 17.5kft(50ft)
    { 0x02F2,        0x3BB3,            0x341D,        0xFCED},    //2/ (10)    -3.0765   114  1347   123 12518  14p   533   off  13p  TR-067 Bridge Tap 17.5kft (200ft)
    //{ 0x02F0,        0x0810,            0x001E,        0xFD45},    //3/ (7)   -2.7329   100  1347   100   off   2p   800   off   0p  TR-067 Bridge Tap 12kft (250ft)
    { 0x02D0,        0x23D1,            0x3FFE,        0xFCDE},    //3/  (3)   -3.1365   100   929   107 18151   8p   800 26319  15p  TR-067 Bridge Tap 17.5kft (300ft)
    { 0x02D0,        0x03D6,            0x001E,        0xFCDE},    //4/  (3)  -3.1365   100   929   160 18151   0p   800   off   0p  TR-067 Bridge Tap 12kft (350ft)
    { 0x0290,        0x0010,            0x1B3F,        0xFB91},    //5  (5)  -4.4344   100   442   100   off   0p  1600  2832   6p  TR-067 Bridge Tap 17.5kft (400ft)
    { 0x02B0,        0x041B,            0x3FDE,        0xFC50},    //6  (3)  -3.6894   100   641   320   off   1p   800 18151  15p  TR-067 Bridge Tap 12kft (500ft)
    { 0x0298,        0x081B,            0x0000,        0xF88E},    //7  (14)  -7.4485   200   442   267   off   2p   off   off   0p  TR-067 Bridge Tap 15kft (600ft)
    { 0x0276,        0x101D,            0x0000,        0xF868},    //8  (4)  -7.5968   160   305   533   off   4p   off   off   0p  TR-067 Bridge Tap 15kft (900ft)
    { 0x0276,        0x041D,            0x0000,        0xF868},    //9 (5)   -7.5968   160   305   533   off   1p   off   off   0p  TR-067 Bridge Tap 17.5kft (900ft)
    { 0x0275,        0x381D,            0x0000,        0xF8E7},    //10 (4)   -7.0996   145   305   533   off  14p   off   off   0p  TR-067 Bridge Tap 12kft (1000ft)
    { 0x0272,        0x0C1D,            0x0000,        0xFA08},    //11 (7)  -5.9721   114   305   533   off   3p   off   off   0p  TR-067 Bridge Tap 12kft (1250ft)
    { 0x02D0,        0x3378,            0x257F,        0xF88E},    //12    15kft+BT400:  PGA0 = 2D0; PGA1 = 3378; PGA2 = 257F;
    { 0x02B0,        0x101D,            0x1ABE,        0xFC50},    //13 (15)   -3.6894   100   641   533   off   4p   800   641   6p  TR-067 Bridge Tap 12kft (1500ft)
    { 0x02B0,        0x381D,            0x065B,        0xFC50},    //14 (3)  -3.6894   100   641   533   off  14p   267   210   1p  TR-067 Bridge Tap 15kft (1500ft)
    // The below are hybrid coefs from Lorenzo mnual tune table (see above)
  { 0x03F1,        0x301D,            0x13BD,        0xFD45},    //15  17500ft BT of length 1500 //added on Mar14,2018
  { 0x02F0,        0x2C11,            0x281E,        0xFD45},    //16  (6) 12000ft using a BT of length 250ft
  { 0x02D0,        0x3B12,            0x3D9E,        0xFCDE},    //17  (3)   15000ft using a BT of length 300ft
  { 0x02D3,        0x3BDA,            0x3FBE,        0xFCDE},    //18  (3)   12000ft using a BT of length 350ft
  { 0x0272,        0x3C14,            0x0E20,        0xFC50},    //19  (5)   12000ft using a BT of length 500ft
  { 0x0273,        0x0816,            0x1A00,        0xF957},    //20  (2)  15000ft using a BT of length 500ft
  { 0x0274,        0x07FD,            0x061F,        0xF8E7},    //21  (10)  12000ft using a BT of length 1000ft
  { 0x02D3,        0x2356,            0x39BF,        0xF957},    //22  (10)17500ft using a BT of length 500ft
  { 0x03D1,        0x27FC,            0x05FF,        0xFA08},    //23  (3)12000ft using a BT of length 1250ft
  { 0x0274,        0x1C1B,            0x0220,        0xFA4E},    //24  (6)15000ft using a BT of length 1250ft
  { 0x02B0,        0x337B,            0x0220,        0x05BF},   //25 17.5+BT600 PGA0 = 2B0; PGA1 = 337B; PGA2 = 5BF;
  { 0x02F1,        0x13D1,            0x21FF,        0x05BF},   //26 12kft+BT350  PGA0 = 2F1; PGA1 = 13D1; PGA2 = 21FF;
  { 0x02D1,        0x3FB6,            0x15DF,        0xF88E},    //27 15kft+BT400:   PGA0 = 2D1; PGA1 = 3FB6; PGA2 = 15DF;   or  PGA0 = 2D0; PGA1 = 3378; PGA2 = 257F;
   {0x001C, 0x001C,  0x001C,  0xFA17}, // 28 5.9113   400   off   400   off   0p   400   off   0p  QLN/HLOG XDSLRTFW_3753

#endif
};
//XDSLRTFW-3674 New_HybridSettings_changes (end)
#endif //#ifdef ISDN
uint16 gus_AFeReg_PGA0,gus_AFeReg_PGA1, gus_AFeReg_PGA2;



DATA_MAP_END


